/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable;

import devplugin.Channel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import util.browserlauncher.Launch;
import util.ui.ChannelContextMenu;
import util.ui.ChannelLabel;
import util.ui.ImageUtilities;
import util.ui.ToolTipWithIcon;
import util.ui.UiUtilities;
import util.ui.persona.Persona;

public class ProgramTableChannelLabel
extends ChannelLabel {
    private static Cursor linkCursor = new Cursor(12);
    private static Font channelNameFont;
    private Channel mChannel;
    private boolean mIsRollover;

    public ProgramTableChannelLabel(Channel ch, KeyListener keyListener) {
        super(Settings.IconAndNames.SHOW_ICONS_IN_PROGRAM_TABLE.getBoolean(), Settings.IconAndNames.SHOW_NAMES_IN_PROGRAM_TABLE.getBoolean(), false, false, true, false, Settings.IconAndNames.SHOW_SORT_NUMBER_IN_PROGRAM_TABLE.getBoolean());
        this.mChannel = ch;
        this.addKeyListener(keyListener);
        this.updatePersona();
        this.setChannel(this.mChannel);
        this.setToolTipText("");
        if (channelNameFont == null) {
            ProgramTableChannelLabel.fontChanged();
        }
        if (channelNameFont != null) {
            this.setFont(channelNameFont);
        }
        this.mIsRollover = false;
        this.setOpaque(false);
        this.setHorizontalAlignment(0);
        this.setCursor(linkCursor);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ProgramTableChannelLabel.this.showPopUp(e);
                } else if (e.getButton() == 1) {
                    Launch.openURL(ProgramTableChannelLabel.this.mChannel.getWebpage());
                }
                super.mouseReleased(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ProgramTableChannelLabel.this.showPopUp(e);
                }
                super.mouseReleased(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ProgramTableChannelLabel.this.mIsRollover = true;
                int r = ProgramTableChannelLabel.this.getForeground().getRed() + ProgramTableChannelLabel.this.getBackground().getRed() >> 1;
                int g = ProgramTableChannelLabel.this.getForeground().getGreen() + ProgramTableChannelLabel.this.getBackground().getGreen() >> 1;
                int b = ProgramTableChannelLabel.this.getForeground().getBlue() + ProgramTableChannelLabel.this.getBackground().getBlue() >> 1;
                e.getComponent().setForeground(new Color(r, g, b));
                if (Settings.ProgramTable.HIGHLIGHT_CHANNEL_COLUMN_BY_MOUSE.getBoolean()) {
                    MainFrame.getInstance().getProgramTableScrollPane().highlightChannel(ProgramTableChannelLabel.this.mChannel);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ProgramTableChannelLabel.this.mIsRollover = false;
                e.getComponent().setForeground(UIManager.getColor("List.selectionForeground"));
                if (Settings.ProgramTable.HIGHLIGHT_CHANNEL_COLUMN_BY_MOUSE.getBoolean()) {
                    MainFrame.getInstance().getProgramTableScrollPane().unHighlightChannel(ProgramTableChannelLabel.this.mChannel);
                }
            }
        });
    }

    private void showPopUp(MouseEvent e) {
        new ChannelContextMenu(e, this.mChannel, this);
    }

    public static void fontChanged() {
        boolean useDefaults = Settings.Fonts.USE_DEFAULT.getBoolean();
        channelNameFont = useDefaults ? Settings.Fonts.CHANNEL_NAME.getDefault() : Settings.Fonts.CHANNEL_NAME.getFont();
    }

    @Override
    public JToolTip createToolTip() {
        Icon shownIcon;
        Icon channelIcon;
        if (!Settings.IconAndNames.SHOW_CHANNEL_TOOLTIP_IN_PROGRAM_TABLE.getBoolean()) {
            return new ToolTipWithIcon(null, null);
        }
        boolean showIcon = false;
        boolean showText = false;
        Icon icon = channelIcon = this.mChannel.getJointChannel() != null ? ImageUtilities.createImageIcon(this.mChannel.getJointChannelIcon(), Color.WHITE, 4) : this.mChannel.getIcon();
        if (channelIcon != null && channelIcon instanceof ImageIcon && (shownIcon = this.getIcon()) != null && (channelIcon.getIconHeight() > shownIcon.getIconHeight() || channelIcon.getIconWidth() > shownIcon.getIconWidth())) {
            showIcon = true;
        }
        ToolTipWithIcon tip = showIcon ? new ToolTipWithIcon((ImageIcon)channelIcon) : new ToolTipWithIcon((ImageIcon)null);
        tip.setBackground(Color.WHITE);
        tip.setComponent(this);
        String text = null;
        if (showText) {
            text = this.mChannel.getName();
        }
        tip.setTipText(text);
        return tip;
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int stringWidth = SwingUtilities.computeStringWidth(metrics, this.getText());
        int x = 0;
        Icon icon = this.mChannel.getJointChannel() != null ? this.mChannel.getJointChannelIcon() : this.getIcon();
        Icon channelIcon = this.mChannel.getJointChannel() != null ? this.mChannel.getJointChannelIcon() : this.mChannel.getIcon();
        int iconWidth = icon.getIconWidth();
        if (channelIcon != null) {
            iconWidth = channelIcon.getIconWidth();
        }
        int iconHeight = icon.getIconHeight();
        if (channelIcon != null) {
            iconHeight = channelIcon.getIconHeight();
        }
        if (icon != null) {
            x = (this.getWidth() - stringWidth - this.getIconTextGap() - icon.getIconWidth()) / 2;
            if (x < 0) {
                x = 0;
            }
            x += (icon.getIconWidth() - iconWidth) / 2;
        }
        int y = (this.getHeight() - iconHeight - 2) / 2;
        return new Point(x, y);
    }

    public void updatePersona() {
        if (Persona.getInstance().getHeaderImage() != null && Persona.getInstance().getTextColor() != null) {
            this.setForeground(Persona.getInstance().getTextColor());
        } else {
            this.setForeground(UIManager.getColor("List.selectionForeground"));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.mChannel.isUsingUserBackgroundColor() || Persona.getInstance().getHeaderImage() != null && Persona.getInstance().getTextColor() != null && Persona.getInstance().getShadowColor() != null) {
            try {
                Color test;
                Color textColor;
                Color c;
                Color color = c = this.mChannel.isUsingUserBackgroundColor() ? this.mChannel.getUserBackgroundColor() : Persona.getInstance().getAccentColor();
                if (!this.mChannel.isUsingUserBackgroundColor()) {
                    c = Persona.testPersonaForegroundAgainst(c);
                }
                Color color2 = textColor = this.mChannel.isUsingUserBackgroundColor() ? this.getForeground() : Persona.getInstance().getTextColor();
                if (this.mIsRollover && UiUtilities.isBrightnessSimilarForColors(test = UIManager.getColor("List.selectionBackground"), textColor, 84)) {
                    textColor = UIManager.getColor("List.selectionForeground");
                }
                g.setColor(c);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                int iconX = this.getWidth() / 2;
                int iconY = this.getHeight() / 2;
                int iconWidth = 0;
                int iconTextGap = 0;
                FontMetrics metrics = g.getFontMetrics(this.getFont());
                Object text = this.getText();
                int textWidth = metrics.stringWidth((String)text);
                int baseLine = this.getHeight() / 2 + metrics.getMaxDescent() + 1;
                Icon icon = this.getIcon();
                int iconTextLength = iconWidth + this.getIconTextGap() + textWidth;
                if (icon != null) {
                    iconWidth = icon.getIconWidth();
                    iconTextGap = this.getIconTextGap();
                    iconTextLength += iconWidth;
                }
                while ((double)iconTextLength > this.getSize().getWidth()) {
                    text = ((String)text).substring(0, ((String)text).length() - 4) + "...";
                    iconTextLength = metrics.stringWidth((String)text) + iconWidth + this.getIconTextGap();
                }
                if (icon != null) {
                    icon.paintIcon(this, g, iconX -= iconTextLength / 2, iconY -= icon.getIconHeight() / 2);
                } else {
                    iconX -= textWidth / 2;
                }
                if (!this.mChannel.isUsingUserBackgroundColor() && !Persona.getInstance().getShadowColor().equals(textColor) && Persona.getInstance().getTextColor().equals(textColor)) {
                    g.setColor(Persona.getInstance().getShadowColor());
                    g.drawString((String)text, iconX + iconWidth + iconTextGap + 1, baseLine + 1);
                }
                g.setColor(textColor);
                g.drawString((String)text, iconX + iconWidth + iconTextGap, baseLine);
            }
            catch (Throwable t) {
                t.printStackTrace();
                super.paintComponent(g);
            }
        } else {
            super.paintComponent(g);
        }
    }
}

