/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.GridFlowLayout;
import util.ui.TimeFormatter;
import util.ui.persona.Persona;

public class TimeChooserPanel
extends JPanel
implements ChangeListener,
MouseListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(TimeChooserPanel.class);
    private MainFrame mParent;
    private JPanel mGridPn;
    private KeyListener mKeyListener;
    private JButton mNowBt;

    public TimeChooserPanel(MainFrame parent, KeyListener keyListener) {
        this.addKeyListener(keyListener);
        this.mParent = parent;
        this.setLayout(new BorderLayout(0, 2));
        this.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
        this.mGridPn = new JPanel(new GridFlowLayout(5, 5, 1, 0, 0));
        this.updatePersona();
        this.mGridPn.addKeyListener(keyListener);
        this.mGridPn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TimeChooserPanel.this.mGridPn.requestFocus();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TimeChooserPanel.this.requestFocus();
            }
        });
        this.add((Component)this.mGridPn, "Center");
        this.mKeyListener = keyListener;
        String msg = mLocalizer.msg("button.now", "Now");
        this.mNowBt = Persona.createPersonaButton(msg);
        this.mNowBt.addKeyListener(keyListener);
        this.mNowBt.addActionListener(e -> this.mParent.scrollToNow());
        this.add((Component)this.mNowBt, "South");
        this.mNowBt.addMouseListener(this);
        this.createContent();
        this.addMouseListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.createContent();
    }

    public void updateButtons() {
        this.createContent();
        this.mGridPn.updateUI();
    }

    private void createContent() {
        try {
            int[] times;
            this.mGridPn.removeAll();
            TimeFormatter formatter = new TimeFormatter();
            for (int time : times = Settings.Buttons.TIME_BUTTONS.getIntArray()) {
                int h = time / 60;
                int m = time % 60;
                JButton btn = Persona.createPersonaButton(formatter.formatTime(h, m));
                btn.addKeyListener(this.mKeyListener);
                this.mGridPn.add(btn);
                btn.addActionListener(e -> this.mParent.scrollToTime(time, true));
                btn.addMouseListener(this);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void showPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem configure = new JMenuItem(mLocalizer.msg("configure", "Configure"));
        configure.addActionListener(evt -> MainFrame.getInstance().showSettingsDialog("#timebuttons"));
        menu.add(configure);
        int x = e.getX();
        int y = e.getY();
        if (e.getSource() != this) {
            x += ((JButton)e.getSource()).getX();
            y += ((JButton)e.getSource()).getY();
        }
        menu.show(this, x, y);
    }

    public void updatePersona() {
        if (Persona.getInstance().getHeaderImage() != null) {
            this.setOpaque(false);
            this.mGridPn.setOpaque(false);
            if (this.mNowBt != null) {
                this.mNowBt.setBorder(Persona.getPersonaButtonBorder());
                this.mNowBt.setRolloverEnabled(true);
                this.updateButtons();
            }
        } else {
            this.setOpaque(true);
            this.mGridPn.setOpaque(true);
            if (this.mNowBt != null) {
                this.mNowBt.setRolloverEnabled(UIManager.getBoolean("Button.rollover"));
                this.mNowBt.setBorder(UIManager.getBorder("Button.border"));
                this.updateButtons();
            }
        }
    }
}

