/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.searchplugin;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tvbrowser.extras.searchplugin.SearchPlugin;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.SearchFormSettings;
import util.ui.TVBrowserIcons;

class SearchSettingsTab
implements SettingsTab {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(SearchSettingsTab.class);
    private JCheckBox mAlwaysExpertMode;
    private JList<SearchFormSettings> mSearchHistory;

    SearchSettingsTab() {
    }

    @Override
    public JPanel createSettingsPanel() {
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("5dlu,5dlu,default,default,0dlu:grow"));
        pb.border(Borders.DIALOG);
        this.mAlwaysExpertMode = new JCheckBox(LOCALIZER.msg("alwaysExpert", "Use expert mode for repetition search also"), SearchPlugin.getAlwaysSearchExpert());
        SearchFormSettings[] history = SearchPlugin.getSearchHistory();
        DefaultListModel<SearchFormSettings> mListModel = new DefaultListModel<SearchFormSettings>();
        if (history != null) {
            for (SearchFormSettings hist : history) {
                mListModel.addElement(hist);
            }
        }
        this.mSearchHistory = new JList(mListModel);
        JButton delete = new JButton(TVBrowserIcons.delete(16));
        delete.setToolTipText(Localizer.getLocalization("i18n_delete"));
        delete.setEnabled(false);
        delete.addActionListener(e -> {
            int[] indicies = this.mSearchHistory.getSelectedIndices();
            for (int i = indicies.length - 1; i >= 0; --i) {
                mListModel.removeElementAt(indicies[i]);
            }
        });
        pb.addSeparatorRowFull(false, LOCALIZER.msg("title", "Search"));
        pb.addRowFull(this.mAlwaysExpertMode, 2);
        pb.addParagraph(LOCALIZER.msg("history", "Search history entries"));
        pb.addRowFull("fill:20dlu:grow", (Component)new JScrollPane(this.mSearchHistory), 3);
        pb.addRow("2dlu,default", (Component)delete, 3);
        this.mSearchHistory.addListSelectionListener(e -> delete.setEnabled(this.mSearchHistory.getSelectedIndices().length != 0));
        return pb.getPanel();
    }

    @Override
    public void saveSettings() {
        SearchPlugin.setAlwaysSearchExpert(this.mAlwaysExpertMode.isSelected());
        ArrayList<SearchFormSettings> listHistory = new ArrayList<SearchFormSettings>();
        for (int i = 0; i < this.mSearchHistory.getModel().getSize(); ++i) {
            listHistory.add(this.mSearchHistory.getModel().getElementAt(i));
        }
        SearchPlugin.setSearchHistory(listHistory.toArray(new SearchFormSettings[listHistory.size()]));
    }

    @Override
    public Icon getIcon() {
        return TVBrowserIcons.search(16);
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Search");
    }
}

