/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.dlgs;

import com.jgoodies.forms.factories.Borders;
import devplugin.Channel;
import devplugin.PluginCommunication;
import devplugin.Program;
import devplugin.ProgramFilter;
import devplugin.ProgressMonitorExtended;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tvbrowser.core.ChannelList;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.filters.filtercomponents.ProgramInfoFilterComponent;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.AdvancedFavorite;
import tvbrowser.extras.favoritesplugin.core.Exclusion;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.core.FilterFavorite;
import tvbrowser.extras.favoritesplugin.core.TitleFavorite;
import tvbrowser.extras.favoritesplugin.core.TopicFavorite;
import tvbrowser.extras.favoritesplugin.dlgs.EditFavoriteDialog;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteNode;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteNodeComparator;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteNodeCountComparator;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTree;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;
import tvbrowser.extras.favoritesplugin.dlgs.ManageFavoritesDialog;
import tvbrowser.extras.favoritesplugin.wizards.TypeWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.WizardHandler;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.ui.mainframe.MainFrame;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.program.ProgramUtilities;
import util.settings.PluginPictureSettings;
import util.settings.ProgramPanelSettings;
import util.ui.DragAndDropMouseListener;
import util.ui.ExtensionFileFilter;
import util.ui.FilterableProgramListPanel;
import util.ui.ListDragAndDropHandler;
import util.ui.ListDropAction;
import util.ui.ProgramList;
import util.ui.SendToPluginDialog;
import util.ui.TVBrowserIcons;
import util.ui.TabListenerPanel;
import util.ui.UiUtilities;
import util.ui.persona.Persona;
import util.ui.persona.PersonaListener;

public class ManageFavoritesPanel
extends TabListenerPanel
implements ListDropAction<Favorite>,
TreeSelectionListener,
PersonaListener {
    public static final int FILTER_START_LAST_TYPE = -1;
    private static final int MAX_SHOWN_PROGRAMS = 6000;
    private static final Localizer LOCALIZER = ManageFavoritesDialog.LOCALIZER;
    private DefaultListModel<Favorite> mFavoritesListModel;
    private JList<Favorite> mFavoritesList;
    private FavoriteTree mFavoriteTree;
    private ProgramList mProgramList;
    private JSplitPane mSplitPane;
    private JButton mNewBt;
    private JButton mEditBt;
    private JButton mDeleteBt;
    private JButton mUpBt;
    private JButton mDownBt;
    private JButton mSortAlphaBt;
    private JButton mSortCountBt;
    private JButton mImportBt;
    private JButton mSendBt;
    private JButton mUpdateBt;
    private JButton mImportApp;
    private JButton mCloseBt;
    private boolean mShowNew = false;
    private JCheckBox mBlackListChb;
    private Thread mSplitDividerThread;
    private long mLastDividerChange;
    private FilterableProgramListPanel mProgramListPanel;
    private JButton mScrollToPreviousDay;
    private JButton mScrollToNextDay;
    private JButton mScrollToFirstNotExpired;
    private static final int DAY_RESTRICTION_TYPE = 0;
    private static final int CHANNEL_RESTRICTION_TYPE = 1;
    private static final int ATTRIBUTE_RESTRICTION_TYPE = 2;

    public ManageFavoritesPanel(Favorite[] favoriteArr, int splitPanePosition, boolean showNew, Favorite initialSelection, boolean border, boolean isMainPanel) {
        this.init(favoriteArr, splitPanePosition, showNew, initialSelection, border, isMainPanel);
    }

    private void init(Favorite[] favoriteArr, int splitPanePosition, boolean showNew, Favorite initialSelection, boolean border, boolean isMainPanel) {
        try {
            JScrollPane scrollPane;
            ImageIcon icon;
            String msg;
            this.mShowNew = showNew;
            this.mLastDividerChange = System.currentTimeMillis();
            this.setLayout(new BorderLayout(5, 5));
            if (border) {
                this.setBorder(Borders.DLU4);
            }
            this.setOpaque(false);
            JToolBar toolbarPn = new JToolBar(){

                @Override
                protected void paintComponent(Graphics g) {
                    if (!UiUtilities.isGTKLookAndFeel() || Persona.getInstance().getHeaderImage() == null) {
                        super.paintComponent(g);
                    }
                }
            };
            toolbarPn.setFloatable(false);
            toolbarPn.setOpaque(false);
            toolbarPn.setBorder(BorderFactory.createEmptyBorder());
            if (this.mShowNew) {
                JEditorPane info = UiUtilities.createHtmlHelpTextArea(FavoritesPlugin.LOCALIZER.msg("newPrograms.description", "After updating TV listings, programs matching your favorites were found.\nSelect a favorite to view the new programs."));
                JPanel northPanel = new JPanel(new BorderLayout(0, 5));
                northPanel.add((Component)info, "North");
                northPanel.add((Component)toolbarPn, "South");
                this.add((Component)northPanel, "North");
            } else {
                this.add((Component)toolbarPn, "North");
            }
            if (!this.mShowNew) {
                if (favoriteArr == null) {
                    JButton newFolder = UiUtilities.createToolBarButton(LOCALIZER.msg("newFolder", "New folder"), IconLoader.getInstance().getIconFromTheme("actions", "folder-new", 22));
                    newFolder.setOpaque(false);
                    newFolder.addActionListener(e -> {
                        TreePath path = this.mFavoriteTree.getSelectionPath();
                        if (path != null) {
                            FavoritesPlugin.getInstance().newFolder((FavoriteNode)path.getLastPathComponent());
                        } else {
                            FavoritesPlugin.getInstance().newFolder(this.mFavoriteTree.getRoot());
                        }
                    });
                    toolbarPn.add(newFolder);
                }
                this.addToolbarSeperator(toolbarPn);
                msg = LOCALIZER.ellipsisMsg("new", "Create a new favorite");
                icon = TVBrowserIcons.newIcon(22);
                this.mNewBt = UiUtilities.createToolBarButton(msg, icon);
                this.mNewBt.setOpaque(false);
                this.mNewBt.addActionListener(e -> {
                    TreePath path = this.mFavoriteTree.getSelectionPath();
                    if (path == null) {
                        this.newFavorite(this.mFavoriteTree.getRoot());
                    } else {
                        FavoriteNode node = (FavoriteNode)path.getLastPathComponent();
                        this.newFavorite(node.isDirectoryNode() ? node : (FavoriteNode)node.getParent());
                    }
                });
                toolbarPn.add(this.mNewBt);
            }
            msg = LOCALIZER.ellipsisMsg("edit", "Edit the selected favorite");
            icon = TVBrowserIcons.edit(22);
            this.mEditBt = UiUtilities.createToolBarButton(msg, icon);
            this.mEditBt.setOpaque(false);
            this.mEditBt.addActionListener(e -> {
                if (this.mShowNew) {
                    this.editSelectedFavorite();
                } else {
                    FavoriteNode node = (FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent();
                    if (node.isDirectoryNode()) {
                        this.mFavoriteTree.renameFolder(node);
                    } else {
                        this.editSelectedFavorite();
                    }
                }
            });
            toolbarPn.add(this.mEditBt);
            msg = LOCALIZER.ellipsisMsg("delete", "Delete selected favorite");
            icon = TVBrowserIcons.delete(22);
            this.mDeleteBt = UiUtilities.createToolBarButton(msg, icon);
            this.mDeleteBt.setOpaque(false);
            this.mDeleteBt.addActionListener(e -> {
                if (this.mShowNew) {
                    this.deleteSelectedFavorite();
                } else {
                    FavoriteNode node = (FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent();
                    if (node.isDirectoryNode()) {
                        this.mFavoriteTree.delete(node);
                        FavoritesPlugin.getInstance().updateRootNode(true);
                    } else {
                        this.deleteSelectedFavorite();
                    }
                }
            });
            toolbarPn.add(this.mDeleteBt);
            msg = LOCALIZER.ellipsisMsg("update", "Search for all Favorites again");
            icon = TVBrowserIcons.update(22);
            this.mUpdateBt = UiUtilities.createToolBarButton(msg, icon);
            this.mUpdateBt.setOpaque(false);
            this.mUpdateBt.addActionListener(e -> {
                ProgressMonitorExtended m = PluginManagerImpl.getInstance().createProgressMonitor();
                m.setValue(0);
                Favorite[] favs = this.mFavoriteTree.getModel().getFavoriteArr();
                m.setMaximum(favs.length);
                m.setMessage(LOCALIZER.ellipsisMsg("update", "Search for all Favorites again"));
                m.setVisible(true);
                for (int i = 0; i < favs.length; ++i) {
                    m.setValue(i);
                    if (favs[i] == null) continue;
                    try {
                        favs[i].updatePrograms();
                        continue;
                    }
                    catch (TvBrowserException tvBrowserException) {
                        // empty catch block
                    }
                }
                FavoritesPlugin.getInstance().saveFavorites();
                m.setMessage("");
                m.setVisible(false);
            });
            if (!this.mShowNew) {
                toolbarPn.add(this.mUpdateBt);
            }
            msg = LOCALIZER.msg("up", "Move the selected favorite up");
            icon = TVBrowserIcons.up(22);
            this.mUpBt = UiUtilities.createToolBarButton(msg, icon);
            this.mUpBt.setOpaque(false);
            this.mUpBt.addActionListener(e -> this.mFavoriteTree.moveSelectedFavorite(-1));
            if (!this.mShowNew) {
                this.addToolbarSeperator(toolbarPn);
                toolbarPn.add(this.mUpBt);
            }
            msg = LOCALIZER.msg("down", "Move the selected favorite down");
            icon = TVBrowserIcons.down(22);
            this.mDownBt = UiUtilities.createToolBarButton(msg, icon);
            this.mDownBt.setOpaque(false);
            this.mDownBt.addActionListener(e -> this.mFavoriteTree.moveSelectedFavorite(1));
            if (!this.mShowNew) {
                toolbarPn.add(this.mDownBt);
            }
            msg = LOCALIZER.msg("sort", "Sort favorites alphabetically");
            icon = FavoritesPlugin.getIconFromTheme("actions", "sort-list", 22);
            String titleAlpha = msg;
            this.mSortAlphaBt = UiUtilities.createToolBarButton(msg, icon);
            this.mSortAlphaBt.setOpaque(false);
            this.mSortAlphaBt.addActionListener(e -> this.sortFavorites(FavoriteNodeComparator.getInstance(), titleAlpha));
            msg = LOCALIZER.msg("sortCount", "Sort favorites by number of programs");
            icon = FavoritesPlugin.getIconFromTheme("actions", "sort-list-numerical", 22);
            String titleCount = msg;
            this.mSortCountBt = UiUtilities.createToolBarButton(msg, icon);
            this.mSortCountBt.setOpaque(false);
            this.mSortCountBt.addActionListener(e -> this.sortFavorites(FavoriteNodeCountComparator.getInstance(), titleCount));
            if (!this.mShowNew) {
                toolbarPn.add(this.mSortAlphaBt);
                toolbarPn.add(this.mSortCountBt);
            }
            msg = LOCALIZER.msg("send", "Send Programs to another Plugin");
            icon = TVBrowserIcons.copy(22);
            this.mSendBt = UiUtilities.createToolBarButton(msg, icon);
            this.mSendBt.setOpaque(false);
            this.mSendBt.addActionListener(e -> this.showSendDialog());
            this.addToolbarSeperator(toolbarPn);
            toolbarPn.add(this.mSendBt);
            msg = LOCALIZER.msg("import", "Import favorites from TVgenial");
            icon = FavoritesPlugin.getIconFromTheme("actions", "document-open", 22);
            this.mImportBt = UiUtilities.createToolBarButton(msg, icon);
            this.mImportBt.setOpaque(false);
            this.mImportBt.addActionListener(e -> this.importFavorites());
            msg = LOCALIZER.msg("androidSync.import", "Import favorites with AndroidSync");
            icon = FavoritesPlugin.getIconFromTheme("actions", "document-open", 22);
            this.mImportApp = UiUtilities.createToolBarButton(msg, icon);
            this.mImportApp.setOpaque(false);
            this.mImportApp.addActionListener(e -> this.importFavoritesAndroid());
            this.updateAndroidSyncImportButton();
            if (!this.mShowNew) {
                toolbarPn.add(this.mImportBt);
                toolbarPn.add(this.mImportApp);
            }
            msg = LOCALIZER.msg("settings", "Open settings");
            icon = TVBrowserIcons.preferences(22);
            if (ManageFavoritesDialog.getInstance() != null) {
                JButton settings = UiUtilities.createToolBarButton(msg, icon);
                settings.addActionListener(e -> {
                    if (ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible()) {
                        ManageFavoritesDialog.getInstance().close();
                    }
                    MainFrame.getInstance().showSettingsDialog("#favorite");
                });
                this.addToolbarSeperator(toolbarPn);
                toolbarPn.add(settings);
            }
            toolbarPn.add(Box.createGlue());
            this.mScrollToFirstNotExpired = UiUtilities.createToolBarButton(LOCALIZER.msg("scrollToFirstNotExpired", "Scroll to first not expired program."), TVBrowserIcons.scrollToNow(22));
            this.mScrollToFirstNotExpired.setOpaque(false);
            toolbarPn.add(this.mScrollToFirstNotExpired);
            this.mScrollToFirstNotExpired.addActionListener(e -> this.scrollToFirstNotExpiredIndex(false));
            toolbarPn.add(Box.createRigidArea(new Dimension(15, 0)));
            this.mScrollToPreviousDay = UiUtilities.createToolBarButton(ProgramList.getPreviousActionTooltip(), TVBrowserIcons.left(22));
            this.mScrollToPreviousDay.setOpaque(false);
            toolbarPn.add(this.mScrollToPreviousDay);
            this.mScrollToPreviousDay.addActionListener(e -> this.mProgramList.scrollToPreviousDayIfAvailable());
            this.mScrollToNextDay = UiUtilities.createToolBarButton(ProgramList.getNextActionTooltip(), TVBrowserIcons.right(22));
            this.mScrollToNextDay.setOpaque(false);
            toolbarPn.add(this.mScrollToNextDay);
            this.mScrollToNextDay.addActionListener(e -> this.mProgramList.scrollToNextDayIfAvailable());
            this.mSplitPane = new JSplitPane();
            for (int i = 0; i < this.mSplitPane.getComponentCount(); ++i) {
                this.mSplitPane.getComponent(i).setBackground(new Color(0, 0, 0, 0));
            }
            this.mSplitPane.setBorder(BorderFactory.createEmptyBorder());
            this.mSplitPane.setDividerLocation(splitPanePosition);
            this.mSplitPane.setContinuousLayout(true);
            this.mSplitPane.setOpaque(false);
            if (isMainPanel) {
                this.mSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                    @Override
                    public synchronized void propertyChange(PropertyChangeEvent evt) {
                        ManageFavoritesPanel.this.mLastDividerChange = System.currentTimeMillis();
                        if (ManageFavoritesPanel.this.mSplitDividerThread == null || !ManageFavoritesPanel.this.mSplitDividerThread.isAlive()) {
                            ManageFavoritesPanel.this.mSplitDividerThread = new Thread("FAVORITE SPLIT DIVIDER THREAD"){

                                @Override
                                public void run() {
                                    while (System.currentTimeMillis() - ManageFavoritesPanel.this.mLastDividerChange < 500L) {
                                        try {
                                            1.sleep(500L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    FavoritesPlugin.getInstance().store();
                                }
                            };
                            ManageFavoritesPanel.this.mSplitDividerThread.start();
                        }
                    }
                });
            }
            this.add((Component)this.mSplitPane, "Center");
            if (favoriteArr != null) {
                this.mFavoritesListModel = new DefaultListModel();
                this.mFavoritesListModel.ensureCapacity(favoriteArr.length);
                for (Favorite element : favoriteArr) {
                    if (element.getNewPrograms().length < 0) continue;
                    this.mFavoritesListModel.addElement(element);
                }
                this.mFavoritesList = new JList<Favorite>(this.mFavoritesListModel);
                this.mFavoritesList.setCellRenderer(new FavoriteListCellRenderer());
                ListSelectionModel selModel = this.mFavoritesList.getSelectionModel();
                selModel.setSelectionMode(0);
                selModel.addListSelectionListener(evt -> {
                    if (!evt.getValueIsAdjusting()) {
                        this.favoriteSelectionChanged(true);
                    }
                });
                if (!this.mShowNew) {
                    ListDragAndDropHandler dnDHandler = new ListDragAndDropHandler(this.mFavoritesList, this.mFavoritesList, this);
                    new DragAndDropMouseListener<Favorite>(this.mFavoritesList, this.mFavoritesList, this, dnDHandler);
                }
                this.mFavoritesList.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            ManageFavoritesPanel.this.showFavoritesPopUp(e.getX(), e.getY());
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            ManageFavoritesPanel.this.showFavoritesPopUp(e.getX(), e.getY());
                        }
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                            ManageFavoritesPanel.this.editSelectedFavorite();
                        }
                    }
                });
                this.mFavoritesList.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 39 && e.isControlDown()) {
                            ManageFavoritesPanel.this.mProgramList.grabFocus();
                            if (ManageFavoritesPanel.this.mProgramList.getSelectedIndex() == -1) {
                                ManageFavoritesPanel.this.mProgramList.setSelectedIndex(0);
                            }
                        }
                    }
                });
                scrollPane = new JScrollPane(this.mFavoritesList);
            } else {
                this.mFavoriteTree = new FavoriteTree();
                this.mFavoriteTree.addTreeSelectionListener(this);
                this.mFavoriteTree.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 39 && e.isControlDown()) {
                            ManageFavoritesPanel.this.mProgramList.grabFocus();
                            if (ManageFavoritesPanel.this.mProgramList.getSelectedIndex() == -1) {
                                ManageFavoritesPanel.this.mProgramList.setSelectedIndex(0);
                            }
                        }
                    }
                });
                scrollPane = new JScrollPane(this.mFavoriteTree);
                this.mFavoritesList = null;
            }
            scrollPane.setBorder(null);
            scrollPane.setMinimumSize(new Dimension(200, 100));
            this.mSplitPane.setLeftComponent(scrollPane);
            this.mProgramListPanel = FavoritesPlugin.getInstance().getFilterStartType() == -1 ? new FilterableProgramListPanel(true, new Program[0], true, FavoritesPlugin.getInstance().showDateSeparators(), new ProgramPanelSettings(new PluginPictureSettings(0), false, 0), FavoritesPlugin.getInstance().getLastSelectedProgramFilter()) : new FilterableProgramListPanel(0, new Program[0], true, FavoritesPlugin.getInstance().showDateSeparators(), new ProgramPanelSettings(new PluginPictureSettings(0), false, 0), FavoritesPlugin.getInstance().getFilterStartType());
            this.mProgramListPanel.setBorder(Borders.DLU2);
            this.mProgramList = this.mProgramListPanel.getProgramList();
            this.setDefaultFocusOwner(this.mProgramList);
            this.mProgramList.addMouseAndKeyListeners(null);
            this.mProgramList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 37 && e.isControlDown()) {
                        if (ManageFavoritesPanel.this.mFavoritesList != null) {
                            ManageFavoritesPanel.this.mFavoritesList.grabFocus();
                            if (ManageFavoritesPanel.this.mFavoritesList.getSelectedIndex() == -1) {
                                ManageFavoritesPanel.this.mFavoritesList.setSelectedIndex(0);
                            }
                        } else if (ManageFavoritesPanel.this.mFavoriteTree != null) {
                            ManageFavoritesPanel.this.mFavoriteTree.grabFocus();
                            if (ManageFavoritesPanel.this.mFavoriteTree.getSelectionCount() == 0) {
                                ManageFavoritesPanel.this.mFavoriteTree.setSelectionRow(0);
                            }
                        }
                    }
                }
            });
            this.mSplitPane.setRightComponent(this.mProgramListPanel);
            msg = LOCALIZER.msg("showBlack", "Show single removed programs");
            this.mBlackListChb = new JCheckBox(msg);
            this.mBlackListChb.setOpaque(false);
            this.mBlackListChb.setSelected(FavoritesPlugin.getInstance().isShowingBlackListEntries());
            this.mBlackListChb.setOpaque(false);
            this.mBlackListChb.addActionListener(e -> {
                FavoritesPlugin.getInstance().setIsShowingBlackListEntries(this.mBlackListChb.isSelected());
                this.favoriteSelectionChanged();
            });
            JPanel buttonPn = new JPanel(new BorderLayout());
            buttonPn.setOpaque(false);
            if (!this.mShowNew) {
                buttonPn.add((Component)this.mBlackListChb, "West");
            }
            this.add((Component)buttonPn, "South");
            this.mCloseBt = new JButton(Localizer.getLocalization("i18n_close"));
            if (ManageFavoritesDialog.getInstance() != null) {
                this.mCloseBt.addActionListener(e -> {
                    if (ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible()) {
                        ManageFavoritesDialog.getInstance().close();
                    }
                });
                buttonPn.add((Component)this.mCloseBt, "East");
                ManageFavoritesDialog.getInstance().getRootPane().setDefaultButton(this.mCloseBt);
            }
            if (this.mFavoriteTree != null) {
                FavoriteNode initialNode = this.mFavoriteTree.getRoot();
                if (initialSelection != null) {
                    initialNode = this.mFavoriteTree.findFavorite(initialSelection);
                }
                TreePath treePath = new TreePath(initialNode.getPath());
                this.mFavoriteTree.setSelectionPath(treePath);
                this.mFavoriteTree.scrollPathToVisible(treePath);
            }
            this.favoriteSelectionChanged(true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void addToolbarSeperator(JToolBar toolbarPn) {
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setSize(10, 10);
        p.setMaximumSize(new Dimension(10, 10));
        toolbarPn.add(p);
        toolbarPn.addSeparator();
        p = new JPanel();
        p.setOpaque(false);
        p.setSize(4, 10);
        p.setMaximumSize(new Dimension(4, 10));
        toolbarPn.add(p);
    }

    protected void showFavoritesPopUp(int x, int y) {
        JPopupMenu menu = new JPopupMenu();
        this.mFavoritesList.setSelectedIndex(this.mFavoritesList.locationToIndex(new Point(x, y)));
        if (!this.mShowNew) {
            JMenuItem createNew = new JMenuItem(LOCALIZER.ellipsisMsg("new", "Create a new favorite"), TVBrowserIcons.newIcon(16));
            createNew.addActionListener(e -> this.newFavorite(this.mFavoriteTree.getRoot()));
            menu.add(createNew);
            menu.addSeparator();
        }
        JMenuItem edit = new JMenuItem(LOCALIZER.ellipsisMsg("edit", "Edit the selected favorite"), TVBrowserIcons.edit(16));
        edit.addActionListener(e -> this.editSelectedFavorite());
        menu.add(edit);
        JMenuItem delete = new JMenuItem(LOCALIZER.ellipsisMsg("delete", "Delete selected favorite"), TVBrowserIcons.delete(16));
        delete.addActionListener(e -> this.deleteSelectedFavorite());
        menu.add(delete);
        menu.addSeparator();
        JMenuItem sendPrograms = new JMenuItem(LOCALIZER.msg("send", "Send Programs to another Plugin"), TVBrowserIcons.copy(16));
        sendPrograms.addActionListener(e -> this.showSendDialog());
        sendPrograms.setEnabled(this.mProgramList.getModel().getSize() > 0);
        menu.add(sendPrograms);
        menu.show(this.mFavoritesList, x, y);
    }

    public int getSplitpanePosition() {
        return this.mSplitPane.getDividerLocation();
    }

    public void setSplitpanePosition(int val) {
        this.mSplitPane.setDividerLocation(val);
    }

    public synchronized void favoriteSelectionChanged(boolean scrollToFirst) {
        if (this.mFavoritesList != null) {
            int selection = this.mFavoritesList.getSelectedIndex();
            int size = this.mFavoritesListModel.getSize();
            this.mEditBt.setEnabled(selection != -1);
            this.mDeleteBt.setEnabled(selection != -1);
            this.mEditBt.setToolTipText(LOCALIZER.ellipsisMsg("edit", "Edit the selected favorite"));
            this.mDeleteBt.setToolTipText(LOCALIZER.ellipsisMsg("delete", "Delete selected favorite"));
            this.mUpBt.setEnabled(selection > 0);
            this.mDownBt.setEnabled(selection != -1 && selection < size - 1);
            this.mSortAlphaBt.setEnabled(size >= 2);
            this.mSortCountBt.setEnabled(this.mSortAlphaBt.isEnabled());
            if (selection == -1) {
                this.mProgramListPanel.clearPrograms();
                this.mSendBt.setEnabled(false);
            } else {
                this.changeProgramList(this.mFavoritesList.getSelectedValue(), scrollToFirst);
            }
            Rectangle rect = this.mFavoritesList.getCellBounds(selection, selection);
            if (rect != null) {
                this.mFavoritesList.paintImmediately(rect);
            }
        } else if (this.mFavoriteTree != null && this.mFavoriteTree.getSelectionPath() != null) {
            Favorite fav = ((FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent()).getFavorite();
            if (fav != null) {
                this.enableButtons(true);
                this.changeProgramList(fav, scrollToFirst);
                this.mDeleteBt.setEnabled(true);
                this.mEditBt.setToolTipText(LOCALIZER.ellipsisMsg("edit", "Edit the selected favorite"));
                this.mDeleteBt.setToolTipText(LOCALIZER.ellipsisMsg("delete", "Delete selected favorite"));
            } else {
                Program[] p = ((FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent()).getAllPrograms(false);
                int firstNotExpiredIndex = -1;
                if (p != null && p.length > 0) {
                    this.enableButtons(true);
                    Arrays.sort(p, ProgramUtilities.getProgramComparator());
                    int maxSize = Math.min(p.length, 6000);
                    ArrayList<Program> programs = new ArrayList<Program>(maxSize);
                    Hashtable test = new Hashtable();
                    for (int i = 0; i < p.length && programs.size() < 6000; ++i) {
                        ArrayList<Program> testList = (ArrayList<Program>)test.get(p[i].getChannel());
                        if (testList == null) {
                            testList = new ArrayList<Program>();
                            test.put(p[i].getChannel(), testList);
                        }
                        if (testList.contains(p[i])) continue;
                        testList.add(p[i]);
                        programs.add(p[i]);
                        if (firstNotExpiredIndex != -1 || p[i].isExpired()) continue;
                        firstNotExpiredIndex = programs.size() - 1;
                    }
                    this.mProgramListPanel.setPrograms(programs.toArray(new Program[programs.size()]));
                    if (scrollToFirst) {
                        this.scrollInProgramListToIndex(firstNotExpiredIndex);
                    }
                    this.mSendBt.setEnabled(true);
                    this.mScrollToPreviousDay.setEnabled(true);
                    this.mScrollToNextDay.setEnabled(true);
                    this.mDeleteBt.setEnabled(false);
                } else {
                    this.mProgramListPanel.clearPrograms();
                    FavoriteNode node = (FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent();
                    this.enableButtons(node.isDirectoryNode());
                    this.mDeleteBt.setEnabled(node.isDirectoryNode() && node.getChildCount() < 1);
                    this.mSendBt.setEnabled(false);
                    this.mScrollToPreviousDay.setEnabled(false);
                    this.mScrollToNextDay.setEnabled(false);
                }
                this.mEditBt.setToolTipText(LOCALIZER.ellipsisMsg("renameFolder", "Rename selected folder"));
                this.mDeleteBt.setToolTipText(LOCALIZER.msg("deleteFolder", "Delete selected folder"));
            }
        } else if (this.mProgramListPanel != null) {
            this.mProgramListPanel.clearPrograms();
            this.mDeleteBt.setEnabled(false);
            this.mSendBt.setEnabled(false);
            this.enableButtons(false);
        }
    }

    public void scrollToFirstNotExpiredIndex(boolean check) {
        this.mProgramListPanel.scrollToFirstNotExpiredIndex(check);
    }

    public void scrollInProgramListToIndex(int index) {
        this.mProgramListPanel.scrollToIndex(index);
    }

    private void enableButtons(boolean enabled) {
        TreePath path = this.mFavoriteTree.getSelectionPath();
        this.mEditBt.setEnabled(enabled && path != null && !path.getLastPathComponent().equals(this.mFavoriteTree.getRoot()));
        this.mUpBt.setEnabled((enabled || path != null && ((FavoriteNode)path.getLastPathComponent()).isDirectoryNode()) && !path.getLastPathComponent().equals(this.mFavoriteTree.getRoot()) && this.mFavoriteTree.getRowForPath(this.mFavoriteTree.getSelectionPath()) > 0);
        this.mDownBt.setEnabled((enabled || path != null && ((FavoriteNode)path.getLastPathComponent()).isDirectoryNode()) && !path.getLastPathComponent().equals(this.mFavoriteTree.getRoot()) && this.mFavoriteTree.getRowForPath(this.mFavoriteTree.getSelectionPath()) < this.mFavoriteTree.getRowCount() - 1);
        if (path != null && !((FavoriteNode)path.getLastPathComponent()).isDirectoryNode() && path.getParentPath().getLastPathComponent().equals(this.mFavoriteTree.getRoot())) {
            path = path.getParentPath();
        }
        this.mSortAlphaBt.setEnabled(path == null || enabled && (path != null && ((FavoriteNode)path.getLastPathComponent()).isDirectoryNode() && ((FavoriteNode)path.getLastPathComponent()).getChildCount() > 1 || path.getLastPathComponent().equals(this.mFavoriteTree.getRoot())));
        this.mSortCountBt.setEnabled(this.mSortAlphaBt.isEnabled());
    }

    private void changeProgramList(Favorite fav, boolean scrollToFirstIndex) {
        Program[] programArr = this.mShowNew ? fav.getNewPrograms() : fav.getWhiteListPrograms();
        Program[] blackListPrograms = fav.getBlackListPrograms();
        Program[] programs = programArr;
        if (!this.mShowNew && this.mBlackListChb.isSelected()) {
            programs = new Program[programArr.length + blackListPrograms.length];
            System.arraycopy(programArr, 0, programs, 0, programArr.length);
            System.arraycopy(blackListPrograms, 0, programs, programArr.length, blackListPrograms.length);
        }
        this.mProgramListPanel.setPrograms(programs);
        this.mSendBt.setEnabled(this.mProgramList.getModel().getSize() > 0);
        this.mScrollToPreviousDay.setEnabled(this.mSendBt.isEnabled());
        this.mScrollToNextDay.setEnabled(this.mSendBt.isEnabled());
        if (scrollToFirstIndex) {
            this.scrollToFirstNotExpiredIndex(false);
        }
    }

    public void showSendDialog() {
        Favorite fav;
        int selection;
        if (this.mFavoritesList != null ? (selection = this.mFavoritesList.getSelectedIndex()) == -1 : this.mFavoriteTree.getSelectionPath() == null) {
            return;
        }
        Program[] programs = this.mProgramList.getSelectedPrograms();
        if (this.mFavoritesList != null) {
            fav = this.mFavoritesListModel.get(this.mFavoritesList.getSelectedIndex());
        } else if (programs == null) {
            programs = ((FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent()).getAllPrograms(true);
            if (programs.length < 1) {
                programs = ((FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent()).getAllPrograms(false);
            }
            fav = null;
        } else {
            fav = null;
        }
        if (fav != null && (programs == null || programs.length == 0)) {
            programs = this.mShowNew ? fav.getNewPrograms() : fav.getWhiteListPrograms();
        }
        SendToPluginDialog send = new SendToPluginDialog(null, ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible() ? ManageFavoritesDialog.getInstance() : MainFrame.getInstance(), programs);
        send.setVisible(true);
    }

    public void newFavorite(FavoriteNode parent) {
        Favorite favorite;
        if (FavoritesPlugin.getInstance().isUsingExpertMode()) {
            favorite = FavoritesPlugin.getInstance().showTypeSelection() && JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), FavoritesPlugin.LOCALIZER.msg("askType.message", "Create a filter favorite?"), FavoritesPlugin.LOCALIZER.msg("askType.title", "Type selection"), 0, 3) == 0 ? new FilterFavorite() : new AdvancedFavorite("");
            EditFavoriteDialog dlg = new EditFavoriteDialog(ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible() ? ManageFavoritesDialog.getInstance() : MainFrame.getInstance(), favorite);
            UiUtilities.centerAndShow(dlg);
            if (!dlg.getOkWasPressed()) {
                favorite = null;
            }
        } else {
            WizardHandler handler = new WizardHandler(ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible() ? ManageFavoritesDialog.getInstance() : MainFrame.getInstance(), new TypeWizardStep(null, parent));
            favorite = (Favorite)handler.show();
        }
        this.addFavorite(favorite, !(favorite instanceof AdvancedFavorite), parent);
    }

    public void addFavorite(Favorite fav, boolean update, FavoriteNode parent) {
        DefaultMutableTreeNode newNode = null;
        if (fav != null) {
            try {
                if (update) {
                    fav.updatePrograms();
                }
                if (this.mFavoritesList != null) {
                    this.mFavoritesListModel.addElement(fav);
                    int idx = this.mFavoritesListModel.size() - 1;
                    this.mFavoritesList.setSelectedIndex(idx);
                    this.mFavoritesList.ensureIndexIsVisible(idx);
                }
                newNode = FavoriteTreeModel.getInstance().addFavorite(fav, parent);
            }
            catch (TvBrowserException e) {
                ErrorHandler.handle("Creating favorites failed.", e);
            }
        }
        if (newNode != null) {
            if (parent != null) {
                this.mFavoriteTree.reload(parent);
            }
            TreePath path = new TreePath(newNode.getPath());
            this.mFavoriteTree.scrollPathToVisible(path);
            this.mFavoriteTree.setSelectionPath(path);
            this.favoriteSelectionChanged();
        }
    }

    public void addFavorite(Favorite fav, Object dummy) {
        if (this.mFavoritesListModel != null) {
            this.mFavoritesListModel.addElement(fav);
        }
    }

    public void reload() {
        this.reload(false);
    }

    public void reload(boolean keepPath) {
        if (this.mFavoriteTree != null) {
            TreePath path = this.mFavoriteTree.getSelectionPath();
            this.mFavoriteTree.reload(this.mFavoriteTree.getRoot());
            if (path != null && keepPath) {
                this.mFavoriteTree.setSelectionPath(path);
            }
        }
    }

    public int getSelectedProgramIndex() {
        return this.mProgramList.getSelectedIndex();
    }

    public void editSelectedFavorite() {
        Favorite fav = null;
        FavoriteNode node = null;
        int index = this.mProgramList.getSelectedIndex();
        if (this.mFavoritesList != null) {
            fav = this.mFavoritesList.getSelectedValue();
            index = this.mFavoritesList.getSelectedIndex();
        } else if (this.mFavoriteTree.getSelectionCount() > 0) {
            node = (FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent();
            fav = node.getFavorite();
        }
        if (fav != null) {
            EditFavoriteDialog dlg = new EditFavoriteDialog(ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible() ? ManageFavoritesDialog.getInstance() : MainFrame.getInstance(), fav);
            UiUtilities.centerAndShow(dlg);
            if (dlg.getOkWasPressed()) {
                if (this.mFavoritesList != null) {
                    this.mFavoritesList.repaint();
                }
                FavoritesPlugin.getInstance().updateRootNode(true);
            }
            if (node != null) {
                this.mFavoriteTree.reload(node);
                this.mFavoriteTree.repaint();
            }
            this.scrollInProgramListToIndex(index);
        }
    }

    public void deleteSelectedFavorite() {
        int selection = -1;
        if (this.mFavoritesList != null) {
            selection = this.mFavoritesList.getSelectedIndex();
        } else if (this.mFavoriteTree.getSelectionPath() != null && ((FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent()).containsFavorite()) {
            selection = 0;
        }
        if (selection != -1) {
            Favorite fav;
            FavoriteNode parent = null;
            if (this.mFavoritesList != null) {
                fav = this.mFavoritesListModel.get(selection);
                this.mFavoritesListModel.remove(selection);
            } else {
                FavoriteNode node = (FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent();
                fav = node.getFavorite();
                parent = (FavoriteNode)node.getParent();
            }
            if (JOptionPane.showConfirmDialog(this, FavoritesPlugin.LOCALIZER.msg("reallyDelete", "Really delete favorite '{0}'?", fav.getName()), LOCALIZER.msg("delete", "Delete selected favorite..."), 0) == 0) {
                FavoriteTreeModel.getInstance().deleteFavorite(fav);
                if (parent != null) {
                    this.mFavoriteTree.setSelectionPath(new TreePath(parent.getPath()));
                    this.mFavoriteTree.reload(parent);
                }
                this.favoriteSelectionChanged();
            }
        }
    }

    protected void sortFavorites(Comparator<TreeNode> comp, String title) {
        TreePath path = this.mFavoriteTree.getSelectionPath();
        if (path != null && !((FavoriteNode)path.getLastPathComponent()).isDirectoryNode() && path.getParentPath().getLastPathComponent().equals(this.mFavoriteTree.getRoot())) {
            path = path.getParentPath();
        }
        if (path == null) {
            path = new TreePath(this.mFavoriteTree.getRoot());
        }
        if (((FavoriteNode)path.getLastPathComponent()).isDirectoryNode()) {
            FavoriteTreeModel.getInstance().sort((FavoriteNode)path.getLastPathComponent(), comp, title);
            this.mFavoriteTree.reload((FavoriteNode)path.getLastPathComponent());
            FavoritesPlugin.getInstance().store();
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void importFavoritesAndroid() {
        block81: {
            PluginProxy androidSync = PluginProxyManager.getInstance().getActivatedPluginForId("java.androidsync.AndroidSync");
            PluginCommunication c = androidSync.getCommunicationClass();
            if (c != null && c.getVersion() >= 2) {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                cal.set(2021, 12, 24);
                Calendar my = Calendar.getInstance(TimeZone.getDefault());
                boolean KEYWORD_ONLY_TITLE_TYPE = false;
                boolean KEYWORD_TYPE = true;
                int RESTRICTION_RULES_TYPE = 2;
                try {
                    Method getFavorites = c.getClass().getDeclaredMethod("getFavorites", new Class[0]);
                    getFavorites.setAccessible(true);
                    Object result = getFavorites.invoke((Object)c, new Object[0]);
                    if (result == null) {
                        UiUtilities.showMessageDialogOnMouseScreen(LOCALIZER.msg("androidSync.noData", "AndroidSync has not provided the needed data.\nMake sure the Favorites were uploaded in the Android app,\nyou're connected to the Internet and try again later."), Localizer.getLocalization("i18n_error"), 0);
                        break block81;
                    }
                    if (!(result instanceof String[])) break block81;
                    String[] favorites = (String[])result;
                    if (favorites.length == 0) {
                        UiUtilities.showMessageDialogOnMouseScreen(LOCALIZER.msg("androidSync.noFavorites", "AndroidSync has found no Favorites.\nMake sure the Favorites were uploaded in the Android app\nand check if the correct credentials were entered in the\nAndroidSync plugin."), Localizer.getLocalization("i18n_info"), 1);
                        break block81;
                    }
                    JCheckBox expert = new JCheckBox(LOCALIZER.msg("androidSync.importAsExpert", "Import all as expert Favorites"));
                    JRadioButton add = new JRadioButton(LOCALIZER.msg("androidSync.duplicates.msg.add", "Add imported Favorite"), true);
                    JRadioButton replace = new JRadioButton(LOCALIZER.msg("androidSync.duplicates.msg.replace", "Replace existing with imported Favorite"));
                    JRadioButton ignore = new JRadioButton(LOCALIZER.msg("androidSync.duplicates.msg.ignore", "Ignore Favorite to import"));
                    JRadioButton ask = new JRadioButton(LOCALIZER.msg("androidSync.duplicates.msg.ask", "Separately ask for each existing Favorite"));
                    ButtonGroup bg = new ButtonGroup();
                    bg.add(add);
                    bg.add(replace);
                    bg.add(ignore);
                    bg.add(ask);
                    Object[] message = new Object[]{LOCALIZER.msg("androidSync.duplicates.msg.global", "How to handle existing imported Favorites?\n\n"), add, replace, ignore, ask, " ", expert};
                    if (UiUtilities.showConfirmDialogOnMouseScreen(message, LOCALIZER.msg("androidSync.duplicates.title", "How to handle duplicate Favorites?"), 2, 3) != 0) break block81;
                    ImportInfo importInfo = new ImportInfo(add.isSelected(), replace.isSelected(), ask.isSelected());
                    FavoriteNode folderAdded = null;
                    HashMap<String, ArrayList<Object>> existingFavorites = new HashMap<String, ArrayList<Object>>();
                    if (!importInfo.mAdd) {
                        Favorite[] favs = this.mFavoriteTree.getModel().getFavoriteArr();
                        for (Object fav : favs) {
                            ArrayList<Object> list = (ArrayList<Object>)existingFavorites.get(((Favorite)fav).getName());
                            if (list == null) {
                                list = new ArrayList<Object>();
                                existingFavorites.put(((Favorite)fav).getName(), list);
                            }
                            list.add(fav);
                        }
                    }
                    int count = 0;
                    for (Object fav : favorites) {
                        Object temp;
                        Object object;
                        String[] parts;
                        ArrayList list;
                        String[] values = ((String)fav).split(";;");
                        String name = null;
                        String search = null;
                        int type = 0;
                        boolean remind = false;
                        ArrayList excludedChannels = null;
                        int timeRestrictionStart = -1;
                        int timeRestrictionEnd = -1;
                        int[] restrictedDays = null;
                        String[] exculdedKeywords = null;
                        int shorterThan = -1;
                        int longerThan = -1;
                        int categories = 0;
                        if (values.length <= 2) continue;
                        name = values[0];
                        search = values[1];
                        try {
                            type = Integer.parseInt(values[2]);
                        }
                        catch (NumberFormatException e) {
                            boolean onlyTitle = Boolean.valueOf(values[2]);
                            type = onlyTitle ? 0 : 1;
                        }
                        if (type == 2) {
                            search = ".*";
                        }
                        ArrayList<Favorite> duplicates = new ArrayList<Favorite>();
                        if (!importInfo.mAdd && (list = (ArrayList)existingFavorites.get(name)) != null) {
                            for (Favorite entry : list) {
                                if (!entry.getSearchText().equals(search)) continue;
                                duplicates.add(entry);
                            }
                        }
                        ImportInfo importInfoTemp = null;
                        if (!duplicates.isEmpty() && importInfo.mAsk) {
                            add.setSelected(true);
                            message = new Object[]{LOCALIZER.msg("androidSync.duplicates.msg.single", "Duplicate Favorites found: '{0}'\nWhat should be done with found Favorite?\n\n", name), add, replace, ignore};
                            importInfoTemp = UiUtilities.showConfirmDialogOnMouseScreen(message, LOCALIZER.msg("androidSync.duplicates.title", "How to handle duplicate Favorites?"), 2, 3) == 0 ? new ImportInfo(add.isSelected(), replace.isSelected(), false) : new ImportInfo(false, false, false);
                        } else {
                            importInfoTemp = importInfo;
                        }
                        if (!duplicates.isEmpty() && !importInfoTemp.mReplace && !importInfoTemp.mAdd) continue;
                        if (values.length > 3) {
                            remind = Boolean.valueOf(values[3]);
                        }
                        if (values.length > 4) {
                            Object exclCh;
                            Object dayRestriction;
                            if (!values[4].equals("null")) {
                                parts = values[4].split(",");
                                try {
                                    timeRestrictionStart = Integer.parseInt(parts[1]) + 1;
                                    timeRestrictionEnd = Integer.parseInt(parts[0]) - 1;
                                    if (timeRestrictionStart >= 1440) {
                                        timeRestrictionStart -= 1440;
                                    }
                                    if (timeRestrictionEnd < 0) {
                                        timeRestrictionEnd += 1440;
                                    }
                                    cal.set(11, timeRestrictionStart / 60);
                                    cal.set(12, timeRestrictionStart % 60);
                                    my.setTimeInMillis(cal.getTimeInMillis());
                                    timeRestrictionStart = my.get(11) * 60 + my.get(12);
                                    cal.set(11, timeRestrictionEnd / 60);
                                    cal.set(12, timeRestrictionEnd % 60);
                                    my.setTimeInMillis(cal.getTimeInMillis());
                                    timeRestrictionEnd = my.get(11) * 60 + my.get(12);
                                }
                                catch (NumberFormatException nfe) {
                                    timeRestrictionStart = -1;
                                    timeRestrictionEnd = -1;
                                }
                            }
                            if ((dayRestriction = this.parseArray(0, values[5])) != null && dayRestriction instanceof int[]) {
                                int[] temp2 = (int[])dayRestriction;
                                String[] days = new ArrayList<Integer>();
                                days.add(2);
                                days.add(3);
                                days.add(4);
                                days.add(5);
                                days.add(6);
                                days.add(7);
                                days.add(1);
                                object = temp2;
                                int n = ((int[])object).length;
                                for (int i = 0; i < n; ++i) {
                                    Object test = object[i];
                                    days.remove((Object)((int)test));
                                }
                                if (!days.isEmpty()) {
                                    restrictedDays = new int[days.size()];
                                    for (int i = 0; i < days.size(); ++i) {
                                        restrictedDays[i] = (Integer)days.get(i);
                                    }
                                }
                            }
                            if ((exclCh = this.parseArray(1, values[6])) != null && exclCh instanceof ArrayList) {
                                excludedChannels = (ArrayList)exclCh;
                            }
                        }
                        if (values.length > 7 && !values[7].equals("null")) {
                            exculdedKeywords = values[7].contains(",") ? values[7].split(",") : new String[]{values[7]};
                        }
                        if (values.length > 8 && !values[8].equals("null")) {
                            parts = values[8].split(",");
                            try {
                                longerThan = Integer.parseInt(parts[0]);
                                shorterThan = Integer.parseInt(parts[1]);
                                if (longerThan != -1) {
                                    --longerThan;
                                }
                                if (shorterThan != -1) {
                                    ++shorterThan;
                                }
                            }
                            catch (NumberFormatException nfe) {
                                shorterThan = -1;
                                longerThan = -1;
                            }
                        }
                        if (values.length > 9 && (temp = this.parseArray(2, values[9])) != null && temp instanceof int[]) {
                            int[] cats = (int[])temp;
                            for (String cat : (String[])cats) {
                                categories |= 1 << cat + true;
                            }
                        }
                        Favorite toAdd = null;
                        if (type == 0) {
                            toAdd = expert.isSelected() ? new AdvancedFavorite(search, 1, 2, false) : new TitleFavorite(search);
                        } else if (type == 1) {
                            toAdd = expert.isSelected() ? new AdvancedFavorite(search, 2, 2, false) : new TopicFavorite(search);
                        } else if (type == 2) {
                            toAdd = new AdvancedFavorite(".*", 1, 3, false);
                        }
                        if (toAdd == null) continue;
                        toAdd.setName(name);
                        ArrayList<Exclusion> exclusionList = new ArrayList<Exclusion>();
                        if (remind) {
                            toAdd.setReminderMinutesDefault(ReminderPlugin.getInstance().getDefaultReminderTime());
                            toAdd.getReminderConfiguration().setReminderServices(new String[]{"window"});
                        } else {
                            toAdd.getReminderConfiguration().setReminderServices(new String[0]);
                        }
                        if (excludedChannels != null) {
                            for (Channel ch : excludedChannels) {
                                exclusionList.add(new Exclusion(null, null, ch, -1, -1, -1, null, null, 0, null, 0, -1));
                            }
                        }
                        if (timeRestrictionStart != -1 && timeRestrictionEnd != -1) {
                            exclusionList.add(new Exclusion(null, null, null, timeRestrictionStart, timeRestrictionEnd, -1, null, null, 0, null, 0, -1));
                        }
                        if (restrictedDays != null) {
                            for (String day : restrictedDays) {
                                exclusionList.add(new Exclusion(null, null, null, -1, -1, (int)day, null, null, 0, null, 0, -1));
                            }
                        }
                        if (exculdedKeywords != null) {
                            for (String keyword : exculdedKeywords) {
                                exclusionList.add(new Exclusion(null, keyword, null, -1, -1, -1, null, null, 0, null, 0, -1));
                            }
                        }
                        if (shorterThan != -1) {
                            exclusionList.add(new Exclusion(null, null, null, -1, -1, -1, null, null, 0, null, 2, shorterThan));
                        }
                        if (longerThan != -1) {
                            exclusionList.add(new Exclusion(null, null, null, -1, -1, -1, null, null, 0, null, 1, longerThan));
                        }
                        if (categories != 0) {
                            try (ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                                 ObjectOutputStream out = new ObjectOutputStream(bOut);){
                                out.writeInt(categories);
                                out.flush();
                                try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bOut.toByteArray()));){
                                    ProgramInfoFilterComponent infoFilter = new ProgramInfoFilterComponent("AndroidSync-Import_" + name.replaceAll("\\s+|\\p{Punct}", "_") + "_" + DateFormat.getDateTimeInstance().format(new Date()).replaceAll("\\s+|\\p{Punct}", "_"), "");
                                    infoFilter.read(in, 1);
                                    FilterComponentList.getInstance().add(infoFilter);
                                    UserFilter filter = new UserFilter("AndroidSync-Import_" + name.replaceAll("\\s+|\\p{Punct}", "_") + "_" + DateFormat.getDateTimeInstance().format(new Date()).replaceAll("\\s+|\\p{Punct}", "_"));
                                    filter.setRule("NOT " + infoFilter.getName());
                                    FilterList.getInstance().addProgramFilter(filter);
                                    exclusionList.add(new Exclusion(null, null, null, -1, -1, -1, filter.getName(), null, 0, null, 0, -1));
                                }
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                        if (!exclusionList.isEmpty()) {
                            toAdd.setExclusions(exclusionList.toArray(new Exclusion[0]));
                        }
                        if (!duplicates.isEmpty() && importInfoTemp.mReplace) {
                            FavoriteNode parent = null;
                            object = duplicates.iterator();
                            while (object.hasNext()) {
                                FavoriteNode temp3;
                                Favorite dup = (Favorite)object.next();
                                if (parent == null && (temp3 = this.mFavoriteTree.findFavorite(dup)) != null) {
                                    parent = (FavoriteNode)temp3.getParent();
                                }
                                FavoriteTreeModel.getInstance().deleteFavorite(dup);
                            }
                            duplicates.clear();
                            if (parent == null) {
                                parent = folderAdded;
                            }
                            duplicates.add(toAdd);
                            this.addFavorite(toAdd, true, parent);
                        } else {
                            if (folderAdded == null) {
                                TreePath path = this.mFavoriteTree.getSelectionPath();
                                if (path != null) {
                                    FavoritesPlugin.getInstance().newFolder((FavoriteNode)path.getLastPathComponent(), "AndroidSync-Import " + DateFormat.getDateTimeInstance().format(new Date()));
                                } else {
                                    FavoritesPlugin.getInstance().newFolder(this.mFavoriteTree.getRoot(), "AndroidSync-Import " + DateFormat.getDateTimeInstance().format(new Date()));
                                }
                                path = this.mFavoriteTree.getSelectionPath();
                                folderAdded = (FavoriteNode)path.getLastPathComponent();
                                this.favoriteSelectionChanged();
                            }
                            this.addFavorite(toAdd, true, folderAdded);
                        }
                        ++count;
                        if (importInfo.mAdd) continue;
                        ArrayList<Favorite> list2 = (ArrayList<Favorite>)existingFavorites.get(toAdd.getName());
                        if (list2 == null) {
                            list2 = new ArrayList<Favorite>();
                            existingFavorites.put(toAdd.getName(), list2);
                        }
                        list2.add(toAdd);
                    }
                    if (count > 0) {
                        UiUtilities.showMessageDialogOnMouseScreen(LOCALIZER.msg("androidSync.success", "{0} Favorites were imported.", count), Localizer.getLocalization("i18n_info"), 1);
                        MainFrame.getInstance().updateFilterMenu();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Object parseArray(int type, String value) {
        Object result = null;
        if (!value.equals("null")) {
            if (type == 1 && value.contains("#_#")) {
                String[] parts;
                ArrayList<Channel> channelList = new ArrayList<Channel>();
                channelList.addAll(Arrays.asList(ChannelList.getSubscribedChannels()));
                block0: for (String part : parts = value.split(",")) {
                    String[] subParts = part.split("#_#");
                    for (int i = channelList.size() - 1; i >= 0; --i) {
                        Channel ch = (Channel)channelList.get(i);
                        if (ch.getDataServiceId().equals("tvbrowserdataservice.TvBrowserDataService") && subParts[0].equals("1")) {
                            if (!ch.getGroup().getId().equals(subParts[1]) || !ch.getId().equals(subParts[2])) continue;
                            channelList.remove(i);
                            continue block0;
                        }
                        if (!ch.getDataServiceId().equals("epgdonatedata.EPGdonateData") || !subParts[0].equals("2") || !ch.getId().equals(subParts[1])) continue;
                        channelList.remove(i);
                        continue block0;
                    }
                }
                if (!channelList.isEmpty()) {
                    result = channelList;
                }
            } else {
                String[] parts = value.split(",");
                int[] array = new int[parts.length];
                for (int i = 0; i < parts.length; ++i) {
                    array[i] = Integer.parseInt(parts[i]);
                }
                result = array;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importFavorites() {
        File file;
        JFileChooser fileChooser = new JFileChooser();
        String[] extArr = new String[]{".txt"};
        String msg = LOCALIZER.msg("importFile.TVgenial", "Text file (from TVgenial) (.txt)");
        fileChooser.setFileFilter(new ExtensionFileFilter(extArr, msg));
        if (fileChooser.showOpenDialog(this) == 0 && (file = fileChooser.getSelectedFile()) != null) {
            FileReader reader = null;
            int importedFavoritesCount = 0;
            BufferedReader lineReader = null;
            try {
                String line;
                reader = new FileReader(file);
                lineReader = new BufferedReader(reader);
                while ((line = lineReader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.startsWith("***")) continue;
                    boolean alreadyKnown = false;
                    Favorite[] favs = null;
                    if (this.mFavoritesListModel != null) {
                        favs = (Favorite[])this.mFavoritesListModel.toArray();
                    } else if (this.mFavoriteTree != null) {
                        favs = FavoriteTreeModel.getInstance().getFavoriteArr();
                    }
                    if (favs == null) continue;
                    for (Favorite favorite : favs) {
                        String favName = favorite.getName();
                        if (!line.equalsIgnoreCase(favName)) continue;
                        alreadyKnown = true;
                        break;
                    }
                    if (alreadyKnown) continue;
                    line = line.replace(" *", " OR ").replace(" |", " OR ").replace(" ODER ", " OR ").replace(" +", " AND ").replace(" &", " AND ").replace(" UND ", " AND ").replace(" \\", " NOT ").replace(" NICHT ", " NOT ").replace("_", " ").trim();
                    while (line.indexOf("  ") >= 0) {
                        line = line.replace("  ", " ");
                    }
                    AdvancedFavorite fav = new AdvancedFavorite(line);
                    fav.updatePrograms();
                    if (this.mFavoritesListModel != null) {
                        this.mFavoritesListModel.addElement(fav);
                    } else {
                        FavoriteTreeModel.getInstance().addFavorite(fav);
                    }
                    ++importedFavoritesCount;
                }
            }
            catch (Exception exc) {
                msg = LOCALIZER.msg("error.1", "Importing text file failed: {0}.", file.getAbsolutePath());
                ErrorHandler.handle(msg, exc);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException exc) {}
                }
            }
            if (importedFavoritesCount == 0) {
                msg = LOCALIZER.msg("error.2", "There are no new favorites in {0}.", file.getAbsolutePath());
                JOptionPane.showMessageDialog(this, msg);
            } else {
                if (this.mFavoritesListModel != null) {
                    this.mFavoritesList.ensureIndexIsVisible(this.mFavoritesListModel.size() - 1);
                    int firstNewIdx = this.mFavoritesListModel.size() - importedFavoritesCount;
                    this.mFavoritesList.setSelectedIndex(firstNewIdx);
                    this.mFavoritesList.ensureIndexIsVisible(firstNewIdx);
                }
                msg = LOCALIZER.msg("importDone", "There were {0} new favorites imported.", importedFavoritesCount);
                JOptionPane.showMessageDialog(this, msg);
            }
        }
    }

    public Favorite[] getFavorites() {
        Object[] favoriteArr = new Favorite[this.mFavoritesListModel.size()];
        this.mFavoritesListModel.copyInto(favoriteArr);
        return favoriteArr;
    }

    @Override
    public void drop(JList<Favorite> source, JList<Favorite> target, int rows, boolean move) {
        UiUtilities.moveSelectedItems(target, rows, true);
        FavoritesPlugin.getInstance().updateRootNode(true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.favoriteSelectionChanged(true);
    }

    public void close() {
        if (this.mFavoriteTree != null) {
            this.mFavoriteTree.removeTreeSelectionListener(this);
        }
    }

    public boolean programListIsEmpty() {
        return this.mProgramList.getModel().getSize() < 1;
    }

    public boolean isShowingNewFoundPrograms() {
        return this.mShowNew;
    }

    public void favoriteSelectionChanged() {
        this.favoriteSelectionChanged(false);
    }

    public void handleFavoriteEvent() {
        SwingUtilities.invokeLater(() -> {
            this.mFavoriteTree.updateUI();
            this.favoriteSelectionChanged();
        });
    }

    public void newFolder(FavoriteNode parent, Window partenWindow, String name) {
        this.mFavoriteTree.newFolder(parent, partenWindow, name);
    }

    @Override
    public void updatePersona() {
        if (Persona.getInstance().getHeaderImage() != null) {
            this.mBlackListChb.setForeground(Persona.getInstance().getTextColor());
        } else {
            this.mBlackListChb.setForeground(UIManager.getColor("Label.foreground"));
        }
    }

    public void setShowDateSeparators(boolean showDateSeparators) {
        this.mProgramListPanel.setShowDateSeparators(showDateSeparators);
    }

    public void registerPersonaListener() {
        Persona.getInstance().registerPersonaListener(this.mProgramListPanel);
        this.mProgramListPanel.updatePersona();
    }

    public void removePersonaListener() {
        Persona.getInstance().removePersonaListener(this.mProgramListPanel);
        this.mProgramListPanel.updatePersona();
    }

    public void scrollToDate(devplugin.Date date) {
        this.mProgramList.scrollToNextDateIfAvailable(date);
    }

    public void scrollToNow() {
        this.mProgramListPanel.scrollToFirstNotExpiredIndex(false);
    }

    public void scrollToTime(int time, boolean scrollToNext) {
        if (scrollToNext) {
            this.mProgramList.scrollToFirstOccurrenceOfTimeFromCurrentViewOnwardIfAvailable(time);
        } else {
            this.mProgramList.scrollToTimeFromCurrentViewIfAvailable(time);
        }
    }

    public void selectFilter(ProgramFilter filter) {
        this.mProgramListPanel.selectFilter(filter);
    }

    public String getSelectedProgramFilterName() {
        return this.mProgramListPanel.getSelectedProgramFilterName();
    }

    @Override
    public void tabShown() {
        super.tabShown();
        this.scrollToFirstNotExpiredIndex(false);
        this.updateAndroidSyncImportButton();
    }

    private void updateAndroidSyncImportButton() {
        PluginProxy androidSync = PluginProxyManager.getInstance().getActivatedPluginForId("java.androidsync.AndroidSync");
        if (androidSync != null) {
            PluginCommunication c = androidSync.getCommunicationClass();
            this.mImportApp.setIcon(TVBrowserIcons.getMenuIcon(androidSync.getButtonAction(), "BigIcon"));
            this.mImportApp.setEnabled(c != null && c.getVersion() >= 2);
        } else {
            this.mImportApp.setEnabled(false);
        }
    }

    private static final class ImportInfo {
        private final boolean mAdd;
        private final boolean mReplace;
        private final boolean mAsk;

        private ImportInfo(boolean add, boolean replace, boolean ask) {
            this.mAdd = add;
            this.mReplace = replace;
            this.mAsk = ask;
        }
    }

    class FavoriteListCellRenderer
    extends DefaultListCellRenderer {
        FavoriteListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof Favorite && c instanceof JLabel) {
                Favorite fav = (Favorite)value;
                ((JLabel)c).setText(fav.getName() + " (" + (ManageFavoritesPanel.this.mShowNew ? fav.getNewPrograms().length : fav.getWhiteListPrograms().length) + ")");
                if (!fav.isValidSearch()) {
                    c.setForeground(Color.orange);
                    ((JLabel)c).setText("<html><strike>" + ((JLabel)c).getText() + "</strike></html>");
                } else if (ManageFavoritesPanel.this.mShowNew && fav.getNewPrograms().length > 0 && !isSelected) {
                    c.setForeground(Color.red);
                }
            }
            return c;
        }
    }
}

