/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.dlgs;

import devplugin.Program;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.tree.DefaultMutableTreeNode;
import tvbrowser.extras.favoritesplugin.core.ActorsFavorite;
import tvbrowser.extras.favoritesplugin.core.AdvancedFavorite;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.core.FilterFavorite;
import tvbrowser.extras.favoritesplugin.core.TitleFavorite;
import tvbrowser.extras.favoritesplugin.core.TopicFavorite;

public class FavoriteNode
extends DefaultMutableTreeNode
implements Comparable<FavoriteNode> {
    private boolean mWasExpanded;

    public FavoriteNode(Object userObject) {
        if (userObject instanceof Favorite) {
            this.setAllowsChildren(false);
        }
        this.userObject = userObject;
    }

    protected FavoriteNode(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            int n = in.readInt();
            this.setUserObject(in.readObject());
            this.mWasExpanded = in.readBoolean();
            for (int i = 0; i < n; ++i) {
                FavoriteNode node = new FavoriteNode(in, version);
                this.add(node);
            }
        } else {
            this.setAllowsChildren(false);
            if (version <= 2) {
                this.userObject = AdvancedFavorite.loadOldFavorite(in);
            } else {
                String typeID = (String)in.readObject();
                if ("topic".equals(typeID)) {
                    this.userObject = new TopicFavorite(in);
                } else if ("title".equals(typeID)) {
                    this.userObject = new TitleFavorite(in);
                } else if ("actors".equals(typeID)) {
                    this.userObject = new ActorsFavorite(in);
                } else if ("advanced".equals(typeID)) {
                    this.userObject = new AdvancedFavorite(in);
                } else if ("filterFavorite".equals(typeID)) {
                    this.userObject = new FilterFavorite(in);
                }
            }
        }
    }

    @Override
    public String toString() {
        if (this.userObject instanceof String) {
            return this.userObject.toString();
        }
        if (this.userObject != null) {
            return ((Favorite)this.userObject).getName();
        }
        return "NULL";
    }

    public boolean containsFavorite() {
        return this.userObject instanceof Favorite;
    }

    public boolean isDirectoryNode() {
        return this.userObject instanceof String;
    }

    public Favorite getFavorite() {
        if (this.containsFavorite()) {
            return (Favorite)this.userObject;
        }
        return null;
    }

    protected boolean wasExpanded() {
        return this.mWasExpanded || this.isRoot();
    }

    protected void setWasExpanded(boolean expanded) {
        this.mWasExpanded = expanded;
    }

    public FavoriteNode add(Favorite fav) {
        if (this.allowsChildren) {
            FavoriteNode newChild = new FavoriteNode(fav);
            super.add(newChild);
            return newChild;
        }
        return null;
    }

    protected void store(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.isDirectoryNode());
        if (this.isDirectoryNode()) {
            out.writeInt(this.getChildCount());
            out.writeObject(this.userObject);
            out.writeBoolean(this.mWasExpanded);
            for (int i = 0; i < this.getChildCount(); ++i) {
                ((FavoriteNode)this.getChildAt(i)).store(out);
            }
        } else if (this.containsFavorite()) {
            out.writeObject(this.getFavorite().getTypeID());
            this.getFavorite().writeData(out);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Favorite) {
            return this.containsFavorite() && this.userObject == o;
        }
        return this == o;
    }

    @Override
    public int compareTo(FavoriteNode other) {
        return this.toString().compareToIgnoreCase(other.toString());
    }

    public Program[] getAllPrograms(boolean onlyNotExpiredPrograms) {
        try {
            if (this.isDirectoryNode()) {
                Program[] progs = new Program[]{};
                for (int i = 0; i < this.getChildCount(); ++i) {
                    Program[] p = ((FavoriteNode)this.getChildAt(i)).getAllPrograms(onlyNotExpiredPrograms);
                    if (p == null || p.length <= 0) continue;
                    Program[] newArr = new Program[progs.length + p.length];
                    System.arraycopy(progs, 0, newArr, 0, progs.length);
                    System.arraycopy(p, 0, newArr, progs.length, p.length);
                    progs = newArr;
                }
                return progs;
            }
            return this.getFavorite().getWhiteListPrograms(onlyNotExpiredPrograms);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void reValidateChannelLimitations() {
        if (this.isDirectoryNode()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ((FavoriteNode)this.getChildAt(i)).reValidateChannelLimitations();
            }
        } else if (this.getFavorite() != null) {
            this.getFavorite().reValidateChannelLimitation();
        }
    }
}

