/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin;

import devplugin.ActionMenu;
import devplugin.ContextMenuAction;
import devplugin.ContextMenuSeparatorAction;
import devplugin.Plugin;
import devplugin.Program;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;
import tvbrowser.extras.favoritesplugin.dlgs.ManageFavoritesDialog;
import tvbrowser.extras.programinfo.ProgramInfo;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class ContextMenuProvider {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ContextMenuProvider.class);
    private Favorite[] mFavoriteArr;

    public ContextMenuProvider(Favorite[] favoriteArr) {
        this.mFavoriteArr = favoriteArr;
    }

    public ActionMenu getContextMenuActions(Program program) {
        ArrayList<Favorite> favorites = new ArrayList<Favorite>();
        block0: for (Favorite favorite : this.mFavoriteArr) {
            Program[] programs;
            for (Program favProgram : programs = favorite.getPrograms()) {
                if (!favProgram.equals(program)) continue;
                favorites.add(favorite);
                continue block0;
            }
        }
        Favorite[] favArr = favorites.toArray(new Favorite[favorites.size()]);
        if (ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible()) {
            if (!favorites.isEmpty()) {
                ActionMenu blackListAction = this.createBlackListFavoriteMenuAction(favArr, program);
                ArrayList<ActionMenu> subItems = new ArrayList<ActionMenu>(2);
                subItems.add(this.createExcludeFromFavoritesMenuAction(favArr, program));
                if (blackListAction != null) {
                    subItems.add(0, blackListAction);
                }
                return new ActionMenu(mLocalizer.msg("favorites", "Favorites"), (Icon)FavoritesPlugin.getFavoritesIcon(16), subItems.toArray());
            }
            return null;
        }
        if (Plugin.getPluginManager().getExampleProgram().equals(program)) {
            return new ActionMenu(mLocalizer.msg("favorites", "Favorites"), (Icon)FavoritesPlugin.getFavoritesIcon(16), new ActionMenu[]{this.createAddToFavoritesActionMenu(program), new ActionMenu(5, mLocalizer.msg("excludeFrom", "Exclude from"), TVBrowserIcons.filter(16), null)});
        }
        if (favorites.isEmpty()) {
            return new ActionMenu(mLocalizer.msg("favorites", "Favorites"), (Icon)FavoritesPlugin.getFavoritesIcon(16), new ActionMenu[]{this.createAddToFavoritesActionMenu(program), this.createGlobalExclusionMenu(program)});
        }
        ActionMenu blackListAction = this.createBlackListFavoriteMenuAction(favArr, program);
        ActionMenu repetitions = FavoritesPlugin.getInstance().isShowingRepetitions() ? this.createRepetitionsMenuAction(favArr, program) : null;
        ArrayList<Object> subItems = new ArrayList<Object>(8);
        subItems.add(this.createManageFavoriteMenuAction(favArr));
        subItems.add(this.createEditFavoriteMenuAction(favArr));
        subItems.add(this.createExcludeFromFavoritesMenuAction(favArr, program));
        subItems.add(this.createDeleteFavoriteMenuAction(favArr));
        subItems.add(ContextMenuSeparatorAction.getInstance());
        subItems.add(this.createGlobalExclusionMenu(program));
        subItems.add(this.createAddToFavoritesActionMenu(program));
        if (repetitions != null) {
            subItems.add(3, repetitions);
        }
        if (blackListAction != null) {
            subItems.add(1, blackListAction);
        }
        return new ActionMenu(mLocalizer.msg("favorites", "Favorites"), (Icon)FavoritesPlugin.getFavoritesIcon(16), subItems.toArray());
    }

    public ImageIcon getIconFromTheme(String category, String icon, int size) {
        return FavoritesPlugin.getIconFromTheme(category, icon, size);
    }

    private ActionMenu createGlobalExclusionMenu(Program program) {
        ContextMenuAction menu = new ContextMenuAction();
        menu.setSmallIcon(TVBrowserIcons.newIcon(16));
        menu.setText(mLocalizer.ellipsisMsg("createGlobalExclusion", "Create global exclusion"));
        menu.setActionListener(e -> FavoritesPlugin.getInstance().showExcludeProgramsDialog(null, program));
        return new ActionMenu(menu);
    }

    private ActionMenu createAddToFavoritesActionMenu(Program program) {
        ContextMenuAction menu = new ContextMenuAction();
        menu.setSmallIcon(FavoritesPlugin.getFavoritesIcon(16));
        menu.setText(mLocalizer.msg("addToFavorites", "Add to favorite programs"));
        menu.setActionListener(e -> FavoritesPlugin.getInstance().showCreateFavoriteWizard(program));
        return new ActionMenu(1, menu);
    }

    private ActionMenu createExcludeFromFavoritesMenuAction(Favorite[] favArr, Program program) {
        if (favArr.length == 1) {
            ContextMenuAction action = new ContextMenuAction();
            action.setSmallIcon(TVBrowserIcons.filter(16));
            action.setText(mLocalizer.ellipsisMsg("excludeFromFavorite", "Exclude from '{0}'", favArr[0].getName()));
            action.setActionListener(e -> FavoritesPlugin.getInstance().showExcludeProgramsDialog(favArr[0], program));
            return new ActionMenu(5, action);
        }
        ActionMenu[] subItems = new ActionMenu[favArr.length];
        for (int i = 0; i < subItems.length; ++i) {
            Favorite fav = favArr[i];
            ContextMenuAction action = new ContextMenuAction(favArr[i].getName(), FavoritesPlugin.getFavoritesIcon(16));
            subItems[i] = new ActionMenu(action);
            action.setActionListener(e -> FavoritesPlugin.getInstance().showExcludeProgramsDialog(fav, program));
        }
        ActionMenu menu = new ActionMenu(5, mLocalizer.msg("excludeFrom", "Exclude from"), TVBrowserIcons.filter(16), subItems);
        Action action = menu.getAction();
        if (action instanceof ContextMenuAction) {
            ((ContextMenuAction)action).setActionListener(e -> {
                JRadioButton[] buttons = new JRadioButton[favArr.length];
                ButtonGroup bg = new ButtonGroup();
                for (int i1 = 0; i1 < favArr.length; ++i1) {
                    buttons[i1] = new JRadioButton(favArr[i1].getName());
                    bg.add(buttons[i1]);
                }
                if (JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), buttons, mLocalizer.msg("excludeFrom", "Exclude from"), 2) == 0) {
                    for (int i2 = 0; i2 < buttons.length; ++i2) {
                        if (!buttons[i2].isSelected()) continue;
                        FavoritesPlugin.getInstance().showExcludeProgramsDialog(favArr[i2], program);
                        break;
                    }
                }
            });
        }
        return menu;
    }

    private ActionMenu createManageFavoriteMenuAction(Favorite[] favArr) {
        if (favArr.length == 1) {
            ContextMenuAction action = new ContextMenuAction();
            action.setSmallIcon(FavoritesPlugin.getFavoritesIcon(16));
            action.setText(mLocalizer.ellipsisMsg("manageFavorite", "Manage favorite '{0}'", favArr[0].getName()));
            action.setActionListener(e -> FavoritesPlugin.getInstance().showManageFavoritesDialog(favArr[0]));
            return new ActionMenu(action);
        }
        Action[] subItems = new ContextMenuAction[favArr.length];
        for (int i = 0; i < subItems.length; ++i) {
            Favorite fav = favArr[i];
            subItems[i] = new ContextMenuAction(favArr[i].getName());
            ((ContextMenuAction)subItems[i]).setSmallIcon(FavoritesPlugin.getFavoritesIcon(16));
            ((ContextMenuAction)subItems[i]).setActionListener(e -> FavoritesPlugin.getInstance().showManageFavoritesDialog(fav));
        }
        return new ActionMenu(mLocalizer.msg("manage", "Manage Favorite"), (Icon)FavoritesPlugin.getFavoritesIcon(16), subItems);
    }

    private ActionMenu createEditFavoriteMenuAction(Favorite[] favArr) {
        if (favArr.length == 1) {
            ContextMenuAction action = new ContextMenuAction();
            action.setSmallIcon(TVBrowserIcons.edit(16));
            action.setText(mLocalizer.ellipsisMsg("editFavorite", "Edit favorite '{0}'", favArr[0].getName()));
            action.setActionListener(e -> FavoritesPlugin.getInstance().editFavorite(favArr[0]));
            return new ActionMenu(action);
        }
        Action[] subItems = new ContextMenuAction[favArr.length];
        for (int i = 0; i < subItems.length; ++i) {
            Favorite fav = favArr[i];
            subItems[i] = new ContextMenuAction(favArr[i].getName());
            ((ContextMenuAction)subItems[i]).setSmallIcon(FavoritesPlugin.getFavoritesIcon(16));
            ((ContextMenuAction)subItems[i]).setActionListener(e -> FavoritesPlugin.getInstance().editFavorite(fav));
        }
        return new ActionMenu(mLocalizer.msg("edit", "Edit Favorite"), (Icon)TVBrowserIcons.edit(16), subItems);
    }

    private ActionMenu createRepetitionsMenuAction(Favorite[] favorites, Program p) {
        ImageIcon icon = TVBrowserIcons.search(16);
        String actionText = mLocalizer.msg("repetitions", "More programs");
        if (favorites.length == 1) {
            return this.createFavoriteRepetitionMenu(actionText, icon, favorites[0], p);
        }
        ArrayList<ActionMenu> menus = new ArrayList<ActionMenu>();
        for (Favorite favorite : favorites) {
            ActionMenu menu = this.createFavoriteRepetitionMenu(favorite.getName(), null, favorite, p);
            if (menu == null) continue;
            menus.add(menu);
        }
        return menus.isEmpty() ? null : new ActionMenu(actionText, (Icon)icon, menus.toArray(new ActionMenu[menus.size()]));
    }

    private ActionMenu createFavoriteRepetitionMenu(String title, Icon icon, Favorite favorite, Program p) {
        Program[] programs = favorite.getPrograms();
        if (programs == null || programs.length == 1 && programs[0].equals(p)) {
            return null;
        }
        ArrayList<ContextMenuAction> subItems = new ArrayList<ContextMenuAction>();
        for (Program program : programs) {
            if (program.isExpired() || program.equals(p)) continue;
            ContextMenuAction subItem = new ContextMenuAction(FavoriteTreeModel.getFavoriteLabel(favorite, program, p.getChannel()));
            subItem.setActionListener(e -> {
                MainFrame.getInstance().scrollToProgram(program);
                if (ProgramInfo.isShowing()) {
                    ProgramInfo.getInstance().showProgramInformation(program);
                }
            });
            subItems.add(subItem);
            if (subItems.size() >= 30) break;
        }
        if (subItems.size() == 0) {
            return null;
        }
        return new ActionMenu(title, icon, subItems.toArray(new ContextMenuAction[subItems.size()]));
    }

    private ActionMenu createDeleteFavoriteMenuAction(Favorite[] favArr) {
        if (favArr.length == 1) {
            ContextMenuAction action = new ContextMenuAction();
            action.setSmallIcon(TVBrowserIcons.delete(16));
            action.setText(mLocalizer.ellipsisMsg("deleteFavorite", "Delete Favorite '{0}'", favArr[0].getName()));
            action.setActionListener(e -> FavoritesPlugin.getInstance().askAndDeleteFavorite(favArr[0]));
            return new ActionMenu(action);
        }
        Action[] subItems = new ContextMenuAction[favArr.length];
        for (int i = 0; i < subItems.length; ++i) {
            Favorite fav = favArr[i];
            subItems[i] = new ContextMenuAction(favArr[i].getName());
            ((ContextMenuAction)subItems[i]).setSmallIcon(FavoritesPlugin.getFavoritesIcon(16));
            ((ContextMenuAction)subItems[i]).setActionListener(e -> FavoritesPlugin.getInstance().askAndDeleteFavorite(fav));
        }
        return new ActionMenu(mLocalizer.msg("delete", "Delete Favorite"), (Icon)TVBrowserIcons.delete(16), subItems);
    }

    private ActionMenu createBlackListFavoriteMenuAction(Favorite[] favArr, Program program) {
        if (favArr.length == 1) {
            ContextMenuAction action = new ContextMenuAction();
            if (favArr[0].isOnBlackList(program)) {
                action.setSmallIcon(TVBrowserIcons.refresh(16));
                action.setText(mLocalizer.msg("removeFavoriteFromBlackList", "Put this program back into '{0}'", favArr[0].getName()));
                action.setActionListener(e -> favArr[0].removeFromBlackList(program));
                return new ActionMenu(action);
            }
            return null;
        }
        ArrayList<Favorite> fromList = new ArrayList<Favorite>();
        for (Favorite favorite : favArr) {
            if (!favorite.isOnBlackList(program)) continue;
            fromList.add(favorite);
        }
        Action[] reactivateAction = new ContextMenuAction[fromList.size()];
        for (int i = 0; i < fromList.size(); ++i) {
            Favorite fav = (Favorite)fromList.get(i);
            reactivateAction[i] = new ContextMenuAction(fav.getName());
            ((ContextMenuAction)reactivateAction[i]).setSmallIcon(FavoritesPlugin.getFavoritesIcon(16));
            ((ContextMenuAction)reactivateAction[i]).setActionListener(e -> fav.removeFromBlackList(program));
        }
        if (!fromList.isEmpty()) {
            return new ActionMenu(mLocalizer.ellipsisMsg("removeFromBlackList", "Put this program back into"), (Icon)TVBrowserIcons.refresh(16), reactivateAction);
        }
        return null;
    }
}

