/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.plugin;

import devplugin.ActionMenu;
import devplugin.AfterDataUpdateInfoPanel;
import devplugin.Channel;
import devplugin.ChannelDayProgram;
import devplugin.ContextMenuAction;
import devplugin.Date;
import devplugin.ImportanceValue;
import devplugin.Plugin;
import devplugin.PluginCenterPanelWrapper;
import devplugin.PluginCommunication;
import devplugin.PluginInfo;
import devplugin.PluginProgramInformation;
import devplugin.PluginTreeNode;
import devplugin.PluginsFilterComponent;
import devplugin.PluginsProgramFilter;
import devplugin.Program;
import devplugin.ProgramInfo;
import devplugin.ProgramRatingIf;
import devplugin.ProgramReceiveTarget;
import devplugin.SettingsTab;
import devplugin.ToolTipIcon;
import devplugin.Version;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import tvbrowser.TVBrowser;
import tvbrowser.core.PluginLoader;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.GenericFilterMap;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.plugin.AbstractPluginProxy;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.SettingsTabProxy;
import tvbrowser.core.settings.PluginSettings;
import tvbrowser.ui.mainframe.MainFrame;
import tvdataservice.MutableChannelDayProgram;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.io.IOUtilities;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class JavaPluginProxy
extends AbstractPluginProxy {
    private static final Logger LOG = Logger.getLogger(JavaPluginProxy.class.getName());
    private Plugin mPlugin;
    private String mId;
    private PluginInfo mPluginInfo;
    private String mPluginFileName;
    private Icon mPluginIcon;
    private String mIconFileName;
    private String mPluginCategory;

    public JavaPluginProxy(Plugin plugin, String pluginFileName) {
        this.mPlugin = plugin;
        this.mPluginFileName = pluginFileName;
    }

    public JavaPluginProxy(PluginInfo info, String pluginFileName, String pluginId, Icon pluginIcon, String category) {
        this.mPluginInfo = info;
        this.mPluginFileName = pluginFileName;
        this.mId = pluginId;
        this.mPluginIcon = pluginIcon;
        this.mPluginCategory = category;
    }

    public JavaPluginProxy(PluginInfo info, String pluginFileName, String pluginId, String iconFileName, String category) {
        this.mPluginInfo = info;
        this.mPluginFileName = pluginFileName;
        this.mId = pluginId;
        this.mIconFileName = iconFileName;
        this.mPluginCategory = category;
    }

    public static String getJavaPluginId(Plugin javaPlugin) {
        return "java." + javaPlugin.getClass().getName();
    }

    @Override
    public String getId() {
        if (this.mId == null) {
            this.mId = JavaPluginProxy.getJavaPluginId(this.mPlugin);
        }
        return this.mId;
    }

    @Override
    void setParentFrame(Frame parent) {
        if (this.mPlugin != null) {
            this.mPlugin.setParent(parent);
        }
    }

    @Override
    protected void doLoadSettings() throws TvBrowserException {
        PluginSettings.loadSettings(this.mPlugin);
        PluginSettings.readData(this.mPlugin);
    }

    @Override
    protected void doSaveSettings(boolean log) throws TvBrowserException {
        if (this.mPlugin.hasToSaveSettings()) {
            PluginSettings.writeData(this.mPlugin, log);
            PluginSettings.storeSettings(this.mPlugin);
        }
    }

    @Override
    protected PluginInfo doGetInfo() {
        if (this.mPluginInfo != null) {
            return this.mPluginInfo;
        }
        PluginInfo info = null;
        try {
            info = this.mPlugin.getInfo();
        }
        catch (NoSuchMethodError e) {
            String name = Plugin.mLocalizer.msg("unkown", "Unknown");
            String desc = Plugin.mLocalizer.msg("noDescription", "No description");
            String author = Plugin.mLocalizer.msg("noAuthor", "No author given");
            return new PluginInfo(Plugin.class, name, desc, author);
        }
        return info;
    }

    @Override
    protected SettingsTabProxy doGetSettingsTab() {
        SettingsTab tab = this.mPlugin.getSettingsTab();
        if (tab == null) {
            return null;
        }
        return new SettingsTabProxy(tab);
    }

    @Override
    protected ActionMenu doGetContextMenuActions(Program program) {
        if (program != null && !program.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
            UserFilter filter = GenericFilterMap.getInstance().getGenericPluginFilter(this, true);
            if (this.accessControl(program.getChannel()) || filter != null && !filter.accept(program)) {
                return null;
            }
        }
        return this.mPlugin.getContextMenuActions(program);
    }

    @Override
    protected ActionMenu doGetContextMenuActions(Channel channel) {
        if (!this.accessControl(channel)) {
            return this.mPlugin.getContextMenuActions(channel);
        }
        return null;
    }

    @Override
    protected ActionMenu doGetButtonAction() {
        if (this.mPlugin != null) {
            Action action;
            ActionMenu actMenu = this.mPlugin.getButtonAction();
            if (actMenu != null && (action = actMenu.getAction()) != null && !(action instanceof ContextMenuAction)) {
                if (action.getValue("SmallIcon") == null) {
                    LOG.warning("Small icon missing for button action " + action.getValue("Name"));
                    action.putValue("SmallIcon", TVBrowserIcons.warning(16));
                }
                if (action.getValue("BigIcon") == null) {
                    LOG.warning("Big icon missing for button action " + action.getValue("Name"));
                    action.putValue("BigIcon", TVBrowserIcons.warning(22));
                }
            }
            return actMenu;
        }
        return null;
    }

    @Override
    protected Icon[] doGetMarkIcons(Program p) {
        if (this.mPlugin != null && p != null) {
            UserFilter filter = GenericFilterMap.getInstance().getGenericPluginFilter(this, true);
            if (!this.accessControl(p.getChannel()) && (filter == null || filter.accept(p))) {
                return this.mPlugin.getMarkIcons(p);
            }
        }
        return null;
    }

    @Override
    protected String doGetProgramTableIconText() {
        return this.mPlugin.getProgramTableIconText();
    }

    @Override
    protected Icon[] doGetProgramTableIcons(Program program) {
        if (program != null && !this.accessControl(program.getChannel())) {
            return this.mPlugin.getProgramTableIcons(program);
        }
        return null;
    }

    @Override
    protected void doHandleTvDataUpdateFinished() {
        this.mPlugin.handleTvDataUpdateFinished();
    }

    @Override
    protected void doHandleTvDataAdded(ChannelDayProgram newProg) {
        if (newProg != null && !this.accessControl(newProg.getChannel())) {
            this.mPlugin.handleTvDataAdded(newProg);
        }
    }

    @Override
    protected void doHandleTvDataDeleted(ChannelDayProgram oldProg) {
        if (oldProg != null && !this.accessControl(oldProg.getChannel())) {
            this.mPlugin.handleTvDataDeleted(oldProg);
        }
    }

    @Override
    protected void doHandleTvBrowserStartFinished() {
        this.mPlugin.handleTvBrowserStartFinished();
    }

    @Override
    public void doOnActivation() throws Throwable {
        if (!TVBrowser.isSafeMode()) {
            this.plugin().onActivation();
        }
    }

    private Plugin plugin() {
        if (this.mPlugin == null) {
            this.mPlugin = (Plugin)PluginLoader.getInstance().loadPlugin(new File(this.mPluginFileName), false);
        }
        return this.mPlugin;
    }

    @Override
    public void doOnDeactivation() throws Throwable {
        if (this.mPlugin != null) {
            this.mPlugin.onDeactivation();
        }
    }

    @Override
    public boolean doCanUseProgramTree() {
        return this.mPlugin.canUseProgramTree();
    }

    @Override
    public PluginTreeNode getRootNode() {
        return this.mPlugin.getRootNode();
    }

    @Override
    protected boolean doReceivePrograms(int type, Program[] programArr, ProgramReceiveTarget receiveTarget) {
        boolean value;
        if (programArr != null && this.accessControl()) {
            ArrayList<Program> accessPrograms = new ArrayList<Program>();
            for (Program p : programArr) {
                if (p.getChannel().isAccessControl()) continue;
                accessPrograms.add(p);
            }
            programArr = accessPrograms.toArray(new Program[accessPrograms.size()]);
        }
        if (!(value = this.mPlugin.receivePrograms(type, programArr, receiveTarget))) {
            JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), mLocalizer.msg("error.noTarget", "The programs for the target \"{0}\" couldn't be processed by \"{1}\".", receiveTarget, this.mPlugin.getInfo().getName()), Localizer.getLocalization("i18n_error"), 0);
        }
        return value;
    }

    @Override
    protected ProgramReceiveTarget[] doGetProgramReceiveTargets() {
        ProgramReceiveTarget[] targets = this.mPlugin.getProgramReceiveTargets();
        return targets != null ? targets : ProgramReceiveTarget.createDefaultTargetArrayForProgramReceiveIf(this.mPlugin);
    }

    @Override
    protected PluginsProgramFilter[] doGetAvailableFilter() {
        return this.mPlugin.getAvailableFilter();
    }

    @Override
    protected boolean doIsAllowedToDeleteProgramFilter(PluginsProgramFilter programFilter) {
        return this.mPlugin.isAllowedToDeleteProgramFilter(programFilter);
    }

    @Override
    protected Class<? extends PluginsFilterComponent>[] doGetAvailableFilterComponentClasses() {
        return this.mPlugin.getAvailableFilterComponentClasses();
    }

    @Override
    protected int doGetMarkPriorityMaxForProgram(Program p) {
        UserFilter filter = GenericFilterMap.getInstance().getGenericPluginFilter(this, true);
        if (p != null && (this.accessControl(p.getChannel()) || filter != null && !filter.accept(p))) {
            return -1;
        }
        return this.mPlugin.getMarkPriorityMaxForProgram(p);
    }

    @Override
    public String getPluginFileName() {
        return this.mPluginFileName;
    }

    public void setPlugin(Plugin plugin, String fileName) {
        this.mPlugin = plugin;
        this.mPluginFileName = fileName;
    }

    @Override
    public Icon getPluginIcon() {
        File iconFile;
        if (this.mPluginIcon == null && this.mIconFileName != null && (iconFile = new File(this.mIconFileName)).canRead()) {
            this.mPluginIcon = IOUtilities.readImageIconFromFile(iconFile);
        }
        if (this.mPluginIcon != null) {
            return this.mPluginIcon;
        }
        return super.getPluginIcon();
    }

    @Override
    public ProgramRatingIf[] getProgramRatingIfs() {
        return this.mPlugin.getRatingInterfaces();
    }

    @Override
    public String getButtonActionDescription() {
        return this.mPlugin.getInfo().getDescription();
    }

    @Override
    protected void doHandleTvDataAdded(MutableChannelDayProgram newProg) {
        if (newProg != null && !this.accessControl(newProg.getChannel())) {
            this.mPlugin.handleTvDataAdded(newProg);
        }
    }

    @Override
    protected boolean doReceiveValues(int type, String[] values, ProgramReceiveTarget receiveTarget) {
        return this.mPlugin.receiveValues(type, values, receiveTarget);
    }

    @Override
    protected void doHandleTvDataTouched(ChannelDayProgram removedDayProgram, ChannelDayProgram addedDayProgram) {
        if (removedDayProgram != null && !this.accessControl(removedDayProgram.getChannel()) || addedDayProgram != null && !this.accessControl(addedDayProgram.getChannel()) || removedDayProgram == null && addedDayProgram == null) {
            this.mPlugin.handleTvDataTouched(removedDayProgram, addedDayProgram);
        }
    }

    @Override
    protected ImportanceValue doGetImportanceValueForProgram(Program p) {
        UserFilter filter = GenericFilterMap.getInstance().getGenericPluginFilter(this, true);
        if (p != null && (this.accessControl(p.getChannel()) || filter != null && !filter.accept(p))) {
            return new ImportanceValue(1, -1);
        }
        return this.mPlugin.getImportanceValueForProgram(p);
    }

    @Override
    public String getPluginCategory() {
        if (this.mPlugin != null) {
            return this.mPlugin.getPluginCategory();
        }
        return this.mPluginCategory;
    }

    @Override
    public PluginCenterPanelWrapper getPluginCenterPanelWrapper() {
        return this.mPlugin.getPluginCenterPanelWrapper();
    }

    @Override
    public AfterDataUpdateInfoPanel getAfterDataUpdateInfoPanel() {
        if (this.mPlugin != null) {
            return this.mPlugin.getAfterDataUpdateInfoPanel();
        }
        return null;
    }

    @Override
    public void handleTvBrowserSettingsChanged() {
        if (this.mPlugin != null) {
            this.mPlugin.handleTvBrowserSettingsChanged();
        }
    }

    @Override
    public void handleTvDataUpdateStarted(Date until) {
        if (this.mPlugin != null) {
            this.mPlugin.handleTvDataUpdateStarted(until);
        }
    }

    @Override
    public PluginCommunication doGetCommunicationClass() {
        if (this.mPlugin != null) {
            return this.mPlugin.getCommunicationClass();
        }
        return null;
    }

    private boolean accessControl(Channel ch) {
        return ch != null && ch.isAccessControl() && this.accessControl();
    }

    private boolean accessControl() {
        if (Settings.Plugins.ACCESS_CONTROL.getStringArray().length > 0) {
            int startIndex = this.mPlugin.getId().indexOf(".") + 1;
            if (Settings.Plugins.ACCESS_CONTROL.containsItem(this.mPlugin.getId().substring(startIndex, this.mPlugin.getId().indexOf(".", startIndex)))) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean doGetAllowsArtificialPluginTree() {
        return this.mPlugin.isAllowingArtificialPluginTree();
    }

    @Override
    protected ToolTipIcon[] doGetProgramTableToolTipIcons(Program program) {
        return this.mPlugin.getProgramTableToolTipIcons(program);
    }

    @Override
    public ProgramInfo[] doGetAddtionalProgramInfoForProgram(Program p, String uniqueId) {
        return this.mPlugin.getAddtionalProgramInfoForProgram(p, uniqueId);
    }

    @Override
    @Deprecated(since="4.2.2")
    public boolean receivePrograms(Program[] programArr, ProgramReceiveTarget receiveTarget) {
        return this.doReceivePrograms(0, programArr, receiveTarget);
    }

    @Override
    @Deprecated(since="4.2.2")
    public boolean receiveValues(String[] values, ProgramReceiveTarget receiveTarget) {
        return this.doReceiveValues(0, values, receiveTarget);
    }

    @Override
    protected boolean doCanReceiveProgramsWithTarget() {
        return this.mPlugin.canReceiveProgramsWithTarget();
    }

    @Override
    protected int[] doGetMarkPrioritiesForProgram(Program p) {
        return this.mPlugin.getMarkPrioritiesForProgram(p);
    }

    @Override
    public PluginProgramInformation doGetProgramInformation(Program p, String informationKey) {
        return this.mPlugin.getProgramInformation(p, informationKey);
    }

    @Override
    protected void doHandleTvBrowserVersionUpdate(Version previousVersion) {
        this.mPlugin.handleTvBrowserVersionUpdate(previousVersion);
    }
}

