/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core;

import devplugin.Channel;
import java.util.Hashtable;
import org.apache.commons.lang3.StringUtils;

public class DuplicateChannelNameCounter {
    private Hashtable<String, Integer> mChannelNames = new Hashtable();
    private Hashtable<String, Integer> mChannelCountryNames = new Hashtable();

    public DuplicateChannelNameCounter(Channel[] channels) {
        this.mChannelNames = new Hashtable();
        for (Channel ch : channels) {
            Integer n;
            Integer n2;
            Object key = this.normalizeName(ch.getDefaultName());
            Integer count = this.mChannelNames.get(key);
            if (count == null) {
                this.mChannelNames.put((String)key, 0);
            } else {
                n2 = count;
                n = count = Integer.valueOf(count + 1);
                this.mChannelNames.put((String)key, count);
            }
            key = (String)key + ch.getBaseCountry().toLowerCase();
            count = this.mChannelCountryNames.get(key);
            if (count == null) {
                this.mChannelCountryNames.put((String)key, 0);
                continue;
            }
            n2 = count;
            n = count = Integer.valueOf(count + 1);
            this.mChannelCountryNames.put((String)key, count);
        }
    }

    private String normalizeName(String name) {
        return StringUtils.remove((String)name.toLowerCase(), (char)' ');
    }

    public boolean isDuplicate(Channel channel) {
        if (channel == null) {
            return false;
        }
        Integer count = this.mChannelNames.get(this.normalizeName(channel.getDefaultName()));
        return count != null && count != 0;
    }

    public boolean isDuplicateIncludingCountry(Channel channel) {
        if (channel == null) {
            return false;
        }
        Integer count = this.mChannelCountryNames.get(this.normalizeName(channel.getDefaultName()) + channel.getBaseCountry().toLowerCase());
        return count != null && count != 0;
    }
}

