/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import devplugin.Channel;
import devplugin.Program;
import devplugin.ProgramFilter;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.filtercomponents.ChannelFilterComponent;
import util.exc.TvBrowserException;

public final class ChannelFilter
implements ProgramFilter {
    private ChannelFilterComponent mChannelFilterComponent;

    private ChannelFilter(String name) throws ClassCastException, TvBrowserException {
        this.mChannelFilterComponent = (ChannelFilterComponent)FilterComponentList.getInstance().getFilterComponentByName(name);
        if (this.mChannelFilterComponent == null) {
            throw new TvBrowserException(ChannelFilter.class, "filterComponentNotFound", "Filter component not found");
        }
    }

    public static ChannelFilter createChannelFilterForName(String name) throws ClassCastException, TvBrowserException {
        return new ChannelFilter(name);
    }

    @Override
    public boolean accept(Program program) {
        return this.mChannelFilterComponent.accept(program);
    }

    @Override
    public String getName() {
        return this.mChannelFilterComponent.getName();
    }

    @Override
    public String toString() {
        return FilterComponentList.getLabelForComponent(this.mChannelFilterComponent, this.getName());
    }

    public Channel[] getChannels() {
        return this.mChannelFilterComponent.getChannels();
    }
}

