/* Based on BoringSSL's server.c fuzzer */

#ifdef __cplusplus
extern "C" {
#endif

#include <hf_ssl_lib.h>
#include <libhfuzz/libhfuzz.h>

#include <assert.h>
#include <openssl/err.h>
#include <openssl/rand.h>
#include <openssl/ssl.h>
#include <openssl/tls1.h>
#include <stdint.h>
#include <string.h>
#include <unistd.h>

static const uint8_t kCertificateDER[] = {0x30, 0x82, 0x06, 0x3a, 0x30, 0x82, 0x04, 0x22, 0xa0,
    0x03, 0x02, 0x01, 0x02, 0x02, 0x14, 0x0f, 0x2d, 0x4d, 0xdd, 0x2f, 0xa5, 0xc0, 0x5f, 0x5a, 0xd3,
    0x6e, 0x9f, 0xbe, 0x29, 0x68, 0xe9, 0x24, 0x72, 0x6c, 0xeb, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86,
    0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x30, 0x81, 0x8d, 0x31, 0x0b, 0x30, 0x09,
    0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55,
    0x04, 0x08, 0x0c, 0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x21,
    0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65,
    0x74, 0x20, 0x57, 0x69, 0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c, 0x74,
    0x64, 0x31, 0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67, 0x61,
    0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x20,
    0x4e, 0x61, 0x6d, 0x65, 0x31, 0x23, 0x30, 0x21, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1a, 0x6e,
    0x6f, 0x6e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65, 0x78,
    0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x63, 0x61, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x39, 0x30,
    0x35, 0x30, 0x38, 0x31, 0x32, 0x35, 0x33, 0x33, 0x32, 0x5a, 0x17, 0x0d, 0x32, 0x39, 0x30, 0x35,
    0x30, 0x37, 0x31, 0x32, 0x35, 0x33, 0x33, 0x32, 0x5a, 0x30, 0x81, 0xa2, 0x31, 0x0b, 0x30, 0x09,
    0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55,
    0x04, 0x08, 0x0c, 0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x0f,
    0x30, 0x0d, 0x06, 0x03, 0x55, 0x04, 0x07, 0x0c, 0x06, 0x53, 0x69, 0x64, 0x6e, 0x65, 0x79, 0x31,
    0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e,
    0x65, 0x74, 0x20, 0x57, 0x69, 0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c,
    0x74, 0x64, 0x31, 0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67,
    0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74,
    0x20, 0x4e, 0x61, 0x6d, 0x65, 0x31, 0x27, 0x30, 0x25, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1e,
    0x6e, 0x6f, 0x6e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65,
    0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x30, 0x82,
    0x02, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05,
    0x00, 0x03, 0x82, 0x02, 0x0f, 0x00, 0x30, 0x82, 0x02, 0x0a, 0x02, 0x82, 0x02, 0x01, 0x00, 0xd0,
    0x4f, 0xad, 0x4c, 0x85, 0x07, 0x3a, 0x17, 0xf7, 0x09, 0x6d, 0xc1, 0x15, 0x13, 0x61, 0x44, 0x97,
    0xe7, 0x09, 0x85, 0x16, 0x11, 0xd3, 0xbb, 0x20, 0x42, 0xc0, 0xfa, 0x07, 0xed, 0x5c, 0x02, 0xc4,
    0x46, 0x3b, 0x64, 0x77, 0xc1, 0x1b, 0xa4, 0x90, 0xc3, 0xd5, 0x16, 0x48, 0x9b, 0xc3, 0x86, 0xbf,
    0xf7, 0xd5, 0x9d, 0x15, 0x7b, 0x3b, 0xb3, 0x30, 0x51, 0x97, 0x40, 0x4e, 0x4e, 0xfc, 0x3a, 0x25,
    0xb9, 0x0e, 0x04, 0x81, 0xb7, 0x7f, 0x88, 0xe3, 0xfe, 0x4f, 0x35, 0x5f, 0x5b, 0x41, 0xd8, 0x12,
    0x05, 0x18, 0xb6, 0x3b, 0x7d, 0x8d, 0x12, 0x8c, 0xa5, 0x9d, 0x75, 0x8b, 0xaf, 0xb6, 0x41, 0x5b,
    0x8b, 0x28, 0x51, 0x1b, 0x06, 0xa9, 0xf1, 0xca, 0x5b, 0x10, 0x75, 0xad, 0x60, 0xd4, 0x5f, 0x65,
    0x93, 0x4c, 0x8c, 0x09, 0xfc, 0xdc, 0x7c, 0xaf, 0xb0, 0xc7, 0x37, 0x4c, 0x4b, 0xe4, 0x22, 0x89,
    0x9b, 0x0d, 0xd5, 0x34, 0x73, 0xc2, 0xe3, 0x3d, 0xa7, 0x26, 0x4c, 0x94, 0xaf, 0x8a, 0x26, 0x5b,
    0xea, 0x45, 0x55, 0xe4, 0x6d, 0x4b, 0xd7, 0xc9, 0xce, 0xf5, 0xec, 0x55, 0x8e, 0x68, 0x9a, 0x1e,
    0xf1, 0x96, 0x0a, 0x8e, 0x1e, 0xd2, 0xdf, 0x09, 0x93, 0x18, 0x02, 0x13, 0x29, 0x7d, 0x4d, 0x1e,
    0x32, 0x6a, 0x75, 0x62, 0x32, 0x9f, 0x0e, 0x08, 0x7e, 0xbb, 0x25, 0xc6, 0x46, 0xa2, 0x29, 0x85,
    0x9c, 0x49, 0xd4, 0xfa, 0x6b, 0x11, 0x41, 0x4e, 0x77, 0x4d, 0x5a, 0x14, 0xe1, 0xef, 0x78, 0x07,
    0x31, 0xe2, 0xdf, 0xdb, 0xaa, 0xef, 0x51, 0x10, 0x7a, 0x78, 0x85, 0x23, 0x34, 0x02, 0x27, 0x2d,
    0x3c, 0x3e, 0x82, 0x44, 0x2d, 0x63, 0x0e, 0x95, 0x63, 0x4f, 0xf0, 0x42, 0x9e, 0x8d, 0x41, 0x9a,
    0x11, 0x97, 0xc2, 0x41, 0x75, 0xaf, 0x0c, 0x7a, 0xda, 0x8d, 0x5b, 0x1c, 0x78, 0xcd, 0xa9, 0xbf,
    0x88, 0xab, 0x5d, 0x37, 0x2e, 0x24, 0xec, 0x56, 0x0f, 0x8e, 0x30, 0x47, 0xb5, 0x4d, 0x5e, 0xbe,
    0x1d, 0x0c, 0xe5, 0xb5, 0x9b, 0xe3, 0xf9, 0xc1, 0x96, 0xe1, 0xef, 0x1d, 0x8b, 0x63, 0x4b, 0xc4,
    0xee, 0x35, 0xe1, 0x65, 0x48, 0x63, 0x2d, 0x6a, 0x2b, 0xb4, 0xde, 0x50, 0x8b, 0xbe, 0x47, 0x0b,
    0x8d, 0x8e, 0xfd, 0x0f, 0x30, 0xdf, 0x66, 0xec, 0x16, 0xa4, 0x62, 0x34, 0x78, 0x09, 0x6b, 0xb0,
    0xbb, 0xc5, 0x55, 0x71, 0x93, 0xd2, 0x6b, 0xa7, 0xce, 0x01, 0x58, 0x5a, 0xa6, 0x97, 0x95, 0xb3,
    0x86, 0x9e, 0x78, 0xd5, 0x4a, 0xb2, 0x0c, 0xc2, 0xa0, 0xad, 0x30, 0x77, 0x48, 0x9f, 0xd4, 0xc8,
    0x62, 0x27, 0x83, 0x7e, 0xbb, 0x42, 0xf4, 0x29, 0xb4, 0x49, 0x8a, 0x6c, 0x4a, 0xec, 0x24, 0x47,
    0xd5, 0x53, 0x8a, 0xa2, 0x8c, 0x94, 0xd2, 0x02, 0x9f, 0xf1, 0x5e, 0xe7, 0x5a, 0x03, 0xff, 0x2a,
    0x09, 0xfd, 0xcb, 0x47, 0xe8, 0x3f, 0x8f, 0x54, 0xe3, 0x9e, 0xef, 0x19, 0x36, 0xe9, 0xcb, 0x38,
    0x6a, 0x76, 0xf7, 0x55, 0x9d, 0x1b, 0xd6, 0x87, 0x4c, 0xfb, 0xd1, 0x5f, 0xe6, 0x9a, 0xef, 0xa6,
    0x61, 0xad, 0xcb, 0x70, 0x63, 0x33, 0x7f, 0x26, 0x44, 0x29, 0x20, 0xcc, 0xf7, 0xb8, 0xd3, 0x59,
    0xc2, 0x86, 0xeb, 0xda, 0xea, 0x64, 0xd7, 0x13, 0x5b, 0x61, 0x08, 0x38, 0x6f, 0x24, 0xf7, 0x17,
    0xc8, 0x8c, 0x5c, 0x9f, 0xfc, 0x12, 0x73, 0x86, 0x53, 0xd9, 0x85, 0x54, 0x8d, 0x12, 0x49, 0xd5,
    0x6b, 0x01, 0xc0, 0x84, 0x93, 0x48, 0x20, 0x1f, 0x98, 0x33, 0x53, 0x39, 0xf0, 0x21, 0x71, 0x3d,
    0x3c, 0x9c, 0xba, 0x0d, 0x99, 0x75, 0x7f, 0x91, 0xed, 0x22, 0xac, 0xcf, 0xa1, 0x57, 0x38, 0x94,
    0xb0, 0x85, 0xff, 0x8c, 0x9b, 0xdc, 0x20, 0xac, 0xa4, 0xc0, 0x22, 0x79, 0xa2, 0xe4, 0x1d, 0x02,
    0x03, 0x01, 0x00, 0x01, 0xa3, 0x7b, 0x30, 0x79, 0x30, 0x09, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x04,
    0x02, 0x30, 0x00, 0x30, 0x2c, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x86, 0xf8, 0x42, 0x01, 0x0d,
    0x04, 0x1f, 0x16, 0x1d, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x53, 0x4c, 0x20, 0x47, 0x65, 0x6e, 0x65,
    0x72, 0x61, 0x74, 0x65, 0x64, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
    0x65, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x43, 0x8c, 0x8e, 0x2f,
    0xe6, 0xa5, 0xfc, 0x81, 0xa1, 0x21, 0x71, 0x60, 0x24, 0x97, 0xb0, 0x22, 0xf2, 0x3b, 0xc2, 0xfc,
    0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xb4, 0x59, 0x44,
    0x9c, 0xe3, 0x18, 0xd1, 0x69, 0x15, 0x4a, 0x38, 0x8b, 0x82, 0x0d, 0x19, 0x83, 0x1f, 0xe0, 0x02,
    0x37, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00,
    0x03, 0x82, 0x02, 0x01, 0x00, 0x36, 0xb9, 0x48, 0x88, 0x84, 0xe9, 0xec, 0x49, 0x50, 0xe5, 0x43,
    0x3e, 0x6f, 0x46, 0xef, 0x76, 0x8e, 0x5e, 0x34, 0xf7, 0x17, 0x6b, 0x87, 0x3d, 0xa3, 0x9b, 0x4e,
    0x89, 0xfe, 0x9d, 0xc0, 0x1d, 0x80, 0xbd, 0xbd, 0x37, 0xd8, 0x46, 0x4a, 0x70, 0x40, 0xa0, 0x34,
    0xd0, 0xa2, 0x6b, 0x56, 0x1c, 0x35, 0xd3, 0x20, 0xeb, 0x99, 0x09, 0x0d, 0x91, 0xd8, 0x1c, 0x8b,
    0x73, 0xdd, 0x98, 0x28, 0xb3, 0xfd, 0x69, 0xfe, 0xdb, 0xd6, 0x9a, 0x21, 0xce, 0x6c, 0xc0, 0xa3,
    0xd4, 0xcc, 0x4c, 0xaa, 0xb2, 0x5e, 0x09, 0xab, 0x6b, 0x1c, 0xf2, 0x88, 0xfc, 0xb8, 0x1c, 0x34,
    0x78, 0x27, 0x0b, 0xb3, 0xfc, 0x6c, 0x56, 0xb4, 0xf8, 0xba, 0xb3, 0xb4, 0x87, 0x52, 0xa8, 0xf7,
    0xf3, 0xde, 0x96, 0x74, 0x72, 0xcd, 0xf6, 0x01, 0x44, 0x04, 0x20, 0x60, 0x10, 0xd8, 0xc2, 0xab,
    0x9a, 0x07, 0x11, 0xf9, 0x2e, 0xc1, 0xff, 0x5d, 0x2e, 0xf5, 0xe4, 0xf0, 0x57, 0x52, 0x20, 0x8f,
    0x6b, 0x1d, 0x5f, 0x87, 0x31, 0x33, 0x5d, 0x75, 0x3f, 0x23, 0xd3, 0x60, 0x94, 0x7b, 0x1d, 0x66,
    0xcc, 0x43, 0xe4, 0xd8, 0xe0, 0xca, 0x82, 0xd9, 0x66, 0x01, 0x4b, 0xfc, 0x73, 0xc0, 0x7b, 0xa5,
    0xaf, 0x4a, 0x0f, 0x1d, 0x4e, 0xbb, 0x7c, 0x53, 0x60, 0x81, 0x71, 0x4f, 0x0c, 0x4b, 0x25, 0x6e,
    0xca, 0xc7, 0x60, 0xaa, 0x0f, 0x62, 0x31, 0x27, 0x40, 0x84, 0x72, 0x05, 0x39, 0x00, 0x94, 0x77,
    0x46, 0xdb, 0x04, 0x51, 0xaf, 0x58, 0x7b, 0x1a, 0x4c, 0x05, 0x88, 0x77, 0x25, 0x24, 0x88, 0x72,
    0x9b, 0xd3, 0xea, 0x9f, 0xfe, 0x23, 0x2f, 0x6e, 0xb6, 0xba, 0xfc, 0x35, 0x1f, 0xbe, 0x0d, 0x79,
    0x47, 0xfb, 0x47, 0xb0, 0x5a, 0x93, 0x23, 0x9c, 0x09, 0x23, 0x37, 0x65, 0x18, 0xe6, 0x0c, 0x6a,
    0x74, 0xcb, 0x75, 0xc7, 0x22, 0x29, 0xdd, 0xfb, 0x4f, 0xf1, 0xe7, 0x33, 0xcf, 0xa9, 0x62, 0xb3,
    0x06, 0xda, 0x28, 0x20, 0x4d, 0x73, 0xd3, 0xc5, 0xbb, 0x6c, 0xb0, 0x44, 0x34, 0xbf, 0x15, 0x29,
    0x71, 0x8f, 0xac, 0xa1, 0xd3, 0xf5, 0x29, 0xb6, 0x42, 0x87, 0xbd, 0xd3, 0xae, 0xea, 0x8c, 0xc0,
    0xa8, 0xc2, 0xe1, 0xa4, 0x74, 0x8c, 0x21, 0x6d, 0x91, 0xa3, 0x98, 0x41, 0xf3, 0xb9, 0x84, 0x88,
    0x51, 0x22, 0xb4, 0x6f, 0xdb, 0x06, 0xa2, 0xfc, 0x56, 0x85, 0xa9, 0xed, 0xce, 0x1d, 0x70, 0xb1,
    0x5c, 0xec, 0x49, 0xc1, 0x48, 0x9f, 0x9d, 0x27, 0x1f, 0xa0, 0x90, 0x9d, 0xab, 0x74, 0x4f, 0xb7,
    0x27, 0x60, 0xe7, 0xc3, 0xac, 0xf2, 0xfd, 0x6b, 0x5d, 0x59, 0xa8, 0x24, 0xfc, 0xbd, 0xb3, 0xe5,
    0x3b, 0x36, 0xc4, 0x56, 0x7e, 0x56, 0x11, 0x41, 0xce, 0xc2, 0xd2, 0xe2, 0x6e, 0x2b, 0xae, 0xad,
    0x71, 0xce, 0x93, 0x03, 0x28, 0x80, 0x33, 0xf2, 0xf6, 0xe5, 0x9c, 0x3f, 0xe2, 0x20, 0x4c, 0xfa,
    0x05, 0xdd, 0xb3, 0xff, 0x76, 0x81, 0x18, 0x01, 0x7a, 0x89, 0xa1, 0x0b, 0x72, 0x0e, 0x07, 0x1e,
    0xd6, 0x08, 0x42, 0xc8, 0xf9, 0xc8, 0xf7, 0x0e, 0x64, 0x65, 0x69, 0xc2, 0x3c, 0xab, 0x13, 0xc9,
    0xd7, 0xf2, 0x3c, 0x02, 0xd4, 0x78, 0xcd, 0xa3, 0x3e, 0xdf, 0xd9, 0x6e, 0xd8, 0x80, 0xaa, 0xba,
    0x8c, 0xe4, 0x1f, 0xb9, 0x01, 0xbb, 0x94, 0x22, 0x66, 0x71, 0x62, 0x30, 0xfc, 0xa4, 0x49, 0xe1,
    0x12, 0x24, 0xf1, 0x89, 0x5e, 0xca, 0xe3, 0xba, 0x20, 0x99, 0x86, 0x20, 0xfd, 0x99, 0xa1, 0xd8,
    0x52, 0x10, 0xd1, 0xff, 0xc3, 0x40, 0x27, 0x56, 0xfd, 0xf0, 0xfd, 0xb8, 0x8b, 0x54, 0x03, 0xc6,
    0xa3, 0xff, 0xe0, 0xf7, 0xaa, 0x03, 0x85, 0x03, 0xae, 0x4a, 0xc1, 0xe6, 0x56, 0xeb, 0x2a, 0x10,
    0xef, 0x48, 0x32, 0x04, 0x64};

static const uint8_t kRSAPrivateKeyDER[] = {0x30, 0x82, 0x09, 0x28, 0x02, 0x01, 0x00, 0x02, 0x82,
    0x02, 0x01, 0x00, 0xd0, 0x4f, 0xad, 0x4c, 0x85, 0x07, 0x3a, 0x17, 0xf7, 0x09, 0x6d, 0xc1, 0x15,
    0x13, 0x61, 0x44, 0x97, 0xe7, 0x09, 0x85, 0x16, 0x11, 0xd3, 0xbb, 0x20, 0x42, 0xc0, 0xfa, 0x07,
    0xed, 0x5c, 0x02, 0xc4, 0x46, 0x3b, 0x64, 0x77, 0xc1, 0x1b, 0xa4, 0x90, 0xc3, 0xd5, 0x16, 0x48,
    0x9b, 0xc3, 0x86, 0xbf, 0xf7, 0xd5, 0x9d, 0x15, 0x7b, 0x3b, 0xb3, 0x30, 0x51, 0x97, 0x40, 0x4e,
    0x4e, 0xfc, 0x3a, 0x25, 0xb9, 0x0e, 0x04, 0x81, 0xb7, 0x7f, 0x88, 0xe3, 0xfe, 0x4f, 0x35, 0x5f,
    0x5b, 0x41, 0xd8, 0x12, 0x05, 0x18, 0xb6, 0x3b, 0x7d, 0x8d, 0x12, 0x8c, 0xa5, 0x9d, 0x75, 0x8b,
    0xaf, 0xb6, 0x41, 0x5b, 0x8b, 0x28, 0x51, 0x1b, 0x06, 0xa9, 0xf1, 0xca, 0x5b, 0x10, 0x75, 0xad,
    0x60, 0xd4, 0x5f, 0x65, 0x93, 0x4c, 0x8c, 0x09, 0xfc, 0xdc, 0x7c, 0xaf, 0xb0, 0xc7, 0x37, 0x4c,
    0x4b, 0xe4, 0x22, 0x89, 0x9b, 0x0d, 0xd5, 0x34, 0x73, 0xc2, 0xe3, 0x3d, 0xa7, 0x26, 0x4c, 0x94,
    0xaf, 0x8a, 0x26, 0x5b, 0xea, 0x45, 0x55, 0xe4, 0x6d, 0x4b, 0xd7, 0xc9, 0xce, 0xf5, 0xec, 0x55,
    0x8e, 0x68, 0x9a, 0x1e, 0xf1, 0x96, 0x0a, 0x8e, 0x1e, 0xd2, 0xdf, 0x09, 0x93, 0x18, 0x02, 0x13,
    0x29, 0x7d, 0x4d, 0x1e, 0x32, 0x6a, 0x75, 0x62, 0x32, 0x9f, 0x0e, 0x08, 0x7e, 0xbb, 0x25, 0xc6,
    0x46, 0xa2, 0x29, 0x85, 0x9c, 0x49, 0xd4, 0xfa, 0x6b, 0x11, 0x41, 0x4e, 0x77, 0x4d, 0x5a, 0x14,
    0xe1, 0xef, 0x78, 0x07, 0x31, 0xe2, 0xdf, 0xdb, 0xaa, 0xef, 0x51, 0x10, 0x7a, 0x78, 0x85, 0x23,
    0x34, 0x02, 0x27, 0x2d, 0x3c, 0x3e, 0x82, 0x44, 0x2d, 0x63, 0x0e, 0x95, 0x63, 0x4f, 0xf0, 0x42,
    0x9e, 0x8d, 0x41, 0x9a, 0x11, 0x97, 0xc2, 0x41, 0x75, 0xaf, 0x0c, 0x7a, 0xda, 0x8d, 0x5b, 0x1c,
    0x78, 0xcd, 0xa9, 0xbf, 0x88, 0xab, 0x5d, 0x37, 0x2e, 0x24, 0xec, 0x56, 0x0f, 0x8e, 0x30, 0x47,
    0xb5, 0x4d, 0x5e, 0xbe, 0x1d, 0x0c, 0xe5, 0xb5, 0x9b, 0xe3, 0xf9, 0xc1, 0x96, 0xe1, 0xef, 0x1d,
    0x8b, 0x63, 0x4b, 0xc4, 0xee, 0x35, 0xe1, 0x65, 0x48, 0x63, 0x2d, 0x6a, 0x2b, 0xb4, 0xde, 0x50,
    0x8b, 0xbe, 0x47, 0x0b, 0x8d, 0x8e, 0xfd, 0x0f, 0x30, 0xdf, 0x66, 0xec, 0x16, 0xa4, 0x62, 0x34,
    0x78, 0x09, 0x6b, 0xb0, 0xbb, 0xc5, 0x55, 0x71, 0x93, 0xd2, 0x6b, 0xa7, 0xce, 0x01, 0x58, 0x5a,
    0xa6, 0x97, 0x95, 0xb3, 0x86, 0x9e, 0x78, 0xd5, 0x4a, 0xb2, 0x0c, 0xc2, 0xa0, 0xad, 0x30, 0x77,
    0x48, 0x9f, 0xd4, 0xc8, 0x62, 0x27, 0x83, 0x7e, 0xbb, 0x42, 0xf4, 0x29, 0xb4, 0x49, 0x8a, 0x6c,
    0x4a, 0xec, 0x24, 0x47, 0xd5, 0x53, 0x8a, 0xa2, 0x8c, 0x94, 0xd2, 0x02, 0x9f, 0xf1, 0x5e, 0xe7,
    0x5a, 0x03, 0xff, 0x2a, 0x09, 0xfd, 0xcb, 0x47, 0xe8, 0x3f, 0x8f, 0x54, 0xe3, 0x9e, 0xef, 0x19,
    0x36, 0xe9, 0xcb, 0x38, 0x6a, 0x76, 0xf7, 0x55, 0x9d, 0x1b, 0xd6, 0x87, 0x4c, 0xfb, 0xd1, 0x5f,
    0xe6, 0x9a, 0xef, 0xa6, 0x61, 0xad, 0xcb, 0x70, 0x63, 0x33, 0x7f, 0x26, 0x44, 0x29, 0x20, 0xcc,
    0xf7, 0xb8, 0xd3, 0x59, 0xc2, 0x86, 0xeb, 0xda, 0xea, 0x64, 0xd7, 0x13, 0x5b, 0x61, 0x08, 0x38,
    0x6f, 0x24, 0xf7, 0x17, 0xc8, 0x8c, 0x5c, 0x9f, 0xfc, 0x12, 0x73, 0x86, 0x53, 0xd9, 0x85, 0x54,
    0x8d, 0x12, 0x49, 0xd5, 0x6b, 0x01, 0xc0, 0x84, 0x93, 0x48, 0x20, 0x1f, 0x98, 0x33, 0x53, 0x39,
    0xf0, 0x21, 0x71, 0x3d, 0x3c, 0x9c, 0xba, 0x0d, 0x99, 0x75, 0x7f, 0x91, 0xed, 0x22, 0xac, 0xcf,
    0xa1, 0x57, 0x38, 0x94, 0xb0, 0x85, 0xff, 0x8c, 0x9b, 0xdc, 0x20, 0xac, 0xa4, 0xc0, 0x22, 0x79,
    0xa2, 0xe4, 0x1d, 0x02, 0x03, 0x01, 0x00, 0x01, 0x02, 0x82, 0x02, 0x00, 0x36, 0x5f, 0x35, 0xaa,
    0xad, 0x66, 0x4f, 0x81, 0x85, 0xd7, 0x8e, 0x30, 0x41, 0xa2, 0x07, 0x57, 0x72, 0x16, 0xb9, 0xe3,
    0x64, 0xf9, 0x4e, 0x3c, 0x9f, 0x95, 0x0c, 0xed, 0xb6, 0x37, 0xfc, 0x36, 0x34, 0xa8, 0xe8, 0x43,
    0xb7, 0x06, 0x4e, 0x82, 0xcb, 0xce, 0x71, 0xc6, 0x19, 0x39, 0x9e, 0xf5, 0x83, 0x11, 0xdb, 0x4d,
    0xdf, 0x17, 0x85, 0x63, 0xa6, 0x0f, 0x05, 0xdd, 0xa1, 0x12, 0xf8, 0xbe, 0xec, 0xad, 0xba, 0xbc,
    0xee, 0x66, 0xc9, 0x01, 0x20, 0x11, 0x76, 0xf7, 0x45, 0x66, 0x7a, 0x6f, 0x3d, 0x74, 0xdb, 0x18,
    0x65, 0xba, 0xc5, 0xa1, 0xbb, 0xd8, 0x56, 0x9b, 0x21, 0xd4, 0xc1, 0x4b, 0x99, 0xeb, 0x5e, 0xa0,
    0x9c, 0xdf, 0x46, 0x68, 0x78, 0x1b, 0x00, 0xd6, 0xd6, 0x64, 0x59, 0xca, 0x74, 0xa6, 0xd7, 0xea,
    0x0d, 0x89, 0x54, 0xbb, 0xae, 0xd8, 0x03, 0x87, 0xa9, 0x80, 0x7d, 0x91, 0x8e, 0x3d, 0x4c, 0x85,
    0x03, 0xe5, 0xdb, 0x4e, 0x98, 0xff, 0x11, 0xfe, 0x17, 0x29, 0x22, 0x74, 0x14, 0xb5, 0xb7, 0x57,
    0x4e, 0x02, 0x41, 0x33, 0x97, 0xd7, 0x4f, 0x55, 0x5a, 0x97, 0x8b, 0x31, 0xff, 0x35, 0xab, 0xa6,
    0x21, 0xa6, 0x66, 0x00, 0x15, 0x6d, 0xb1, 0x6c, 0x89, 0x37, 0xe1, 0x1e, 0xc9, 0xec, 0xfa, 0xe0,
    0x9c, 0xba, 0xfd, 0xcd, 0x19, 0xe6, 0x8a, 0x4e, 0xb7, 0xcc, 0x23, 0xf3, 0x96, 0x8e, 0x4e, 0xaf,
    0x2a, 0x95, 0xdb, 0xb1, 0x22, 0x1b, 0xfd, 0xb2, 0xaf, 0x94, 0xb1, 0x7e, 0xb0, 0xd2, 0x12, 0x97,
    0xbf, 0xac, 0x84, 0x3e, 0xb2, 0x80, 0x65, 0x08, 0xcb, 0x41, 0x7d, 0xf6, 0x5f, 0xd6, 0x43, 0xb2,
    0x98, 0xbd, 0x08, 0x07, 0xfc, 0x72, 0x29, 0xa1, 0x5a, 0xa2, 0x2b, 0xd8, 0x9d, 0xb0, 0x4d, 0xde,
    0x44, 0x5b, 0xc5, 0x4f, 0x0a, 0x9a, 0x15, 0x1f, 0x5c, 0xf5, 0x23, 0x28, 0xdc, 0xb7, 0x34, 0x87,
    0x24, 0xf0, 0xfe, 0xc0, 0xe6, 0x0d, 0xf9, 0xc5, 0xd6, 0x6a, 0x15, 0x82, 0x40, 0x2c, 0x2e, 0xa2,
    0x2d, 0x02, 0x15, 0x6c, 0x90, 0x21, 0x55, 0x09, 0x4d, 0x6b, 0x51, 0x1e, 0xa8, 0x63, 0x1f, 0x7e,
    0x0c, 0x7b, 0x18, 0xad, 0xcc, 0x91, 0x52, 0xbe, 0x4f, 0x0f, 0xb0, 0xdd, 0xb9, 0xbe, 0x27, 0x6a,
    0x25, 0x06, 0x63, 0x16, 0x91, 0x61, 0xae, 0x1a, 0xcf, 0xef, 0xc0, 0x99, 0x10, 0x3a, 0x37, 0x9c,
    0x5f, 0x2e, 0x84, 0xa4, 0xee, 0xae, 0xcb, 0x2b, 0x06, 0x4c, 0x3b, 0x13, 0x30, 0x2e, 0x14, 0xb9,
    0x04, 0x84, 0x55, 0x00, 0xf2, 0xcc, 0xeb, 0x42, 0x7c, 0x89, 0xf8, 0x8f, 0x1a, 0x52, 0x7f, 0xec,
    0xc3, 0x4c, 0x5a, 0xee, 0xe3, 0x2e, 0x47, 0xaa, 0xbb, 0xd7, 0x62, 0xc6, 0x0c, 0x34, 0x63, 0x52,
    0xf3, 0x09, 0xb3, 0x35, 0x8e, 0xb2, 0x8b, 0x57, 0x2b, 0x33, 0x69, 0x8e, 0xa7, 0x9d, 0x02, 0x86,
    0x9b, 0x2e, 0xbc, 0x14, 0x56, 0x17, 0xda, 0xd6, 0x09, 0x9e, 0x35, 0x8b, 0x82, 0x53, 0x89, 0xe5,
    0x7a, 0x22, 0x2d, 0x64, 0x0e, 0xb3, 0xff, 0x51, 0xa5, 0x01, 0x15, 0x5a, 0x8c, 0x77, 0xf6, 0xa8,
    0x2e, 0x67, 0x63, 0x82, 0x68, 0x32, 0x9c, 0xa3, 0xe7, 0x08, 0x52, 0x6a, 0x3a, 0x57, 0x37, 0xfa,
    0x08, 0x81, 0x5e, 0x0d, 0x5a, 0xa0, 0x1c, 0x89, 0x88, 0xfc, 0x2c, 0x6b, 0xfc, 0x04, 0x3e, 0xa3,
    0x64, 0x55, 0x72, 0xf5, 0x15, 0x4d, 0x2a, 0x2b, 0x34, 0x21, 0xc9, 0xca, 0xf4, 0xf3, 0x03, 0x9c,
    0x24, 0x4c, 0x11, 0x78, 0xd4, 0xd2, 0x92, 0xe7, 0xd7, 0x5d, 0xe1, 0x04, 0x98, 0xa6, 0xf6, 0xc7,
    0x20, 0x4e, 0x72, 0x1c, 0x70, 0xbb, 0x1c, 0xcb, 0xa4, 0x86, 0x07, 0x3d, 0xab, 0x01, 0x7c, 0x7d,
    0xc1, 0x90, 0x55, 0x3d, 0xd3, 0x66, 0xbb, 0x59, 0xb2, 0x6c, 0x82, 0x41, 0x02, 0x82, 0x01, 0x01,
    0x00, 0xf4, 0x95, 0x3e, 0x30, 0x1a, 0x3f, 0x6b, 0xd4, 0x3b, 0xe8, 0x10, 0x54, 0xf4, 0xba, 0xd9,
    0xf3, 0xd8, 0x93, 0x7b, 0xb0, 0xb7, 0x13, 0x6e, 0x26, 0x5d, 0x1f, 0x24, 0x9c, 0x6b, 0xee, 0xa6,
    0x8f, 0x8c, 0x18, 0x18, 0x5c, 0xe5, 0xad, 0x28, 0xb5, 0x30, 0x85, 0x2e, 0x49, 0x42, 0x05, 0x79,
    0x56, 0xdb, 0x9b, 0xcc, 0xd4, 0x24, 0xcc, 0x6c, 0xd4, 0x51, 0x49, 0xe6, 0x67, 0x98, 0xf6, 0xb7,
    0x31, 0x00, 0x8f, 0xfc, 0x48, 0x1b, 0xb4, 0x83, 0x0e, 0x52, 0x65, 0xe9, 0x74, 0x9a, 0x3c, 0x3d,
    0x52, 0x63, 0xf7, 0x73, 0x64, 0xf0, 0xbd, 0x88, 0xbb, 0x55, 0xbf, 0xdb, 0x82, 0x44, 0x52, 0x4e,
    0xdf, 0x15, 0x69, 0x43, 0xda, 0x83, 0xb0, 0xe1, 0xf6, 0x28, 0xf9, 0xaa, 0x66, 0x74, 0xce, 0xad,
    0xfd, 0x9f, 0x3a, 0x77, 0x78, 0x85, 0x7d, 0xda, 0xd7, 0xff, 0x94, 0x24, 0xba, 0x47, 0x3b, 0xc5,
    0xda, 0xb2, 0xae, 0xdd, 0x70, 0x3c, 0x23, 0x39, 0xc9, 0xb6, 0x73, 0xdf, 0x0a, 0xa6, 0x78, 0x68,
    0xfd, 0x05, 0x4c, 0x3a, 0x61, 0xc3, 0x87, 0x1e, 0x1c, 0x7e, 0x7d, 0x31, 0x6b, 0x44, 0x46, 0x4e,
    0x98, 0xb5, 0xad, 0xa9, 0xf6, 0x4c, 0xc9, 0xf8, 0x56, 0x0b, 0xd9, 0x5b, 0x15, 0x05, 0xc6, 0xe6,
    0xee, 0x41, 0xce, 0x6a, 0x9a, 0xf1, 0x1b, 0x17, 0xf9, 0xf6, 0x78, 0xe1, 0xa4, 0x15, 0x5a, 0x77,
    0x35, 0x10, 0x1b, 0x60, 0x61, 0xa1, 0x3f, 0x0a, 0x88, 0x65, 0x2c, 0x28, 0x65, 0x3c, 0x20, 0x9f,
    0x72, 0xc3, 0xa6, 0xdb, 0x02, 0x1b, 0x36, 0xd9, 0xf3, 0x78, 0x36, 0x88, 0x35, 0x93, 0x69, 0xf2,
    0x49, 0xd4, 0x37, 0x10, 0xcd, 0x8d, 0xc5, 0x53, 0x43, 0x9e, 0x26, 0x24, 0x9b, 0x92, 0xc5, 0xb1,
    0x63, 0x13, 0x53, 0x2e, 0xda, 0x7a, 0x16, 0x17, 0x9d, 0xac, 0xc1, 0x4f, 0x4d, 0x90, 0x54, 0x98,
    0x69, 0x02, 0x82, 0x01, 0x01, 0x00, 0xda, 0x08, 0xfc, 0xf5, 0xa8, 0xa5, 0xfe, 0xc6, 0x70, 0x31,
    0x5f, 0x17, 0x27, 0x47, 0xbb, 0xe0, 0x24, 0x25, 0x86, 0x93, 0x7d, 0xea, 0x63, 0x59, 0x40, 0x29,
    0xb8, 0xcb, 0x3f, 0xc6, 0x7b, 0xa2, 0xba, 0x69, 0x3a, 0x62, 0x2b, 0x01, 0x10, 0xf8, 0xca, 0x4a,
    0x51, 0x8c, 0xcc, 0x77, 0x7c, 0x05, 0x21, 0x40, 0x02, 0xbf, 0x1a, 0x55, 0x7a, 0xf8, 0x10, 0x55,
    0xcd, 0xce, 0x19, 0x72, 0x49, 0xaf, 0xcb, 0xbf, 0x8e, 0xa5, 0xda, 0x1f, 0xc8, 0xb6, 0x91, 0x6c,
    0x22, 0xe0, 0x86, 0xed, 0xd9, 0x54, 0x2c, 0x4f, 0xbb, 0x1e, 0x87, 0x98, 0x6c, 0x31, 0xd9, 0xdb,
    0xe8, 0xd3, 0x77, 0x59, 0x03, 0x27, 0x29, 0x71, 0xf4, 0xe1, 0xa6, 0xd3, 0xee, 0x4e, 0xd0, 0x9c,
    0xc4, 0x8a, 0x02, 0x49, 0xe3, 0xbc, 0xe5, 0xce, 0xad, 0x63, 0x66, 0x96, 0x9c, 0x0e, 0x84, 0x1b,
    0x6c, 0x3d, 0x53, 0x4e, 0x73, 0x44, 0xdd, 0x2f, 0xb1, 0xc4, 0x2b, 0x07, 0x08, 0x0f, 0x84, 0x18,
    0x28, 0x52, 0xc4, 0x64, 0x6c, 0x5d, 0xe6, 0x82, 0x4a, 0xef, 0x9a, 0x4a, 0xcb, 0xeb, 0x00, 0x0a,
    0x83, 0xd3, 0xae, 0x37, 0xa7, 0x6c, 0xda, 0x37, 0xa2, 0x7e, 0xa7, 0x08, 0x37, 0x73, 0xc1, 0x6a,
    0xc3, 0x2c, 0x60, 0xbb, 0xc4, 0x98, 0xe8, 0x66, 0xc5, 0x86, 0xfd, 0xd0, 0x0a, 0x49, 0x4d, 0xa6,
    0x7f, 0x9b, 0x20, 0xa1, 0x7b, 0xae, 0x54, 0x2d, 0x3c, 0xa0, 0xa6, 0x11, 0xf4, 0xb1, 0xde, 0x1b,
    0x19, 0x4f, 0x4a, 0xc8, 0x5e, 0x2d, 0x33, 0x23, 0xc5, 0xc7, 0xa9, 0x61, 0x5f, 0x58, 0x59, 0x45,
    0x3c, 0xee, 0xfb, 0xe4, 0x40, 0x6a, 0xc2, 0x8d, 0x4a, 0xd2, 0x90, 0x16, 0x6c, 0xb8, 0x1f, 0x9a,
    0x5f, 0x54, 0xf3, 0xae, 0x7c, 0x43, 0xad, 0x7e, 0xde, 0xe4, 0xb0, 0x9d, 0xe8, 0xef, 0x75, 0xbf,
    0x9a, 0x21, 0x4c, 0x76, 0xd7, 0x95, 0x02, 0x82, 0x01, 0x01, 0x00, 0xe1, 0x82, 0x41, 0xa6, 0x84,
    0x6c, 0xf9, 0x74, 0xe4, 0x0f, 0x62, 0x0f, 0x92, 0xde, 0x3d, 0x5b, 0x11, 0xd3, 0x59, 0xf6, 0x63,
    0xb6, 0xac, 0x96, 0xfe, 0xc1, 0x5a, 0x36, 0x47, 0x65, 0xf1, 0x78, 0xe5, 0x48, 0xca, 0x1d, 0xcd,
    0x3e, 0xcd, 0x0b, 0xd2, 0xc2, 0xd9, 0x1c, 0x7e, 0x9d, 0x21, 0x75, 0xae, 0x62, 0x86, 0x87, 0x0b,
    0xae, 0xd8, 0xa1, 0x22, 0x9a, 0x2a, 0xb0, 0x56, 0x5f, 0x14, 0x25, 0x40, 0x49, 0x81, 0xe8, 0xd2,
    0x72, 0xab, 0x6b, 0xa7, 0x19, 0x84, 0x19, 0x18, 0xa4, 0x76, 0x3d, 0xe3, 0x22, 0x22, 0xe9, 0x6c,
    0xf6, 0xb4, 0x7d, 0x55, 0xe0, 0xe1, 0xf9, 0xc8, 0x18, 0xc3, 0xd3, 0xf8, 0x9f, 0xe8, 0x0a, 0x2f,
    0xe6, 0x05, 0x51, 0xbc, 0x12, 0x06, 0xc5, 0x14, 0xea, 0x03, 0x8e, 0x97, 0x23, 0x87, 0x48, 0x3e,
    0x7c, 0xfe, 0x2c, 0xad, 0xdf, 0xdf, 0xc5, 0x49, 0x2c, 0x99, 0x8e, 0xbd, 0xb5, 0x71, 0x42, 0xac,
    0x90, 0x26, 0x16, 0x0f, 0xfd, 0xe2, 0x26, 0xa5, 0xba, 0xdb, 0xc2, 0x7f, 0x01, 0xfb, 0xca, 0x6c,
    0x47, 0xc6, 0xc1, 0xaa, 0xf6, 0xaf, 0x7c, 0x21, 0xa5, 0x59, 0x8e, 0x7f, 0xe4, 0xb1, 0x93, 0x00,
    0xd6, 0x2f, 0xfc, 0xd6, 0x4c, 0x00, 0x28, 0xef, 0xfc, 0xa6, 0xac, 0x03, 0x4c, 0xd9, 0x0a, 0x27,
    0x48, 0x3d, 0xe1, 0x21, 0x19, 0xef, 0xa2, 0x24, 0x76, 0x16, 0xf7, 0x7b, 0xf4, 0x61, 0xf7, 0x62,
    0x7f, 0x07, 0xad, 0x1e, 0xeb, 0x8a, 0x0b, 0x5d, 0x57, 0x0e, 0xec, 0xf7, 0xec, 0x7e, 0x7e, 0x00,
    0xad, 0xa0, 0x63, 0x55, 0xf1, 0xa1, 0xc1, 0x14, 0x3c, 0x59, 0x43, 0x2d, 0x41, 0xe0, 0x62, 0x46,
    0x57, 0x2c, 0x20, 0x6a, 0x4e, 0xec, 0xed, 0xec, 0x74, 0x0e, 0xcc, 0x34, 0xe3, 0x3b, 0x8e, 0x01,
    0x87, 0x21, 0x1b, 0x26, 0x4f, 0xce, 0x58, 0xcb, 0xbc, 0xd4, 0x11, 0x02, 0x82, 0x01, 0x00, 0x71,
    0x71, 0xa9, 0xc4, 0x5b, 0xca, 0x7a, 0xa4, 0x5f, 0x2d, 0xa1, 0x0f, 0x57, 0xf5, 0xbf, 0xf0, 0x20,
    0x7e, 0x91, 0xe5, 0xdd, 0xe6, 0xfd, 0x68, 0x2b, 0xb5, 0x49, 0x9c, 0x1f, 0x03, 0xb3, 0xc2, 0x78,
    0x81, 0x55, 0xca, 0x4c, 0x1b, 0xd2, 0xeb, 0xcf, 0xbd, 0x19, 0x6f, 0x4b, 0xd7, 0x83, 0x64, 0xdb,
    0xe7, 0x05, 0x46, 0xcf, 0x79, 0xd8, 0x70, 0x87, 0x77, 0x4d, 0x8c, 0xc5, 0xba, 0xac, 0x52, 0x56,
    0x8d, 0xc5, 0xb7, 0xcf, 0xa5, 0x27, 0xf6, 0xad, 0xf5, 0x78, 0xb4, 0x20, 0x20, 0x53, 0x2a, 0xb3,
    0x9f, 0x8c, 0x79, 0x97, 0x0d, 0x9c, 0x85, 0xd7, 0x97, 0xcf, 0x2d, 0x6f, 0xf4, 0x95, 0x6a, 0x63,
    0xeb, 0x12, 0x01, 0xf2, 0x9e, 0x64, 0x69, 0x07, 0xab, 0xf9, 0xaa, 0xe1, 0x03, 0xf7, 0x05, 0x8b,
    0x00, 0x9d, 0x40, 0x91, 0xd9, 0x1d, 0x3b, 0x84, 0x4b, 0x0c, 0x67, 0x60, 0x17, 0xfa, 0x6b, 0xc3,
    0x36, 0x14, 0xa5, 0x3f, 0xc9, 0xf9, 0xcc, 0xb0, 0xeb, 0x2c, 0xd7, 0xdb, 0xad, 0x70, 0xa0, 0xee,
    0xd5, 0xae, 0x0d, 0xba, 0xd6, 0xde, 0x00, 0xd8, 0xd5, 0x9f, 0xbf, 0x9c, 0xef, 0x02, 0x22, 0xe5,
    0xeb, 0x7a, 0x95, 0xb1, 0x6c, 0xda, 0x05, 0x55, 0x86, 0xaa, 0x24, 0x45, 0xf4, 0x8c, 0x97, 0x0e,
    0x9c, 0xa2, 0x7b, 0xd9, 0x45, 0xcc, 0x84, 0x55, 0x6d, 0xa3, 0x09, 0x60, 0xd2, 0x04, 0x9b, 0x30,
    0xdb, 0x14, 0xa7, 0x75, 0xa0, 0xf4, 0x13, 0x33, 0xc0, 0x1f, 0xcc, 0x1c, 0xd9, 0xe1, 0xfe, 0x5c,
    0x94, 0x69, 0x4c, 0xb8, 0x79, 0x9c, 0x75, 0x48, 0x85, 0x78, 0xed, 0xd3, 0x8b, 0xf0, 0x64, 0x5b,
    0xf3, 0xce, 0x11, 0x7e, 0xbc, 0xdc, 0x36, 0x74, 0xe3, 0x0a, 0x65, 0x16, 0x21, 0x1c, 0x30, 0xce,
    0x6d, 0xab, 0xa5, 0x8b, 0xab, 0xad, 0xce, 0x22, 0x12, 0xde, 0x2c, 0x23, 0x2f, 0xd6, 0x7d, 0x02,
    0x82, 0x01, 0x00, 0x32, 0x49, 0xcb, 0x68, 0x2e, 0x6c, 0x15, 0xf4, 0xb7, 0x79, 0x38, 0x2c, 0xb2,
    0xfc, 0x6c, 0x88, 0x6a, 0x8f, 0xe7, 0xff, 0x22, 0x6f, 0xa6, 0x24, 0xda, 0x41, 0x07, 0xdd, 0x63,
    0xa2, 0x9c, 0x7d, 0xa4, 0x38, 0xb4, 0xe6, 0x61, 0xcb, 0x6d, 0x30, 0x34, 0x5c, 0xdd, 0x5d, 0x9d,
    0xfc, 0x74, 0x0d, 0x35, 0xe5, 0x58, 0xf6, 0x1e, 0x2e, 0x48, 0x0f, 0xa9, 0x3e, 0x67, 0x62, 0xfe,
    0xe3, 0xed, 0x59, 0xc6, 0xfa, 0x85, 0x17, 0x9d, 0x4b, 0xeb, 0x80, 0xff, 0xf5, 0xf1, 0x90, 0x92,
    0x26, 0x2a, 0x96, 0xc4, 0xe5, 0x2a, 0x08, 0x36, 0x28, 0xf7, 0x94, 0x39, 0xd5, 0x0d, 0x8a, 0x00,
    0xb1, 0x81, 0x81, 0xb9, 0xec, 0xca, 0x0e, 0x50, 0xc0, 0xd8, 0xfe, 0x42, 0x43, 0x1a, 0xd9, 0x19,
    0xae, 0x60, 0x0a, 0x87, 0xf6, 0x64, 0xae, 0x80, 0x7c, 0xc6, 0xa0, 0x75, 0x48, 0xcc, 0xf2, 0xe6,
    0x5d, 0xc7, 0x6e, 0x55, 0x36, 0x9e, 0xbf, 0xea, 0xf5, 0x94, 0x53, 0xc6, 0x1c, 0x8d, 0x42, 0xbf,
    0xac, 0x31, 0xc7, 0xa3, 0x27, 0x3b, 0x66, 0x96, 0x5b, 0xf5, 0x91, 0x32, 0x38, 0x6a, 0x23, 0x4a,
    0x4c, 0x7c, 0xcb, 0xbd, 0xb4, 0x4b, 0x50, 0xc6, 0x4d, 0xaf, 0x32, 0x08, 0x99, 0x7c, 0x31, 0x5c,
    0x60, 0x62, 0xc2, 0x84, 0xc8, 0x4a, 0xe6, 0x16, 0xfe, 0x4d, 0xe8, 0x9d, 0x01, 0x79, 0x0b, 0x68,
    0x13, 0x08, 0x3e, 0x64, 0xf4, 0x90, 0x8f, 0xb5, 0xa7, 0x3b, 0x54, 0x2e, 0x3d, 0x84, 0x7c, 0x91,
    0x4d, 0x61, 0xa0, 0xce, 0xc3, 0x6f, 0x85, 0x0e, 0x49, 0xba, 0x70, 0xb9, 0xba, 0x11, 0x3c, 0x03,
    0x70, 0x8a, 0x1f, 0xdb, 0xd5, 0xb9, 0xd2, 0x3b, 0x6b, 0x42, 0x06, 0x7b, 0xc0, 0xd9, 0x19, 0xd0,
    0x7e, 0xc9, 0x7b, 0x87, 0x7f, 0xe8, 0x4b, 0x64, 0x15, 0xb1, 0x51, 0x0e, 0x34, 0x39, 0xb8, 0x9b,
    0xfc, 0x95, 0x9d};

static const uint8_t kRSACACertDER[] = {0x30, 0x82, 0x05, 0xfd, 0x30, 0x82, 0x03, 0xe5, 0xa0, 0x03,
    0x02, 0x01, 0x02, 0x02, 0x14, 0x0f, 0x2d, 0x4d, 0xdd, 0x2f, 0xa5, 0xc0, 0x5f, 0x5a, 0xd3, 0x6e,
    0x9f, 0xbe, 0x29, 0x68, 0xe9, 0x24, 0x72, 0x6c, 0xe9, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48,
    0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x30, 0x81, 0x8d, 0x31, 0x0b, 0x30, 0x09, 0x06,
    0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04,
    0x08, 0x0c, 0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x21, 0x30,
    0x1f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74,
    0x20, 0x57, 0x69, 0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c, 0x74, 0x64,
    0x31, 0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67, 0x61, 0x6e,
    0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x20, 0x4e,
    0x61, 0x6d, 0x65, 0x31, 0x23, 0x30, 0x21, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1a, 0x6e, 0x6f,
    0x6e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65, 0x78, 0x69,
    0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x63, 0x61, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x39, 0x30, 0x35,
    0x30, 0x38, 0x31, 0x32, 0x34, 0x30, 0x32, 0x30, 0x5a, 0x17, 0x0d, 0x32, 0x39, 0x30, 0x35, 0x30,
    0x37, 0x31, 0x32, 0x34, 0x30, 0x32, 0x30, 0x5a, 0x30, 0x81, 0x8d, 0x31, 0x0b, 0x30, 0x09, 0x06,
    0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04,
    0x08, 0x0c, 0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x21, 0x30,
    0x1f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74,
    0x20, 0x57, 0x69, 0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c, 0x74, 0x64,
    0x31, 0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67, 0x61, 0x6e,
    0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x20, 0x4e,
    0x61, 0x6d, 0x65, 0x31, 0x23, 0x30, 0x21, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1a, 0x6e, 0x6f,
    0x6e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65, 0x78, 0x69,
    0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x63, 0x61, 0x30, 0x82, 0x02, 0x22, 0x30, 0x0d, 0x06, 0x09,
    0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x02, 0x0f, 0x00,
    0x30, 0x82, 0x02, 0x0a, 0x02, 0x82, 0x02, 0x01, 0x00, 0xd4, 0xa4, 0x24, 0xe8, 0xac, 0xef, 0xab,
    0xb4, 0xfd, 0x30, 0x45, 0xb3, 0x2f, 0x5f, 0x28, 0xa7, 0xa7, 0x55, 0x8a, 0x73, 0x6c, 0x29, 0x70,
    0x99, 0xb8, 0x13, 0x65, 0x68, 0xd2, 0x96, 0x71, 0x04, 0xc6, 0x52, 0x8e, 0xc9, 0x3e, 0xa0, 0xcb,
    0x11, 0x9c, 0xbe, 0x04, 0x66, 0x41, 0x2b, 0x85, 0x4d, 0xac, 0x2f, 0x87, 0xef, 0x7b, 0x47, 0x0b,
    0x79, 0xe3, 0x37, 0xd0, 0x9e, 0xb4, 0xfa, 0x8f, 0x94, 0x95, 0x4d, 0x41, 0x45, 0x5c, 0x75, 0x1b,
    0x1c, 0xc5, 0x1d, 0xa8, 0x3b, 0x0e, 0x87, 0x9c, 0x06, 0xc5, 0xe6, 0x19, 0x0e, 0x00, 0x88, 0xb4,
    0xfa, 0xf0, 0x3c, 0x57, 0x03, 0xd9, 0xbf, 0xee, 0x64, 0x8a, 0x22, 0x66, 0xeb, 0x4c, 0x91, 0xb3,
    0x09, 0xac, 0x13, 0x50, 0xd6, 0x41, 0x5b, 0x4f, 0x7e, 0x06, 0x9a, 0xa6, 0x9b, 0x1f, 0x07, 0x95,
    0xd0, 0xe9, 0x9e, 0x43, 0xb4, 0xe1, 0x60, 0xf0, 0x37, 0x53, 0xce, 0x73, 0xea, 0x6e, 0xad, 0x4f,
    0x73, 0xe0, 0x8b, 0x24, 0xf4, 0x6b, 0xec, 0xfc, 0x09, 0xbc, 0xed, 0x88, 0x8b, 0x92, 0xa5, 0xfe,
    0x1d, 0x51, 0x3c, 0x51, 0xe0, 0x0f, 0xb1, 0xe9, 0x9d, 0xf5, 0x24, 0x86, 0xb3, 0xd3, 0x98, 0x53,
    0x81, 0x44, 0x6e, 0x02, 0x33, 0xe1, 0x04, 0xa3, 0x8d, 0xc9, 0x50, 0xa1, 0xff, 0x8b, 0x93, 0x37,
    0xfc, 0x9c, 0xff, 0xd9, 0x8d, 0x07, 0x30, 0xdb, 0xeb, 0x6f, 0x77, 0xfb, 0x5f, 0x1b, 0xea, 0x5f,
    0x30, 0xf6, 0x30, 0xa9, 0x7b, 0xb7, 0x08, 0xed, 0x60, 0x3f, 0xb7, 0x98, 0x42, 0xcd, 0x28, 0xf8,
    0x5b, 0x68, 0x13, 0xf9, 0x31, 0x9a, 0x6c, 0x31, 0x58, 0x59, 0x1a, 0xcd, 0x2f, 0xa0, 0x5b, 0x0b,
    0xdc, 0xdb, 0xf6, 0xc0, 0x51, 0x77, 0xce, 0x65, 0xa7, 0x81, 0x29, 0x68, 0xa4, 0xf7, 0x6a, 0x23,
    0xb5, 0xf2, 0x82, 0xae, 0x6a, 0x80, 0xaf, 0x46, 0xa3, 0xfa, 0xc1, 0xee, 0x69, 0x22, 0x2a, 0x00,
    0xa4, 0x22, 0x93, 0x70, 0x70, 0x5d, 0x0b, 0xc6, 0x7d, 0x04, 0x4d, 0x68, 0x95, 0xd6, 0xaf, 0x8f,
    0x08, 0x16, 0x97, 0x64, 0x57, 0x3f, 0xb0, 0x6d, 0x1a, 0xd6, 0xc3, 0xf8, 0xbe, 0x73, 0xe4, 0x8d,
    0x39, 0x25, 0xff, 0x68, 0x2d, 0xb8, 0x0c, 0xf5, 0xd1, 0xa0, 0xe2, 0xd2, 0x41, 0x1d, 0xda, 0xbe,
    0xe9, 0x8a, 0x30, 0x9b, 0x0e, 0xed, 0xc7, 0x8c, 0xee, 0x97, 0xda, 0x5f, 0xe4, 0x18, 0x28, 0x07,
    0x53, 0xce, 0x1a, 0xff, 0x86, 0x1c, 0xc6, 0xe0, 0x0b, 0xab, 0x51, 0x95, 0xef, 0xe2, 0xdb, 0x23,
    0x0a, 0x01, 0xb5, 0x51, 0x3e, 0x5a, 0xc1, 0x32, 0xe6, 0xf2, 0xb1, 0x59, 0xe1, 0xbb, 0xaa, 0x77,
    0x4e, 0xae, 0xfa, 0x4d, 0x3c, 0x18, 0x1a, 0xdf, 0xe7, 0xde, 0x3e, 0x66, 0xc6, 0xcf, 0xbd, 0x9b,
    0xa8, 0x5a, 0x8c, 0xa1, 0x80, 0x7c, 0x3d, 0x89, 0x45, 0x40, 0x54, 0x25, 0xfa, 0x93, 0xff, 0xde,
    0x49, 0x56, 0x54, 0x45, 0x13, 0xce, 0x55, 0xb2, 0xbb, 0x19, 0x47, 0x7f, 0x5e, 0x5e, 0xd3, 0xd9,
    0xdc, 0x01, 0x5c, 0x12, 0x58, 0xdc, 0x47, 0x67, 0x6c, 0xc8, 0xbb, 0x9e, 0xa1, 0x75, 0xd1, 0x17,
    0x07, 0x07, 0x9b, 0xc4, 0x4a, 0xdd, 0x4c, 0x52, 0x48, 0x64, 0x1b, 0x64, 0x1b, 0x1a, 0x37, 0xe6,
    0x51, 0xeb, 0x0c, 0xf5, 0x49, 0x78, 0x71, 0x6a, 0x11, 0x68, 0xbf, 0x59, 0x09, 0xeb, 0x4b, 0x3a,
    0xfa, 0xbe, 0x75, 0x96, 0x07, 0x7a, 0xa6, 0xd0, 0x45, 0xb6, 0x49, 0xe7, 0x7a, 0xcc, 0xdf, 0xc7,
    0x20, 0xe8, 0xa5, 0xb6, 0xf4, 0x4f, 0x7a, 0x3b, 0xa0, 0x94, 0x9b, 0x00, 0xa8, 0x88, 0xe1, 0x4a,
    0x2d, 0x91, 0xfa, 0x5a, 0x00, 0xf2, 0x49, 0xf0, 0xba, 0x08, 0xed, 0x7a, 0xcc, 0x87, 0x01, 0xf0,
    0x84, 0xee, 0x49, 0x45, 0x7f, 0x7f, 0x71, 0x9a, 0x71, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x53,
    0x30, 0x51, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xb4, 0x59, 0x44,
    0x9c, 0xe3, 0x18, 0xd1, 0x69, 0x15, 0x4a, 0x38, 0x8b, 0x82, 0x0d, 0x19, 0x83, 0x1f, 0xe0, 0x02,
    0x37, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xb4, 0x59,
    0x44, 0x9c, 0xe3, 0x18, 0xd1, 0x69, 0x15, 0x4a, 0x38, 0x8b, 0x82, 0x0d, 0x19, 0x83, 0x1f, 0xe0,
    0x02, 0x37, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03,
    0x01, 0x01, 0xff, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b,
    0x05, 0x00, 0x03, 0x82, 0x02, 0x01, 0x00, 0x09, 0xbc, 0xf2, 0x4f, 0x06, 0x98, 0xf7, 0x8a, 0xfb,
    0x49, 0xc7, 0x78, 0x7c, 0xd7, 0x00, 0x00, 0x51, 0x75, 0x91, 0xdb, 0xd0, 0xd2, 0x9c, 0x61, 0xeb,
    0xe5, 0x15, 0x80, 0x50, 0xc8, 0xed, 0x50, 0x5c, 0x0e, 0x3b, 0x77, 0x51, 0x48, 0x44, 0xc4, 0xce,
    0x81, 0x9a, 0x60, 0x1c, 0xf1, 0xc2, 0x25, 0xfc, 0xcd, 0x7d, 0xf8, 0x2f, 0xf9, 0xcf, 0x21, 0x28,
    0x36, 0xa3, 0xc5, 0x15, 0x99, 0x75, 0x5b, 0x13, 0x65, 0xb8, 0x28, 0x1d, 0xde, 0x18, 0xaf, 0x1b,
    0xd8, 0x6f, 0xd8, 0x83, 0xbf, 0xbb, 0xa9, 0x13, 0x44, 0xfe, 0x4a, 0x19, 0xac, 0x18, 0x00, 0x94,
    0x3f, 0xdc, 0xe4, 0x34, 0x73, 0x44, 0xbf, 0x9f, 0x1b, 0x01, 0x70, 0xd5, 0x92, 0x2b, 0xce, 0x1c,
    0x63, 0xc5, 0xfb, 0x6b, 0x0e, 0xe0, 0x8d, 0x48, 0x59, 0x5c, 0xcd, 0xac, 0x62, 0x9a, 0xd0, 0xf0,
    0xa8, 0xe7, 0x35, 0x02, 0x95, 0xc9, 0x3f, 0x65, 0xab, 0x76, 0x38, 0xab, 0x18, 0x32, 0x64, 0xa7,
    0x14, 0x53, 0xc8, 0xaf, 0x49, 0x61, 0xaa, 0x94, 0x05, 0xd1, 0xaa, 0xd6, 0xea, 0x34, 0xda, 0xc8,
    0x73, 0xdb, 0xad, 0x48, 0xd8, 0xcc, 0x5a, 0x44, 0xda, 0xa6, 0x0b, 0xbb, 0xc4, 0x7b, 0xce, 0x0f,
    0x5f, 0xa6, 0x46, 0xe5, 0x90, 0xfb, 0xf0, 0xa5, 0x04, 0x0c, 0x32, 0xa8, 0x54, 0xdc, 0x62, 0x97,
    0x57, 0x4a, 0xdf, 0xb3, 0x03, 0x42, 0x64, 0xe8, 0x43, 0xc2, 0xdb, 0x38, 0x73, 0x6f, 0x67, 0x7d,
    0x6d, 0x56, 0x2f, 0x51, 0x41, 0x8f, 0x84, 0x82, 0x7e, 0x25, 0x04, 0xe2, 0x37, 0x68, 0xf8, 0x35,
    0x6a, 0x71, 0x3c, 0xde, 0xf7, 0x18, 0xb4, 0x4f, 0xbd, 0xfc, 0x73, 0x81, 0x96, 0x72, 0x03, 0x47,
    0x7c, 0x04, 0x6d, 0x76, 0x56, 0x7f, 0x27, 0x2a, 0x46, 0x20, 0x75, 0x7f, 0x0c, 0xb1, 0xd6, 0xcc,
    0x9d, 0x99, 0xcc, 0x7d, 0x23, 0x43, 0xed, 0xe2, 0xf4, 0x08, 0x4d, 0xe7, 0xf3, 0xdb, 0x0e, 0x69,
    0xfd, 0x4b, 0xb4, 0xce, 0x5e, 0x83, 0xd7, 0x0c, 0xd5, 0x43, 0x9b, 0x18, 0x9d, 0x67, 0x5b, 0x13,
    0xce, 0x50, 0x11, 0x1d, 0xa6, 0x31, 0x24, 0x6b, 0xae, 0x23, 0x41, 0xae, 0x90, 0xbb, 0x80, 0x2a,
    0x92, 0x78, 0xe8, 0x45, 0xc0, 0xde, 0xb5, 0xe7, 0x10, 0xb0, 0xac, 0x99, 0x7d, 0x3e, 0x2a, 0x38,
    0x4d, 0xb9, 0x96, 0x5d, 0x38, 0x49, 0xf1, 0x3f, 0xb8, 0x74, 0xc2, 0x3f, 0x53, 0x93, 0x7a, 0x1d,
    0x60, 0x1f, 0xb0, 0x19, 0xd1, 0xee, 0x06, 0x16, 0x68, 0x1c, 0x26, 0xa2, 0xad, 0xfd, 0xfd, 0x99,
    0x01, 0xab, 0xe1, 0xfa, 0xac, 0x9f, 0x79, 0xe7, 0xfb, 0xe4, 0xd9, 0xe4, 0xb6, 0x9f, 0xa5, 0xc2,
    0x80, 0x9e, 0x04, 0x32, 0x2f, 0x52, 0xbc, 0x39, 0xff, 0x38, 0xa8, 0x14, 0x81, 0x98, 0xef, 0x99,
    0x86, 0x3f, 0x13, 0x8d, 0x2e, 0xb8, 0xc5, 0xcc, 0x2b, 0xd9, 0xb5, 0x20, 0x21, 0x32, 0x82, 0xf4,
    0x5a, 0x37, 0xb2, 0x08, 0xaa, 0xec, 0x3f, 0x47, 0x06, 0x84, 0x55, 0x8d, 0xf3, 0xb4, 0xf3, 0xea,
    0x41, 0x56, 0x58, 0xc9, 0x1a, 0x88, 0x11, 0x93, 0x4c, 0xc5, 0x59, 0x14, 0x0e, 0x54, 0x6e, 0x5f,
    0x2b, 0x62, 0x2f, 0x5d, 0xbd, 0xfe, 0x07, 0x37, 0x2c, 0xc4, 0x6d, 0x30, 0x58, 0xb9, 0x02, 0xe7,
    0x81, 0xf8, 0x96, 0x8e, 0xbd, 0x9a, 0x03, 0x4b, 0xc1, 0x0d, 0x66, 0x28, 0xdd, 0x2f, 0xb7, 0x58,
    0xeb, 0xb8, 0x49, 0xa3, 0x91, 0xf3, 0x60, 0xe6, 0x36, 0x15, 0xb1, 0xfb, 0xb6, 0xf3, 0x54, 0x3f,
    0x7b, 0x1d, 0x10, 0xa4, 0x5a, 0x41, 0xba, 0x47, 0x92, 0xc5, 0xeb, 0x6a, 0x3b, 0xc6, 0xeb, 0xbc,
    0x05, 0x97, 0xc0, 0x77, 0xc8, 0x89, 0x4f, 0xf0, 0xee, 0xfa, 0xaf, 0xbe, 0x90, 0x05, 0xc4, 0x3e,
    0x48, 0x82, 0x09, 0x17, 0xf1, 0x3d, 0x8b};

static const uint8_t kECCACertDER[] = {0x30, 0x82, 0x02, 0xfd, 0x30, 0x82, 0x02, 0x5e, 0xa0, 0x03,
    0x02, 0x01, 0x02, 0x02, 0x14, 0x47, 0x96, 0xf7, 0x19, 0x12, 0x8f, 0x46, 0x3b, 0xd1, 0x98, 0xe6,
    0xd6, 0xc4, 0x5a, 0x79, 0x3f, 0xe9, 0xde, 0x4e, 0x4b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48,
    0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x81, 0x8f, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04,
    0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0c, 0x0a,
    0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x21, 0x30, 0x1f, 0x06, 0x03,
    0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x20, 0x57, 0x69,
    0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c, 0x74, 0x64, 0x31, 0x21, 0x30,
    0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
    0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x20, 0x4e, 0x61, 0x6d, 0x65,
    0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x6e, 0x6f, 0x6e, 0x65, 0x78,
    0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65,
    0x6e, 0x74, 0x2e, 0x65, 0x63, 0x63, 0x61, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x39, 0x30, 0x35, 0x30,
    0x38, 0x31, 0x32, 0x34, 0x37, 0x31, 0x31, 0x5a, 0x17, 0x0d, 0x33, 0x39, 0x30, 0x35, 0x30, 0x33,
    0x31, 0x32, 0x34, 0x37, 0x31, 0x31, 0x5a, 0x30, 0x81, 0x8f, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03,
    0x55, 0x04, 0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x08,
    0x0c, 0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x21, 0x30, 0x1f,
    0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x20,
    0x57, 0x69, 0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c, 0x74, 0x64, 0x31,
    0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
    0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x20, 0x4e, 0x61,
    0x6d, 0x65, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x6e, 0x6f, 0x6e,
    0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65, 0x78, 0x69, 0x73,
    0x74, 0x65, 0x6e, 0x74, 0x2e, 0x65, 0x63, 0x63, 0x61, 0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07,
    0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81,
    0x86, 0x00, 0x04, 0x01, 0xf3, 0x42, 0x76, 0xea, 0xca, 0x37, 0x6b, 0x80, 0xb4, 0x26, 0x42, 0x9f,
    0x26, 0x0b, 0xfe, 0x8b, 0x94, 0x4a, 0x56, 0x48, 0x56, 0x78, 0xda, 0x65, 0x07, 0xa6, 0x92, 0x63,
    0xdc, 0x33, 0x9f, 0x2f, 0x67, 0xaa, 0xc7, 0xf2, 0x77, 0xba, 0x4a, 0x65, 0xe7, 0x6b, 0x5b, 0x79,
    0x8a, 0x92, 0xe2, 0xd1, 0x99, 0x8f, 0x6d, 0x08, 0x50, 0x9f, 0x2f, 0xe9, 0x39, 0xff, 0xee, 0xa1,
    0xf7, 0x3b, 0x4f, 0xb1, 0x96, 0x01, 0xbc, 0xda, 0xa9, 0x21, 0x1b, 0x15, 0xb1, 0x24, 0x59, 0x38,
    0x3a, 0xee, 0x46, 0x31, 0x51, 0xae, 0xd8, 0x63, 0x0f, 0x5a, 0xae, 0xa5, 0xfa, 0x12, 0x2e, 0xbb,
    0x71, 0x71, 0xe5, 0x85, 0xa3, 0x4b, 0x90, 0x47, 0xbb, 0xa9, 0xa5, 0x55, 0x10, 0xeb, 0xe7, 0xf5,
    0x34, 0xe7, 0x3a, 0xd7, 0xb2, 0xaa, 0xad, 0x86, 0x8d, 0x29, 0xb9, 0xe9, 0x3b, 0xc4, 0x6b, 0x2c,
    0x23, 0x3f, 0x08, 0x37, 0xac, 0xeb, 0x6b, 0xa3, 0x53, 0x30, 0x51, 0x30, 0x1d, 0x06, 0x03, 0x55,
    0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xcc, 0x8b, 0x62, 0xc3, 0x62, 0x94, 0x1e, 0x17, 0x51, 0x32,
    0xd5, 0x95, 0x2f, 0xaf, 0x20, 0x68, 0x9d, 0x67, 0xc2, 0xb0, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d,
    0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xcc, 0x8b, 0x62, 0xc3, 0x62, 0x94, 0x1e, 0x17, 0x51,
    0x32, 0xd5, 0x95, 0x2f, 0xaf, 0x20, 0x68, 0x9d, 0x67, 0xc2, 0xb0, 0x30, 0x0f, 0x06, 0x03, 0x55,
    0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x0a, 0x06, 0x08,
    0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x81, 0x8c, 0x00, 0x30, 0x81, 0x88, 0x02,
    0x42, 0x01, 0x91, 0xfa, 0xdc, 0xb9, 0x61, 0x21, 0x29, 0x01, 0xd0, 0xd0, 0x07, 0xa6, 0xed, 0x77,
    0xa6, 0x81, 0x27, 0x13, 0x4d, 0x74, 0x96, 0xbd, 0x0a, 0x97, 0xeb, 0xd0, 0x02, 0x77, 0x90, 0x80,
    0xdf, 0xc1, 0xd3, 0xd3, 0x3c, 0xe5, 0x30, 0x6d, 0xba, 0x5a, 0xcf, 0x22, 0x70, 0x13, 0xad, 0x44,
    0x46, 0xbb, 0x6c, 0xdf, 0x27, 0x8a, 0x00, 0xf9, 0xc6, 0xa4, 0x87, 0x71, 0xeb, 0x19, 0x93, 0x13,
    0x6d, 0xcb, 0x2d, 0x02, 0x42, 0x01, 0x22, 0x3a, 0x74, 0xe9, 0xee, 0x1b, 0x09, 0xe0, 0xc7, 0xd5,
    0x78, 0xf2, 0x0c, 0x45, 0x30, 0x23, 0x48, 0xcc, 0x6a, 0x5f, 0x63, 0x32, 0xb7, 0x34, 0xf2, 0xfb,
    0xf4, 0x68, 0x16, 0xbd, 0x2e, 0xea, 0x88, 0x11, 0x3b, 0xd0, 0x4e, 0xc3, 0x6a, 0x1a, 0xa4, 0x6d,
    0xb7, 0x63, 0x2f, 0x7b, 0x65, 0x24, 0xde, 0xbd, 0x1a, 0x00, 0xaf, 0x46, 0xa2, 0x7c, 0xbc, 0x08,
    0x38, 0xcd, 0x12, 0x8a, 0x63, 0x4d, 0x3b};

static const uint8_t kDSACertDER[] = {0x30, 0x82, 0x03, 0xdf, 0x30, 0x82, 0x03, 0x9c, 0xa0, 0x03,
    0x02, 0x01, 0x02, 0x02, 0x14, 0x60, 0xe4, 0x10, 0x21, 0xe4, 0xc9, 0xaa, 0xf4, 0x6f, 0x72, 0x62,
    0xd1, 0x9f, 0x6e, 0x11, 0xc9, 0xee, 0x65, 0xd4, 0x62, 0x30, 0x0b, 0x06, 0x09, 0x60, 0x86, 0x48,
    0x01, 0x65, 0x03, 0x04, 0x03, 0x02, 0x30, 0x81, 0x9f, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55,
    0x04, 0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0c,
    0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x0f, 0x30, 0x0d, 0x06,
    0x03, 0x55, 0x04, 0x07, 0x0c, 0x06, 0x53, 0x69, 0x64, 0x6e, 0x65, 0x79, 0x31, 0x21, 0x30, 0x1f,
    0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x20,
    0x57, 0x69, 0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c, 0x74, 0x64, 0x31,
    0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
    0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x20, 0x4e, 0x61,
    0x6d, 0x65, 0x31, 0x24, 0x30, 0x22, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1b, 0x6e, 0x6f, 0x6e,
    0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65, 0x78, 0x69, 0x73,
    0x74, 0x65, 0x6e, 0x74, 0x2e, 0x64, 0x73, 0x61, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x39, 0x30, 0x35,
    0x30, 0x38, 0x31, 0x32, 0x34, 0x38, 0x33, 0x36, 0x5a, 0x17, 0x0d, 0x33, 0x39, 0x30, 0x35, 0x30,
    0x33, 0x31, 0x32, 0x34, 0x38, 0x33, 0x36, 0x5a, 0x30, 0x81, 0x9f, 0x31, 0x0b, 0x30, 0x09, 0x06,
    0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04,
    0x08, 0x0c, 0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x0f, 0x30,
    0x0d, 0x06, 0x03, 0x55, 0x04, 0x07, 0x0c, 0x06, 0x53, 0x69, 0x64, 0x6e, 0x65, 0x79, 0x31, 0x21,
    0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65,
    0x74, 0x20, 0x57, 0x69, 0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c, 0x74,
    0x64, 0x31, 0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67, 0x61,
    0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x20,
    0x4e, 0x61, 0x6d, 0x65, 0x31, 0x24, 0x30, 0x22, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1b, 0x6e,
    0x6f, 0x6e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65, 0x78,
    0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x64, 0x73, 0x61, 0x30, 0x82, 0x01, 0xb7, 0x30, 0x82,
    0x01, 0x2c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x38, 0x04, 0x01, 0x30, 0x82, 0x01, 0x1f, 0x02,
    0x81, 0x81, 0x00, 0xb2, 0xf2, 0xb3, 0x0d, 0x25, 0x1c, 0x01, 0x78, 0x24, 0xaf, 0x21, 0x37, 0xe1,
    0x07, 0x1a, 0xd6, 0x3f, 0xc5, 0x5c, 0x94, 0x4e, 0xf9, 0x82, 0x11, 0x4a, 0x42, 0xf8, 0xbc, 0x86,
    0x21, 0xd7, 0xe1, 0xef, 0x21, 0x50, 0xad, 0x79, 0x26, 0xab, 0x38, 0xb6, 0xd9, 0x46, 0x0f, 0xef,
    0xa3, 0x74, 0x3f, 0x3b, 0x10, 0x55, 0x67, 0x81, 0xfc, 0xe5, 0x48, 0x94, 0x33, 0xdd, 0x2c, 0x0a,
    0x7e, 0x0b, 0x23, 0x07, 0x89, 0x96, 0x09, 0x8c, 0xcd, 0x22, 0xfc, 0xdc, 0x09, 0x6f, 0x62, 0xec,
    0x0f, 0x5a, 0x0e, 0x02, 0x1c, 0x74, 0x02, 0x04, 0xb9, 0x52, 0x0a, 0xae, 0x95, 0x85, 0xea, 0x2b,
    0xee, 0x99, 0xbd, 0x7c, 0xf4, 0x27, 0xb7, 0xaf, 0x86, 0x3e, 0x0c, 0x69, 0x55, 0x51, 0x8f, 0x05,
    0xcf, 0x4e, 0xde, 0xfd, 0xb0, 0x98, 0xbb, 0xdd, 0x55, 0xa4, 0x53, 0xc5, 0x98, 0x31, 0xde, 0x8d,
    0xa9, 0xcf, 0x4b, 0x02, 0x15, 0x00, 0x9a, 0x11, 0xba, 0xd8, 0x08, 0x2b, 0x64, 0x4f, 0x5b, 0xaf,
    0x2f, 0xb8, 0x8b, 0x43, 0x9e, 0x8f, 0xc1, 0x04, 0xa2, 0x4d, 0x02, 0x81, 0x81, 0x00, 0xa8, 0x8f,
    0xe1, 0xb3, 0xe3, 0xd5, 0x61, 0xa8, 0x57, 0xe0, 0x0c, 0x55, 0x95, 0xaf, 0x80, 0xf8, 0xe3, 0xf8,
    0x73, 0xfe, 0x30, 0x3d, 0xf0, 0x10, 0x10, 0xa9, 0x11, 0x94, 0xc8, 0x98, 0x44, 0x25, 0x79, 0xa5,
    0x1a, 0xe9, 0x57, 0xe3, 0x0d, 0x57, 0x3a, 0x49, 0xc1, 0x4c, 0x7f, 0x01, 0x21, 0x6c, 0x15, 0xd5,
    0xdb, 0x73, 0x41, 0xbc, 0x4b, 0xf2, 0x8e, 0xe0, 0x30, 0x55, 0xda, 0x86, 0xac, 0x23, 0x78, 0x7a,
    0x7a, 0xef, 0xb4, 0x84, 0xbf, 0x9f, 0x02, 0x77, 0xe6, 0x44, 0x54, 0xca, 0xac, 0x2a, 0x6b, 0xfd,
    0x58, 0xfa, 0xbe, 0xc2, 0xeb, 0x02, 0xf0, 0xce, 0x32, 0x2e, 0x1c, 0x5f, 0xca, 0xdd, 0xe9, 0xf6,
    0x67, 0xf7, 0x4f, 0xa4, 0xe5, 0x2b, 0x27, 0xec, 0xaa, 0x47, 0xfd, 0xfb, 0x63, 0x9c, 0x3f, 0xba,
    0xdc, 0xda, 0xd2, 0x18, 0xd6, 0x8d, 0x65, 0xf5, 0x8d, 0xc5, 0x97, 0x78, 0xcc, 0x6f, 0x03, 0x81,
    0x84, 0x00, 0x02, 0x81, 0x80, 0x70, 0x3d, 0xfa, 0x84, 0x2a, 0x3c, 0xad, 0x9c, 0xfa, 0x86, 0x39,
    0xaf, 0xa9, 0xdb, 0x4f, 0x94, 0x27, 0x12, 0xa7, 0x60, 0x5b, 0xa8, 0xe9, 0x30, 0x19, 0x5d, 0xf8,
    0x0d, 0x20, 0x90, 0x61, 0x9f, 0xd7, 0xf8, 0xa9, 0xbe, 0x5f, 0x2d, 0x31, 0x38, 0x5a, 0xb4, 0xaa,
    0x25, 0x6b, 0xb2, 0x37, 0x25, 0xdb, 0xc2, 0x50, 0xca, 0xaf, 0x44, 0xcb, 0x2e, 0x5f, 0x69, 0xc8,
    0x56, 0x16, 0x0e, 0x90, 0x20, 0x94, 0xc8, 0x43, 0x86, 0x5b, 0x52, 0x6c, 0xd4, 0x74, 0xd0, 0x76,
    0xec, 0xe4, 0x81, 0xcc, 0x21, 0x30, 0xf9, 0x75, 0x54, 0xd9, 0xf3, 0xd0, 0x83, 0x46, 0x63, 0x96,
    0xf9, 0x60, 0x1a, 0xa7, 0xeb, 0xe2, 0xe4, 0x7a, 0x89, 0x9d, 0xfa, 0x26, 0xc6, 0x22, 0xab, 0xee,
    0x29, 0x43, 0x4d, 0x32, 0x5c, 0x01, 0x09, 0x18, 0xf6, 0xe4, 0x9f, 0xfd, 0xeb, 0xb7, 0x16, 0x08,
    0xdd, 0x29, 0xbb, 0xce, 0x10, 0xa3, 0x53, 0x30, 0x51, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e,
    0x04, 0x16, 0x04, 0x14, 0x04, 0x11, 0x5e, 0x1f, 0xd4, 0x92, 0x92, 0xea, 0xe3, 0x1c, 0xc2, 0x03,
    0x6f, 0xc1, 0x80, 0x73, 0x2b, 0xa5, 0xa0, 0x3e, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04,
    0x18, 0x30, 0x16, 0x80, 0x14, 0x04, 0x11, 0x5e, 0x1f, 0xd4, 0x92, 0x92, 0xea, 0xe3, 0x1c, 0xc2,
    0x03, 0x6f, 0xc1, 0x80, 0x73, 0x2b, 0xa5, 0xa0, 0x3e, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13,
    0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x0b, 0x06, 0x09, 0x60, 0x86,
    0x48, 0x01, 0x65, 0x03, 0x04, 0x03, 0x02, 0x03, 0x30, 0x00, 0x30, 0x2d, 0x02, 0x14, 0x73, 0x18,
    0xf9, 0x68, 0x26, 0xdb, 0x0d, 0xd5, 0x49, 0x52, 0x14, 0x50, 0xb4, 0xcf, 0x3a, 0x1f, 0x0d, 0x49,
    0x8f, 0xe7, 0x02, 0x15, 0x00, 0x92, 0x6e, 0xb6, 0xce, 0x87, 0x1e, 0x7b, 0x68, 0xfc, 0x2e, 0xd3,
    0xa9, 0x3d, 0xe1, 0x55, 0x39, 0xc0, 0x66, 0xe0, 0x20};

static SSL_CTX* ctx = NULL;

unsigned int psk_callback(
    SSL* ssl, const char* identity, unsigned char* psk, unsigned int max_psk_len) {
    memset(psk, 'A', max_psk_len);
    return max_psk_len;
}

#if defined(HF_SSL_IS_OPENSSL)
static int srp_callback(SSL* s, int* ad, void* arg) {
    if (strcmp(SSL_get_srp_username(s), "USER") != 0) {
        *ad = SSL_AD_INTERNAL_ERROR;
        return SSL3_AL_FATAL;
    }
    if (SSL_set_srp_server_param_pw(s, "USER", "PASS", "1024") < 0) {
        *ad = SSL_AD_INTERNAL_ERROR;
        return SSL3_AL_FATAL;
    }
    return SSL_ERROR_NONE;
}
#endif /* defined(HF_SSL_IS_OPENSSL) */

int alpn_callback(SSL* ssl, const unsigned char** out, unsigned char* outlen,
    const unsigned char* in, unsigned int inlen, void* arg) {
    *out = &in[1];
    *outlen = in[0];
    return SSL_TLSEXT_ERR_OK;
}

static int npn_callback(SSL* ssl, const uint8_t** out, unsigned* out_len, void* arg) {
    static const uint8_t kProtocols[] = {
        0x01,
        'a',
        0x02,
        'a',
        'a',
        0x03,
        'a',
        'a',
        'a',
    };
    *out = kProtocols;
    *out_len = sizeof(kProtocols);
    return SSL_TLSEXT_ERR_OK;
}

static int session_id_callback(
#if defined(HF_SSL_IS_LIBRESSL)
    const
#endif /* defined(HF_SSL_IS_LIBRESSL) */
    SSL* ssl,
    unsigned char* id, unsigned int* id_len) {
    static unsigned char sess_cnt = 'A';
    memset(id, sess_cnt++, *id_len);
    return 1;
}

int LLVMFuzzerInitialize(int* argc, char*** argv) {
    HFInit();
    HFResetRand();

    ctx = SSL_CTX_new(SSLv23_method());
    const uint8_t* bufp = kRSAPrivateKeyDER;
    RSA* privkey = d2i_RSAPrivateKey(NULL, &bufp, sizeof(kRSAPrivateKeyDER));
    assert(privkey != NULL);
    EVP_PKEY* pkey = EVP_PKEY_new();
    EVP_PKEY_assign_RSA(pkey, privkey);
    int ret = SSL_CTX_use_PrivateKey(ctx, pkey);
    assert(ret == 1);
    EVP_PKEY_free(pkey);

    bufp = kCertificateDER;
    X509* cert = d2i_X509(NULL, &bufp, sizeof(kCertificateDER));
    assert(cert != NULL);
    ret = SSL_CTX_use_certificate(ctx, cert);
    assert(ret == 1);
    X509_free(cert);
#if defined(HF_SSL_IS_BORINGSSL)
    ret = SSL_CTX_set_cipher_list(ctx, "ALL");
#else
    ret = SSL_CTX_set_cipher_list(ctx, "ALL:COMPLEMENTOFALL");
#endif  // defined(HF_SSL_IS_BORINGSSL)
    assert(ret == 1);

    X509_STORE* store = X509_STORE_new();
    assert(store != NULL);

    bufp = kRSACACertDER;
    cert = d2i_X509(NULL, &bufp, sizeof(kRSACACertDER));
    assert(cert != NULL);
    ret = SSL_CTX_add_client_CA(ctx, cert);
    assert(ret == 1);
    ret = X509_STORE_add_cert(store, cert);
    assert(ret == 1);
    X509_free(cert);

    bufp = kECCACertDER;
    cert = d2i_X509(NULL, &bufp, sizeof(kECCACertDER));
    assert(cert != NULL);
    ret = SSL_CTX_add_client_CA(ctx, cert);
    assert(ret == 1);
    ret = X509_STORE_add_cert(store, cert);
    assert(ret == 1);
    X509_free(cert);

    bufp = kDSACertDER;
    cert = d2i_X509(NULL, &bufp, sizeof(kDSACertDER));
    ret = SSL_CTX_add_client_CA(ctx, cert);
    assert(ret == 1);
    ret = X509_STORE_add_cert(store, cert);
    assert(ret == 1);
    X509_free(cert);

    SSL_CTX_set_cert_store(ctx, store);
    SSL_CTX_set_verify(ctx, SSL_VERIFY_PEER, NULL);
    SSL_CTX_set_verify_depth(ctx, 10);

#if !defined(HF_SSL_IS_LIBRESSL)
    SSL_CTX_set_psk_server_callback(ctx, psk_callback);
    ret = SSL_CTX_use_psk_identity_hint(ctx, "ABCDEFUZZ");
    assert(ret == 1);
#endif /* !defined(HF_SSL_IS_LIBRESSL) */

#if defined(HF_SSL_IS_OPENSSL)
    ret = SSL_CTX_set_srp_username_callback(ctx, srp_callback);
    assert(ret == 1);
    ret = SSL_CTX_set_srp_cb_arg(ctx, NULL);
    assert(ret == 1);
#endif /* defined(HF_SSL_IS_OPENSSL) */

    SSL_CTX_set_alpn_select_cb(ctx, alpn_callback, NULL);
    SSL_CTX_set_next_protos_advertised_cb(ctx, npn_callback, NULL);
    SSL_CTX_set_ecdh_auto(ctx, 1);
    SSL_CTX_set_min_proto_version(ctx, SSL3_VERSION);
    SSL_CTX_set_max_proto_version(ctx, TLS1_3_VERSION);
    SSL_CTX_set_session_cache_mode(ctx, SSL_SESS_CACHE_BOTH);
    SSL_CTX_set_timeout(ctx, 3);

#if defined(HF_SSL_IS_OPENSSL_GE_1_1)
    SSL_CTX_enable_ct(ctx, SSL_CT_VALIDATION_STRICT);
    SSL_CTX_set_max_early_data(ctx, 1024);
#endif /* defined(HF_SSL_IS_OPENSSL_GE_1_1) */

#if defined(HF_SSL_IS_OPENSSL_GE_1_1) || defined(HF_SSL_IS_LIBRESSL)
    SSL_CTX_set_dh_auto(ctx, 1);
    SSL_CTX_set_generate_session_id(ctx, session_id_callback);
#endif /* defined(HF_SSL_IS_OPENSSL_GE_1_1) || defined(HF_SSL_IS_LIBRESSL) */

    long opts = SSL_CTX_get_options(ctx);
    opts |= SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION;
    opts |= SSL_OP_LEGACY_SERVER_CONNECT;
    opts |= SSL_OP_ALL;
    SSL_CTX_set_options(ctx, opts);

    return 1;
}

__attribute__((weak)) void RAND_reset_for_fuzzing(void){};

int LLVMFuzzerTestOneInput(const uint8_t* buf, size_t len) {
    RAND_reset_for_fuzzing();

    SSL* server = SSL_new(ctx);

#if defined(HF_SSL_FROM_STDIN)
    BIO* in = BIO_new(BIO_s_fd());
    BIO_set_fd(in, 0, BIO_NOCLOSE);
#else  /* defined(HF_SSL_FROM_STDIN) */
    BIO* in = BIO_new(BIO_s_mem());
    BIO_write(in, buf, len);
#endif /* defined(HF_SSL_FROM_STDIN) */

    BIO* out = BIO_new(BIO_s_fd());
    BIO_set_fd(out, 1, BIO_NOCLOSE);

    SSL_set_bio(server, in, out);
    SSL_set_accept_state(server);

#if defined(HF_SSL_IS_OPENSSL_GE_1_1)
    for (;;) {
        size_t sz;
        uint8_t edata_rbuf[128];
        if (SSL_read_early_data(server, edata_rbuf, sizeof(edata_rbuf), &sz) !=
            SSL_READ_EARLY_DATA_SUCCESS) {
            break;
        }
    }
#endif  // defined(HF_SSL_IS_OPENSSL_GE_1_1)

    /* Try it two times to test SSL_clear() */
    for (unsigned i = 0; i < 2; i++) {
        if (SSL_do_handshake(server) == 1) {
            uint8_t tmp[1024 * 1024];

            X509* peer;
            if ((peer = SSL_get_peer_certificate(server)) != NULL) {
                long res = SSL_get_verify_result(server);
                if (res != X509_V_OK) {
                    if (getenv("HFUZZ_SSL_ABORT_ON_VERIFY")) {
                        fprintf(stderr, "verify: %ld\n", res);
                        abort();
                    }
                }
                X509_free(peer);
            }
            for (;;) {
                ssize_t r = SSL_read(server, tmp, sizeof(tmp));
                if (r <= 0) {
                    break;
                }
                if (SSL_write(server, tmp, r) <= 0) {
                    break;
                }
                SSL_set_mtu(server, 8);
            }
        } else {
            ERR_print_errors_fp(stderr);
            break;
        }

        if (SSL_shutdown(server) != 1) {
            break;
        }
        if (SSL_clear(server) != 1) {
            break;
        }
    }
    SSL_free(server);

    return 0;
}

#ifdef __cplusplus
}
#endif
