// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/video/livestream/logging/v1/logs.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	v1 "google.golang.org/genproto/googleapis/cloud/video/livestream/v1"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Logs of activities related to the Channels.
type ChannelActivity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Message is for more details of the log and instructions to users.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// Different types of the logs.
	//
	// Types that are assignable to ActivityType:
	//	*ChannelActivity_StreamingStateChange
	//	*ChannelActivity_StreamingError
	//	*ChannelActivity_InputAccept
	//	*ChannelActivity_InputError
	//	*ChannelActivity_InputDisconnect
	ActivityType isChannelActivity_ActivityType `protobuf_oneof:"activity_type"`
}

func (x *ChannelActivity) Reset() {
	*x = ChannelActivity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChannelActivity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChannelActivity) ProtoMessage() {}

func (x *ChannelActivity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChannelActivity.ProtoReflect.Descriptor instead.
func (*ChannelActivity) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescGZIP(), []int{0}
}

func (x *ChannelActivity) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (m *ChannelActivity) GetActivityType() isChannelActivity_ActivityType {
	if m != nil {
		return m.ActivityType
	}
	return nil
}

func (x *ChannelActivity) GetStreamingStateChange() *StreamingStateChange {
	if x, ok := x.GetActivityType().(*ChannelActivity_StreamingStateChange); ok {
		return x.StreamingStateChange
	}
	return nil
}

func (x *ChannelActivity) GetStreamingError() *StreamingError {
	if x, ok := x.GetActivityType().(*ChannelActivity_StreamingError); ok {
		return x.StreamingError
	}
	return nil
}

func (x *ChannelActivity) GetInputAccept() *InputAccept {
	if x, ok := x.GetActivityType().(*ChannelActivity_InputAccept); ok {
		return x.InputAccept
	}
	return nil
}

func (x *ChannelActivity) GetInputError() *InputError {
	if x, ok := x.GetActivityType().(*ChannelActivity_InputError); ok {
		return x.InputError
	}
	return nil
}

func (x *ChannelActivity) GetInputDisconnect() *InputDisconnect {
	if x, ok := x.GetActivityType().(*ChannelActivity_InputDisconnect); ok {
		return x.InputDisconnect
	}
	return nil
}

type isChannelActivity_ActivityType interface {
	isChannelActivity_ActivityType()
}

type ChannelActivity_StreamingStateChange struct {
	// The channel streaming state changes.
	StreamingStateChange *StreamingStateChange `protobuf:"bytes,2,opt,name=streaming_state_change,json=streamingStateChange,proto3,oneof"`
}

type ChannelActivity_StreamingError struct {
	// An error happens with the video pipeline.
	StreamingError *StreamingError `protobuf:"bytes,3,opt,name=streaming_error,json=streamingError,proto3,oneof"`
}

type ChannelActivity_InputAccept struct {
	// The channel has accepted an input stream.
	InputAccept *InputAccept `protobuf:"bytes,4,opt,name=input_accept,json=inputAccept,proto3,oneof"`
}

type ChannelActivity_InputError struct {
	// An error happens with the input stream.
	InputError *InputError `protobuf:"bytes,5,opt,name=input_error,json=inputError,proto3,oneof"`
}

type ChannelActivity_InputDisconnect struct {
	// An input stream disconnects.
	InputDisconnect *InputDisconnect `protobuf:"bytes,6,opt,name=input_disconnect,json=inputDisconnect,proto3,oneof"`
}

func (*ChannelActivity_StreamingStateChange) isChannelActivity_ActivityType() {}

func (*ChannelActivity_StreamingError) isChannelActivity_ActivityType() {}

func (*ChannelActivity_InputAccept) isChannelActivity_ActivityType() {}

func (*ChannelActivity_InputError) isChannelActivity_ActivityType() {}

func (*ChannelActivity_InputDisconnect) isChannelActivity_ActivityType() {}

// StreamingStateChange records when the channel streaming state changes.
type StreamingStateChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// New streaming state of the channel.
	NewState v1.Channel_StreamingState `protobuf:"varint,1,opt,name=new_state,json=newState,proto3,enum=google.cloud.video.livestream.v1.Channel_StreamingState" json:"new_state,omitempty"`
	// Previous streaming state of the channel.
	PreviousState v1.Channel_StreamingState `protobuf:"varint,2,opt,name=previous_state,json=previousState,proto3,enum=google.cloud.video.livestream.v1.Channel_StreamingState" json:"previous_state,omitempty"`
}

func (x *StreamingStateChange) Reset() {
	*x = StreamingStateChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingStateChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingStateChange) ProtoMessage() {}

func (x *StreamingStateChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingStateChange.ProtoReflect.Descriptor instead.
func (*StreamingStateChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescGZIP(), []int{1}
}

func (x *StreamingStateChange) GetNewState() v1.Channel_StreamingState {
	if x != nil {
		return x.NewState
	}
	return v1.Channel_STREAMING_STATE_UNSPECIFIED
}

func (x *StreamingStateChange) GetPreviousState() v1.Channel_StreamingState {
	if x != nil {
		return x.PreviousState
	}
	return v1.Channel_STREAMING_STATE_UNSPECIFIED
}

// StreamingError records when an error happens with the video pipeline.
type StreamingError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A description of the reason for the streaming error.
	Error *status.Status `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *StreamingError) Reset() {
	*x = StreamingError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingError) ProtoMessage() {}

func (x *StreamingError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingError.ProtoReflect.Descriptor instead.
func (*StreamingError) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescGZIP(), []int{2}
}

func (x *StreamingError) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// InputAccept records when the channel has accepted an input stream.
type InputAccept struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the input stream.
	StreamId string `protobuf:"bytes,1,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
	// The user-defined key for the input attachment.
	InputAttachment string `protobuf:"bytes,2,opt,name=input_attachment,json=inputAttachment,proto3" json:"input_attachment,omitempty"`
	// Properties of the input stream.
	InputStreamProperty *InputStreamProperty `protobuf:"bytes,3,opt,name=input_stream_property,json=inputStreamProperty,proto3" json:"input_stream_property,omitempty"`
}

func (x *InputAccept) Reset() {
	*x = InputAccept{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputAccept) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputAccept) ProtoMessage() {}

func (x *InputAccept) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputAccept.ProtoReflect.Descriptor instead.
func (*InputAccept) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescGZIP(), []int{3}
}

func (x *InputAccept) GetStreamId() string {
	if x != nil {
		return x.StreamId
	}
	return ""
}

func (x *InputAccept) GetInputAttachment() string {
	if x != nil {
		return x.InputAttachment
	}
	return ""
}

func (x *InputAccept) GetInputStreamProperty() *InputStreamProperty {
	if x != nil {
		return x.InputStreamProperty
	}
	return nil
}

// InputError records when an error happens with the input stream.
type InputError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the input stream.
	StreamId string `protobuf:"bytes,1,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
	// The user-defined key for the input attachment. If the stream doesn’t belong
	// to any input attachment, this field is empty.
	InputAttachment string `protobuf:"bytes,2,opt,name=input_attachment,json=inputAttachment,proto3" json:"input_attachment,omitempty"`
	// Properties of the input stream.
	InputStreamProperty *InputStreamProperty `protobuf:"bytes,3,opt,name=input_stream_property,json=inputStreamProperty,proto3" json:"input_stream_property,omitempty"`
	// A description of the reason for the error with the input stream.
	Error *status.Status `protobuf:"bytes,4,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *InputError) Reset() {
	*x = InputError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputError) ProtoMessage() {}

func (x *InputError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputError.ProtoReflect.Descriptor instead.
func (*InputError) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescGZIP(), []int{4}
}

func (x *InputError) GetStreamId() string {
	if x != nil {
		return x.StreamId
	}
	return ""
}

func (x *InputError) GetInputAttachment() string {
	if x != nil {
		return x.InputAttachment
	}
	return ""
}

func (x *InputError) GetInputStreamProperty() *InputStreamProperty {
	if x != nil {
		return x.InputStreamProperty
	}
	return nil
}

func (x *InputError) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// Properties of the input stream.
type InputStreamProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Properties of the video streams.
	VideoStreams []*VideoStream `protobuf:"bytes,1,rep,name=video_streams,json=videoStreams,proto3" json:"video_streams,omitempty"`
	// Properties of the audio streams.
	AudioStreams []*AudioStream `protobuf:"bytes,2,rep,name=audio_streams,json=audioStreams,proto3" json:"audio_streams,omitempty"`
}

func (x *InputStreamProperty) Reset() {
	*x = InputStreamProperty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputStreamProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputStreamProperty) ProtoMessage() {}

func (x *InputStreamProperty) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputStreamProperty.ProtoReflect.Descriptor instead.
func (*InputStreamProperty) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescGZIP(), []int{5}
}

func (x *InputStreamProperty) GetVideoStreams() []*VideoStream {
	if x != nil {
		return x.VideoStreams
	}
	return nil
}

func (x *InputStreamProperty) GetAudioStreams() []*AudioStream {
	if x != nil {
		return x.AudioStreams
	}
	return nil
}

// Properties of the video stream.
type VideoStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of this video stream.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// Properties of the video format.
	VideoFormat *VideoFormat `protobuf:"bytes,2,opt,name=video_format,json=videoFormat,proto3" json:"video_format,omitempty"`
}

func (x *VideoStream) Reset() {
	*x = VideoStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoStream) ProtoMessage() {}

func (x *VideoStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoStream.ProtoReflect.Descriptor instead.
func (*VideoStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescGZIP(), []int{6}
}

func (x *VideoStream) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *VideoStream) GetVideoFormat() *VideoFormat {
	if x != nil {
		return x.VideoFormat
	}
	return nil
}

// Properties of the video format.
type VideoFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Video codec used in this video stream.
	Codec string `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
	// The width of the video stream in pixels.
	WidthPixels int32 `protobuf:"varint,2,opt,name=width_pixels,json=widthPixels,proto3" json:"width_pixels,omitempty"`
	// The height of the video stream in pixels.
	HeightPixels int32 `protobuf:"varint,3,opt,name=height_pixels,json=heightPixels,proto3" json:"height_pixels,omitempty"`
	// The frame rate of the input video stream.
	FrameRate float64 `protobuf:"fixed64,4,opt,name=frame_rate,json=frameRate,proto3" json:"frame_rate,omitempty"`
}

func (x *VideoFormat) Reset() {
	*x = VideoFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoFormat) ProtoMessage() {}

func (x *VideoFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoFormat.ProtoReflect.Descriptor instead.
func (*VideoFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescGZIP(), []int{7}
}

func (x *VideoFormat) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

func (x *VideoFormat) GetWidthPixels() int32 {
	if x != nil {
		return x.WidthPixels
	}
	return 0
}

func (x *VideoFormat) GetHeightPixels() int32 {
	if x != nil {
		return x.HeightPixels
	}
	return 0
}

func (x *VideoFormat) GetFrameRate() float64 {
	if x != nil {
		return x.FrameRate
	}
	return 0
}

// Properties of the audio stream.
type AudioStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of this audio stream.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// Properties of the audio format.
	AudioFormat *AudioFormat `protobuf:"bytes,2,opt,name=audio_format,json=audioFormat,proto3" json:"audio_format,omitempty"`
}

func (x *AudioStream) Reset() {
	*x = AudioStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioStream) ProtoMessage() {}

func (x *AudioStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioStream.ProtoReflect.Descriptor instead.
func (*AudioStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescGZIP(), []int{8}
}

func (x *AudioStream) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *AudioStream) GetAudioFormat() *AudioFormat {
	if x != nil {
		return x.AudioFormat
	}
	return nil
}

// Properties of the audio format.
type AudioFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Audio codec used in this audio stream.
	Codec string `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
	// The number of audio channels.
	ChannelCount int32 `protobuf:"varint,2,opt,name=channel_count,json=channelCount,proto3" json:"channel_count,omitempty"`
	// A list of channel names specifying the layout of the audio channels.
	ChannelLayout []string `protobuf:"bytes,3,rep,name=channel_layout,json=channelLayout,proto3" json:"channel_layout,omitempty"`
}

func (x *AudioFormat) Reset() {
	*x = AudioFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioFormat) ProtoMessage() {}

func (x *AudioFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioFormat.ProtoReflect.Descriptor instead.
func (*AudioFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescGZIP(), []int{9}
}

func (x *AudioFormat) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

func (x *AudioFormat) GetChannelCount() int32 {
	if x != nil {
		return x.ChannelCount
	}
	return 0
}

func (x *AudioFormat) GetChannelLayout() []string {
	if x != nil {
		return x.ChannelLayout
	}
	return nil
}

// InputDisconnect records when an input stream disconnects.
type InputDisconnect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the input stream.
	StreamId string `protobuf:"bytes,1,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
	// The user-defined key for the input attachment.
	InputAttachment string `protobuf:"bytes,2,opt,name=input_attachment,json=inputAttachment,proto3" json:"input_attachment,omitempty"`
}

func (x *InputDisconnect) Reset() {
	*x = InputDisconnect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputDisconnect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputDisconnect) ProtoMessage() {}

func (x *InputDisconnect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputDisconnect.ProtoReflect.Descriptor instead.
func (*InputDisconnect) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescGZIP(), []int{10}
}

func (x *InputDisconnect) GetStreamId() string {
	if x != nil {
		return x.StreamId
	}
	return ""
}

func (x *InputDisconnect) GetInputAttachment() string {
	if x != nil {
		return x.InputAttachment
	}
	return ""
}

var File_google_cloud_video_livestream_logging_v1_logs_proto protoreflect.FileDescriptor

var file_google_cloud_video_livestream_logging_v1_logs_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2f,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x1a,
	0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2f, 0x76,
	0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb6, 0x04, 0x0a, 0x0f, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x18,
	0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x76, 0x0a, 0x16, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x14, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x63, 0x0a, 0x0f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x5a, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x61,
	0x63, 0x63, 0x65, 0x70, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x63, 0x63, 0x65,
	0x70, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x63, 0x63, 0x65, 0x70,
	0x74, 0x12, 0x57, 0x0a, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x0a,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x66, 0x0a, 0x10, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x48,
	0x00, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x42, 0x0f, 0x0a, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x22, 0xce, 0x01, 0x0a, 0x14, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x55, 0x0a, 0x09,
	0x6e, 0x65, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x08, 0x6e, 0x65, 0x77, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x5f, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x22, 0x3a, 0x0a, 0x0e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x22, 0xc8, 0x01, 0x0a, 0x0b, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x64, 0x12, 0x29, 0x0a,
	0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x71, 0x0a, 0x15, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x13, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0xf1, 0x01, 0x0a, 0x0a,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x71, 0x0a, 0x15, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x52, 0x13, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22,
	0xcd, 0x01, 0x0a, 0x13, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x5a, 0x0a, 0x0d, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x12, 0x5a, 0x0a, 0x0d, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x22,
	0x7d, 0x0a, 0x0b, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x14,
	0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x12, 0x58, 0x0a, 0x0c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x52, 0x0b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x8a,
	0x01, 0x0a, 0x0b, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63,
	0x6f, 0x64, 0x65, 0x63, 0x12, 0x21, 0x0a, 0x0c, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x69,
	0x78, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x68, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c,
	0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x1d, 0x0a, 0x0a,
	0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x09, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x61, 0x74, 0x65, 0x22, 0x7d, 0x0a, 0x0b, 0x41,
	0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x58, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0b, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x6f, 0x0a, 0x0b, 0x41, 0x75,
	0x64, 0x69, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x64,
	0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x12,
	0x23, 0x0a, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f,
	0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x22, 0x59, 0x0a, 0x0f, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x8c, 0x01, 0x0a, 0x2c, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x42, 0x09, 0x4c, 0x6f, 0x67, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescOnce sync.Once
	file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescData = file_google_cloud_video_livestream_logging_v1_logs_proto_rawDesc
)

func file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescGZIP() []byte {
	file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescOnce.Do(func() {
		file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescData)
	})
	return file_google_cloud_video_livestream_logging_v1_logs_proto_rawDescData
}

var file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_video_livestream_logging_v1_logs_proto_goTypes = []interface{}{
	(*ChannelActivity)(nil),        // 0: google.cloud.video.livestream.logging.v1.ChannelActivity
	(*StreamingStateChange)(nil),   // 1: google.cloud.video.livestream.logging.v1.StreamingStateChange
	(*StreamingError)(nil),         // 2: google.cloud.video.livestream.logging.v1.StreamingError
	(*InputAccept)(nil),            // 3: google.cloud.video.livestream.logging.v1.InputAccept
	(*InputError)(nil),             // 4: google.cloud.video.livestream.logging.v1.InputError
	(*InputStreamProperty)(nil),    // 5: google.cloud.video.livestream.logging.v1.InputStreamProperty
	(*VideoStream)(nil),            // 6: google.cloud.video.livestream.logging.v1.VideoStream
	(*VideoFormat)(nil),            // 7: google.cloud.video.livestream.logging.v1.VideoFormat
	(*AudioStream)(nil),            // 8: google.cloud.video.livestream.logging.v1.AudioStream
	(*AudioFormat)(nil),            // 9: google.cloud.video.livestream.logging.v1.AudioFormat
	(*InputDisconnect)(nil),        // 10: google.cloud.video.livestream.logging.v1.InputDisconnect
	(v1.Channel_StreamingState)(0), // 11: google.cloud.video.livestream.v1.Channel.StreamingState
	(*status.Status)(nil),          // 12: google.rpc.Status
}
var file_google_cloud_video_livestream_logging_v1_logs_proto_depIdxs = []int32{
	1,  // 0: google.cloud.video.livestream.logging.v1.ChannelActivity.streaming_state_change:type_name -> google.cloud.video.livestream.logging.v1.StreamingStateChange
	2,  // 1: google.cloud.video.livestream.logging.v1.ChannelActivity.streaming_error:type_name -> google.cloud.video.livestream.logging.v1.StreamingError
	3,  // 2: google.cloud.video.livestream.logging.v1.ChannelActivity.input_accept:type_name -> google.cloud.video.livestream.logging.v1.InputAccept
	4,  // 3: google.cloud.video.livestream.logging.v1.ChannelActivity.input_error:type_name -> google.cloud.video.livestream.logging.v1.InputError
	10, // 4: google.cloud.video.livestream.logging.v1.ChannelActivity.input_disconnect:type_name -> google.cloud.video.livestream.logging.v1.InputDisconnect
	11, // 5: google.cloud.video.livestream.logging.v1.StreamingStateChange.new_state:type_name -> google.cloud.video.livestream.v1.Channel.StreamingState
	11, // 6: google.cloud.video.livestream.logging.v1.StreamingStateChange.previous_state:type_name -> google.cloud.video.livestream.v1.Channel.StreamingState
	12, // 7: google.cloud.video.livestream.logging.v1.StreamingError.error:type_name -> google.rpc.Status
	5,  // 8: google.cloud.video.livestream.logging.v1.InputAccept.input_stream_property:type_name -> google.cloud.video.livestream.logging.v1.InputStreamProperty
	5,  // 9: google.cloud.video.livestream.logging.v1.InputError.input_stream_property:type_name -> google.cloud.video.livestream.logging.v1.InputStreamProperty
	12, // 10: google.cloud.video.livestream.logging.v1.InputError.error:type_name -> google.rpc.Status
	6,  // 11: google.cloud.video.livestream.logging.v1.InputStreamProperty.video_streams:type_name -> google.cloud.video.livestream.logging.v1.VideoStream
	8,  // 12: google.cloud.video.livestream.logging.v1.InputStreamProperty.audio_streams:type_name -> google.cloud.video.livestream.logging.v1.AudioStream
	7,  // 13: google.cloud.video.livestream.logging.v1.VideoStream.video_format:type_name -> google.cloud.video.livestream.logging.v1.VideoFormat
	9,  // 14: google.cloud.video.livestream.logging.v1.AudioStream.audio_format:type_name -> google.cloud.video.livestream.logging.v1.AudioFormat
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_video_livestream_logging_v1_logs_proto_init() }
func file_google_cloud_video_livestream_logging_v1_logs_proto_init() {
	if File_google_cloud_video_livestream_logging_v1_logs_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChannelActivity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingStateChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputAccept); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputStreamProperty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputDisconnect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ChannelActivity_StreamingStateChange)(nil),
		(*ChannelActivity_StreamingError)(nil),
		(*ChannelActivity_InputAccept)(nil),
		(*ChannelActivity_InputError)(nil),
		(*ChannelActivity_InputDisconnect)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_video_livestream_logging_v1_logs_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_video_livestream_logging_v1_logs_proto_goTypes,
		DependencyIndexes: file_google_cloud_video_livestream_logging_v1_logs_proto_depIdxs,
		MessageInfos:      file_google_cloud_video_livestream_logging_v1_logs_proto_msgTypes,
	}.Build()
	File_google_cloud_video_livestream_logging_v1_logs_proto = out.File
	file_google_cloud_video_livestream_logging_v1_logs_proto_rawDesc = nil
	file_google_cloud_video_livestream_logging_v1_logs_proto_goTypes = nil
	file_google_cloud_video_livestream_logging_v1_logs_proto_depIdxs = nil
}
