{
"#pragma parameter target_gamma \"Target Gamma\" 2.4 0.1 5.0 0.1\n"
"#pragma parameter monitor_gamma \"Monitor Gamma\" 2.2 0.1 5.0 0.1\n"
"#pragma parameter overscan_percent_x \"Horizontal Overscan %\" 0.0 -25.0 25.0 1.0\n"
"#pragma parameter overscan_percent_y \"Vertical Overscan %\" 0.0 -25.0 25.0 1.0\n"
"#pragma parameter saturation \"Saturation\" 1.0 0.0 5.0 0.1\n"
"#pragma parameter contrast \"Contrast\" 1.0 0.0 7.5 0.1\n"
"#pragma parameter luminance \"Luminance\" 1.0 0.0 2.0 0.1\n"
"#pragma parameter bright_boost \"Brightness Boost\" 0.0 -1.0 1.0 0.1\n"
"#pragma parameter R \"Red Channel\" 1.0 0.0 2.0 0.05\n"
"#pragma parameter G \"Green Channel\" 1.0 0.0 2.0 0.05\n"
"#pragma parameter B \"Blue Channel\" 1.0 0.0 2.0 0.05\n"
"#pragma parameter ZOOM \"Zoom Factor\" 1.0 0.0 4.0 0.01\n"
"#pragma parameter XPOS \"X Modifier\" 0.0 -2.0 2.0 0.005\n"
"#pragma parameter YPOS \"Y Modifier\" 0.0 -2.0 2.0 0.005\n"
"#pragma parameter V_OSMASK \"Overscan Mask Y\" 0.0 0.0 1.0 0.001\n"
"#pragma parameter H_OSMASK \"Overscan Mask X\" 0.0 0.0 1.0 0.001\n"
"#ifdef PARAMETER_UNIFORM\n"
"uniform float target_gamma;\n"
"uniform float monitor_gamma;\n"
"uniform float overscan_percent_x;\n"
"uniform float overscan_percent_y;\n"
"uniform float saturation;\n"
"uniform float contrast;\n"
"uniform float luminance;\n"
"uniform float bright_boost;\n"
"uniform float R;\n"
"uniform float G;\n"
"uniform float B;\n"
"uniform float ZOOM;\n"
"uniform float XPOS;\n"
"uniform float YPOS;\n"
"uniform float V_OSMASK;\n"
"uniform float H_OSMASK;\n"
"#else\n"
"#define overscan_percent_x 0.0         // crop width of image by X%; default is 0.0\n"
"#define overscan_percent_y 0.0         // crop height of image by X%; default is 0.0\n"
"#define saturation 1.0                 // color saturation; default 1.0\n"
"#define monitor_gamma 2.2              // gamma setting of your current display; LCD monitors typically have a gamma of 2.2\n"
"#define target_gamma 2.4               // the gamma you want the image to have; CRT TVs typically have a gamma of 2.4\n"
"#define contrast 1.0                   // image contrast; default 1.0\n"
"#define luminance 1.0                  // image luminance; default 1.0\n"
"#define bright_boost 0.0               // adds to the total brightness. Negative values decrease it; Use values between 1.0 (totally white) and -1.0 (totally black); default is 0.0\n"
"#define R 1.0\n"
"#define G 1.0\n"
"#define B 1.0\n"
"#define ZOOM 1.0\n"
"#define XPOS 0.0\n"
"#define YPOS 0.0\n"
"#define V_OSMASK 0.0\n"
"#define H_OSMASK 0.0\n"
"#endif\n"
"// END PARAMETERS //\n"
"\n"
"/* COMPATIBILITY \n"
"   - HLSL compilers\n"
"   - Cg   compilers\n"
"*/\n"
"\n"
"struct input\n"
"{\n"
"  float2 video_size;\n"
"  float2 texture_size;\n"
"  float2 output_size;\n"
"  float  frame_count;\n"
"  float  frame_direction;\n"
"  float frame_rotation;\n"
"};\n"
"\n"
"void main_vertex\n"
"(\n"
"    float4 position    : POSITION,\n"
"    float4 color    : COLOR,\n"
"    float2 texCoord : TEXCOORD0,\n"
"\n"
"    uniform float4x4 modelViewProj,\n"
"    uniform input IN,\n"
"\n"
"    out float4 oPosition : POSITION,\n"
"    out float4 oColor    : COLOR,\n"
"    out float2 otexCoord : TEXCOORD\n"
")\n"
"{\n"
"   oPosition = mul(modelViewProj, position);\n"
"   oColor = color;\n"
"   float2 shift = 0.5 * IN.video_size / IN.texture_size;\n"
"   float2 overscan_coord = ((texCoord - shift) / ZOOM) * (1.0 - float2(overscan_percent_x / 100.0, overscan_percent_y / 100.0)) + shift;\n"
"   otexCoord = overscan_coord + float2(XPOS, YPOS);\n"
"}\n"
"\n"
"struct output \n"
"{\n"
"   float4 color    : COLOR;\n"
"};\n"
"\n"
"float3 grayscale(float3 col)\n"
"{\n"
"   // ATSC grayscale standard\n"
"   return float3(dot(col, float3(0.2126, 0.7152, 0.0722)));\n"
"}\n"
"\n"
"float4 main_fragment(float2 texCoord : TEXCOORD, in sampler2D s0 : TEXUNIT0, uniform input IN) : COLOR\n"
"{\n"
"float2 fragcoord = texCoord.xy * (IN.texture_size.xy / IN.video_size.xy);\n"
"   float3 res = tex2D(s0, texCoord).rgb; // sample the texture\n"
"   float3 gamma = float3(monitor_gamma / target_gamma); // setup ratio of display's gamma vs desired gamma\n"
"   float3 AvgLumin = float3(0.5, 0.5, 0.5);\n"
"   float3 intensity = grayscale(res); // find luminance\n"
"   float3 satColor = lerp(intensity, res, saturation); // apply saturation\n"
"   float3 conColor = lerp(AvgLumin, satColor, contrast);   // apply contrast\n"
"   conColor = pow(conColor, 1.0 / float3(gamma)); // Apply gamma correction\n"
"   conColor = saturate(conColor * luminance); // apply luminance\n"
"   conColor += float3(bright_boost); // apply brightboost\n"
"   conColor *= float3(R, G, B);\n"
"if (fragcoord.y > V_OSMASK && fragcoord.y < (1.0 - V_OSMASK))\n"
"conColor = conColor;\n"
"else\n"
"conColor = 0.0;\n"
"\n"
"if (fragcoord.x > H_OSMASK && fragcoord.x < (1.0 - H_OSMASK))\n"
"conColor = conColor;\n"
"else\n"
"conColor = 0.0;\n"
"   return float4(conColor, 1.0);\n"
"}\n"
},
