/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.ttflib;

import java.io.DataInputStream;
import java.io.IOException;

public class PuaaEntry {
    private int entryType;
    private int firstCodePoint;
    private int lastCodePoint;
    private int entryData;
    private Object value;

    PuaaEntry() {
    }

    void readHead(DataInputStream dataInputStream) throws IOException {
        this.entryType = dataInputStream.readUnsignedByte();
        int n = dataInputStream.readUnsignedByte() << 16;
        this.firstCodePoint = dataInputStream.readUnsignedShort() | n;
        this.lastCodePoint = dataInputStream.readUnsignedShort() | n;
        this.entryData = dataInputStream.readInt();
    }

    void readBody(DataInputStream dataInputStream, int n) throws IOException {
        switch (this.entryType) {
            case 1: {
                this.value = PuaaEntry.readString(dataInputStream, n, this.entryData);
                break;
            }
            case 2: {
                int[] nArray = PuaaEntry.readIntArray(dataInputStream, n, this.entryData);
                int n2 = nArray.length;
                String[] stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray[i] = PuaaEntry.readString(dataInputStream, n, nArray[i]);
                }
                this.value = stringArray;
                break;
            }
            case 3: {
                this.value = this.entryData != 0;
                break;
            }
            case 4: 
            case 5: {
                this.value = this.entryData;
                break;
            }
            case 6: 
            case 7: {
                this.value = PuaaEntry.readIntArray(dataInputStream, n, this.entryData);
                break;
            }
            case 8: {
                int[] nArray = PuaaEntry.readIntArray(dataInputStream, n, this.entryData);
                int n3 = nArray.length - 1;
                int[] nArray2 = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray2[i] = nArray[i];
                }
                String string = PuaaEntry.readString(dataInputStream, n, nArray[n3]);
                this.value = new CaseMapping(nArray2, string);
                break;
            }
            case 9: {
                int[] nArray = PuaaEntry.readIntArray(dataInputStream, n, this.entryData);
                String string = PuaaEntry.readString(dataInputStream, n, nArray[0]);
                String string2 = PuaaEntry.readString(dataInputStream, n, nArray[1]);
                this.value = new NameAlias(string, string2);
                break;
            }
            default: {
                this.value = null;
            }
        }
    }

    void setData(int n, String string) {
        this.entryType = 1;
        this.firstCodePoint = n;
        this.lastCodePoint = n;
        this.entryData = 0;
        this.value = string;
    }

    boolean extendData(int n, String string) {
        if (this.lastCodePoint + 1 != n) {
            return false;
        }
        if (this.value == null && string != null) {
            return false;
        }
        if (this.value != null && !this.value.equals(string)) {
            return false;
        }
        ++this.lastCodePoint;
        return true;
    }

    public int getFirstCodePoint() {
        return this.firstCodePoint;
    }

    public int getLastCodePoint() {
        return this.lastCodePoint;
    }

    public boolean contains(int n) {
        return n >= this.firstCodePoint && n <= this.lastCodePoint;
    }

    public Object getPropertyValue(int n) {
        if (this.value == null) {
            return null;
        }
        switch (this.entryType) {
            case 2: {
                return ((String[])this.value)[n - this.firstCodePoint];
            }
            case 6: {
                return ((int[])this.value)[n - this.firstCodePoint];
            }
        }
        return this.value;
    }

    public String getPropertyString(int n) {
        if (this.value == null) {
            return null;
        }
        switch (this.entryType) {
            case 2: {
                return ((String[])this.value)[n - this.firstCodePoint];
            }
            case 3: {
                return (Boolean)this.value != false ? "Y" : "N";
            }
            case 5: {
                return PuaaEntry.toHexString((Integer)this.value);
            }
            case 6: {
                return PuaaEntry.toHexString(((int[])this.value)[n - this.firstCodePoint]);
            }
            case 7: {
                return PuaaEntry.toHexString((int[])this.value);
            }
        }
        return this.value.toString();
    }

    static String readString(DataInputStream dataInputStream, int n, int n2) throws IOException {
        if (n2 > 0) {
            dataInputStream.reset();
            dataInputStream.skipBytes(n + n2);
            int n3 = dataInputStream.readUnsignedByte();
            byte[] byArray = new byte[n3];
            dataInputStream.readFully(byArray);
            return new String(byArray, "UTF-8");
        }
        if (n2 < 0) {
            char c;
            char c2;
            char c3;
            StringBuffer stringBuffer = new StringBuffer();
            char c4 = (char)(n2 >> 24 & 0x7F);
            if (c4 != '\u0000') {
                stringBuffer.append(c4);
            }
            if ((c3 = (char)(n2 >> 16 & 0x7F)) != '\u0000') {
                stringBuffer.append(c3);
            }
            if ((c2 = (char)(n2 >> 8 & 0x7F)) != '\u0000') {
                stringBuffer.append(c2);
            }
            if ((c = (char)(n2 >> 0 & 0x7F)) != '\u0000') {
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    static int[] readIntArray(DataInputStream dataInputStream, int n, int n2) throws IOException {
        if (n2 > 0) {
            dataInputStream.reset();
            dataInputStream.skipBytes(n + n2);
            int n3 = dataInputStream.readUnsignedShort();
            int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = dataInputStream.readInt();
            }
            return nArray;
        }
        return null;
    }

    static String toHexString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() < 4) {
            string = ("0000" + string).substring(string.length());
        }
        return string;
    }

    static String toHexString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(PuaaEntry.toHexString(nArray[i]));
        }
        return stringBuffer.toString();
    }

    public static final class NameAlias {
        public final String alias;
        public final String type;

        public NameAlias(String string, String string2) {
            this.alias = string;
            this.type = string2;
        }

        public String toString() {
            return this.alias + ";" + this.type;
        }
    }

    public static final class CaseMapping {
        public final int[] codePoints;
        public final String condition;

        public CaseMapping(int[] nArray, String string) {
            this.codePoints = nArray;
            this.condition = string;
        }

        public String toString() {
            String string = PuaaEntry.toHexString(this.codePoints);
            if (this.condition == null) {
                return string;
            }
            return string + "; " + this.condition;
        }
    }
}

