/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class TrueTypeTable {
    public abstract String tableName();

    public int tableId() {
        char[] cArray = this.tableName().toCharArray();
        int n = (cArray.length > 0 && cArray[0] >= ' ' && cArray[0] < '\u007f' ? cArray[0] : 32) << 24 | (cArray.length > 1 && cArray[1] >= ' ' && cArray[1] < '\u007f' ? cArray[1] : 32) << 16 | (cArray.length > 2 && cArray[2] >= ' ' && cArray[2] < '\u007f' ? cArray[2] : 32) << 8 | (cArray.length > 3 && cArray[3] >= ' ' && cArray[3] < '\u007f' ? cArray[3] : 32) << 0;
        return n;
    }

    public abstract String[] dependencyNames();

    public int[] dependencyIds() {
        String[] stringArray = this.dependencyNames();
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            char[] cArray = stringArray[i].toCharArray();
            nArray[i] = (cArray.length > 0 && cArray[0] >= ' ' && cArray[0] < '\u007f' ? cArray[0] : 32) << 24 | (cArray.length > 1 && cArray[1] >= ' ' && cArray[1] < '\u007f' ? cArray[1] : 32) << 16 | (cArray.length > 2 && cArray[2] >= ' ' && cArray[2] < '\u007f' ? cArray[2] : 32) << 8 | (cArray.length > 3 && cArray[3] >= ' ' && cArray[3] < '\u007f' ? cArray[3] : 32) << 0;
        }
        return nArray;
    }

    protected abstract void compile(DataOutputStream var1, TrueTypeTable[] var2) throws IOException;

    public byte[] compile(TrueTypeTable[] trueTypeTableArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.compile(dataOutputStream, trueTypeTableArray);
        dataOutputStream.flush();
        byteArrayOutputStream.flush();
        dataOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    protected abstract void decompile(DataInputStream var1, int var2, TrueTypeTable[] var3) throws IOException;

    public void decompile(byte[] byArray, TrueTypeTable[] trueTypeTableArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.decompile(dataInputStream, byArray.length, trueTypeTableArray);
        dataInputStream.close();
        byteArrayInputStream.close();
    }
}

