/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.bitsnpicas.u8m.U8MFile;
import com.kreative.bitsnpicas.u8m.U8MGlyph;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class U8MBitmapFontImporter
implements BitmapFontImporter {
    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        File file = File.createTempFile("u8m", ".u8m");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        fileOutputStream.close();
        BitmapFont[] bitmapFontArray = this.importFont(file);
        file.delete();
        return bitmapFontArray;
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        int n;
        File file = File.createTempFile("u8m", ".u8m");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) >= 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        BitmapFont[] bitmapFontArray = this.importFont(file);
        file.delete();
        return bitmapFontArray;
    }

    public BitmapFont[] importFont(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        for (long i = 0L; i <= 16L; ++i) {
            randomAccessFile.seek(i);
            if (randomAccessFile.readInt() != 1429745485) continue;
            randomAccessFile.seek(i);
            U8MFile u8MFile = new U8MFile();
            u8MFile.read(randomAccessFile, i);
            randomAccessFile.close();
            return U8MBitmapFontImporter.importFont(u8MFile);
        }
        randomAccessFile.close();
        return new BitmapFont[0];
    }

    private static BitmapFont[] importFont(U8MFile u8MFile) {
        BitmapFont bitmapFont = new BitmapFont();
        bitmapFont.setName(1, u8MFile.familyName);
        bitmapFont.setName(2, U8MBitmapFontImporter.fontStyleToString(u8MFile.style));
        bitmapFont.autoFillNames();
        bitmapFont.setLineAscent(u8MFile.lineAscent);
        bitmapFont.setLineDescent(u8MFile.lineDescent);
        bitmapFont.setLineGap(u8MFile.lineGap);
        double d = (double)u8MFile.pointSize / (double)(u8MFile.lineAscent + u8MFile.lineDescent);
        bitmapFont.setEmAscent2D((double)u8MFile.lineAscent * d);
        bitmapFont.setEmDescent2D((double)u8MFile.lineDescent * d);
        for (int i = 0; i < 0x110000; ++i) {
            int n = u8MFile.getUnicodeGlyphIndex(i);
            if (i != 0 && n == 0) continue;
            U8MGlyph u8MGlyph = (U8MGlyph)u8MFile.glyphs.get(n);
            BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph();
            bitmapFontGlyph.setCharacterWidth(u8MGlyph.advanceWidth);
            bitmapFontGlyph.setXY(u8MGlyph.xOffset, -u8MGlyph.yOffset);
            bitmapFontGlyph.setGlyph(u8MGlyph.to2DArray());
            bitmapFont.putCharacter(i, bitmapFontGlyph);
        }
        bitmapFont.setXHeight();
        bitmapFont.setCapHeight();
        return new BitmapFont[]{bitmapFont};
    }

    private static String fontStyleToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append(" Bold");
        }
        if ((n & 2) != 0) {
            stringBuffer.append(" Italic");
        }
        if ((n & 4) != 0) {
            stringBuffer.append(" Underline");
        }
        if ((n & 8) != 0) {
            stringBuffer.append(" Outline");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append(" Shadow");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append(" Condensed");
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append(" Extended");
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString().trim() : "Normal";
    }
}

