/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit.importer;

import com.kreative.bitsnpicas.FileProxy;
import com.kreative.bitsnpicas.FontExporter;
import com.kreative.bitsnpicas.FontImporter;
import com.kreative.bitsnpicas.edit.importer.BinaryBitmapFontImporterFrame;
import com.kreative.bitsnpicas.edit.importer.DualEncodingSelectionFrame;
import com.kreative.bitsnpicas.edit.importer.DualEncodingSelectionImporter;
import com.kreative.bitsnpicas.edit.importer.EncodingSelectionFrame;
import com.kreative.bitsnpicas.edit.importer.EncodingSelectionImporter;
import com.kreative.bitsnpicas.edit.importer.ImageBitmapFontImporterFrame;
import com.kreative.bitsnpicas.edit.importer.PSFEncodingSelectionFrame;
import com.kreative.bitsnpicas.edit.importer.PSFEncodingSelectionImporter;
import com.kreative.bitsnpicas.exporter.KbitxBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.KpcaxVectorFontExporter;
import com.kreative.bitsnpicas.geos.mover.GEOSMoverFrame;
import com.kreative.bitsnpicas.importer.BDFBitmapFontImporter;
import com.kreative.bitsnpicas.importer.CybikoBitmapFontImporter;
import com.kreative.bitsnpicas.importer.DSFBitmapFontImporter;
import com.kreative.bitsnpicas.importer.FNTBitmapFontImporter;
import com.kreative.bitsnpicas.importer.FONTXBitmapFontImporter;
import com.kreative.bitsnpicas.importer.FZXBitmapFontImporter;
import com.kreative.bitsnpicas.importer.HMZKBitmapFontImporter;
import com.kreative.bitsnpicas.importer.HexBitmapFontImporter;
import com.kreative.bitsnpicas.importer.KbitsBitmapFontImporter;
import com.kreative.bitsnpicas.importer.KbitxBitmapFontImporter;
import com.kreative.bitsnpicas.importer.KpcasVectorFontImporter;
import com.kreative.bitsnpicas.importer.KpcaxVectorFontImporter;
import com.kreative.bitsnpicas.importer.PSFBitmapFontImporter;
import com.kreative.bitsnpicas.importer.PlaydateBitmapFontImporter;
import com.kreative.bitsnpicas.importer.RockboxBitmapFontImporter;
import com.kreative.bitsnpicas.importer.S10BitmapFontImporter;
import com.kreative.bitsnpicas.importer.SBFBitmapFontImporter;
import com.kreative.bitsnpicas.importer.SFDBitmapFontImporter;
import com.kreative.bitsnpicas.importer.SRFontBitmapFontImporter;
import com.kreative.bitsnpicas.importer.U8MBitmapFontImporter;
import com.kreative.bitsnpicas.mover.MoverFrame;
import com.kreative.unicode.data.GlyphList;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ImportFormat {
    KBITX{

        @Override
        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".kbitx");
        }

        @Override
        public FontImporter<?> createImporter() {
            return new KbitxBitmapFontImporter();
        }

        @Override
        public FontExporter<?> createExporter() {
            return new KbitxBitmapFontExporter();
        }
    }
    ,
    KPCAX{

        @Override
        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".kpcax");
        }

        @Override
        public FontImporter<?> createImporter() {
            return new KpcaxVectorFontImporter();
        }

        @Override
        public FontExporter<?> createExporter() {
            return new KpcaxVectorFontExporter();
        }
    }
    ,
    KBITS{

        @Override
        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".kbits");
        }

        @Override
        public FontImporter<?> createImporter() {
            return new KbitsBitmapFontImporter();
        }
    }
    ,
    KPCAS{

        @Override
        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".kpcas");
        }

        @Override
        public FontImporter<?> createImporter() {
            return new KpcasVectorFontImporter();
        }
    }
    ,
    SFD{

        @Override
        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".sfd");
        }

        @Override
        public FontImporter<?> createImporter() {
            return new SFDBitmapFontImporter();
        }
    }
    ,
    BDF{

        @Override
        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".bdf");
        }

        @Override
        public FontImporter<?> createImporter() {
            return new BDFBitmapFontImporter();
        }
    }
    ,
    PSF{

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".psf", ".psfu");
        }

        public JFrame createOptionFrame(File file) throws IOException {
            return new PSFEncodingSelectionFrame(file, new PSFEncodingSelectionImporter(){

                @Override
                public FontImporter<?> createImporter(GlyphList glyphList, GlyphList glyphList2, int n) {
                    return new PSFBitmapFontImporter(glyphList, glyphList2, n, false);
                }
            });
        }
    }
    ,
    PSFGZ{

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".psf.gz", ".psfu.gz");
        }

        public JFrame createOptionFrame(File file) throws IOException {
            return new PSFEncodingSelectionFrame(file, new PSFEncodingSelectionImporter(){

                @Override
                public FontImporter<?> createImporter(GlyphList glyphList, GlyphList glyphList2, int n) {
                    return new PSFBitmapFontImporter(glyphList, glyphList2, n, true);
                }
            });
        }
    }
    ,
    SUIT(true){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".suit");
        }

        public JFrame createOptionFrame(File file) throws IOException {
            return MoverFrame.forFile(file);
        }
    }
    ,
    DFONT(false){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".dfont");
        }

        public JFrame createOptionFrame(File file) throws IOException {
            return MoverFrame.forFile(file);
        }
    }
    ,
    SRFONT{

        @Override
        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".png") && fileProxy.isImage() && new SRFontBitmapFontImporter().canImportFont(fileProxy.getImage());
        }

        @Override
        public FontImporter<?> createImporter() {
            return new SRFontBitmapFontImporter();
        }
    }
    ,
    HEX{

        @Override
        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".hex");
        }

        @Override
        public FontImporter<?> createImporter() {
            return new HexBitmapFontImporter();
        }
    }
    ,
    CVT{

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".cvt");
        }

        public JFrame createOptionFrame(File file) throws IOException {
            return GEOSMoverFrame.forFile(file);
        }
    }
    ,
    FZX{

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".fzx");
        }

        public JFrame createOptionFrame(File file) throws IOException {
            return new EncodingSelectionFrame("FZX PUA", file, new EncodingSelectionImporter(){

                @Override
                public FontImporter<?> createImporter(GlyphList glyphList) {
                    return new FZXBitmapFontImporter(glyphList);
                }
            });
        }
    }
    ,
    U8M{

        @Override
        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".u8m");
        }

        @Override
        public FontImporter<?> createImporter() {
            return new U8MBitmapFontImporter();
        }
    }
    ,
    FNT{

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".fnt") && fileProxy.startsWith(0);
        }

        public JFrame createOptionFrame(File file) throws IOException {
            return new EncodingSelectionFrame("CP1252", file, new EncodingSelectionImporter(){

                @Override
                public FontImporter<?> createImporter(GlyphList glyphList) {
                    return new FNTBitmapFontImporter(glyphList);
                }
            });
        }
    }
    ,
    FONTX{

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".ftx", ".fnt") && fileProxy.startsWith(70);
        }

        public JFrame createOptionFrame(File file) throws IOException {
            String string = Charset.forName("CP943").displayName();
            return new DualEncodingSelectionFrame("CP437", string, file, new DualEncodingSelectionImporter(){

                @Override
                public FontImporter<?> createImporter(GlyphList glyphList, String string) {
                    return new FONTXBitmapFontImporter(glyphList, string);
                }
            });
        }
    }
    ,
    ROCKBOX{

        @Override
        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".rbf", ".rb11", ".rb12", ".fnt") && fileProxy.startsWith(82);
        }

        @Override
        public FontImporter<?> createImporter() {
            return new RockboxBitmapFontImporter();
        }
    }
    ,
    CYBIKO{

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".cyf", ".fntz", ".fnty", ".fnt") && fileProxy.startsWith(1);
        }

        public JFrame createOptionFrame(File file) throws IOException {
            return new EncodingSelectionFrame("Cybiko", file, new EncodingSelectionImporter(){

                @Override
                public FontImporter<?> createImporter(GlyphList glyphList) {
                    return new CybikoBitmapFontImporter(glyphList);
                }
            });
        }
    }
    ,
    PLAYDATE{

        @Override
        public boolean recognize(FileProxy fileProxy) {
            return PlaydateBitmapFontImporter.canImportFont(fileProxy);
        }

        @Override
        public FontImporter<?> createImporter() {
            return new PlaydateBitmapFontImporter();
        }
    }
    ,
    HMZK{

        @Override
        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".hmzk");
        }

        @Override
        public FontImporter<?> createImporter() {
            return new HMZKBitmapFontImporter();
        }
    }
    ,
    DSF{

        @Override
        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".dsf");
        }

        @Override
        public FontImporter<?> createImporter() {
            return new DSFBitmapFontImporter();
        }
    }
    ,
    SBF{

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".sbf");
        }

        public JFrame createOptionFrame(File file) throws IOException {
            return new EncodingSelectionFrame("Kreative SuperLatin", file, new EncodingSelectionImporter(){

                @Override
                public FontImporter<?> createImporter(GlyphList glyphList) {
                    return new SBFBitmapFontImporter(glyphList);
                }
            });
        }
    }
    ,
    S10{

        @Override
        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".s10");
        }

        @Override
        public FontImporter<?> createImporter() {
            return new S10BitmapFontImporter();
        }
    }
    ,
    DMOV(true){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasMacCreator("DMOV") || fileProxy.hasMacCreator("movr") || (fileProxy.hasMacCreator("MACS") || fileProxy.hasMacCreator("macs")) && (fileProxy.hasMacType("ZSYS") || fileProxy.hasMacType("zsys"));
        }

        public JFrame createOptionFrame(File file) throws IOException {
            return MoverFrame.forFile(file);
        }
    }
    ,
    BINARY{

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".bin", ".rom");
        }

        public JFrame createOptionFrame(File file) throws IOException {
            return new BinaryBitmapFontImporterFrame(file);
        }
    }
    ,
    IMAGE{

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.isImage();
        }

        public JFrame createOptionFrame(File file) throws IOException {
            return new ImageBitmapFontImporterFrame(file);
        }
    };

    public final boolean macResFork;

    private ImportFormat() {
        this.macResFork = false;
    }

    private ImportFormat(boolean bl) {
        this.macResFork = bl;
    }

    public abstract boolean recognize(FileProxy var1);

    public FontImporter<?> createImporter() {
        return null;
    }

    public FontExporter<?> createExporter() {
        return null;
    }

    public JFrame createOptionFrame(File file) throws IOException {
        return null;
    }

    public static ImportFormat forFile(File file) {
        FileProxy fileProxy = new FileProxy(file);
        for (ImportFormat importFormat : ImportFormat.values()) {
            if (!importFormat.recognize(fileProxy)) continue;
            return importFormat;
        }
        return null;
    }
}

