/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit.exporter;

import com.kreative.unicode.data.EncodingList;
import com.kreative.unicode.data.GlyphList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BitmapExportU8MPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JComboBox u8mEncoding = new JComboBox<Object>(EncodingList.instance().glyphLists().toArray());
    private final JCheckBox u8mHasLoadAddress = new JCheckBox("Load Address:");
    private final JTextField u8mLoadAddress = new JTextField("$A000");

    public BitmapExportU8MPanel() {
        this.u8mEncoding.setEditable(false);
        this.u8mLoadAddress.setEnabled(false);
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel.add(this.u8mHasLoadAddress);
        jPanel.add(new JLabel("Native Encoding:"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.u8mLoadAddress, "Before");
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel3.add(jPanel2);
        jPanel3.add(this.u8mEncoding);
        JPanel jPanel4 = new JPanel(new BorderLayout(8, 8));
        jPanel4.add((Component)jPanel, "Before");
        jPanel4.add((Component)jPanel3, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel4, "First");
        this.u8mHasLoadAddress.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BitmapExportU8MPanel.this.u8mLoadAddress.setEnabled(BitmapExportU8MPanel.this.u8mHasLoadAddress.isSelected());
            }
        });
    }

    public Integer getLoadAddress() {
        if (this.u8mHasLoadAddress.isSelected()) {
            String string = this.u8mLoadAddress.getText();
            try {
                if (string.startsWith("0X") || string.startsWith("0x")) {
                    return Integer.parseInt(string.substring(2), 16);
                }
                if (string.startsWith("$")) {
                    return Integer.parseInt(string.substring(1), 16);
                }
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public GlyphList getSelectedEncoding() {
        return (GlyphList)this.u8mEncoding.getSelectedItem();
    }

    public void setSelectedEncoding(GlyphList glyphList) {
        this.u8mEncoding.setSelectedItem(glyphList);
    }
}

