/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontExporter;
import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.edit.GlyphListMenuBar;
import com.kreative.bitsnpicas.edit.GlyphListPanel;
import com.kreative.bitsnpicas.edit.SaveManager;
import com.kreative.bitsnpicas.edit.SaveRoutine;
import java.io.File;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphListFrame<G extends FontGlyph>
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final SaveManager sm;
    private final GlyphListPanel<G> panel;
    private final GlyphListMenuBar mb;

    public GlyphListFrame(File file, FontExporter<? extends Font<G>> fontExporter, Font<G> font) {
        super(font.toString());
        this.sm = new SaveManager(this, file, fontExporter, font);
        this.panel = new GlyphListPanel<G>(font, this.sm);
        this.mb = new GlyphListMenuBar(this, this.sm, font, this.panel.getGlyphList());
        this.makeUI();
    }

    public GlyphListFrame(SaveRoutine saveRoutine, Font<G> font) {
        super(font.toString());
        this.sm = new SaveManager(this, saveRoutine, font);
        this.panel = new GlyphListPanel<G>(font, this.sm);
        this.mb = new GlyphListMenuBar(this, this.sm, font, this.panel.getGlyphList());
        this.makeUI();
    }

    public void makeUI() {
        this.setJMenuBar(this.mb);
        this.setContentPane(this.panel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.sm);
        this.panel.getGlyphList().requestFocusInWindow();
    }
}

