/*
 *                           TERMS AND CONDITIONS
 *                                   FOR
 *                         OPEN SOURCE CODE LICENSE
 *                               Version 1.1
 * 
 * Japan Registry Services Co., Ltd. ("JPRS"), a Japanese corporation
 * having its head office at Chiyoda First Bldg. East 13F 3-8-1 Nishi-Kanda,
 * Chiyoda-ku, Tokyo 101-0065, Japan, grants you the license for open source
 * code specified in EXHIBIT A the "Code" subject to the following Terms and
 * Conditions ("OSCL").
 * 
 * 1. License Grant.
 *   JPRS hereby grants you a worldwide, royalty-free, non-exclusive
 *   license, subject to third party intellectual property claims:
 *   (a) under intellectual property rights (other than patent or
 *       trademark) licensable by JPRS to use, reproduce, modify, display,
 *       perform, sublicense and distribute the Code (or portions thereof)
 *       with or without modifications, and/or as part of a derivative work;
 *       or
 *   (b) under claims of the infringement through the making, using,
 *       offering to sell and/or otherwise disposing the JPRS Revised Code
 *       (or portions thereof);
 *   (c) the licenses granted in this Section 1(a) and (b) are effective on
 *       the date JPRS first distributes the Code to you under the terms of
 *       this OSCL;
 *   (d) Notwithstanding the above stated terms, no patent license is
 *       granted:
 *       1)  for a code that you delete from the Code;
 *       2)  separate from the Code; or
 *       3)  for infringements caused by:
 *            i) modification of the Code; or
 *           ii) combination of the Code with other software or devices.
 * 
 * 2. Consents.
 *   You agree that:
 *   (a) you must include a copy of this OSCL and the notice set forth in
 *       EXHIBIT A with every copy of the Code you distribute;
 *   (b) you must include a copy of this OSCL and the notice set forth in
 *       EXHIBIT A with every copy of binary form of the Code in the
 *       documentation and/or other materials provided with the distribution;
 *   (c) you may not offer or impose any terms on any source code version
 *       that alters or restricts the applicable version of this OSCL or
 *       the recipients' rights hereunder.
 *   (d) If the terms and conditions are set forth in EXHIBIT A, you must
 *       comply with those terms and conditions.
 * 
 * 3. Proprietary Information.
 *   All trademarks, service marks, patents, copyrights, trade secrets, and
 *   other proprietary rights in or related to the Code are and will remain
 *   the exclusive property of JPRS or its licensors, whether or not
 *   specifically recognized or perfected under local law except specified
 *   in this OSCL; provided however you agree and understand that the JPRS
 *   name may not be used to endorse or promote this Code without prior
 *   written approval of JPRS.
 * 
 * 4. WARRANTY DISCLAIMER.
 *   JPRS MAKES NO REPRESENTATIONS AND WARRANTIES REGARDING THE USE OF THE
 *   CODE, NOR DOES JPRS MAKE ANY REPRESENTATIONS THAT THE CODE WILL BECOME
 *   COMMERCIALLY AVAILABLE. JPRS, ITS AFFILIATES, AND ITS SUPPLIERS DO NOT
 *   WARRANT OR REPRESENT THAT THE CODE IS FREE OF ERRORS OR THAT THE CODE
 *   IS SUITABLE FOR TRANSLATION AND/OR LOCALIZATION. THE CODE IS PROVIDED
 *   ON AN "AS IS" BASIS AND JPRS AND ITS SUPPLIERS HAVE NO OBLIGATION TO
 *   CORRECT ERRORS OR TO SUPPORT THE CODE UNDER THIS OSCL FOR ANY REASON.
 *   TO THE FULL EXTENT PERMITTED BY LAW, ALL OBLIGATIONS ARE HEREBY
 *   EXCLUDED WHETHER EXPRESS, STATUTORY OR IMPLIED UNDER LAW, COURSE OF
 *   DEALING, CUSTOM, TRADE USAGE, ORAL OR WRITTEN STATEMENT OR OTHERWISE,
 *   INCLUDING BUT NOT LIMITED TO ANY IMPLIED WARRANTIES OF MERCHANTABILITY
 *   OR FITNESS FOR A PARTICULAR PURPOSE CONCERNING THE CODE.
 * 
 * 5. NO LIABILITY.
 *   UNDER NO CIRCUMSTANCES SHALL JPRS AND/OR ITS AFFILIATES, LICENSORS, OR
 *   REPRESENTATIVES BE LIABLE FOR ANY DAMAGES INCLUDING BUT NOT LIMITED TO
 *   CONSEQUENTIAL, INDIRECT, SPECIAL, PUNITIVE OR INCIDENTAL DAMAGES,
 *   WHETHER FORESEEABLE OR UNFORESEEABLE, BASED ON YOUR CLAIMS, INCLUDING,
 *   BUT NOT LIMITED TO, CLAIMS FOR LOSS OF DATA, GOODWILL, PROFITS, USE OF
 *   MONEY, INTERRUPTION IN USE OR AVAILABILITY OF DATA, STOPPAGE, IMPLIED
 *   WARRANTY, BREACH OF CONTRACT, MISREPRESENTATION, NEGLIGENCE, STRICT
 *   LIABILITY IN TORT, OR OTHERWISE.
 * 
 * 6. Indemnification.
 *   You hereby agree to indemnify, defend, and hold harmless JPRS for any
 *   liability incurred by JRPS due to your terms of warranty, support,
 *   indemnity, or liability offered by you to any third party.
 * 
 * 7. Termination.
 * 7.1 This OSCL shall be automatically terminated in the events that:
 *   (a) You fail to comply with the terms herein and fail to cure such
 *       breach within 30 days of becoming aware of the breach;
 *   (b) You initiate patent or copyright infringement litigation against
 *       any party (including a cross-claim or counterclaim in a lawsuit)
 *       alleging that the Code constitutes a direct or indirect patent or
 *       copyright infringement, in such case, this OSCL to you shall
 *       terminate as of the date such litigation is filed;
 * 7.2 In the event of termination under Sections 7.1(a) or 7.1(b) above,
 *     all end user license agreements (excluding distributors and
 *     resellers) which have been validly granted by You or any distributor
 *     hereunder prior to termination shall survive termination.
 *
 * 
 * 8. General.
 *   This OSCL shall be governed by, and construed and enforced in
 *   accordance with, the laws of Japan. Any litigation or arbitration
 *   between the parties shall be conducted exclusively in Tokyo, Japan
 *   except written consent of JPRS provides other venue.
 * 
 * 
 *                                EXHIBIT A
 * 
 * The original open source code of idnkit-2 is idnkit-1.0 developed and
 * conceived by Japan Network Information Center ("JPNIC"), a Japanese
 * association, Kokusai-Kougyou-Kanda Bldg 6F, 2-3-4 Uchi-Kanda,
 * Chiyoda-ku, Tokyo 101-0047, Japan, and JPRS modifies above original code
 * under following Terms and Conditions set forth by JPNIC.
 * 
 *                                  JPNIC
 * 
 * Copyright (c) 2000-2002 Japan Network Information Center.  All rights reserved.
 * 
 * By using this file, you agree to the terms and conditions set forth bellow.
 * 
 *                       LICENSE TERMS AND CONDITIONS
 * 
 * The following License Terms and Conditions apply, unless a different
 * license is obtained from Japan Network Information Center ("JPNIC"),
 * a Japanese association, Kokusai-Kougyou-Kanda Bldg 6F, 2-3-4 Uchi-Kanda,
 * Chiyoda-ku, Tokyo 101-0047, Japan.
 * 
 * 1. Use, Modification and Redistribution (including distribution of any
 *    modified or derived work) in source and/or binary forms is permitted
 *    under this License Terms and Conditions.
 * 
 * 2. Redistribution of source code must retain the copyright notices as they
 *    appear in each source code file, this License Terms and Conditions.
 * 
 * 3. Redistribution in binary form must reproduce the Copyright Notice,
 *    this License Terms and Conditions, in the documentation and/or other
 *    materials provided with the distribution. For the purposes of binary
 *    distribution the "Copyright Notice" refers to the following language:
 *    "Copyright (c) 2000-2002 Japan Network Information Center.  All rights reserved."
 * 
 * 4. The name of JPNIC may not be used to endorse or promote products
 *    derived from this Software without specific prior written approval of
 *    JPNIC.
 * 
 * 5. Disclaimer/Limitation of Liability: THIS SOFTWARE IS PROVIDED BY JPNIC
 *    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 *    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JPNIC BE LIABLE
 *    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 *    OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * 
 *                        JPRS Public License Notice
 *                                   For
 *                                idnkit-2.
 * 
 * The contents of this file are subject to the Terms and Conditions for
 * the Open Source Code License (the "OSCL"). You may not use this file
 * except in compliance with above terms and conditions. A copy of the OSCL
 * is available at <http://jprs.co.jp/idn/>.
 * The JPRS Revised Code is idnkit-2.
 * The Initial Developer of the JPRS Revised Code is Japan Network
 * Information Center ("JPNIC"), a Japanese association,
 * Kokusai-Kougyou-Kanda Bldg 6F, 2-3-4 Uchi-Kanda, Chiyoda-ku, Tokyo
 * 101-0047, Japan.
 * "Copyright (c) 2000-2002 Japan Network Information Center.  All rights reserved."
 * "Copyright (c) 2010-2012 Japan Registry Services Co., Ltd.  All rights reserved."
 * Contributor(s): ______________________________________.
 * 
 * If you wish to allow use of your version of this file only under the
 * above License(s) and not to allow others to use your version of this
 * file, please indicate your decision by deleting the relevant provisions
 * above and replacing them with the notice and other provisions required
 * by the above License(s). If you do not delete the relevant provisions,
 * a recipient may use your version of this file under either the above
 * License(s).
 */

/*
 * Low level API module of libidnkit.
 *
 * All the functions provided by this module requires a configuration
 * context of type 'idn_resconf_t' as an argument. The context holds
 * information described in the configuration file (idn.conf).
 * See 'resconf' module for details.
 */

#ifndef IDN_RES_H
#define IDN_RES_H 1

#ifdef __cplusplus
extern "C" {
#endif

#include <stddef.h>
#include <idn/result.h>
#include <idn/export.h>
#include <idn/resconf.h>

/*
 * Actions.
 */
typedef unsigned long idn_action_t;

#define IDN_UNICODECONV   0x00000001UL /* Local encoding -> UTF-8 */
#define IDN_MAP           0x00000002UL /* Mappings */
#define IDN_ASCLOWER      0x00000004UL /* ASCII Lowercase */
#define IDN_RTCONV        0x00000008UL /* Punycode -> UTF-8 for RTCHECK */
#define IDN_PROHCHECK     0x00000010UL /* Prohibited code point check */
#define IDN_UNASCHECK     0x00000020UL /* Unassigned code point check */
#define IDN_NFCCHECK      0x00000040UL /* NFC validation check */
#define IDN_PREFCHECK     0x00000080UL /* ACE prefix check */
#define IDN_HYPHCHECK     0x00000100UL /* Hyphen check */
#define IDN_COMBCHECK     0x00000200UL /* Combining character check */
#define IDN_CTXJCHECK     0x00000400UL /* CONTEXTJ check */
#define IDN_CTXOCHECK     0x00000800UL /* CONTEXTO check for registration */
#define IDN_CTXOLITECHECK 0x00001000UL /* CONTEXTO check for lookup */
#define IDN_BIDICHECK     0x00002000UL /* Bidi check */
#define IDN_LOCALCHECK    0x00004000UL /* Local check */
#define IDN_IDNCONV       0x00008000UL /* UTF-8 <-> Punycode */
#define IDN_LENCHECK      0x00010000UL /* Label length check */
#define IDN_RTCHECK       0x00020000UL /* Round trip check */
#define IDN_LOCALCONV     0x00040000UL /* UTF-8 -> Local encoding */
#define IDN_UNDOIFERR     0x40000000UL /* Option: undo if an error occurs */
#define IDN_LITEFORCEUTF8 0x80000000UL /* libidnkitlite option: force to con-
					* -sider the local encoding is UTF-8 */

/*
 * Combined Actions.
 */
#define IDN_ENCODE_REGIST \
	(IDN_UNICODECONV | IDN_MAP | IDN_ASCLOWER | IDN_RTCONV | \
	IDN_PROHCHECK | IDN_UNASCHECK | IDN_NFCCHECK | IDN_PREFCHECK | \
	IDN_HYPHCHECK | IDN_COMBCHECK | IDN_CTXJCHECK | IDN_CTXOCHECK | \
	IDN_BIDICHECK | IDN_IDNCONV | IDN_LENCHECK | IDN_RTCHECK | \
	IDN_LITEFORCEUTF8)
#define IDN_ENCODE_LOOKUP \
	(IDN_UNICODECONV | IDN_MAP | IDN_ASCLOWER | IDN_RTCONV | \
	IDN_PROHCHECK | IDN_UNASCHECK | IDN_NFCCHECK | IDN_PREFCHECK | \
	IDN_COMBCHECK | IDN_CTXJCHECK | IDN_CTXOLITECHECK | \
	IDN_BIDICHECK | IDN_IDNCONV | IDN_LENCHECK | IDN_RTCHECK | \
	IDN_LITEFORCEUTF8)
#define IDN_DECODE_REGIST \
	(IDN_UNICODECONV | IDN_MAP | IDN_ASCLOWER | IDN_IDNCONV | \
	IDN_PROHCHECK | IDN_UNASCHECK | IDN_NFCCHECK | IDN_PREFCHECK | \
	IDN_HYPHCHECK | IDN_COMBCHECK | IDN_CTXJCHECK | IDN_CTXOCHECK | \
	IDN_BIDICHECK | IDN_RTCHECK | IDN_LOCALCONV | IDN_LITEFORCEUTF8)
#define IDN_DECODE_LOOKUP \
	(IDN_UNICODECONV | IDN_MAP | IDN_ASCLOWER | IDN_IDNCONV | \
	IDN_PROHCHECK | IDN_UNASCHECK | IDN_NFCCHECK | IDN_PREFCHECK | \
	IDN_COMBCHECK | IDN_CTXJCHECK | IDN_CTXOLITECHECK | \
	IDN_BIDICHECK | IDN_RTCHECK | IDN_LOCALCONV | IDN_LITEFORCEUTF8)

#define IDN_COMPARE_REGIST IDN_ENCODE_REGIST
#define IDN_COMPARE_LOOKUP IDN_ENCODE_LOOKUP
#define IDN_CHECK_REGIST   IDN_ENCODE_REGIST
#define IDN_CHECK_LOOKUP   IDN_ENCODE_LOOKUP

/*
 * These macros are provided for backward compatibility to idnkit 1.x.
 */
#define IDN_ENCODE_STORED  IDN_ENCODE_REGIST
#define IDN_ENCODE_QUERY   IDN_ENCODE_LOOKUP
#define IDN_ENCODE_APP     IDN_ENCODE_LOOKUP
#define IDN_DECODE_STORED  IDN_DECODE_REGIST
#define IDN_DECODE_QUERY   IDN_DECODE_LOOKUP
#define IDN_DECODE_APP     IDN_DECODE_LOOKUP

/*
 * Encode an internationalized domain name.
 *
 * The function converts a domain name 'from' and writes the result on 'to',
 * at most 'tolen' bytes. Note that 'from' must be terminated by NUL, and
 * 'tolen' includes room for a NUL character.
 *
 * The argument 'actions' specifies which steps in the entire encoding
 * process should be performed. The following list shows action names
 * corresponding with steps of the encoding process. The function 
 * performs the steps in that order.
 *
 *    1. IDN_UNICODECONV
 *       Convert a domain name from local encoding (e.g. ISO-8859-1) to UTF-8.
 *    2. IDN_MAP
 *       Perform mappings (NFC, Lowercase conversion, etc.).
 *    3. IDN_ASCLOWER
 *       Convert ASCII uppercase letters (A..Z) to lowercase (a..z).
 *    4. IDN_RTCONV
 *       Convert A-labels to U-labels.
 *    5. IDN_PROHCHECK
 *       Check prohibited code points.
 *    6. IDN_UNASCHECK
 *       Check unassigned code points.
 *    7. IDN_NFCCHECK
 *       Check labels are in NFC.
 *    8. IDN_PREFCHECK
 *       Check labels containing "--" in the 3rd and 4th characters.
 *    9. IDN_HYPHCHECK
 *       Check labels beginning/ending with "-".
 *   10. IDN_COMBCHECK
 *       Check labels beginning with a combining mark.
 *   11. IDN_CTXJCHECK
 *       Check CONTEXTJ code points.
 *  12a. IDN_CTXOCHECK
 *       Check CONTEXTO code points for the registration protocol.
 *  12b. IDN_CTXOLITECHECK
 *       Check CONTEXTO code points for the lookup protocol.
 *   13. IDN_BIDICHECK
 *       Check requirements specified in [IDNA2008-BIDI].
 *   14. IDN_LOCALCHECK
 *       Perform local check (optional).
 *   15. IDN_IDNCONV
 *       Convert labels in UTF-8 to Punycode.
 *   16. IDN_LENCHECK
 *       Check length of each label.
 *   17. IDN_RTCHECK
 *       Perform round trip check for each label.
 *
 * Between the step 2 and 3, the domain name is split into labels.
 * The step 3 through 17 are applied to each label. After the step 17,
 * labels are joined with a separator '.'.
 *
 * A value of bitwise-OR of some actions can be specified, like:
 *
 *   result = idn_res_encodename(ctx, IDN_UNICODECONV | IDN_MAP,
 *                               from, to, tolen);
 *
 * Also the following actions are provided for convenience:
 *
 *   IDN_ENCODE_REGIST
 *      Encode a domain name with IDNA2008 registration protocol.
 *      libidnkit performs the step 1..11, 12a, 13 and 15..17.
 *      libidnkitlite performs the step 2..11, 12a, 13 and 15..17.
 *
 *   IDN_ENCODE_LOOKUP
 *      Encode a domain name with IDNA2008 lookup protocol.
 *      libidnkit performs the step 1..8, 10, 11, 12b, 13 and 15..17.
 *      libidnkitlite performs the step 2..8, 10, 11, 12b, 13 and 15..17.
 *
 * The following action is not an actual step of the encoding process,
 * but it can be specified with other actions described above.
 *
 *   IDN_UNDOIFERR	-- If any step fails, the original input name is
 *                         returned.
 *
 * If no flags are specified, the function just copies 'from' to 'to'.
 *
 * Returns:
 *   idn_success            -- Ok.
 *   idn_invalid_action	    -- Invalid action flag specified.
 *   idn_invalid_encoding   -- The given string has invalid byte sequence.
 *   idn_buffer_overflow    -- 'tolen' is too small.
 *   idn_nomemory           -- malloc() failed.
 *   idn_nomapping          -- At IDN_LOCALCONV or IDN_UNICODECONV, the
 *                             corresponding character doesn't exist in
 *                             the destination encoding.
 *   idn_prohcheck_error    -- IDN_PROHCHECK failed.
 *   idn_unascheck_error    -- IDN_UNASCHECK failed.
 *   idn_nfccheck_error     -- IDN_NFCCHECK failed.
 *   idn_prefcheck_error    -- IDN_PREFCHECK failed.
 *   idn_hyphcheck_error    -- IDN_HYPHCHECK failed.
 *   idn_combcheck_error    -- IDN_COMBCHECK failed.
 *   idn_ctxjcheck_error    -- IDN_CTXJCHECK failed.
 *   idn_ctxocheck_error    -- IDN_CTXOCHECK or IDN_CTXOLITECHECK failed.
 *   idn_bidicheck_error    -- IDN_BIDICHECK failed.
 *   idn_localcheck_error   -- IDN_LOCALCHECK failed.
 *   idn_lencheck_error     -- IDN_LENCHECK failed.
 *   idn_rtcheck_error      -- IDN_RTCHECK failed.
 */
IDN_EXPORT idn_result_t
idn_res_encodename(idn_resconf_t ctx, idn_action_t actions, const char *from,
		   char *to, size_t tolen);

/*
 * Decode an internationalized domain name.
 *
 * The function converts a domain name 'from' and writes the result on 'to',
 * at most 'tolen' bytes. Note that 'from' must be terminated by NUL, and
 * 'tolen' includes room for a NUL character.
 *
 * The argument 'actions' specifies which steps in the entire decoding
 * process should be performed. The following list shows action names
 * corresponding with steps of the decoding process. The function 
 * performs the steps in that order.
 *
 *    1. IDN_UNICODECONV
 *       Convert a domain name from local encoding (e.g. ISO-8859-1) to UTF-8.
 *    2. IDN_MAP
 *       Perform mappings (NFC, Lowercase conversion, etc.).
 *    3. IDN_ASCLOWER
 *       Convert ASCII uppercase letters (A..Z) to lowercase (a..z).
 *    4. IDN_IDNCONV
 *       Convert A-labels to U-labels.
 *    5. IDN_PROHCHECK
 *       Check prohibited code points.
 *    6. IDN_UNASCHECK
 *       Check unassigned code points.
 *    7. IDN_NFCCHECK
 *       Check labels are in NFC.
 *    8. IDN_PREFCHECK
 *       Check labels containing "--" in the 3rd and 4th characters.
 *    9. IDN_HYPHCHECK
 *       Check labels beginning/ending with "-".
 *   10. IDN_COMBCHECK
 *       Check labels beginning with a combining mark.
 *   11. IDN_CTXJCHECK
 *       Check CONTEXTJ code points.
 *  12a. IDN_CTXOCHECK
 *       Check CONTEXTO code points for the registration protocol.
 *  12b. IDN_CTXOLITECHECK
 *       Check CONTEXTO code points for the lookup protocol.
 *   13. IDN_BIDICHECK
 *       Check requirements specified in [IDNA2008-BIDI].
 *   14. IDN_LOCALCHECK
 *       Perform local check (optional).
 *   15. IDN_RTCHECK
 *       Perform round trip check for each label.
 *   16. IDN_LOCALCONV
 *       Convert a domain name from UTF-8 to local encoding (e.g. ISO-8859-1).
 *
 * Between the step 2 and 3, the domain name is split into labels.
 * The step 3 through 15 are applied to each label. After the step 15,
 * labels are joined with a separator '.'.
 *
 * A value of bitwise-OR of some actions can be specified, like:
 *
 *   result = idn_res_decodename(ctx, IDN_IDNCONV | IDN_LOCALCONV,
 *                               from, to, tolen);
 *
 * Also the following actions are provided for convenience:
 *
 *   IDN_DECODE_REGIST
 *      Decode a domain name with IDNA2008 registration protocol.
 *      libidnkit performs the step 1..11, 12a, 13, 15 and 16.
 *      libidnkitlite performs the step 2..11, 12a, 13 and 15.
 *
 *   IDN_DECODE_LOOKUP
 *      Decode a domain name with IDNA2008 lookup protocol.
 *      libidnkit performs the step 1..8, 10, 11, 12b, 13, 15 and 16.
 *      libidnkitlite performs the step 2..8, 10, 11, 12b, 13 and 15.
 *
 *
 * The following action is not an actual step of the decoding process,
 * but it can be specified with other actions described above.
 *
 *   IDN_UNDOIFERR	-- If any step fails, the original input name is
 *                         returned.
 *
 * If no flags are specified, the function just copies 'from' to 'to'.
 *
 * Returns:
 *   idn_success            -- Ok.
 *   idn_invalid_action	    -- Invalid action flag specified.
 *   idn_invalid_encoding   -- The given string has invalid byte sequence.
 *   idn_buffer_overflow    -- 'tolen' is too small.
 *   idn_nomemory           -- malloc() failed.
 *   idn_nomapping          -- At IDN_LOCALCONV or IDN_UNICODECONV, the
 *                             corresponding character doesn't exist in
 *                             the destination encoding.
 *   idn_prohcheck_error    -- IDN_PROHCHECK failed.
 *   idn_unascheck_error    -- IDN_UNASCHECK failed.
 *   idn_nfccheck_error     -- IDN_NFCCHECK failed.
 *   idn_prefcheck_error    -- IDN_PREFCHECK failed.
 *   idn_hyphcheck_error    -- IDN_HYPHCHECK failed.
 *   idn_combcheck_error    -- IDN_COMBCHECK failed.
 *   idn_ctxjcheck_error    -- IDN_CTXJCHECK failed.
 *   idn_ctxocheck_error    -- IDN_CTXOCHECK or IDN_CTXOLITECHECK failed.
 *   idn_bidicheck_error    -- IDN_BIDICHECK failed.
 *   idn_localcheck_error   -- IDN_LOCALCHECK failed.
 */
IDN_EXPORT idn_result_t
idn_res_decodename(idn_resconf_t ctx, idn_action_t actions, const char *from,
		   char *to, size_t tolen);

/*
 * Decode an internationalized domain name with auxiliary encoding
 * support.
 *
 * The function works the same as idn_res_decodename(), but an encoding
 * conversion from 'auxencoding' to UTF-8 is performed prior to the actual
 * decode process (see idn_res_decodename() above).
 *
 * If 'auxencoding' is NULL, 'from' is treated as UTF-8.
 */
IDN_EXPORT idn_result_t
idn_res_decodename2(idn_resconf_t ctx, idn_action_t actions, const char *from,
		    char *to, size_t tolen, const char *auxencoding);

/*
 * Compare two domain names.
 *
 * The functions encodes domain names 'name1' and 'name2' as
 * idn_res_encodename() does, and then compares them.
 * If they are equivalent, it returns 'idn_success'. Otherwise,
 * it returns 'idn_neq'. When an error occurs in the encoding process,
 * the function returns the correspoinding error code
 * (see idn_res_encodename() above).
 *
 * Returns:
 *   idn_success            -- 'name1' and 'name2' are equivalent.
 *   idn_neq                -- 'name1' and 'name2' are different.
 *   (other error codes)    -- See idn_res_encodename().
 */
IDN_EXPORT idn_result_t
idn_res_comparenames(idn_resconf_t ctx, idn_action_t actions,
		     const char *name1, const char *name2);

/*
 * Compare two domain names.
 *
 * The function works the same as idn_res_comparenames(), but it performs
 * 'actions1' when it encodes 'name1' and it perfomrs 'actions2' when
 * it encodes 'name2' respectively.
 */
IDN_EXPORT idn_result_t
idn_res_comparenames2(idn_resconf_t ctx,
		      idn_action_t actions1, const char *name1,
		      idn_action_t actions2, const char *name2);

/*
 * Check a domain name.
 *
 * The function internally creates a copy of 'name', performs
 * the encoding process 'actions' for it, and returns its error code
 * as idn_res_encodename() does.
 */
IDN_EXPORT idn_result_t
idn_res_checkname(idn_resconf_t ctx, idn_action_t actions, const char *name);

/*
 * The function is provided for backward compatibility to idnkit 1.x.
 */
IDN_EXPORT void
idn_res_enable(int on_off);

#ifdef __cplusplus
}
#endif

#endif /* IDN_RES_H */
