###############################################################################
#
# firstpass.awk
#
###############################################################################
#
#       Matthew Doar    April 1997
#
###############################################################################
#
# Scan a file until plot is seen, outputting lines unchanged. Adjust the plot
# line to use the correct filename, then stop writing out lines
#
#
BEGIN {
# EOC : End Of gnuplot Commands
  EOC = 0;
  OUTPUTFILE = FILENAME
  
  i = 1;
}

{
  if ($1 == "plot")
    {
      EOC = 1;
# Modify the plot line and write it out
      while (i <= NF)
	{
	  if ($i == "'-'") 
	    {
	      printf " '%s.data3.5' ", OUTPUTFILE
	    }
	  else
	    {
	      printf " %s ", $i
	    }
	  i++;
	} 
      printf "\n"

      printf "pause -1 \"Wait ... press RETURN to exit after the graph has appeared\"\n"
      printf "set output\n"
      printf "# End of gnuplot3.5 command file\n" 
   }

# Not reached the plot command yet
  if (EOC != 1)
    {
      printf "%s\n", $0
    }
}

END {
}
# End of script
