/*
 * exec: A plugin for the Video Disk Recorder
 * Copyright (C) 2007  Winfried Koehler
 * Licence GPL
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */

#ifndef __EXEC_MENU_H_
#define __EXEC_MENU_H_

#include <vdr/plugin.h>
#include "exectimer.h"

void log(int loglevel, const char * s, ...);

/****************************************************************************** 
 * cExecSetup
 *****************************************************************************/

class cExecSetup {
 public:
  int logLevel;
  int logFile;
  int logLength;
  int showMainMenu;
  int enableSVDRP;
  cExecSetup(void);
};
extern cExecSetup ExecSetup;


/****************************************************************************** 
 * cMenuExec
 * -> Plugins setup page
 *****************************************************************************/

class cMenuExec : public cMenuSetupPage {
 private:
   cExecSetup data;
 protected:
   virtual void Store(void);
 public:
   cMenuExec(void);
   ~cMenuExec(void);
  virtual eOSState ProcessKey(eKeys Key);
};


/****************************************************************************** 
 * cMenuExecTimers
 * -> Menu for Viewing/Editing exec timers
 *****************************************************************************/

class cMenuExecTimers : public cOsdMenu {
private:
  int helpKeys;
  eOSState Edit(void);
  eOSState New(void);
  eOSState Run(void);
  eOSState Delete(void);
  cExecTimer *CurrentExecTimer(void);
  void SetHelpKeys(void);
public:
  cMenuExecTimers(void);
  virtual ~cMenuExecTimers();
  virtual eOSState ProcessKey(eKeys Key);
  };

#endif
