/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BuiltinClass
extends Operand {
    private final Type type;

    public BuiltinClass(Type type2) {
        this.type = type2;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.BUILTIN_CLASS;
    }

    public String toString() {
        return "<Class:" + (Object)((Object)this.type) + ">";
    }

    @Override
    public boolean canCopyPropagate() {
        return true;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return this;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.type.ordinal());
    }

    public static BuiltinClass decode(IRReaderDecoder d) {
        Type type2 = Type.fromOrdinal(d.decodeInt());
        switch (type2) {
            case ARRAY: {
                return d.getCurrentScope().getManager().getArrayClass();
            }
            case HASH: {
                return d.getCurrentScope().getManager().getHashClass();
            }
            case OBJECT: {
                return d.getCurrentScope().getManager().getObjectClass();
            }
        }
        throw new RuntimeException("BuiltinClass has unknown type");
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        switch (this.type) {
            case ARRAY: {
                return context.getRuntime().getArray();
            }
            case HASH: {
                return context.getRuntime().getHash();
            }
            case OBJECT: {
                return context.getRuntime().getObject();
            }
        }
        throw new RuntimeException("BuiltinClass has unknown type");
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuiltinClass(this);
    }

    public static enum Type {
        OBJECT,
        ARRAY,
        HASH;


        public static Type fromOrdinal(int value2) {
            return value2 < 0 || value2 >= Type.values().length ? null : Type.values()[value2];
        }
    }
}

