/*********************************************************************
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ===================================================================
 * Revision History ::
 * YYYY.MM.DD   Change ID       Developer
 *              Description
 * -------------------------------------------------------------------
 * 2002.04.25                   Vlad Skarzhevskyy
 *              Initial implementation.
 *
 * ===================================================================
 *
 ********************************************************************/

#include "pure-sfv.h"

int _debug_on_ = 0;

int initParams(pure_sfv_params* params)
{
    memset(params, 0, sizeof(pure_sfv_params));
    params->mode = MODE_DEFAULT;

    params->sfv_dir[0] = '\0';
    init_string_array(&params->sfv_files);
    init_string_array(&params->files);

    params->quiet = 0;
    params->create_recurse_subdirectories = 0;
    params->force_create = 0;
    params->name_place_holder = 'X';
    params->win_sfv = 1;
    params->windows_pause = 0;
    params->create_m3u = 0;
    params->recurse_subdirectories = 0;
    params->ignore_case = 0;
    params->ignore_dir_name = 0;
    params->ignore_nofiles_sfv = 0;
    params->list_files = 0;
    params->tested_db_use = 0;

    params->tested_db_filename[0] = '\0';

    params->par_create = 0;
    params->par_recovery_ratio = 14;

    initCnt(&(params->cnt));
    return 0;
}

int debugParams(pure_sfv_params* params)
{
    DBUG_PRINT("PARAMS", ("sfv_dir = [%s]", params->sfv_dir));
    debug_string_array("sfv_files", &params->sfv_files);
    debug_string_array("files", &params->files);

    return 0;
}

int initCnt(pure_sfv_counters* cnt)
{
    cnt->sfv_tested = 0;
    cnt->files_tested = 0;
    cnt->files_ok = 0;
    cnt->files_not_found = 0;
    cnt->files_found = 0;
    cnt->files_broken = 0;
    cnt->sfv_created = 0;
    cnt->files_added = 0;
    cnt->files_ignored = 0;
    cnt->directories_scaned = 0;
    return 0;
}

int addCnt(pure_sfv_counters* cnt, pure_sfv_counters* to_add)
{
    cnt->sfv_tested += to_add->sfv_tested;
    cnt->files_tested += to_add->files_tested;
    cnt->files_ok += to_add->files_ok;
    cnt->files_not_found += to_add->files_not_found;
    cnt->files_broken += to_add->files_broken;
    cnt->sfv_created += to_add->sfv_created;
    cnt->files_added += to_add->files_added;
    cnt->files_ignored += to_add->files_ignored;
    cnt->directories_scaned += to_add->directories_scaned;
    return 0;
}


void ifNeedDirectory(pure_sfv_params* params, char* filename)
{
    char *dir;
    if ((params->cd_sfv_file_location) && (params->sfv_dir[0] == '\0'))
    {
        dir = getFilePath(filename);
        if (dir)
        {
            DBUG_PRINT("acepted dir", ("%s", dir));
            strncpy(params->sfv_dir, dir, MAX_STRING_LEN);
        }
    }
}

char* stripExtraPath(pure_sfv_params* params, char* filename)
{
    char *dir;
    if ((params->cd_sfv_file_location) && (params->sfv_dir[0] != '\0'))
    {
        DBUG_PRINT("stripExtraPath", ("%s", filename));
        dir = getFilePath(filename);
        if (dir == NULL) return filename;
        if (strcmp(dir, params->sfv_dir) == 0)
        {
            return getBaseName(filename);
        }
        return filename;
    }
    else
    {
        return filename;
    }
}

int attr_base(int attr)
{
    return (attr & PARAM_NAME_MASK);
}

void attr_set(int* pattr, int attr_flag)
{
     *pattr = (attr_base(*pattr) | attr_flag);
}

int attr_is_set(int attr, int attr_flag)
{
     return  (attr & attr_flag);
}

/* Exclude or include files in command line Wildcard */

int includeFile(char* filename, pure_sfv_params* params)
{
    int default_return = 1;
    int i;
    if (params->files.len == 0) {
        return 1;
    }
    for (i = 0; i < params->files.len; i++) {
        if (attr_base(params->files.attr[i]) != PARAM_MASK_EXCLUDE) {
            default_return = 0;
        }
        if (match(params->files.strs[i], filename, params->ignore_case)) {
            switch (attr_base(params->files.attr[i])) {
                case PARAM_NAME:
                                attr_set(&(params->files.attr[i]), PARAM_NAME_FOUND);
                                return 1;
                case PARAM_MASK_INCLUDE:
                                return 1;
                case PARAM_MASK_EXCLUDE:
                                return 0;
            }
        }
    }
    return default_return;
}

int includeFileSFV(char* filename, pure_sfv_params* params)
{
    int i;
    if (params->sfv_files.len == 0) {
        return 1;
    }
    for(i = 0; i < params->sfv_files.len; i++) {
        if (match(params->sfv_files.strs[i], filename, params->ignore_case)) {
            switch(attr_base(params->sfv_files.attr[i])) {
                case PARAM_NAME:
                                attr_set(&(params->sfv_files.attr[i]), PARAM_NAME_FOUND);
                                return 1;
                case PARAM_MASK_INCLUDE:
                                return 1;
                case PARAM_MASK_EXCLUDE:
                                return 0;
            }
        }
    }
    return 0;
}


void init_string_array(string_array *ar)
{
    int i;
    memset(ar, 0, sizeof(string_array));
    ar->len = 0;
    ar->names_cnt = 0;
    for (i = 0; i < MAX_STRING_ARRAY_LEN; i++) {
        ar->strs[i][0] = '\0';
        ar->attr[i] = 0;
    }
}

void add_string_array(string_array *ar, char* str, param_attribute attr)
{
    int len = 0;
    if (str == NULL) return;
    if (ar->len == MAX_STRING_ARRAY_LEN) {
        fprintf(stderr, "sfv: error, config array limit to add %s\n", str);
        return;
    }

    len = strlen(str);
    if (len >= MAX_STRING_LEN) {
        fprintf(stderr, "sfv: error, string too long %s\n", str);
        return;
    }
    if (len == 0) {
        /* Ignore empty string */
        return;
    }
    DBUG_PRINT("array_add", ("%s", str));

    strncpy(ar->strs[ar->len], str, MAX_STRING_LEN);
    ar->attr[ar->len] = attr;
    ar->len ++;
    if (attr_base(attr) == PARAM_NAME) {
       ar->names_cnt ++;
    }
}

void debug_string_array(char* name, string_array *ar)
{
    int i;
    DBUG_PRINT("array", ("%s len = [%i] names_cnt = [%i]", name, ar->len, ar->names_cnt));
    for (i = 0; i < ar->len; i++) {
        DBUG_PRINT("array", ("%s[%i] = [%s] [%i]", name, i, ar->strs[i], ar->attr[i]));
    }
}


/* EOF */

