
/*

    dockhelper.h - Header file with definitions
    Copyright (C) 2002-2004 Mario Pascucci <ilpettegolo (a) yahoo it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    or
    visit the URL http://www.fsf.org/


*/

/* prevent multiple inclusion */
#ifndef _MP_DOCKHELPER


#ifndef _XLIB_H_
#include <X11/Xlib.h>
#endif


#ifdef __cplusplus
extern "C" {
#endif


/* define header ID */
#define _MP_DOCKHELPER

/* utility defs */
#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

  
/* header definitions starts here */

/* maximum areas allowed */
#define DH_MAXAREAS   16
/* max colors used */
#define DH_MAXCOLORS  32
/* max applet size */
#define DH_MAXSIZE    200
/* max border */
#define DH_MAXBORDER  5
/* icon size */
#define DH_ICONX      10
#define DH_ICONY      6


  
struct dh_areas {
  int x,y,w,h;	    /* area location and size */
  void (*handler)();	/* handler callback */
  int enabled;	    /* if area is enabled */
  int bevel;	    /* if area has a bevel */
};



struct dh_color {
  long	pixel;	    /* X color pixel value */
  char *name;	    /* full color name (case insensitive) */
};



/* create pixmaps for icons */
void dh_pixmap(Pixmap *p, Pixmap *m, char *xpm[]);

/* scroll pixmap 1 pixel to right */
void dh_scroll(Pixmap p, int xs, int ys, int w, int h);

/* create utility pixmap for scrolling area */
void dh_newpixmap(Pixmap *p, int w, int h);

/* copy pixmap for icons */
void dh_copyarea(Pixmap src, int xs, int ys, int xd, int yd, int w, int h);

/* return display */
Display *dh_display(void);

/* return background color */
char *dh_background(void);

/* get and eventually allocate X color in colormap
   select colors by name */
long dh_getcolor(char *name);

/* define an area
   x,y position of upper left corner
   w,h width and height of area
   bevel flag for bevel
   handler callback pointer fo handler on click, NULL if no handler needs
   returns an handler to area */
int dh_addarea(int x, int y, int w, int h, int bevel, void (*handler)());

/* find an area from coord */
int dh_getarea(int x, int y);

/* setup applet size */
int dh_setsize(int width, int height, int border);

/* returns usable sizes of an area */
void dh_getsize(int handler, int *x, int *y, int *w, int *h);

/* draw areas bevel */
void dh_bevel(void);

/* create applet window */
int dh_mainwin(char *name, char *background);

/* updates applet area on screen */
void dh_update(void);

/* draw line using predefined gc */
void dh_line(int x1, int y1, int x2, int y2);

/* draw hollow rectangle */
void dh_rectangle(int x, int y, int w, int h);

/* draw filled rectangle */
void dh_fillrect(int x, int y, int w, int h);

/* set current color */
void dh_color(char *color);


#ifdef __cplusplus
}
#endif

#endif /* _MP_DOCKHELPER */


