#ifndef SLTDL_H
#define SLTDL_H

#include "sltdl_api.h"

#ifdef __cplusplus
extern "C" {
#endif

/**********************************************************************/
/*                                                                    */
/* this header povides projects that depend on ltdl's interfaces the  */
/* most necessary macro definitions, type definitions, and forward    */
/* declarations.                                                      */
/*                                                                    */
/* if your library or utility does not yet use libltdl, then it is    */
/* strongly recommended that you use the various posix interfaces as  */
/* defined in <dlfcn.h>, and accordingly refrain from using libsltdl  */
/* altogether.                                                        */
/*                                                                    */
/**********************************************************************/

#define LT_PATHSEP_CHAR ':'

typedef struct lt_modctx * lt_dlhandle;
typedef struct lt_modctl * lt_dladvise;

/* global reference-counting */
lt_api int lt_dlinit(void);
lt_api int lt_dlexit(void);

/* library search path */
lt_api int          lt_dlpathopen(const char *, const char **);
lt_api int          lt_dladdsearchdir(const char *);
lt_api int          lt_dlinsertsearchdir(const char *, const char *);
lt_api int          lt_dlsetsearchpath(const char *);
lt_api const char * lt_dlgetsearchpath(void);

/* module interfaces */
lt_api lt_dlhandle  lt_dlopen(const char *);
lt_api lt_dlhandle  lt_dlopenext(const char *);
lt_api lt_dlhandle  lt_dlopenadvise(const char *, struct lt_modctl *);

lt_api void *       lt_dlsym(lt_dlhandle, const char *);
lt_api int          lt_dlclose(lt_dlhandle);
lt_api const char * lt_dlerror(void);

#ifdef __cplusplus
}
#endif

#endif
