       SUBROUTINE DRTU1(ICHARN,IOP,X,Y,NUMCO,IXMINS,IXMAXS,IXDELS,
     1IBUGD2,IFOUND,IERROR)
C
C     PURPOSE--DEFINE AND SET THE HERSHEY CHARACTER SET COORDINATES
C              FOR ROMAN TRIPLEX UPPER CASE (PART 1).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--87/4
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MARCH     1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MARCH     1987.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IOP
      CHARACTER*4 IBUGD2
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IOPERA
C
C---------------------------------------------------------------------
C
      DIMENSION IOP(*)
      DIMENSION X(*)
      DIMENSION Y(*)
C
      DIMENSION IOPERA(300)
      DIMENSION IX(300)
      DIMENSION IY(300)
C
      DIMENSION IXMIND(30)
      DIMENSION IXMAXD(30)
      DIMENSION IXDELD(30)
      DIMENSION ISTARD(30)
      DIMENSION NUMCOO(30)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C     DEFINE CHARACTER   3001--UPPER CASE A
C
      DATA IOPERA(   1),IX(   1),IY(   1)/'MOVE',   0,  12/
      DATA IOPERA(   2),IX(   2),IY(   2)/'DRAW',  -7,  -8/
      DATA IOPERA(   3),IX(   3),IY(   3)/'MOVE',  -1,   9/
      DATA IOPERA(   4),IX(   4),IY(   4)/'DRAW',   5,  -9/
      DATA IOPERA(   5),IX(   5),IY(   5)/'MOVE',   0,   9/
      DATA IOPERA(   6),IX(   6),IY(   6)/'DRAW',   6,  -9/
      DATA IOPERA(   7),IX(   7),IY(   7)/'MOVE',   0,  12/
      DATA IOPERA(   8),IX(   8),IY(   8)/'DRAW',   7,  -9/
      DATA IOPERA(   9),IX(   9),IY(   9)/'MOVE',  -5,  -3/
      DATA IOPERA(  10),IX(  10),IY(  10)/'DRAW',   4,  -3/
      DATA IOPERA(  11),IX(  11),IY(  11)/'MOVE',  -9,  -9/
      DATA IOPERA(  12),IX(  12),IY(  12)/'DRAW',  -3,  -9/
      DATA IOPERA(  13),IX(  13),IY(  13)/'MOVE',   2,  -9/
      DATA IOPERA(  14),IX(  14),IY(  14)/'DRAW',   9,  -9/
      DATA IOPERA(  15),IX(  15),IY(  15)/'MOVE',  -7,  -8/
      DATA IOPERA(  16),IX(  16),IY(  16)/'DRAW',  -8,  -9/
      DATA IOPERA(  17),IX(  17),IY(  17)/'MOVE',  -7,  -8/
      DATA IOPERA(  18),IX(  18),IY(  18)/'DRAW',  -5,  -9/
      DATA IOPERA(  19),IX(  19),IY(  19)/'MOVE',   5,  -8/
      DATA IOPERA(  20),IX(  20),IY(  20)/'DRAW',   3,  -9/
      DATA IOPERA(  21),IX(  21),IY(  21)/'MOVE',   5,  -7/
      DATA IOPERA(  22),IX(  22),IY(  22)/'DRAW',   4,  -9/
      DATA IOPERA(  23),IX(  23),IY(  23)/'MOVE',   6,  -7/
      DATA IOPERA(  24),IX(  24),IY(  24)/'DRAW',   8,  -9/
C
      DATA IXMIND(   1)/ -10/
      DATA IXMAXD(   1)/  10/
      DATA IXDELD(   1)/  20/
      DATA ISTARD(   1)/   1/
      DATA NUMCOO(   1)/  24/
C
C     DEFINE CHARACTER   3002--UPPER CASE B
C
      DATA IOPERA(  25),IX(  25),IY(  25)/'MOVE',  -6,  12/
      DATA IOPERA(  26),IX(  26),IY(  26)/'DRAW',  -6,  -9/
      DATA IOPERA(  27),IX(  27),IY(  27)/'MOVE',  -5,  11/
      DATA IOPERA(  28),IX(  28),IY(  28)/'DRAW',  -5,  -8/
      DATA IOPERA(  29),IX(  29),IY(  29)/'MOVE',  -4,  12/
      DATA IOPERA(  30),IX(  30),IY(  30)/'DRAW',  -4,  -9/
      DATA IOPERA(  31),IX(  31),IY(  31)/'MOVE',  -9,  12/
      DATA IOPERA(  32),IX(  32),IY(  32)/'DRAW',   3,  12/
      DATA IOPERA(  33),IX(  33),IY(  33)/'DRAW',   6,  11/
      DATA IOPERA(  34),IX(  34),IY(  34)/'DRAW',   7,  10/
      DATA IOPERA(  35),IX(  35),IY(  35)/'DRAW',   8,   8/
      DATA IOPERA(  36),IX(  36),IY(  36)/'DRAW',   8,   6/
      DATA IOPERA(  37),IX(  37),IY(  37)/'DRAW',   7,   4/
      DATA IOPERA(  38),IX(  38),IY(  38)/'DRAW',   6,   3/
      DATA IOPERA(  39),IX(  39),IY(  39)/'DRAW',   3,   2/
      DATA IOPERA(  40),IX(  40),IY(  40)/'MOVE',   6,  10/
      DATA IOPERA(  41),IX(  41),IY(  41)/'DRAW',   7,   8/
      DATA IOPERA(  42),IX(  42),IY(  42)/'DRAW',   7,   6/
      DATA IOPERA(  43),IX(  43),IY(  43)/'DRAW',   6,   4/
      DATA IOPERA(  44),IX(  44),IY(  44)/'MOVE',   3,  12/
      DATA IOPERA(  45),IX(  45),IY(  45)/'DRAW',   5,  11/
      DATA IOPERA(  46),IX(  46),IY(  46)/'DRAW',   6,   9/
      DATA IOPERA(  47),IX(  47),IY(  47)/'DRAW',   6,   5/
      DATA IOPERA(  48),IX(  48),IY(  48)/'DRAW',   5,   3/
      DATA IOPERA(  49),IX(  49),IY(  49)/'DRAW',   3,   2/
      DATA IOPERA(  50),IX(  50),IY(  50)/'MOVE',  -4,   2/
      DATA IOPERA(  51),IX(  51),IY(  51)/'DRAW',   3,   2/
      DATA IOPERA(  52),IX(  52),IY(  52)/'DRAW',   6,   1/
      DATA IOPERA(  53),IX(  53),IY(  53)/'DRAW',   7,   0/
      DATA IOPERA(  54),IX(  54),IY(  54)/'DRAW',   8,  -2/
      DATA IOPERA(  55),IX(  55),IY(  55)/'DRAW',   8,  -5/
      DATA IOPERA(  56),IX(  56),IY(  56)/'DRAW',   7,  -7/
      DATA IOPERA(  57),IX(  57),IY(  57)/'DRAW',   6,  -8/
      DATA IOPERA(  58),IX(  58),IY(  58)/'DRAW',   3,  -9/
      DATA IOPERA(  59),IX(  59),IY(  59)/'DRAW',  -9,  -9/
      DATA IOPERA(  60),IX(  60),IY(  60)/'MOVE',   6,   0/
      DATA IOPERA(  61),IX(  61),IY(  61)/'DRAW',   7,  -2/
      DATA IOPERA(  62),IX(  62),IY(  62)/'DRAW',   7,  -5/
      DATA IOPERA(  63),IX(  63),IY(  63)/'DRAW',   6,  -7/
      DATA IOPERA(  64),IX(  64),IY(  64)/'MOVE',   3,   2/
      DATA IOPERA(  65),IX(  65),IY(  65)/'DRAW',   5,   1/
      DATA IOPERA(  66),IX(  66),IY(  66)/'DRAW',   6,  -1/
      DATA IOPERA(  67),IX(  67),IY(  67)/'DRAW',   6,  -6/
      DATA IOPERA(  68),IX(  68),IY(  68)/'DRAW',   5,  -8/
      DATA IOPERA(  69),IX(  69),IY(  69)/'DRAW',   3,  -9/
      DATA IOPERA(  70),IX(  70),IY(  70)/'MOVE',  -8,  12/
      DATA IOPERA(  71),IX(  71),IY(  71)/'DRAW',  -6,  11/
      DATA IOPERA(  72),IX(  72),IY(  72)/'MOVE',  -7,  12/
      DATA IOPERA(  73),IX(  73),IY(  73)/'DRAW',  -6,  10/
      DATA IOPERA(  74),IX(  74),IY(  74)/'MOVE',  -3,  12/
      DATA IOPERA(  75),IX(  75),IY(  75)/'DRAW',  -4,  10/
      DATA IOPERA(  76),IX(  76),IY(  76)/'MOVE',  -2,  12/
      DATA IOPERA(  77),IX(  77),IY(  77)/'DRAW',  -4,  11/
      DATA IOPERA(  78),IX(  78),IY(  78)/'MOVE',  -6,  -8/
      DATA IOPERA(  79),IX(  79),IY(  79)/'DRAW',  -8,  -9/
      DATA IOPERA(  80),IX(  80),IY(  80)/'MOVE',  -6,  -7/
      DATA IOPERA(  81),IX(  81),IY(  81)/'DRAW',  -7,  -9/
      DATA IOPERA(  82),IX(  82),IY(  82)/'MOVE',  -4,  -7/
      DATA IOPERA(  83),IX(  83),IY(  83)/'DRAW',  -3,  -9/
      DATA IOPERA(  84),IX(  84),IY(  84)/'MOVE',  -4,  -8/
      DATA IOPERA(  85),IX(  85),IY(  85)/'DRAW',  -2,  -9/
C
      DATA IXMIND(   2)/ -11/
      DATA IXMAXD(   2)/  11/
      DATA IXDELD(   2)/  22/
      DATA ISTARD(   2)/  25/
      DATA NUMCOO(   2)/  61/
C
C     DEFINE CHARACTER   3003--UPPER CASE C
C
      DATA IOPERA(  86),IX(  86),IY(  86)/'MOVE',   6,   9/
      DATA IOPERA(  87),IX(  87),IY(  87)/'DRAW',   7,  12/
      DATA IOPERA(  88),IX(  88),IY(  88)/'DRAW',   7,   6/
      DATA IOPERA(  89),IX(  89),IY(  89)/'DRAW',   6,   9/
      DATA IOPERA(  90),IX(  90),IY(  90)/'DRAW',   4,  11/
      DATA IOPERA(  91),IX(  91),IY(  91)/'DRAW',   2,  12/
      DATA IOPERA(  92),IX(  92),IY(  92)/'DRAW',  -1,  12/
      DATA IOPERA(  93),IX(  93),IY(  93)/'DRAW',  -4,  11/
      DATA IOPERA(  94),IX(  94),IY(  94)/'DRAW',  -6,   9/
      DATA IOPERA(  95),IX(  95),IY(  95)/'DRAW',  -7,   7/
      DATA IOPERA(  96),IX(  96),IY(  96)/'DRAW',  -8,   4/
      DATA IOPERA(  97),IX(  97),IY(  97)/'DRAW',  -8,  -1/
      DATA IOPERA(  98),IX(  98),IY(  98)/'DRAW',  -7,  -4/
      DATA IOPERA(  99),IX(  99),IY(  99)/'DRAW',  -6,  -6/
      DATA IOPERA( 100),IX( 100),IY( 100)/'DRAW',  -4,  -8/
      DATA IOPERA( 101),IX( 101),IY( 101)/'DRAW',  -1,  -9/
      DATA IOPERA( 102),IX( 102),IY( 102)/'DRAW',   2,  -9/
      DATA IOPERA( 103),IX( 103),IY( 103)/'DRAW',   4,  -8/
      DATA IOPERA( 104),IX( 104),IY( 104)/'DRAW',   6,  -6/
      DATA IOPERA( 105),IX( 105),IY( 105)/'DRAW',   7,  -4/
      DATA IOPERA( 106),IX( 106),IY( 106)/'MOVE',  -5,   9/
      DATA IOPERA( 107),IX( 107),IY( 107)/'DRAW',  -6,   7/
      DATA IOPERA( 108),IX( 108),IY( 108)/'DRAW',  -7,   4/
      DATA IOPERA( 109),IX( 109),IY( 109)/'DRAW',  -7,  -1/
      DATA IOPERA( 110),IX( 110),IY( 110)/'DRAW',  -6,  -4/
      DATA IOPERA( 111),IX( 111),IY( 111)/'DRAW',  -5,  -6/
      DATA IOPERA( 112),IX( 112),IY( 112)/'MOVE',  -1,  12/
      DATA IOPERA( 113),IX( 113),IY( 113)/'DRAW',  -3,  11/
      DATA IOPERA( 114),IX( 114),IY( 114)/'DRAW',  -5,   8/
      DATA IOPERA( 115),IX( 115),IY( 115)/'DRAW',  -6,   4/
      DATA IOPERA( 116),IX( 116),IY( 116)/'DRAW',  -6,  -1/
      DATA IOPERA( 117),IX( 117),IY( 117)/'DRAW',  -5,  -5/
      DATA IOPERA( 118),IX( 118),IY( 118)/'DRAW',  -3,  -8/
      DATA IOPERA( 119),IX( 119),IY( 119)/'DRAW',  -1,  -9/
C
      DATA IXMIND(   3)/ -11/
      DATA IXMAXD(   3)/  10/
      DATA IXDELD(   3)/  21/
      DATA ISTARD(   3)/  86/
      DATA NUMCOO(   3)/  34/
C
C     DEFINE CHARACTER   3004--UPPER CASE D
C
      DATA IOPERA( 120),IX( 120),IY( 120)/'MOVE',  -6,  12/
      DATA IOPERA( 121),IX( 121),IY( 121)/'DRAW',  -6,  -9/
      DATA IOPERA( 122),IX( 122),IY( 122)/'MOVE',  -5,  11/
      DATA IOPERA( 123),IX( 123),IY( 123)/'DRAW',  -5,  -8/
      DATA IOPERA( 124),IX( 124),IY( 124)/'MOVE',  -4,  12/
      DATA IOPERA( 125),IX( 125),IY( 125)/'DRAW',  -4,  -9/
      DATA IOPERA( 126),IX( 126),IY( 126)/'MOVE',  -9,  12/
      DATA IOPERA( 127),IX( 127),IY( 127)/'DRAW',   1,  12/
      DATA IOPERA( 128),IX( 128),IY( 128)/'DRAW',   4,  11/
      DATA IOPERA( 129),IX( 129),IY( 129)/'DRAW',   6,   9/
      DATA IOPERA( 130),IX( 130),IY( 130)/'DRAW',   7,   7/
      DATA IOPERA( 131),IX( 131),IY( 131)/'DRAW',   8,   4/
      DATA IOPERA( 132),IX( 132),IY( 132)/'DRAW',   8,  -1/
      DATA IOPERA( 133),IX( 133),IY( 133)/'DRAW',   7,  -4/
      DATA IOPERA( 134),IX( 134),IY( 134)/'DRAW',   6,  -6/
      DATA IOPERA( 135),IX( 135),IY( 135)/'DRAW',   4,  -8/
      DATA IOPERA( 136),IX( 136),IY( 136)/'DRAW',   1,  -9/
      DATA IOPERA( 137),IX( 137),IY( 137)/'DRAW',  -9,  -9/
      DATA IOPERA( 138),IX( 138),IY( 138)/'MOVE',   5,   9/
      DATA IOPERA( 139),IX( 139),IY( 139)/'DRAW',   6,   7/
      DATA IOPERA( 140),IX( 140),IY( 140)/'DRAW',   7,   4/
      DATA IOPERA( 141),IX( 141),IY( 141)/'DRAW',   7,  -1/
      DATA IOPERA( 142),IX( 142),IY( 142)/'DRAW',   6,  -4/
      DATA IOPERA( 143),IX( 143),IY( 143)/'DRAW',   5,  -6/
      DATA IOPERA( 144),IX( 144),IY( 144)/'MOVE',   1,  12/
      DATA IOPERA( 145),IX( 145),IY( 145)/'DRAW',   3,  11/
      DATA IOPERA( 146),IX( 146),IY( 146)/'DRAW',   5,   8/
      DATA IOPERA( 147),IX( 147),IY( 147)/'DRAW',   6,   4/
      DATA IOPERA( 148),IX( 148),IY( 148)/'DRAW',   6,  -1/
      DATA IOPERA( 149),IX( 149),IY( 149)/'DRAW',   5,  -5/
      DATA IOPERA( 150),IX( 150),IY( 150)/'DRAW',   3,  -8/
      DATA IOPERA( 151),IX( 151),IY( 151)/'DRAW',   1,  -9/
      DATA IOPERA( 152),IX( 152),IY( 152)/'MOVE',  -8,  12/
      DATA IOPERA( 153),IX( 153),IY( 153)/'DRAW',  -6,  11/
      DATA IOPERA( 154),IX( 154),IY( 154)/'MOVE',  -7,  12/
      DATA IOPERA( 155),IX( 155),IY( 155)/'DRAW',  -6,  10/
      DATA IOPERA( 156),IX( 156),IY( 156)/'MOVE',  -3,  12/
      DATA IOPERA( 157),IX( 157),IY( 157)/'DRAW',  -4,  10/
      DATA IOPERA( 158),IX( 158),IY( 158)/'MOVE',  -2,  12/
      DATA IOPERA( 159),IX( 159),IY( 159)/'DRAW',  -4,  11/
      DATA IOPERA( 160),IX( 160),IY( 160)/'MOVE',  -6,  -8/
      DATA IOPERA( 161),IX( 161),IY( 161)/'DRAW',  -8,  -9/
      DATA IOPERA( 162),IX( 162),IY( 162)/'MOVE',  -6,  -7/
      DATA IOPERA( 163),IX( 163),IY( 163)/'DRAW',  -7,  -9/
      DATA IOPERA( 164),IX( 164),IY( 164)/'MOVE',  -4,  -7/
      DATA IOPERA( 165),IX( 165),IY( 165)/'DRAW',  -3,  -9/
      DATA IOPERA( 166),IX( 166),IY( 166)/'MOVE',  -4,  -8/
      DATA IOPERA( 167),IX( 167),IY( 167)/'DRAW',  -2,  -9/
C
      DATA IXMIND(   4)/ -11/
      DATA IXMAXD(   4)/  11/
      DATA IXDELD(   4)/  22/
      DATA ISTARD(   4)/ 120/
      DATA NUMCOO(   4)/  48/
C
C     DEFINE CHARACTER   3005--UPPER CASE E
C
      DATA IOPERA( 168),IX( 168),IY( 168)/'MOVE',  -6,  12/
      DATA IOPERA( 169),IX( 169),IY( 169)/'DRAW',  -6,  -9/
      DATA IOPERA( 170),IX( 170),IY( 170)/'MOVE',  -5,  11/
      DATA IOPERA( 171),IX( 171),IY( 171)/'DRAW',  -5,  -8/
      DATA IOPERA( 172),IX( 172),IY( 172)/'MOVE',  -4,  12/
      DATA IOPERA( 173),IX( 173),IY( 173)/'DRAW',  -4,  -9/
      DATA IOPERA( 174),IX( 174),IY( 174)/'MOVE',  -9,  12/
      DATA IOPERA( 175),IX( 175),IY( 175)/'DRAW',   7,  12/
      DATA IOPERA( 176),IX( 176),IY( 176)/'DRAW',   7,   6/
      DATA IOPERA( 177),IX( 177),IY( 177)/'MOVE',  -4,   2/
      DATA IOPERA( 178),IX( 178),IY( 178)/'DRAW',   2,   2/
      DATA IOPERA( 179),IX( 179),IY( 179)/'MOVE',   2,   6/
      DATA IOPERA( 180),IX( 180),IY( 180)/'DRAW',   2,  -2/
      DATA IOPERA( 181),IX( 181),IY( 181)/'MOVE',  -9,  -9/
      DATA IOPERA( 182),IX( 182),IY( 182)/'DRAW',   7,  -9/
      DATA IOPERA( 183),IX( 183),IY( 183)/'DRAW',   7,  -3/
      DATA IOPERA( 184),IX( 184),IY( 184)/'MOVE',  -8,  12/
      DATA IOPERA( 185),IX( 185),IY( 185)/'DRAW',  -6,  11/
      DATA IOPERA( 186),IX( 186),IY( 186)/'MOVE',  -7,  12/
      DATA IOPERA( 187),IX( 187),IY( 187)/'DRAW',  -6,  10/
      DATA IOPERA( 188),IX( 188),IY( 188)/'MOVE',  -3,  12/
      DATA IOPERA( 189),IX( 189),IY( 189)/'DRAW',  -4,  10/
      DATA IOPERA( 190),IX( 190),IY( 190)/'MOVE',  -2,  12/
      DATA IOPERA( 191),IX( 191),IY( 191)/'DRAW',  -4,  11/
      DATA IOPERA( 192),IX( 192),IY( 192)/'MOVE',   2,  12/
      DATA IOPERA( 193),IX( 193),IY( 193)/'DRAW',   7,  11/
      DATA IOPERA( 194),IX( 194),IY( 194)/'MOVE',   4,  12/
      DATA IOPERA( 195),IX( 195),IY( 195)/'DRAW',   7,  10/
      DATA IOPERA( 196),IX( 196),IY( 196)/'MOVE',   5,  12/
      DATA IOPERA( 197),IX( 197),IY( 197)/'DRAW',   7,   9/
      DATA IOPERA( 198),IX( 198),IY( 198)/'MOVE',   6,  12/
      DATA IOPERA( 199),IX( 199),IY( 199)/'DRAW',   7,   6/
      DATA IOPERA( 200),IX( 200),IY( 200)/'MOVE',   2,   6/
      DATA IOPERA( 201),IX( 201),IY( 201)/'DRAW',   1,   2/
      DATA IOPERA( 202),IX( 202),IY( 202)/'DRAW',   2,  -2/
      DATA IOPERA( 203),IX( 203),IY( 203)/'MOVE',   2,   4/
      DATA IOPERA( 204),IX( 204),IY( 204)/'DRAW',   0,   2/
      DATA IOPERA( 205),IX( 205),IY( 205)/'DRAW',   2,   0/
      DATA IOPERA( 206),IX( 206),IY( 206)/'MOVE',   2,   3/
      DATA IOPERA( 207),IX( 207),IY( 207)/'DRAW',  -2,   2/
      DATA IOPERA( 208),IX( 208),IY( 208)/'DRAW',   2,   1/
      DATA IOPERA( 209),IX( 209),IY( 209)/'MOVE',  -6,  -8/
      DATA IOPERA( 210),IX( 210),IY( 210)/'DRAW',  -8,  -9/
      DATA IOPERA( 211),IX( 211),IY( 211)/'MOVE',  -6,  -7/
      DATA IOPERA( 212),IX( 212),IY( 212)/'DRAW',  -7,  -9/
      DATA IOPERA( 213),IX( 213),IY( 213)/'MOVE',  -4,  -7/
      DATA IOPERA( 214),IX( 214),IY( 214)/'DRAW',  -3,  -9/
      DATA IOPERA( 215),IX( 215),IY( 215)/'MOVE',  -4,  -8/
      DATA IOPERA( 216),IX( 216),IY( 216)/'DRAW',  -2,  -9/
      DATA IOPERA( 217),IX( 217),IY( 217)/'MOVE',   2,  -9/
      DATA IOPERA( 218),IX( 218),IY( 218)/'DRAW',   7,  -8/
      DATA IOPERA( 219),IX( 219),IY( 219)/'MOVE',   4,  -9/
      DATA IOPERA( 220),IX( 220),IY( 220)/'DRAW',   7,  -7/
      DATA IOPERA( 221),IX( 221),IY( 221)/'MOVE',   5,  -9/
      DATA IOPERA( 222),IX( 222),IY( 222)/'DRAW',   7,  -6/
      DATA IOPERA( 223),IX( 223),IY( 223)/'MOVE',   6,  -9/
      DATA IOPERA( 224),IX( 224),IY( 224)/'DRAW',   7,  -3/
C
      DATA IXMIND(   5)/ -11/
      DATA IXMAXD(   5)/  10/
      DATA IXDELD(   5)/  21/
      DATA ISTARD(   5)/ 168/
      DATA NUMCOO(   5)/  57/
C
C     DEFINE CHARACTER   3006--UPPER CASE F
C
      DATA IOPERA( 225),IX( 225),IY( 225)/'MOVE',  -6,  12/
      DATA IOPERA( 226),IX( 226),IY( 226)/'DRAW',  -6,  -9/
      DATA IOPERA( 227),IX( 227),IY( 227)/'MOVE',  -5,  11/
      DATA IOPERA( 228),IX( 228),IY( 228)/'DRAW',  -5,  -8/
      DATA IOPERA( 229),IX( 229),IY( 229)/'MOVE',  -4,  12/
      DATA IOPERA( 230),IX( 230),IY( 230)/'DRAW',  -4,  -9/
      DATA IOPERA( 231),IX( 231),IY( 231)/'MOVE',  -9,  12/
      DATA IOPERA( 232),IX( 232),IY( 232)/'DRAW',   7,  12/
      DATA IOPERA( 233),IX( 233),IY( 233)/'DRAW',   7,   6/
      DATA IOPERA( 234),IX( 234),IY( 234)/'MOVE',  -4,   2/
      DATA IOPERA( 235),IX( 235),IY( 235)/'DRAW',   2,   2/
      DATA IOPERA( 236),IX( 236),IY( 236)/'MOVE',   2,   6/
      DATA IOPERA( 237),IX( 237),IY( 237)/'DRAW',   2,  -2/
      DATA IOPERA( 238),IX( 238),IY( 238)/'MOVE',  -9,  -9/
      DATA IOPERA( 239),IX( 239),IY( 239)/'DRAW',  -1,  -9/
      DATA IOPERA( 240),IX( 240),IY( 240)/'MOVE',  -8,  12/
      DATA IOPERA( 241),IX( 241),IY( 241)/'DRAW',  -6,  11/
      DATA IOPERA( 242),IX( 242),IY( 242)/'MOVE',  -7,  12/
      DATA IOPERA( 243),IX( 243),IY( 243)/'DRAW',  -6,  10/
      DATA IOPERA( 244),IX( 244),IY( 244)/'MOVE',  -3,  12/
      DATA IOPERA( 245),IX( 245),IY( 245)/'DRAW',  -4,  10/
      DATA IOPERA( 246),IX( 246),IY( 246)/'MOVE',  -2,  12/
      DATA IOPERA( 247),IX( 247),IY( 247)/'DRAW',  -4,  11/
      DATA IOPERA( 248),IX( 248),IY( 248)/'MOVE',   2,  12/
      DATA IOPERA( 249),IX( 249),IY( 249)/'DRAW',   7,  11/
      DATA IOPERA( 250),IX( 250),IY( 250)/'MOVE',   4,  12/
      DATA IOPERA( 251),IX( 251),IY( 251)/'DRAW',   7,  10/
      DATA IOPERA( 252),IX( 252),IY( 252)/'MOVE',   5,  12/
      DATA IOPERA( 253),IX( 253),IY( 253)/'DRAW',   7,   9/
      DATA IOPERA( 254),IX( 254),IY( 254)/'MOVE',   6,  12/
      DATA IOPERA( 255),IX( 255),IY( 255)/'DRAW',   7,   6/
      DATA IOPERA( 256),IX( 256),IY( 256)/'MOVE',   2,   6/
      DATA IOPERA( 257),IX( 257),IY( 257)/'DRAW',   1,   2/
      DATA IOPERA( 258),IX( 258),IY( 258)/'DRAW',   2,  -2/
      DATA IOPERA( 259),IX( 259),IY( 259)/'MOVE',   2,   4/
      DATA IOPERA( 260),IX( 260),IY( 260)/'DRAW',   0,   2/
      DATA IOPERA( 261),IX( 261),IY( 261)/'DRAW',   2,   0/
      DATA IOPERA( 262),IX( 262),IY( 262)/'MOVE',   2,   3/
      DATA IOPERA( 263),IX( 263),IY( 263)/'DRAW',  -2,   2/
      DATA IOPERA( 264),IX( 264),IY( 264)/'DRAW',   2,   1/
      DATA IOPERA( 265),IX( 265),IY( 265)/'MOVE',  -6,  -8/
      DATA IOPERA( 266),IX( 266),IY( 266)/'DRAW',  -8,  -9/
      DATA IOPERA( 267),IX( 267),IY( 267)/'MOVE',  -6,  -7/
      DATA IOPERA( 268),IX( 268),IY( 268)/'DRAW',  -7,  -9/
      DATA IOPERA( 269),IX( 269),IY( 269)/'MOVE',  -4,  -7/
      DATA IOPERA( 270),IX( 270),IY( 270)/'DRAW',  -3,  -9/
      DATA IOPERA( 271),IX( 271),IY( 271)/'MOVE',  -4,  -8/
      DATA IOPERA( 272),IX( 272),IY( 272)/'DRAW',  -2,  -9/
C
      DATA IXMIND(   6)/ -11/
      DATA IXMAXD(   6)/   9/
      DATA IXDELD(   6)/  20/
      DATA ISTARD(   6)/ 225/
      DATA NUMCOO(   6)/  48/
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='YES'
      IERROR='NO'
C
      NUMCO=1
      ISTART=1
      ISTOP=1
      NC=1
C
C               ******************************************
C               **  TREAT THE ROMAN SIMPLEX UPPER CASE  **
C               **  HERSHEY CHARACTER SET CASE          **
C               ******************************************
C
C
      IF(IBUGD2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DRTU1--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)ICHARN
   52 FORMAT('ICHARN = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)IBUGD2,IFOUND,IERROR
   59 FORMAT('IBUGD2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************
C               **  STEP 2--                        **
C               **  EXTRACT THE COORDINATES         **
C               **  FOR THIS PARTICULAR CHARACTER.  **
C               **************************************
C
 1000 CONTINUE
      ISTART=ISTARD(ICHARN)
      NC=NUMCOO(ICHARN)
      ISTOP=ISTART+NC-1
      J=0
      DO1100I=ISTART,ISTOP
      J=J+1
      IOP(J)=IOPERA(I)
      X(J)=IX(I)
      Y(J)=IY(I)
 1100 CONTINUE
      NUMCO=J
      IXMINS=IXMIND(ICHARN)
      IXMAXS=IXMAXD(ICHARN)
      IXDELS=IXDELD(ICHARN)
C
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGD2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DRTU1--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGD2,IFOUND,IERROR
 9012 FORMAT('IBUGD2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICHARN
 9013 FORMAT('ICHARN = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)ISTART,ISTOP,NC,NUMCO
 9014 FORMAT('ISTART,ISTOP,NC,NUMCO = ',4I8)
      CALL DPWRST('XXX','BUG ')
      IF(NUMCO.GE.1.AND.NUMCO.LE.1000)GOTO9019
      DO9015I=1,NUMCO
      WRITE(ICOUT,9016)I,IOP(I),X(I),Y(I)
 9016 FORMAT('I,IOP(I),X(I),Y(I) = ',I8,2X,A4,2F10.2)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
 9019 CONTINUE
      WRITE(ICOUT,9021)IXMINS,IXMAXS,IXDELS
 9021 FORMAT('IXMINS,IXMAXS,IXDELS = ',3I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DRTU2(ICHARN,IOP,X,Y,NUMCO,IXMINS,IXMAXS,IXDELS,
     1IBUGD2,IFOUND,IERROR)
C
C     PURPOSE--DEFINE AND SET THE HERSHEY CHARACTER SET COORDINATES
C              FOR ROMAN TRIPLEX UPPER CASE (PART 2).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--87/4
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MARCH     1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MARCH     1987.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IOP
      CHARACTER*4 IBUGD2
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IOPERA
C
C---------------------------------------------------------------------
C
      DIMENSION IOP(*)
      DIMENSION X(*)
      DIMENSION Y(*)
C
      DIMENSION IOPERA(300)
      DIMENSION IX(300)
      DIMENSION IY(300)
C
      DIMENSION IXMIND(30)
      DIMENSION IXMAXD(30)
      DIMENSION IXDELD(30)
      DIMENSION ISTARD(30)
      DIMENSION NUMCOO(30)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C     DEFINE CHARACTER   3007--UPPER CASE G
C
      DATA IOPERA(   1),IX(   1),IY(   1)/'MOVE',   6,   9/
      DATA IOPERA(   2),IX(   2),IY(   2)/'DRAW',   7,  12/
      DATA IOPERA(   3),IX(   3),IY(   3)/'DRAW',   7,   6/
      DATA IOPERA(   4),IX(   4),IY(   4)/'DRAW',   6,   9/
      DATA IOPERA(   5),IX(   5),IY(   5)/'DRAW',   4,  11/
      DATA IOPERA(   6),IX(   6),IY(   6)/'DRAW',   2,  12/
      DATA IOPERA(   7),IX(   7),IY(   7)/'DRAW',  -1,  12/
      DATA IOPERA(   8),IX(   8),IY(   8)/'DRAW',  -4,  11/
      DATA IOPERA(   9),IX(   9),IY(   9)/'DRAW',  -6,   9/
      DATA IOPERA(  10),IX(  10),IY(  10)/'DRAW',  -7,   7/
      DATA IOPERA(  11),IX(  11),IY(  11)/'DRAW',  -8,   4/
      DATA IOPERA(  12),IX(  12),IY(  12)/'DRAW',  -8,  -1/
      DATA IOPERA(  13),IX(  13),IY(  13)/'DRAW',  -7,  -4/
      DATA IOPERA(  14),IX(  14),IY(  14)/'DRAW',  -6,  -6/
      DATA IOPERA(  15),IX(  15),IY(  15)/'DRAW',  -4,  -8/
      DATA IOPERA(  16),IX(  16),IY(  16)/'DRAW',  -1,  -9/
      DATA IOPERA(  17),IX(  17),IY(  17)/'DRAW',   2,  -9/
      DATA IOPERA(  18),IX(  18),IY(  18)/'DRAW',   4,  -8/
      DATA IOPERA(  19),IX(  19),IY(  19)/'DRAW',   6,  -8/
      DATA IOPERA(  20),IX(  20),IY(  20)/'DRAW',   7,  -9/
      DATA IOPERA(  21),IX(  21),IY(  21)/'DRAW',   7,  -1/
      DATA IOPERA(  22),IX(  22),IY(  22)/'MOVE',  -5,   9/
      DATA IOPERA(  23),IX(  23),IY(  23)/'DRAW',  -6,   7/
      DATA IOPERA(  24),IX(  24),IY(  24)/'DRAW',  -7,   4/
      DATA IOPERA(  25),IX(  25),IY(  25)/'DRAW',  -7,  -1/
      DATA IOPERA(  26),IX(  26),IY(  26)/'DRAW',  -6,  -4/
      DATA IOPERA(  27),IX(  27),IY(  27)/'DRAW',  -5,  -6/
      DATA IOPERA(  28),IX(  28),IY(  28)/'MOVE',  -1,  12/
      DATA IOPERA(  29),IX(  29),IY(  29)/'DRAW',  -3,  11/
      DATA IOPERA(  30),IX(  30),IY(  30)/'DRAW',  -5,   8/
      DATA IOPERA(  31),IX(  31),IY(  31)/'DRAW',  -6,   4/
      DATA IOPERA(  32),IX(  32),IY(  32)/'DRAW',  -6,  -1/
      DATA IOPERA(  33),IX(  33),IY(  33)/'DRAW',  -5,  -5/
      DATA IOPERA(  34),IX(  34),IY(  34)/'DRAW',  -3,  -8/
      DATA IOPERA(  35),IX(  35),IY(  35)/'DRAW',  -1,  -9/
      DATA IOPERA(  36),IX(  36),IY(  36)/'MOVE',   6,  -2/
      DATA IOPERA(  37),IX(  37),IY(  37)/'DRAW',   6,  -7/
      DATA IOPERA(  38),IX(  38),IY(  38)/'MOVE',   5,  -1/
      DATA IOPERA(  39),IX(  39),IY(  39)/'DRAW',   5,  -7/
      DATA IOPERA(  40),IX(  40),IY(  40)/'DRAW',   4,  -8/
      DATA IOPERA(  41),IX(  41),IY(  41)/'MOVE',   2,  -1/
      DATA IOPERA(  42),IX(  42),IY(  42)/'DRAW',  10,  -1/
      DATA IOPERA(  43),IX(  43),IY(  43)/'MOVE',   3,  -1/
      DATA IOPERA(  44),IX(  44),IY(  44)/'DRAW',   5,  -2/
      DATA IOPERA(  45),IX(  45),IY(  45)/'MOVE',   4,  -1/
      DATA IOPERA(  46),IX(  46),IY(  46)/'DRAW',   5,  -3/
      DATA IOPERA(  47),IX(  47),IY(  47)/'MOVE',   8,  -1/
      DATA IOPERA(  48),IX(  48),IY(  48)/'DRAW',   7,  -3/
      DATA IOPERA(  49),IX(  49),IY(  49)/'MOVE',   9,  -1/
      DATA IOPERA(  50),IX(  50),IY(  50)/'DRAW',   7,  -2/
C
      DATA IXMIND(   7)/ -11/
      DATA IXMAXD(   7)/  12/
      DATA IXDELD(   7)/  23/
      DATA ISTARD(   7)/   1/
      DATA NUMCOO(   7)/  50/
C
C     DEFINE CHARACTER   3008--UPPER CASE H
C
      DATA IOPERA(  51),IX(  51),IY(  51)/'MOVE',  -7,  12/
      DATA IOPERA(  52),IX(  52),IY(  52)/'DRAW',  -7,  -9/
      DATA IOPERA(  53),IX(  53),IY(  53)/'MOVE',  -6,  11/
      DATA IOPERA(  54),IX(  54),IY(  54)/'DRAW',  -6,  -8/
      DATA IOPERA(  55),IX(  55),IY(  55)/'MOVE',  -5,  12/
      DATA IOPERA(  56),IX(  56),IY(  56)/'DRAW',  -5,  -9/
      DATA IOPERA(  57),IX(  57),IY(  57)/'MOVE',   5,  12/
      DATA IOPERA(  58),IX(  58),IY(  58)/'DRAW',   5,  -9/
      DATA IOPERA(  59),IX(  59),IY(  59)/'MOVE',   6,  11/
      DATA IOPERA(  60),IX(  60),IY(  60)/'DRAW',   6,  -8/
      DATA IOPERA(  61),IX(  61),IY(  61)/'MOVE',   7,  12/
      DATA IOPERA(  62),IX(  62),IY(  62)/'DRAW',   7,  -9/
      DATA IOPERA(  63),IX(  63),IY(  63)/'MOVE', -10,  12/
      DATA IOPERA(  64),IX(  64),IY(  64)/'DRAW',  -2,  12/
      DATA IOPERA(  65),IX(  65),IY(  65)/'MOVE',   2,  12/
      DATA IOPERA(  66),IX(  66),IY(  66)/'DRAW',  10,  12/
      DATA IOPERA(  67),IX(  67),IY(  67)/'MOVE',  -5,   2/
      DATA IOPERA(  68),IX(  68),IY(  68)/'DRAW',   5,   2/
      DATA IOPERA(  69),IX(  69),IY(  69)/'MOVE', -10,  -9/
      DATA IOPERA(  70),IX(  70),IY(  70)/'DRAW',  -2,  -9/
      DATA IOPERA(  71),IX(  71),IY(  71)/'MOVE',   2,  -9/
      DATA IOPERA(  72),IX(  72),IY(  72)/'DRAW',  10,  -9/
      DATA IOPERA(  73),IX(  73),IY(  73)/'MOVE',  -9,  12/
      DATA IOPERA(  74),IX(  74),IY(  74)/'DRAW',  -7,  11/
      DATA IOPERA(  75),IX(  75),IY(  75)/'MOVE',  -8,  12/
      DATA IOPERA(  76),IX(  76),IY(  76)/'DRAW',  -7,  10/
      DATA IOPERA(  77),IX(  77),IY(  77)/'MOVE',  -4,  12/
      DATA IOPERA(  78),IX(  78),IY(  78)/'DRAW',  -5,  10/
      DATA IOPERA(  79),IX(  79),IY(  79)/'MOVE',  -3,  12/
      DATA IOPERA(  80),IX(  80),IY(  80)/'DRAW',  -5,  11/
      DATA IOPERA(  81),IX(  81),IY(  81)/'MOVE',   3,  12/
      DATA IOPERA(  82),IX(  82),IY(  82)/'DRAW',   5,  11/
      DATA IOPERA(  83),IX(  83),IY(  83)/'MOVE',   4,  12/
      DATA IOPERA(  84),IX(  84),IY(  84)/'DRAW',   5,  10/
      DATA IOPERA(  85),IX(  85),IY(  85)/'MOVE',   8,  12/
      DATA IOPERA(  86),IX(  86),IY(  86)/'DRAW',   7,  10/
      DATA IOPERA(  87),IX(  87),IY(  87)/'MOVE',   9,  12/
      DATA IOPERA(  88),IX(  88),IY(  88)/'DRAW',   7,  11/
      DATA IOPERA(  89),IX(  89),IY(  89)/'MOVE',  -7,  -8/
      DATA IOPERA(  90),IX(  90),IY(  90)/'DRAW',  -9,  -9/
      DATA IOPERA(  91),IX(  91),IY(  91)/'MOVE',  -7,  -7/
      DATA IOPERA(  92),IX(  92),IY(  92)/'DRAW',  -8,  -9/
      DATA IOPERA(  93),IX(  93),IY(  93)/'MOVE',  -5,  -7/
      DATA IOPERA(  94),IX(  94),IY(  94)/'DRAW',  -4,  -9/
      DATA IOPERA(  95),IX(  95),IY(  95)/'MOVE',  -5,  -8/
      DATA IOPERA(  96),IX(  96),IY(  96)/'DRAW',  -3,  -9/
      DATA IOPERA(  97),IX(  97),IY(  97)/'MOVE',   5,  -8/
      DATA IOPERA(  98),IX(  98),IY(  98)/'DRAW',   3,  -9/
      DATA IOPERA(  99),IX(  99),IY(  99)/'MOVE',   5,  -7/
      DATA IOPERA( 100),IX( 100),IY( 100)/'DRAW',   4,  -9/
      DATA IOPERA( 101),IX( 101),IY( 101)/'MOVE',   7,  -7/
      DATA IOPERA( 102),IX( 102),IY( 102)/'DRAW',   8,  -9/
      DATA IOPERA( 103),IX( 103),IY( 103)/'MOVE',   7,  -8/
      DATA IOPERA( 104),IX( 104),IY( 104)/'DRAW',   9,  -9/
C
      DATA IXMIND(   8)/ -12/
      DATA IXMAXD(   8)/  12/
      DATA IXDELD(   8)/  24/
      DATA ISTARD(   8)/  51/
      DATA NUMCOO(   8)/  54/
C
C     DEFINE CHARACTER   3009--UPPER CASE I
C
      DATA IOPERA( 105),IX( 105),IY( 105)/'MOVE',  -1,  12/
      DATA IOPERA( 106),IX( 106),IY( 106)/'DRAW',  -1,  -9/
      DATA IOPERA( 107),IX( 107),IY( 107)/'MOVE',   0,  11/
      DATA IOPERA( 108),IX( 108),IY( 108)/'DRAW',   0,  -8/
      DATA IOPERA( 109),IX( 109),IY( 109)/'MOVE',   1,  12/
      DATA IOPERA( 110),IX( 110),IY( 110)/'DRAW',   1,  -9/
      DATA IOPERA( 111),IX( 111),IY( 111)/'MOVE',  -4,  12/
      DATA IOPERA( 112),IX( 112),IY( 112)/'DRAW',   4,  12/
      DATA IOPERA( 113),IX( 113),IY( 113)/'MOVE',  -4,  -9/
      DATA IOPERA( 114),IX( 114),IY( 114)/'DRAW',   4,  -9/
      DATA IOPERA( 115),IX( 115),IY( 115)/'MOVE',  -3,  12/
      DATA IOPERA( 116),IX( 116),IY( 116)/'DRAW',  -1,  11/
      DATA IOPERA( 117),IX( 117),IY( 117)/'MOVE',  -2,  12/
      DATA IOPERA( 118),IX( 118),IY( 118)/'DRAW',  -1,  10/
      DATA IOPERA( 119),IX( 119),IY( 119)/'MOVE',   2,  12/
      DATA IOPERA( 120),IX( 120),IY( 120)/'DRAW',   1,  10/
      DATA IOPERA( 121),IX( 121),IY( 121)/'MOVE',   3,  12/
      DATA IOPERA( 122),IX( 122),IY( 122)/'DRAW',   1,  11/
      DATA IOPERA( 123),IX( 123),IY( 123)/'MOVE',  -1,  -8/
      DATA IOPERA( 124),IX( 124),IY( 124)/'DRAW',  -3,  -9/
      DATA IOPERA( 125),IX( 125),IY( 125)/'MOVE',  -1,  -7/
      DATA IOPERA( 126),IX( 126),IY( 126)/'DRAW',  -2,  -9/
      DATA IOPERA( 127),IX( 127),IY( 127)/'MOVE',   1,  -7/
      DATA IOPERA( 128),IX( 128),IY( 128)/'DRAW',   2,  -9/
      DATA IOPERA( 129),IX( 129),IY( 129)/'MOVE',   1,  -8/
      DATA IOPERA( 130),IX( 130),IY( 130)/'DRAW',   3,  -9/
C
      DATA IXMIND(   9)/  -6/
      DATA IXMAXD(   9)/   6/
      DATA IXDELD(   9)/  12/
      DATA ISTARD(   9)/ 105/
      DATA NUMCOO(   9)/  26/
C
C     DEFINE CHARACTER   3010--UPPER CASE J
C
      DATA IOPERA( 131),IX( 131),IY( 131)/'MOVE',   1,  12/
      DATA IOPERA( 132),IX( 132),IY( 132)/'DRAW',   1,  -5/
      DATA IOPERA( 133),IX( 133),IY( 133)/'DRAW',   0,  -8/
      DATA IOPERA( 134),IX( 134),IY( 134)/'DRAW',  -1,  -9/
      DATA IOPERA( 135),IX( 135),IY( 135)/'MOVE',   2,  11/
      DATA IOPERA( 136),IX( 136),IY( 136)/'DRAW',   2,  -5/
      DATA IOPERA( 137),IX( 137),IY( 137)/'DRAW',   1,  -8/
      DATA IOPERA( 138),IX( 138),IY( 138)/'MOVE',   3,  12/
      DATA IOPERA( 139),IX( 139),IY( 139)/'DRAW',   3,  -5/
      DATA IOPERA( 140),IX( 140),IY( 140)/'DRAW',   2,  -8/
      DATA IOPERA( 141),IX( 141),IY( 141)/'DRAW',  -1,  -9/
      DATA IOPERA( 142),IX( 142),IY( 142)/'DRAW',  -3,  -9/
      DATA IOPERA( 143),IX( 143),IY( 143)/'DRAW',  -5,  -8/
      DATA IOPERA( 144),IX( 144),IY( 144)/'DRAW',  -6,  -6/
      DATA IOPERA( 145),IX( 145),IY( 145)/'DRAW',  -6,  -4/
      DATA IOPERA( 146),IX( 146),IY( 146)/'DRAW',  -5,  -3/
      DATA IOPERA( 147),IX( 147),IY( 147)/'DRAW',  -4,  -3/
      DATA IOPERA( 148),IX( 148),IY( 148)/'DRAW',  -3,  -4/
      DATA IOPERA( 149),IX( 149),IY( 149)/'DRAW',  -3,  -5/
      DATA IOPERA( 150),IX( 150),IY( 150)/'DRAW',  -4,  -6/
      DATA IOPERA( 151),IX( 151),IY( 151)/'DRAW',  -5,  -6/
      DATA IOPERA( 152),IX( 152),IY( 152)/'MOVE',  -5,  -4/
      DATA IOPERA( 153),IX( 153),IY( 153)/'DRAW',  -5,  -5/
      DATA IOPERA( 154),IX( 154),IY( 154)/'DRAW',  -4,  -5/
      DATA IOPERA( 155),IX( 155),IY( 155)/'DRAW',  -4,  -4/
      DATA IOPERA( 156),IX( 156),IY( 156)/'DRAW',  -5,  -4/
      DATA IOPERA( 157),IX( 157),IY( 157)/'MOVE',  -2,  12/
      DATA IOPERA( 158),IX( 158),IY( 158)/'DRAW',   6,  12/
      DATA IOPERA( 159),IX( 159),IY( 159)/'MOVE',  -1,  12/
      DATA IOPERA( 160),IX( 160),IY( 160)/'DRAW',   1,  11/
      DATA IOPERA( 161),IX( 161),IY( 161)/'MOVE',   0,  12/
      DATA IOPERA( 162),IX( 162),IY( 162)/'DRAW',   1,  10/
      DATA IOPERA( 163),IX( 163),IY( 163)/'MOVE',   4,  12/
      DATA IOPERA( 164),IX( 164),IY( 164)/'DRAW',   3,  10/
      DATA IOPERA( 165),IX( 165),IY( 165)/'MOVE',   5,  12/
      DATA IOPERA( 166),IX( 166),IY( 166)/'DRAW',   3,  11/
C
      DATA IXMIND(  10)/  -8/
      DATA IXMAXD(  10)/   8/
      DATA IXDELD(  10)/  16/
      DATA ISTARD(  10)/ 131/
      DATA NUMCOO(  10)/  36/
C
C     DEFINE CHARACTER   3011--UPPER CASE K
C
      DATA IOPERA( 167),IX( 167),IY( 167)/'MOVE',  -7,  12/
      DATA IOPERA( 168),IX( 168),IY( 168)/'DRAW',  -7,  -9/
      DATA IOPERA( 169),IX( 169),IY( 169)/'MOVE',  -6,  11/
      DATA IOPERA( 170),IX( 170),IY( 170)/'DRAW',  -6,  -8/
      DATA IOPERA( 171),IX( 171),IY( 171)/'MOVE',  -5,  12/
      DATA IOPERA( 172),IX( 172),IY( 172)/'DRAW',  -5,  -9/
      DATA IOPERA( 173),IX( 173),IY( 173)/'MOVE',   6,  11/
      DATA IOPERA( 174),IX( 174),IY( 174)/'DRAW',  -5,   0/
      DATA IOPERA( 175),IX( 175),IY( 175)/'MOVE',  -2,   2/
      DATA IOPERA( 176),IX( 176),IY( 176)/'DRAW',   5,  -9/
      DATA IOPERA( 177),IX( 177),IY( 177)/'MOVE',  -1,   2/
      DATA IOPERA( 178),IX( 178),IY( 178)/'DRAW',   6,  -9/
      DATA IOPERA( 179),IX( 179),IY( 179)/'MOVE',  -1,   4/
      DATA IOPERA( 180),IX( 180),IY( 180)/'DRAW',   7,  -9/
      DATA IOPERA( 181),IX( 181),IY( 181)/'MOVE', -10,  12/
      DATA IOPERA( 182),IX( 182),IY( 182)/'DRAW',  -2,  12/
      DATA IOPERA( 183),IX( 183),IY( 183)/'MOVE',   3,  12/
      DATA IOPERA( 184),IX( 184),IY( 184)/'DRAW',   9,  12/
      DATA IOPERA( 185),IX( 185),IY( 185)/'MOVE', -10,  -9/
      DATA IOPERA( 186),IX( 186),IY( 186)/'DRAW',  -2,  -9/
      DATA IOPERA( 187),IX( 187),IY( 187)/'MOVE',   2,  -9/
      DATA IOPERA( 188),IX( 188),IY( 188)/'DRAW',   9,  -9/
      DATA IOPERA( 189),IX( 189),IY( 189)/'MOVE',  -9,  12/
      DATA IOPERA( 190),IX( 190),IY( 190)/'DRAW',  -7,  11/
      DATA IOPERA( 191),IX( 191),IY( 191)/'MOVE',  -8,  12/
      DATA IOPERA( 192),IX( 192),IY( 192)/'DRAW',  -7,  10/
      DATA IOPERA( 193),IX( 193),IY( 193)/'MOVE',  -4,  12/
      DATA IOPERA( 194),IX( 194),IY( 194)/'DRAW',  -5,  10/
      DATA IOPERA( 195),IX( 195),IY( 195)/'MOVE',  -3,  12/
      DATA IOPERA( 196),IX( 196),IY( 196)/'DRAW',  -5,  11/
      DATA IOPERA( 197),IX( 197),IY( 197)/'MOVE',   5,  12/
      DATA IOPERA( 198),IX( 198),IY( 198)/'DRAW',   6,  11/
      DATA IOPERA( 199),IX( 199),IY( 199)/'MOVE',   8,  12/
      DATA IOPERA( 200),IX( 200),IY( 200)/'DRAW',   6,  11/
      DATA IOPERA( 201),IX( 201),IY( 201)/'MOVE',  -7,  -8/
      DATA IOPERA( 202),IX( 202),IY( 202)/'DRAW',  -9,  -9/
      DATA IOPERA( 203),IX( 203),IY( 203)/'MOVE',  -7,  -7/
      DATA IOPERA( 204),IX( 204),IY( 204)/'DRAW',  -8,  -9/
      DATA IOPERA( 205),IX( 205),IY( 205)/'MOVE',  -5,  -7/
      DATA IOPERA( 206),IX( 206),IY( 206)/'DRAW',  -4,  -9/
      DATA IOPERA( 207),IX( 207),IY( 207)/'MOVE',  -5,  -8/
      DATA IOPERA( 208),IX( 208),IY( 208)/'DRAW',  -3,  -9/
      DATA IOPERA( 209),IX( 209),IY( 209)/'MOVE',   5,  -7/
      DATA IOPERA( 210),IX( 210),IY( 210)/'DRAW',   3,  -9/
      DATA IOPERA( 211),IX( 211),IY( 211)/'MOVE',   5,  -7/
      DATA IOPERA( 212),IX( 212),IY( 212)/'DRAW',   8,  -9/
C
      DATA IXMIND(  11)/ -12/
      DATA IXMAXD(  11)/  10/
      DATA IXDELD(  11)/  22/
      DATA ISTARD(  11)/ 167/
      DATA NUMCOO(  11)/  46/
C
C     DEFINE CHARACTER   3012--UPPER CASE L
C
      DATA IOPERA( 213),IX( 213),IY( 213)/'MOVE',  -4,  12/
      DATA IOPERA( 214),IX( 214),IY( 214)/'DRAW',  -4,  -9/
      DATA IOPERA( 215),IX( 215),IY( 215)/'MOVE',  -3,  11/
      DATA IOPERA( 216),IX( 216),IY( 216)/'DRAW',  -3,  -8/
      DATA IOPERA( 217),IX( 217),IY( 217)/'MOVE',  -2,  12/
      DATA IOPERA( 218),IX( 218),IY( 218)/'DRAW',  -2,  -9/
      DATA IOPERA( 219),IX( 219),IY( 219)/'MOVE',  -7,  12/
      DATA IOPERA( 220),IX( 220),IY( 220)/'DRAW',   1,  12/
      DATA IOPERA( 221),IX( 221),IY( 221)/'MOVE',  -7,  -9/
      DATA IOPERA( 222),IX( 222),IY( 222)/'DRAW',   8,  -9/
      DATA IOPERA( 223),IX( 223),IY( 223)/'DRAW',   8,  -3/
      DATA IOPERA( 224),IX( 224),IY( 224)/'MOVE',  -6,  12/
      DATA IOPERA( 225),IX( 225),IY( 225)/'DRAW',  -4,  11/
      DATA IOPERA( 226),IX( 226),IY( 226)/'MOVE',  -5,  12/
      DATA IOPERA( 227),IX( 227),IY( 227)/'DRAW',  -4,  10/
      DATA IOPERA( 228),IX( 228),IY( 228)/'MOVE',  -1,  12/
      DATA IOPERA( 229),IX( 229),IY( 229)/'DRAW',  -2,  10/
      DATA IOPERA( 230),IX( 230),IY( 230)/'MOVE',   0,  12/
      DATA IOPERA( 231),IX( 231),IY( 231)/'DRAW',  -2,  11/
      DATA IOPERA( 232),IX( 232),IY( 232)/'MOVE',  -4,  -8/
      DATA IOPERA( 233),IX( 233),IY( 233)/'DRAW',  -6,  -9/
      DATA IOPERA( 234),IX( 234),IY( 234)/'MOVE',  -4,  -7/
      DATA IOPERA( 235),IX( 235),IY( 235)/'DRAW',  -5,  -9/
      DATA IOPERA( 236),IX( 236),IY( 236)/'MOVE',  -2,  -7/
      DATA IOPERA( 237),IX( 237),IY( 237)/'DRAW',  -1,  -9/
      DATA IOPERA( 238),IX( 238),IY( 238)/'MOVE',  -2,  -8/
      DATA IOPERA( 239),IX( 239),IY( 239)/'DRAW',   0,  -9/
      DATA IOPERA( 240),IX( 240),IY( 240)/'MOVE',   3,  -9/
      DATA IOPERA( 241),IX( 241),IY( 241)/'DRAW',   8,  -8/
      DATA IOPERA( 242),IX( 242),IY( 242)/'MOVE',   5,  -9/
      DATA IOPERA( 243),IX( 243),IY( 243)/'DRAW',   8,  -7/
      DATA IOPERA( 244),IX( 244),IY( 244)/'MOVE',   6,  -9/
      DATA IOPERA( 245),IX( 245),IY( 245)/'DRAW',   8,  -6/
      DATA IOPERA( 246),IX( 246),IY( 246)/'MOVE',   7,  -9/
      DATA IOPERA( 247),IX( 247),IY( 247)/'DRAW',   8,  -3/
C
      DATA IXMIND(  12)/  -9/
      DATA IXMAXD(  12)/   9/
      DATA IXDELD(  12)/  18/
      DATA ISTARD(  12)/ 213/
      DATA NUMCOO(  12)/  35/
C
C     DEFINE CHARACTER   3013--UPPER CASE M
C
      DATA IOPERA( 248),IX( 248),IY( 248)/'MOVE',  -8,  12/
      DATA IOPERA( 249),IX( 249),IY( 249)/'DRAW',  -8,  -8/
      DATA IOPERA( 250),IX( 250),IY( 250)/'MOVE',  -8,  12/
      DATA IOPERA( 251),IX( 251),IY( 251)/'DRAW',  -1,  -9/
      DATA IOPERA( 252),IX( 252),IY( 252)/'MOVE',  -7,  12/
      DATA IOPERA( 253),IX( 253),IY( 253)/'DRAW',  -1,  -6/
      DATA IOPERA( 254),IX( 254),IY( 254)/'MOVE',  -6,  12/
      DATA IOPERA( 255),IX( 255),IY( 255)/'DRAW',   0,  -6/
      DATA IOPERA( 256),IX( 256),IY( 256)/'MOVE',   6,  12/
      DATA IOPERA( 257),IX( 257),IY( 257)/'DRAW',  -1,  -9/
      DATA IOPERA( 258),IX( 258),IY( 258)/'MOVE',   6,  12/
      DATA IOPERA( 259),IX( 259),IY( 259)/'DRAW',   6,  -9/
      DATA IOPERA( 260),IX( 260),IY( 260)/'MOVE',   7,  11/
      DATA IOPERA( 261),IX( 261),IY( 261)/'DRAW',   7,  -8/
      DATA IOPERA( 262),IX( 262),IY( 262)/'MOVE',   8,  12/
      DATA IOPERA( 263),IX( 263),IY( 263)/'DRAW',   8,  -9/
      DATA IOPERA( 264),IX( 264),IY( 264)/'MOVE', -11,  12/
      DATA IOPERA( 265),IX( 265),IY( 265)/'DRAW',  -6,  12/
      DATA IOPERA( 266),IX( 266),IY( 266)/'MOVE',   6,  12/
      DATA IOPERA( 267),IX( 267),IY( 267)/'DRAW',  11,  12/
      DATA IOPERA( 268),IX( 268),IY( 268)/'MOVE', -11,  -9/
      DATA IOPERA( 269),IX( 269),IY( 269)/'DRAW',  -5,  -9/
      DATA IOPERA( 270),IX( 270),IY( 270)/'MOVE',   3,  -9/
      DATA IOPERA( 271),IX( 271),IY( 271)/'DRAW',  11,  -9/
      DATA IOPERA( 272),IX( 272),IY( 272)/'MOVE', -10,  12/
      DATA IOPERA( 273),IX( 273),IY( 273)/'DRAW',  -8,  11/
      DATA IOPERA( 274),IX( 274),IY( 274)/'MOVE',   9,  12/
      DATA IOPERA( 275),IX( 275),IY( 275)/'DRAW',   8,  10/
      DATA IOPERA( 276),IX( 276),IY( 276)/'MOVE',  10,  12/
      DATA IOPERA( 277),IX( 277),IY( 277)/'DRAW',   8,  11/
      DATA IOPERA( 278),IX( 278),IY( 278)/'MOVE',  -8,  -8/
      DATA IOPERA( 279),IX( 279),IY( 279)/'DRAW', -10,  -9/
      DATA IOPERA( 280),IX( 280),IY( 280)/'MOVE',  -8,  -8/
      DATA IOPERA( 281),IX( 281),IY( 281)/'DRAW',  -6,  -9/
      DATA IOPERA( 282),IX( 282),IY( 282)/'MOVE',   6,  -8/
      DATA IOPERA( 283),IX( 283),IY( 283)/'DRAW',   4,  -9/
      DATA IOPERA( 284),IX( 284),IY( 284)/'MOVE',   6,  -7/
      DATA IOPERA( 285),IX( 285),IY( 285)/'DRAW',   5,  -9/
      DATA IOPERA( 286),IX( 286),IY( 286)/'MOVE',   8,  -7/
      DATA IOPERA( 287),IX( 287),IY( 287)/'DRAW',   9,  -9/
      DATA IOPERA( 288),IX( 288),IY( 288)/'MOVE',   8,  -8/
      DATA IOPERA( 289),IX( 289),IY( 289)/'DRAW',  10,  -9/
C
      DATA IXMIND(  13)/ -13/
      DATA IXMAXD(  13)/  13/
      DATA IXDELD(  13)/  26/
      DATA ISTARD(  13)/ 248/
      DATA NUMCOO(  13)/  42/
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='YES'
      IERROR='NO'
C
      NUMCO=1
      ISTART=1
      ISTOP=1
      NC=1
C
C               ******************************************
C               **  TREAT THE ROMAN SIMPLEX UPPER CASE  **
C               **  HERSHEY CHARACTER SET CASE          **
C               ******************************************
C
C
      IF(IBUGD2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DRTU2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)ICHARN
   52 FORMAT('ICHARN = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)IBUGD2,IFOUND,IERROR
   59 FORMAT('IBUGD2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************
C               **  STEP 2--                        **
C               **  EXTRACT THE COORDINATES         **
C               **  FOR THIS PARTICULAR CHARACTER.  **
C               **************************************
C
 1000 CONTINUE
      ISTART=ISTARD(ICHARN)
      NC=NUMCOO(ICHARN)
      ISTOP=ISTART+NC-1
      J=0
      DO1100I=ISTART,ISTOP
      J=J+1
      IOP(J)=IOPERA(I)
      X(J)=IX(I)
      Y(J)=IY(I)
 1100 CONTINUE
      NUMCO=J
      IXMINS=IXMIND(ICHARN)
      IXMAXS=IXMAXD(ICHARN)
      IXDELS=IXDELD(ICHARN)
C
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGD2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DRTU2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGD2,IFOUND,IERROR
 9012 FORMAT('IBUGD2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICHARN
 9013 FORMAT('ICHARN = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)ISTART,ISTOP,NC,NUMCO
 9014 FORMAT('ISTART,ISTOP,NC,NUMCO = ',4I8)
      CALL DPWRST('XXX','BUG ')
      IF(NUMCO.GE.1.AND.NUMCO.LE.1000)GOTO9019
      DO9015I=1,NUMCO
      WRITE(ICOUT,9016)I,IOP(I),X(I),Y(I)
 9016 FORMAT('I,IOP(I),X(I),Y(I) = ',I8,2X,A4,2F10.2)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
 9019 CONTINUE
      WRITE(ICOUT,9021)IXMINS,IXMAXS,IXDELS
 9021 FORMAT('IXMINS,IXMAXS,IXDELS = ',3I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DRTU3(ICHARN,IOP,X,Y,NUMCO,IXMINS,IXMAXS,IXDELS,
     1IBUGD2,IFOUND,IERROR)
C
C     PURPOSE--DEFINE AND SET THE HERSHEY CHARACTER SET COORDINATES
C              FOR ROMAN TRIPLEX UPPER CASE (PART 3).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--87/4
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MARCH     1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MARCH     1987.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IOP
      CHARACTER*4 IBUGD2
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IOPERA
C
C---------------------------------------------------------------------
C
      DIMENSION IOP(*)
      DIMENSION X(*)
      DIMENSION Y(*)
C
      DIMENSION IOPERA(300)
      DIMENSION IX(300)
      DIMENSION IY(300)
C
      DIMENSION IXMIND(30)
      DIMENSION IXMAXD(30)
      DIMENSION IXDELD(30)
      DIMENSION ISTARD(30)
      DIMENSION NUMCOO(30)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C     DEFINE CHARACTER   3014--UPPER CASE N
C
      DATA IOPERA(   1),IX(   1),IY(   1)/'MOVE',  -7,  12/
      DATA IOPERA(   2),IX(   2),IY(   2)/'DRAW',  -7,  -8/
      DATA IOPERA(   3),IX(   3),IY(   3)/'MOVE',  -7,  12/
      DATA IOPERA(   4),IX(   4),IY(   4)/'DRAW',   7,  -9/
      DATA IOPERA(   5),IX(   5),IY(   5)/'MOVE',  -6,  12/
      DATA IOPERA(   6),IX(   6),IY(   6)/'DRAW',   6,  -6/
      DATA IOPERA(   7),IX(   7),IY(   7)/'MOVE',  -5,  12/
      DATA IOPERA(   8),IX(   8),IY(   8)/'DRAW',   7,  -6/
      DATA IOPERA(   9),IX(   9),IY(   9)/'MOVE',   7,  11/
      DATA IOPERA(  10),IX(  10),IY(  10)/'DRAW',   7,  -9/
      DATA IOPERA(  11),IX(  11),IY(  11)/'MOVE', -10,  12/
      DATA IOPERA(  12),IX(  12),IY(  12)/'DRAW',  -5,  12/
      DATA IOPERA(  13),IX(  13),IY(  13)/'MOVE',   4,  12/
      DATA IOPERA(  14),IX(  14),IY(  14)/'DRAW',  10,  12/
      DATA IOPERA(  15),IX(  15),IY(  15)/'MOVE', -10,  -9/
      DATA IOPERA(  16),IX(  16),IY(  16)/'DRAW',  -4,  -9/
      DATA IOPERA(  17),IX(  17),IY(  17)/'MOVE',  -9,  12/
      DATA IOPERA(  18),IX(  18),IY(  18)/'DRAW',  -7,  11/
      DATA IOPERA(  19),IX(  19),IY(  19)/'MOVE',   5,  12/
      DATA IOPERA(  20),IX(  20),IY(  20)/'DRAW',   7,  11/
      DATA IOPERA(  21),IX(  21),IY(  21)/'MOVE',   9,  12/
      DATA IOPERA(  22),IX(  22),IY(  22)/'DRAW',   7,  11/
      DATA IOPERA(  23),IX(  23),IY(  23)/'MOVE',  -7,  -8/
      DATA IOPERA(  24),IX(  24),IY(  24)/'DRAW',  -9,  -9/
      DATA IOPERA(  25),IX(  25),IY(  25)/'MOVE',  -7,  -8/
      DATA IOPERA(  26),IX(  26),IY(  26)/'DRAW',  -5,  -9/
C
      DATA IXMIND(  14)/ -12/
      DATA IXMAXD(  14)/  12/
      DATA IXDELD(  14)/  24/
      DATA ISTARD(  14)/   1/
      DATA NUMCOO(  14)/  26/
C
C     DEFINE CHARACTER   3015--UPPER CASE O
C
      DATA IOPERA(  27),IX(  27),IY(  27)/'MOVE',  -1,  12/
      DATA IOPERA(  28),IX(  28),IY(  28)/'DRAW',  -4,  11/
      DATA IOPERA(  29),IX(  29),IY(  29)/'DRAW',  -6,   9/
      DATA IOPERA(  30),IX(  30),IY(  30)/'DRAW',  -7,   7/
      DATA IOPERA(  31),IX(  31),IY(  31)/'DRAW',  -8,   3/
      DATA IOPERA(  32),IX(  32),IY(  32)/'DRAW',  -8,   0/
      DATA IOPERA(  33),IX(  33),IY(  33)/'DRAW',  -7,  -4/
      DATA IOPERA(  34),IX(  34),IY(  34)/'DRAW',  -6,  -6/
      DATA IOPERA(  35),IX(  35),IY(  35)/'DRAW',  -4,  -8/
      DATA IOPERA(  36),IX(  36),IY(  36)/'DRAW',  -1,  -9/
      DATA IOPERA(  37),IX(  37),IY(  37)/'DRAW',   1,  -9/
      DATA IOPERA(  38),IX(  38),IY(  38)/'DRAW',   4,  -8/
      DATA IOPERA(  39),IX(  39),IY(  39)/'DRAW',   6,  -6/
      DATA IOPERA(  40),IX(  40),IY(  40)/'DRAW',   7,  -4/
      DATA IOPERA(  41),IX(  41),IY(  41)/'DRAW',   8,   0/
      DATA IOPERA(  42),IX(  42),IY(  42)/'DRAW',   8,   3/
      DATA IOPERA(  43),IX(  43),IY(  43)/'DRAW',   7,   7/
      DATA IOPERA(  44),IX(  44),IY(  44)/'DRAW',   6,   9/
      DATA IOPERA(  45),IX(  45),IY(  45)/'DRAW',   4,  11/
      DATA IOPERA(  46),IX(  46),IY(  46)/'DRAW',   1,  12/
      DATA IOPERA(  47),IX(  47),IY(  47)/'DRAW',  -1,  12/
      DATA IOPERA(  48),IX(  48),IY(  48)/'MOVE',  -5,   9/
      DATA IOPERA(  49),IX(  49),IY(  49)/'DRAW',  -6,   7/
      DATA IOPERA(  50),IX(  50),IY(  50)/'DRAW',  -7,   4/
      DATA IOPERA(  51),IX(  51),IY(  51)/'DRAW',  -7,  -1/
      DATA IOPERA(  52),IX(  52),IY(  52)/'DRAW',  -6,  -4/
      DATA IOPERA(  53),IX(  53),IY(  53)/'DRAW',  -5,  -6/
      DATA IOPERA(  54),IX(  54),IY(  54)/'MOVE',   5,  -6/
      DATA IOPERA(  55),IX(  55),IY(  55)/'DRAW',   6,  -4/
      DATA IOPERA(  56),IX(  56),IY(  56)/'DRAW',   7,  -1/
      DATA IOPERA(  57),IX(  57),IY(  57)/'DRAW',   7,   4/
      DATA IOPERA(  58),IX(  58),IY(  58)/'DRAW',   6,   7/
      DATA IOPERA(  59),IX(  59),IY(  59)/'DRAW',   5,   9/
      DATA IOPERA(  60),IX(  60),IY(  60)/'MOVE',  -1,  12/
      DATA IOPERA(  61),IX(  61),IY(  61)/'DRAW',  -3,  11/
      DATA IOPERA(  62),IX(  62),IY(  62)/'DRAW',  -5,   8/
      DATA IOPERA(  63),IX(  63),IY(  63)/'DRAW',  -6,   4/
      DATA IOPERA(  64),IX(  64),IY(  64)/'DRAW',  -6,  -1/
      DATA IOPERA(  65),IX(  65),IY(  65)/'DRAW',  -5,  -5/
      DATA IOPERA(  66),IX(  66),IY(  66)/'DRAW',  -3,  -8/
      DATA IOPERA(  67),IX(  67),IY(  67)/'DRAW',  -1,  -9/
      DATA IOPERA(  68),IX(  68),IY(  68)/'MOVE',   1,  -9/
      DATA IOPERA(  69),IX(  69),IY(  69)/'DRAW',   3,  -8/
      DATA IOPERA(  70),IX(  70),IY(  70)/'DRAW',   5,  -5/
      DATA IOPERA(  71),IX(  71),IY(  71)/'DRAW',   6,  -1/
      DATA IOPERA(  72),IX(  72),IY(  72)/'DRAW',   6,   4/
      DATA IOPERA(  73),IX(  73),IY(  73)/'DRAW',   5,   8/
      DATA IOPERA(  74),IX(  74),IY(  74)/'DRAW',   3,  11/
      DATA IOPERA(  75),IX(  75),IY(  75)/'DRAW',   1,  12/
C
      DATA IXMIND(  15)/ -11/
      DATA IXMAXD(  15)/  11/
      DATA IXDELD(  15)/  22/
      DATA ISTARD(  15)/  27/
      DATA NUMCOO(  15)/  49/
C
C     DEFINE CHARACTER   3016--UPPER CASE P
C
      DATA IOPERA(  76),IX(  76),IY(  76)/'MOVE',  -6,  12/
      DATA IOPERA(  77),IX(  77),IY(  77)/'DRAW',  -6,  -9/
      DATA IOPERA(  78),IX(  78),IY(  78)/'MOVE',  -5,  11/
      DATA IOPERA(  79),IX(  79),IY(  79)/'DRAW',  -5,  -8/
      DATA IOPERA(  80),IX(  80),IY(  80)/'MOVE',  -4,  12/
      DATA IOPERA(  81),IX(  81),IY(  81)/'DRAW',  -4,  -9/
      DATA IOPERA(  82),IX(  82),IY(  82)/'MOVE',  -9,  12/
      DATA IOPERA(  83),IX(  83),IY(  83)/'DRAW',   3,  12/
      DATA IOPERA(  84),IX(  84),IY(  84)/'DRAW',   6,  11/
      DATA IOPERA(  85),IX(  85),IY(  85)/'DRAW',   7,  10/
      DATA IOPERA(  86),IX(  86),IY(  86)/'DRAW',   8,   8/
      DATA IOPERA(  87),IX(  87),IY(  87)/'DRAW',   8,   5/
      DATA IOPERA(  88),IX(  88),IY(  88)/'DRAW',   7,   3/
      DATA IOPERA(  89),IX(  89),IY(  89)/'DRAW',   6,   2/
      DATA IOPERA(  90),IX(  90),IY(  90)/'DRAW',   3,   1/
      DATA IOPERA(  91),IX(  91),IY(  91)/'DRAW',  -4,   1/
      DATA IOPERA(  92),IX(  92),IY(  92)/'MOVE',   6,  10/
      DATA IOPERA(  93),IX(  93),IY(  93)/'DRAW',   7,   8/
      DATA IOPERA(  94),IX(  94),IY(  94)/'DRAW',   7,   5/
      DATA IOPERA(  95),IX(  95),IY(  95)/'DRAW',   6,   3/
      DATA IOPERA(  96),IX(  96),IY(  96)/'MOVE',   3,  12/
      DATA IOPERA(  97),IX(  97),IY(  97)/'DRAW',   5,  11/
      DATA IOPERA(  98),IX(  98),IY(  98)/'DRAW',   6,   9/
      DATA IOPERA(  99),IX(  99),IY(  99)/'DRAW',   6,   4/
      DATA IOPERA( 100),IX( 100),IY( 100)/'DRAW',   5,   2/
      DATA IOPERA( 101),IX( 101),IY( 101)/'DRAW',   3,   1/
      DATA IOPERA( 102),IX( 102),IY( 102)/'MOVE',  -9,  -9/
      DATA IOPERA( 103),IX( 103),IY( 103)/'DRAW',  -1,  -9/
      DATA IOPERA( 104),IX( 104),IY( 104)/'MOVE',  -8,  12/
      DATA IOPERA( 105),IX( 105),IY( 105)/'DRAW',  -6,  11/
      DATA IOPERA( 106),IX( 106),IY( 106)/'MOVE',  -7,  12/
      DATA IOPERA( 107),IX( 107),IY( 107)/'DRAW',  -6,  10/
      DATA IOPERA( 108),IX( 108),IY( 108)/'MOVE',  -3,  12/
      DATA IOPERA( 109),IX( 109),IY( 109)/'DRAW',  -4,  10/
      DATA IOPERA( 110),IX( 110),IY( 110)/'MOVE',  -2,  12/
      DATA IOPERA( 111),IX( 111),IY( 111)/'DRAW',  -4,  11/
      DATA IOPERA( 112),IX( 112),IY( 112)/'MOVE',  -6,  -8/
      DATA IOPERA( 113),IX( 113),IY( 113)/'DRAW',  -8,  -9/
      DATA IOPERA( 114),IX( 114),IY( 114)/'MOVE',  -6,  -7/
      DATA IOPERA( 115),IX( 115),IY( 115)/'DRAW',  -7,  -9/
      DATA IOPERA( 116),IX( 116),IY( 116)/'MOVE',  -4,  -7/
      DATA IOPERA( 117),IX( 117),IY( 117)/'DRAW',  -3,  -9/
      DATA IOPERA( 118),IX( 118),IY( 118)/'MOVE',  -4,  -8/
      DATA IOPERA( 119),IX( 119),IY( 119)/'DRAW',  -2,  -9/
C
      DATA IXMIND(  16)/ -11/
      DATA IXMAXD(  16)/  11/
      DATA IXDELD(  16)/  22/
      DATA ISTARD(  16)/  76/
      DATA NUMCOO(  16)/  44/
C
C     DEFINE CHARACTER   3017--UPPER CASE Q
C
      DATA IOPERA( 120),IX( 120),IY( 120)/'MOVE',  -1,  12/
      DATA IOPERA( 121),IX( 121),IY( 121)/'DRAW',  -4,  11/
      DATA IOPERA( 122),IX( 122),IY( 122)/'DRAW',  -6,   9/
      DATA IOPERA( 123),IX( 123),IY( 123)/'DRAW',  -7,   7/
      DATA IOPERA( 124),IX( 124),IY( 124)/'DRAW',  -8,   3/
      DATA IOPERA( 125),IX( 125),IY( 125)/'DRAW',  -8,   0/
      DATA IOPERA( 126),IX( 126),IY( 126)/'DRAW',  -7,  -4/
      DATA IOPERA( 127),IX( 127),IY( 127)/'DRAW',  -6,  -6/
      DATA IOPERA( 128),IX( 128),IY( 128)/'DRAW',  -4,  -8/
      DATA IOPERA( 129),IX( 129),IY( 129)/'DRAW',  -1,  -9/
      DATA IOPERA( 130),IX( 130),IY( 130)/'DRAW',   1,  -9/
      DATA IOPERA( 131),IX( 131),IY( 131)/'DRAW',   4,  -8/
      DATA IOPERA( 132),IX( 132),IY( 132)/'DRAW',   6,  -6/
      DATA IOPERA( 133),IX( 133),IY( 133)/'DRAW',   7,  -4/
      DATA IOPERA( 134),IX( 134),IY( 134)/'DRAW',   8,   0/
      DATA IOPERA( 135),IX( 135),IY( 135)/'DRAW',   8,   3/
      DATA IOPERA( 136),IX( 136),IY( 136)/'DRAW',   7,   7/
      DATA IOPERA( 137),IX( 137),IY( 137)/'DRAW',   6,   9/
      DATA IOPERA( 138),IX( 138),IY( 138)/'DRAW',   4,  11/
      DATA IOPERA( 139),IX( 139),IY( 139)/'DRAW',   1,  12/
      DATA IOPERA( 140),IX( 140),IY( 140)/'DRAW',  -1,  12/
      DATA IOPERA( 141),IX( 141),IY( 141)/'MOVE',  -5,   9/
      DATA IOPERA( 142),IX( 142),IY( 142)/'DRAW',  -6,   7/
      DATA IOPERA( 143),IX( 143),IY( 143)/'DRAW',  -7,   4/
      DATA IOPERA( 144),IX( 144),IY( 144)/'DRAW',  -7,  -1/
      DATA IOPERA( 145),IX( 145),IY( 145)/'DRAW',  -6,  -4/
      DATA IOPERA( 146),IX( 146),IY( 146)/'DRAW',  -5,  -6/
      DATA IOPERA( 147),IX( 147),IY( 147)/'MOVE',   5,  -6/
      DATA IOPERA( 148),IX( 148),IY( 148)/'DRAW',   6,  -4/
      DATA IOPERA( 149),IX( 149),IY( 149)/'DRAW',   7,  -1/
      DATA IOPERA( 150),IX( 150),IY( 150)/'DRAW',   7,   4/
      DATA IOPERA( 151),IX( 151),IY( 151)/'DRAW',   6,   7/
      DATA IOPERA( 152),IX( 152),IY( 152)/'DRAW',   5,   9/
      DATA IOPERA( 153),IX( 153),IY( 153)/'MOVE',  -1,  12/
      DATA IOPERA( 154),IX( 154),IY( 154)/'DRAW',  -3,  11/
      DATA IOPERA( 155),IX( 155),IY( 155)/'DRAW',  -5,   8/
      DATA IOPERA( 156),IX( 156),IY( 156)/'DRAW',  -6,   4/
      DATA IOPERA( 157),IX( 157),IY( 157)/'DRAW',  -6,  -1/
      DATA IOPERA( 158),IX( 158),IY( 158)/'DRAW',  -5,  -5/
      DATA IOPERA( 159),IX( 159),IY( 159)/'DRAW',  -3,  -8/
      DATA IOPERA( 160),IX( 160),IY( 160)/'DRAW',  -1,  -9/
      DATA IOPERA( 161),IX( 161),IY( 161)/'MOVE',   1,  -9/
      DATA IOPERA( 162),IX( 162),IY( 162)/'DRAW',   3,  -8/
      DATA IOPERA( 163),IX( 163),IY( 163)/'DRAW',   5,  -5/
      DATA IOPERA( 164),IX( 164),IY( 164)/'DRAW',   6,  -1/
      DATA IOPERA( 165),IX( 165),IY( 165)/'DRAW',   6,   4/
      DATA IOPERA( 166),IX( 166),IY( 166)/'DRAW',   5,   8/
      DATA IOPERA( 167),IX( 167),IY( 167)/'DRAW',   3,  11/
      DATA IOPERA( 168),IX( 168),IY( 168)/'DRAW',   1,  12/
      DATA IOPERA( 169),IX( 169),IY( 169)/'MOVE',  -4,  -6/
      DATA IOPERA( 170),IX( 170),IY( 170)/'DRAW',  -3,  -4/
      DATA IOPERA( 171),IX( 171),IY( 171)/'DRAW',  -1,  -3/
      DATA IOPERA( 172),IX( 172),IY( 172)/'DRAW',   0,  -3/
      DATA IOPERA( 173),IX( 173),IY( 173)/'DRAW',   2,  -4/
      DATA IOPERA( 174),IX( 174),IY( 174)/'DRAW',   3,  -6/
      DATA IOPERA( 175),IX( 175),IY( 175)/'DRAW',   4, -12/
      DATA IOPERA( 176),IX( 176),IY( 176)/'DRAW',   5, -14/
      DATA IOPERA( 177),IX( 177),IY( 177)/'DRAW',   7, -14/
      DATA IOPERA( 178),IX( 178),IY( 178)/'DRAW',   8, -12/
      DATA IOPERA( 179),IX( 179),IY( 179)/'DRAW',   8, -10/
      DATA IOPERA( 180),IX( 180),IY( 180)/'MOVE',   4, -10/
      DATA IOPERA( 181),IX( 181),IY( 181)/'DRAW',   5, -12/
      DATA IOPERA( 182),IX( 182),IY( 182)/'DRAW',   6, -13/
      DATA IOPERA( 183),IX( 183),IY( 183)/'DRAW',   7, -13/
      DATA IOPERA( 184),IX( 184),IY( 184)/'MOVE',   3,  -6/
      DATA IOPERA( 185),IX( 185),IY( 185)/'DRAW',   5, -11/
      DATA IOPERA( 186),IX( 186),IY( 186)/'DRAW',   6, -12/
      DATA IOPERA( 187),IX( 187),IY( 187)/'DRAW',   7, -12/
      DATA IOPERA( 188),IX( 188),IY( 188)/'DRAW',   8, -11/
C
      DATA IXMIND(  17)/ -11/
      DATA IXMAXD(  17)/  11/
      DATA IXDELD(  17)/  22/
      DATA ISTARD(  17)/ 120/
      DATA NUMCOO(  17)/  69/
C
C     DEFINE CHARACTER   3018--UPPER CASE R
C
      DATA IOPERA( 189),IX( 189),IY( 189)/'MOVE',  -6,  12/
      DATA IOPERA( 190),IX( 190),IY( 190)/'DRAW',  -6,  -9/
      DATA IOPERA( 191),IX( 191),IY( 191)/'MOVE',  -5,  11/
      DATA IOPERA( 192),IX( 192),IY( 192)/'DRAW',  -5,  -8/
      DATA IOPERA( 193),IX( 193),IY( 193)/'MOVE',  -4,  12/
      DATA IOPERA( 194),IX( 194),IY( 194)/'DRAW',  -4,  -9/
      DATA IOPERA( 195),IX( 195),IY( 195)/'MOVE',  -9,  12/
      DATA IOPERA( 196),IX( 196),IY( 196)/'DRAW',   3,  12/
      DATA IOPERA( 197),IX( 197),IY( 197)/'DRAW',   6,  11/
      DATA IOPERA( 198),IX( 198),IY( 198)/'DRAW',   7,  10/
      DATA IOPERA( 199),IX( 199),IY( 199)/'DRAW',   8,   8/
      DATA IOPERA( 200),IX( 200),IY( 200)/'DRAW',   8,   6/
      DATA IOPERA( 201),IX( 201),IY( 201)/'DRAW',   7,   4/
      DATA IOPERA( 202),IX( 202),IY( 202)/'DRAW',   6,   3/
      DATA IOPERA( 203),IX( 203),IY( 203)/'DRAW',   3,   2/
      DATA IOPERA( 204),IX( 204),IY( 204)/'DRAW',  -4,   2/
      DATA IOPERA( 205),IX( 205),IY( 205)/'MOVE',   6,  10/
      DATA IOPERA( 206),IX( 206),IY( 206)/'DRAW',   7,   8/
      DATA IOPERA( 207),IX( 207),IY( 207)/'DRAW',   7,   6/
      DATA IOPERA( 208),IX( 208),IY( 208)/'DRAW',   6,   4/
      DATA IOPERA( 209),IX( 209),IY( 209)/'MOVE',   3,  12/
      DATA IOPERA( 210),IX( 210),IY( 210)/'DRAW',   5,  11/
      DATA IOPERA( 211),IX( 211),IY( 211)/'DRAW',   6,   9/
      DATA IOPERA( 212),IX( 212),IY( 212)/'DRAW',   6,   5/
      DATA IOPERA( 213),IX( 213),IY( 213)/'DRAW',   5,   3/
      DATA IOPERA( 214),IX( 214),IY( 214)/'DRAW',   3,   2/
      DATA IOPERA( 215),IX( 215),IY( 215)/'MOVE',   0,   2/
      DATA IOPERA( 216),IX( 216),IY( 216)/'DRAW',   2,   1/
      DATA IOPERA( 217),IX( 217),IY( 217)/'DRAW',   3,  -1/
      DATA IOPERA( 218),IX( 218),IY( 218)/'DRAW',   5,  -7/
      DATA IOPERA( 219),IX( 219),IY( 219)/'DRAW',   6,  -9/
      DATA IOPERA( 220),IX( 220),IY( 220)/'DRAW',   8,  -9/
      DATA IOPERA( 221),IX( 221),IY( 221)/'DRAW',   9,  -7/
      DATA IOPERA( 222),IX( 222),IY( 222)/'DRAW',   9,  -5/
      DATA IOPERA( 223),IX( 223),IY( 223)/'MOVE',   5,  -5/
      DATA IOPERA( 224),IX( 224),IY( 224)/'DRAW',   6,  -7/
      DATA IOPERA( 225),IX( 225),IY( 225)/'DRAW',   7,  -8/
      DATA IOPERA( 226),IX( 226),IY( 226)/'DRAW',   8,  -8/
      DATA IOPERA( 227),IX( 227),IY( 227)/'MOVE',   2,   1/
      DATA IOPERA( 228),IX( 228),IY( 228)/'DRAW',   3,   0/
      DATA IOPERA( 229),IX( 229),IY( 229)/'DRAW',   6,  -6/
      DATA IOPERA( 230),IX( 230),IY( 230)/'DRAW',   7,  -7/
      DATA IOPERA( 231),IX( 231),IY( 231)/'DRAW',   8,  -7/
      DATA IOPERA( 232),IX( 232),IY( 232)/'DRAW',   9,  -6/
      DATA IOPERA( 233),IX( 233),IY( 233)/'MOVE',  -9,  -9/
      DATA IOPERA( 234),IX( 234),IY( 234)/'DRAW',  -1,  -9/
      DATA IOPERA( 235),IX( 235),IY( 235)/'MOVE',  -8,  12/
      DATA IOPERA( 236),IX( 236),IY( 236)/'DRAW',  -6,  11/
      DATA IOPERA( 237),IX( 237),IY( 237)/'MOVE',  -7,  12/
      DATA IOPERA( 238),IX( 238),IY( 238)/'DRAW',  -6,  10/
      DATA IOPERA( 239),IX( 239),IY( 239)/'MOVE',  -3,  12/
      DATA IOPERA( 240),IX( 240),IY( 240)/'DRAW',  -4,  10/
      DATA IOPERA( 241),IX( 241),IY( 241)/'MOVE',  -2,  12/
      DATA IOPERA( 242),IX( 242),IY( 242)/'DRAW',  -4,  11/
      DATA IOPERA( 243),IX( 243),IY( 243)/'MOVE',  -6,  -8/
      DATA IOPERA( 244),IX( 244),IY( 244)/'DRAW',  -8,  -9/
      DATA IOPERA( 245),IX( 245),IY( 245)/'MOVE',  -6,  -7/
      DATA IOPERA( 246),IX( 246),IY( 246)/'DRAW',  -7,  -9/
      DATA IOPERA( 247),IX( 247),IY( 247)/'MOVE',  -4,  -7/
      DATA IOPERA( 248),IX( 248),IY( 248)/'DRAW',  -3,  -9/
      DATA IOPERA( 249),IX( 249),IY( 249)/'MOVE',  -4,  -8/
      DATA IOPERA( 250),IX( 250),IY( 250)/'DRAW',  -2,  -9/
C
      DATA IXMIND(  18)/ -11/
      DATA IXMAXD(  18)/  11/
      DATA IXDELD(  18)/  22/
      DATA ISTARD(  18)/ 189/
      DATA NUMCOO(  18)/  62/
C
C     DEFINE CHARACTER   3019--UPPER CASE S
C
      DATA IOPERA( 251),IX( 251),IY( 251)/'MOVE',   6,   9/
      DATA IOPERA( 252),IX( 252),IY( 252)/'DRAW',   7,  12/
      DATA IOPERA( 253),IX( 253),IY( 253)/'DRAW',   7,   6/
      DATA IOPERA( 254),IX( 254),IY( 254)/'DRAW',   6,   9/
      DATA IOPERA( 255),IX( 255),IY( 255)/'DRAW',   4,  11/
      DATA IOPERA( 256),IX( 256),IY( 256)/'DRAW',   1,  12/
      DATA IOPERA( 257),IX( 257),IY( 257)/'DRAW',  -2,  12/
      DATA IOPERA( 258),IX( 258),IY( 258)/'DRAW',  -5,  11/
      DATA IOPERA( 259),IX( 259),IY( 259)/'DRAW',  -7,   9/
      DATA IOPERA( 260),IX( 260),IY( 260)/'DRAW',  -7,   6/
      DATA IOPERA( 261),IX( 261),IY( 261)/'DRAW',  -6,   4/
      DATA IOPERA( 262),IX( 262),IY( 262)/'DRAW',  -3,   2/
      DATA IOPERA( 263),IX( 263),IY( 263)/'DRAW',   3,   0/
      DATA IOPERA( 264),IX( 264),IY( 264)/'DRAW',   5,  -1/
      DATA IOPERA( 265),IX( 265),IY( 265)/'DRAW',   6,  -3/
      DATA IOPERA( 266),IX( 266),IY( 266)/'DRAW',   6,  -6/
      DATA IOPERA( 267),IX( 267),IY( 267)/'DRAW',   5,  -8/
      DATA IOPERA( 268),IX( 268),IY( 268)/'MOVE',  -6,   6/
      DATA IOPERA( 269),IX( 269),IY( 269)/'DRAW',  -5,   4/
      DATA IOPERA( 270),IX( 270),IY( 270)/'DRAW',  -3,   3/
      DATA IOPERA( 271),IX( 271),IY( 271)/'DRAW',   3,   1/
      DATA IOPERA( 272),IX( 272),IY( 272)/'DRAW',   5,   0/
      DATA IOPERA( 273),IX( 273),IY( 273)/'DRAW',   6,  -2/
      DATA IOPERA( 274),IX( 274),IY( 274)/'MOVE',  -5,  11/
      DATA IOPERA( 275),IX( 275),IY( 275)/'DRAW',  -6,   9/
      DATA IOPERA( 276),IX( 276),IY( 276)/'DRAW',  -6,   7/
      DATA IOPERA( 277),IX( 277),IY( 277)/'DRAW',  -5,   5/
      DATA IOPERA( 278),IX( 278),IY( 278)/'DRAW',  -3,   4/
      DATA IOPERA( 279),IX( 279),IY( 279)/'DRAW',   3,   2/
      DATA IOPERA( 280),IX( 280),IY( 280)/'DRAW',   6,   0/
      DATA IOPERA( 281),IX( 281),IY( 281)/'DRAW',   7,  -2/
      DATA IOPERA( 282),IX( 282),IY( 282)/'DRAW',   7,  -5/
      DATA IOPERA( 283),IX( 283),IY( 283)/'DRAW',   6,  -7/
      DATA IOPERA( 284),IX( 284),IY( 284)/'DRAW',   5,  -8/
      DATA IOPERA( 285),IX( 285),IY( 285)/'DRAW',   2,  -9/
      DATA IOPERA( 286),IX( 286),IY( 286)/'DRAW',  -1,  -9/
      DATA IOPERA( 287),IX( 287),IY( 287)/'DRAW',  -4,  -8/
      DATA IOPERA( 288),IX( 288),IY( 288)/'DRAW',  -6,  -6/
      DATA IOPERA( 289),IX( 289),IY( 289)/'DRAW',  -7,  -3/
      DATA IOPERA( 290),IX( 290),IY( 290)/'DRAW',  -7,  -9/
      DATA IOPERA( 291),IX( 291),IY( 291)/'DRAW',  -6,  -6/
C
      DATA IXMIND(  19)/ -10/
      DATA IXMAXD(  19)/  10/
      DATA IXDELD(  19)/  20/
      DATA ISTARD(  19)/ 251/
      DATA NUMCOO(  19)/  41/
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='YES'
      IERROR='NO'
C
      NUMCO=1
      ISTART=1
      ISTOP=1
      NC=1
C
C               ******************************************
C               **  TREAT THE ROMAN SIMPLEX UPPER CASE  **
C               **  HERSHEY CHARACTER SET CASE          **
C               ******************************************
C
C
      IF(IBUGD2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DRTU3--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)ICHARN
   52 FORMAT('ICHARN = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)IBUGD2,IFOUND,IERROR
   59 FORMAT('IBUGD2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************
C               **  STEP 2--                        **
C               **  EXTRACT THE COORDINATES         **
C               **  FOR THIS PARTICULAR CHARACTER.  **
C               **************************************
C
 1000 CONTINUE
      ISTART=ISTARD(ICHARN)
      NC=NUMCOO(ICHARN)
      ISTOP=ISTART+NC-1
      J=0
      DO1100I=ISTART,ISTOP
      J=J+1
      IOP(J)=IOPERA(I)
      X(J)=IX(I)
      Y(J)=IY(I)
 1100 CONTINUE
      NUMCO=J
      IXMINS=IXMIND(ICHARN)
      IXMAXS=IXMAXD(ICHARN)
      IXDELS=IXDELD(ICHARN)
C
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGD2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DRTU3--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGD2,IFOUND,IERROR
 9012 FORMAT('IBUGD2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICHARN
 9013 FORMAT('ICHARN = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)ISTART,ISTOP,NC,NUMCO
 9014 FORMAT('ISTART,ISTOP,NC,NUMCO = ',4I8)
      CALL DPWRST('XXX','BUG ')
      IF(NUMCO.GE.1.AND.NUMCO.LE.1000)GOTO9019
      DO9015I=1,NUMCO
      WRITE(ICOUT,9016)I,IOP(I),X(I),Y(I)
 9016 FORMAT('I,IOP(I),X(I),Y(I) = ',I8,2X,A4,2F10.2)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
 9019 CONTINUE
      WRITE(ICOUT,9021)IXMINS,IXMAXS,IXDELS
 9021 FORMAT('IXMINS,IXMAXS,IXDELS = ',3I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DRTU4(ICHARN,IOP,X,Y,NUMCO,IXMINS,IXMAXS,IXDELS,
     1IBUGD2,IFOUND,IERROR)
C
C     PURPOSE--DEFINE AND SET THE HERSHEY CHARACTER SET COORDINATES
C              FOR ROMAN TRIPLEX UPPER CASE (PART 4).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--87/4
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MARCH     1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MARCH     1987.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IOP
      CHARACTER*4 IBUGD2
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IOPERA
C
C---------------------------------------------------------------------
C
      DIMENSION IOP(*)
      DIMENSION X(*)
      DIMENSION Y(*)
C
      DIMENSION IOPERA(300)
      DIMENSION IX(300)
      DIMENSION IY(300)
C
      DIMENSION IXMIND(30)
      DIMENSION IXMAXD(30)
      DIMENSION IXDELD(30)
      DIMENSION ISTARD(30)
      DIMENSION NUMCOO(30)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C     DEFINE CHARACTER   3020--UPPER CASE T
C
      DATA IOPERA(   1),IX(   1),IY(   1)/'MOVE',  -8,  12/
      DATA IOPERA(   2),IX(   2),IY(   2)/'DRAW',  -8,   6/
      DATA IOPERA(   3),IX(   3),IY(   3)/'MOVE',  -1,  12/
      DATA IOPERA(   4),IX(   4),IY(   4)/'DRAW',  -1,  -9/
      DATA IOPERA(   5),IX(   5),IY(   5)/'MOVE',   0,  11/
      DATA IOPERA(   6),IX(   6),IY(   6)/'DRAW',   0,  -8/
      DATA IOPERA(   7),IX(   7),IY(   7)/'MOVE',   1,  12/
      DATA IOPERA(   8),IX(   8),IY(   8)/'DRAW',   1,  -9/
      DATA IOPERA(   9),IX(   9),IY(   9)/'MOVE',   8,  12/
      DATA IOPERA(  10),IX(  10),IY(  10)/'DRAW',   8,   6/
      DATA IOPERA(  11),IX(  11),IY(  11)/'MOVE',  -8,  12/
      DATA IOPERA(  12),IX(  12),IY(  12)/'DRAW',   8,  12/
      DATA IOPERA(  13),IX(  13),IY(  13)/'MOVE',  -4,  -9/
      DATA IOPERA(  14),IX(  14),IY(  14)/'DRAW',   4,  -9/
      DATA IOPERA(  15),IX(  15),IY(  15)/'MOVE',  -7,  12/
      DATA IOPERA(  16),IX(  16),IY(  16)/'DRAW',  -8,   6/
      DATA IOPERA(  17),IX(  17),IY(  17)/'MOVE',  -6,  12/
      DATA IOPERA(  18),IX(  18),IY(  18)/'DRAW',  -8,   9/
      DATA IOPERA(  19),IX(  19),IY(  19)/'MOVE',  -5,  12/
      DATA IOPERA(  20),IX(  20),IY(  20)/'DRAW',  -8,  10/
      DATA IOPERA(  21),IX(  21),IY(  21)/'MOVE',  -3,  12/
      DATA IOPERA(  22),IX(  22),IY(  22)/'DRAW',  -8,  11/
      DATA IOPERA(  23),IX(  23),IY(  23)/'MOVE',   3,  12/
      DATA IOPERA(  24),IX(  24),IY(  24)/'DRAW',   8,  11/
      DATA IOPERA(  25),IX(  25),IY(  25)/'MOVE',   5,  12/
      DATA IOPERA(  26),IX(  26),IY(  26)/'DRAW',   8,  10/
      DATA IOPERA(  27),IX(  27),IY(  27)/'MOVE',   6,  12/
      DATA IOPERA(  28),IX(  28),IY(  28)/'DRAW',   8,   9/
      DATA IOPERA(  29),IX(  29),IY(  29)/'MOVE',   7,  12/
      DATA IOPERA(  30),IX(  30),IY(  30)/'DRAW',   8,   6/
      DATA IOPERA(  31),IX(  31),IY(  31)/'MOVE',  -1,  -8/
      DATA IOPERA(  32),IX(  32),IY(  32)/'DRAW',  -3,  -9/
      DATA IOPERA(  33),IX(  33),IY(  33)/'MOVE',  -1,  -7/
      DATA IOPERA(  34),IX(  34),IY(  34)/'DRAW',  -2,  -9/
      DATA IOPERA(  35),IX(  35),IY(  35)/'MOVE',   1,  -7/
      DATA IOPERA(  36),IX(  36),IY(  36)/'DRAW',   2,  -9/
      DATA IOPERA(  37),IX(  37),IY(  37)/'MOVE',   1,  -8/
      DATA IOPERA(  38),IX(  38),IY(  38)/'DRAW',   3,  -9/
C
      DATA IXMIND(  20)/ -10/
      DATA IXMAXD(  20)/  10/
      DATA IXDELD(  20)/  20/
      DATA ISTARD(  20)/   1/
      DATA NUMCOO(  20)/  38/
C
C     DEFINE CHARACTER   3021--UPPER CASE U
C
      DATA IOPERA(  39),IX(  39),IY(  39)/'MOVE',  -7,  12/
      DATA IOPERA(  40),IX(  40),IY(  40)/'DRAW',  -7,  -3/
      DATA IOPERA(  41),IX(  41),IY(  41)/'DRAW',  -6,  -6/
      DATA IOPERA(  42),IX(  42),IY(  42)/'DRAW',  -4,  -8/
      DATA IOPERA(  43),IX(  43),IY(  43)/'DRAW',  -1,  -9/
      DATA IOPERA(  44),IX(  44),IY(  44)/'DRAW',   1,  -9/
      DATA IOPERA(  45),IX(  45),IY(  45)/'DRAW',   4,  -8/
      DATA IOPERA(  46),IX(  46),IY(  46)/'DRAW',   6,  -6/
      DATA IOPERA(  47),IX(  47),IY(  47)/'DRAW',   7,  -3/
      DATA IOPERA(  48),IX(  48),IY(  48)/'DRAW',   7,  11/
      DATA IOPERA(  49),IX(  49),IY(  49)/'MOVE',  -6,  11/
      DATA IOPERA(  50),IX(  50),IY(  50)/'DRAW',  -6,  -4/
      DATA IOPERA(  51),IX(  51),IY(  51)/'DRAW',  -5,  -6/
      DATA IOPERA(  52),IX(  52),IY(  52)/'MOVE',  -5,  12/
      DATA IOPERA(  53),IX(  53),IY(  53)/'DRAW',  -5,  -4/
      DATA IOPERA(  54),IX(  54),IY(  54)/'DRAW',  -4,  -7/
      DATA IOPERA(  55),IX(  55),IY(  55)/'DRAW',  -3,  -8/
      DATA IOPERA(  56),IX(  56),IY(  56)/'DRAW',  -1,  -9/
      DATA IOPERA(  57),IX(  57),IY(  57)/'MOVE', -10,  12/
      DATA IOPERA(  58),IX(  58),IY(  58)/'DRAW',  -2,  12/
      DATA IOPERA(  59),IX(  59),IY(  59)/'MOVE',   4,  12/
      DATA IOPERA(  60),IX(  60),IY(  60)/'DRAW',  10,  12/
      DATA IOPERA(  61),IX(  61),IY(  61)/'MOVE',  -9,  12/
      DATA IOPERA(  62),IX(  62),IY(  62)/'DRAW',  -7,  11/
      DATA IOPERA(  63),IX(  63),IY(  63)/'MOVE',  -8,  12/
      DATA IOPERA(  64),IX(  64),IY(  64)/'DRAW',  -7,  10/
      DATA IOPERA(  65),IX(  65),IY(  65)/'MOVE',  -4,  12/
      DATA IOPERA(  66),IX(  66),IY(  66)/'DRAW',  -5,  10/
      DATA IOPERA(  67),IX(  67),IY(  67)/'MOVE',  -3,  12/
      DATA IOPERA(  68),IX(  68),IY(  68)/'DRAW',  -5,  11/
      DATA IOPERA(  69),IX(  69),IY(  69)/'MOVE',   5,  12/
      DATA IOPERA(  70),IX(  70),IY(  70)/'DRAW',   7,  11/
      DATA IOPERA(  71),IX(  71),IY(  71)/'MOVE',   9,  12/
      DATA IOPERA(  72),IX(  72),IY(  72)/'DRAW',   7,  11/
C
      DATA IXMIND(  21)/ -12/
      DATA IXMAXD(  21)/  12/
      DATA IXDELD(  21)/  24/
      DATA ISTARD(  21)/  39/
      DATA NUMCOO(  21)/  34/
C
C     DEFINE CHARACTER   3022--UPPER CASE V
C
      DATA IOPERA(  73),IX(  73),IY(  73)/'MOVE',  -7,  12/
      DATA IOPERA(  74),IX(  74),IY(  74)/'DRAW',   0,  -9/
      DATA IOPERA(  75),IX(  75),IY(  75)/'MOVE',  -6,  12/
      DATA IOPERA(  76),IX(  76),IY(  76)/'DRAW',   0,  -6/
      DATA IOPERA(  77),IX(  77),IY(  77)/'DRAW',   0,  -9/
      DATA IOPERA(  78),IX(  78),IY(  78)/'MOVE',  -5,  12/
      DATA IOPERA(  79),IX(  79),IY(  79)/'DRAW',   1,  -6/
      DATA IOPERA(  80),IX(  80),IY(  80)/'MOVE',   7,  11/
      DATA IOPERA(  81),IX(  81),IY(  81)/'DRAW',   0,  -9/
      DATA IOPERA(  82),IX(  82),IY(  82)/'MOVE',  -9,  12/
      DATA IOPERA(  83),IX(  83),IY(  83)/'DRAW',  -2,  12/
      DATA IOPERA(  84),IX(  84),IY(  84)/'MOVE',   3,  12/
      DATA IOPERA(  85),IX(  85),IY(  85)/'DRAW',   9,  12/
      DATA IOPERA(  86),IX(  86),IY(  86)/'MOVE',  -8,  12/
      DATA IOPERA(  87),IX(  87),IY(  87)/'DRAW',  -6,  10/
      DATA IOPERA(  88),IX(  88),IY(  88)/'MOVE',  -4,  12/
      DATA IOPERA(  89),IX(  89),IY(  89)/'DRAW',  -5,  10/
      DATA IOPERA(  90),IX(  90),IY(  90)/'MOVE',  -3,  12/
      DATA IOPERA(  91),IX(  91),IY(  91)/'DRAW',  -5,  11/
      DATA IOPERA(  92),IX(  92),IY(  92)/'MOVE',   5,  12/
      DATA IOPERA(  93),IX(  93),IY(  93)/'DRAW',   7,  11/
      DATA IOPERA(  94),IX(  94),IY(  94)/'MOVE',   8,  12/
      DATA IOPERA(  95),IX(  95),IY(  95)/'DRAW',   7,  11/
C
      DATA IXMIND(  22)/ -10/
      DATA IXMAXD(  22)/  10/
      DATA IXDELD(  22)/  20/
      DATA ISTARD(  22)/  73/
      DATA NUMCOO(  22)/  23/
C
C     DEFINE CHARACTER   3023--UPPER CASE W
C
      DATA IOPERA(  96),IX(  96),IY(  96)/'MOVE',  -8,  12/
      DATA IOPERA(  97),IX(  97),IY(  97)/'DRAW',  -4,  -9/
      DATA IOPERA(  98),IX(  98),IY(  98)/'MOVE',  -7,  12/
      DATA IOPERA(  99),IX(  99),IY(  99)/'DRAW',  -4,  -4/
      DATA IOPERA( 100),IX( 100),IY( 100)/'DRAW',  -4,  -9/
      DATA IOPERA( 101),IX( 101),IY( 101)/'MOVE',  -6,  12/
      DATA IOPERA( 102),IX( 102),IY( 102)/'DRAW',  -3,  -4/
      DATA IOPERA( 103),IX( 103),IY( 103)/'MOVE',   0,  12/
      DATA IOPERA( 104),IX( 104),IY( 104)/'DRAW',  -3,  -4/
      DATA IOPERA( 105),IX( 105),IY( 105)/'DRAW',  -4,  -9/
      DATA IOPERA( 106),IX( 106),IY( 106)/'MOVE',   0,  12/
      DATA IOPERA( 107),IX( 107),IY( 107)/'DRAW',   4,  -9/
      DATA IOPERA( 108),IX( 108),IY( 108)/'MOVE',   1,  12/
      DATA IOPERA( 109),IX( 109),IY( 109)/'DRAW',   4,  -4/
      DATA IOPERA( 110),IX( 110),IY( 110)/'DRAW',   4,  -9/
      DATA IOPERA( 111),IX( 111),IY( 111)/'MOVE',   2,  12/
      DATA IOPERA( 112),IX( 112),IY( 112)/'DRAW',   5,  -4/
      DATA IOPERA( 113),IX( 113),IY( 113)/'MOVE',   8,  11/
      DATA IOPERA( 114),IX( 114),IY( 114)/'DRAW',   5,  -4/
      DATA IOPERA( 115),IX( 115),IY( 115)/'DRAW',   4,  -9/
      DATA IOPERA( 116),IX( 116),IY( 116)/'MOVE', -11,  12/
      DATA IOPERA( 117),IX( 117),IY( 117)/'DRAW',  -3,  12/
      DATA IOPERA( 118),IX( 118),IY( 118)/'MOVE',   0,  12/
      DATA IOPERA( 119),IX( 119),IY( 119)/'DRAW',   2,  12/
      DATA IOPERA( 120),IX( 120),IY( 120)/'MOVE',   5,  12/
      DATA IOPERA( 121),IX( 121),IY( 121)/'DRAW',  11,  12/
      DATA IOPERA( 122),IX( 122),IY( 122)/'MOVE', -10,  12/
      DATA IOPERA( 123),IX( 123),IY( 123)/'DRAW',  -7,  11/
      DATA IOPERA( 124),IX( 124),IY( 124)/'MOVE',  -9,  12/
      DATA IOPERA( 125),IX( 125),IY( 125)/'DRAW',  -7,  10/
      DATA IOPERA( 126),IX( 126),IY( 126)/'MOVE',  -5,  12/
      DATA IOPERA( 127),IX( 127),IY( 127)/'DRAW',  -6,  10/
      DATA IOPERA( 128),IX( 128),IY( 128)/'MOVE',  -4,  12/
      DATA IOPERA( 129),IX( 129),IY( 129)/'DRAW',  -6,  11/
      DATA IOPERA( 130),IX( 130),IY( 130)/'MOVE',   6,  12/
      DATA IOPERA( 131),IX( 131),IY( 131)/'DRAW',   8,  11/
      DATA IOPERA( 132),IX( 132),IY( 132)/'MOVE',  10,  12/
      DATA IOPERA( 133),IX( 133),IY( 133)/'DRAW',   8,  11/
C
      DATA IXMIND(  23)/ -12/
      DATA IXMAXD(  23)/  12/
      DATA IXDELD(  23)/  24/
      DATA ISTARD(  23)/  96/
      DATA NUMCOO(  23)/  38/
C
C     DEFINE CHARACTER   3024--UPPER CASE X
C
      DATA IOPERA( 134),IX( 134),IY( 134)/'MOVE',  -7,  12/
      DATA IOPERA( 135),IX( 135),IY( 135)/'DRAW',   5,  -9/
      DATA IOPERA( 136),IX( 136),IY( 136)/'MOVE',  -6,  12/
      DATA IOPERA( 137),IX( 137),IY( 137)/'DRAW',   6,  -9/
      DATA IOPERA( 138),IX( 138),IY( 138)/'MOVE',  -5,  12/
      DATA IOPERA( 139),IX( 139),IY( 139)/'DRAW',   7,  -9/
      DATA IOPERA( 140),IX( 140),IY( 140)/'MOVE',   6,  11/
      DATA IOPERA( 141),IX( 141),IY( 141)/'DRAW',  -6,  -8/
      DATA IOPERA( 142),IX( 142),IY( 142)/'MOVE',  -9,  12/
      DATA IOPERA( 143),IX( 143),IY( 143)/'DRAW',  -2,  12/
      DATA IOPERA( 144),IX( 144),IY( 144)/'MOVE',   3,  12/
      DATA IOPERA( 145),IX( 145),IY( 145)/'DRAW',   9,  12/
      DATA IOPERA( 146),IX( 146),IY( 146)/'MOVE',  -9,  -9/
      DATA IOPERA( 147),IX( 147),IY( 147)/'DRAW',  -3,  -9/
      DATA IOPERA( 148),IX( 148),IY( 148)/'MOVE',   2,  -9/
      DATA IOPERA( 149),IX( 149),IY( 149)/'DRAW',   9,  -9/
      DATA IOPERA( 150),IX( 150),IY( 150)/'MOVE',  -8,  12/
      DATA IOPERA( 151),IX( 151),IY( 151)/'DRAW',  -5,  10/
      DATA IOPERA( 152),IX( 152),IY( 152)/'MOVE',  -4,  12/
      DATA IOPERA( 153),IX( 153),IY( 153)/'DRAW',  -5,  10/
      DATA IOPERA( 154),IX( 154),IY( 154)/'MOVE',  -3,  12/
      DATA IOPERA( 155),IX( 155),IY( 155)/'DRAW',  -5,  11/
      DATA IOPERA( 156),IX( 156),IY( 156)/'MOVE',   4,  12/
      DATA IOPERA( 157),IX( 157),IY( 157)/'DRAW',   6,  11/
      DATA IOPERA( 158),IX( 158),IY( 158)/'MOVE',   8,  12/
      DATA IOPERA( 159),IX( 159),IY( 159)/'DRAW',   6,  11/
      DATA IOPERA( 160),IX( 160),IY( 160)/'MOVE',  -6,  -8/
      DATA IOPERA( 161),IX( 161),IY( 161)/'DRAW',  -8,  -9/
      DATA IOPERA( 162),IX( 162),IY( 162)/'MOVE',  -6,  -8/
      DATA IOPERA( 163),IX( 163),IY( 163)/'DRAW',  -4,  -9/
      DATA IOPERA( 164),IX( 164),IY( 164)/'MOVE',   5,  -8/
      DATA IOPERA( 165),IX( 165),IY( 165)/'DRAW',   3,  -9/
      DATA IOPERA( 166),IX( 166),IY( 166)/'MOVE',   5,  -7/
      DATA IOPERA( 167),IX( 167),IY( 167)/'DRAW',   4,  -9/
      DATA IOPERA( 168),IX( 168),IY( 168)/'MOVE',   5,  -7/
      DATA IOPERA( 169),IX( 169),IY( 169)/'DRAW',   8,  -9/
C
      DATA IXMIND(  24)/ -10/
      DATA IXMAXD(  24)/  10/
      DATA IXDELD(  24)/  20/
      DATA ISTARD(  24)/ 134/
      DATA NUMCOO(  24)/  36/
C
C     DEFINE CHARACTER   3025--UPPER CASE Y
C
      DATA IOPERA( 170),IX( 170),IY( 170)/'MOVE',  -8,  12/
      DATA IOPERA( 171),IX( 171),IY( 171)/'DRAW',  -1,   1/
      DATA IOPERA( 172),IX( 172),IY( 172)/'DRAW',  -1,  -9/
      DATA IOPERA( 173),IX( 173),IY( 173)/'MOVE',  -7,  12/
      DATA IOPERA( 174),IX( 174),IY( 174)/'DRAW',   0,   1/
      DATA IOPERA( 175),IX( 175),IY( 175)/'DRAW',   0,  -8/
      DATA IOPERA( 176),IX( 176),IY( 176)/'MOVE',  -6,  12/
      DATA IOPERA( 177),IX( 177),IY( 177)/'DRAW',   1,   1/
      DATA IOPERA( 178),IX( 178),IY( 178)/'DRAW',   1,  -9/
      DATA IOPERA( 179),IX( 179),IY( 179)/'MOVE',   7,  11/
      DATA IOPERA( 180),IX( 180),IY( 180)/'DRAW',   1,   1/
      DATA IOPERA( 181),IX( 181),IY( 181)/'MOVE', -10,  12/
      DATA IOPERA( 182),IX( 182),IY( 182)/'DRAW',  -3,  12/
      DATA IOPERA( 183),IX( 183),IY( 183)/'MOVE',   4,  12/
      DATA IOPERA( 184),IX( 184),IY( 184)/'DRAW',  10,  12/
      DATA IOPERA( 185),IX( 185),IY( 185)/'MOVE',  -4,  -9/
      DATA IOPERA( 186),IX( 186),IY( 186)/'DRAW',   4,  -9/
      DATA IOPERA( 187),IX( 187),IY( 187)/'MOVE',  -9,  12/
      DATA IOPERA( 188),IX( 188),IY( 188)/'DRAW',  -7,  11/
      DATA IOPERA( 189),IX( 189),IY( 189)/'MOVE',  -4,  12/
      DATA IOPERA( 190),IX( 190),IY( 190)/'DRAW',  -6,  11/
      DATA IOPERA( 191),IX( 191),IY( 191)/'MOVE',   5,  12/
      DATA IOPERA( 192),IX( 192),IY( 192)/'DRAW',   7,  11/
      DATA IOPERA( 193),IX( 193),IY( 193)/'MOVE',   9,  12/
      DATA IOPERA( 194),IX( 194),IY( 194)/'DRAW',   7,  11/
      DATA IOPERA( 195),IX( 195),IY( 195)/'MOVE',  -1,  -8/
      DATA IOPERA( 196),IX( 196),IY( 196)/'DRAW',  -3,  -9/
      DATA IOPERA( 197),IX( 197),IY( 197)/'MOVE',  -1,  -7/
      DATA IOPERA( 198),IX( 198),IY( 198)/'DRAW',  -2,  -9/
      DATA IOPERA( 199),IX( 199),IY( 199)/'MOVE',   1,  -7/
      DATA IOPERA( 200),IX( 200),IY( 200)/'DRAW',   2,  -9/
      DATA IOPERA( 201),IX( 201),IY( 201)/'MOVE',   1,  -8/
      DATA IOPERA( 202),IX( 202),IY( 202)/'DRAW',   3,  -9/
C
      DATA IXMIND(  25)/ -11/
      DATA IXMAXD(  25)/  11/
      DATA IXDELD(  25)/  22/
      DATA ISTARD(  25)/ 170/
      DATA NUMCOO(  25)/  33/
C
C     DEFINE CHARACTER   3026--UPPER CASE Z
C
      DATA IOPERA( 203),IX( 203),IY( 203)/'MOVE',   7,  12/
      DATA IOPERA( 204),IX( 204),IY( 204)/'DRAW',  -7,  12/
      DATA IOPERA( 205),IX( 205),IY( 205)/'DRAW',  -7,   6/
      DATA IOPERA( 206),IX( 206),IY( 206)/'MOVE',   5,  12/
      DATA IOPERA( 207),IX( 207),IY( 207)/'DRAW',  -7,  -9/
      DATA IOPERA( 208),IX( 208),IY( 208)/'MOVE',   6,  12/
      DATA IOPERA( 209),IX( 209),IY( 209)/'DRAW',  -6,  -9/
      DATA IOPERA( 210),IX( 210),IY( 210)/'MOVE',   7,  12/
      DATA IOPERA( 211),IX( 211),IY( 211)/'DRAW',  -5,  -9/
      DATA IOPERA( 212),IX( 212),IY( 212)/'MOVE',  -7,  -9/
      DATA IOPERA( 213),IX( 213),IY( 213)/'DRAW',   7,  -9/
      DATA IOPERA( 214),IX( 214),IY( 214)/'DRAW',   7,  -3/
      DATA IOPERA( 215),IX( 215),IY( 215)/'MOVE',  -6,  12/
      DATA IOPERA( 216),IX( 216),IY( 216)/'DRAW',  -7,   6/
      DATA IOPERA( 217),IX( 217),IY( 217)/'MOVE',  -5,  12/
      DATA IOPERA( 218),IX( 218),IY( 218)/'DRAW',  -7,   9/
      DATA IOPERA( 219),IX( 219),IY( 219)/'MOVE',  -4,  12/
      DATA IOPERA( 220),IX( 220),IY( 220)/'DRAW',  -7,  10/
      DATA IOPERA( 221),IX( 221),IY( 221)/'MOVE',  -2,  12/
      DATA IOPERA( 222),IX( 222),IY( 222)/'DRAW',  -7,  11/
      DATA IOPERA( 223),IX( 223),IY( 223)/'MOVE',   2,  -9/
      DATA IOPERA( 224),IX( 224),IY( 224)/'DRAW',   7,  -8/
      DATA IOPERA( 225),IX( 225),IY( 225)/'MOVE',   4,  -9/
      DATA IOPERA( 226),IX( 226),IY( 226)/'DRAW',   7,  -7/
      DATA IOPERA( 227),IX( 227),IY( 227)/'MOVE',   5,  -9/
      DATA IOPERA( 228),IX( 228),IY( 228)/'DRAW',   7,  -6/
      DATA IOPERA( 229),IX( 229),IY( 229)/'MOVE',   6,  -9/
      DATA IOPERA( 230),IX( 230),IY( 230)/'DRAW',   7,  -3/
C
      DATA IXMIND(  26)/ -10/
      DATA IXMAXD(  26)/  10/
      DATA IXDELD(  26)/  20/
      DATA ISTARD(  26)/ 203/
      DATA NUMCOO(  26)/  28/
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='YES'
      IERROR='NO'
C
      NUMCO=1
      ISTART=1
      ISTOP=1
      NC=1
C
C               ******************************************
C               **  TREAT THE ROMAN SIMPLEX UPPER CASE  **
C               **  HERSHEY CHARACTER SET CASE          **
C               ******************************************
C
C
      IF(IBUGD2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DRTU4--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)ICHARN
   52 FORMAT('ICHARN = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)IBUGD2,IFOUND,IERROR
   59 FORMAT('IBUGD2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************
C               **  STEP 2--                        **
C               **  EXTRACT THE COORDINATES         **
C               **  FOR THIS PARTICULAR CHARACTER.  **
C               **************************************
C
 1000 CONTINUE
      ISTART=ISTARD(ICHARN)
      NC=NUMCOO(ICHARN)
      ISTOP=ISTART+NC-1
      J=0
      DO1100I=ISTART,ISTOP
      J=J+1
      IOP(J)=IOPERA(I)
      X(J)=IX(I)
      Y(J)=IY(I)
 1100 CONTINUE
      NUMCO=J
      IXMINS=IXMIND(ICHARN)
      IXMAXS=IXMAXD(ICHARN)
      IXDELS=IXDELD(ICHARN)
C
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGD2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DRTU4--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGD2,IFOUND,IERROR
 9012 FORMAT('IBUGD2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICHARN
 9013 FORMAT('ICHARN = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)ISTART,ISTOP,NC,NUMCO
 9014 FORMAT('ISTART,ISTOP,NC,NUMCO = ',4I8)
      CALL DPWRST('XXX','BUG ')
      IF(NUMCO.GE.1.AND.NUMCO.LE.1000)GOTO9019
      DO9015I=1,NUMCO
      WRITE(ICOUT,9016)I,IOP(I),X(I),Y(I)
 9016 FORMAT('I,IOP(I),X(I),Y(I) = ',I8,2X,A4,2F10.2)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
 9019 CONTINUE
      WRITE(ICOUT,9021)IXMINS,IXMAXS,IXDELS
 9021 FORMAT('IXMINS,IXMAXS,IXDELS = ',3I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DRWFIL(XC,YC,NMX,NSEG,NPTS,SNSE,CLSD,NSGX,X,Y,IMX,
     1  JMX,IB,JB,NBX,PRMTR,NS,D,CN,WLN,IDSH,KOLR,LBL,LDEC,SZL,DLMM,
     1XTEMP,YTEMP,TATEMP,NTEMP,NTRACE,
     1IBUGG3,ISUBRO,IERROR)
C
C     PURPOSE--XX
C
C     WRITTEN BY--DAVID W. BEHRINGER NOAA/AOML (MIAMI).
C                 AS PART OF NOAA'S CONCX V.3   MARCH 1988.
C     ORIGINAL VERSION (IN DATAPLOT)--AUGUST    1988.
C
C     UPDATED         --JANUARY   1989.  MORE CHANGES TO STANDARD FORTRAN 77--
C                                        REPLACED ENCODE WITH
C                                        INTERNAL WRITE (ALAN HECKERT).
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOCP.INC'
C
C---------------------------------------------------------------------
C
      CHARACTER CHR(15)*1
      CHARACTER*15 CHRTMP
C
CCCCC INTEGER NPTS(NSGX,3),SNSE(NSGX,3),CLSD(NSGX,3),NSEG(3),NSGE(3),
CCCCC1 NSGCL(3),NSGCH(3),NTPE(3),NTPCL(3),NTPCH(3)
CCCCC DIMENSION XC(NMX,3),YC(NMX,3),D(2,NSGX,3),IB(NBX),JB(NBX),
CCCCC1 X(IMX),Y(JMX),NS(2,NSGX,3)
C
      CHARACTER*4 IBUGG3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      INTEGER NPTS
      INTEGER SNSE
      INTEGER CLSD
      INTEGER NSEG
      INTEGER NSGE
      INTEGER NSGCL
      INTEGER NSGCH
      INTEGER NTPE
      INTEGER NTPCL
      INTEGER NTPCH
C
      DIMENSION NPTS(MAXNSG,3)
      DIMENSION SNSE(MAXNSG,3)
      DIMENSION CLSD(MAXNSG,3)
      DIMENSION NSEG(3)
      DIMENSION NSGE(3)
      DIMENSION NSGCL(3)
      DIMENSION NSGCH(3)
      DIMENSION NTPE(3)
      DIMENSION NTPCL(3)
      DIMENSION NTPCH(3)
C
      DIMENSION XC(MAXNMX,3)
      DIMENSION YC(MAXNMX,3)
      DIMENSION D(2,MAXNSG,3)
      DIMENSION IB(*)
      DIMENSION JB(*)
      DIMENSION X(*)
      DIMENSION Y(*)
      DIMENSION NS(2,MAXNSG,3)
C
      DIMENSION XTEMP(*)
      DIMENSION YTEMP(*)
      DIMENSION TATEMP(*)
C
      DATA FRM/0.0/
C
C-----START POINT-----------------------------------------------------
C
C   SORT THE CONTOUR SEGMENTS AND CREATE POLYGONS FOR COLOR FILL
C
      CALL PLYSRT(XC,YC,NMX,NSEG,NSGE,NSGCL,NSGCH,NPTS,NTPE,NTPCL,
     1   NTPCH,SNSE,CLSD,NSGX,X,Y,IMX,JMX,IB,JB,NBX,PRMTR,NS,D)
C
C   FILL THE POLYGONS WITH COLOR
C
      IF (KOLR.GE.0) THEN
        L1=1
        DO 10 N=1,NSEG(3)
          NP=NPTS(N,3)
          CALL RSURF(XC(L1,3),YC(L1,3),NP,KOLR,FRM,
     1XTEMP,YTEMP,TATEMP,NTEMP,NTRACE,
     1IBUGG3,ISUBRO,IERROR)
          L1=L1+NP
 10     CONTINUE
      END IF
C
C   DRAW THE CONTOURS (USE *(*,3) ARRAYS TO PREVENT DATA LOSS DUE TO GVECT)
C
      IF (CN.NE.999.999) THEN
CCCCC   CALL GWICOL(WLN,1)    AUGUST 1988
        IF (LBL.GT.0) THEN
          IPOW=MAX0(LDEC+1,1)
CCCCC THE FOLLOWING 2 LINES WERE CORRECTED JANUARY 1989
CCCCC     ENCODE(15,999,CHR) CN+SIGN(10.**-IPOW,CN)
C999      FORMAT(F15.5)
          WRITE(CHRTMP,'(F15.5)') CN+SIGN(10.**(-IPOW),CN)
          DO 15 III=1,15
            CHR(III)=CHRTMP(III:III)
 15       CONTINUE
C  END CHANGE
          I=MAX0(0,INT(LOG10(ABS(CN+SIGN(0.001,CN)))))+1
          IF (CN.LT.0.) I=I+1
          IS=MAX0(1,10-I)
          IE=10+LDEC
          DO 20 I=IS,IE
            NCHR=I-IS+1
            CHR(NCHR)=CHR(I)
 20       CONTINUE
        END IF
        L2=0
        DO 30 NSG=1,NSEG(1)
          L1=L2+1
          NP=IABS(NPTS(NSG,1))
          L2=L2+NP
          DO 40 L=L1,L2
            LL=L-L1+1
            LLL=L2-L+L1
            XC(LL,3)=XC(LLL,1)
            YC(LL,3)=YC(LLL,1)
 40       CONTINUE
          IF (LBL.LE.0) THEN
            CALL DRAW0(XC(1,3),YC(1,3),NP,IDSH,
     1XTEMP,YTEMP,TATEMP,NTEMP,NTRACE,
     1IBUGG3,ISUBRO,IERROR)
          ELSE
            CALL DRAWL(XC(1,3),YC(1,3),D(1,1,3),NP,IDSH,CHR,
     1                          NCHR,SZL,DLMM,
     1XTEMP,YTEMP,TATEMP,NTEMP,NTRACE,
     1IBUGG3,ISUBRO,IERROR)
          END IF
 30     CONTINUE
      END IF
C
C   CONVERT *(*,2) ARRAYS TO *(*,1) ARRAYS
C
      N=0
      LE=0
      DO 50 K=1,3
        IF (K.EQ.1) THEN
          NSG=NSGE(2)
          NSGE(1)=NSG
          NTPE(1)=NTPE(2)
          NN=0
          LOFF=0
        ELSE IF (K.EQ.2) THEN
          NSG=NSGCH(2)
          NSGCL(1)=NSG
          NTPCL(1)=NTPCH(2)
          NN=NSGE(2)+NSGCL(2)
          LOFF=NTPCL(2)
        ELSE
          NSG=NSGCL(2)
          NSGCH(1)=NSG
          NTPCH(1)=NTPCL(2)
          NN=NSGE(2)
          LOFF=-NTPCH(2)
        END IF
        DO 60 N0=1,NSG
          N=N+1
          NN=NN+1
          NPTS(N,1)=IABS(NPTS(NN,2))
          SNSE(N,1)=1
          CLSD(N,1)=-CLSD(NN,2)
          LS=LE+1
          LE=LE+NPTS(N,1)
          DO 70 L=LS,LE
            LL=LE-L+LS+LOFF
            XC(L,1)=XC(LL,2)
            YC(L,1)=YC(LL,2)
 70       CONTINUE
          IF (K.EQ.1) THEN
            DO 80 I=1,2
              II=MOD(I,2)+1
              NS(I,N,1)=NS(II,NN,2)
              D(I,N,1)=D(II,NN,2)
 80         CONTINUE
          ELSE
            D(1,N,1)=D(1,NN,2)
          END IF
 60     CONTINUE
 50   CONTINUE
      NSEG(1)=NSEG(2)
      RETURN
      END
      SUBROUTINE DSCAL(N,DA,DX,INCX)
C
C     SCALES A VECTOR BY A CONSTANT.
C     USES UNROLLED LOOPS FOR INCREMENT EQUAL TO ONE.
C     JACK DONGARRA, LINPACK, 3/11/78.
C     MODIFIED 3/93 TO RETURN IF INCX .LE. 0.
C
      DOUBLE PRECISION DA,DX(1)
      INTEGER I,INCX,M,MP1,N,NINCX
C
      IF( N.LE.0 .OR. INCX.LE.0 )RETURN
      IF(INCX.EQ.1)GO TO 20
C
C        CODE FOR INCREMENT NOT EQUAL TO 1
C
      NINCX = N*INCX
      DO 10 I = 1,NINCX,INCX
        DX(I) = DA*DX(I)
   10 CONTINUE
      RETURN
C
C        CODE FOR INCREMENT EQUAL TO 1
C
C
C        CLEAN-UP LOOP
C
   20 M = MOD(N,5)
      IF( M .EQ. 0 ) GO TO 40
      DO 30 I = 1,M
        DX(I) = DA*DX(I)
   30 CONTINUE
      IF( N .LT. 5 ) RETURN
   40 MP1 = M + 1
      DO 50 I = MP1,N,5
        DX(I) = DA*DX(I)
        DX(I + 1) = DA*DX(I + 1)
        DX(I + 2) = DA*DX(I + 2)
        DX(I + 3) = DA*DX(I + 3)
        DX(I + 4) = DA*DX(I + 4)
   50 CONTINUE
      RETURN
      END
      SUBROUTINE DSET (N, X, CONST)
C
C     MARK VANGEL, NIST, JANUARY 1994
C     SUBROUTINE DSET SETS THE N VALUES IN X TO THE CONSTANT CONST
C
C
      DOUBLE PRECISION X, CONST
      DIMENSION X(N)
      DO 10 I=1, N
         X(I) = CONST
 10   CONTINUE
      RETURN
      END
      SUBROUTINE DSORT (DX, DY, N, KFLAG, IERROR)
C***BEGIN PROLOGUE  DSORT
C***PURPOSE  Sort an array and optionally make the same interchanges in
C            an auxiliary array.  The array may be sorted in increasing
C            or decreasing order.  A slightly modified QUICKSORT
C            algorithm is used.
C***LIBRARY   SLATEC
C***CATEGORY  N6A2B
C***TYPE      DOUBLE PRECISION (SSORT-S, DSORT-D, ISORT-I)
C***KEYWORDS  SINGLETON QUICKSORT, SORT, SORTING
C***AUTHOR  Jones, R. E., (SNLA)
C           Wisniewski, J. A., (SNLA)
C***DESCRIPTION
C
C   DSORT sorts array DX and optionally makes the same interchanges in
C   array DY.  The array DX may be sorted in increasing order or
C   decreasing order.  A slightly modified quicksort algorithm is used.
C
C   Description of Parameters
C      DX - array of values to be sorted   (usually abscissas)
C      DY - array to be (optionally) carried along
C      N  - number of values in array DX to be sorted
C      KFLAG - control parameter
C            =  2  means sort DX in increasing order and carry DY along.
C            =  1  means sort DX in increasing order (ignoring DY)
C            = -1  means sort DX in decreasing order (ignoring DY)
C            = -2  means sort DX in decreasing order and carry DY along.
C
C***REFERENCES  R. C. Singleton, Algorithm 347, An efficient algorithm
C                 for sorting with minimal storage, Communications of
C                 the ACM, 12, 3 (1969), pp. 185-187.
C***ROUTINES CALLED  XERMSG
C***REVISION HISTORY  (YYMMDD)
C   761101  DATE WRITTEN
C   761118  Modified to use the Singleton quicksort algorithm.  (JAW)
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890831  Modified array declarations.  (WRB)
C   891009  Removed unreferenced statement labels.  (WRB)
C   891024  Changed category.  (WRB)
C   891024  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   901012  Declared all variables; changed X,Y to DX,DY; changed
C           code to parallel SSORT. (M. McClain)
C   920501  Reformatted the REFERENCES section.  (DWL, WRB)
C   920519  Clarified error messages.  (DWL)
C   920801  Declarations section rebuilt and code restructured to use
C           IF-THEN-ELSE-ENDIF.  (RWC, WRB)
C   970821  Minor modifications to error handling and printing to
C           incorporate into Dataplot
C***END PROLOGUE  DSORT
C     .. Scalar Arguments ..
C
      CHARACTER*4 IERROR
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      INTEGER KFLAG, N
C     .. Array Arguments ..
      DOUBLE PRECISION DX(*), DY(*)
C     .. Local Scalars ..
      DOUBLE PRECISION R, T, TT, TTY, TY
      INTEGER I, IJ, J, K, KK, L, M, NN
C     .. Local Arrays ..
      INTEGER IL(21), IU(21)
C     .. External Subroutines ..
CCCCC EXTERNAL XERMSG
C     .. Intrinsic Functions ..
      INTRINSIC ABS, INT
C***FIRST EXECUTABLE STATEMENT  DSORT
      IERROR='NO'
      NN = N
      IF (NN .LT. 1) THEN
CCCCC    CALL XERMSG ('SLATEC', 'DSORT',
CCCCC+      'The number of values to be sorted is not positive.', 1, 1)
         WRITE(ICOUT,1001)
         CALL DPWRST('XXX','BUG')
         WRITE(ICOUT,1002)
         CALL DPWRST('XXX','BUG')
         IERROR='YES'
         RETURN
      ENDIF
 1001 FORMAT('***** RECIPE ERROR: INTERNAL ERROR FROM DSORT')
 1002 FORMAT('      THE NUMBER OF VALUES TO BE SORTED IS NOT POSITIVE.')
C
      KK = ABS(KFLAG)
      IF (KK.NE.1 .AND. KK.NE.2) THEN
CCCCC    CALL XERMSG ('SLATEC', 'DSORT',
CCCCC+      'The sort control parameter, K, is not 2, 1, -1, or -2.', 2,
CCCCC+      1)
         WRITE(ICOUT,1003)
         CALL DPWRST('XXX','BUG')
         WRITE(ICOUT,1004)
         CALL DPWRST('XXX','BUG')
         IERROR='YES'
         RETURN
      ENDIF
 1003 FORMAT('***** RECIPE ERROR: INTERNAL ERROR FROM DSORT')
 1004 FORMAT('      THE SORT CONTROL PARAMETER, K, IS NOT 2, 1, ',
     1'-1, OR -2.')
C
C     Alter array DX to get decreasing order if needed
C
      IF (KFLAG .LE. -1) THEN
         DO 10 I=1,NN
            DX(I) = -DX(I)
   10    CONTINUE
      ENDIF
C
      IF (KK .EQ. 2) GO TO 100
C
C     Sort DX only
C
      M = 1
      I = 1
      J = NN
      R = 0.375D0
C
   20 IF (I .EQ. J) GO TO 60
      IF (R .LE. 0.5898437D0) THEN
         R = R+3.90625D-2
      ELSE
         R = R-0.21875D0
      ENDIF
C
   30 K = I
C
C     Select a central element of the array and save it in location T
C
      IJ = I + INT((J-I)*R)
      T = DX(IJ)
C
C     If first element of array is greater than T, interchange with T
C
      IF (DX(I) .GT. T) THEN
         DX(IJ) = DX(I)
         DX(I) = T
         T = DX(IJ)
      ENDIF
      L = J
C
C     If last element of array is less than than T, interchange with T
C
      IF (DX(J) .LT. T) THEN
         DX(IJ) = DX(J)
         DX(J) = T
         T = DX(IJ)
C
C        If first element of array is greater than T, interchange with T
C
         IF (DX(I) .GT. T) THEN
            DX(IJ) = DX(I)
            DX(I) = T
            T = DX(IJ)
         ENDIF
      ENDIF
C
C     Find an element in the second half of the array which is smaller
C     than T
C
   40 L = L-1
      IF (DX(L) .GT. T) GO TO 40
C
C     Find an element in the first half of the array which is greater
C     than T
C
   50 K = K+1
      IF (DX(K) .LT. T) GO TO 50
C
C     Interchange these elements
C
      IF (K .LE. L) THEN
         TT = DX(L)
         DX(L) = DX(K)
         DX(K) = TT
         GO TO 40
      ENDIF
C
C     Save upper and lower subscripts of the array yet to be sorted
C
      IF (L-I .GT. J-K) THEN
         IL(M) = I
         IU(M) = L
         I = K
         M = M+1
      ELSE
         IL(M) = K
         IU(M) = J
         J = L
         M = M+1
      ENDIF
      GO TO 70
C
C     Begin again on another portion of the unsorted array
C
   60 M = M-1
      IF (M .EQ. 0) GO TO 190
      I = IL(M)
      J = IU(M)
C
   70 IF (J-I .GE. 1) GO TO 30
      IF (I .EQ. 1) GO TO 20
      I = I-1
C
   80 I = I+1
      IF (I .EQ. J) GO TO 60
      T = DX(I+1)
      IF (DX(I) .LE. T) GO TO 80
      K = I
C
   90 DX(K+1) = DX(K)
      K = K-1
      IF (T .LT. DX(K)) GO TO 90
      DX(K+1) = T
      GO TO 80
C
C     Sort DX and carry DY along
C
  100 M = 1
      I = 1
      J = NN
      R = 0.375D0
C
  110 IF (I .EQ. J) GO TO 150
      IF (R .LE. 0.5898437D0) THEN
         R = R+3.90625D-2
      ELSE
         R = R-0.21875D0
      ENDIF
C
  120 K = I
C
C     Select a central element of the array and save it in location T
C
      IJ = I + INT((J-I)*R)
      T = DX(IJ)
      TY = DY(IJ)
C
C     If first element of array is greater than T, interchange with T
C
      IF (DX(I) .GT. T) THEN
         DX(IJ) = DX(I)
         DX(I) = T
         T = DX(IJ)
         DY(IJ) = DY(I)
         DY(I) = TY
         TY = DY(IJ)
      ENDIF
      L = J
C
C     If last element of array is less than T, interchange with T
C
      IF (DX(J) .LT. T) THEN
         DX(IJ) = DX(J)
         DX(J) = T
         T = DX(IJ)
         DY(IJ) = DY(J)
         DY(J) = TY
         TY = DY(IJ)
C
C        If first element of array is greater than T, interchange with T
C
         IF (DX(I) .GT. T) THEN
            DX(IJ) = DX(I)
            DX(I) = T
            T = DX(IJ)
            DY(IJ) = DY(I)
            DY(I) = TY
            TY = DY(IJ)
         ENDIF
      ENDIF
C
C     Find an element in the second half of the array which is smaller
C     than T
C
  130 L = L-1
      IF (DX(L) .GT. T) GO TO 130
C
C     Find an element in the first half of the array which is greater
C     than T
C
  140 K = K+1
      IF (DX(K) .LT. T) GO TO 140
C
C     Interchange these elements
C
      IF (K .LE. L) THEN
         TT = DX(L)
         DX(L) = DX(K)
         DX(K) = TT
         TTY = DY(L)
         DY(L) = DY(K)
         DY(K) = TTY
         GO TO 130
      ENDIF
C
C     Save upper and lower subscripts of the array yet to be sorted
C
      IF (L-I .GT. J-K) THEN
         IL(M) = I
         IU(M) = L
         I = K
         M = M+1
      ELSE
         IL(M) = K
         IU(M) = J
         J = L
         M = M+1
      ENDIF
      GO TO 160
C
C     Begin again on another portion of the unsorted array
C
  150 M = M-1
      IF (M .EQ. 0) GO TO 190
      I = IL(M)
      J = IU(M)
C
  160 IF (J-I .GE. 1) GO TO 120
      IF (I .EQ. 1) GO TO 110
      I = I-1
C
  170 I = I+1
      IF (I .EQ. J) GO TO 150
      T = DX(I+1)
      TY = DY(I+1)
      IF (DX(I) .LE. T) GO TO 170
      K = I
C
  180 DX(K+1) = DX(K)
      DY(K+1) = DY(K)
      K = K-1
      IF (T .LT. DX(K)) GO TO 180
      DX(K+1) = T
      DY(K+1) = TY
      GO TO 170
C
C     Clean up
C
  190 IF (KFLAG .LE. -1) THEN
         DO 200 I=1,NN
            DX(I) = -DX(I)
  200    CONTINUE
      ENDIF
      RETURN
      END
      DOUBLE PRECISION FUNCTION DSPENC (X)
C***BEGIN PROLOGUE  DSPENC
C***PURPOSE  Compute a form of Spence's integral due to K. Mitchell.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C5
C***TYPE      DOUBLE PRECISION (SPENC-S, DSPENC-D)
C***KEYWORDS  FNLIB, SPECIAL FUNCTIONS, SPENCE'S INTEGRAL
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C DSPENC(X) calculates the double precision Spence's integral
C for double precision argument X.  Spence's function defined by
C        integral from 0 to X of  -LOG(1-Y)/Y  DY.
C For ABS(X) .LE. 1, the uniformly convergent expansion
C        DSPENC = sum K=1,infinity  X**K / K**2     is valid.
C This is a form of Spence's integral due to K. Mitchell which differs
C from the definition in the NBS Handbook of Mathematical Functions.
C
C Spence's function can be used to evaluate much more general integral
C forms.  For example,
C        integral from 0 to Z of  LOG(A*X+B)/(C*X+D)  DX  =
C             LOG(ABS(B-A*D/C))*LOG(ABS(A*(C*X+D)/(A*D-B*C)))/C
C             - DSPENC (A*(C*Z+D)/(A*D-B*C)) / C.
C
C Ref -- K. Mitchell, Philosophical Magazine, 40, p.351 (1949).
C        Stegun and Abromowitz, AMS 55, p.1004.
C
C
C Series for SPEN       on the interval  0.          to  5.00000E-01
C                                        with weighted error   4.74E-32
C                                         log weighted error  31.32
C                               significant figures required  30.37
C                                    decimal places required  32.11
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, DCSEVL, INITDS
C***REVISION HISTORY  (YYMMDD)
C   780201  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   891115  Corrected third argument in reference to INITDS.  (WRB)
C   891115  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  DSPENC
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOMC.INC'
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DOUBLE PRECISION X, SPENCS(38), ALN, PI26, XBIG, DCSEVL
      LOGICAL FIRST
      SAVE SPENCS, PI26, NSPENC, XBIG, FIRST
      DATA SPENCS(  1) / +.1527365598 8924058729 4668491002 8 D+0      /
      DATA SPENCS(  2) / +.8169658058 0510144035 0183818527 1 D-1      /
      DATA SPENCS(  3) / +.5814157140 7787308729 7735064118 2 D-2      /
      DATA SPENCS(  4) / +.5371619814 5415275422 4788900531 9 D-3      /
      DATA SPENCS(  5) / +.5724704675 1858262332 1060305478 2 D-4      /
      DATA SPENCS(  6) / +.6674546121 6493363436 0783543858 9 D-5      /
      DATA SPENCS(  7) / +.8276467339 7156769815 8439168901 1 D-6      /
      DATA SPENCS(  8) / +.1073315673 0306789512 7000587335 4 D-6      /
      DATA SPENCS(  9) / +.1440077294 3032394023 3459033151 3 D-7      /
      DATA SPENCS( 10) / +.1984442029 9659063678 9887713960 8 D-8      /
      DATA SPENCS( 11) / +.2794005822 1636387202 0199482161 5 D-9      /
      DATA SPENCS( 12) / +.4003991310 8833118230 7258044590 8 D-10     /
      DATA SPENCS( 13) / +.5823462892 0446384713 6813583575 7 D-11     /
      DATA SPENCS( 14) / +.8576708692 6386892780 9791477122 4 D-12     /
      DATA SPENCS( 15) / +.1276862586 2801930459 8948303343 3 D-12     /
      DATA SPENCS( 16) / +.1918826209 0425170811 6238041606 2 D-13     /
      DATA SPENCS( 17) / +.2907319206 9771381777 9579971967 3 D-14     /
      DATA SPENCS( 18) / +.4437112685 2767804625 5747364174 5 D-15     /
      DATA SPENCS( 19) / +.6815727787 4145995278 6735913560 7 D-16     /
      DATA SPENCS( 20) / +.1053017386 0155744295 4701941664 4 D-16     /
      DATA SPENCS( 21) / +.1635389806 7523771000 5182173457 0 D-17     /
      DATA SPENCS( 22) / +.2551852874 9404639323 1090164258 1 D-18     /
      DATA SPENCS( 23) / +.3999020621 9993601127 7047037951 9 D-19     /
      DATA SPENCS( 24) / +.6291501645 2168118765 1414917119 9 D-20     /
      DATA SPENCS( 25) / +.9933827435 6756776438 0388775253 3 D-21     /
      DATA SPENCS( 26) / +.1573679570 7499648167 2176380586 6 D-21     /
      DATA SPENCS( 27) / +.2500595316 8494761293 6927095466 6 D-22     /
      DATA SPENCS( 28) / +.3984740918 3838111392 1066325333 3 D-23     /
      DATA SPENCS( 29) / +.6366473210 0828438926 9132629333 3 D-24     /
      DATA SPENCS( 30) / +.1019674287 2396783670 7706197333 3 D-24     /
      DATA SPENCS( 31) / +.1636881058 9135188411 1107413333 3 D-25     /
      DATA SPENCS( 32) / +.2633310439 4176501173 4527999999 9 D-26     /
      DATA SPENCS( 33) / +.4244811560 1239768172 2436266666 6 D-27     /
      DATA SPENCS( 34) / +.6855411983 6800529168 2474666666 6 D-28     /
      DATA SPENCS( 35) / +.1109122433 4380564340 1898666666 6 D-28     /
      DATA SPENCS( 36) / +.1797431304 9998914573 6533333333 3 D-29     /
      DATA SPENCS( 37) / +.2917505845 9760951732 9066666666 6 D-30     /
      DATA SPENCS( 38) / +.4742646808 9286710613 3333333333 3 D-31     /
      DATA PI26 / +1.644934066 8482264364 7241516664 6025189219 D0 /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  DSPENC
      IF (FIRST) THEN
         NSPENC = INITDS (SPENCS, 38, 0.1*REAL(D1MACH(3)))
         XBIG = 1.0D0/D1MACH(3)
      ENDIF
      FIRST = .FALSE.
C
      IF (X.GT.2.0D0) GO TO 60
      IF (X.GT.1.0D0) GO TO 50
      IF (X.GT.0.5D0) GO TO 40
      IF (X.GE.0.0D0) GO TO 30
      IF (X.GT.(-1.D0)) GO TO 20
C
C HERE IF X .LE. -1.0
C
      ALN = LOG(1.0D0-X)
      DSPENC = -PI26 - 0.5D0*ALN*(2.0D0*LOG(-X)-ALN)
      IF (X.GT.(-XBIG)) DSPENC = DSPENC
     1  + (1.D0 + DCSEVL (4.D0/(1.D0-X)-1.D0, SPENCS, NSPENC))/(1.D0-X)
      RETURN
C
C -1.0 .LT. X .LT. 0.0
C
 20   DSPENC = -0.5D0*LOG(1.0D0-X)**2
     1  - X*(1.D0+DCSEVL(4.D0*X/(X-1.D0)-1.D0, SPENCS, NSPENC))/(X-1.D0)
      RETURN
C
C 0.0 .LE. X .LE. 0.5
C
 30   DSPENC = X*(1.D0 + DCSEVL (4.D0*X-1.D0, SPENCS, NSPENC))
      RETURN
C
C 0.5 .LT. X .LE. 1.0
C
 40   DSPENC = PI26
      IF (X.NE.1.D0) DSPENC = PI26 - LOG(X)*LOG(1.0D0-X)
     1  - (1.D0-X)*(1.D0+DCSEVL(4.D0*(1.D0-X)-1.D0, SPENCS, NSPENC))
      RETURN
C
C 1.0 .LT. X .LE. 2.0
C
 50   DSPENC = PI26 - 0.5D0*LOG(X)*LOG((X-1.D0)**2/X)
     1  + (X-1.D0)*(1.D0+DCSEVL(4.D0*(X-1.D0)/X-1.D0, SPENCS, NSPENC))/X
      RETURN
C
C X .GT. 2.0
C
 60   DSPENC = 2.0D0*PI26 - 0.5D0*LOG(X)**2
      IF (X.LT.XBIG) DSPENC = DSPENC
     1  - (1.D0 + DCSEVL (4.D0/X-1.D0, SPENCS, NSPENC))/X
      RETURN
C
      END
      DOUBLE PRECISION FUNCTION DSUM (N, DX, INCX)
C
C     MARK VANGEL, NIST, JANUARY 1994
C     FUNCTION DSUM SUMS DX((I-1)*INCX+1), FOR I=1, ..., N.
C     COMPARE TO BLAS LEVEL 1 ROUTINE DASUM.
C
      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      DIMENSION DX(1)
      DSUM = 0.D0
      DO 10 I=1, N
         DSUM = DSUM +DX ((I-1)*INCX +1)
 10   CONTINUE
      RETURN
      END
      SUBROUTINE DSVDC(X,LDX,N,P,S,E,U,LDU,V,LDV,WORK,JOB,INFO)
      INTEGER LDX,N,P,LDU,LDV,JOB,INFO
      DOUBLE PRECISION X(LDX,1),S(1),E(1),U(LDU,1),V(LDV,1),WORK(1)
C
C
C     DSVDC IS A SUBROUTINE TO REDUCE A DOUBLE PRECISION NXP MATRIX X
C     BY ORTHOGONAL TRANSFORMATIONS U AND V TO DIAGONAL FORM.  THE
C     DIAGONAL ELEMENTS S(I) ARE THE SINGULAR VALUES OF X.  THE
C     COLUMNS OF U ARE THE CORRESPONDING LEFT SINGULAR VECTORS,
C     AND THE COLUMNS OF V THE RIGHT SINGULAR VECTORS.
C
C     ON ENTRY
C
C         X         DOUBLE PRECISION(LDX,P), WHERE LDX.GE.N.
C                   X CONTAINS THE MATRIX WHOSE SINGULAR VALUE
C                   DECOMPOSITION IS TO BE COMPUTED.  X IS
C                   DESTROYED BY DSVDC.
C
C         LDX       INTEGER.
C                   LDX IS THE LEADING DIMENSION OF THE ARRAY X.
C
C         N         INTEGER.
C                   N IS THE NUMBER OF ROWS OF THE MATRIX X.
C
C         P         INTEGER.
C                   P IS THE NUMBER OF COLUMNS OF THE MATRIX X.
C
C         LDU       INTEGER.
C                   LDU IS THE LEADING DIMENSION OF THE ARRAY U.
C                   (SEE BELOW).
C
C         LDV       INTEGER.
C                   LDV IS THE LEADING DIMENSION OF THE ARRAY V.
C                   (SEE BELOW).
C
C         WORK      DOUBLE PRECISION(N).
C                   WORK IS A SCRATCH ARRAY.
C
C         JOB       INTEGER.
C                   JOB CONTROLS THE COMPUTATION OF THE SINGULAR
C                   VECTORS.  IT HAS THE DECIMAL EXPANSION AB
C                   WITH THE FOLLOWING MEANING
C
C                        A.EQ.0    DO NOT COMPUTE THE LEFT SINGULAR
C                                  VECTORS.
C                        A.EQ.1    RETURN THE N LEFT SINGULAR VECTORS
C                                  IN U.
C                        A.GE.2    RETURN THE FIRST MIN(N,P) SINGULAR
C                                  VECTORS IN U.
C                        B.EQ.0    DO NOT COMPUTE THE RIGHT SINGULAR
C                                  VECTORS.
C                        B.EQ.1    RETURN THE RIGHT SINGULAR VECTORS
C                                  IN V.
C
C     ON RETURN
C
C         S         DOUBLE PRECISION(MM), WHERE MM=MIN(N+1,P).
C                   THE FIRST MIN(N,P) ENTRIES OF S CONTAIN THE
C                   SINGULAR VALUES OF X ARRANGED IN DESCENDING
C                   ORDER OF MAGNITUDE.
C
C         E         DOUBLE PRECISION(P),
C                   E ORDINARILY CONTAINS ZEROS.  HOWEVER SEE THE
C                   DISCUSSION OF INFO FOR EXCEPTIONS.
C
C         U         DOUBLE PRECISION(LDU,K), WHERE LDU.GE.N.  IF
C                                   JOBA.EQ.1 THEN K.EQ.N, IF JOBA.GE.2
C                                   THEN K.EQ.MIN(N,P).
C                   U CONTAINS THE MATRIX OF LEFT SINGULAR VECTORS.
C                   U IS NOT REFERENCED IF JOBA.EQ.0.  IF N.LE.P
C                   OR IF JOBA.EQ.2, THEN U MAY BE IDENTIFIED WITH X
C                   IN THE SUBROUTINE CALL.
C
C         V         DOUBLE PRECISION(LDV,P), WHERE LDV.GE.P.
C                   V CONTAINS THE MATRIX OF RIGHT SINGULAR VECTORS.
C                   V IS NOT REFERENCED IF JOB.EQ.0.  IF P.LE.N,
C                   THEN V MAY BE IDENTIFIED WITH X IN THE
C                   SUBROUTINE CALL.
C
C         INFO      INTEGER.
C                   THE SINGULAR VALUES (AND THEIR CORRESPONDING
C                   SINGULAR VECTORS) S(INFO+1),S(INFO+2),...,S(M)
C                   ARE CORRECT (HERE M=MIN(N,P)).  THUS IF
C                   INFO.EQ.0, ALL THE SINGULAR VALUES AND THEIR
C                   VECTORS ARE CORRECT.  IN ANY EVENT, THE MATRIX
C                   B = TRANS(U)*X*V IS THE BIDIAGONAL MATRIX
C                   WITH THE ELEMENTS OF S ON ITS DIAGONAL AND THE
C                   ELEMENTS OF E ON ITS SUPER-DIAGONAL (TRANS(U)
C                   IS THE TRANSPOSE OF U).  THUS THE SINGULAR
C                   VALUES OF X AND B ARE THE SAME.
C
C     LINPACK. THIS VERSION DATED 08/14/78 .
C              CORRECTION MADE TO SHIFT 2/84.
C     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.
C
C     DSVDC USES THE FOLLOWING FUNCTIONS AND SUBPROGRAMS.
C
C     EXTERNAL DROT
C     BLAS DAXPY,DDOT,DSCAL,DSWAP,DNRM2,DROTG
C     FORTRAN DABS,DMAX1,MAX0,MIN0,MOD,DSQRT
C
C     INTERNAL VARIABLES
C
      INTEGER I,ITER,J,JOBU,K,KASE,KK,L,LL,LLS,LM1,LP1,LS,LU,M,MAXIT,
     *        MM,MM1,MP1,NCT,NCTP1,NCU,NRT,NRTP1
      DOUBLE PRECISION DDOT,T
      DOUBLE PRECISION B,C,CS,EL,EMM1,F,G,DNRM2,SCALE,SHIFT,SL,SM,SN,
     *                 SMM1,T1,TEST,ZTEST
      LOGICAL WANTU,WANTV
C
C
C     SET THE MAXIMUM NUMBER OF ITERATIONS.
C
      MAXIT = 30
C
C     DETERMINE WHAT IS TO BE COMPUTED.
C
      WANTU = .FALSE.
      WANTV = .FALSE.
      JOBU = MOD(JOB,100)/10
      NCU = N
      IF (JOBU .GT. 1) NCU = MIN0(N,P)
      IF (JOBU .NE. 0) WANTU = .TRUE.
      IF (MOD(JOB,10) .NE. 0) WANTV = .TRUE.
C
C     REDUCE X TO BIDIAGONAL FORM, STORING THE DIAGONAL ELEMENTS
C     IN S AND THE SUPER-DIAGONAL ELEMENTS IN E.
C
      INFO = 0
      NCT = MIN0(N-1,P)
      NRT = MAX0(0,MIN0(P-2,N))
      LU = MAX0(NCT,NRT)
      IF (LU .LT. 1) GO TO 170
      DO 160 L = 1, LU
         LP1 = L + 1
         IF (L .GT. NCT) GO TO 20
C
C           COMPUTE THE TRANSFORMATION FOR THE L-TH COLUMN AND
C           PLACE THE L-TH DIAGONAL IN S(L).
C
            S(L) = DNRM2(N-L+1,X(L,L),1)
            IF (S(L) .EQ. 0.0D0) GO TO 10
               IF (X(L,L) .NE. 0.0D0) S(L) = DSIGN(S(L),X(L,L))
               CALL DSCAL(N-L+1,1.0D0/S(L),X(L,L),1)
               X(L,L) = 1.0D0 + X(L,L)
   10       CONTINUE
            S(L) = -S(L)
   20    CONTINUE
         IF (P .LT. LP1) GO TO 50
         DO 40 J = LP1, P
            IF (L .GT. NCT) GO TO 30
            IF (S(L) .EQ. 0.0D0) GO TO 30
C
C              APPLY THE TRANSFORMATION.
C
               T = -DDOT(N-L+1,X(L,L),1,X(L,J),1)/X(L,L)
               CALL DAXPY(N-L+1,T,X(L,L),1,X(L,J),1)
   30       CONTINUE
C
C           PLACE THE L-TH ROW OF X INTO  E FOR THE
C           SUBSEQUENT CALCULATION OF THE ROW TRANSFORMATION.
C
            E(J) = X(L,J)
   40    CONTINUE
   50    CONTINUE
         IF (.NOT.WANTU .OR. L .GT. NCT) GO TO 70
C
C           PLACE THE TRANSFORMATION IN U FOR SUBSEQUENT BACK
C           MULTIPLICATION.
C
            DO 60 I = L, N
               U(I,L) = X(I,L)
   60       CONTINUE
   70    CONTINUE
         IF (L .GT. NRT) GO TO 150
C
C           COMPUTE THE L-TH ROW TRANSFORMATION AND PLACE THE
C           L-TH SUPER-DIAGONAL IN E(L).
C
            E(L) = DNRM2(P-L,E(LP1),1)
            IF (E(L) .EQ. 0.0D0) GO TO 80
               IF (E(LP1) .NE. 0.0D0) E(L) = DSIGN(E(L),E(LP1))
               CALL DSCAL(P-L,1.0D0/E(L),E(LP1),1)
               E(LP1) = 1.0D0 + E(LP1)
   80       CONTINUE
            E(L) = -E(L)
            IF (LP1 .GT. N .OR. E(L) .EQ. 0.0D0) GO TO 120
C
C              APPLY THE TRANSFORMATION.
C
               DO 90 I = LP1, N
                  WORK(I) = 0.0D0
   90          CONTINUE
               DO 100 J = LP1, P
                  CALL DAXPY(N-L,E(J),X(LP1,J),1,WORK(LP1),1)
  100          CONTINUE
               DO 110 J = LP1, P
                  CALL DAXPY(N-L,-E(J)/E(LP1),WORK(LP1),1,X(LP1,J),1)
  110          CONTINUE
  120       CONTINUE
            IF (.NOT.WANTV) GO TO 140
C
C              PLACE THE TRANSFORMATION IN V FOR SUBSEQUENT
C              BACK MULTIPLICATION.
C
               DO 130 I = LP1, P
                  V(I,L) = E(I)
  130          CONTINUE
  140       CONTINUE
  150    CONTINUE
  160 CONTINUE
  170 CONTINUE
C
C     SET UP THE FINAL BIDIAGONAL MATRIX OR ORDER M.
C
      M = MIN0(P,N+1)
      NCTP1 = NCT + 1
      NRTP1 = NRT + 1
      IF (NCT .LT. P) S(NCTP1) = X(NCTP1,NCTP1)
      IF (N .LT. M) S(M) = 0.0D0
      IF (NRTP1 .LT. M) E(NRTP1) = X(NRTP1,M)
      E(M) = 0.0D0
C
C     IF REQUIRED, GENERATE U.
C
      IF (.NOT.WANTU) GO TO 300
         IF (NCU .LT. NCTP1) GO TO 200
         DO 190 J = NCTP1, NCU
            DO 180 I = 1, N
               U(I,J) = 0.0D0
  180       CONTINUE
            U(J,J) = 1.0D0
  190    CONTINUE
  200    CONTINUE
         IF (NCT .LT. 1) GO TO 290
         DO 280 LL = 1, NCT
            L = NCT - LL + 1
            IF (S(L) .EQ. 0.0D0) GO TO 250
               LP1 = L + 1
               IF (NCU .LT. LP1) GO TO 220
               DO 210 J = LP1, NCU
                  T = -DDOT(N-L+1,U(L,L),1,U(L,J),1)/U(L,L)
                  CALL DAXPY(N-L+1,T,U(L,L),1,U(L,J),1)
  210          CONTINUE
  220          CONTINUE
               CALL DSCAL(N-L+1,-1.0D0,U(L,L),1)
               U(L,L) = 1.0D0 + U(L,L)
               LM1 = L - 1
               IF (LM1 .LT. 1) GO TO 240
               DO 230 I = 1, LM1
                  U(I,L) = 0.0D0
  230          CONTINUE
  240          CONTINUE
            GO TO 270
  250       CONTINUE
               DO 260 I = 1, N
                  U(I,L) = 0.0D0
  260          CONTINUE
               U(L,L) = 1.0D0
  270       CONTINUE
  280    CONTINUE
  290    CONTINUE
  300 CONTINUE
C
C     IF IT IS REQUIRED, GENERATE V.
C
      IF (.NOT.WANTV) GO TO 350
         DO 340 LL = 1, P
            L = P - LL + 1
            LP1 = L + 1
            IF (L .GT. NRT) GO TO 320
            IF (E(L) .EQ. 0.0D0) GO TO 320
               DO 310 J = LP1, P
                  T = -DDOT(P-L,V(LP1,L),1,V(LP1,J),1)/V(LP1,L)
                  CALL DAXPY(P-L,T,V(LP1,L),1,V(LP1,J),1)
  310          CONTINUE
  320       CONTINUE
            DO 330 I = 1, P
               V(I,L) = 0.0D0
  330       CONTINUE
            V(L,L) = 1.0D0
  340    CONTINUE
  350 CONTINUE
C
C     MAIN ITERATION LOOP FOR THE SINGULAR VALUES.
C
      MM = M
      ITER = 0
  360 CONTINUE
C
C        QUIT IF ALL THE SINGULAR VALUES HAVE BEEN FOUND.
C
C     ...EXIT
         IF (M .EQ. 0) GO TO 620
C
C        IF TOO MANY ITERATIONS HAVE BEEN PERFORMED, SET
C        FLAG AND RETURN.
C
         IF (ITER .LT. MAXIT) GO TO 370
            INFO = M
C     ......EXIT
            GO TO 620
  370    CONTINUE
C
C        THIS SECTION OF THE PROGRAM INSPECTS FOR
C        NEGLIGIBLE ELEMENTS IN THE S AND E ARRAYS.  ON
C        COMPLETION THE VARIABLES KASE AND L ARE SET AS FOLLOWS.
C
C           KASE = 1     IF S(M) AND E(L-1) ARE NEGLIGIBLE AND L.LT.M
C           KASE = 2     IF S(L) IS NEGLIGIBLE AND L.LT.M
C           KASE = 3     IF E(L-1) IS NEGLIGIBLE, L.LT.M, AND
C                        S(L), ..., S(M) ARE NOT NEGLIGIBLE (QR STEP).
C           KASE = 4     IF E(M-1) IS NEGLIGIBLE (CONVERGENCE).
C
         DO 390 LL = 1, M
            L = M - LL
C        ...EXIT
            IF (L .EQ. 0) GO TO 400
            TEST = DABS(S(L)) + DABS(S(L+1))
            ZTEST = TEST + DABS(E(L))
            IF (ZTEST .NE. TEST) GO TO 380
               E(L) = 0.0D0
C        ......EXIT
               GO TO 400
  380       CONTINUE
  390    CONTINUE
  400    CONTINUE
         IF (L .NE. M - 1) GO TO 410
            KASE = 4
         GO TO 480
  410    CONTINUE
            LP1 = L + 1
            MP1 = M + 1
            DO 430 LLS = LP1, MP1
               LS = M - LLS + LP1
C           ...EXIT
               IF (LS .EQ. L) GO TO 440
               TEST = 0.0D0
               IF (LS .NE. M) TEST = TEST + DABS(E(LS))
               IF (LS .NE. L + 1) TEST = TEST + DABS(E(LS-1))
               ZTEST = TEST + DABS(S(LS))
               IF (ZTEST .NE. TEST) GO TO 420
                  S(LS) = 0.0D0
C           ......EXIT
                  GO TO 440
  420          CONTINUE
  430       CONTINUE
  440       CONTINUE
            IF (LS .NE. L) GO TO 450
               KASE = 3
            GO TO 470
  450       CONTINUE
            IF (LS .NE. M) GO TO 460
               KASE = 1
            GO TO 470
  460       CONTINUE
               KASE = 2
               L = LS
  470       CONTINUE
  480    CONTINUE
         L = L + 1
C
C        PERFORM THE TASK INDICATED BY KASE.
C
         GO TO (490,520,540,570), KASE
C
C        DEFLATE NEGLIGIBLE S(M).
C
  490    CONTINUE
            MM1 = M - 1
            F = E(M-1)
            E(M-1) = 0.0D0
            DO 510 KK = L, MM1
               K = MM1 - KK + L
               T1 = S(K)
               CALL DROTG(T1,F,CS,SN)
               S(K) = T1
               IF (K .EQ. L) GO TO 500
                  F = -SN*E(K-1)
                  E(K-1) = CS*E(K-1)
  500          CONTINUE
               IF (WANTV) CALL DROT(P,V(1,K),1,V(1,M),1,CS,SN)
  510       CONTINUE
         GO TO 610
C
C        SPLIT AT NEGLIGIBLE S(L).
C
  520    CONTINUE
            F = E(L-1)
            E(L-1) = 0.0D0
            DO 530 K = L, M
               T1 = S(K)
               CALL DROTG(T1,F,CS,SN)
               S(K) = T1
               F = -SN*E(K)
               E(K) = CS*E(K)
               IF (WANTU) CALL DROT(N,U(1,K),1,U(1,L-1),1,CS,SN)
  530       CONTINUE
         GO TO 610
C
C        PERFORM ONE QR STEP.
C
  540    CONTINUE
C
C           CALCULATE THE SHIFT.
C
            SCALE = DMAX1(DABS(S(M)),DABS(S(M-1)),DABS(E(M-1)),
     *                    DABS(S(L)),DABS(E(L)))
            SM = S(M)/SCALE
            SMM1 = S(M-1)/SCALE
            EMM1 = E(M-1)/SCALE
            SL = S(L)/SCALE
            EL = E(L)/SCALE
            B = ((SMM1 + SM)*(SMM1 - SM) + EMM1**2)/2.0D0
            C = (SM*EMM1)**2
            SHIFT = 0.0D0
            IF (B .EQ. 0.0D0 .AND. C .EQ. 0.0D0) GO TO 550
               SHIFT = DSQRT(B**2+C)
               IF (B .LT. 0.0D0) SHIFT = -SHIFT
               SHIFT = C/(B + SHIFT)
  550       CONTINUE
            F = (SL + SM)*(SL - SM) + SHIFT
            G = SL*EL
C
C           CHASE ZEROS.
C
            MM1 = M - 1
            DO 560 K = L, MM1
               CALL DROTG(F,G,CS,SN)
               IF (K .NE. L) E(K-1) = F
               F = CS*S(K) + SN*E(K)
               E(K) = CS*E(K) - SN*S(K)
               G = SN*S(K+1)
               S(K+1) = CS*S(K+1)
               IF (WANTV) CALL DROT(P,V(1,K),1,V(1,K+1),1,CS,SN)
               CALL DROTG(F,G,CS,SN)
               S(K) = F
               F = CS*E(K) + SN*S(K+1)
               S(K+1) = -SN*E(K) + CS*S(K+1)
               G = SN*E(K+1)
               E(K+1) = CS*E(K+1)
               IF (WANTU .AND. K .LT. N)
     *            CALL DROT(N,U(1,K),1,U(1,K+1),1,CS,SN)
  560       CONTINUE
            E(M-1) = F
            ITER = ITER + 1
         GO TO 610
C
C        CONVERGENCE.
C
  570    CONTINUE
C
C           MAKE THE SINGULAR VALUE  POSITIVE.
C
            IF (S(L) .GE. 0.0D0) GO TO 580
               S(L) = -S(L)
               IF (WANTV) CALL DSCAL(P,-1.0D0,V(1,L),1)
  580       CONTINUE
C
C           ORDER THE SINGULAR VALUE.
C
  590       IF (L .EQ. MM) GO TO 600
C           ...EXIT
               IF (S(L) .GE. S(L+1)) GO TO 600
               T = S(L)
               S(L) = S(L+1)
               S(L+1) = T
               IF (WANTV .AND. L .LT. P)
     *            CALL DSWAP(P,V(1,L),1,V(1,L+1),1)
               IF (WANTU .AND. L .LT. N)
     *            CALL DSWAP(N,U(1,L),1,U(1,L+1),1)
               L = L + 1
            GO TO 590
  600       CONTINUE
            ITER = 0
            M = M - 1
  610    CONTINUE
      GO TO 360
  620 CONTINUE
      RETURN
      END
      SUBROUTINE DSWAP (N,DX,INCX,DY,INCY)
C
C     INTERCHANGES TWO VECTORS.
C     USES UNROLLED LOOPS FOR INCREMENTS EQUAL ONE.
C     JACK DONGARRA, LINPACK, 3/11/78.
C
      DOUBLE PRECISION DX(1),DY(1),DTEMP
      INTEGER I,INCX,INCY,IX,IY,M,MP1,N
C
      IF(N.LE.0)RETURN
      IF(INCX.EQ.1.AND.INCY.EQ.1)GO TO 20
C
C       CODE FOR UNEQUAL INCREMENTS OR EQUAL INCREMENTS NOT EQUAL
C         TO 1
C
      IX = 1
      IY = 1
      IF(INCX.LT.0)IX = (-N+1)*INCX + 1
      IF(INCY.LT.0)IY = (-N+1)*INCY + 1
      DO 10 I = 1,N
        DTEMP = DX(IX)
        DX(IX) = DY(IY)
        DY(IY) = DTEMP
        IX = IX + INCX
        IY = IY + INCY
   10 CONTINUE
      RETURN
C
C       CODE FOR BOTH INCREMENTS EQUAL TO 1
C
C
C       CLEAN-UP LOOP
C
   20 M = MOD(N,3)
      IF( M .EQ. 0 ) GO TO 40
      DO 30 I = 1,M
        DTEMP = DX(I)
        DX(I) = DY(I)
        DY(I) = DTEMP
   30 CONTINUE
      IF( N .LT. 3 ) RETURN
   40 MP1 = M + 1
      DO 50 I = MP1,N,3
        DTEMP = DX(I)
        DX(I) = DY(I)
        DY(I) = DTEMP
        DTEMP = DX(I + 1)
        DX(I + 1) = DY(I + 1)
        DY(I + 1) = DTEMP
        DTEMP = DX(I + 2)
        DX(I + 2) = DY(I + 2)
        DY(I + 2) = DTEMP
   50 CONTINUE
      RETURN
      END
      REAL FUNCTION DUMFUN(X0)
C
C     PURPOSE--AUXILLARY FUNCTION FOR COMPUTING A USER-DEFINED
C              FUNCTION.  USED BY THE NUMERICAL DERIVATIVE ROUTINE
C              INITIALLY, BUT MAY BE APPLICABLE TO OTHER APPLICATIONS.
C              IT COMPUTES THE FUNCTION AT THE VALUE X0
C              AND RETURNS THE FUNCTION VALUE IN DUMFUN.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/1
C     ORIGINAL VERSION--JANUARY   2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      REAL X0
C
      CHARACTER*4 MODEL
      CHARACTER*4 IPARN
      CHARACTER*4 IPARN2
      CHARACTER*4 IANGLU
      CHARACTER*4 ITYPEH
      CHARACTER*4 IW21HO
      CHARACTER*4 IW22HO
      CHARACTER*4 IVARN
      CHARACTER*4 IVARN2
      CHARACTER*4 IZNAME
      CHARACTER*4 IZNAM2
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGCO
      CHARACTER*4 IBUGEV
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      PARAMETER (IDUMCH=1000)
      PARAMETER (IDUMC2=100)
C
      DIMENSION PARAM(IDUMC2)
      DIMENSION IPARN(IDUMC2)
      DIMENSION IPARN2(IDUMC2)
      DIMENSION IVARN(IDUMC2)
      DIMENSION IVARN2(IDUMC2)
C
      DIMENSION MODEL(IDUMCH)
      DIMENSION ITYPEH(IDUMCH)
      DIMENSION IW21HO(IDUMCH)
      DIMENSION IW22HO(IDUMCH)
      DIMENSION W2HOLD(IDUMCH)
C
      DIMENSION ILOCV(IDUMC2)
C
      COMMON /DUMCMC/ IBUGA3, ITYPEH, IW21HO, IW22HO, IPARN, IPARN2, 
     &                IVARN, IVARN2, MODEL, IZNAME, IZNAM2, IZNDEX
      COMMON /DUMCMR/ PARAM, W2HOLD,
     &                NUMCHA, NUMVAR, NWHOLD, NUMDV, ILOCV
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='OFF'
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('AT THE BEGINNING OF DUMFUN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)NUMCHA,NUMDV,NUMVAR
   53   FORMAT('NUMCHA,NUMDV,NUMVAR = ',3I8)
        CALL DPWRST('XXX','BUG ')
        NMAX=NUMCHA
        IF(NMAX.GT.25)NMAX=25
        WRITE(ICOUT,54)(MODEL(J),J=1,NMAX)
   54   FORMAT('MODEL(I) = ',25A4)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMVAR
          WRITE(ICOUT,56)I,PARAM(I),IPARN(I),IPARN2(I)
   56     FORMAT('I,PARAM(I),IPARN(I),IPARN2(I) = ',I8,E15.7,A4,A4)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        DO59I=1,NUMDV
          WRITE(ICOUT,61)I,IVARN(I),IVARN2(I)
   61     FORMAT('I, IVARN(I),IVARN2(I) = ',I8,2X,A4,A4)
          CALL DPWRST('XXX','BUG ')
   59   CONTINUE
        WRITE(ICOUT,69)X0
   69   FORMAT('X0 = ',G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ***************************
C               **  STEP 3--             **
C               **  INITIALIZE PARAMETERS**
C               ***************************
C
      ISTEPN='3'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IPASS=2
      IBUGCO=IBUGA3
      IBUGEV=IBUGA3
      FX=0.0
C
      PARAM(IZNDEX)=X0
      CALL COMPIM(MODEL,NUMCHA,IPASS,PARAM,IPARN,IPARN2,NUMVAR,
     1IANGLU,ITYPEH,IW21HO,IW22HO,W2HOLD,NWHOLD,FX,
     1IBUGCO,IBUGEV,IERROR)
      DUMFUN=FX
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,9101)FX
        CALL DPWRST('XXX','BUG ')
        DO9102KK=1,NUMDV
        WRITE(ICOUT,9103)KK,PARAM(KK)
        CALL DPWRST('XXX','BUG ')
 9102   CONTINUE
      ENDIF
 9101 FORMAT('FX  = ',E15.7)
 9103 FORMAT('I,PARAM(I) = ',I5,1X,E15.7)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END      OF DUMFUN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9021)FX,IERROR
 9021   FORMAT('FX,IERROR = ',G15.7,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE DUNRAN(N,NPAR,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE DISCRETE UNIFORM DISTRIBUTION
C              WITH INTEGER 'NUMBER OF ITEMS' = NPAR
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --NPAR   = THE INTEGER VALUE
C                                OF THE 'NUMBER OF ITEMS' PARAMETER.
C                                NPAR SHOULD BE A POSITIVE INTEGER.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE DISCRETE UNIFORM DISTRIBUTION
C             WITH 'NUMBER OF ITEMS' PARAMETER = NPAR.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --NPAR SHOULD BE A POSITIVE INTEGER.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     COMMENT--NOTE THAT EVEN THOUGH THE OUTPUT
C              FROM THIS DISCRETE RANDOM NUMBER
C              GENERATOR MUST NECESSARILY BE A
C              SEQUENCE OF ***INTEGER*** VALUES,
C              THE OUTPUT VECTOR X IS SINGLE
C              PRECISION IN MODE.
C              X HAS BEEN SPECIFIED AS SINGLE
C              PRECISION SO AS TO CONFORM WITH THE DATAPAC
C              CONVENTION THAT ALL OUTPUT VECTORS FROM ALL
C              DATAPAC SUBROUTINES ARE SINGLE PRECISION.
C              THIS CONVENTION IS BASED ON THE BELIEF THAT
C              1) A MIXTURE OF MODES (FLOATING POINT
C              VERSUS INTEGER) IS INCONSISTENT AND
C              AN UNNECESSARY COMPLICATION
C              IN A DATA ANALYSIS; AND
C              2) FLOATING POINT MACHINE ARITHMETIC
C              (AS OPPOSED TO INTEGER ARITHMETIC)
C              IS THE MORE NATURAL MODE FOR DOING
C              DATA ANALYSIS.
C     REFERENCE--JOHNSON AND KOTZ
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--89/1
C     ORIGINAL VERSION--DECEMBER  1988.
C     UPDATED         --JUNE      2005. ROUTINE WAS GENERATING RANDOM
C                                       NUMBERS FROM 1 TO N RATHER
C                                       THAN 0 TO N.  CORRECTED TO
C                                       GENERATE FROM 0 TO N.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
    5   FORMAT('***** ERROR--THE REQUESTED NUMBER OF DISCRETE ',
     1         'UNIFORM RANDOM NUMBERS IS NON-POSITIVE *****')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
   47   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,' *****')
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(NPAR.LT.1)THEN
        WRITE(ICOUT,25)
   25   FORMAT('***** ERROR--THE SHAPE PARAMETER (N) FOR THE DISCRETE',
     1         'UNIFORM RANDOM NUMBERS IS NON-POSITIVE *****')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)NPAR
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
C     GENERATE N UNIFORM (0,1) (CONTINOUS) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     CONVERT THE N CONTINUOUS UNIFORM RANDOM NUMBERS OVER [0,1]
C     TO N DISCRETE UNIFORM RANDOM NUMBERS OVER [0,NPAR]
C
CCCCC JUNE 2005. GENERATE OVER [0,NPAR] RATHER THAN [1,NPAR].  USE
CCCCC CURRENT ALGORITHM FOR [1,NPAR+1] THEN SUBTRACT 1.
C
      NPART=NPAR+1
      ANPAR=NPART
      DO1100I=1,N
        U=X(I)
        PROD=ANPAR*U
        IPROD=PROD
        IPROD=IPROD+1
        IF(IPROD.LT.1)IPROD=1
        IF(IPROD.GT.NPART)IPROD=NPART
        X(I)=IPROD - 1
 1100 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE DUNRA2(N,NPAR,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE DISCRETE UNIFORM DISTRIBUTION
C              WITH INTEGER 'NUMBER OF ITEMS' = NPAR
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --NPAR   = THE INTEGER VALUE
C                                OF THE 'NUMBER OF ITEMS' PARAMETER.
C                                NPAR SHOULD BE A POSITIVE INTEGER.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE DISCRETE UNIFORM DISTRIBUTION
C             WITH 'NUMBER OF ITEMS' PARAMETER = NPAR.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --NPAR SHOULD BE A POSITIVE INTEGER.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     COMMENT--NOTE THAT EVEN THOUGH THE OUTPUT
C              FROM THIS DISCRETE RANDOM NUMBER
C              GENERATOR MUST NECESSARILY BE A
C              SEQUENCE OF ***INTEGER*** VALUES,
C              THE OUTPUT VECTOR X IS SINGLE
C              PRECISION IN MODE.
C              X HAS BEEN SPECIFIED AS SINGLE
C              PRECISION SO AS TO CONFORM WITH THE DATAPAC
C              CONVENTION THAT ALL OUTPUT VECTORS FROM ALL
C              DATAPAC SUBROUTINES ARE SINGLE PRECISION.
C              THIS CONVENTION IS BASED ON THE BELIEF THAT
C              1) A MIXTURE OF MODES (FLOATING POINT
C              VERSUS INTEGER) IS INCONSISTENT AND
C              AN UNNECESSARY COMPLICATION
C              IN A DATA ANALYSIS; AND
C              2) FLOATING POINT MACHINE ARITHMETIC
C              (AS OPPOSED TO INTEGER ARITHMETIC)
C              IS THE MORE NATURAL MODE FOR DOING
C              DATA ANALYSIS.
C     REFERENCE--JOHNSON AND KOTZ
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--89/1
C     ORIGINAL VERSION--DECEMBER  1988.
C     UPDATED         --JUNE      2005. ROUTINE WAS GENERATING RANDOM
C                                       NUMBERS FROM 1 TO N RATHER
C                                       THAN 0 TO N.  CORRECTED TO
C                                       GENERATE FROM 0 TO N.
C     UPDATED         --AUGUST    2005. THIS IS A COPY OF THE ORIGINAL
C                                       DUNRAN THAT GOES FROM 1 TO N.
C                                       THIS VERSION OF ROUTINE USED
C                                       BY BOOTSTRAP COMMAND.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
    5   FORMAT('***** ERROR--THE REQUESTED NUMBER OF DISCRETE ',
     1         'UNIFORM RANDOM NUMBERS IS NON-POSITIVE *****')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
   47   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,' *****')
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(NPAR.LT.1)THEN
        WRITE(ICOUT,25)
   25   FORMAT('***** ERROR--THE SHAPE PARAMETER (N) FOR THE DISCRETE',
     1         'UNIFORM RANDOM NUMBERS IS NON-POSITIVE *****')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)NPAR
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
C     GENERATE N UNIFORM (0,1) (CONTINOUS) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     CONVERT THE N CONTINUOUS UNIFORM RANDOM NUMBERS OVER [0,1]
C     TO N DISCRETE UNIFORM RANDOM NUMBERS OVER [1,NPAR]
C
      ANPAR=NPAR
      DO1100I=1,N
      U=X(I)
      PROD=ANPAR*U
      IPROD=PROD
      IPROD=IPROD+1
      IF(IPROD.LT.1)IPROD=1
      IF(IPROD.GT.NPAR)IPROD=NPAR
      X(I)=IPROD
 1100 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE DVLA(VA,X,PD)
C
C       ====================================================
C       Purpose: Compute parabolic cylinder functions Dv(x)
C                for large argument
C       Input:   x  --- Argument
C                va --- Order
C       Output:  PD --- Dv(x)
C       Routines called:
C             (1) VVLA for computing Vv(x) for large |x|
C             (2) GAMMA for computing (x)
C                 SUBSTITUTE CMLIB DGAMMA FUNCTION
C       ====================================================
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        PI=3.141592653589793D0           
        EPS=1.0D-12
        EP=DEXP(-.25*X*X)
        A0=DABS(X)**VA*EP
        R=1.0D0
        PD=1.0D0
        DO 10 K=1,16
           R=-0.5D0*R*(2.0*K-VA-1.0)*(2.0*K-VA-2.0)/(K*X*X)
           PD=PD+R
           IF (DABS(R/PD).LT.EPS) GO TO 15
10      CONTINUE
15      PD=A0*PD
        IF (X.LT.0.0D0) THEN
            X1=-X
            CALL VVLA(VA,X1,VL)
CCCCC       CALL GAMMA(-VA,GL)
            GL=DGAMMA(-VA)
            PD=PI*VL/GL+DCOS(PI*VA)*PD
        ENDIF
        RETURN
        END
      SUBROUTINE DVSA(VA,X,PD)
C
C       ===================================================
C       Purpose: Compute parabolic cylinder function Dv(x)
C                for small argument
C       Input:   x  --- Argument
C                va --- Order
C       Output:  PD --- Dv(x)
C       Routine called: GAMMA for computing (x)
C                SUBSTITUTE CMLIB DGAMMA FUNCTION
C       ===================================================
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        EPS=1.0D-15
        PI=3.141592653589793D0
        SQ2=DSQRT(2.0D0)
        EP=DEXP(-.25D0*X*X)
        VA0=0.5D0*(1.0D0-VA)
        IF (VA.EQ.0.0) THEN
           PD=EP
        ELSE
           IF (X.EQ.0.0) THEN
              IF (VA0.LE.0.0.AND.VA0.EQ.INT(VA0)) THEN
                 PD=0.0D0
              ELSE
CCCCC            CALL GAMMA(VA0,GA0)
                 GA0=DGAMMA(VA0)
                 PD=DSQRT(PI)/(2.0D0**(-.5D0*VA)*GA0)
              ENDIF
           ELSE
CCCCC         CALL GAMMA(-VA,G1)
              G1=DGAMMA(-VA)
              A0=2.0D0**(-0.5D0*VA-1.0D0)*EP/G1
              VT=-.5D0*VA
CCCCC         CALL GAMMA(VT,G0)
              G0=DGAMMA(VT)
              PD=G0
              R=1.0D0
              DO 10 M=1,250
                 VM=.5D0*(M-VA)
CCCCC            CALL GAMMA(VM,GM)
                 GM=DGAMMA(VM)
                 R=-R*SQ2*X/M
                 R1=GM*R
                 PD=PD+R1
                 IF (DABS(R1).LT.DABS(PD)*EPS) GO TO 15
10            CONTINUE
15            PD=A0*PD
           ENDIF
        ENDIF
        RETURN
        END
      SUBROUTINE DWECDF(X,GAMMA,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE DOUBLE WEIBULL
C              DISTRIBUTION WITH SINGLE PRECISION
C              TAIL LENGTH PARAMETER = GAMMA.
C              THE DOUBLE WEIBULL DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL REAL X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = (C/2)*X*EXP(-ABS(X)**C)
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C                     --GAMMA  = THE SHAPE PARAMETER
C                                GAMMA SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--CDF    = THE SINGLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE CDF FOR THE DOUBLE WEIBULL DISTRIBUTION
C             WITH TAIL LENGHT PARAMETER = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--GAMMA SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCE --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--2, 1994, CHAPTER 21
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--95/10
C     ORIGINAL VERSION--OCTOBER   1995.
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      CDF=0.0
      IF(GAMMA.LE.0)THEN
        WRITE(ICOUT,15)
   15   FORMAT('***** ERROR--THE SECOND ARGUMENT TO DWECDF IS ',
     1         'NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
   46   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
CCCCC THE FOLLOWING SECTION WAS REWRITTEN      JANUARY 1994
      MINMAX=1
      IF(X.EQ.0.0)THEN
        CDF=0.5
      ELSEIF(X.GT.0.0)THEN
        CALL WEICDF(X,GAMMA,MINMAX,CDF2)
        CDF=0.5+CDF2/2.0
      ELSE
        ARG1=-X
        CALL WEICDF(ARG1,GAMMA,MINMAX,CDF2)
        CDF=0.5-CDF2/2.0
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE DWEPDF(X,GAMMA,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE DOUBLE WEIBULL
C              DISTRIBUTION WITH SINGLE PRECISION
C              TAIL LENGTH PARAMETER = GAMMA.
C              THE DOUBLE WEIBULL DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL REAL X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = (C/2)*X*EXP(-ABS(X)**C)
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C                     --GAMMA  = THE SHAPE PARAMETER
C                                GAMMA SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--PDF    = THE SINGLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE PDF FOR THE DOUBLE WEIBULL DISTRIBUTION
C             WITH TAIL LENGHT PARAMETER = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--GAMMA SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--WEIPDF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCE --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--2, 1994, CHAPTER 21
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--95/10
C     ORIGINAL VERSION--OCTOBER   1995.
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      PDF=0.0
      IF(GAMMA.LE.0)THEN
        WRITE(ICOUT,15)
   15   FORMAT('***** ERROR--THE SECOND ARGUMENT TO DWEPDF IS ',
     1         'NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
   46   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
CCCCC THE FOLLOWING SECTION WAS REWRITTEN      JANUARY 1994
      MINMAX=1
      ARG1=ABS(X)
      CALL WEIPDF(ARG1,GAMMA,MINMAX,PDF2)
      PDF=PDF2/2.0
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE DWEPPF(P,GAMMA,PPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE DOUBLE WEIBULL
C              DISTRIBUTION WITH SINGLE PRECISION
C              TAIL LENGTH PARAMETER = GAMMA.
C              THE DOUBLE WEIBULL DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL REAL X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = (C/2)*X*EXP(-ABS(X)**C)
C     INPUT  ARGUMENTS--P      = THE SINGLE PRECISION VALUE
C                                (BETWEEN 0.0 (INCLUSIVELY)
C                                AND 1.0 (EXCLUSIVELY))
C                                AT WHICH THE PERCENT POINT
C                                FUNCTION IS TO BE EVALUATED.
C                     --GAMMA  = THE SINGLE PRECISION VALUE
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--PPF    = THE SINGLE PRECISION PERCENT
C                                POINT FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PERCENT POINT FUNCTION .
C             VALUE PPF FOR THE WEIBULL DISTRIBUTION
C             WITH TAIL LENGTH PARAMETER VALUE = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--GAMMA SHOULD BE POSITIVE.
C                 --P SHOULD BE BETWEEN 0.0 (EXCLUSIVELY)
C                   AND 1.0 (EXCLUSIVELY).
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--LOG.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCE --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--2, 1994, CHAPTER 21
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--95/10
C     ORIGINAL VERSION--OCTOBER   1995.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      PPF=0.0
      IF(P.LE.0.0.OR.P.GE.1.0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    1 FORMAT('***** ERROR--THE FIRST ARGUMENT TO DWEPPF IS ',
     1       'OUTSIDE THE ALLOWABLE (0,1) INTERVAL')
   15 FORMAT('***** ERROR--THE SECOND ARGUMENT TO DWEPPF IS ',
     1       'NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      MINMAX=1
      IF(P.EQ.0.5)THEN
        PPF=0.0
      ELSEIF(P.LT.0.5)THEN
        ARG1=2.0*(0.5-P)
        CALL WEIPPF(ARG1,GAMMA,MINMAX,PPF)
        PPF=-PPF
      ELSE
        ARG1=2.0*(P-0.5)
        CALL WEIPPF(ARG1,GAMMA,MINMAX,PPF)
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE DWERAN(N,GAMMA,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE DOUBLE WEIBULL DISTRIBUTION
C              WITH TAIL LENGTH PARAMETER VALUE = GAMMA.
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --GAMMA  = THE SINGLE PRECISION VALUE OF THE
C                                TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE DOUBLE WEIBULL DISTRIBUTION
C             WITH TAIL LENGTH PARAMETER VALUE = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --GAMMA SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NON E.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 2ND. ED., 1994.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--2001.9
C     ORIGINAL VERSION--SEPTEMBER 2001.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE REQUESTED NUMBER OF DOUBLE WEIBULL ',
     1       'RANDOM NUMBERS IS NON-POSITIVE')
   15 FORMAT('***** ERROR--THE SPECIFIED VALUE OF GAMMA FOR THE ',
     1       'DOUBLE WEIBULL RANDOM NUMBERS IS NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
C
C     GENERATE N UNIFORM (0,1) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     GENERATE N DOUBLE WEIBULL DISTRIBUTION RANDOM NUMBERS
C     USING THE PERCENT POINT FUNCTION TRANSFORMATION METHOD.
C
      DO100I=1,N
        CALL DWEPPF(X(I),GAMMA,XTEMP)
        X(I)=XTEMP
  100 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE DXADD (X, IX, Y, IY, Z, IZ, IERROR)
C***BEGIN PROLOGUE  DXADD
C***PURPOSE  To provide double-precision floating-point arithmetic
C            with an extended exponent range.
C***LIBRARY   SLATEC
C***CATEGORY  A3D
C***TYPE      DOUBLE PRECISION (XADD-S, DXADD-D)
C***KEYWORDS  EXTENDED-RANGE DOUBLE-PRECISION ARITHMETIC
C***AUTHOR  Lozier, Daniel W., (NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY)
C           Smith, John M., (NBS and George Mason University)
C***DESCRIPTION
C     DOUBLE PRECISION X, Y, Z
C     INTEGER IX, IY, IZ
C
C                  FORMS THE EXTENDED-RANGE SUM  (Z,IZ) =
C                  (X,IX) + (Y,IY).  (Z,IZ) IS ADJUSTED
C                  BEFORE RETURNING. THE INPUT OPERANDS
C                  NEED NOT BE IN ADJUSTED FORM, BUT THEIR
C                  PRINCIPAL PARTS MUST SATISFY
C                  RADIX**(-2L).LE.ABS(X).LE.RADIX**(2L),
C                  RADIX**(-2L).LE.ABS(Y).LE.RADIX**(2L).
C
C***SEE ALSO  DXSET
C***REFERENCES  (NONE)
C***ROUTINES CALLED  DXADJ
C***COMMON BLOCKS    DXBLK2
C***REVISION HISTORY  (YYMMDD)
C   820712  DATE WRITTEN
C   881020  Revised to meet SLATEC CML recommendations.  (DWL and JMS)
C   901019  Revisions to prologue.  (DWL and WRB)
C   901106  Changed all specific intrinsics to generic.  (WRB)
C           Corrected order of sections in prologue and added TYPE
C           section.  (WRB)
C   920127  Revised PURPOSE section of prologue.  (DWL)
C***END PROLOGUE  DXADD
      DOUBLE PRECISION X, Y, Z
      INTEGER IX, IY, IZ
      DOUBLE PRECISION RADIX, RADIXL, RAD2L, DLG10R
      INTEGER L, L2, KMAX
      COMMON /DXBLK2/ RADIX, RADIXL, RAD2L, DLG10R, L, L2, KMAX
      SAVE /DXBLK2/
      DOUBLE PRECISION S, T
C
C   THE CONDITIONS IMPOSED ON L AND KMAX BY THIS SUBROUTINE
C ARE
C     (1) 1 .LT. L .LE. 0.5D0*LOGR(0.5D0*DZERO)
C
C     (2) NRADPL .LT. L .LE. KMAX/6
C
C     (3) KMAX .LE. (2**NBITS - 4*L - 1)/2
C
C THESE CONDITIONS MUST BE MET BY APPROPRIATE CODING
C IN SUBROUTINE DXSET.
C
C***FIRST EXECUTABLE STATEMENT  DXADD
      IERROR=0
      IF (X.NE.0.0D0) GO TO 10
      Z = Y
      IZ = IY
      GO TO 220
   10 IF (Y.NE.0.0D0) GO TO 20
      Z = X
      IZ = IX
      GO TO 220
   20 CONTINUE
      IF (IX.GE.0 .AND. IY.GE.0) GO TO 40
      IF (IX.LT.0 .AND. IY.LT.0) GO TO 40
      IF (ABS(IX).LE.6*L .AND. ABS(IY).LE.6*L) GO TO 40
      IF (IX.GE.0) GO TO 30
      Z = Y
      IZ = IY
      GO TO 220
   30 CONTINUE
      Z = X
      IZ = IX
      GO TO 220
   40 I = IX - IY
CCCCC IF (I) 80, 50, 90
      IF(I.LT.0)GOTO80
      IF(I.GT.0)GOTO90
   50 IF (ABS(X).GT.1.0D0 .AND. ABS(Y).GT.1.0D0) GO TO 60
      IF (ABS(X).LT.1.0D0 .AND. ABS(Y).LT.1.0D0) GO TO 70
      Z = X + Y
      IZ = IX
      GO TO 220
   60 S = X/RADIXL
      T = Y/RADIXL
      Z = S + T
      IZ = IX + L
      GO TO 220
   70 S = X*RADIXL
      T = Y*RADIXL
      Z = S + T
      IZ = IX - L
      GO TO 220
   80 S = Y
      IS = IY
      T = X
      GO TO 100
   90 S = X
      IS = IX
      T = Y
  100 CONTINUE
C
C  AT THIS POINT, THE ONE OF (X,IX) OR (Y,IY) THAT HAS THE
C LARGER AUXILIARY INDEX IS STORED IN (S,IS). THE PRINCIPAL
C PART OF THE OTHER INPUT IS STORED IN T.
C
      I1 = ABS(I)/L
      I2 = MOD(ABS(I),L)
      IF (ABS(T).GE.RADIXL) GO TO 130
      IF (ABS(T).GE.1.0D0) GO TO 120
      IF (RADIXL*ABS(T).GE.1.0D0) GO TO 110
      J = I1 + 1
      T = T*RADIX**(L-I2)
      GO TO 140
  110 J = I1
      T = T*RADIX**(-I2)
      GO TO 140
  120 J = I1 - 1
      IF (J.LT.0) GO TO 110
      T = T*RADIX**(-I2)/RADIXL
      GO TO 140
  130 J = I1 - 2
      IF (J.LT.0) GO TO 120
      T = T*RADIX**(-I2)/RAD2L
  140 CONTINUE
C
C  AT THIS POINT, SOME OR ALL OF THE DIFFERENCE IN THE
C AUXILIARY INDICES HAS BEEN USED TO EFFECT A LEFT SHIFT
C OF T.  THE SHIFTED VALUE OF T SATISFIES
C
C       RADIX**(-2*L) .LE. ABS(T) .LE. 1.0D0
C
C AND, IF J=0, NO FURTHER SHIFTING REMAINS TO BE DONE.
C
      IF (J.EQ.0) GO TO 190
      IF (ABS(S).GE.RADIXL .OR. J.GT.3) GO TO 150
      IF (ABS(S).GE.1.0D0) GO TO (180, 150, 150), J
      IF (RADIXL*ABS(S).GE.1.0D0) GO TO (180, 170, 150), J
      GO TO (180, 170, 160), J
  150 Z = S
      IZ = IS
      GO TO 220
  160 S = S*RADIXL
  170 S = S*RADIXL
  180 S = S*RADIXL
  190 CONTINUE
C
C   AT THIS POINT, THE REMAINING DIFFERENCE IN THE
C AUXILIARY INDICES HAS BEEN USED TO EFFECT A RIGHT SHIFT
C OF S.  IF THE SHIFTED VALUE OF S WOULD HAVE EXCEEDED
C RADIX**L, THEN (S,IS) IS RETURNED AS THE VALUE OF THE
C SUM.
C
      IF (ABS(S).GT.1.0D0 .AND. ABS(T).GT.1.0D0) GO TO 200
      IF (ABS(S).LT.1.0D0 .AND. ABS(T).LT.1.0D0) GO TO 210
      Z = S + T
      IZ = IS - J*L
      GO TO 220
  200 S = S/RADIXL
      T = T/RADIXL
      Z = S + T
      IZ = IS - J*L + L
      GO TO 220
  210 S = S*RADIXL
      T = T*RADIXL
      Z = S + T
      IZ = IS - J*L - L
  220 CALL DXADJ(Z, IZ,IERROR)
      RETURN
      END
      SUBROUTINE DXADJ (X, IX, IERROR)
C***BEGIN PROLOGUE  DXADJ
C***PURPOSE  To provide double-precision floating-point arithmetic
C            with an extended exponent range.
C***LIBRARY   SLATEC
C***CATEGORY  A3D
C***TYPE      DOUBLE PRECISION (XADJ-S, DXADJ-D)
C***KEYWORDS  EXTENDED-RANGE DOUBLE-PRECISION ARITHMETIC
C***AUTHOR  Lozier, Daniel W., (NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY)
C           Smith, John M., (NBS and George Mason University)
C***DESCRIPTION
C     DOUBLE PRECISION X
C     INTEGER IX
C
C                  TRANSFORMS (X,IX) SO THAT
C                  RADIX**(-L) .LE. ABS(X) .LT. RADIX**L.
C                  ON MOST COMPUTERS THIS TRANSFORMATION DOES
C                  NOT CHANGE THE MANTISSA OF X PROVIDED RADIX IS
C                  THE NUMBER BASE OF DOUBLE-PRECISION ARITHMETIC.
C
C***SEE ALSO  DXSET
C***REFERENCES  (NONE)
C***ROUTINES CALLED  XERMSG
C***COMMON BLOCKS    DXBLK2
C***REVISION HISTORY  (YYMMDD)
C   820712  DATE WRITTEN
C   881020  Revised to meet SLATEC CML recommendations.  (DWL and JMS)
C   901019  Revisions to prologue.  (DWL and WRB)
C   901106  Changed all specific intrinsics to generic.  (WRB)
C           Corrected order of sections in prologue and added TYPE
C           section.  (WRB)
C           CALLs to XERROR changed to CALLs to XERMSG.  (WRB)
C   920127  Revised PURPOSE section of prologue.  (DWL)
C***END PROLOGUE  DXADJ
      DOUBLE PRECISION X
      INTEGER IX
      DOUBLE PRECISION RADIX, RADIXL, RAD2L, DLG10R
      INTEGER L, L2, KMAX
      COMMON /DXBLK2/ RADIX, RADIXL, RAD2L, DLG10R, L, L2, KMAX
      SAVE /DXBLK2/
C
C-----COMMON----------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C   THE CONDITION IMPOSED ON L AND KMAX BY THIS SUBROUTINE
C IS
C     2*L .LE. KMAX
C
C THIS CONDITION MUST BE MET BY APPROPRIATE CODING
C IN SUBROUTINE DXSET.
C
C***FIRST EXECUTABLE STATEMENT  DXADJ
      IERROR=0
      IF (X.EQ.0.0D0) GO TO 50
      IF (ABS(X).GE.1.0D0) GO TO 20
      IF (RADIXL*ABS(X).GE.1.0D0) GO TO 60
      X = X*RAD2L
      IF (IX.LT.0) GO TO 10
      IX = IX - L2
      GO TO 70
   10 IF (IX.LT.-KMAX+L2) GO TO 40
      IX = IX - L2
      GO TO 70
   20 IF (ABS(X).LT.RADIXL) GO TO 60
      X = X/RAD2L
      IF (IX.GT.0) GO TO 30
      IX = IX + L2
      GO TO 70
   30 IF (IX.GT.KMAX-L2) GO TO 40
      IX = IX + L2
      GO TO 70
   40 CONTINUE
CCC40 CALL XERMSG ('SLATEC', 'DXADJ', 'overflow in auxiliary index',
CCCCC+             207, 1)
      IERROR=207
      WRITE(ICOUT,901)
      CALL DPWRST('XXX','BUG ')
  901 FORMAT('***** ERROR FROM DXADJ, OVERFLOW IN AUXILIARY INDEX.')
      RETURN
   50 IX = 0
   60 IF (ABS(IX).GT.KMAX) GO TO 40
   70 RETURN
      END
      SUBROUTINE DXLEGF (DNU1, NUDIFF, MU1, MU2, THETA, ID, PQA, IPQA,
     1   IERROR)
C***BEGIN PROLOGUE  DXLEGF
C***PURPOSE  Compute normalized Legendre polynomials and associated
C            Legendre functions.
C***LIBRARY   SLATEC
C***CATEGORY  C3A2, C9
C***TYPE      DOUBLE PRECISION (XLEGF-S, DXLEGF-D)
C***KEYWORDS  LEGENDRE FUNCTIONS
C***AUTHOR  Smith, John M., (NBS and George Mason University)
C***DESCRIPTION
C
C   DXLEGF: Extended-range Double-precision Legendre Functions
C
C   A feature of the DXLEGF subroutine for Legendre functions is
C the use of extended-range arithmetic, a software extension of
C ordinary floating-point arithmetic that greatly increases the
C exponent range of the representable numbers. This avoids the
C need for scaling the solutions to lie within the exponent range
C of the most restrictive manufacturer's hardware. The increased
C exponent range is achieved by allocating an integer storage
C location together with each floating-point storage location.
C
C   The interpretation of the pair (X,I) where X is floating-point
C and I is integer is X*(IR**I) where IR is the internal radix of
C the computer arithmetic.
C
C   This subroutine computes one of the following vectors:
C
C 1. Legendre function of the first kind of negative order, either
C    a. P(-MU1,NU,X), P(-MU1-1,NU,X), ..., P(-MU2,NU,X) or
C    b. P(-MU,NU1,X), P(-MU,NU1+1,X), ..., P(-MU,NU2,X)
C 2. Legendre function of the second kind, either
C    a. Q(MU1,NU,X), Q(MU1+1,NU,X), ..., Q(MU2,NU,X) or
C    b. Q(MU,NU1,X), Q(MU,NU1+1,X), ..., Q(MU,NU2,X)
C 3. Legendre function of the first kind of positive order, either
C    a. P(MU1,NU,X), P(MU1+1,NU,X), ..., P(MU2,NU,X) or
C    b. P(MU,NU1,X), P(MU,NU1+1,X), ..., P(MU,NU2,X)
C 4. Normalized Legendre polynomials, either
C    a. PN(MU1,NU,X), PN(MU1+1,NU,X), ..., PN(MU2,NU,X) or
C    b. PN(MU,NU1,X), PN(MU,NU1+1,X), ..., PN(MU,NU2,X)
C
C where X = COS(THETA).
C
C   The input values to DXLEGF are DNU1, NUDIFF, MU1, MU2, THETA,
C and ID. These must satisfy
C
C    DNU1 is DOUBLE PRECISION and greater than or equal to -0.5;
C    NUDIFF is INTEGER and non-negative;
C    MU1 is INTEGER and non-negative;
C    MU2 is INTEGER and greater than or equal to MU1;
C    THETA is DOUBLE PRECISION and in the half-open interval (0,PI/2];
C    ID is INTEGER and equal to 1, 2, 3 or 4;
C
C and  additionally either NUDIFF = 0 or MU2 = MU1.
C
C   If ID=1 and NUDIFF=0, a vector of type 1a above is computed
C with NU=DNU1.
C
C   If ID=1 and MU1=MU2, a vector of type 1b above is computed
C with NU1=DNU1, NU2=DNU1+NUDIFF and MU=MU1.
C
C   If ID=2 and NUDIFF=0, a vector of type 2a above is computed
C with NU=DNU1.
C
C   If ID=2 and MU1=MU2, a vector of type 2b above is computed
C with NU1=DNU1, NU2=DNU1+NUDIFF and MU=MU1.
C
C   If ID=3 and NUDIFF=0, a vector of type 3a above is computed
C with NU=DNU1.
C
C   If ID=3 and MU1=MU2, a vector of type 3b above is computed
C with NU1=DNU1, NU2=DNU1+NUDIFF and MU=MU1.
C
C   If ID=4 and NUDIFF=0, a vector of type 4a above is computed
C with NU=DNU1.
C
C   If ID=4 and MU1=MU2, a vector of type 4b above is computed
C with NU1=DNU1, NU2=DNU1+NUDIFF and MU=MU1.
C
C   In each case the vector of computed Legendre function values
C is returned in the extended-range vector (PQA(I),IPQA(I)). The
C length of this vector is either MU2-MU1+1 or NUDIFF+1.
C
C   Where possible, DXLEGF returns IPQA(I) as zero. In this case the
C value of the Legendre function is contained entirely in PQA(I),
C so it can be used in subsequent computations without further
C consideration of extended-range arithmetic. If IPQA(I) is nonzero,
C then the value of the Legendre function is not representable in
C floating-point because of underflow or overflow. The program that
C calls DXLEGF must test IPQA(I) to ensure correct usage.
C
C   IERROR is an error indicator. If no errors are detected, IERROR=0
C when control returns to the calling routine. If an error is detected,
C IERROR is returned as nonzero. The calling routine must check the
C value of IERROR.
C
C   If IERROR=210 or 211, invalid input was provided to DXLEGF.
C   If IERROR=201,202,203, or 204, invalid input was provided to DXSET.
C   If IERROR=205 or 206, an internal consistency error occurred in
C DXSET (probably due to a software malfunction in the library routine
C I1MACH).
C   If IERROR=207, an overflow or underflow of an extended-range number
C was detected in DXADJ.
C   If IERROR=208, an overflow or underflow of an extended-range number
C was detected in DXC210.
C
C***SEE ALSO  DXSET
C***REFERENCES  Olver and Smith, Associated Legendre Functions on the
C                 Cut, J Comp Phys, v 51, n 3, Sept 1983, pp 502--518.
C               Smith, Olver and Lozier, Extended-Range Arithmetic and
C                 Normalized Legendre Polynomials, ACM Trans on Math
C                 Softw, v 7, n 1, March 1981, pp 93--105.
C***ROUTINES CALLED  DXPMU, DXPMUP, DXPNRM, DXPQNU, DXQMU, DXQNU, DXRED,
C                    DXSET, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   820728  DATE WRITTEN
C   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS)
C   901019  Revisions to prologue.  (DWL and WRB)
C   901106  Changed all specific intrinsics to generic.  (WRB)
C           Corrected order of sections in prologue and added TYPE
C           section.  (WRB)
C           CALLs to XERROR changed to CALLs to XERMSG.  (WRB)
C   920127  Revised PURPOSE section of prologue.  (DWL)
C***END PROLOGUE  DXLEGF
      DOUBLE PRECISION PQA,DNU1,DNU2,SX,THETA,X,PI2
      DIMENSION PQA(*),IPQA(*)
C
C-----COMMON----------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C***FIRST EXECUTABLE STATEMENT  DXLEGF
      IERROR=0
      CALL DXSET (0, 0, 0.0D0, 0,IERROR)
      IF (IERROR.NE.0) RETURN
      PI2=2.D0*ATAN(1.D0)
C
C        ZERO OUTPUT ARRAYS
C
      L=(MU2-MU1)+NUDIFF+1
      DO 290 I=1,L
      PQA(I)=0.D0
  290 IPQA(I)=0
C
C        CHECK FOR VALID INPUT VALUES
C
      IF(NUDIFF.LT.0) GO TO 400
      IF(DNU1.LT.-.5D0) GO TO 400
      IF(MU2.LT.MU1) GO TO 400
      IF(MU1.LT.0) GO TO 400
      IF(THETA.LE.0.D0.OR.THETA.GT.PI2) GO TO 420
      IF(ID.LT.1.OR.ID.GT.4) GO TO 400
      IF((MU1.NE.MU2).AND.(NUDIFF.GT.0)) GO TO 400
C
C        IF DNU1 IS NOT AN INTEGER, NORMALIZED P(MU,DNU,X)
C        CANNOT BE CALCULATED.  IF DNU1 IS AN INTEGER AND
C        MU1.GT.DNU2 THEN ALL VALUES OF P(+MU,DNU,X) AND
C        NORMALIZED P(MU,NU,X) WILL BE ZERO.
C
      DNU2=DNU1+NUDIFF
      IF((ID.EQ.3).AND.(MOD(DNU1,1.D0).NE.0.D0)) GO TO 295
      IF((ID.EQ.4).AND.(MOD(DNU1,1.D0).NE.0.D0)) GO TO 400
      IF((ID.EQ.3.OR.ID.EQ.4).AND.MU1.GT.DNU2) RETURN
  295 CONTINUE
C
      X=COS(THETA)
      SX=1.D0/SIN(THETA)
      IF(ID.EQ.2) GO TO 300
      IF(MU2-MU1.LE.0) GO TO 360
C
C        FIXED NU, VARIABLE MU
C        CALL DXPMU TO CALCULATE P(-MU1,NU,X),....,P(-MU2,NU,X)
C
      CALL DXPMU(DNU1,DNU2,MU1,MU2,THETA,X,SX,ID,PQA,IPQA,IERROR)
      IF (IERROR.NE.0) RETURN
      GO TO 380
C
  300 IF(MU2.EQ.MU1) GO TO 320
C
C        FIXED NU, VARIABLE MU
C        CALL DXQMU TO CALCULATE Q(MU1,NU,X),....,Q(MU2,NU,X)
C
      CALL DXQMU(DNU1,DNU2,MU1,MU2,THETA,X,SX,ID,PQA,IPQA,IERROR)
      IF (IERROR.NE.0) RETURN
      GO TO 390
C
C        FIXED MU, VARIABLE NU
C        CALL DXQNU TO CALCULATE Q(MU,DNU1,X),....,Q(MU,DNU2,X)
C
  320 CALL DXQNU(DNU1,DNU2,MU1,THETA,X,SX,ID,PQA,IPQA,IERROR)
      IF (IERROR.NE.0) RETURN
      GO TO 390
C
C        FIXED MU, VARIABLE NU
C        CALL DXPQNU TO CALCULATE P(-MU,DNU1,X),....,P(-MU,DNU2,X)
C
  360 CALL DXPQNU(DNU1,DNU2,MU1,THETA,ID,PQA,IPQA,IERROR)
      IF (IERROR.NE.0) RETURN
C
C        IF ID = 3, TRANSFORM P(-MU,NU,X) VECTOR INTO
C        P(MU,NU,X) VECTOR.
C
  380 IF(ID.EQ.3) CALL DXPMUP(DNU1,DNU2,MU1,MU2,PQA,IPQA,IERROR)
      IF (IERROR.NE.0) RETURN
C
C        IF ID = 4, TRANSFORM P(-MU,NU,X) VECTOR INTO
C        NORMALIZED P(MU,NU,X) VECTOR.
C
      IF(ID.EQ.4) CALL DXPNRM(DNU1,DNU2,MU1,MU2,PQA,IPQA,IERROR)
      IF (IERROR.NE.0) RETURN
C
C        PLACE RESULTS IN REDUCED FORM IF POSSIBLE
C        AND RETURN TO MAIN PROGRAM.
C
  390 DO 395 I=1,L
      CALL DXRED(PQA(I),IPQA(I),IERROR)
      IF (IERROR.NE.0) RETURN
  395 CONTINUE
      RETURN
C
C        *****     ERROR TERMINATION     *****
C
  400 CONTINUE
CCCCC CALL XERMSG ('SLATEC', 'DXLEGF',
CCCCC+             'DNU1, NUDIFF, MU1, MU2, or ID not valid', 210, 1)
      WRITE(ICOUT,901)
      CALL DPWRST('XXX','BUG ')
  901 FORMAT('***** ERROR FROM DXLEGF, INVALID INPUT ARGUMENTS.')
      IERROR=210
      RETURN
  420 CONTINUE
CCCCC CALL XERMSG ('SLATEC', 'DXLEGF', 'THETA out of range', 211, 1)
      WRITE(ICOUT,902)
      CALL DPWRST('XXX','BUG ')
  902 FORMAT('***** ERROR FROM DXLEGF, THETA OUT OF RANGE.')
      IERROR=211
      RETURN
      END
      SUBROUTINE DXNRMP (NU, MU1, MU2, DARG, MODE, DPN, IPN, ISIG,
     1   IERROR)
C***BEGIN PROLOGUE  DXNRMP
C***PURPOSE  Compute normalized Legendre polynomials.
C***LIBRARY   SLATEC
C***CATEGORY  C3A2, C9
C***TYPE      DOUBLE PRECISION (XNRMP-S, DXNRMP-D)
C***KEYWORDS  LEGENDRE FUNCTIONS
C***AUTHOR  Lozier, Daniel W., (NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY)
C           Smith, John M., (NBS and George Mason University)
C***DESCRIPTION
C
C        SUBROUTINE TO CALCULATE NORMALIZED LEGENDRE POLYNOMIALS
C        (XNRMP is single-precision version)
C        DXNRMP calculates normalized Legendre polynomials of varying
C        order and fixed argument and degree. The order MU and degree
C        NU are non-negative integers and the argument is real. Because
C        the algorithm requires the use of numbers outside the normal
C        machine range, this subroutine employs a special arithmetic
C        called extended-range arithmetic. See J.M. Smith, F.W.J. Olver,
C        and D.W. Lozier, Extended-Range Arithmetic and Normalized
C        Legendre Polynomials, ACM Transactions on Mathematical Soft-
C        ware, 93-105, March 1981, for a complete description of the
C        algorithm and special arithmetic. Also see program comments
C        in DXSET.
C
C        The normalized Legendre polynomials are multiples of the
C        associated Legendre polynomials of the first kind where the
C        normalizing coefficients are chosen so as to make the integral
C        from -1 to 1 of the square of each function equal to 1. See
C        E. Jahnke, F. Emde and F. Losch, Tables of Higher Functions,
C        McGraw-Hill, New York, 1960, p. 121.
C
C        The input values to DXNRMP are NU, MU1, MU2, DARG, and MODE.
C        These must satisfy
C          1. NU .GE. 0 specifies the degree of the normalized Legendre
C             polynomial that is wanted.
C          2. MU1 .GE. 0 specifies the lowest-order normalized Legendre
C             polynomial that is wanted.
C          3. MU2 .GE. MU1 specifies the highest-order normalized Leg-
C             endre polynomial that is wanted.
C         4a. MODE = 1 and -1.0D0 .LE. DARG .LE. 1.0D0 specifies that
C             Normalized Legendre(NU, MU, DARG) is wanted for MU = MU1,
C             MU1 + 1, ..., MU2.
C         4b. MODE = 2 and -3.14159... .LT. DARG .LT. 3.14159... spec-
C             ifies that Normalized Legendre(NU, MU, COS(DARG)) is
C             wanted for MU = MU1, MU1 + 1, ..., MU2.
C
C        The output of DXNRMP consists of the two vectors DPN and IPN
C        and the error estimate ISIG. The computed values are stored as
C        extended-range numbers such that
C             (DPN(1),IPN(1))=NORMALIZED LEGENDRE(NU,MU1,DX)
C             (DPN(2),IPN(2))=NORMALIZED LEGENDRE(NU,MU1+1,DX)
C                .
C                .
C             (DPN(K),IPN(K))=NORMALIZED LEGENDRE(NU,MU2,DX)
C        where K = MU2 - MU1 + 1 and DX = DARG or COS(DARG) according
C        to whether MODE = 1 or 2. Finally, ISIG is an estimate of the
C        number of decimal digits lost through rounding errors in the
C        computation. For example if DARG is accurate to 12 significant
C        decimals, then the computed function values are accurate to
C        12 - ISIG significant decimals (except in neighborhoods of
C        zeros).
C
C        The interpretation of (DPN(I),IPN(I)) is DPN(I)*(IR**IPN(I))
C        where IR is the internal radix of the computer arithmetic. When
C        IPN(I) = 0 the value of the normalized Legendre polynomial is
C        contained entirely in DPN(I) and subsequent double-precision
C        computations can be performed without further consideration of
C        extended-range arithmetic. However, if IPN(I) .NE. 0 the corre-
C        sponding value of the normalized Legendre polynomial cannot be
C        represented in double-precision because of overflow or under-
C        flow. THE USER MUST TEST IPN(I) IN HIS/HER PROGRAM. In the case
C        that IPN(I) is nonzero, the user could rewrite his/her program
C        to use extended range arithmetic.
C
C
C
C        The interpretation of (DPN(I),IPN(I)) can be changed to
C        DPN(I)*(10**IPN(I)) by calling the extended-range subroutine
C        DXCON. This should be done before printing the computed values.
C        As an example of usage, the Fortran coding
C              J = K
C              DO 20 I = 1, K
C              CALL DXCON(DPN(I), IPN(I),IERROR)
C              IF (IERROR.NE.0) RETURN
C              PRINT 10, DPN(I), IPN(I)
C           10 FORMAT(1X, D30.18 , I15)
C              IF ((IPN(I) .EQ. 0) .OR. (J .LT. K)) GO TO 20
C              J = I - 1
C           20 CONTINUE
C        will print all computed values and determine the largest J
C        such that IPN(1) = IPN(2) = ... = IPN(J) = 0. Because of the
C        change of representation caused by calling DXCON, (DPN(I),
C        IPN(I)) for I = J+1, J+2, ... cannot be used in subsequent
C        extended-range computations.
C
C        IERROR is an error indicator. If no errors are detected,
C        IERROR=0 when control returns to the calling routine. If
C        an error is detected, IERROR is returned as nonzero. The
C        calling routine must check the value of IERROR.
C
C        If IERROR=212 or 213, invalid input was provided to DXNRMP.
C        If IERROR=201,202,203, or 204, invalid input was provided
C        to DXSET.
C        If IERROR=205 or 206, an internal consistency error occurred
C        in DXSET (probably due to a software malfunction in the
C        library routine I1MACH).
C        If IERROR=207, an overflow or underflow of an extended-range
C        number was detected in DXADJ.
C        If IERROR=208, an overflow or underflow of an extended-range
C        number was detected in DXC210.
C
C***SEE ALSO  DXSET
C***REFERENCES  Smith, Olver and Lozier, Extended-Range Arithmetic and
C                 Normalized Legendre Polynomials, ACM Trans on Math
C                 Softw, v 7, n 1, March 1981, pp 93--105.
C***ROUTINES CALLED  DXADD, DXADJ, DXRED, DXSET, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   820712  DATE WRITTEN
C   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS)
C   901019  Revisions to prologue.  (DWL and WRB)
C   901106  Changed all specific intrinsics to generic.  (WRB)
C           Corrected order of sections in prologue and added TYPE
C           section.  (WRB)
C           CALLs to XERROR changed to CALLs to XERMSG.  (WRB)
C   920127  Revised PURPOSE section of prologue.  (DWL)
C***END PROLOGUE  DXNRMP
      INTEGER NU, MU1, MU2, MODE, IPN, ISIG
      DOUBLE PRECISION DARG, DPN
      DIMENSION DPN(*), IPN(*)
      DOUBLE PRECISION C1,C2,P,P1,P2,P3,S,SX,T,TX,X,DK
C
C-----COMMON----------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C CALL DXSET TO INITIALIZE EXTENDED-RANGE ARITHMETIC (SEE DXSET
C LISTING FOR DETAILS)
C***FIRST EXECUTABLE STATEMENT  DXNRMP
      IERROR=0
      CALL DXSET (0, 0, 0.0D0, 0,IERROR)
      IF (IERROR.NE.0) RETURN
C
C        TEST FOR PROPER INPUT VALUES.
C
      IF (NU.LT.0) GO TO 110
      IF (MU1.LT.0) GO TO 110
      IF (MU1.GT.MU2) GO TO 110
      IF (NU.EQ.0) GO TO 90
      IF (MODE.LT.1 .OR. MODE.GT.2) GO TO 110
      GO TO (10, 20), MODE
   10 IF (ABS(DARG).GT.1.0D0) GO TO 120
      IF (ABS(DARG).EQ.1.0D0) GO TO 90
      X = DARG
      SX = SQRT((1.0D0+ABS(X))*((0.5D0-ABS(X))+0.5D0))
      TX = X/SX
      ISIG = LOG10(2.0D0*NU*(5.0D0+TX**2))
      GO TO 30
   20 IF (ABS(DARG).GT.4.0D0*ATAN(1.0D0)) GO TO 120
      IF (DARG.EQ.0.0D0) GO TO 90
      X = COS(DARG)
      SX = ABS(SIN(DARG))
      TX = X/SX
      ISIG = LOG10(2.0D0*NU*(5.0D0+ABS(DARG*TX)))
C
C        BEGIN CALCULATION
C
   30 MU = MU2
      I = MU2 - MU1 + 1
C
C        IF MU.GT.NU, NORMALIZED LEGENDRE(NU,MU,X)=0.
C
   40 IF (MU.LE.NU) GO TO 50
      DPN(I) = 0.0D0
      IPN(I) = 0
      I = I - 1
      MU = MU - 1
      IF (I .GT. 0) GO TO 40
      ISIG = 0
      GO TO 160
   50 MU = NU
C
C        P1 = 0. = NORMALIZED LEGENDRE(NU,NU+1,X)
C
      P1 = 0.0D0
      IP1 = 0
C
C        CALCULATE P2 = NORMALIZED LEGENDRE(NU,NU,X)
C
      P2 = 1.0D0
      IP2 = 0
      P3 = 0.5D0
      DK = 2.0D0
      DO 60 J=1,NU
        P3 = ((DK+1.0D0)/DK)*P3
        P2 = P2*SX
        CALL DXADJ(P2, IP2,IERROR)
        IF (IERROR.NE.0) RETURN
        DK = DK + 2.0D0
   60 CONTINUE
      P2 = P2*SQRT(P3)
      CALL DXADJ(P2, IP2,IERROR)
      IF (IERROR.NE.0) RETURN
      S = 2.0D0*TX
      T = 1.0D0/NU
      IF (MU2.LT.NU) GO TO 70
      DPN(I) = P2
      IPN(I) = IP2
      I = I - 1
      IF (I .EQ. 0) GO TO 140
C
C        RECURRENCE PROCESS
C
   70 P = MU*T
      C1 = 1.0D0/SQRT((1.0D0-P+T)*(1.0D0+P))
      C2 = S*P*C1*P2
      C1 = -SQRT((1.0D0+P+T)*(1.0D0-P))*C1*P1
      CALL DXADD(C2, IP2, C1, IP1, P, IP,IERROR)
      IF (IERROR.NE.0) RETURN
      MU = MU - 1
      IF (MU.GT.MU2) GO TO 80
C
C        STORE IN ARRAY DPN FOR RETURN TO CALLING ROUTINE.
C
      DPN(I) = P
      IPN(I) = IP
      I = I - 1
      IF (I .EQ. 0) GO TO 140
   80 P1 = P2
      IP1 = IP2
      P2 = P
      IP2 = IP
      IF (MU.LE.MU1) GO TO 140
      GO TO 70
C
C        SPECIAL CASE WHEN X=-1 OR +1, OR NU=0.
C
   90 K = MU2 - MU1 + 1
      DO 100 I=1,K
        DPN(I) = 0.0D0
        IPN(I) = 0
  100 CONTINUE
      ISIG = 0
      IF (MU1.GT.0) GO TO 160
      ISIG = 1
      DPN(1) = SQRT(NU+0.5D0)
      IPN(1) = 0
      IF (MOD(NU,2).EQ.0) GO TO 160
      IF (MODE.EQ.1 .AND. DARG.EQ.1.0D0) GO TO 160
      IF (MODE.EQ.2) GO TO 160
      DPN(1) = -DPN(1)
      GO TO 160
C
C          ERROR PRINTOUTS AND TERMINATION.
C
  110 CONTINUE
CCCCC CALL XERMSG ('SLATEC', 'DXNRMP', 'NU, MU1, MU2 or MODE not valid',
CCCCC+             212, 1)
      WRITE(ICOUT,901)
      CALL DPWRST('XXX','BUG ')
  901 FORMAT('***** ERROR FROM DXNRMP, INVALID INOUT ARGUMENTS.')
      IERROR=212
      RETURN
  120 CONTINUE
CCCCC CALL XERMSG ('SLATEC', 'DXNRMP', 'DARG out of range', 213, 1)
      WRITE(ICOUT,902)
      CALL DPWRST('XXX','BUG ')
  902 FORMAT('***** ERROR FROM DXNRMP, FIRST ARGUMENT OUT OF RANGE.')
      IERROR=213
      RETURN
C
C        RETURN TO CALLING PROGRAM
C
  140 K = MU2 - MU1 + 1
      DO 150 I=1,K
        CALL DXRED(DPN(I),IPN(I),IERROR)
        IF (IERROR.NE.0) RETURN
  150 CONTINUE
  160 RETURN
      END
      SUBROUTINE DXPMU (NU1, NU2, MU1, MU2, THETA, X, SX, ID, PQA, IPQA,
     1   IERROR)
C***BEGIN PROLOGUE  DXPMU
C***SUBSIDIARY
C***PURPOSE  To compute the values of Legendre functions for DXLEGF.
C            Method: backward mu-wise recurrence for P(-MU,NU,X) for
C            fixed nu to obtain P(-MU2,NU1,X), P(-(MU2-1),NU1,X), ...,
C            P(-MU1,NU1,X) and store in ascending mu order.
C***LIBRARY   SLATEC
C***CATEGORY  C3A2, C9
C***TYPE      DOUBLE PRECISION (XPMU-S, DXPMU-D)
C***KEYWORDS  LEGENDRE FUNCTIONS
C***AUTHOR  Smith, John M., (NBS and George Mason University)
C***ROUTINES CALLED  DXADD, DXADJ, DXPQNU
C***REVISION HISTORY  (YYMMDD)
C   820728  DATE WRITTEN
C   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS)
C   901019  Revisions to prologue.  (DWL and WRB)
C   901106  Changed all specific intrinsics to generic.  (WRB)
C           Corrected order of sections in prologue and added TYPE
C           section.  (WRB)
C   920127  Revised PURPOSE section of prologue.  (DWL)
C***END PROLOGUE  DXPMU
      DOUBLE PRECISION PQA,NU1,NU2,P0,X,SX,THETA,X1,X2
      DIMENSION PQA(*),IPQA(*)
C
C        CALL DXPQNU TO OBTAIN P(-MU2,NU,X)
C
C***FIRST EXECUTABLE STATEMENT  DXPMU
      IERROR=0
      CALL DXPQNU(NU1,NU2,MU2,THETA,ID,PQA,IPQA,IERROR)
      IF (IERROR.NE.0) RETURN
      P0=PQA(1)
      IP0=IPQA(1)
      MU=MU2-1
C
C        CALL DXPQNU TO OBTAIN P(-MU2-1,NU,X)
C
      CALL DXPQNU(NU1,NU2,MU,THETA,ID,PQA,IPQA,IERROR)
      IF (IERROR.NE.0) RETURN
      N=MU2-MU1+1
      PQA(N)=P0
      IPQA(N)=IP0
      IF(N.EQ.1) GO TO 300
      PQA(N-1)=PQA(1)
      IPQA(N-1)=IPQA(1)
      IF(N.EQ.2) GO TO 300
      J=N-2
  290 CONTINUE
C
C        BACKWARD RECURRENCE IN MU TO OBTAIN
C              P(-MU2,NU1,X),P(-(MU2-1),NU1,X),....P(-MU1,NU1,X)
C              USING
C              (NU-MU)*(NU+MU+1.)*P(-(MU+1),NU,X)=
C                2.*MU*X*SQRT((1./(1.-X**2))*P(-MU,NU,X)-P(-(MU-1),NU,X)
C
      X1=2.D0*MU*X*SX*PQA(J+1)
      X2=-(NU1-MU)*(NU1+MU+1.D0)*PQA(J+2)
      CALL DXADD(X1,IPQA(J+1),X2,IPQA(J+2),PQA(J),IPQA(J),IERROR)
      IF (IERROR.NE.0) RETURN
      CALL DXADJ(PQA(J),IPQA(J),IERROR)
      IF (IERROR.NE.0) RETURN
      IF(J.EQ.1) GO TO 300
      J=J-1
      MU=MU-1
      GO TO 290
  300 RETURN
      END
      SUBROUTINE DXPMUP (NU1, NU2, MU1, MU2, PQA, IPQA, IERROR)
C***BEGIN PROLOGUE  DXPMUP
C***SUBSIDIARY
C***PURPOSE  To compute the values of Legendre functions for DXLEGF.
C            This subroutine transforms an array of Legendre functions
C            of the first kind of negative order stored in array PQA
C            into Legendre functions of the first kind of positive
C            order stored in array PQA. The original array is destroyed.
C***LIBRARY   SLATEC
C***CATEGORY  C3A2, C9
C***TYPE      DOUBLE PRECISION (XPMUP-S, DXPMUP-D)
C***KEYWORDS  LEGENDRE FUNCTIONS
C***AUTHOR  Smith, John M., (NBS and George Mason University)
C***ROUTINES CALLED  DXADJ
C***REVISION HISTORY  (YYMMDD)
C   820728  DATE WRITTEN
C   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS)
C   901019  Revisions to prologue.  (DWL and WRB)
C   901106  Changed all specific intrinsics to generic.  (WRB)
C           Corrected order of sections in prologue and added TYPE
C           section.  (WRB)
C   920127  Revised PURPOSE section of prologue.  (DWL)
C***END PROLOGUE  DXPMUP
      DOUBLE PRECISION DMU,NU,NU1,NU2,PQA,PROD
      DIMENSION PQA(*),IPQA(*)
C***FIRST EXECUTABLE STATEMENT  DXPMUP
      IERROR=0
      NU=NU1
      MU=MU1
      DMU=MU
      N=INT(NU2-NU1+.1D0)+(MU2-MU1)+1
      J=1
      IF(MOD(REAL(NU),1.).NE.0.) GO TO 210
  200 IF(DMU.LT.NU+1.D0) GO TO 210
      PQA(J)=0.D0
      IPQA(J)=0
      J=J+1
      IF(J.GT.N) RETURN
C        INCREMENT EITHER MU OR NU AS APPROPRIATE.
      IF(NU2-NU1.GT..5D0) NU=NU+1.D0
      IF(MU2.GT.MU1) MU=MU+1
      GO TO 200
C
C        TRANSFORM P(-MU,NU,X) TO P(MU,NU,X) USING
C        P(MU,NU,X)=(NU-MU+1)*(NU-MU+2)*...*(NU+MU)*P(-MU,NU,X)*(-1)**MU
C
  210 PROD=1.D0
      IPROD=0
      K=2*MU
      IF(K.EQ.0) GO TO 222
      DO 220 L=1,K
      PROD=PROD*(DMU-NU-L)
  220 CALL DXADJ(PROD,IPROD,IERROR)
      IF (IERROR.NE.0) RETURN
  222 CONTINUE
      DO 240 I=J,N
      IF(MU.EQ.0) GO TO 225
      PQA(I)=PQA(I)*PROD*(-1)**MU
      IPQA(I)=IPQA(I)+IPROD
      CALL DXADJ(PQA(I),IPQA(I),IERROR)
      IF (IERROR.NE.0) RETURN
  225 IF(NU2-NU1.GT..5D0) GO TO 230
      PROD=(DMU-NU)*PROD*(-DMU-NU-1.D0)
      CALL DXADJ(PROD,IPROD,IERROR)
      IF (IERROR.NE.0) RETURN
      MU=MU+1
      DMU=DMU+1.D0
      GO TO 240
  230 PROD=PROD*(-DMU-NU-1.D0)/(DMU-NU-1.D0)
      CALL DXADJ(PROD,IPROD,IERROR)
      IF (IERROR.NE.0) RETURN
      NU=NU+1.D0
  240 CONTINUE
      RETURN
      END
      SUBROUTINE DXPNRM (NU1, NU2, MU1, MU2, PQA, IPQA, IERROR)
C***BEGIN PROLOGUE  DXPNRM
C***SUBSIDIARY
C***PURPOSE  To compute the values of Legendre functions for DXLEGF.
C            This subroutine transforms an array of Legendre functions
C            of the first kind of negative order stored in array PQA
C            into normalized Legendre polynomials stored in array PQA.
C            The original array is destroyed.
C***LIBRARY   SLATEC
C***CATEGORY  C3A2, C9
C***TYPE      DOUBLE PRECISION (XPNRM-S, DXPNRM-D)
C***KEYWORDS  LEGENDRE FUNCTIONS
C***AUTHOR  Smith, John M., (NBS and George Mason University)
C***ROUTINES CALLED  DXADJ
C***REVISION HISTORY  (YYMMDD)
C   820728  DATE WRITTEN
C   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS)
C   901019  Revisions to prologue.  (DWL and WRB)
C   901106  Changed all specific intrinsics to generic.  (WRB)
C           Corrected order of sections in prologue and added TYPE
C           section.  (WRB)
C   920127  Revised PURPOSE section of prologue.  (DWL)
C***END PROLOGUE  DXPNRM
      DOUBLE PRECISION C1,DMU,NU,NU1,NU2,PQA,PROD
      DIMENSION PQA(*),IPQA(*)
C***FIRST EXECUTABLE STATEMENT  DXPNRM
      IERROR=0
      L=(MU2-MU1)+(NU2-NU1+1.5D0)
      MU=MU1
      DMU=MU1
      NU=NU1
C
C         IF MU .GT.NU, NORM P =0.
C
      J=1
  500 IF(DMU.LE.NU) GO TO 505
      PQA(J)=0.D0
      IPQA(J)=0
      J=J+1
      IF(J.GT.L) RETURN
C
C        INCREMENT EITHER MU OR NU AS APPROPRIATE.
C
      IF(MU2.GT.MU1) DMU=DMU+1.D0
      IF(NU2-NU1.GT..5D0) NU=NU+1.D0
      GO TO 500
C
C         TRANSFORM P(-MU,NU,X) INTO NORMALIZED P(MU,NU,X) USING
C              NORM P(MU,NU,X)=
C                 SQRT((NU+.5)*FACTORIAL(NU+MU)/FACTORIAL(NU-MU))
C                              *P(-MU,NU,X)
C
  505 PROD=1.D0
      IPROD=0
      K=2*MU
      IF(K.LE.0) GO TO 520
      DO 510 I=1,K
      PROD=PROD*SQRT(NU+DMU+1.D0-I)
  510 CALL DXADJ(PROD,IPROD,IERROR)
      IF (IERROR.NE.0) RETURN
  520 DO 540 I=J,L
      C1=PROD*SQRT(NU+.5D0)
      PQA(I)=PQA(I)*C1
      IPQA(I)=IPQA(I)+IPROD
      CALL DXADJ(PQA(I),IPQA(I),IERROR)
      IF (IERROR.NE.0) RETURN
      IF(NU2-NU1.GT..5D0) GO TO 530
      IF(DMU.GE.NU) GO TO 525
      PROD=SQRT(NU+DMU+1.D0)*PROD
      IF(NU.GT.DMU) PROD=PROD*SQRT(NU-DMU)
      CALL DXADJ(PROD,IPROD,IERROR)
      IF (IERROR.NE.0) RETURN
      MU=MU+1
      DMU=DMU+1.D0
      GO TO 540
  525 PROD=0.D0
      IPROD=0
      MU=MU+1
      DMU=DMU+1.D0
      GO TO 540
  530 PROD=SQRT(NU+DMU+1.D0)*PROD
      IF(NU.NE.DMU-1.D0) PROD=PROD/SQRT(NU-DMU+1.D0)
      CALL DXADJ(PROD,IPROD,IERROR)
      IF (IERROR.NE.0) RETURN
      NU=NU+1.D0
  540 CONTINUE
      RETURN
      END
      SUBROUTINE DXPQNU (NU1, NU2, MU, THETA, ID, PQA, IPQA, IERROR)
C***BEGIN PROLOGUE  DXPQNU
C***SUBSIDIARY
C***PURPOSE  To compute the values of Legendre functions for DXLEGF.
C            This subroutine calculates initial values of P or Q using
C            power series, then performs forward nu-wise recurrence to
C            obtain P(-MU,NU,X), Q(0,NU,X), or Q(1,NU,X). The nu-wise
C            recurrence is stable for P for all mu and for Q for mu=0,1.
C***LIBRARY   SLATEC
C***CATEGORY  C3A2, C9
C***TYPE      DOUBLE PRECISION (XPQNU-S, DXPQNU-D)
C***KEYWORDS  LEGENDRE FUNCTIONS
C***AUTHOR  Smith, John M., (NBS and George Mason University)
C***ROUTINES CALLED  DXADD, DXADJ, DXPSI
C***COMMON BLOCKS    DXBLK1
C***REVISION HISTORY  (YYMMDD)
C   820728  DATE WRITTEN
C   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS)
C   901019  Revisions to prologue.  (DWL and WRB)
C   901106  Changed all specific intrinsics to generic.  (WRB)
C           Corrected order of sections in prologue and added TYPE
C           section.  (WRB)
C   920127  Revised PURPOSE section of prologue.  (DWL)
C***END PROLOGUE  DXPQNU
      DOUBLE PRECISION A,NU,NU1,NU2,PQ,PQA,DXPSI,R,THETA,W,X,X1,X2,XS,
     1 Y,Z
      DOUBLE PRECISION DI,DMU,PQ1,PQ2,FACTMU,FLOK
      DIMENSION PQA(*),IPQA(*)
      COMMON /DXBLK1/ NBITSF
      SAVE /DXBLK1/
C
C        J0, IPSIK, AND IPSIX ARE INITIALIZED IN THIS SUBROUTINE.
C        J0 IS THE NUMBER OF TERMS USED IN SERIES EXPANSION
C        IN SUBROUTINE DXPQNU.
C        IPSIK, IPSIX ARE VALUES OF K AND X RESPECTIVELY
C        USED IN THE CALCULATION OF THE DXPSI FUNCTION.
C
C***FIRST EXECUTABLE STATEMENT  DXPQNU
      IERROR=0
      J0=NBITSF
      IPSIK=1+(NBITSF/10)
      IPSIX=5*IPSIK
      IPQ=0
C        FIND NU IN INTERVAL [-.5,.5) IF ID=2  ( CALCULATION OF Q )
      NU=MOD(NU1,1.D0)
      IF(NU.GE..5D0) NU=NU-1.D0
C        FIND NU IN INTERVAL (-1.5,-.5] IF ID=1,3, OR 4  ( CALC. OF P )
      IF(ID.NE.2.AND.NU.GT.-.5D0) NU=NU-1.D0
C        CALCULATE MU FACTORIAL
      K=MU
      DMU=MU
      IF(MU.LE.0) GO TO 60
      FACTMU=1.D0
      IF=0
      DO 50 I=1,K
      FACTMU=FACTMU*I
   50 CALL DXADJ(FACTMU,IF,IERROR)
      IF (IERROR.NE.0) RETURN
   60 IF(K.EQ.0) FACTMU=1.D0
      IF(K.EQ.0) IF=0
C
C        X=COS(THETA)
C        Y=SIN(THETA/2)**2=(1-X)/2=.5-.5*X
C        R=TAN(THETA/2)=SQRT((1-X)/(1+X)
C
      X=COS(THETA)
      Y=SIN(THETA/2.D0)**2
      R=TAN(THETA/2.D0)
C
C        USE ASCENDING SERIES TO CALCULATE TWO VALUES OF P OR Q
C        FOR USE AS STARTING VALUES IN RECURRENCE RELATION.
C
      PQ2=0.0D0
      DO 100 J=1,2
      IPQ1=0
      IF(ID.EQ.2) GO TO 80
C
C        SERIES FOR P ( ID = 1, 3, OR 4 )
C        P(-MU,NU,X)=1./FACTORIAL(MU)*SQRT(((1.-X)/(1.+X))**MU)
C                *SUM(FROM 0 TO J0-1)A(J)*(.5-.5*X)**J
C
      IPQ=0
      PQ=1.D0
      A=1.D0
      IA=0
      DO 65 I=2,J0
      DI=I
      A=A*Y*(DI-2.D0-NU)*(DI-1.D0+NU)/((DI-1.D0+DMU)*(DI-1.D0))
      CALL DXADJ(A,IA,IERROR)
      IF (IERROR.NE.0) RETURN
      IF(A.EQ.0.D0) GO TO 66
      CALL DXADD(PQ,IPQ,A,IA,PQ,IPQ,IERROR)
      IF (IERROR.NE.0) RETURN
   65 CONTINUE
   66 CONTINUE
      IF(MU.LE.0) GO TO 90
      X2=R
      X1=PQ
      K=MU
      DO 77 I=1,K
      X1=X1*X2
   77 CALL DXADJ(X1,IPQ,IERROR)
      IF (IERROR.NE.0) RETURN
      PQ=X1/FACTMU
      IPQ=IPQ-IF
      CALL DXADJ(PQ,IPQ,IERROR)
      IF (IERROR.NE.0) RETURN
      GO TO 90
C
C        Z=-LN(R)=.5*LN((1+X)/(1-X))
C
   80 Z=-LOG(R)
      W=DXPSI(NU+1.D0,IPSIK,IPSIX)
      XS=1.D0/SIN(THETA)
C
C        SERIES SUMMATION FOR Q ( ID = 2 )
C        Q(0,NU,X)=SUM(FROM 0 TO J0-1)((.5*LN((1+X)/(1-X))
C    +DXPSI(J+1,IPSIK,IPSIX)-DXPSI(NU+1,IPSIK,IPSIX)))*A(J)*(.5-.5*X)**J
C
C        Q(1,NU,X)=-SQRT(1./(1.-X**2))+SQRT((1-X)/(1+X))
C             *SUM(FROM 0 T0 J0-1)(-NU*(NU+1)/2*LN((1+X)/(1-X))
C                 +(J-NU)*(J+NU+1)/(2*(J+1))+NU*(NU+1)*
C     (DXPSI(NU+1,IPSIK,IPSIX)-DXPSI(J+1,IPSIK,IPSIX))*A(J)*(.5-.5*X)**J
C
C        NOTE, IN THIS LOOP K=J+1
C
      PQ=0.D0
      IPQ=0
      IA=0
      A=1.D0
      DO 85 K=1,J0
      FLOK=K
      IF(K.EQ.1) GO TO 81
      A=A*Y*(FLOK-2.D0-NU)*(FLOK-1.D0+NU)/((FLOK-1.D0+DMU)*(FLOK-1.D0))
      CALL DXADJ(A,IA,IERROR)
      IF (IERROR.NE.0) RETURN
   81 CONTINUE
      IF(MU.GE.1) GO TO 83
      X1=(DXPSI(FLOK,IPSIK,IPSIX)-W+Z)*A
      IX1=IA
      CALL DXADD(PQ,IPQ,X1,IX1,PQ,IPQ,IERROR)
      IF (IERROR.NE.0) RETURN
      GO TO 85
   83 X1=(NU*(NU+1.D0)*(Z-W+DXPSI(FLOK,IPSIK,IPSIX))+(NU-FLOK+1.D0)
     1  *(NU+FLOK)/(2.D0*FLOK))*A
      IX1=IA
      CALL DXADD(PQ,IPQ,X1,IX1,PQ,IPQ,IERROR)
      IF (IERROR.NE.0) RETURN
   85 CONTINUE
      IF(MU.GE.1) PQ=-R*PQ
      IXS=0
      IF(MU.GE.1) CALL DXADD(PQ,IPQ,-XS,IXS,PQ,IPQ,IERROR)
      IF (IERROR.NE.0) RETURN
      IF(J.EQ.2) MU=-MU
      IF(J.EQ.2) DMU=-DMU
   90 IF(J.EQ.1) PQ2=PQ
      IF(J.EQ.1) IPQ2=IPQ
      NU=NU+1.D0
  100 CONTINUE
      K=0
      IF(NU-1.5D0.LT.NU1) GO TO 120
      K=K+1
      PQA(K)=PQ2
      IPQA(K)=IPQ2
      IF(NU.GT.NU2+.5D0) RETURN
  120 PQ1=PQ
      IPQ1=IPQ
      IF(NU.LT.NU1+.5D0) GO TO 130
      K=K+1
      PQA(K)=PQ
      IPQA(K)=IPQ
      IF(NU.GT.NU2+.5D0) RETURN
C
C        FORWARD NU-WISE RECURRENCE FOR F(MU,NU,X) FOR FIXED MU
C        USING
C        (NU+MU+1)*F(MU,NU,X)=(2.*NU+1)*F(MU,NU,X)-(NU-MU)*F(MU,NU-1,X)
C        WHERE F(MU,NU,X) MAY BE P(-MU,NU,X) OR IF MU IS REPLACED
C        BY -MU THEN F(MU,NU,X) MAY BE Q(MU,NU,X).
C        NOTE, IN THIS LOOP, NU=NU+1
C
  130 X1=(2.D0*NU-1.D0)/(NU+DMU)*X*PQ1
      X2=(NU-1.D0-DMU)/(NU+DMU)*PQ2
      CALL DXADD(X1,IPQ1,-X2,IPQ2,PQ,IPQ,IERROR)
      IF (IERROR.NE.0) RETURN
      CALL DXADJ(PQ,IPQ,IERROR)
      IF (IERROR.NE.0) RETURN
      NU=NU+1.D0
      PQ2=PQ1
      IPQ2=IPQ1
      GO TO 120
C
      END
      DOUBLE PRECISION FUNCTION DXPSI (A, IPSIK, IPSIX)
C***BEGIN PROLOGUE  DXPSI
C***SUBSIDIARY
C***PURPOSE  To compute values of the Psi function for DXLEGF.
C***LIBRARY   SLATEC
C***CATEGORY  C7C
C***TYPE      DOUBLE PRECISION (XPSI-S, DXPSI-D)
C***KEYWORDS  PSI FUNCTION
C***AUTHOR  Smith, John M., (NBS and George Mason University)
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   820728  DATE WRITTEN
C   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS)
C   901019  Revisions to prologue.  (DWL and WRB)
C   901106  Changed all specific intrinsics to generic.  (WRB)
C           Corrected order of sections in prologue and added TYPE
C           section.  (WRB)
C   920127  Revised PURPOSE section of prologue.  (DWL)
C***END PROLOGUE  DXPSI
      DOUBLE PRECISION A,B,C,CNUM,CDENOM
      DIMENSION CNUM(12),CDENOM(12)
      SAVE CNUM, CDENOM
C
C        CNUM(I) AND CDENOM(I) ARE THE ( REDUCED ) NUMERATOR
C        AND 2*I*DENOMINATOR RESPECTIVELY OF THE 2*I TH BERNOULLI
C        NUMBER.
C
      DATA CNUM(1),CNUM(2),CNUM(3),CNUM(4),CNUM(5),CNUM(6),CNUM(7),
     1CNUM(8),CNUM(9),CNUM(10),CNUM(11),CNUM(12)
     2    / 1.D0,     -1.D0,    1.D0,     -1.D0, 1.D0,
     3   -691.D0,  1.D0,     -3617.D0, 43867.D0, -174611.D0, 77683.D0,
     4   -236364091.D0/
      DATA CDENOM(1),CDENOM(2),CDENOM(3),CDENOM(4),CDENOM(5),CDENOM(6),
     1 CDENOM(7),CDENOM(8),CDENOM(9),CDENOM(10),CDENOM(11),CDENOM(12)
     2/12.D0,120.D0,   252.D0,   240.D0,132.D0,
     3  32760.D0, 12.D0,  8160.D0, 14364.D0, 6600.D0, 276.D0, 65520.D0/
C***FIRST EXECUTABLE STATEMENT  DXPSI
      N=MAX(0,IPSIX-INT(A))
      B=N+A
      K1=IPSIK-1
C
C        SERIES EXPANSION FOR A .GT. IPSIX USING IPSIK-1 TERMS.
C
      C=0.D0
      DO 12 I=1,K1
      K=IPSIK-I
   12 C=(C+CNUM(K)/CDENOM(K))/B**2
      DXPSI=LOG(B)-(C+.5D0/B)
      IF(N.EQ.0) GO TO 20
      B=0.D0
C
C        RECURRENCE FOR A .LE. IPSIX.
C
      DO 15 M=1,N
   15 B=B+1.D0/(N-M+A)
      DXPSI=DXPSI-B
   20 RETURN
      END
      SUBROUTINE DXQMU (NU1, NU2, MU1, MU2, THETA, X, SX, ID, PQA, IPQA,
     1   IERROR)
C***BEGIN PROLOGUE  DXQMU
C***SUBSIDIARY
C***PURPOSE  To compute the values of Legendre functions for DXLEGF.
C            Method: forward mu-wise recurrence for Q(MU,NU,X) for fixed
C            nu to obtain Q(MU1,NU,X), Q(MU1+1,NU,X), ..., Q(MU2,NU,X).
C***LIBRARY   SLATEC
C***CATEGORY  C3A2, C9
C***TYPE      DOUBLE PRECISION (XQMU-S, DXQMU-D)
C***KEYWORDS  LEGENDRE FUNCTIONS
C***AUTHOR  Smith, John M., (NBS and George Mason University)
C***ROUTINES CALLED  DXADD, DXADJ, DXPQNU
C***REVISION HISTORY  (YYMMDD)
C   820728  DATE WRITTEN
C   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS)
C   901019  Revisions to prologue.  (DWL and WRB)
C   901106  Corrected order of sections in prologue and added TYPE
C           section.  (WRB)
C   920127  Revised PURPOSE section of prologue.  (DWL)
C***END PROLOGUE  DXQMU
      DIMENSION PQA(*),IPQA(*)
      DOUBLE PRECISION DMU,NU,NU1,NU2,PQ,PQA,PQ1,PQ2,SX,X,X1,X2
      DOUBLE PRECISION THETA
C***FIRST EXECUTABLE STATEMENT  DXQMU
      IERROR=0
      MU=0
C
C        CALL DXPQNU TO OBTAIN Q(0.,NU1,X)
C
      CALL DXPQNU(NU1,NU2,MU,THETA,ID,PQA,IPQA,IERROR)
      IF (IERROR.NE.0) RETURN
      PQ2=PQA(1)
      IPQ2=IPQA(1)
      MU=1
C
C        CALL DXPQNU TO OBTAIN Q(1.,NU1,X)
C
      CALL DXPQNU(NU1,NU2,MU,THETA,ID,PQA,IPQA,IERROR)
      IF (IERROR.NE.0) RETURN
      NU=NU1
      K=0
      MU=1
      DMU=1.D0
      PQ1=PQA(1)
      IPQ1=IPQA(1)
      IF(MU1.GT.0) GO TO 310
      K=K+1
      PQA(K)=PQ2
      IPQA(K)=IPQ2
      IF(MU2.LT.1) GO TO 330
  310 IF(MU1.GT.1) GO TO 320
      K=K+1
      PQA(K)=PQ1
      IPQA(K)=IPQ1
      IF(MU2.LE.1) GO TO 330
  320 CONTINUE
C
C        FORWARD RECURRENCE IN MU TO OBTAIN
C                  Q(MU1,NU,X),Q(MU1+1,NU,X),....,Q(MU2,NU,X) USING
C             Q(MU+1,NU,X)=-2.*MU*X*SQRT(1./(1.-X**2))*Q(MU,NU,X)
C                               -(NU+MU)*(NU-MU+1.)*Q(MU-1,NU,X)
C
      X1=-2.D0*DMU*X*SX*PQ1
      X2=(NU+DMU)*(NU-DMU+1.D0)*PQ2
      CALL DXADD(X1,IPQ1,-X2,IPQ2,PQ,IPQ,IERROR)
      IF (IERROR.NE.0) RETURN
      CALL DXADJ(PQ,IPQ,IERROR)
      IF (IERROR.NE.0) RETURN
      PQ2=PQ1
      IPQ2=IPQ1
      PQ1=PQ
      IPQ1=IPQ
      MU=MU+1
      DMU=DMU+1.D0
      IF(MU.LT.MU1) GO TO 320
      K=K+1
      PQA(K)=PQ
      IPQA(K)=IPQ
      IF(MU2.GT.MU) GO TO 320
  330 RETURN
      END
      SUBROUTINE DXQNU (NU1, NU2, MU1, THETA, X, SX, ID, PQA, IPQA,
     1   IERROR)
C***BEGIN PROLOGUE  DXQNU
C***SUBSIDIARY
C***PURPOSE  To compute the values of Legendre functions for DXLEGF.
C            Method: backward nu-wise recurrence for Q(MU,NU,X) for
C            fixed mu to obtain Q(MU1,NU1,X), Q(MU1,NU1+1,X), ...,
C            Q(MU1,NU2,X).
C***LIBRARY   SLATEC
C***CATEGORY  C3A2, C9
C***TYPE      DOUBLE PRECISION (XQNU-S, DXQNU-D)
C***KEYWORDS  LEGENDRE FUNCTIONS
C***AUTHOR  Smith, John M., (NBS and George Mason University)
C***ROUTINES CALLED  DXADD, DXADJ, DXPQNU
C***REVISION HISTORY  (YYMMDD)
C   820728  DATE WRITTEN
C   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS)
C   901019  Revisions to prologue.  (DWL and WRB)
C   901106  Corrected order of sections in prologue and added TYPE
C           section.  (WRB)
C   920127  Revised PURPOSE section of prologue.  (DWL)
C***END PROLOGUE  DXQNU
      DIMENSION PQA(*),IPQA(*)
      DOUBLE PRECISION DMU,NU,NU1,NU2,PQ,PQA,PQ1,PQ2,SX,X,X1,X2
      DOUBLE PRECISION THETA,PQL1,PQL2
C***FIRST EXECUTABLE STATEMENT  DXQNU
      IERROR=0
      K=0
      PQ2=0.0D0
      IPQ2=0
      PQL2=0.0D0
      IPQL2=0
      IF(MU1.EQ.1) GO TO 290
      MU=0
C
C        CALL DXPQNU TO OBTAIN Q(0.,NU2,X) AND Q(0.,NU2-1,X)
C
      CALL DXPQNU(NU1,NU2,MU,THETA,ID,PQA,IPQA,IERROR)
      IF (IERROR.NE.0) RETURN
      IF(MU1.EQ.0) RETURN
      K=(NU2-NU1+1.5D0)
      PQ2=PQA(K)
      IPQ2=IPQA(K)
      PQL2=PQA(K-1)
      IPQL2=IPQA(K-1)
  290 MU=1
C
C        CALL DXPQNU TO OBTAIN Q(1.,NU2,X) AND Q(1.,NU2-1,X)
C
      CALL DXPQNU(NU1,NU2,MU,THETA,ID,PQA,IPQA,IERROR)
      IF (IERROR.NE.0) RETURN
      IF(MU1.EQ.1) RETURN
      NU=NU2
      PQ1=PQA(K)
      IPQ1=IPQA(K)
      PQL1=PQA(K-1)
      IPQL1=IPQA(K-1)
  300 MU=1
      DMU=1.D0
  320 CONTINUE
C
C        FORWARD RECURRENCE IN MU TO OBTAIN Q(MU1,NU2,X) AND
C              Q(MU1,NU2-1,X) USING
C              Q(MU+1,NU,X)=-2.*MU*X*SQRT(1./(1.-X**2))*Q(MU,NU,X)
C                   -(NU+MU)*(NU-MU+1.)*Q(MU-1,NU,X)
C
C              FIRST FOR NU=NU2
C
      X1=-2.D0*DMU*X*SX*PQ1
      X2=(NU+DMU)*(NU-DMU+1.D0)*PQ2
      CALL DXADD(X1,IPQ1,-X2,IPQ2,PQ,IPQ,IERROR)
      IF (IERROR.NE.0) RETURN
      CALL DXADJ(PQ,IPQ,IERROR)
      IF (IERROR.NE.0) RETURN
      PQ2=PQ1
      IPQ2=IPQ1
      PQ1=PQ
      IPQ1=IPQ
      MU=MU+1
      DMU=DMU+1.D0
      IF(MU.LT.MU1) GO TO 320
      PQA(K)=PQ
      IPQA(K)=IPQ
      IF(K.EQ.1) RETURN
      IF(NU.LT.NU2) GO TO 340
C
C              THEN FOR NU=NU2-1
C
      NU=NU-1.D0
      PQ2=PQL2
      IPQ2=IPQL2
      PQ1=PQL1
      IPQ1=IPQL1
      K=K-1
      GO TO 300
C
C         BACKWARD RECURRENCE IN NU TO OBTAIN
C              Q(MU1,NU1,X),Q(MU1,NU1+1,X),....,Q(MU1,NU2,X)
C              USING
C              (NU-MU+1.)*Q(MU,NU+1,X)=
C                       (2.*NU+1.)*X*Q(MU,NU,X)-(NU+MU)*Q(MU,NU-1,X)
C
  340 PQ1=PQA(K)
      IPQ1=IPQA(K)
      PQ2=PQA(K+1)
      IPQ2=IPQA(K+1)
  350 IF(NU.LE.NU1) RETURN
      K=K-1
      X1=(2.D0*NU+1.D0)*X*PQ1/(NU+DMU)
      X2=-(NU-DMU+1.D0)*PQ2/(NU+DMU)
      CALL DXADD(X1,IPQ1,X2,IPQ2,PQ,IPQ,IERROR)
      IF (IERROR.NE.0) RETURN
      CALL DXADJ(PQ,IPQ,IERROR)
      IF (IERROR.NE.0) RETURN
      PQ2=PQ1
      IPQ2=IPQ1
      PQ1=PQ
      IPQ1=IPQ
      PQA(K)=PQ
      IPQA(K)=IPQ
      NU=NU-1.D0
      GO TO 350
      END
      SUBROUTINE DXRED (X, IX, IERROR)
C***BEGIN PROLOGUE  DXRED
C***PURPOSE  To provide double-precision floating-point arithmetic
C            with an extended exponent range.
C***LIBRARY   SLATEC
C***CATEGORY  A3D
C***TYPE      DOUBLE PRECISION (XRED-S, DXRED-D)
C***KEYWORDS  EXTENDED-RANGE DOUBLE-PRECISION ARITHMETIC
C***AUTHOR  Lozier, Daniel W., (NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY)
C           Smith, John M., (NBS and George Mason University)
C***DESCRIPTION
C     DOUBLE PRECISION X
C     INTEGER IX
C
C                  IF
C                  RADIX**(-2L) .LE. (ABS(X),IX) .LE. RADIX**(2L)
C                  THEN DXRED TRANSFORMS (X,IX) SO THAT IX=0.
C                  IF (X,IX) IS OUTSIDE THE ABOVE RANGE,
C                  THEN DXRED TAKES NO ACTION.
C                  THIS SUBROUTINE IS USEFUL IF THE
C                  RESULTS OF EXTENDED-RANGE CALCULATIONS
C                  ARE TO BE USED IN SUBSEQUENT ORDINARY
C                  DOUBLE-PRECISION CALCULATIONS.
C
C***SEE ALSO  DXSET
C***REFERENCES  (NONE)
C***ROUTINES CALLED  (NONE)
C***COMMON BLOCKS    DXBLK2
C***REVISION HISTORY  (YYMMDD)
C   820712  DATE WRITTEN
C   881020  Revised to meet SLATEC CML recommendations.  (DWL and JMS)
C   901019  Revisions to prologue.  (DWL and WRB)
C   901106  Changed all specific intrinsics to generic.  (WRB)
C           Corrected order of sections in prologue and added TYPE
C           section.  (WRB)
C   920127  Revised PURPOSE section of prologue.  (DWL)
C***END PROLOGUE  DXRED
      DOUBLE PRECISION X
      INTEGER IX
      DOUBLE PRECISION RADIX, RADIXL, RAD2L, DLG10R, XA
      INTEGER L, L2, KMAX
      COMMON /DXBLK2/ RADIX, RADIXL, RAD2L, DLG10R, L, L2, KMAX
      SAVE /DXBLK2/
C
C***FIRST EXECUTABLE STATEMENT  DXRED
      IERROR=0
      IF (X.EQ.0.0D0) GO TO 90
      XA = ABS(X)
      IF (IX.EQ.0) GO TO 70
      IXA = ABS(IX)
      IXA1 = IXA/L2
      IXA2 = MOD(IXA,L2)
      IF (IX.GT.0) GO TO 40
   10 CONTINUE
      IF (XA.GT.1.0D0) GO TO 20
      XA = XA*RAD2L
      IXA1 = IXA1 + 1
      GO TO 10
   20 XA = XA/RADIX**IXA2
      IF (IXA1.EQ.0) GO TO 70
      DO 30 I=1,IXA1
        IF (XA.LT.1.0D0) GO TO 100
        XA = XA/RAD2L
   30 CONTINUE
      GO TO 70
C
   40 CONTINUE
      IF (XA.LT.1.0D0) GO TO 50
      XA = XA/RAD2L
      IXA1 = IXA1 + 1
      GO TO 40
   50 XA = XA*RADIX**IXA2
      IF (IXA1.EQ.0) GO TO 70
      DO 60 I=1,IXA1
        IF (XA.GT.1.0D0) GO TO 100
        XA = XA*RAD2L
   60 CONTINUE
   70 IF (XA.GT.RAD2L) GO TO 100
      IF (XA.GT.1.0D0) GO TO 80
      IF (RAD2L*XA.LT.1.0D0) GO TO 100
   80 X = SIGN(XA,X)
   90 IX = 0
  100 RETURN
      END
      SUBROUTINE DXSET (IRAD, NRADPL, DZERO, NBITS, IERROR)
C***BEGIN PROLOGUE  DXSET
C***PURPOSE  To provide double-precision floating-point arithmetic
C            with an extended exponent range.
C***LIBRARY   SLATEC
C***CATEGORY  A3D
C***TYPE      DOUBLE PRECISION (XSET-S, DXSET-D)
C***KEYWORDS  EXTENDED-RANGE DOUBLE-PRECISION ARITHMETIC
C***AUTHOR  Lozier, Daniel W., (NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY)
C           Smith, John M., (NBS and George Mason University)
C***DESCRIPTION
C
C   SUBROUTINE  DXSET  MUST BE CALLED PRIOR TO CALLING ANY OTHER
C EXTENDED-RANGE SUBROUTINE. IT CALCULATES AND STORES SEVERAL
C MACHINE-DEPENDENT CONSTANTS IN COMMON BLOCKS. THE USER MUST
C SUPPLY FOUR CONSTANTS THAT PERTAIN TO HIS PARTICULAR COMPUTER.
C THE CONSTANTS ARE
C
C          IRAD = THE INTERNAL BASE OF DOUBLE-PRECISION
C                 ARITHMETIC IN THE COMPUTER.
C        NRADPL = THE NUMBER OF RADIX PLACES CARRIED IN
C                 THE DOUBLE-PRECISION REPRESENTATION.
C         DZERO = THE SMALLEST OF 1/DMIN, DMAX, DMAXLN WHERE
C                 DMIN = THE SMALLEST POSITIVE DOUBLE-PRECISION
C                 NUMBER OR AN UPPER BOUND TO THIS NUMBER,
C                 DMAX = THE LARGEST DOUBLE-PRECISION NUMBER
C                 OR A LOWER BOUND TO THIS NUMBER,
C                 DMAXLN = THE LARGEST DOUBLE-PRECISION NUMBER
C                 SUCH THAT LOG10(DMAXLN) CAN BE COMPUTED BY THE
C                 FORTRAN SYSTEM (ON MOST SYSTEMS DMAXLN = DMAX).
C         NBITS = THE NUMBER OF BITS (EXCLUSIVE OF SIGN) IN
C                 AN INTEGER COMPUTER WORD.
C
C ALTERNATIVELY, ANY OR ALL OF THE CONSTANTS CAN BE GIVEN
C THE VALUE 0 (0.0D0 FOR DZERO). IF A CONSTANT IS ZERO, DXSET TRIES
C TO ASSIGN AN APPROPRIATE VALUE BY CALLING I1MACH
C (SEE P.A.FOX, A.D.HALL, N.L.SCHRYER, ALGORITHM 528 FRAMEWORK
C FOR A PORTABLE LIBRARY, ACM TRANSACTIONS ON MATH SOFTWARE,
C V.4, NO.2, JUNE 1978, 177-188).
C
C   THIS IS THE SETTING-UP SUBROUTINE FOR A PACKAGE OF SUBROUTINES
C THAT FACILITATE THE USE OF EXTENDED-RANGE ARITHMETIC. EXTENDED-RANGE
C ARITHMETIC ON A PARTICULAR COMPUTER IS DEFINED ON THE SET OF NUMBERS
C OF THE FORM
C
C               (X,IX) = X*RADIX**IX
C
C WHERE X IS A DOUBLE-PRECISION NUMBER CALLED THE PRINCIPAL PART,
C IX IS AN INTEGER CALLED THE AUXILIARY INDEX, AND RADIX IS THE
C INTERNAL BASE OF THE DOUBLE-PRECISION ARITHMETIC.  OBVIOUSLY,
C EACH REAL NUMBER IS REPRESENTABLE WITHOUT ERROR BY MORE THAN ONE
C EXTENDED-RANGE FORM.  CONVERSIONS BETWEEN  DIFFERENT FORMS ARE
C ESSENTIAL IN CARRYING OUT ARITHMETIC OPERATIONS.  WITH THE CHOICE
C OF RADIX WE HAVE MADE, AND THE SUBROUTINES WE HAVE WRITTEN, THESE
C CONVERSIONS ARE PERFORMED WITHOUT ERROR (AT LEAST ON MOST COMPUTERS).
C (SEE SMITH, J.M., OLVER, F.W.J., AND LOZIER, D.W., EXTENDED-RANGE
C ARITHMETIC AND NORMALIZED LEGENDRE POLYNOMIALS, ACM TRANSACTIONS ON
C MATHEMATICAL SOFTWARE, MARCH 1981).
C
C   AN EXTENDED-RANGE NUMBER  (X,IX)  IS SAID TO BE IN ADJUSTED FORM IF
C X AND IX ARE ZERO OR
C
C           RADIX**(-L) .LE. ABS(X) .LT. RADIX**L
C
C IS SATISFIED, WHERE L IS A COMPUTER-DEPENDENT INTEGER DEFINED IN THIS
C SUBROUTINE. TWO EXTENDED-RANGE NUMBERS IN ADJUSTED FORM CAN BE ADDED,
C SUBTRACTED, MULTIPLIED OR DIVIDED (IF THE DIVISOR IS NONZERO) WITHOUT
C CAUSING OVERFLOW OR UNDERFLOW IN THE PRINCIPAL PART OF THE RESULT.
C WITH PROPER USE OF THE EXTENDED-RANGE SUBROUTINES, THE ONLY OVERFLOW
C THAT CAN OCCUR IS INTEGER OVERFLOW IN THE AUXILIARY INDEX. IF THIS
C IS DETECTED, THE SOFTWARE CALLS XERROR (A GENERAL ERROR-HANDLING
C FORTRAN SUBROUTINE PACKAGE).
C
C   MULTIPLICATION AND DIVISION IS PERFORMED BY SETTING
C
C                 (X,IX)*(Y,IY) = (X*Y,IX+IY)
C OR
C                 (X,IX)/(Y,IY) = (X/Y,IX-IY).
C
C PRE-ADJUSTMENT OF THE OPERANDS IS ESSENTIAL TO AVOID
C OVERFLOW OR  UNDERFLOW OF THE PRINCIPAL PART. SUBROUTINE
C DXADJ (SEE BELOW) MAY BE CALLED TO TRANSFORM ANY EXTENDED-
C RANGE NUMBER INTO ADJUSTED FORM.
C
C   ADDITION AND SUBTRACTION REQUIRE THE USE OF SUBROUTINE DXADD
C (SEE BELOW).  THE INPUT OPERANDS NEED NOT BE IN ADJUSTED FORM.
C HOWEVER, THE RESULT OF ADDITION OR SUBTRACTION IS RETURNED
C IN ADJUSTED FORM.  THUS, FOR EXAMPLE, IF (X,IX),(Y,IY),
C (U,IU),  AND (V,IV) ARE IN ADJUSTED FORM, THEN
C
C                 (X,IX)*(Y,IY) + (U,IU)*(V,IV)
C
C CAN BE COMPUTED AND STORED IN ADJUSTED FORM WITH NO EXPLICIT
C CALLS TO DXADJ.
C
C   WHEN AN EXTENDED-RANGE NUMBER IS TO BE PRINTED, IT MUST BE
C CONVERTED TO AN EXTENDED-RANGE FORM WITH DECIMAL RADIX.  SUBROUTINE
C DXCON IS PROVIDED FOR THIS PURPOSE.
C
C   THE SUBROUTINES CONTAINED IN THIS PACKAGE ARE
C
C     SUBROUTINE DXADD
C USAGE
C                  CALL DXADD(X,IX,Y,IY,Z,IZ,IERROR)
C                  IF (IERROR.NE.0) RETURN
C DESCRIPTION
C                  FORMS THE EXTENDED-RANGE SUM  (Z,IZ) =
C                  (X,IX) + (Y,IY).  (Z,IZ) IS ADJUSTED
C                  BEFORE RETURNING. THE INPUT OPERANDS
C                  NEED NOT BE IN ADJUSTED FORM, BUT THEIR
C                  PRINCIPAL PARTS MUST SATISFY
C                  RADIX**(-2L).LE.ABS(X).LE.RADIX**(2L),
C                  RADIX**(-2L).LE.ABS(Y).LE.RADIX**(2L).
C
C     SUBROUTINE DXADJ
C USAGE
C                  CALL DXADJ(X,IX,IERROR)
C                  IF (IERROR.NE.0) RETURN
C DESCRIPTION
C                  TRANSFORMS (X,IX) SO THAT
C                  RADIX**(-L) .LE. ABS(X) .LT. RADIX**L.
C                  ON MOST COMPUTERS THIS TRANSFORMATION DOES
C                  NOT CHANGE THE MANTISSA OF X PROVIDED RADIX IS
C                  THE NUMBER BASE OF DOUBLE-PRECISION ARITHMETIC.
C
C     SUBROUTINE DXC210
C USAGE
C                  CALL DXC210(K,Z,J,IERROR)
C                  IF (IERROR.NE.0) RETURN
C DESCRIPTION
C                  GIVEN K THIS SUBROUTINE COMPUTES J AND Z
C                  SUCH THAT  RADIX**K = Z*10**J, WHERE Z IS IN
C                  THE RANGE 1/10 .LE. Z .LT. 1.
C                  THE VALUE OF Z WILL BE ACCURATE TO FULL
C                  DOUBLE-PRECISION PROVIDED THE NUMBER
C                  OF DECIMAL PLACES IN THE LARGEST
C                  INTEGER PLUS THE NUMBER OF DECIMAL
C                  PLACES CARRIED IN DOUBLE-PRECISION DOES NOT
C                  EXCEED 60. DXC210 IS CALLED BY SUBROUTINE
C                  DXCON WHEN NECESSARY. THE USER SHOULD
C                  NEVER NEED TO CALL DXC210 DIRECTLY.
C
C     SUBROUTINE DXCON
C USAGE
C                  CALL DXCON(X,IX,IERROR)
C                  IF (IERROR.NE.0) RETURN
C DESCRIPTION
C                  CONVERTS (X,IX) = X*RADIX**IX
C                  TO DECIMAL FORM IN PREPARATION FOR
C                  PRINTING, SO THAT (X,IX) = X*10**IX
C                  WHERE 1/10 .LE. ABS(X) .LT. 1
C                  IS RETURNED, EXCEPT THAT IF
C                  (ABS(X),IX) IS BETWEEN RADIX**(-2L)
C                  AND RADIX**(2L) THEN THE REDUCED
C                  FORM WITH IX = 0 IS RETURNED.
C
C     SUBROUTINE DXRED
C USAGE
C                  CALL DXRED(X,IX,IERROR)
C                  IF (IERROR.NE.0) RETURN
C DESCRIPTION
C                  IF
C                  RADIX**(-2L) .LE. (ABS(X),IX) .LE. RADIX**(2L)
C                  THEN DXRED TRANSFORMS (X,IX) SO THAT IX=0.
C                  IF (X,IX) IS OUTSIDE THE ABOVE RANGE,
C                  THEN DXRED TAKES NO ACTION.
C                  THIS SUBROUTINE IS USEFUL IF THE
C                  RESULTS OF EXTENDED-RANGE CALCULATIONS
C                  ARE TO BE USED IN SUBSEQUENT ORDINARY
C                  DOUBLE-PRECISION CALCULATIONS.
C
C***REFERENCES  Smith, Olver and Lozier, Extended-Range Arithmetic and
C                 Normalized Legendre Polynomials, ACM Trans on Math
C                 Softw, v 7, n 1, March 1981, pp 93--105.
C***ROUTINES CALLED  I1MACH, XERMSG
C***COMMON BLOCKS    DXBLK1, DXBLK2, DXBLK3
C***REVISION HISTORY  (YYMMDD)
C   820712  DATE WRITTEN
C   881020  Revised to meet SLATEC CML recommendations.  (DWL and JMS)
C   901019  Revisions to prologue.  (DWL and WRB)
C   901106  Changed all specific intrinsics to generic.  (WRB)
C           Corrected order of sections in prologue and added TYPE
C           section.  (WRB)
C           CALLs to XERROR changed to CALLs to XERMSG.  (WRB)
C   920127  Revised PURPOSE section of prologue.  (DWL)
C***END PROLOGUE  DXSET
      INTEGER IRAD, NRADPL, NBITS
      DOUBLE PRECISION DZERO, DZEROX
      COMMON /DXBLK1/ NBITSF
      SAVE /DXBLK1/
      DOUBLE PRECISION RADIX, RADIXL, RAD2L, DLG10R
      INTEGER L, L2, KMAX
      COMMON /DXBLK2/ RADIX, RADIXL, RAD2L, DLG10R, L, L2, KMAX
      SAVE /DXBLK2/
      INTEGER NLG102, MLG102, LG102
      COMMON /DXBLK3/ NLG102, MLG102, LG102(21)
      SAVE /DXBLK3/
      INTEGER IFLAG
      SAVE IFLAG
C
      DIMENSION LOG102(20), LGTEMP(20)
      SAVE LOG102
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOMC.INC'
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C
C   LOG102 CONTAINS THE FIRST 60 DIGITS OF LOG10(2) FOR USE IN
C CONVERSION OF EXTENDED-RANGE NUMBERS TO BASE 10 .
      DATA LOG102 /301,029,995,663,981,195,213,738,894,724,493,026,768,
     * 189,881,462,108,541,310,428/
C
C FOLLOWING CODING PREVENTS DXSET FROM BEING EXECUTED MORE THAN ONCE.
C THIS IS IMPORTANT BECAUSE SOME SUBROUTINES (SUCH AS DXNRMP AND
C DXLEGF) CALL DXSET TO MAKE SURE EXTENDED-RANGE ARITHMETIC HAS
C BEEN INITIALIZED. THE USER MAY WANT TO PRE-EMPT THIS CALL, FOR
C EXAMPLE WHEN I1MACH IS NOT AVAILABLE. SEE CODING BELOW.
      DATA IFLAG /0/
C***FIRST EXECUTABLE STATEMENT  DXSET
      IERROR=0
      IF (IFLAG .NE. 0) RETURN
      IRADX = IRAD
      NRDPLC = NRADPL
      DZEROX = DZERO
      IMINEX = 0
      IMAXEX = 0
      NBITSX = NBITS
C FOLLOWING 5 STATEMENTS SHOULD BE DELETED IF I1MACH IS
C NOT AVAILABLE OR NOT CONFIGURED TO RETURN THE CORRECT
C MACHINE-DEPENDENT VALUES.
      IF (IRADX .EQ. 0) IRADX = I1MACH (10)
      IF (NRDPLC .EQ. 0) NRDPLC = I1MACH (14)
      IF (DZEROX .EQ. 0.0D0) IMINEX = I1MACH (15)
      IF (DZEROX .EQ. 0.0D0) IMAXEX = I1MACH (16)
      IF (NBITSX .EQ. 0) NBITSX = I1MACH (8)
      IF (IRADX.EQ.2) GO TO 10
      IF (IRADX.EQ.4) GO TO 10
      IF (IRADX.EQ.8) GO TO 10
      IF (IRADX.EQ.16) GO TO 10
CCCCC CALL XERMSG ('SLATEC', 'DXSET', 'IMPROPER VALUE OF IRAD', 201, 1)
      WRITE(ICOUT,901)
      CALL DPWRST('XXX','BUG ')
  901 FORMAT('***** ERROR FROM DXSET, IMPROPER VALUE OF IRAD.')
      IERROR=201
      RETURN
   10 CONTINUE
      LOG2R=0
      IF (IRADX.EQ.2) LOG2R = 1
      IF (IRADX.EQ.4) LOG2R = 2
      IF (IRADX.EQ.8) LOG2R = 3
      IF (IRADX.EQ.16) LOG2R = 4
      NBITSF=LOG2R*NRDPLC
      RADIX = IRADX
      DLG10R = LOG10(RADIX)
      IF (DZEROX .NE. 0.0D0) GO TO 14
      LX = MIN ((1-IMINEX)/2, (IMAXEX-1)/2)
      GO TO 16
   14 LX = 0.5D0*LOG10(DZEROX)/DLG10R
C RADIX**(2*L) SHOULD NOT OVERFLOW, BUT REDUCE L BY 1 FOR FURTHER
C PROTECTION.
      LX=LX-1
   16 L2 = 2*LX
      IF (LX.GE.4) GO TO 20
CCCCC CALL XERMSG ('SLATEC', 'DXSET', 'IMPROPER VALUE OF DZERO', 202, 1)
      WRITE(ICOUT,902)
      CALL DPWRST('XXX','BUG ')
  902 FORMAT('***** ERROR FROM DXSET, IMPROPER VALUE OF DZERO.')
      IERROR=202
      RETURN
   20 L = LX
      RADIXL = RADIX**L
      RAD2L = RADIXL**2
C    IT IS NECESSARY TO RESTRICT NBITS (OR NBITSX) TO BE LESS THAN SOME
C UPPER LIMIT BECAUSE OF BINARY-TO-DECIMAL CONVERSION. SUCH CONVERSION
C IS DONE BY DXC210 AND REQUIRES A CONSTANT THAT IS STORED TO SOME FIXED
C PRECISION. THE STORED CONSTANT (LOG102 IN THIS ROUTINE) PROVIDES
C FOR CONVERSIONS ACCURATE TO THE LAST DECIMAL DIGIT WHEN THE INTEGER
C WORD LENGTH DOES NOT EXCEED 63. A LOWER LIMIT OF 15 BITS IS IMPOSED
C BECAUSE THE SOFTWARE IS DESIGNED TO RUN ON COMPUTERS WITH INTEGER WORD
C LENGTH OF AT LEAST 16 BITS.
      IF (15.LE.NBITSX .AND. NBITSX.LE.63) GO TO 30
CCCCC CALL XERMSG ('SLATEC', 'DXSET', 'IMPROPER VALUE OF NBITS', 203, 1)
      WRITE(ICOUT,913)
      CALL DPWRST('XXX','BUG ')
  913 FORMAT('***** ERROR FROM DXSET, IMPROPER VALUE OF NBITS.')
      IERROR=203
      RETURN
   30 CONTINUE
      KMAX = 2**(NBITSX-1) - L2
      NB = (NBITSX-1)/2
      MLG102 = 2**NB
      IF (1.LE.NRDPLC*LOG2R .AND. NRDPLC*LOG2R.LE.120) GO TO 40
CCCCC CALL XERMSG ('SLATEC', 'DXSET', 'IMPROPER VALUE OF NRADPL', 204,
CCCCC+             1)
      WRITE(ICOUT,903)
      CALL DPWRST('XXX','BUG ')
  903 FORMAT('***** ERROR FROM DXSET, IMPROPER VALUE OF NRADPL.')
      IERROR=204
      RETURN
   40 CONTINUE
      NLG102 = NRDPLC*LOG2R/NB + 3
      NP1 = NLG102 + 1
C
C   AFTER COMPLETION OF THE FOLLOWING LOOP, IC CONTAINS
C THE INTEGER PART AND LGTEMP CONTAINS THE FRACTIONAL PART
C OF LOG10(IRADX) IN RADIX 1000.
      IC = 0
      DO 50 II=1,20
        I = 21 - II
        IT = LOG2R*LOG102(I) + IC
        IC = IT/1000
        LGTEMP(I) = MOD(IT,1000)
   50 CONTINUE
C
C   AFTER COMPLETION OF THE FOLLOWING LOOP, LG102 CONTAINS
C LOG10(IRADX) IN RADIX MLG102. THE RADIX POINT IS
C BETWEEN LG102(1) AND LG102(2).
      LG102(1) = IC
      DO 80 I=2,NP1
        LG102X = 0
        DO 70 J=1,NB
          IC = 0
          DO 60 KK=1,20
            K = 21 - KK
            IT = 2*LGTEMP(K) + IC
            IC = IT/1000
            LGTEMP(K) = MOD(IT,1000)
   60     CONTINUE
          LG102X = 2*LG102X + IC
   70   CONTINUE
        LG102(I) = LG102X
   80 CONTINUE
C
C CHECK SPECIAL CONDITIONS REQUIRED BY SUBROUTINES...
      IF (NRDPLC.LT.L) GO TO 90
CCCCC CALL XERMSG ('SLATEC', 'DXSET', 'NRADPL .GE. L', 205, 1)
      WRITE(ICOUT,904)
      CALL DPWRST('XXX','BUG ')
  904 FORMAT('***** ERROR FROM DXSET, IMPROPER VALUE OF NRADPL.')
      IERROR=205
      RETURN
   90 IF (6*L.LE.KMAX) GO TO 100
CCCCC CALL XERMSG ('SLATEC', 'DXSET', '6*L .GT. KMAX', 206, 1)
      WRITE(ICOUT,905)
      CALL DPWRST('XXX','BUG ')
  905 FORMAT('***** ERROR FROM DXSET, IMPROPER VALUE OF L.')
      IERROR=206
      RETURN
  100 CONTINUE
      IFLAG = 1
      RETURN
      END
      SUBROUTINE D3DEDC(X,Y,Z,N,
     1X3DEYE,Y3DEYE,Z3DEYE,
     1D3DCXX,D3DCXY,D3DCXZ,
     1D3DCYX,D3DCYY,D3DCYZ,
     1D3DCZX,D3DCZY,D3DCZZ,
     1TERMXX,TERMXY,TERMXZ,
     1TERMYX,TERMYY,TERMYZ,
     1TERMZX,TERMZY,TERMZZ,
     1IBUGPL,ISUBRO,IERROR)
C
C     PURPOSE--COMPUTE DIRECTION COSINES
C              WHICH WILL BE NEEDED TO ROTATE
C              THE 3-D DATA CLOUD ONTO A 2-D PLANE.
C     NOTE--THE DN.. ARE DIRECTION NUMBERS.
C           THE DC.. ARE DIRECTION COSINES.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--88/10
C     ORIGINAL VERSION--MARCH     1979.
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--SEPTEMBER 1988.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DIMENSION X(*)
      DIMENSION Y(*)
      DIMENSION Z(*)
C
      CHARACTER*4 IBUGPL
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='D3DE'
      ISUBN2='DC  '
C
      IERROR='NO'
C
      EPS=0.0000001
C
      IF(IBUGPL.EQ.'OFF'.AND.ISUBRO.NE.'DEDC')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF D3DEDC--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGPL,ISUBRO,IERROR
   52 FORMAT('IBUGPL,ISUBRO,IERROR = ',3A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)X3DEYE,Y3DEYE,Z3DEYE
   61 FORMAT('X3DEYE, Y3DEYE, Z3DEYE  = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               *********************************************************
C               **  GENERAL DISCUSSION--                               **
C               **  DETERMINE (IN ORIGINAL COORDINATE SYSTEM VALUES)   **
C               **  WHERE THE DATA POINTS FALL ON THE VISUAL PLANE.    **
C               **  FOR EACH (XD,YD,ZD) DATA POINT,                    **
C               **  DETERMINE WHERE THE VISUAL RAY FROM                **
C               **  THE DATA POINT TO OUR EYE                          **
C               **  STRIKES THE VISUAL (PERSPECTIVE) PLANE.            **
C               **  THE VISUAL PLANE IS THAT PLANE                     **
C               **  WHICH IS NORMAL TO OUR EYE                         **
C               **  AND WHICH CONTAINS THE AVERAGE POINT (XM,YM,ZM).   **
C               **  THE EQUATION OF THE VISUAL PLANE IS                **
C               **  (X3DEYE-XM)(X-XM) + (Y3DEYE-YM)(Y-YM) +
C               **                    + (Z3DEYE-YM)(Z-ZM) = 0          **
C               **  WHERE X, Y, Z ARE THE DUMMY VARIABLES              **
C               **  REPRESENTING ANY POINT (X,Y,Z) ON THAT PLANE.      **
C               **  THIS EQUATION MUST BE SOLVED FOR X, Y, AND Z.      **
C               **  THE EQUATIONS OF THE LINE FROM THE DATA POINT
C               **  (XD,YD,ZD)
C               **  TO OUR EYE (X3DEYE,Y3DEYE,Z3DEYE) ARE
C               **  (X-XD)/(X3DEYE-XD) = (Y-YD)/(Y3DEYE-YD)
C               **                     = (Z-ZD)/(Z3DEYE-ZD)
C               **  WHERE (XD,YD,ZD) REPRESENTS A DATA POINT.           **
C               **  THE VISUAL PLANE EQUATION AND THE LINE EQUATIONS    **
C               **  MUST BE COMBINED TO SOLVE FOR THE VALUES (X,Y,Z)    **
C               **  ON THE VISUAL PLANE AS OUR EYE SEES THEM.           **
C               **********************************************************
C
C               **********************************************************
C               **  THE FINAL PLOT STATEMENT WILL INVOLVE
C               **  ONLY 2 VECTORS.
C               **  AT THE MOMENT, THE POINTS (XP,YP,ZP)
C               **  ON THE VISUAL PLANE ARE DEFINED
C               **  BY 3 COORDINATE VALUES.
C               **  TO REDUCE THE 3 COORDINATE VALUES
C               **  TO 2 COORDINATE VALUES,
C               **  WE MUST ROTATE THE VISUAL PLANE
C               **  SO THAT IT IS PARALLEL TO THE ORIGINAL XZ PLANE.
C               **  TO CARRY OUT SUCH A ROTATION, WE MUST
C               **  DETERMINE THE DIRECTION NUMBERS AND DIRECTION COSINES
C               **  OF THE NEW AXES IN TERMS OF THE OLD COORDINATE SYSTEM.
C               **  THE NEW Y AXIS WILL (BY CONSTRUCTION) BE
C               **  ON THE NORMAL LINE TRAVELING FROM
C               **  THE AVERAGE POINT (XM,YM,ZM) TO OUR EYE POINT
C               **  (X3DEYE,Y3DEYE,Z3DEYE)
C               **  AND WILL THEREFORE HAVE DIRECTIONS NUMBERS
C               **  X3DEYE, Y3DEYE, Z3DEYE
C               **  THE NEW Z AXIS WILL BE PERPENDICULAR TO THE NEW Y AXIS
C               **  AND WILL RESIDE IN THE PLANE CONTAINING THE
C               **  THE FOLLOWING 3 POINTS--
C               **      1) THE AVERAGE POINT (XM,YM,ZM)
C               **      2) THE EYE POINT (X3DEYE,Y3DEYE,Z3DEYE)
C               **      3) SOME POINT (SAY (XM,YM,ZM+1)) OF THE OLD Z AXIS
C               **         DISPLACED OVER SO AS TO EMANATE FROM (XM,YM,ZM).
C               **  THE ABOVE 3 POINTS DEFINE A VERTICAL PLANE.
C               **  THE PURPOSE OF THE VERTICAL PLANE IS TO DEFINE
C               **  WHICH DIRECTION IS 'UP' IN THE FINAL PICTURE.
C               **  THE EQUATION OF THE VERTICAL PLANE IS
C               **  (A-XM)(X-XM) + (B-YM)(Y-YM) + (C-ZM)(Z-ZM) = 0 .
C               **  THIS EQUATION MUST BE SOLVED FOR A, B, AND C.
C               **  WITHOUT LOSS OF GENERALITY, A MAY BE INITIALLY SET TO 1.
C               **  THE SOLUTION TURNS OUT TO BE
C               **      A = 1
C               **      B = -X3DEYE/Y3DEYE
C               **      C = 0
C               **  NOTE, HOWEVER, THAT THESE A, B, AND C VALUES
C               **  FOR THIS VERTICAL PLANE WILL BE IDENTICAL TO THE
C               **  DIRECTION NUMBERS FOR THE NORMAL TO THIS VERTICAL PLANE
C               **  WHICH IS IDENTICALLY THE NEW X AXIS
C               **  AND SO THE ABOVE A, B, AND C VALUES DEFINE THE DIRECTION
C               **  DIRECTION NUMBERS FOR THE NEW X AXIS.
C               **  TO SOLVE FOR THE DIRECTION NUMBERS FOR THE NEW Z AXIS,
C               **  WE SEEK 3 DIRECTION NUMBERS D, E, AND F
C               **  WHICH MUST BE PERPENDICULAR TO BOTH THE
C               **  NEW Y AXIS (WITH DIRECTION NUMBERS X3DEYE, Y3DEYE,
C               **  AND Z3DEYE)
C               **  AND THE NEW X AXIS (WITH DIRECTION NUMBERS A, B, AND C ABOVE
C               **  WITHOUT LOSS OF GENERALITY, D MAY BE INITIALLY SET TO 1.
C               **  NOTE THAT WHENEVER 2 LINES ARE PERPENDICULAR,
C               **  THE INNER PRODUCT OF THE DIRECTION NUMBERS MUST = 0.
C               **  WITHOUT LOSS OF GENERALITY, D MAY BE INITIALLY SET TO 1.
C               **  INCORPORATING THE 2 INNER PRODUCT EQUATIONS,
C               **  WE MAY SOLVE FOR E AND F.
C               **  THE SOLUTIONS TURN OUT TO BE
C               **      D = 1
C               **      E = Y3DEYE/X3DEYE
C               **      F = (-X3DEYE*X3DEYE - Y3DEYE*Y3DEYE) / (X3DEYE*Z3DEYE)
C               **
C               **  IN SUMMARY, THE DIRECTION NUMBERS FOR THE 3 NEW AXES
C               **  MAY BE WRITTEN AS
C               **      NEW X AXIS:  Y3DEYE       -X3DEYE     0
C               **      NEW Y AXIS:  X3DEYE       Y3DEYE      Z3DEYE
C               **      NEW Z AXIS:  -X3DEYE*Z3DEYE   -Y3DEYE*Z3DEYE
C               **                                        X3DEYE*X3DEYE+Y3DEYE
C               **  NOTE THAT BY INSPECTION WE SEE RETROSPECTIVELY
C               **  THAT THE 3 INNER PRODUCTS ALL = 0
C               **  AND SO THE 3 DEFINED AXES ARE ALL PERPENDICULAR
C               **  (AS THEY SHOULD BE).
C               **
C               **  THE CORRESPONDING DIRECTION COSINES
C               **  ARE GOTTEN BY NORMALIZATION TO UNITY;
C               **  LET US SYMBOLICALLY REPRESENT THEM BY--
C               **      D3DCXX   D3DCXY   D3DCXZ
C               **      D3DCYX   D3DCYY   D3DCYZ
C               **      D3DCZX   D3DCZY   D3DCZZ
C               **  THE ABOVE RESULTS WERE ACTUALLY ARRIVED AT
C               **  (AND ARE VALID FOR) BY DISPLACING THE OLD ORIGIN
C               **  FROM (0,0,0) TO (XM,YM,ZM).
C               **  THIS SIMPLIFIES THE EQUATIONS CONSIDERABLY.
C               **
C               **  GIVEN THAT WE NOW HAVE THE DIRECTION COSINES
C               **  OF THE NEW AXES IN TERMS OF THE OLD COORDINATES,
C               **  WE MAKE USE OF
C               **  EISENHART (COORDINATE GEOMETRY, PAGE 160) WHICH STATES
C               **  THAT THE LINEAR TRANSFORMATION THAT IS NEEDED TO CARRY OUT
C               **  THE ROTATION FROM THE VISUAL PLANE TO THE XZ PLANE
C               **  IS GIVEN BY
C               **      XT = XM + D3DCXX(X-XM) + D3DCXY(Y-YM) + D3DCXZ(Z-ZM)
C               **      YT = YM + D3DCYX(X-XM) + D3DCYY(Y-YM) + D3DCYZ(Z-ZM)
C               **      ZT = ZM + D3DCZX(X-XM) + D3DCZY(Y-YM) + D3DCZZ(Z-ZM)
C               **
C               **  NOTE THAT BY INSPECTION OF THE ABOVE TRANSFORMATION
C               **  IT IS SEEN THAT (XM,YM,ZM) IS MAPPED INTO (XM,YM,ZM)
C               **  (AS IT SHOULD BE).
C               **  NOTE ALSO THAT THE EYE POINT AND ANY POINT ALONG THE LINE
C               **  OF SIGHT WOULD HAVE BEEN MAPPED INTO (XM,YM,ZM)
C               **  AS IT SHOULD BE.
C               **  NOTE ALSO THAT ALL POINTS ON THE VISUAL PLANE
C               **  SINCE THEY SATISFY
C               **     (X3DEYE-XM)(X-XM) + (Y3DEYE-YM)(Y-YM) + (Z3DEYE-ZM)(Z-ZM)
C               **     = 0
C               **  GETS MAPPED INTO THE CONSTANT YT VALUE OF YT = YM
C               **  AND SO THE TRANSFORMED PLOT SURFACE IS ONE WHICH
C               **  IS PARALLEL TO THE XZ PLANE BUT IS DISPLACED
C               **  YM UNITS OUT FROM THE XZ PLANE.
C               **  THIS PLOT PLANE WILL CONTAIN THE POINT (XM,YM,ZM).
C               ****************************************************************
C
      ISTEPN='31'
      IF(IBUGPL.EQ.'ON'.OR.ISUBRO.EQ.'DEDC')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DNXX=Y3DEYE
      DNXY=-X3DEYE
      DNXZ=0.0
      DNYX=X3DEYE
      DNYY=Y3DEYE
      DNYZ=Z3DEYE
      DNZX=-X3DEYE*Z3DEYE
      DNZY=-Y3DEYE*Z3DEYE
      DNZZ=X3DEYE*X3DEYE+Y3DEYE*Y3DEYE
C
      ARGX=DNXX**2+DNXY**2+DNXZ**2
      ARGY=DNYX**2+DNYY**2+DNYZ**2
      ARGZ=DNZX**2+DNZY**2+DNZZ**2
      DENOMX=0.0
      DENOMY=0.0
      DENOMZ=0.0
      IF(ARGX.GT.0.0)DENOMX=SQRT(ARGX)
      IF(ARGY.GT.0.0)DENOMY=SQRT(ARGY)
      IF(ARGZ.GT.0.0)DENOMZ=SQRT(ARGZ)
C
C     ***** 15 LINES OF CODE TO CHECK FOR DIVISION BY 0 ADDED AUGUST 1983 *****
C
      D3DCXX=CPUMAX
      D3DCXY=CPUMAX
      D3DCXZ=CPUMAX
      IF(DENOMX.EQ.0.0)GOTO1119
      D3DCXX=DNXX/DENOMX
      D3DCXY=DNXY/DENOMX
      D3DCXZ=DNXZ/DENOMX
 1119 CONTINUE
C
      D3DCYX=CPUMAX
      D3DCYY=CPUMAX
      D3DCYZ=CPUMAX
      IF(DENOMY.EQ.0.0)GOTO1129
      D3DCYX=DNYX/DENOMY
      D3DCYY=DNYY/DENOMY
      D3DCYZ=DNYZ/DENOMY
 1129 CONTINUE
C
      D3DCZX=CPUMAX
      D3DCZY=CPUMAX
      D3DCZZ=CPUMAX
      IF(DENOMZ.EQ.0.0)GOTO1139
      D3DCZX=DNZX/DENOMZ
      D3DCZY=DNZY/DENOMZ
      D3DCZZ=DNZZ/DENOMZ
 1139 CONTINUE
C
C     THE FOLLOWING IS FROM EIDE ET AL (1985),
C     ENGINEERING GRAPHICS FUNDAMENTALS
C     PAGE 386-387, FORMULA 17.42.
C     ALPHA IS THE ANGLE FROM MY XY (= BOTTTOM) PLANE TO THE EYE VECTOR
C     BETA  IS THE ANGLE FROM MY YZ (= LEFT) TO THE EYE VECTOR
C     (NOTE DIFFERENCE HERE TO EIDE'S NOTATION, HIS Z = MY Y, & VV.)
C
      ARGALP=X3DEYE**2+Y3DEYE**2+Z3DEYE**2
      DENALP=0.0
      IF(ARGALP.GT.0.0)DENALP=SQRT(ARGALP)
      SINALP=Z3DEYE/DENALP
      COSALP=SQRT(1.0-SINALP**2)
C
      SINBET=0.0
      COSBET=1.0
      DENBET=0.0
      ARGBET=X3DEYE**2+Y3DEYE**2
      IF(ARGBET.LE.EPS)GOTO1159
      IF(ARGBET.GT.EPS)DENBET=SQRT(ARGBET)
      SINBET=X3DEYE/DENBET
      COSBET=SQRT(1.0-SINBET**2)
 1159 CONTINUE
C
      TERMXX=COSBET
      TERMXY=(-SINBET)
      TERMXZ=0.0
C
      TERMYX=COSALP*SINBET
      TERMYY=COSALP*COSBET
      TERMYZ=SINALP
C
      TERMZX=(-SINALP*SINBET)
      TERMZY=(-SINALP*COSBET)
      TERMZZ=COSALP
C
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGPL.EQ.'OFF'.AND.ISUBRO.NE.'DEDC')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF D3DEDC--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGPL,ISUBRO,IERROR
 9012 FORMAT('IBUGPL,ISUBRO,IERROR = ',3A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)X3DEYE,Y3DEYE,Z3DEYE
 9013 FORMAT('X3DEYE,Y3DEYE,Z3DEYE = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)DNXX,DNXY,DNXZ
 9021 FORMAT('DNXX,DNXY,DNXZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)DNYX,DNYY,DNYZ
 9022 FORMAT('DNYX,DNYY,DNYZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9023)DNYX,DNYY,DNYZ
 9023 FORMAT('DNZX,DNZY,DNZZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9024)D3DCXX,D3DCXY,D3DCXZ
 9024 FORMAT('D3DCXX,D3DCXY,D3DCXZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9025)D3DCYX,D3DCYY,D3DCYZ
 9025 FORMAT('D3DCYX,D3DCYY,D3DCYZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9026)D3DCZX,D3DCZY,D3DCZZ
 9026 FORMAT('D3DCZX,D3DCZY,D3DCZZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9034)TERMXX,TERMXY,TERMXZ
 9034 FORMAT('TERMXX,TERMXY,TERMXZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9035)TERMYX,TERMYY,TERMYZ
 9035 FORMAT('TERMYX,TERMYY,TERMYZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9036)TERMZX,TERMZY,TERMZZ
 9036 FORMAT('TERMZX,TERMZY,TERMZZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE D3DELI(X,Y,Z,N,
     1XEYE0,YEYE0,ZEYE0,
     1XORIG,YORIG,ZORIG,
     1X3DMIN,Y3DMIN,Z3DMIN,
     1X3DMAX,Y3DMAX,Z3DMAX,
     1X3DMID,Y3DMID,Z3DMID,
     1X3DRAN,Y3DRAN,Z3DRAN,
     1X3DEYE,Y3DEYE,Z3DEYE,
     1X3DORI,Y3DORI,Z3DORI,
     1XPRIME,YPRIME,ZPRIME,
     1IBUGPL,ISUBRO,IERROR)
C
C     PURPOSE--COMPUTE MIN, MAX, MID, AND RANGE OF THE RAW DATA.
C              COMPUTE EYE COORDINATES.
C              COMPUTE ORIGIN COORDINATES
C              COMPUTE VISUAL EXTREME POINTS ON THE
C                 ORTHOGNORMAL PLANE THROUGH (X3DMID,Y3DMID,Z3DMID)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--88/10
C     ORIGINAL VERSION--MARCH     1979.
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--SEPTEMBER 1988.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IBUGPL
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION Y(*)
      DIMENSION Z(*)
C
      DIMENSION XPRIME(*)
      DIMENSION YPRIME(*)
      DIMENSION ZPRIME(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='D3DE'
      ISUBN2='LI  '
C
      IERROR='NO'
C
      EPS=0.0000001
C
      IF(IBUGPL.NE.'ON'.AND.ISUBRO.NE.'DELI')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF D3DELI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGPL,ISUBRO,IERROR
   52 FORMAT('IBUGPL,ISUBRO,IERROR = ',3A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)XEYE0,YEYE0,ZEYE0
   61 FORMAT('XEYE0, YEYE0, ZEYE0  = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)XORIG,YORIG,ZORIG
   62 FORMAT('XORIG, YORIG, ZORIG  = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,71)N
   71 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO72I=1,N
      WRITE(ICOUT,73)I,X(I),Y(I),Z(I)
   73 FORMAT('I,X(I),Y(I),Z(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
   72 CONTINUE
   90 CONTINUE
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  COMPUTE THE MIN AND MAX OF THE RAW DATA.  **
C               ************************************************
C
      ISTEPN='11'
      IF(IBUGPL.EQ.'ON'.OR.ISUBRO.EQ.'DELI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      X3DMIN=X(1)
      X3DMAX=X(1)
      Y3DMIN=Y(1)
      Y3DMAX=Y(1)
      Z3DMIN=Z(1)
      Z3DMAX=Z(1)
C
      DO1100I=1,N
      IF(X(I).LT.X3DMIN)X3DMIN=X(I)
      IF(X(I).GT.X3DMAX)X3DMAX=X(I)
      IF(Y(I).LT.Y3DMIN)Y3DMIN=Y(I)
      IF(Y(I).GT.Y3DMAX)Y3DMAX=Y(I)
      IF(Z(I).LT.Z3DMIN)Z3DMIN=Z(I)
      IF(Z(I).GT.Z3DMAX)Z3DMAX=Z(I)
 1100 CONTINUE
      X3DRAN=X3DMAX-X3DMIN
      Y3DRAN=Y3DMAX-Y3DMIN
      Z3DRAN=Z3DMAX-Z3DMIN
C
C               *******************************************
C               **  STEP 12--                            **
C               **  COMPUTE MIDRANGES FOR THE X, Y,      **
C               **  AND Z VECTORS.                       **
C               **  THIS WILL DEFINE THE 'MIDDLE POINT'  **
C               **  OF THE 3-D PLOT.                     **
C               *******************************************
C
      ISTEPN='12'
      IF(IBUGPL.EQ.'ON'.OR.ISUBRO.EQ.'DELI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      X3DMID=(X3DMIN+X3DMAX)/2.0
      Y3DMID=(Y3DMIN+Y3DMAX)/2.0
      Z3DMID=(Z3DMIN+Z3DMAX)/2.0
C
C               *******************************************
C               **  STEP 13--                            **
C               **  COMPUTE EYE COORDINATES.             88
C               **  IF (XEYE0,YEYE0,ZEYE0) IS UNDEFINED  **
C               **  (THAT IS,    = CPU MINIMUM),         **
C               **  THEN COMPUTE DEFAULT VALUES.         **
C               *******************************************
C
      ISTEPN='13'
      IF(IBUGPL.EQ.'ON'.OR.ISUBRO.EQ.'DELI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
      X3DEYE=XEYE0
      Y3DEYE=YEYE0
      Z3DEYE=ZEYE0
      IF(XEYE0.LE.CPUMIN)X3DEYE=X3DMAX+3.0*X3DRAN
      IF(YEYE0.LE.CPUMIN)Y3DEYE=Y3DMAX+3.0*Y3DRAN
      IF(ZEYE0.LE.CPUMIN)Z3DEYE=Z3DMAX+3.0*Z3DRAN
C
C               ***************************************************
C               **  STEP 14--                                    **
C               **  COMPUTE THE ENDPONTS OF THE 3-PRONGED AXIS.  **
C               ***************************************************
C
      ISTEPN='14'
      IF(IBUGPL.EQ.'ON'.OR.ISUBRO.EQ.'DELI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      FACTOR=1.25
C
      X3DORI=XORIG
      Y3DORI=YORIG
      Z3DORI=ZORIG
      IF(XORIG.EQ.CPUMIN)X3DORI=X3DMIN
      IF(YORIG.EQ.CPUMIN)Y3DORI=Y3DMIN
      IF(ZORIG.EQ.CPUMIN)Z3DORI=Z3DMIN
C
      XPRIME(1)=X3DORI
      YPRIME(1)=Y3DORI
      ZPRIME(1)=Z3DORI
C
      XPRIME(2)=X3DORI+FACTOR*X3DRAN
      YPRIME(2)=Y3DORI
      ZPRIME(2)=Z3DORI
C
      XPRIME(3)=X3DORI
      YPRIME(3)=Y3DORI
      ZPRIME(3)=Z3DORI
C
      XPRIME(4)=X3DORI
      YPRIME(4)=Y3DORI+FACTOR*Y3DRAN
      ZPRIME(4)=Z3DORI
C
      XPRIME(5)=X3DORI
      YPRIME(5)=Y3DORI
      ZPRIME(5)=Z3DORI
C
      XPRIME(6)=X3DORI
      YPRIME(6)=Y3DORI
      ZPRIME(6)=Z3DORI+FACTOR*Z3DRAN
C
C               ***************************************************************
C               **  STEP 15--                                                **
C               **  DETERMINE 3 POINTS WHICH WILL DEFINE EXTREMAL POINTS     **
C               **  ON THE VISUAL PLANE.                                     **
C               **  THIS IS NEEDED SO THAT THE UNDERLYING GRAPHICS SOFTWARE  **
C               **  WILL SHOW A CLOSE POINT/CLOUD/FIGURE                     **
C               **  AS BEING LARGE IN APPEARANCE,                            **
C               **  AND A DISTANT POINT/CLOUD/FIGURE                         **
C               **  AS BEING SMALL IN APPEARANCE.                            **
C               **  SUCH A STEP IS NECESSARY BECAUSE THE                     **
C               **  UNDERLYING GRAPHICS SOFTWARE WILL BY DEFAULT             **
C               **  GIVE FULL RESOLUTION TO ALL DATA CLOUDS/FIGRUES          **
C               **  WHICH WILL HAVE THE NET EFFECT OF                        **
C               **  ALL DATA CLOUDS/FIGURES BEING LARGE.                     **
C               **  THE 3 CALCULATED EXTREMAL POINTS WILL NEVER              **
C               **  EXPLICITELY APPEAR ON THE PLOT (THEY WILL                **
C               **  HAVE A BLANK PLOT CHARAXCTER AUTOMATICALLY);             **
C               **  THERE EXISTENCE ONLY SERVES TO ASSURE THAT THE           **
C               **  PLOT WINDOW IS APPROPRIATELY STRETCHED.                  **
C               ***************************************************************
C
C               ************************************************************
C               **  STEP 15.1--                                           **
C               **  DEFINE THE PERIPHERAL VISION ANGLE.                   **
C               **  THIS HAS BEEN SET TO 60 DEGREES                       **
C               **  (30   DEGREES ABOVE THE NORMAL LINE                   **
C               **  TO THE VISUAL PLANE AND 30   DEGREES BELOW            **
C               **  THE NORMAL LINE TO THE PLANE).                        **
C               **  COMPUTE THE RADIUS OF THE CIRCLE ON THE VISUAL PLANE  **
C               **  WHICH IS JUST AT THE EDGE OF VISIBILITY--             **
C               **  THE LARGER THE PERIPHERAL ANGLE,                      **
C               **  THE LARGER THE RADIUS, AND VICE VERSA.                **
C               ************************************************************
C
      ISTEPN='15.1'
      IF(IBUGPL.EQ.'ON'.OR.ISUBRO.EQ.'DELI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      THETA=3.1415926/12.0
      ARG=(X3DEYE-X3DMID)**2+(Y3DEYE-Y3DMID)**2+(Z3DEYE-Z3DMID)**2
      DIST=0.0
      IF(ARG.GT.0.0)DIST=SQRT(ARG)
      RADIUS=DIST*TAN(THETA)
      IF(IBUGPL.NE.'ON'.AND.ISUBRO.NE.'DELI')GOTO1519
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1511)
 1511 FORMAT('***** FROM THE MIDDLE OF D3DELI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1512)THETA,ARG,DIST,RADIUS
 1512 FORMAT('THETA,ARG,DIST,RADIUS = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
 1519 CONTINUE
C
C               ***********************************************************
C               **  STEP 15.2--                                          **
C               **  DETERMINE THE 2 POINTS ON THIS CIRCLE OF VISIBILITY  **
C               **  WHICH INTERSECT WITH THE X = X3DMID PLANE.             **
C               ***********************************************************
C
      ISTEPN='15.2'
      IF(IBUGPL.EQ.'ON'.OR.ISUBRO.EQ.'DELI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      XD=X3DMID
      YD1=Y3DMID
      YD2=Y3DMID
      ZD1=Z3DMID
      ZD2=Z3DMID
C
C     ***** 7 LINES OF CODE TO ADJUST FOR DIVISION BY 0 ADDED AUGUST 1983 *****
      XDEL=X3DEYE-X3DMID
      IF(XDEL.EQ.0.0)XDEL=EPS
      YDEL=Y3DEYE-Y3DMID
      IF(YDEL.EQ.0.0)YDEL=EPS
      ZDEL=Z3DEYE-Z3DMID
      IF(ZDEL.EQ.0.0)ZDEL=EPS
C
      DISC=1.0+(ZDEL/YDEL)**2
      DENOM=0.0
      IF(DISC.GT.0.0)DENOM=SQRT(DISC)
      IF(DISC.LT.0.0)GOTO1520
      ZD1=Z3DMID+RADIUS/DENOM
      ZD2=Z3DMID+RADIUS/(-DENOM)
      YD1=CPUMIN
      IF(YDEL.NE.0.0)YD1=Y3DMID-ZDEL*(ZD1-Z3DMID)/YDEL
      YD2=CPUMAX
      IF(YDEL.NE.0.0)YD2=Y3DMID-ZDEL*(ZD2-Z3DMID)/YDEL
 1520 CONTINUE
C
      XPRIME(7)=X3DMID
      YPRIME(7)=YD1
      ZPRIME(7)=ZD1
C
      XPRIME(8)=X3DMID
      YPRIME(8)=YD2
      ZPRIME(8)=ZD2
C
      IF(IBUGPL.NE.'ON'.AND.ISUBRO.NE.'DELI')GOTO1529
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1521)X3DMID,RADIUS
 1521 FORMAT('X3DMID,RADIUS = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1522)DISC,DENOM
 1522 FORMAT('DISC,DENOM = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1523)XD,YD1,YD2,ZD1,ZD2
 1523 FORMAT('XD,YD1,YD2,ZD1,ZD2 = ',5E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1524)XPRIME(7),YPRIME(7),ZPRIME(7)
 1524 FORMAT('XPRIME(7),YPRIME(7),ZPRIME(7)    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1525)XPRIME(8),YPRIME(8),ZPRIME(8)
 1525 FORMAT('XPRIME(8),YPRIME(8),ZPRIME(8)    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
 1529 CONTINUE
C
C               ***********************************************************
C               **  STEP 15.3--                                          **
C               **  DETERMINE THE 2 POINTS ON THIS CIRCLE OF VISIBILITY  **
C               **  WHICH INTERSECT WITH THE Y = Y3DMID PLANE.             **
C               ***********************************************************
C
      ISTEPN='15.3'
      IF(IBUGPL.EQ.'ON'.OR.ISUBRO.EQ.'DELI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      XD1=X3DMID
      XD2=X3DMID
      YD=Y3DMID
      ZD1=Z3DMID
      ZD2=Z3DMID
C
C     ***** 3 LINES OF CODE TO CHECK FOR DIVISION BY 0 ADDED AUGUST 1983 *****
      DISC=CPUMAX
      IF(XDEL.NE.0.0)DISC=1.0+(ZDEL/XDEL)**2
      DENOM=0.0
      IF(DISC.GT.0.0)DENOM=SQRT(DISC)
      IF(DISC.LT.0.0)GOTO1530
      ZD1=Z3DMID+RADIUS/DENOM
      ZD2=Z3DMID+RADIUS/(-DENOM)
      XD1=CPUMIN
      IF(XDEL.NE.0.0)XD1=X3DMID-ZDEL*(ZD1-Z3DMID)/XDEL
      XD2=CPUMAX
      IF(XDEL.NE.0.0)XD2=X3DMID-ZDEL*(ZD2-Z3DMID)/XDEL
C
 1530 CONTINUE
      XPRIME(9)=XD1
      YPRIME(9)=Y3DMID
      ZPRIME(9)=ZD1
C
      XPRIME(10)=XD2
      YPRIME(10)=Y3DMID
      ZPRIME(10)=ZD2
C
      IF(IBUGPL.NE.'ON'.AND.ISUBRO.NE.'DELI')GOTO1539
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1531)Y3DMID,RADIUS
 1531 FORMAT('Y3DMID,RADIUS = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1532)DISC,DENOM
 1532 FORMAT('DISC,DENOM = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1533)XD1,XD2,YD,ZD1,ZD2
 1533 FORMAT('XD1,XD2,YD,ZD1,ZD2 = ',5E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1534)XPRIME(9),YPRIME(9),ZPRIME(9)
 1534 FORMAT('XPRIME(9),YPRIME(9),ZPRIME(9)    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1535)XPRIME(10),YPRIME(10),ZPRIME(10)
 1535 FORMAT('XPRIME(10),YPRIME(10),ZPRIME(10) = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
 1539 CONTINUE
C
C               ***********************************************************
C               **  STEP 15.4--                                          **
C               **  DETERMINE THE 2 POINTS ON THIS CIRCLE OF VISIBILITY  **
C               **  WHICH INTERSECT WITH THE Z = Z3DMID PLANE.             **
C               ***********************************************************
C
      ISTEPN='15.4'
      IF(IBUGPL.EQ.'ON'.OR.ISUBRO.EQ.'DELI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      XD1=X3DMID
      XD2=X3DMID
      YD1=Y3DMID
      YD2=Y3DMID
      ZD=Z3DMID
C
C     ***** 3 LINES OF CODE TO CHECK FOR DIVISION BY 0 ADDED AUGUST 1983 *****
      DISC=CPUMAX
      IF(YDEL.NE.0.0)DISC=1.0+(XDEL/YDEL)**2
      DENOM=0.0
      IF(DISC.GT.0.0)DENOM=SQRT(DISC)
      IF(DISC.LT.0.0)GOTO1540
      XD1=X3DMID+RADIUS/DENOM
      XD2=X3DMID+RADIUS/(-DENOM)
      YD1=CPUMIN
      IF(YDEL.NE.0.0)YD1=Y3DMID-XDEL*(XD1-X3DMID)/YDEL
      YD2=CPUMAX
      IF(YDEL.NE.0.0)YD2=Y3DMID-XDEL*(XD2-X3DMID)/YDEL
C
 1540 CONTINUE
      XPRIME(11)=XD1
      YPRIME(11)=YD1
      ZPRIME(11)=Z3DMID
C
      XPRIME(12)=XD2
      YPRIME(12)=YD2
      ZPRIME(12)=Z3DMID
C
      IF(IBUGPL.NE.'ON'.AND.ISUBRO.NE.'DELI')GOTO1549
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1541)Z3DMID,RADIUS
 1541 FORMAT('Z3DMID,RADIUS = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1542)DISC,DENOM
 1542 FORMAT('DISC,DENOM = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1543)XD1,XD2,YD1,YD2,ZD
 1543 FORMAT('XD1,XD2,YD1,YD2,ZD = ',5E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1544)XPRIME(11),YPRIME(11),ZPRIME(11)
 1544 FORMAT('XPRIME(11),YPRIME(11),ZPRIME(11) = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1545)XPRIME(12),YPRIME(12),ZPRIME(12)
 1545 FORMAT('XPRIME(12),YPRIME(12),ZPRIME(12) = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
 1549 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGPL.NE.'ON'.AND.ISUBRO.NE.'DELI')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF D3DELI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGPL,ISUBRO,IERROR
 9012 FORMAT('IBUGPL,ISUBRO,IERROR = ',3A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)N
 9021 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9022I=1,N
      WRITE(ICOUT,9023)I,X(I),Y(I),Z(I)
 9023 FORMAT('I,X(I),Y(I),Z(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
 9022 CONTINUE
      WRITE(ICOUT,9031)X3DMIN,Y3DMIN,Z3DMIN
 9031 FORMAT('X3DMIN,Y3DMIN,Z3DMIN       = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9032)X3DMAX,Y3DMAX,Z3DMAX
 9032 FORMAT('X3DMAX,Y3DMAX,Z3DMAX       = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9033)X3DMID,Y3DMID,Z3DMID
 9033 FORMAT('X3DMID,Y3DMID,Z3DMID       = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9034)X3DRAN,Y3DRAN,Z3DRAN
 9034 FORMAT('X3DRAN,Y3DRAN,Z3DRAN = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9041)XEYE0,YEYE0,ZEYE0
 9041 FORMAT('XEYE0,YEYE0,ZEYE0    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9042)X3DEYE,Y3DEYE,Z3DEYE
 9042 FORMAT('X3DEYE,Y3DEYE,Z3DEYE       = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9043)XORIG,YORIG,ZORIG
 9043 FORMAT('XORIG,YORIG,ZORIG    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9044)X3DORI,Y3DORI,Z3DORI
 9044 FORMAT('X3DORI,Y3DORI,Z3DORI = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      DO9051I=1,12
      WRITE(ICOUT,9052)I,XPRIME(I),YPRIME(I),ZPRIME(I)
 9052 FORMAT('I,XPRIME(I),YPRIME(I),ZPRIME(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
 9051 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE D3DEMD(X,Y,Z,TEMP,N,
     1XDELMN,YDELMN,ZDELMN)
C
C     PURPOSE--COMPUTE MINIMUM DIFFERENCE
C              BETWEEN X VALUES,
C              BETWEEN Y VALUES,
C              BETWEEN Z VALUES.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--88/11
C     ORIGINAL VERSION--OCTOBER   1979.
C     UPDATED         --JULY      1989.  CHAR*4 STATEMETN FOR IWRITE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1989
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOBE.INC'
C
      DIMENSION X(*)
      DIMENSION Y(*)
      DIMENSION Z(*)
      DIMENSION TEMP(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='D3DE'
      ISUBN2='MD  '
C
      IF(IBUGG4.NE.'ON'.AND.ISUBG4.NE.'DEMD')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF D3DEMD--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGG4,ISUBG4,IERRG4
   52 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',3A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,71)N
   71 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO72I=1,N
      WRITE(ICOUT,73)I,X(I),Y(I),Z(I)
   73 FORMAT('I,X(I),Y(I),Z(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
   72 CONTINUE
   90 CONTINUE
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  COMPUTE MINIMUM DIFFERENCES               **
C               ************************************************
C
      ISTEPN='11'
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'DEMD')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IWRITE='OFF'
C
      XDELMN=CPUMAX
      CALL DISTIN(X,N,IWRITE,TEMP,NTEMP,IBUGG4,IERRG4)
      CALL SORT(TEMP,NTEMP,TEMP)
      IF(NTEMP.LE.1)XDELMN=0.0
      IF(NTEMP.LE.1)GOTO1190
      DO1100I=2,NTEMP
      IM1=I-1
      DEL=TEMP(I)-TEMP(IM1)
      IF(DEL.LE.0.0)GOTO1100
      IF(DEL.LT.XDELMN)XDELMN=DEL
 1100 CONTINUE
 1190 CONTINUE
C
      YDELMN=CPUMAX
      CALL DISTIN(Y,N,IWRITE,TEMP,NTEMP,IBUGG4,IERRG4)
      CALL SORT(TEMP,NTEMP,TEMP)
      IF(NTEMP.LE.1)YDELMN=0.0
      IF(NTEMP.LE.1)GOTO1290
      DO1200I=2,NTEMP
      IM1=I-1
      DEL=TEMP(I)-TEMP(IM1)
      IF(DEL.LE.0.0)GOTO1200
      IF(DEL.LT.YDELMN)YDELMN=DEL
 1200 CONTINUE
 1290 CONTINUE
C
      ZDELMN=CPUMAX
      CALL DISTIN(Z,N,IWRITE,TEMP,NTEMP,IBUGG4,IERRG4)
      CALL SORT(TEMP,NTEMP,TEMP)
      IF(NTEMP.LE.1)ZDELMN=0.0
      IF(NTEMP.LE.1)GOTO1390
      DO1300I=2,NTEMP
      IM1=I-1
      DEL=TEMP(I)-TEMP(IM1)
      IF(DEL.LE.0.0)GOTO1300
      IF(DEL.LT.ZDELMN)ZDELMN=DEL
 1300 CONTINUE
 1390 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.NE.'ON'.AND.ISUBG4.NE.'DEMD')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF D3DEMD--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGG4,ISUBG4,IERRG4
 9012 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',3A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)N,NTEMP
 9021 FORMAT('N,NTEMP = ',2I8)
      CALL DPWRST('XXX','BUG ')
      DO9022I=1,N
      WRITE(ICOUT,9023)I,X(I),Y(I),Z(I),TEMP(I)
 9023 FORMAT('I,X(I),Y(I),Z(I),TEMP(I) = ',I8,4E15.7)
      CALL DPWRST('XXX','BUG ')
 9022 CONTINUE
      WRITE(ICOUT,9031)XDELMN,YDELMN,ZDELMN
 9031 FORMAT('XDELMN,YDELMN,ZDELMN = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE D3DRBA(XRAW,YRAW,ZRAW,NP,
     1PX,PY,PZ,PX2,PY2,PZ2,PX3,PY3,
     1ICASPL,ICAS3D,
     1ISORSW,
     1IBA2SW,ABA2WI,ABA2BA,
     1IBA2BL,IBA2BC,PBA2BT,
     1IBA2FS,IBA2FC,
     1IBA2PT,IBA2PL,IBA2PC,IBA2TY,IBA2DI,PBA2PS,PBA2PT,
     1XDELMN,YDELMN,ZDELMN,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1FX1MIN,FX1MAX,FY1MIN,FY1MAX,
     1IX1TSC,IY1TSC)
C
C     PURPOSE--FOR A GENERAL GRAPHICS DEVICE,
C              AND FOR EACH VALUE IN X(.), DRAW A BAR
C              (= VERTICAL OR HORIZONTAL BAR)
C              FROM THE BASE POINT ABA2BA
C              TO THE POINT Y(.).
C              DO SO FOR A SPECIFIED BAR LINE TYPE,
C              LINES COLOR, AND LINE THICKNESS.
C     NOTE--THE VARIABLES PY(.) AND PX(.) ARE DUMMY VARIABLES
C           WHICH ARE USED IN THE INTERMEDIATE CALCULATIONS
C           AND WHOSE DIMENSIONS ARE DEFINED (FOR EASY OF CHANGE)
C           BACK IN THE MAIN ROUTINE.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--87.5
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED         --MAY       1987.
C     UPDATED         --MARCH     1988.  TO FIX PROBLEM WHEREBY ONLY FIRST BAR
C                                        HAD PROPER PATTERN (STOLNICKI).
C     UPDATED         --SEPTEMBER 1988.  RENUMBER
C     UPDATED         --APRIL     1992.  ASP2BA  TO  ABA2BA
C     UPDATED         --APRIL     1992.  IPATTT TO IPATT
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAS3D
C
      CHARACTER*4 ISORSW
C
      CHARACTER*4 IBA2SW
      CHARACTER*4 IBA2BL
      CHARACTER*4 IBA2BC
      CHARACTER*4 IBA2FS
      CHARACTER*4 IBA2FC
      CHARACTER*4 IBA2PT
      CHARACTER*4 IBA2PL
      CHARACTER*4 IBA2PC
      CHARACTER*4 IBA2TY
      CHARACTER*4 IBA2DI
C
      CHARACTER*4 IX1TSC
      CHARACTER*4 IY1TSC
C
      CHARACTER*4 ITYPE
C
      CHARACTER*4 IFIG
      CHARACTER*4 IPATT
      CHARACTER*4 ICOL
CCCCC CHARACTER*4 ICOLF
CCCCC CHARACTER*4 ICOLP
      CHARACTER*4 IDIR
C
      CHARACTER*4 IHORPA
      CHARACTER*4 IVERPA
      CHARACTER*4 IDUPPA
      CHARACTER*4 IDDOPA
C
CCCCC CHARACTER*4 IFIGSV
C
      DIMENSION XRAW(*)
      DIMENSION YRAW(*)
      DIMENSION ZRAW(*)
      DIMENSION PX(*)
      DIMENSION PY(*)
      DIMENSION PZ(*)
      DIMENSION PX2(*)
      DIMENSION PY2(*)
      DIMENSION PZ2(*)
      DIMENSION PX3(*)
      DIMENSION PY3(*)
C
      DIMENSION XVECT(2)
      DIMENSION YVECT(2)
      DIMENSION ZVECT(2)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
      INCLUDE 'DPCO3D.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      HOLD=1.0
      ABASE=0.0
      PBASE=0.0
      PBASE2=0.0
      PLEFT=0.0
      PRIGHT=0.0
      AWIDTH=0.0
      PWIDTH=0.0
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      FYMIN=FY1MIN
      FYMAX=FY1MAX
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRBA')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF D3DRBA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)NP
   52 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)ICASPL,ICAS3D
   53 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)XDELMN,YDELMN,ZDELMN
   54 FORMAT('XDELMN,YDELMN,ZDELMN = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      IF(NP.LE.3)GOTO69
      DO65I=1,3
      WRITE(ICOUT,66)I,XRAW(I),YRAW(I),ZRAW(I)
   66 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
   65 CONTINUE
      NPM2=NP-2
      DO67I=NPM2,NP
      WRITE(ICOUT,68)I,XRAW(I),YRAW(I),ZRAW(I)
   68 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
   67 CONTINUE
   69 CONTINUE
      WRITE(ICOUT,70)ISORSW
   70 FORMAT('ISORSW = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,71)IBA2SW,ABA2WI,ABA2BA
   71 FORMAT('IBA2SW,ABA2WI,ABA2BA = ',A4,2X,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,72)IBA2BL,IBA2BC,PBA2BT
   72 FORMAT('IBA2BL,IBA2BC,PBA2BT = ',A4,2X,A4,2X,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,73)IBA2FS,IBA2FC
   73 FORMAT('IBA2FS,IBA2FC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,74)IBA2PT,IBA2PL,IBA2PC,IBA2TY,IBA2DI,PBA2PS,PBA2PT
   74 FORMAT('IBA2PT,IBA2PL,IBA2PC,IBA2TY,IBA2DI,PBA2PS,PBA2PT = ',
     1A4,2X,A4,2X,A4,2X,A4,2X,A4,2X,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,81)X3DEYE,Y3DEYE,Z3DEYE
   81 FORMAT('X3DEYE,Y3DEYE,Z3DEYE = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,84)PXMIN,PXMAX,PYMIN,PYMAX
   84 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,85)FX1MIN,FX1MAX,FY1MIN,FY1MAX
   85 FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,86)IX1TSC,IY1TSC
   86 FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,89)IBUGG4,ISUBG4,IERRG4
   89 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               *************************************************
C               **  STEP 11--                                  **
C               **  IF CALLED FOR, SORT THE DATA               **
C               **  ACCORDING TO THE HORIZONTAL AXIS VARIABLE  **
C               *************************************************
C
      IDIR=IBA2DI
C
      IF(ISORSW.EQ.'OFF')GOTO1150
      IF(ICASPL.EQ.'PIEC')GOTO1150
      IF(ICAS3D.EQ.'ON')GOTO1150
      IF(ICASPL.EQ.'CONT')GOTO1150
C
C
C     12/2009: NEED TO MODIFY THIS SORT LINE.
CCCCC CALL SORTC(X,Y,NP,PX,PY)
      GOTO1190
C
 1150 CONTINUE
      DO1160I=1,NP
      PX(I)=XRAW(I)
      PY(I)=YRAW(I)
      PZ(I)=ZRAW(I)
 1160 CONTINUE
      GOTO1190
C
 1190 CONTINUE
C
C               ************************************************
C               **  STEP 12--                                 **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,        **
C               **  CHECK THAT ALL DATA POINTS ARE POSITIVE.  **
C               ************************************************
C
      IF(IX1TSC.EQ.'LOG')GOTO1210
      GOTO1290
C
 1210 CONTINUE
      IF(IDIR.EQ.'H')GOTO1215
      GOTO1219
 1215 CONTINUE
CCCCC THE FOLLOWING 2 LINES WERE FIXED    APRIL 1992 (ALAN)
CCCCC IF(ASP2BA.LE.0.0)HOLD=ASP2BA
CCCCC IF(ASP2BA.LE.0.0)GOTO1250
      IF(ABA2BA.LE.0.0)HOLD=ABA2BA
      IF(ABA2BA.LE.0.0)GOTO1250
 1219 CONTINUE
C
      IF(ISORSW.EQ.'ON')GOTO1220
      GOTO1230
C
 1220 CONTINUE
      J=1
      IF(PX(J).LE.0.0)GOTO1250
      GOTO1290
C
 1230 CONTINUE
      DO1235I=1,NP
      J=I
      IF(PX(J).LE.0.0)GOTO1250
 1235 CONTINUE
      GOTO1290
C
 1250 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1251)
 1251 FORMAT('***** ERROR IN D3DRBA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1252)
 1252 FORMAT('      THE LOG OF A NON-POSITIVE DATA VALUE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1253)
 1253 FORMAT('      WAS ENCOUNTERED IN FORMING A PLOT.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1254)
 1254 FORMAT('      DATA MAY NOT BE ZERO OR NEGATIVE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1255)
 1255 FORMAT('      WHEN A LOG SCALE PLOT IS USED.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1256)PX(J)
 1256 FORMAT('      THE VALUE = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1257)
 1257 FORMAT('      THIS VALUE CAME FROM THE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1258)
 1258 FORMAT('      HORIZONTAL AXIS VARIABLE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1259)
 1259 FORMAT('      CORRECTIVE ACTION--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1260)
 1260 FORMAT('      CHANGE DATA OR CHANGE LIMITS.')
      CALL DPWRST('XXX','BUG ')
      IERRG4='YES'
      GOTO9000
C
 1290 CONTINUE
C
      IF(IY1TSC.EQ.'LOG')GOTO1310
      GOTO1390
C
 1310 CONTINUE
      IF(IDIR.EQ.'V')GOTO1315
      GOTO1319
 1315 CONTINUE
CCCCC THE FOLLOWING 2 LINES WERE FIXED    APRIL 1992 (ALAN)
CCCCC IF(ASP2BA.LE.0.0)HOLD=ASP2BA
CCCCC IF(ASP2BA.LE.0.0)GOTO1350
      IF(ABA2BA.LE.0.0)HOLD=ABA2BA
      IF(ABA2BA.LE.0.0)GOTO1350
 1319 CONTINUE
C
      IF(ISORSW.EQ.'ON')GOTO1320
      GOTO1330
C
 1320 CONTINUE
      J=1
      IF(PY(J).LE.0.0)HOLD=PY(J)
      IF(PY(J).LE.0.0)GOTO1350
      GOTO1390
C
 1330 CONTINUE
      DO1335I=1,NP
      J=I
      IF(PY(J).LE.0.0)HOLD=PY(J)
      IF(PY(J).LE.0.0)GOTO1350
 1335 CONTINUE
      GOTO1390
C
 1350 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1351)
 1351 FORMAT('***** ERROR IN D3DRBA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1352)
 1352 FORMAT('      THE LOG OF A NON-POSITIVE DATA VALUE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1353)
 1353 FORMAT('      WAS ENCOUNTERED IN FORMING A PLOT.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1354)
 1354 FORMAT('      DATA MAY NOT BE ZERO OR NEGATIVE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1355)
 1355 FORMAT('      WHEN A LOG SCALE PLOT IS USED.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1356)HOLD
 1356 FORMAT('      THE VALUE = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1357)
 1357 FORMAT('      THIS VALUE CAME FROM THE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1358)
 1358 FORMAT('      VERTICAL AXIS VARIABLE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1359)
 1359 FORMAT('      CORRECTIVE ACTION--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1360)
 1360 FORMAT('      CHANGE DATA OR CHANGE LIMITS.')
      CALL DPWRST('XXX','BUG ')
      IERRG4='YES'
      GOTO9000
C
 1390 CONTINUE
C
C               ******************************************
C               **  STEP 40--                           **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,  **
C               **  TRANSFORM THE DATA                  **
C               ******************************************
C
      ABASE=ABA2BA
      AWIDTH=ABA2WI
C
      WIDTHX=AWIDTH
      IF(WIDTHX.EQ.CPUMIN.AND.XDELMN.LE.0.0)WIDTHX=1.0
      IF(WIDTHX.EQ.CPUMIN.AND.XDELMN.GT.0.0)WIDTHX=XDELMN
      WIDTHY=AWIDTH
      IF(WIDTHY.EQ.CPUMIN.AND.YDELMN.LE.0.0)WIDTHY=1.0
      IF(WIDTHY.EQ.CPUMIN.AND.YDELMN.GT.0.0)WIDTHY=YDELMN
      WIDTHZ=AWIDTH
      IF(WIDTHZ.EQ.CPUMIN.AND.ZDELMN.LE.0.0)WIDTHZ=1.0
      IF(WIDTHZ.EQ.CPUMIN.AND.ZDELMN.GT.0.0)WIDTHZ=ZDELMN
C
      IF(IX1TSC.EQ.'LOG')GOTO4010
      GOTO4019
 4010 CONTINUE
      IF(IDIR.EQ.'H')ABASE=LOG10(ABASE)
      DO4015I=1,NP
      PX(I)=LOG10(PX(I))
 4015 CONTINUE
 4019 CONTINUE
C
      IF(IY1TSC.EQ.'LOG')GOTO4020
      GOTO4029
 4020 CONTINUE
      IF(IDIR.EQ.'V')ABASE=LOG10(ABASE)
      DO4025I=1,NP
      PY(I)=LOG10(PY(I))
 4025 CONTINUE
 4029 CONTINUE
C
C               *******************************
C               **  STEP 60--                **
C               **  PREPARE TO MAKE VARIOUS  **
C               **  LINE SETTINGS            **
C               *******************************
C
      ITYPE='LINE'
C
C               **********************************************
C               **  STEP 61--                               **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE LINE PATTERN                     **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      IPATT=IBA2BL
      CALL GRTRPA(ITYPE,IPATT,PXSPA,PYSPA,
     1JPATT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               *******************************
C               **  STEP 62--                **
C               **  SET THE LINE PATTERN     **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSEPA(ITYPE,IPATT,PXSPA,PYSPA,
     1JPATT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               **********************************************
C               **  STEP 63--                               **
C               **  TRANSLATE THE  DESIRED                  **
C               **  LINE THICKNESS                          **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      PTHICK=PBA2BT
      CALL GRTRTH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               *******************************
C               **  STEP 64--                **
C               **  SET THE LINE THICKNESS   **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSETH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               **********************************************
C               **  STEP 65--                               **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE LINE COLOR                       **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      ICOL=IBA2BC
      CALL GRTRCO(ITYPE,ICOL,JCOL)
C
C               *******************************
C               **  STEP 66--                **
C               **  SET THE LINE COLOR       **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSECO(ITYPE,ICOL,JCOL)
C
C               **************************************************
C               **  STEP 71--                                   **
C               **  FOR EACH RAW 3-D DATA POINT--               **
C               **     1) MAKE THE BAR                          **
C               **     2) TRANSLATE IT TO 2 DIMENSIONS          **
C               **     3) TRANSLATE IT TO 0-100 UNITS           **
C               **     4) CLIP THE BAR   IF NEEDED              **
C               **     5) DRAW OUT THE BAR                      **
C               **************************************************
C
      IFIG='GENE'
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      IF(IX1TSC.EQ.'LOG')FXMIN=LOG10(FX1MIN)
      IF(IX1TSC.EQ.'LOG')FXMAX=LOG10(FX1MAX)
C
      FYMIN=FY1MIN
      FYMAX=FY1MAX
      IF(IY1TSC.EQ.'LOG')FYMIN=LOG10(FY1MIN)
      IF(IY1TSC.EQ.'LOG')FYMAX=LOG10(FY1MAX)
C
      FXRANG=FXMAX-FXMIN
      FYRANG=FYMAX-FYMIN
      PXRANG=PXMAX-PXMIN
      PYRANG=PYMAX-PYMIN
C
C
      BASEX=ABASE
      BASEY=ABASE
      BASEZ=ABASE
C
      DO7100I=1,NP
C
      CALL D3MKBA(PX,PY,PZ,NP,I,
     1IDIR,
     1WIDTHX,WIDTHY,WIDTHZ,
     1BASEX,BASEY,BASEZ,
     1XVECT,YVECT,ZVECT,IXNEAR,IXFAR,IYNEAR,IYFAR,IZNEAR,IZFAR,
     1PX2,PY2,PZ2,NP2)
C
      CALL D3TR32(PX2,PY2,PZ2,NP2,PX3,PY3,NP3)
C
      CALL D3TRXP(PX3,PY3,NP3,IDIR,ABASE,
     1FXMIN,FXMAX,FXRANG,FYMIN,FYMAX,FYRANG,
     1PXMIN,PXMAX,PXRANG,PYMIN,PYMAX,PYRANG,
     1PX3,PY3,NP3,PBASE)
C
      CALL DPSQUE(PX3,PY3,NP3,
     1PXMIN,PXMAX,PYMIN,PYMAX)
C
      CALL GRDRPL(PX3,PY3,NP3,
CCCCC THE FOLLOWING LINE WAS FIXED   APRIL 1992
CCCCC1IFIG,IPATTT,PTHICK,ICOL,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATTT,JTHICK,PTHIC2,JCOL)
C
 7100 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRBA')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF D3DRBA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)NP
 9012 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICASPL,ICAS3D
 9013 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)ABASE,HOLD,PBASE,PBASE2,PLEFT,PRIGHT
 9014 FORMAT('ABASE,HOLD,PBASE,PBASE2,PLEFT,PRIGHT = ',6E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)XDELMN,YDELMN,ZDELMN,AWIDTH,PWIDTH
 9015 FORMAT('XDELMN,YDELMN,ZDELMN,AWIDTH,PWIDTH = ',5E15.7)
      CALL DPWRST('XXX','BUG ')
      IF(NP.LE.3)GOTO9029
      DO9025I=1,3
      WRITE(ICOUT,9026)I,XRAW(I),YRAW(I),ZRAW(I)
 9026 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
 9025 CONTINUE
      NPM2=NP-2
      DO9027I=NPM2,NP
      WRITE(ICOUT,9028)I,XRAW(I),YRAW(I),ZRAW(I)
 9028 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
 9027 CONTINUE
 9029 CONTINUE
      WRITE(ICOUT,9030)ISORSW
 9030 FORMAT('ISORSW = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9031)IBA2SW,ABA2WI,ABA2BA
 9031 FORMAT('IBA2SW,ABA2WI,ABA2BA = ',A4,2X,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9032)IBA2BL,IBA2BC,PBA2BT
 9032 FORMAT('IBA2BL,IBA2BC,PBA2BT = ',A4,2X,A4,2X,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9033)IBA2FS,IBA2FC
 9033 FORMAT('IBA2FS,IBA2FC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9034)IBA2PT,IBA2PL,IBA2PC,IBA2TY,IBA2DI,PBA2PS,PBA2PT
 9034 FORMAT('IBA2PT,IBA2PL,IBA2PC,IBA2TY,IBA2DI,PBA2PS,PBA2PT = ',
     1A4,2X,A4,2X,A4,2X,A4,2X,A4,2X,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9041)X3DEYE,Y3DEYE,Z3DEYE
 9041 FORMAT('X3DEYE,Y3DEYE,Z3DEYE    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9042)WIDTHX,WIDTHY,WIDTHZ
 9042 FORMAT('WIDTHX,WIDTHY,WIDTHZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9043)BASEX,BASEY,BASEZ
 9043 FORMAT('BASEX,BASEY,BASEZ    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9044)PXMIN,PXMAX,PYMIN,PYMAX
 9044 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9045)FX1MIN,FX1MAX,FY1MIN,FY1MAX
 9045 FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9046)FXMIN,FXMAX,FYMIN,FYMAX
 9046 FORMAT('FXMIN,FXMAX,FYMIN,FYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9047)IX1TSC,IY1TSC
 9047 FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9051)IFIG
 9051 FORMAT('IFIG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9052)IPATT,JPATT
 9052 FORMAT('IPATT,JPATT = ',A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9053)PTHICK,JTHICK,PTHIC2
 9053 FORMAT('PTHICK,JTHICK,PTHIC2 = ',E15.7,I8,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9054)ICOL,JCOL,IDIR
 9054 FORMAT('ICOL,JCOL,IDIR = ',A4,I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9055)ITYPE
 9055 FORMAT('ITYPE = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9069)IBUGG4,ISUBG4,IERRG4
 9069 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE D3DRCH(XRAW,YRAW,ZRAW,PX,PY,PZ,NP,PY2,PX2,NP2,
     1X3D2,
     1ICASPL,ICAS3D,
     1ISORSW,
     1ICH2PA,ICH2FO,ICH2CA,ICH2JU,ICH2DI,ACH2AN,ICH2FI,ICH2CO,
     1PCH2HE,PCH2WI,PCH2TH,PCH2HO,PCH2VO,
     1ITEXSP,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1FX1MIN,FX1MAX,FY1MIN,FY1MAX,
     1IX1TSC,IY1TSC,
     1IMPSW2,AMPSCH,AMPSCW)
C
C     PURPOSE--FOR A GENERAL GRAPHICS DEVICE,
C              DRAW A CHARACTER TRACE OF Y(.) VERSUS X(.),
C              THAT IS, DRAW A SPECIFIED MARKER (= CHARACTER) TYPE
C              AT EACH OF THE PLOT POINTS.
C     NOTE--THE VARIABLES PY(.) AND PX(.) ARE DUMMY VARIABLES
C           WHICH ARE USED IN THE INTERMEDIATE CALCULATIONS
C           AND WHOSE DIMENSIONS ARE DEFINED (FOR EASY OF CHANGE)
C           BACK IN THE MAIN ROUTINE.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED         --DECEMBER  1987.  INDEPENDENT CONTROL OF CHAR WIDTH.
C     UPDATED         --SEPTEMBER 1988.  LOG/WEIBULL CHECK AS A SUBROUTINE
C     UPDATED         --SEPTEMBER 1988.  RENUMBER
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAS3D
C
      CHARACTER*4 ISORSW
C
      CHARACTER*16 ICH2PA
      CHARACTER*4 ICH2FO
      CHARACTER*4 ICH2CA
      CHARACTER*4 ICH2JU
      CHARACTER*4 ICH2DI
      CHARACTER*4 ICH2FI
      CHARACTER*4 ICH2CO
C
      CHARACTER*4 ITEXSP
C
      CHARACTER*4 IX1TSC
      CHARACTER*4 IY1TSC
C
      CHARACTER*4 IFIG
      CHARACTER*16 IPATT
      CHARACTER*4 IFONT
      CHARACTER*4 ICASE
      CHARACTER*4 IJUST
      CHARACTER*4 IDIR
      CHARACTER*4 IFILL
      CHARACTER*4 ICOL
C
      CHARACTER*16 ISYMBL
      CHARACTER*4 ISPAC
      CHARACTER*4 IMPSW2
C
      CHARACTER*4 ICASAX
C
      DIMENSION XRAW(*)
      DIMENSION YRAW(*)
      DIMENSION ZRAW(*)
      DIMENSION PX(*)
      DIMENSION PY(*)
      DIMENSION PZ(*)
      DIMENSION PY2(*)
      DIMENSION PX2(*)
      DIMENSION X3D2(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
      INCLUDE 'DPCO3D.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      FYMIN=FY1MIN
      FYMAX=FY1MAX
C
      AHUNDR=100.0
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRCH')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF D3DRCH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)NP
   52 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)ICASPL,ICAS3D
   53 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      IF(NP.LE.3)GOTO69
      DO65I=1,3
      WRITE(ICOUT,66)I,XRAW(I),YRAW(I),ZRAW(I)
   66 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
   65 CONTINUE
      NPM2=NP-2
      DO67I=NPM2,NP
      WRITE(ICOUT,68)I,XRAW(I),YRAW(I),ZRAW(I)
   68 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
   67 CONTINUE
   69 CONTINUE
      WRITE(ICOUT,70)ISORSW
   70 FORMAT('ISORSW = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,74)ICH2PA
   74 FORMAT('ICH2PA= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,75)ICH2FO
   75 FORMAT('ICH2FO= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,76)ICH2JU
   76 FORMAT('ICH2JU= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,77)ICH2DI
   77 FORMAT('ICH2DI= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,78)ACH2AN
   78 FORMAT('ACH2AN= ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,79)ICH2FI
   79 FORMAT('ICH2FI= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,80)ICH2CO
   80 FORMAT('ICH2CO= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,81)PCH2HE
   81 FORMAT('PCH2HE= ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,82)PCH2WI
   82 FORMAT('PCH2WI= ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,83)PCH2TH,PCH2VO,PCH2HO
   83 FORMAT('PCH2TH,PCH2VO,PCH2HO= ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,84)ITEXSP
   84 FORMAT('ITEXSP = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,85)PXMIN,PXMAX,PYMIN,PYMAX
   85 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,86)FX1MIN,FX1MAX,FY1MIN,FY1MAX
   86 FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,87)IX1TSC,IY1TSC
   87 FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,89)IBUGG4,ISUBG4,IERRG4
   89 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               *************************************************
C               **  STEP 10--                                  **
C               **  IF CALLED FOR, SORT THE DATA               **
C               **  ACCORDING TO THE HORIZONTAL AXIS VARIABLE  **
C               *************************************************
C
      IF(ISORSW.EQ.'OFF')GOTO1150
      IF(ICASPL.EQ.'PIEC')GOTO1150
      IF(ICAS3D.EQ.'ON')GOTO1150
C
CCCCC CALL SORTC(X,Y,NP,PX,PY)
      GOTO1190
C
 1150 CONTINUE
      DO1160I=1,NP
      PX(I)=XRAW(I)
      PY(I)=YRAW(I)
      PZ(I)=ZRAW(I)
 1160 CONTINUE
      GOTO1190
C
 1190 CONTINUE
C
C               **********************************************************
C               **  STEP 21--                                           **
C               **  IF A NON-LINEAR SCALE PLOT IS CALLED FOR,           **
C               **  CHECK THAT ALL   HORIZ. AXIS DATA POINTS            **
C               **  ARE IN VALID RANGE.                                 **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,                  **
C               **  CHECK THAT ALL   HORIZ.  AXIS DATA POINTS ARE > 0.  **
C               **  IF A WEIBULL SCALE PLOT IS CALLED FOR,              **
C               **  CHECK THAT ALL   HORIZ. AXIS DATA POINTS ARE        **
C               **  STRICTLY > 0 AND STRICTLY < 100                     **
C               **********************************************************
C
      IF(IX1TSC.EQ.'LOG')GOTO2110
      GOTO2119
 2110 CONTINUE
      ICASAX='2DHO'
      CALL CKLOSC(PX,NP,ISORSW,ICASAX,
     1ISUBG4,IBUGG4,IERRG4)
      IF(IERRG4.EQ.'YES')GOTO9000
 2119 CONTINUE
C
      IF(IX1TSC.EQ.'WEIB')GOTO2120
      GOTO2129
 2120 CONTINUE
      ICASAX='2DHO'
      CALL CKPRSC(PX,NP,ISORSW,ICASAX,
     1ISUBG4,IBUGG4,IERRG4)
      IF(IERRG4.EQ.'YES')GOTO9000
 2129 CONTINUE
C
C               **********************************************************
C               **  STEP 22--                                           **
C               **  IF A NON-LINEAR SCALE PLOT IS CALLED FOR,           **
C               **  CHECK THAT ALL   VERT.  AXIS DATA POINTS            **
C               **  ARE IN VALID RANGE.                                 **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,                  **
C               **  CHECK THAT ALL   VERT.   AXIS DATA POINTS ARE > 0.  **
C               **  IF A WEIBULL SCALE PLOT IS CALLED FOR,              **
C               **  CHECK THAT ALL   VERT.  AXIS DATA POINTS ARE        **
C               **  STRICTLY > 0 AND STRICTLY < 100                     **
C               **********************************************************
C
      IF(IY1TSC.EQ.'LOG')GOTO2210
      GOTO2219
 2210 CONTINUE
      ICASAX='2DVE'
      CALL CKLOSC(PY,NP,ISORSW,ICASAX,
     1ISUBG4,IBUGG4,IERRG4)
      IF(IERRG4.EQ.'YES')GOTO9000
 2219 CONTINUE
C
      IF(IY1TSC.EQ.'WEIB')GOTO2220
      GOTO2229
 2220 CONTINUE
      ICASAX='2DVE'
      CALL CKPRSC(PY,NP,ISORSW,ICASAX,
     1ISUBG4,IBUGG4,IERRG4)
      IF(IERRG4.EQ.'YES')GOTO9000
 2229 CONTINUE
C
C               ******************************************
C               **  STEP 41--                           **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,  **
C               **  TRANSFORM THE DATA                  **
C               ******************************************
C
      IF(IX1TSC.EQ.'LOG')GOTO4110
      GOTO4119
 4110 CONTINUE
      DO4115I=1,NP
      PX(I)=LOG10(PX(I))
 4115 CONTINUE
 4119 CONTINUE
C
      IF(IY1TSC.EQ.'LOG')GOTO4120
      GOTO4129
 4120 CONTINUE
      DO4125I=1,NP
      PY(I)=LOG10(PY(I))
 4125 CONTINUE
 4129 CONTINUE
C
C               ******************************************
C               **  STEP 42--                           **
C               **  IF A WEIBULL SCALE PLOT IS CALLED FOR,  **
C               **  TRANSFORM THE DATA                  **
C               ******************************************
C
      IF(IX1TSC.EQ.'WEIB')GOTO4210
      GOTO4219
 4210 CONTINUE
      DO4215I=1,NP
      PX(I)=LOG(LOG(AHUNDR/(AHUNDR-PX(I))))
 4215 CONTINUE
 4219 CONTINUE
C
      IF(IY1TSC.EQ.'WEIB')GOTO4220
      GOTO4229
 4220 CONTINUE
      DO4225I=1,NP
      PY(I)=LOG(LOG(AHUNDR/(AHUNDR-PY(I))))
 4225 CONTINUE
 4229 CONTINUE
C
C               **************************************************
C               **  STEP 51--                                   **
C               **  FORM THE CHARACTERS IN RAW 3-D SPACE.       **
C               **************************************************
C
C               **************************************************
C               **  STEP 52--                                   **
C               **  IF HIDDEN LINE REMOVAL IS ON,               **
C               **  DETERMINE IF ANY PART                       **
C               **  OF THE CHARACTER IS VISIBLE;                **
C               **  FORM SUBCHARACTERS.                         **
C               **************************************************
C
C               **************************************************
C               **  STEP 53--                                   **
C               **  TRANSLATE THE VISIBLE SUB-CHARACTERS        **
C               **  FROM THE RAW 3-D SPACE                      **
C               **  TO THE FINAL VISUAL 2-D PLANE.              **
C               **************************************************
C
      CALL D3TR32(PX,PY,PZ,NP,PX,PY,NP)
C
C               *****************************************************
C               **  STEP 54--                                      **
C               **  TRANSLATE THE 2-D PLANE DATA POINTS            **
C               **  INTO STANDARDIZED (0.0 TO 100.0) COORDINATES.  **
C               *****************************************************
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      IF(IX1TSC.EQ.'LOG')FXMIN=LOG10(FX1MIN)
      IF(IX1TSC.EQ.'LOG')FXMAX=LOG10(FX1MAX)
      IF(IX1TSC.EQ.'WEIB')FXMIN=LOG(LOG(AHUNDR/(AHUNDR-FX1MIN)))
      IF(IX1TSC.EQ.'WEIB')FXMAX=LOG(LOG(AHUNDR/(AHUNDR-FX1MAX)))
C
      FYMIN=FY1MIN
      FYMAX=FY1MAX
      IF(IY1TSC.EQ.'LOG')FYMIN=LOG10(FY1MIN)
      IF(IY1TSC.EQ.'LOG')FYMAX=LOG10(FY1MAX)
      IF(IY1TSC.EQ.'WEIB')FYMIN=LOG(LOG(AHUNDR/(AHUNDR-FY1MIN)))
      IF(IY1TSC.EQ.'WEIB')FYMAX=LOG(LOG(AHUNDR/(AHUNDR-FY1MAX)))
C
      FXRANG=FXMAX-FXMIN
      FYRANG=FYMAX-FYMIN
      PXRANG=PXMAX-PXMIN
      PYRANG=PYMAX-PYMIN
C
      DO5410I=1,NP
      FXRATI=(PX(I)-FXMIN)/FXRANG
      FYRATI=(PY(I)-FYMIN)/FYRANG
      PX(I)=PXMIN+FXRATI*PXRANG
      PY(I)=PYMIN+FYRATI*PYRANG
 5410 CONTINUE
C
      DO5420I=1,NP
      PX(I)=PX(I)+PCH2HO
      PY(I)=PY(I)+PCH2VO
 5420 CONTINUE
C
C               ***********************************************
C               **  STEP 60--                                **
C               **  WRITE OUT THE MARKERS (PLOT CHARACTERS)  **
C               **  AT THE PLOT POINTS                       **
C               ***********************************************
C
      IFIG='GENE'
      IPATT=ICH2PA
      IFONT=ICH2FO
      ICASE=ICH2CA
      IJUST=ICH2JU
      IDIR=ICH2DI
      ANGLE=ACH2AN
      IFILL=ICH2FI
      ICOL=ICH2CO
      PHEIGH=PCH2HE
CCCCC PWIDTH=0.5*PHEIGH
CCCCC PWIDTH=PHEIGH*(ANUMVP/ANUMHP)      DECEMBER 1987  TEST
      PWIDTH=PCH2WI
      PVEGAP=PHEIGH/2.0
      PHOGAP=PWIDTH/2.0
      PTHICK=PCH2TH
      ISYMBL=ICH2PA
      ISPAC=ITEXSP
C
      CALL DPCLCH(PX,PY,NP,PX2,PY2,NP2,X3D2,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1ISORSW,
     1IFIG,IPATT,IFONT,ICASE,IJUST,IDIR,ANGLE,IFILL,ICOL,
     1PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1IMPSW2,AMPSCH,AMPSCW,
     1ISYMBL,ISPAC)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRCH')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF D3DRCH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)NP
 9012 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICASPL,ICAS3D
 9013 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      IF(NP.LE.3)GOTO9029
      DO9025I=1,3
      WRITE(ICOUT,9026)I,XRAW(I),YRAW(I),ZRAW(I)
 9026 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
 9025 CONTINUE
      NPM2=NP-2
      DO9027I=NPM2,NP
      WRITE(ICOUT,9028)I,XRAW(I),YRAW(I),ZRAW(I)
 9028 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
 9027 CONTINUE
 9029 CONTINUE
      WRITE(ICOUT,9030)ISORSW
 9030 FORMAT('ISORSW = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9034)ICH2PA
 9034 FORMAT('ICH2PA= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9035)ICH2FO
 9035 FORMAT('ICH2FO= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9036)ICH2JU
 9036 FORMAT('ICH2JU= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9037)ICH2DI
 9037 FORMAT('ICH2DI= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9038)ACH2AN
 9038 FORMAT('ACH2AN= ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9039)ICH2FI
 9039 FORMAT('ICH2FI= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9040)ICH2CO
 9040 FORMAT('ICH2CO= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9041)PCH2HE
 9041 FORMAT('PCH2HE= ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9042)PCH2WI
 9042 FORMAT('PCH2WI= ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9043)PCH2TH,PCH2HO,PCH2VO
 9043 FORMAT('PCH2TH,PCH2HO,PCH2VO= ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9044)ITEXSP
 9044 FORMAT('ITEXSP = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9045)PXMIN,PXMAX,PYMIN,PYMAX
 9045 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9046)FX1MIN,FX1MAX,FY1MIN,FY1MAX
 9046 FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9047)FXMIN,FXMAX,FYMIN,FYMAX
 9047 FORMAT('FXMIN,FXMAX,FYMIN,FYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9048)IX1TSC,IY1TSC
 9048 FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9051)ISYMBL,ISPAC
 9051 FORMAT('ISYMBL,ISPAC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9059)IBUGG4,ISUBG4,IERRG4
 9059 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE D3DRFL(ICASPL,ICAS3D,FRAM3D,
     1X3DMIN,X3DMAX,Y3DMIN,Y3DMAX,Z3DMIN,Z3DMAX,
     1IX1FSW,IX2FSW,IY1FSW,IY2FSW,
     1IX1FPA,IX2FPA,IY1FPA,IY2FPA,
     1IX1FCO,IX2FCO,IY1FCO,IY2FCO,
     1PFRATH)
C     PURPOSE--DRAW THE 3 TO 8 (IF CALLED FOR) 3-D FRAME LINES
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--93.10
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--SEPTEMBER 1993.
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAS3D
C
      CHARACTER*4 FRAM3D
C
      CHARACTER*4 IX1FSW
      CHARACTER*4 IX2FSW
      CHARACTER*4 IY1FSW
      CHARACTER*4 IY2FSW
C
      CHARACTER*4 IX1FPA
      CHARACTER*4 IX2FPA
      CHARACTER*4 IY1FPA
      CHARACTER*4 IY2FPA
C
      CHARACTER*4 IX1FCO
      CHARACTER*4 IX2FCO
      CHARACTER*4 IY1FCO
      CHARACTER*4 IY2FCO
C
      CHARACTER*4 IFIG
      CHARACTER*4 IPATT
      CHARACTER*4 ICOL
      CHARACTER*4 IFLAG
C
      DIMENSION PX(100)
      DIMENSION PY(100)
      DIMENSION PZ(100)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C
C-----START POINT-----------------------------------------------------
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRFL')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF D3DRFL--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)X3DMIN,X3DMAX
   52 FORMAT('X3DMIN,X3DMAX = ',2F10.5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)Y3DMIN,Y3DMAX
   53 FORMAT('Y3DMIN,Y3DMAX = ',2F10.5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)Z3DMIN,Z3DMAX
   54 FORMAT('Z3DMIN,Z3DMAX = ',2F10.5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)ICASPL,ICAS3D,FRAM3D
   55 FORMAT('ICASPL,ICAS3D,FRAM3D = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)IX1FSW,IX2FSW,IY1FSW,IY2FSW
   61 FORMAT('IX1FSW,IX2FSW,IY1FSW,IY2FSW = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)IX1FPA,IX2FPA,IY1FPA,IY2FPA
   62 FORMAT('IX1FPA,IX2FPA,IY1FPA,IY2FPA = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)IX1FCO,IX2FCO,IY1FCO,IY2FCO
   63 FORMAT('IX1FCO,IX2FCO,IY1FCO,IY2FCO = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)PFRATH
   64 FORMAT('PFRATH = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,65)IBUGG4,ISUBG4,IERRG4
   65 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IF(ICASPL.EQ.'PIEC')GOTO9000
      IF(ICASPL.EQ.'STAR')GOTO9000
C
      IFIG='LINE'
      PTHICK=PFRATH
C
C               *********************************************
C               **  STEP 1--                               **
C               **  IF CALLED FOR,                         **
C               **  DRAW OUT THE "3 PRONG" FRAME           **
C               *********************************************
C
      IF(FRAM3D.EQ.'3PRO')THEN
         PX(1)=X3DMIN
         PX(2)=X3DMAX
         PX(3)=X3DMIN
         PX(4)=X3DMIN
         PX(5)=X3DMIN
         PX(6)=X3DMIN
C
         PY(1)=Y3DMIN
         PY(2)=Y3DMIN
         PY(3)=Y3DMIN
         PY(4)=Y3DMIN
         PY(5)=Y3DMIN
         PY(6)=Y3DMAX
C
         PZ(1)=Z3DMIN
         PZ(2)=Z3DMIN
         PZ(3)=Z3DMIN
         PZ(4)=Z3DMAX
         PZ(5)=Z3DMIN
         PZ(6)=Z3DMIN
         NP=6
         IPATT=IX1FPA
         ICOL=IX1FCO
         IFLAG='ON'
C
         CALL D3TR32(PX,PY,PZ,NP,PX,PY,NP)
         CALL D3SCAL(PX,PY,NP)
         CALL DPDRPL(PX,PY,NP,
     1   IFIG,IPATT,PTHICK,ICOL,
     1   JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
      ENDIF
C
C               *********************************************
C               **  STEP 2--                               **
C               **  IF CALLED FOR,                         **
C               **  DRAW OUT THE "3 PLANE" STYLE FRAME     **
C               *********************************************
C
      IF(FRAM3D.EQ.'3PLA')THEN
         PX(1)=X3DMIN
         PX(2)=X3DMAX
         PX(3)=X3DMAX
         PX(4)=X3DMIN
         PX(5)=X3DMIN
         PX(6)=X3DMIN
         PX(7)=X3DMIN
         PX(8)=X3DMIN
         PX(9)=X3DMIN
         PX(10)=X3DMAX
         PX(11)=X3DMAX
         PX(12)=X3DMIN
         PX(13)=X3DMIN
C
         PY(1)=Y3DMIN
         PY(2)=Y3DMIN
         PY(3)=Y3DMIN
         PY(4)=Y3DMIN
         PY(5)=Y3DMIN
         PY(6)=Y3DMAX
         PY(7)=Y3DMAX
         PY(8)=Y3DMIN
         PY(9)=Y3DMIN
         PY(10)=Y3DMIN
         PY(11)=Y3DMAX
         PY(12)=Y3DMAX
         PY(13)=Y3DMIN
C
         PZ(1)=Z3DMIN
         PZ(2)=Z3DMIN
         PZ(3)=Z3DMAX
         PZ(4)=Z3DMAX
         PZ(5)=Z3DMIN
         PZ(6)=Z3DMIN
         PZ(7)=Z3DMAX
         PZ(8)=Z3DMAX
         PZ(9)=Z3DMIN
         PZ(10)=Z3DMIN
         PZ(11)=Z3DMIN
         PZ(12)=Z3DMIN
         PZ(13)=Z3DMIN
         NP=13
         IPATT=IX1FPA
         ICOL=IX1FCO
         IFLAG='ON'
         CALL D3TR32(PX,PY,PZ,NP,PX,PY,NP)
         CALL D3SCAL(PX,PY,NP)
         CALL DPDRPL(PX,PY,NP,
     1   IFIG,IPATT,PTHICK,ICOL,
     1   JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
      ENDIF
C
C               *********************************************
C               **  STEP 3--                               **
C               **  IF CALLED FOR,                         **
C               **  DRAW OUT THE "BOX" STYLE FRAME         **
C               *********************************************
C
      IF(FRAM3D.EQ.'BOX')THEN
         PX(1)=X3DMIN
         PX(2)=X3DMAX
         PX(3)=X3DMAX
         PX(4)=X3DMIN
         PX(5)=X3DMIN
         PX(6)=X3DMIN
         PX(7)=X3DMIN
         PX(8)=X3DMIN
         PX(9)=X3DMIN
         PX(10)=X3DMAX
         PX(11)=X3DMAX
         PX(12)=X3DMAX
         PX(13)=X3DMAX
         PX(14)=X3DMAX
         PX(15)=X3DMIN
         PX(16)=X3DMAX
         PX(17)=X3DMAX
         PX(18)=X3DMIN
         PX(19)=X3DMIN
C
         PY(1)=Y3DMIN
         PY(2)=Y3DMIN
         PY(3)=Y3DMIN
         PY(4)=Y3DMIN
         PY(5)=Y3DMIN
         PY(6)=Y3DMAX
         PY(7)=Y3DMAX
         PY(8)=Y3DMIN
         PY(9)=Y3DMIN
         PY(10)=Y3DMIN
         PY(11)=Y3DMAX
         PY(12)=Y3DMAX
         PY(13)=Y3DMIN
         PY(14)=Y3DMAX
         PY(15)=Y3DMAX
         PY(16)=Y3DMAX
         PY(17)=Y3DMAX
         PY(18)=Y3DMAX
         PY(19)=Y3DMIN
C
         PZ(1)=Z3DMIN
         PZ(2)=Z3DMIN
         PZ(3)=Z3DMAX
         PZ(4)=Z3DMAX
         PZ(5)=Z3DMIN
         PZ(6)=Z3DMIN
         PZ(7)=Z3DMAX
         PZ(8)=Z3DMAX
         PZ(9)=Z3DMIN
         PZ(10)=Z3DMIN
         PZ(11)=Z3DMIN
         PZ(12)=Z3DMAX
         PZ(13)=Z3DMAX
         PZ(14)=Z3DMAX
         PZ(15)=Z3DMAX
         PZ(16)=Z3DMAX
         PZ(17)=Z3DMIN
         PZ(18)=Z3DMIN
         PZ(19)=Z3DMIN
         NP=19
         IPATT=IX1FPA
         ICOL=IX1FCO
         IFLAG='ON'
         CALL D3TR32(PX,PY,PZ,NP,PX,PY,NP)
         CALL D3SCAL(PX,PY,NP)
         CALL DPDRPL(PX,PY,NP,
     1   IFIG,IPATT,PTHICK,ICOL,
     1   JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
      ENDIF
C
C               *********************************************
C               **  STEP 4--                               **
C               **  IF CALLED FOR,                         **
C               **  DRAW OUT THE "ZIGZAG" FRAME           **
C               *********************************************
C
      IF(FRAM3D.EQ.'ZIGZ')THEN
         PX(1)=X3DMIN
         PX(2)=X3DMIN
         PX(3)=X3DMAX
         PX(4)=X3DMAX
C
         PY(1)=Y3DMAX
         PY(2)=Y3DMAX
         PY(3)=Y3DMAX
         PY(4)=Y3DMIN
C
         PZ(1)=Z3DMAX
         PZ(2)=Z3DMIN
         PZ(3)=Z3DMIN
         PZ(4)=Z3DMIN
         NP=4
         IPATT=IX1FPA
         ICOL=IX1FCO
         IFLAG='ON'
         CALL D3TR32(PX,PY,PZ,NP,PX,PY,NP)
         CALL D3SCAL(PX,PY,NP)
         CALL DPDRPL(PX,PY,NP,
     1   IFIG,IPATT,PTHICK,ICOL,
     1   JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRFL')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF D3DRFL--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)X3DMIN,X3DMAX
 9012 FORMAT('X3DMIN,X3DMAX = ',2F10.5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)Y3DMIN,Y3DMAX
 9013 FORMAT('Y3DMIN,Y3DMAX = ',2F10.5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)Z3DMIN,Z3DMAX
 9014 FORMAT('Z3DMIN,Z3DMAX = ',2F10.5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)ICASPL,ICAS3D,FRAM3D
 9015 FORMAT('ICASPL,ICAS3D,FRAM3D = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)IX1FSW,IX2FSW,IY1FSW,IY2FSW
 9021 FORMAT('IX1FSW,IX2FSW,IY1FSW,IY2FSW = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)IX1FPA,IX2FPA,IY1FPA,IY2FPA
 9022 FORMAT('IX1FPA,IX2FPA,IY1FPA,IY2FPA = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9023)IX1FCO,IX2FCO,IY1FCO,IY2FCO
 9023 FORMAT('IX1FCO,IX2FCO,IY1FCO,IY2FCO = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9024)PFRATH
 9024 FORMAT('PFRATH = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9025)IBUGG4,ISUBG4,IERRG4
 9025 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE D3DRFR(ICASPL,ICAS3D,FRAM3D,
     1X3DMIN,X3DMAX,Y3DMIN,Y3DMAX,Z3DMIN,Z3DMAX,
     1IVGMSW,IHGMSW)
C
C     PURPOSE--DRAW 3-D FRAME LINES (ALONG WITH TIC MARKS,
C              TIC MARK LABELS, AND GRID LINES
C              FOR A PLOT.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--93.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--SEPTEMBER 1993.
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAS3D
C
      CHARACTER*4 FRAM3D
C
      CHARACTER*4 IVGMSW
      CHARACTER*4 IHGMSW
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOPC.INC'
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRFR')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF D3DRFR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IMANUF,IMODEL
   52 FORMAT('IMANUF,IMODEL = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)ICASPL,ICAS3D
   53 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IBUGG4,ISUBG4,IERRG4
   55 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               *******************************
C               **  STEP 1--                 **
C               **  FILL  THE MARGIN REGION  **
C               *******************************
C
      IF(IERASW.EQ.'ON'.AND.IMARCO.NE.IBACCO)
     1CALL DPFIMA(PXMIN,PYMIN,PXMAX,PYMAX,
     1ICASPL,ICAS3D,
     1IMARCO)
C
C               ****************************
C               **  STEP 2--              **
C               **  DRAW THE FRAME LINES  **
C               ****************************
C
      CALL D3DRFL(ICASPL,ICAS3D,FRAM3D,
     1X3DMIN,X3DMAX,Y3DMIN,Y3DMAX,Z3DMIN,Z3DMAX,
     1IX1FSW,IX2FSW,IY1FSW,IY2FSW,
     1IX1FPA,IX2FPA,IY1FPA,IY2FPA,
     1IX1FCO,IX2FCO,IY1FCO,IY2FCO,
     1PFRATH)
C
C               **************************
C               **  STEP 3--            **
C               **  DRAW THE TIC MARKS  **
C               **************************
C
      CALL DPDRTM(PXMIN,PYMIN,PXMAX,PYMAX,
     1FX1MIN,FY1MIN,FX1MAX,FY1MAX,
     1ICASPL,ICAS3D,
     1IX1FSW,IX2FSW,IY1FSW,IY2FSW,
     1IX1TSW,IX2TSW,IY1TSW,IY2TSW,
     1PX1COO,PX2COO,PY1COO,PY2COO,
     1NX1COO,NX2COO,NY1COO,NY2COO,
     1PX1CMN,PX2CMN,PY1CMN,PY2CMN,
     1NX1CMN,NX2CMN,NY1CMN,NY2CMN,
     1PX1TLE,PX2TLE,PY1TLE,PY2TLE,
     1PTICTH,PMNTFA,
     1IX1TJU,IX2TJU,IY1TJU,IY2TJU,
     1IX1TCO,IX2TCO,IY1TCO,IY2TCO)
C
C               *************************************
C               **  STEP 4--                       **
C               **  WRITE OUT THE TIC MARK LABELS  **
C               *************************************
C
      CALL DPWRTL(ICASPL,ICAS3D)
C
C               ***************************
C               **  STEP 5--             **
C               **  DRAW THE GRID LINES  **
C               ***************************
C
      CALL DPDRGL(PXMIN,PYMIN,PXMAX,PYMAX,
     1FX1MIN,FY1MIN,FX1MAX,FY1MAX,
     1ICASPL,ICAS3D,
     1IVGRSW,IHGRSW,
     1IVGMSW,IHGMSW,
     1PX1COO,PX2COO,PY1COO,PY2COO,
     1X1COOR,X2COOR,Y1COOR,Y2COOR,
     1NX1COO,NX2COO,NY1COO,NY2COO,
     1PX1CMN,PX2CMN,PY1CMN,PY2CMN,
     1X1COMN,X2COMN,Y1COMN,Y2COMN,
     1NX1CMN,NX2CMN,NY1CMN,NY2CMN,
     1IVGRPA,IHGRPA,IVGRCO,IHGRCO,
     1PVGRTH,PHGRTH,
     1PX1TOL,PX1TOR,PY1TOB,PY1TOT)
CCCC ABOVE LINE ADDED MAY, 1990 (FOR TIC OFFSETS)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRFR')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF D3DRFR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IMANUF,IMODEL
 9012 FORMAT('IMANUF,IMODEL = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICASPL,ICAS3D
 9013 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IBUGG4,ISUBG4,IERRG4
 9015 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE D3DRSP(XRAW,YRAW,ZRAW,NP,
     1PX,PY,PZ,PX2,PY2,PZ2,PX3,PY3,
     1ICASPL,ICAS3D,
     1ISORSW,
     1ISP2LI,ISP2CO,ISP2DI,PSP2TH,ASP2BA,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1FX1MIN,FX1MAX,FY1MIN,FY1MAX,
     1IX1TSC,IY1TSC)
C
C     PURPOSE--FOR A GENERAL GRAPHICS DEVICE,
C              AND FOR EACH VALUE IN X(.), DRAW A SPIKE
C              (= A VERTICAL OR HORIZONTAL LINE SEGMENT)
C              FROM THE BASE POINT ASP2BA
C              TO THE POINT Y(.).
C              DO SO FOR A SPECIFIED SPIKE LINE TYPE,
C              LINES COLOR, LINE DIRECTION, AND LINE THICKNESS.
C     NOTE--THE VARIABLES PY(.) AND PX(.) ARE DUMMY VARIABLES
C           WHICH ARE USED IN THE INTERMEDIATE CALCULATIONS
C           AND WHOSE DIMENSIONS ARE DEFINED (FOR EASY OF CHANGE)
C           BACK IN THE MAIN ROUTINE.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--87.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED--APRIL     1987.
C     UPDATED         --SEPTEMBER 1988.  RENUMBER
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAS3D
C
      CHARACTER*4 ISORSW
C
      CHARACTER*4 ISP2LI
      CHARACTER*4 ISP2CO
      CHARACTER*4 ISP2DI
C
      CHARACTER*4 IX1TSC
      CHARACTER*4 IY1TSC
C
      CHARACTER*4 ITYPE
C
      CHARACTER*4 IFIG
      CHARACTER*4 IPATTT
      CHARACTER*4 ICOL
      CHARACTER*4 IDIR
C
C     6/23/86
C     HOW COME THE FOLLOWING 4 VARIABLES ARE NOT CARRIED
C     AS INPUT TO THIS SUBROUTINE--NOT NEEDED???
C     CHECK ON THIS.
C
      CHARACTER*4 IHORPA
      CHARACTER*4 IVERPA
      CHARACTER*4 IDUPPA
      CHARACTER*4 IDDOPA
C
      DIMENSION XRAW(*)
      DIMENSION YRAW(*)
      DIMENSION ZRAW(*)
      DIMENSION PX(*)
      DIMENSION PY(*)
      DIMENSION PZ(*)
      DIMENSION PX2(*)
      DIMENSION PY2(*)
      DIMENSION PZ2(*)
      DIMENSION PX3(*)
      DIMENSION PY3(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
      INCLUDE 'DPCO3D.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      HOLD=1.0
      ABASE=0.0
      PBASE=0.0
      PBASE2=0.0
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      FYMIN=FY1MIN
      FYMAX=FY1MAX
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRSP')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF D3DRSP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)NP
   52 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)ICASPL,ICAS3D
   53 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      IF(NP.LE.3)GOTO69
      DO65I=1,3
      WRITE(ICOUT,66)I,XRAW(I),YRAW(I),ZRAW(I)
   66 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
   65 CONTINUE
      NPM2=NP-2
      DO67I=NPM2,NP
      WRITE(ICOUT,68)I,XRAW(I),YRAW(I),ZRAW(I)
   68 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
   67 CONTINUE
   69 CONTINUE
      WRITE(ICOUT,70)ISORSW
   70 FORMAT('ISORSW = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,71)ISP2LI
   71 FORMAT('ISP2LI= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,72)ISP2CO,ISP2DI
   72 FORMAT('ISP2CO,ISP2DI= ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,73)PSP2TH
   73 FORMAT('PSP2TH= ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,74)ASP2BA
   74 FORMAT('ASP2BA= ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,84)PXMIN,PXMAX,PYMIN,PYMAX
   84 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,85)FX1MIN,FX1MAX,FY1MIN,FY1MAX
   85 FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,86)IX1TSC,IY1TSC
   86 FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,89)IBUGG4,ISUBG4,IERRG4
   89 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               *************************************************
C               **  STEP 11--                                  **
C               **  IF CALLED FOR, SORT THE DATA               **
C               **  ACCORDING TO THE HORIZONTAL AXIS VARIABLE  **
C               *************************************************
C
      IDIR=ISP2DI
C
      IF(ISORSW.EQ.'OFF')GOTO1150
      IF(ICASPL.EQ.'PIEC')GOTO1150
      IF(ICAS3D.EQ.'ON')GOTO1150
      IF(ICASPL.EQ.'CONT')GOTO1150
C
CCCCC CALL SORTC(X,Y,NP,PX,PY)
      GOTO1190
C
 1150 CONTINUE
      DO1160I=1,NP
      PX(I)=XRAW(I)
      PY(I)=YRAW(I)
      PZ(I)=ZRAW(I)
 1160 CONTINUE
      GOTO1190
C
 1190 CONTINUE
C
C               ************************************************
C               **  STEP 12--                                 **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,        **
C               **  CHECK THAT ALL DATA POINTS ARE POSITIVE.  **
C               ************************************************
C
      IF(IX1TSC.EQ.'LOG')GOTO1210
      GOTO1290
C
 1210 CONTINUE
      IF(IDIR.EQ.'H')GOTO1215
      GOTO1219
 1215 CONTINUE
      IF(ASP2BA.LE.0.0)HOLD=ASP2BA
      IF(ASP2BA.LE.0.0)GOTO1250
 1219 CONTINUE
C
      IF(ISORSW.EQ.'ON')GOTO1220
      GOTO1230
C
 1220 CONTINUE
      J=1
      IF(PX(J).LE.0.0)GOTO1250
      GOTO1290
C
 1230 CONTINUE
      DO1235I=1,NP
      J=I
      IF(PX(J).LE.0.0)GOTO1250
 1235 CONTINUE
      GOTO1290
C
 1250 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1251)
 1251 FORMAT('***** ERROR IN D3DRSP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1252)
 1252 FORMAT('      THE LOG OF A NON-POSITIVE DATA VALUE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1253)
 1253 FORMAT('      WAS ENCOUNTERED IN FORMING A PLOT.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1254)
 1254 FORMAT('      DATA MAY NOT BE ZERO OR NEGATIVE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1255)
 1255 FORMAT('      WHEN A LOG SCALE PLOT IS USED.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1256)PX(J)
 1256 FORMAT('      THE VALUE = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1257)
 1257 FORMAT('      THIS VALUE CAME FROM THE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1258)
 1258 FORMAT('      HORIZONTAL AXIS VARIABLE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1259)
 1259 FORMAT('      CORRECTIVE ACTION--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1260)
 1260 FORMAT('      CHANGE DATA OR CHANGE LIMITS.')
      CALL DPWRST('XXX','BUG ')
      IERRG4='YES'
      GOTO9000
C
 1290 CONTINUE
C
      IF(IY1TSC.EQ.'LOG')GOTO1310
      GOTO1390
C
 1310 CONTINUE
      IF(IDIR.EQ.'V')GOTO1315
      GOTO1319
 1315 CONTINUE
      IF(ASP2BA.LE.0.0)HOLD=ASP2BA
      IF(ASP2BA.LE.0.0)GOTO1350
 1319 CONTINUE
C
      IF(ISORSW.EQ.'ON')GOTO1320
      GOTO1330
C
 1320 CONTINUE
      J=1
      IF(PY(J).LE.0.0)HOLD=PY(J)
      IF(PY(J).LE.0.0)GOTO1350
      GOTO1390
C
 1330 CONTINUE
      DO1335I=1,NP
      J=I
      IF(PY(J).LE.0.0)HOLD=PY(J)
      IF(PY(J).LE.0.0)GOTO1350
 1335 CONTINUE
      GOTO1390
C
 1350 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1351)
 1351 FORMAT('***** ERROR IN D3DRSP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1352)
 1352 FORMAT('      THE LOG OF A NON-POSITIVE DATA VALUE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1353)
 1353 FORMAT('      WAS ENCOUNTERED IN FORMING A PLOT.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1354)
 1354 FORMAT('      DATA MAY NOT BE ZERO OR NEGATIVE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1355)
 1355 FORMAT('      WHEN A LOG SCALE PLOT IS USED.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1356)HOLD
 1356 FORMAT('      THE VALUE = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1357)
 1357 FORMAT('      THIS VALUE CAME FROM THE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1358)
 1358 FORMAT('      VERTICAL AXIS VARIABLE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1359)
 1359 FORMAT('      CORRECTIVE ACTION--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1360)
 1360 FORMAT('      CHANGE DATA OR CHANGE LIMITS.')
      CALL DPWRST('XXX','BUG ')
      IERRG4='YES'
      GOTO9000
C
 1390 CONTINUE
C
C               ******************************************
C               **  STEP 40--                           **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,  **
C               **  TRANSFORM THE DATA                  **
C               ******************************************
C
      ABASE=ASP2BA
C
      IF(IX1TSC.EQ.'LOG')GOTO4010
      GOTO4019
 4010 CONTINUE
      IF(IDIR.EQ.'H')ABASE=LOG10(ABASE)
      DO4015I=1,NP
      PX(I)=LOG10(PX(I))
 4015 CONTINUE
 4019 CONTINUE
C
      IF(IY1TSC.EQ.'LOG')GOTO4020
      GOTO4029
 4020 CONTINUE
      IF(IDIR.EQ.'V')ABASE=LOG10(ABASE)
      DO4025I=1,NP
      PY(I)=LOG10(PY(I))
 4025 CONTINUE
 4029 CONTINUE
C
C               *******************************
C               **  STEP 60--                **
C               **  PREPARE TO MAKE VARIOUS  **
C               **  LINE SETTINGS            **
C               *******************************
C
      ITYPE='LINE'
C
C               **********************************************
C               **  STEP 61--                               **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE LINE PATTERN                     **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      IPATTT=ISP2LI
      CALL GRTRPA(ITYPE,IPATTT,PXSPA,PYSPA,
     1JPATTT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               *******************************
C               **  STEP 62--                **
C               **  SET THE LINE PATTERN     **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSEPA(ITYPE,IPATTT,PXSPA,PYSPA,
     1JPATTT,IHORPA,IVERPA,IDUPPA,IDDOPA,PXSPA2,PYSPA2)
C
C               **********************************************
C               **  STEP 63--                               **
C               **  TRANSLATE THE  DESIRED                  **
C               **  LINE THICKNESS                          **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      PTHICK=PSP2TH
      CALL GRTRTH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               *******************************
C               **  STEP 64--                **
C               **  SET THE LINE THICKNESS   **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSETH(ITYPE,PTHICK,JTHICK,PTHIC2)
C
C               **********************************************
C               **  STEP 65--                               **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE LINE COLOR                       **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      ICOL=ISP2CO
      CALL GRTRCO(ITYPE,ICOL,JCOL)
C
C               *******************************
C               **  STEP 66--                **
C               **  SET THE LINE COLOR       **
C               **  ON THE GRAPHICS DEVICE.  **
C               *******************************
C
      CALL GRSECO(ITYPE,ICOL,JCOL)
C
C               **************************************************
C               **  STEP 71--                                   **
C               **  FOR EACH RAW 3-D DATA POINT--               **
C               **     1) MAKE THE SPIKE                        **
C               **     2) TRANSLATE IT TO 2 DIMENSIONS          **
C               **     3) TRANSLATE IT TO 0-100 UNITS           **
C               **     4) CLIP THE SPIKE IF NEEDED              **
C               **     5) DRAW OUT THE SPIKE                    **
C               **************************************************
C
C
      IFIG='GENE'
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      IF(IX1TSC.EQ.'LOG')FXMIN=LOG10(FX1MIN)
      IF(IX1TSC.EQ.'LOG')FXMAX=LOG10(FX1MAX)
C
      FYMIN=FY1MIN
      FYMAX=FY1MAX
      IF(IY1TSC.EQ.'LOG')FYMIN=LOG10(FY1MIN)
      IF(IY1TSC.EQ.'LOG')FYMAX=LOG10(FY1MAX)
C
      FXRANG=FXMAX-FXMIN
      FYRANG=FYMAX-FYMIN
      PXRANG=PXMAX-PXMIN
      PYRANG=PYMAX-PYMIN
C
      DO7100I=1,NP
C
      CALL D3MKSP(PX,PY,PZ,NP,I,
     1IDIR,
     1ABASE,ABASE,ABASE,
     1PX2,PY2,PZ2,NP2)
C
      CALL D3TR32(PX2,PY2,PZ2,NP2,PX3,PY3,NP3)
C
      CALL D3TRXP(PX3,PY3,NP3,IDIR,ABASE,
     1FXMIN,FXMAX,FXRANG,FYMIN,FYMAX,FYRANG,
     1PXMIN,PXMAX,PXRANG,PYMIN,PYMAX,PYRANG,
     1PX3,PY3,NP3,PBASE)
C
      CALL DPSQUE(PX3,PY3,NP3,
     1PXMIN,PXMAX,PYMIN,PYMAX)
C
      CALL GRDRPL(PX3,PY3,NP3,
     1IFIG,IPATTT,PTHICK,ICOL,
     1JPATTT,JTHICK,PTHIC2,JCOL)
C
 7100 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRSP')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF D3DRSP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)NP
 9012 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICASPL,ICAS3D
 9013 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)HOLD
 9014 FORMAT('HOLD = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)ABASE,PBASE,PBASE2
 9015 FORMAT('ABASE,PBASE,PBASE2 = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      IF(NP.LE.3)GOTO9029
      DO9025I=1,3
      WRITE(ICOUT,9026)I,XRAW(I),YRAW(I),ZRAW(I)
 9026 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
 9025 CONTINUE
      NPM2=NP-2
      DO9027I=NPM2,NP
      WRITE(ICOUT,9028)I,XRAW(I),YRAW(I),ZRAW(I)
 9028 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
 9027 CONTINUE
 9029 CONTINUE
      WRITE(ICOUT,9030)ISORSW
 9030 FORMAT('ISORSW = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9031)ISP2LI
 9031 FORMAT('ISP2LI= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9032)PSP2TH
 9032 FORMAT('PSP2TH= ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9033)ISP2CO,ISP2DI
 9033 FORMAT('ISP2CO,ISP2DI= ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9044)PXMIN,PXMAX,PYMIN,PYMAX
 9044 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9045)FX1MIN,FX1MAX,FY1MIN,FY1MAX
 9045 FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9046)FXMIN,FXMAX,FYMIN,FYMAX
 9046 FORMAT('FXMIN,FXMAX,FYMIN,FYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9047)IX1TSC,IY1TSC
 9047 FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9051)IFIG
 9051 FORMAT('IFIG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9052)IPATTT,JPATTT
 9052 FORMAT('IPATTT,JPATTT = ',A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9053)PTHICK,JTHICK,PTHIC2
 9053 FORMAT('PTHICK,JTHICK,PTHIC2 = ',E15.7,I8,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9054)ICOL,JCOL,IDIR
 9054 FORMAT('ICOL,JCOL,IDIR = ',A4,I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9055)ITYPE
 9055 FORMAT('ITYPE = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9069)IBUGG4,ISUBG4,IERRG4
 9069 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9071)NP2,NP3
 9071 FORMAT('NP2,NP3 = ',2I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE D3DRTR(XRAW,YRAW,ZRAW,PX,PY,PZ,NP,PY2,PX2,NP2,
     1PY3,PX3,NP3,
     1ICASPL,ICAS3D,
     1ISORSW,
     1ILI2PA,ILI2CO,PLI2TH,
     1ARE2BA,
     1IRE2FS,IRE2FC,
     1IRE2PT,IRE2PL,IRE2PC,PRE2PT,PRE2PS,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1FX1MIN,FX1MAX,FY1MIN,FY1MAX,
     1IX1TSC,IY1TSC)
C
C     PURPOSE--FOR A GENERAL GRAPHICS DEVICE,
C              DRAW A SINGLE TRACE OF Y(.) VERSUS X(.)
C              FOR A SPECIFIED LINE TYPE, COLOR, AND THICKNESS.
C              AND (IF CALLED FOR) FILL IN BELOW/ABOVE THE TRACE
C              TO THE BASE LINE ARE2BA.
C     NOTE--THE VARIABLES PY(.) AND PX(.) ARE DUMMY VARIABLES
C           WHICH ARE USED IN THE INTERMEDIATE CALCULATIONS
C           AND WHOSE DIMENSIONS ARE DEFINED (FOR EASY OF CHANGE)
C           BACK IN THE MAIN ROUTINE.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED         --FEBRUARY  1988.   STAR PLOT
C     UPDATED         --SEPTEMBER 1988.  LOG/WEIBULL CHECK AS A SUBROUTINE
C     UPDATED         --SEPTEMBER 1988.  RENUMBER
C     UPDATED         --AUGUST    1992.  CALL TO DPFIRE
C     UPDATED         --JULY      1993.  NORMAL SCALE (JJF)
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAS3D
C
      CHARACTER*4 ISORSW
C
      CHARACTER*4 ILI2PA
      CHARACTER*4 ILI2CO
C
      CHARACTER*4 IRE2FS
      CHARACTER*4 IRE2FC
      CHARACTER*4 IRE2PT
      CHARACTER*4 IRE2PL
      CHARACTER*4 IRE2PC
C
      CHARACTER*4 IX1TSC
      CHARACTER*4 IY1TSC
C
      CHARACTER*4 IFIG
      CHARACTER*4 IPATT
      CHARACTER*4 ICOL
C
      CHARACTER*4 ICOLF
      CHARACTER*4 ICOLP
C
      CHARACTER*4 ICASAX
C
CCCCC AUGUST 1992.
      CHARACTER*4 IPATT2
C
      DIMENSION XRAW(*)
      DIMENSION YRAW(*)
      DIMENSION ZRAW(*)
      DIMENSION PX(*)
      DIMENSION PY(*)
      DIMENSION PZ(*)
      DIMENSION PY2(*)
      DIMENSION PX2(*)
      DIMENSION PY3(*)
      DIMENSION PX3(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
      INCLUDE 'DPCO3D.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      HOLD=1.0
      ABASE=0.0
      PBASE=0.0
      PBASE2=0.0
      PLEFT=0.0
      PRIGHT=0.0
      AWIDTH=0.0
      PWIDTH=0.0
      FYRATI=0.0
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      FYMIN=FY1MIN
      FYMAX=FY1MAX
C
      AHUNDR=100.0
      ABASE2=0.0
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRTR')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF D3DRTR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)NP
   52 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)ICASPL,ICAS3D
   53 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      IF(NP.LE.3)GOTO69
      DO65I=1,3
      WRITE(ICOUT,66)I,XRAW(I),YRAW(I),ZRAW(I)
   66 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
   65 CONTINUE
      NPM2=NP-2
      DO67I=NPM2,NP
      WRITE(ICOUT,68)I,XRAW(I),YRAW(I),ZRAW(I)
   68 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
   67 CONTINUE
   69 CONTINUE
      WRITE(ICOUT,70)ISORSW
   70 FORMAT('ISORSW = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,71)ILI2PA,ILI2CO,PLI2TH
   71 FORMAT('ILI2PA,ILI2CO,PLI2TH = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,72)ARE2BA
   72 FORMAT('ARE2BA = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,73)IRE2FS,IRE2FC
   73 FORMAT('IRE2FS,IRE2FC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,74)IRE2PT,IRE2PL,IRE2PC,PRE2PT,PRE2PS
   74 FORMAT('IRE2PT,IRE2PL,IRE2PC,PRE2PT,PRE2PS = ',
     1A4,2X,A4,2X,A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,84)PXMIN,PXMAX,PYMIN,PYMAX
   84 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,85)FX1MIN,FX1MAX,FY1MIN,FY1MAX
   85 FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,86)IX1TSC,IY1TSC
   86 FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,89)IBUGG4,ISUBG4,IERRG4
   89 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               *************************************************
C               **  STEP 11--                                  **
C               **  IF CALLED FOR, SORT THE DATA               **
C               **  ACCORDING TO THE HORIZONTAL AXIS VARIABLE  **
C               *************************************************
C
      IF(ISORSW.EQ.'OFF')GOTO1150
      IF(ICASPL.EQ.'PIEC')GOTO1150
      IF(ICASPL.EQ.'STAR')GOTO1150
      IF(ICAS3D.EQ.'ON')GOTO1150
      IF(ICASPL.EQ.'CONT')GOTO1150
C
CCCCC CALL SORTC(X,Y,NP,PX,PY)
      GOTO1190
C
 1150 CONTINUE
      DO1160I=1,NP
      PX(I)=XRAW(I)
      PY(I)=YRAW(I)
      PZ(I)=ZRAW(I)
 1160 CONTINUE
      GOTO1190
C
 1190 CONTINUE
C
C               **********************************************************
C               **  STEP 21--                                           **
C               **  IF A NON-LINEAR SCALE PLOT IS CALLED FOR,           **
C               **  CHECK THAT ALL   HORIZ. AXIS DATA POINTS            **
C               **  ARE IN VALID RANGE.                                 **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,                  **
C               **  CHECK THAT ALL   HORIZ.  AXIS DATA POINTS ARE > 0.  **
C               **  IF A WEIBULL SCALE PLOT IS CALLED FOR,              **
C               **  CHECK THAT ALL   HORIZ. AXIS DATA POINTS ARE        **
C               **  IF A NORMAL SCALE PLOT IS CALLED FOR,              **
C               **  CHECK THAT ALL   HORIZ. AXIS DATA POINTS ARE        **
C               **  STRICTLY > 0 AND STRICTLY < 100                     **
C               **********************************************************
C
      IF(IX1TSC.EQ.'LOG')GOTO2110
      GOTO2119
 2110 CONTINUE
      ICASAX='2DHO'
      CALL CKLOSC(PX,NP,ISORSW,ICASAX,
     1ISUBG4,IBUGG4,IERRG4)
      IF(IERRG4.EQ.'YES')GOTO9000
 2119 CONTINUE
C
CCCCC THE FOLLOWING SECTION WAS CHANGED JULY 1993 (JJF)
CCCCC IF(IX1TSC.EQ.'WEIB')GOTO2120
      IF(IX1TSC.EQ.'WEIB'.OR.
     1   IX1TSC.EQ.'NORM')GOTO2120
      GOTO2129
 2120 CONTINUE
      ICASAX='2DHO'
CCCCC CALL CKWESC(PX,NP,ISORSW,ICASAX,
CCCCC CALL CKPRSC(PX,NP,ISORSW,ICASAX,
CCCCC1ISUBG4,IBUGG4,IERRG4)
CCCCC IF(IERRG4.EQ.'YES')GOTO9000
 2129 CONTINUE
C
C               **********************************************************
C               **  STEP 22--                                           **
C               **  IF A NON-LINEAR SCALE PLOT IS CALLED FOR,           **
C               **  CHECK THAT ALL   VERT.  AXIS DATA POINTS            **
C               **  ARE IN VALID RANGE.                                 **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,                  **
C               **  CHECK THAT ALL   VERT.   AXIS DATA POINTS ARE > 0.  **
C               **  IF A WEIBULL SCALE PLOT IS CALLED FOR,              **
C               **  CHECK THAT ALL   VERT.  AXIS DATA POINTS ARE        **
C               **  STRICTLY > 0 AND STRICTLY < 100                     **
C               **  IF A NORMAL  SCALE PLOT IS CALLED FOR,              **
C               **  CHECK THAT ALL   VERT.  AXIS DATA POINTS ARE        **
C               **  STRICTLY > 0 AND STRICTLY < 100                     **
C               **********************************************************
C
      IF(IY1TSC.EQ.'LOG')GOTO2210
      GOTO2219
 2210 CONTINUE
      ICASAX='2DVE'
      CALL CKLOSC(PY,NP,ISORSW,ICASAX,
     1ISUBG4,IBUGG4,IERRG4)
      IF(IERRG4.EQ.'YES')GOTO9000
 2219 CONTINUE
C
CCCCC THE FOLLOWING SECTION WAS CHANGED JULY 1993 (JJF)
CCCCC IF(IY1TSC.EQ.'WEIB')GOTO2220
      IF(IY1TSC.EQ.'WEIB'.OR.
     1   IY1TSC.EQ.'NORM')GOTO2220
      GOTO2229
 2220 CONTINUE
      ICASAX='2DVE'
CCCCC CALL CKWESC(PY,NP,ISORSW,ICASAX,
CCCCC CALL CKPRSC(PY,NP,ISORSW,ICASAX,
CCCCC1ISUBG4,IBUGG4,IERRG4)
CCCCC IF(IERRG4.EQ.'YES')GOTO9000
 2229 CONTINUE
C
C               ******************************************
C               **  STEP 41--                           **
C               **  IF A LOG SCALE PLOT IS CALLED FOR,  **
C               **  TRANSFORM THE DATA                  **
C               ******************************************
C
      IF(IX1TSC.EQ.'LOG')GOTO4110
      GOTO4119
 4110 CONTINUE
      DO4115I=1,NP
      PX(I)=LOG10(PX(I))
 4115 CONTINUE
 4119 CONTINUE
C
      ABASE=ARE2BA
      IF(IY1TSC.EQ.'LOG')GOTO4120
      GOTO4129
 4120 CONTINUE
      IF(ABASE.NE.CPUMAX.AND.ABASE.GT.0.0)ABASE=LOG10(ABASE)
      IF(ABASE.NE.CPUMAX.AND.ABASE.LE.0.0)ABASE=1.0
      DO4125I=1,NP
      PY(I)=LOG10(PY(I))
 4125 CONTINUE
 4129 CONTINUE
C
C               ******************************************
C               **  STEP 42--                           **
C               **  IF A WEIBULL SCALE PLOT IS CALLED FOR,  **
C               **  TRANSFORM THE DATA                  **
C               ******************************************
C
      IF(IX1TSC.EQ.'WEIB')GOTO4210
      GOTO4219
 4210 CONTINUE
      DO4215I=1,NP
      PX(I)=LOG(LOG(AHUNDR/(AHUNDR-PX(I))))
 4215 CONTINUE
 4219 CONTINUE
C
      ABASE=ARE2BA
      IF(IY1TSC.EQ.'WEIB')GOTO4220
      GOTO4229
 4220 CONTINUE
      IF(ABASE.NE.CPUMAX.AND.ABASE.GT.0.0.AND.ABASE.LT.AHUNDR)
     1ABASE2=LOG(LOG(AHUNDR/(AHUNDR-ABASE)))
      IF(ABASE.NE.CPUMAX.AND.ABASE.LE.0.0)ABASE2=0.1
      IF(ABASE.NE.CPUMAX.AND.ABASE.GE.AHUNDR)ABASE2=0.1
      ABASE=ABASE2
      DO4225I=1,NP
      PY(I)=LOG(LOG(AHUNDR/(AHUNDR-PY(I))))
 4225 CONTINUE
 4229 CONTINUE
C
CCCCC THE FOLLOWING SECTION WAS ADDED   JULY 1993 (JJF)
C               ******************************************
C               **  STEP 43--                           **
C               **  IF A NORMAL  SCALE PLOT IS CALLED FOR,  **
C               **  TRANSFORM THE DATA                  **
C               ******************************************
C
      IF(IX1TSC.EQ.'NORM')GOTO4310
      GOTO4319
 4310 CONTINUE
      DO4315I=1,NP
CCCCC CHANGE FOLLOWING LINE NOVEMBER 1994.
CCCCC PX(I)=AHUNDR*NORCDF(PX(I))
      CALL NORCDF(PX(I),ATEMP)
      PX(I)=AHUNDR*ATEMP
 4315 CONTINUE
 4319 CONTINUE
C
      ABASE=ARE2BA
      IF(IY1TSC.EQ.'WEIB')GOTO4320
      GOTO4329
 4320 CONTINUE
      CALL NORCDF(ABASE,ATEMP)
      IF(ABASE.NE.CPUMAX.AND.ABASE.GT.0.0.AND.ABASE.LT.AHUNDR)
     1ABASE2=AHUNDR*ATEMP
      IF(ABASE.NE.CPUMAX.AND.ABASE.LE.0.0)ABASE2=0.1
      IF(ABASE.NE.CPUMAX.AND.ABASE.GE.AHUNDR)ABASE2=0.1
      ABASE=ABASE2
      DO4325I=1,NP
CCCCC CHANGE FOLLOWING LINE NOVEMBER 1994.
CCCCC PY(I)=AHUNDR*NORCDF(PY(I))
      CALL NORCDF(PY(I),ATEMP)
      PY(I)=AHUNDR*ATEMP
 4325 CONTINUE
 4329 CONTINUE
C
C               **************************************************
C               **  STEP 51--                                   **
C               **  FORM THE TRACE IN RAW 3-D SPACE.            **
C               **************************************************
C
C               **************************************************
C               **  STEP 52--                                   **
C               **  IF HIDDEN LINE REMOVAL IS ON,               **
C               **  DETERMINE IF ANY PART                       **
C               **  OF THE TRACE IS VISIBLE;                    **
C               **  FORM SUBTRACES.                             **
C               **************************************************
C
C               **************************************************
C               **  STEP 53--                                   **
C               **  TRANSLATE THE VISIBLE SUB-TRACES            **
C               **  FROM THE RAW 3-D SPACE                      **
C               **  TO THE FINAL VISUAL 2-D PLANE.              **
C               **************************************************
C
      CALL D3TR32(PX,PY,PZ,NP,PX,PY,NP)
C
C               *****************************************************
C               **  STEP 54--                                      **
C               **  TRANSLATE THE 2-D PLANE DATA POINTS            **
C               **  INTO STANDARDIZED (0.0 TO 100.0) COORDINATES.  **
C               *****************************************************
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      IF(IX1TSC.EQ.'LOG')FXMIN=LOG10(FX1MIN)
      IF(IX1TSC.EQ.'LOG')FXMAX=LOG10(FX1MAX)
      IF(IX1TSC.EQ.'WEIB')FXMIN=LOG(LOG(AHUNDR/(AHUNDR-FX1MIN)))
      IF(IX1TSC.EQ.'WEIB')FXMAX=LOG(LOG(AHUNDR/(AHUNDR-FX1MAX)))
CCCCC THE FOLLOWING 2 LINES WERE ADDED JULY 193 (JJF)
CCCCC CHANGE FOLLOWING 2 LINES NOVEMBER 1994.
CCCCC IF(IX1TSC.EQ.'NORM')FXMIN=AHUNDR*NORCDF(FX1MIN)
CCCCC IF(IX1TSC.EQ.'NORM')FXMAX=AHUNDR*NORCDF(FX1MAX)
      CALL NORCDF(FX1MIN,ATEMP)
      IF(IX1TSC.EQ.'NORM')FXMIN=AHUNDR*ATEMP
      CALL NORCDF(FX1MAX,ATEMP)
      IF(IX1TSC.EQ.'NORM')FXMAX=AHUNDR*ATEMP
C
      FYMIN=FY1MIN
      FYMAX=FY1MAX
      IF(IY1TSC.EQ.'LOG')FYMIN=LOG10(FY1MIN)
      IF(IY1TSC.EQ.'LOG')FYMAX=LOG10(FY1MAX)
      IF(IY1TSC.EQ.'WEIB')FYMIN=LOG(LOG(AHUNDR/(AHUNDR-FY1MIN)))
      IF(IY1TSC.EQ.'WEIB')FYMAX=LOG(LOG(AHUNDR/(AHUNDR-FY1MAX)))
CCCCC THE FOLLOWING 2 LINES WERE ADDED JULY 193 (JJF)
CCCCC CHANGE FOLLOWING 2 LINES NOVEMBER 1994.
CCCCC IF(IY1TSC.EQ.'NORM')FYMIN=AHUNDR*NORCDF(FY1MIN)
CCCCC IF(IY1TSC.EQ.'NORM')FYMAX=AHUNDR*NORCDF(FY1MAX)
      CALL NORCDF(FY1MIN,ATEMP)
      IF(IY1TSC.EQ.'NORM')FYMIN=AHUNDR*ATEMP
      CALL NORCDF(FY1MAX,ATEMP)
      IF(IY1TSC.EQ.'NORM')FYMAX=AHUNDR*ATEMP
C
      FXRANG=FXMAX-FXMIN
      FYRANG=FYMAX-FYMIN
      PXRANG=PXMAX-PXMIN
      PYRANG=PYMAX-PYMIN
C
      DO5410I=1,NP
      FXRATI=(PX(I)-FXMIN)/FXRANG
      FYRATI=(PY(I)-FYMIN)/FYRANG
      PX(I)=PXMIN+FXRATI*PXRANG
      PY(I)=PYMIN+FYRATI*PYRANG
 5410 CONTINUE
      IF(ABASE.NE.CPUMAX)FYRATI=(ABASE-FYMIN)/FYRANG
      IF(ABASE.NE.CPUMAX)PBASE=PYMIN+FYRATI*PYRANG
C
C               **************************************
C               **  STEP 60--                       **
C               **  IF CALLED FOR,                  **
C               **  FILL OVER/UNDER THE TRACE       **
C               **  (BUT CLIP FIRST, IF NECESSARY)  **
C               **************************************
C
      IFIG='GENE'
C
      IF(IRE2FS.EQ.'OFF')GOTO6190
      IPATT=IRE2PT
      PTHICK=PRE2PT
      PXGAP=PRE2PS
      PYGAP=PRE2PS
      ICOLF=IRE2FC
      ICOLP=IRE2PC
CCCCC AUGUST 1992.  SET IPATT2
      IPATT2='SOLI'
C
      CALL DPSQUE(PX,PY,NP,
     1PXMIN,PXMAX,PYMIN,PYMAX)
C
      IF(ABASE.EQ.CPUMAX)GOTO6110
      GOTO6120
C
 6110 CONTINUE
      DO6115I=1,NP
      PX2(I)=PX(I)
      PY2(I)=PY(I)
 6115 CONTINUE
      NP2=NP+1
      PX2(NP2)=PX(1)
      PY2(NP2)=PY(1)
C
      DO6116J=1,NP2
      IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
      IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
      IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
      IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 6116 CONTINUE
C
CCCCC AUGUST 1992.  ADD IPATT2
      CALL DPFIRE(PX2,PY2,NP2,
CCCCC1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP)
     1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,
     1IPATT2)
C
      GOTO6190
C
 6120 CONTINUE
      PBASE2=PBASE
      IF(PBASE2.LT.PYMIN.AND.(PYMIN-PBASE2).LE.0.0001)PBASE2=PYMIN
      IF(PBASE2.GT.PYMAX.AND.(PBASE2-PYMAX).LE.0.0001)PBASE2=PYMAX
C
      NP2=5
      NPM1=NP-1
      IF(NPM1.LE.0)GOTO6190
      DO6125I=1,NPM1
      IP1=I+1
C
      PLEFT=PX(I)
      PRIGHT=PX(IP1)
      IF(PLEFT.LT.PXMIN.AND.(PXMIN-PLEFT).LE.0.0001)PLEFT=PXMIN
      IF(PRIGHT.GT.PXMAX.AND.(PRIGHT-PXMAX).LE.0.0001)PRIGHT=PXMAX
C
      IF(PRIGHT.LT.PXMIN)GOTO6125
      IF(PLEFT.GT.PXMAX)GOTO6125
      IF(PY(I).LT.PYMIN.AND.PBASE2.LT.PYMIN)GOTO6125
      IF(PY(I).GT.PYMAX.AND.PBASE2.GT.PYMAX)GOTO6125
C
      PX2(1)=PLEFT
      PX2(2)=PRIGHT
      PX2(3)=PRIGHT
      PX2(4)=PLEFT
      PX2(5)=PLEFT
C
      PY2(1)=PBASE2
      PY2(2)=PBASE2
      PY2(3)=PY(IP1)
      PY2(4)=PY(I)
      PY2(5)=PBASE2
C
      DO6126J=1,NP2
      IF(PX2(J).LT.PXMIN)PX2(J)=PXMIN
      IF(PX2(J).GT.PXMAX)PX2(J)=PXMAX
      IF(PY2(J).LT.PYMIN)PY2(J)=PYMIN
      IF(PY2(J).GT.PYMAX)PY2(J)=PYMAX
 6126 CONTINUE
C
CCCCC AUGUST 1992.  ADD IPATT2
      CALL DPFIRE(PX2,PY2,NP2,
CCCCC1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP)
     1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,
     1IPATT2)
 6125 CONTINUE
C
      GOTO6190
C
 6190 CONTINUE
C
C               *****************************************
C               **  STEP 70--                          **
C               **  DRAW OUT THE TRACE                 **
C               **  (BUT CLIP IT FIRST, IF NECESSARY)  **
C               *****************************************
C
      IFIG='GENE'
      IPATT=ILI2PA
      PTHICK=PLI2TH
      ICOL=ILI2CO
C
CCCCC PX3 AND PY3 COMMENTED OUT IN DPCLTR, SO TREAT AS
CCCCC SCALAR HERE FOR NOW.
C
CCCCC CALL DPCLTR(PX,PY,NP,PX2,PY2,NP2,PY3,PX3,NP3,
      CALL DPCLTR(PX,PY,NP,PX2,PY2,NP2,PY9,PX9,NP3,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1ISORSW,
     1IFIG,IPATT,PTHICK,ICOL)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'DRTR')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF D3DRTR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)NP
 9012 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICASPL,ICAS3D
 9013 FORMAT('ICASPL,ICAS3D = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      IF(NP.LE.3)GOTO9029
      DO9025I=1,3
      WRITE(ICOUT,9026)I,XRAW(I),YRAW(I),ZRAW(I)
 9026 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
 9025 CONTINUE
      NPM2=NP-2
      DO9027I=NPM2,NP
      WRITE(ICOUT,9028)I,XRAW(I),YRAW(I),ZRAW(I)
 9028 FORMAT('I,XRAW(I),YRAW(I),ZRAW(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
 9027 CONTINUE
 9029 CONTINUE
      WRITE(ICOUT,9030)ISORSW
 9030 FORMAT('ISORSW = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9031)ILI2PA,ILI2CO,PLI2TH
 9031 FORMAT('ILI2PA,ILI2CO,PLI2TH = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9032)ARE2BA
 9032 FORMAT('ARE2BA = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9033)IRE2FS,IRE2FC
 9033 FORMAT('IRE2FS,IRE2FC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9034)IRE2PT,IRE2PL,IRE2PC,PRE2PT,PRE2PS
 9034 FORMAT('IRE2PT,IRE2PL,IRE2PC,PRE2PT,PRE2PS = ',
     1A4,2X,A4,2X,A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9044)PXMIN,PXMAX,PYMIN,PYMAX
 9044 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9045)FX1MIN,FX1MAX,FY1MIN,FY1MAX
 9045 FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9046)FXMIN,FXMAX,FYMIN,FYMAX
 9046 FORMAT('FXMIN,FXMAX,FYMIN,FYMAX= ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9047)IX1TSC,IY1TSC
 9047 FORMAT('IX1TSC,IY1TSC = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9049)IBUGG4,ISUBG4,IERRG4
 9049 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE D3MKBA(XRAW,YRAW,ZRAW,NRAW,IRAW,
     1IDIR,
     1WIDTHX,WIDTHY,WIDTHZ,
     1BASEX,BASEY,BASEZ,
     1XVECT,YVECT,ZVECT,IXNEAR,IXFAR,IYNEAR,IYFAR,IZNEAR,IZFAR,
     1XBAR,YBAR,ZBAR,NBAR)
C
C     PURPOSE--GIVEN A SINGLE POINT (XRAW(IRAW),YRAW(IRAW),ZRAW(IRAW))
C              IN 3-SPACE, AND AN EYE POSITION,
C              MAKE (= CONSTRUCT) A 3-D BAR.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISIONBAR
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--88/10
C     ORIGINAL VERSION--SEPTEMBER 1988.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IDIR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
CCCCC CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION XRAW(*)
      DIMENSION YRAW(*)
      DIMENSION ZRAW(*)
C
      DIMENSION XVECT(*)
      DIMENSION YVECT(*)
      DIMENSION ZVECT(*)
C
      DIMENSION XBAR(*)
      DIMENSION YBAR(*)
      DIMENSION ZBAR(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOBE.INC'
      INCLUDE 'DPCO3D.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='D3MK'
      ISUBN2='BA  '
C
      IF(IBUGG4.NE.'ON'.AND.ISUBG4.NE.'MKBA')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF D3MKBA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGG4,ISUBG4,IERRG4
   52 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',3A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IDIR
   53 FORMAT('IDIR = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)WIDTHX,WIDTHY,WIDTHZ
   54 FORMAT('WIDTHX,WIDTHY,WIDTHZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)BASEX,BASEY,BASEZ
   55 FORMAT('BASEX,BASEY,BASEZ    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)X3DEYE,Y3DEYE,Z3DEYE
   56 FORMAT('X3DEYE,Y3DEYE,Z3DEYE    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)XVECT(1),YVECT(1),ZVECT(1)
   61 FORMAT('XVECT(1),YVECT(1),ZVECT(1) = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)XVECT(2),YVECT(2),ZVECT(2)
   62 FORMAT('XVECT(2),YVECT(2),ZVECT(2) = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)IXNEAR,IXFAR,IYNEAR,IYFAR,IZNEAR,IZFAR
   63 FORMAT('IXNEAR,IXFAR,IYNEAR,IYFAR,IZNEAR,IZFAR = ',6I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,71)NRAW,IRAW
   71 FORMAT('NRAW,IRAW = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,72)IRAW,XRAW(IRAW),YRAW(IRAW),ZRAW(IRAW)
   72 FORMAT('IRAW,XRAW(IRAW),YRAW(IRAW),ZRAW(IRAW) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  MAKE (= CONSTRUCT) A BAR.                 **
C               **************************************************
C
C               **************************************************
C               **  STEP 11-                                    **
C               **  FIND THE NEAREST (TO THE EYE) VERTEX        **
C               **  OF OF THE 8 VERTICES OF THE 3-D BAR         **
C               **************************************************
C
      X0=XRAW(IRAW)
      Y0=YRAW(IRAW)
      Z0=ZRAW(IRAW)
C
      IF(IDIR.EQ.'V')GOTO1110
      IF(IDIR.EQ.'H1')GOTO1120
      IF(IDIR.EQ.'H2')GOTO1130
      GOTO1110
C
 1110 CONTINUE
      XVECT(1)=X0-WIDTHX/2.0
      XVECT(2)=X0+WIDTHX/2.0
      YVECT(1)=Y0-WIDTHY/2.0
      YVECT(2)=Y0+WIDTHY/2.0
      ZVECT(1)=BASEZ
      ZVECT(2)=Z0
      GOTO1150
C
 1120 CONTINUE
      XVECT(1)=BASEX
      XVECT(2)=X0
      YVECT(1)=Y0-WIDTHY/2.0
      YVECT(2)=Y0+WIDTHY/2.0
      ZVECT(1)=Z0-WIDTHZ/2.0
      ZVECT(2)=Z0+WIDTHZ/2.0
      GOTO1150
C
 1130 CONTINUE
      XVECT(1)=X0-WIDTHX/2.0
      XVECT(2)=X0+WIDTHX/2.0
      YVECT(1)=BASEY
      YVECT(2)=Y0
      ZVECT(1)=Z0-WIDTHZ/2.0
      ZVECT(2)=Z0+WIDTHZ/2.0
      GOTO1150
C
 1150 CONTINUE
C
      DISTSQ=CPUMAX
      DO1151IX=1,2
      XVECT2=XVECT(IX)
      DO1152IY=1,2
      YVECT2=YVECT(IY)
      DO1153IZ=1,2
      ZVECT2=ZVECT(IZ)
      DISTS2=(XVECT2-X3DEYE)**2+(YVECT2-Y3DEYE)**2+(ZVECT2-Z3DEYE)**2
      IF(DISTS2.LT.DISTSQ)GOTO1155
      GOTO1153
 1155 CONTINUE
      IXNEAR=IX
      IYNEAR=IY
      IZNEAR=IZ
 1153 CONTINUE
 1152 CONTINUE
 1151 CONTINUE
C
      IXFAR=1
      IF(IXNEAR.EQ.1)IXFAR=2
      IYFAR=1
      IF(IYNEAR.EQ.1)IYFAR=2
      IZFAR=1
      IF(IZNEAR.EQ.1)IZFAR=2
C
      XBAR(1)=XVECT(IXNEAR)
      XBAR(2)=XVECT(IXNEAR)
      XBAR(3)=XVECT(IXNEAR)
      XBAR(4)=XVECT(IXNEAR)
      XBAR(5)=XVECT(IXNEAR)
      YBAR(1)=YVECT(IYNEAR)
      YBAR(2)=YVECT(IYNEAR)
      YBAR(3)=YVECT(IYFAR)
      YBAR(4)=YVECT(IYFAR)
      YBAR(5)=YVECT(IYNEAR)
      ZBAR(1)=ZVECT(IZNEAR)
      ZBAR(2)=ZVECT(IZFAR)
      ZBAR(3)=ZVECT(IZFAR)
      ZBAR(4)=ZVECT(IZNEAR)
      ZBAR(5)=ZVECT(IZNEAR)
C
      XBAR(6)=XVECT(IXNEAR)
      XBAR(7)=XVECT(IXFAR)
      XBAR(8)=XVECT(IXFAR)
      XBAR(9)=XVECT(IXNEAR)
      XBAR(10)=XVECT(IXNEAR)
      YBAR(6)=YVECT(IYNEAR)
      YBAR(7)=YVECT(IYNEAR)
      YBAR(8)=YVECT(IYNEAR)
      YBAR(9)=YVECT(IYNEAR)
      YBAR(10)=YVECT(IYNEAR)
      ZBAR(6)=ZVECT(IZNEAR)
      ZBAR(7)=ZVECT(IZNEAR)
      ZBAR(8)=ZVECT(IZFAR)
      ZBAR(9)=ZVECT(IZFAR)
      ZBAR(10)=ZVECT(IZNEAR)
C
      XBAR(11)=XVECT(IXNEAR)
      XBAR(12)=XVECT(IXNEAR)
      XBAR(13)=XVECT(IXFAR)
      XBAR(14)=XVECT(IXFAR)
      XBAR(15)=XVECT(IXNEAR)
      YBAR(11)=YVECT(IYNEAR)
      YBAR(12)=YVECT(IYFAR)
      YBAR(13)=YVECT(IYFAR)
      YBAR(14)=YVECT(IYNEAR)
      YBAR(15)=YVECT(IYNEAR)
      ZBAR(11)=ZVECT(IZNEAR)
      ZBAR(12)=ZVECT(IZNEAR)
      ZBAR(13)=ZVECT(IZNEAR)
      ZBAR(14)=ZVECT(IZNEAR)
      ZBAR(15)=ZVECT(IZNEAR)
C
      NBAR=15
C
C               *****************
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.NE.'ON'.AND.ISUBG4.NE.'MKBA')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF D3MKBA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGG4,ISUBG4,IERRG4
 9012 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',3A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IDIR
 9013 FORMAT('IDIR = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)WIDTHX,WIDTHY,WIDTHZ
 9014 FORMAT('WIDTHX,WIDTHY,WIDTHZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)BASEX,BASEY,BASEZ
 9015 FORMAT('BASEX,BASEY,BASEZ    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)X3DEYE,Y3DEYE,Z3DEYE
 9016 FORMAT('X3DEYE,Y3DEYE,Z3DEYE    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)XVECT(1),YVECT(1),ZVECT(1)
 9021 FORMAT('XVECT(1),YVECT(1),ZVECT(1) = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)XVECT(2),YVECT(2),ZVECT(2)
 9022 FORMAT('XVECT(2),YVECT(2),ZVECT(2) = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9023)IXNEAR,IXFAR,IYNEAR,IYFAR,IZNEAR,IZFAR
 9023 FORMAT('IXNEAR,IXFAR,IYNEAR,IYFAR,IZNEAR,IZFAR = ',6I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9031)NRAW,IRAW
 9031 FORMAT('NRAW,IRAW = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9032)IRAW,XRAW(IRAW),YRAW(IRAW),ZRAW(IRAW)
 9032 FORMAT('IRAW,XRAW(IRAW),YRAW(IRAW),ZRAW(IRAW) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9041)NBAR
 9041 FORMAT('NBAR = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9042I=1,NBAR
      WRITE(ICOUT,9043)I,XBAR(I),YBAR(I),ZBAR(I)
 9043 FORMAT('I,XBAR(I),YBAR(I),ZBAR(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
 9042 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE D3MKSP(XRAW,YRAW,ZRAW,NRAW,IRAW,
     1IDIR,
     1BASEX,BASEY,BASEZ,
     1XSPIKE,YSPIKE,ZSPIKE,NSPIKE)
C
C     PURPOSE--GIVEN A SINGLE POINT (XRAW(IRAW),YRAW(IRAW),ZRAW(IRAW))
C              IN 3-SPACE,
C              MAKE (= CONSTRUCT) A 3-D SPIKE.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISIONSPIKE
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--88/10
C     ORIGINAL VERSION--SEPTEMBER 1988.
C     UPDATED         --APRIL   1992.  BASE2 TO BASEX/Y/Z
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IDIR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION XRAW(*)
      DIMENSION YRAW(*)
      DIMENSION ZRAW(*)
C
      DIMENSION XSPIKE(*)
      DIMENSION YSPIKE(*)
      DIMENSION ZSPIKE(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOBE.INC'
      INCLUDE 'DPCO3D.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='D3MK'
      ISUBN2='SP  '
C
      IF(IBUGG4.NE.'ON'.AND.ISUBG4.NE.'MKSP')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF D3MKSP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGG4,ISUBG4,IERRG4
   52 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',3A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)NRAW,IRAW
   53 FORMAT('NRAW,IRAW = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)IDIR
   61 FORMAT('IDIR = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)BASEX,BASEY,BASEZ
   62 FORMAT('BASEX,BASEY,BASEZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)IRAW,XRAW(IRAW),YRAW(IRAW),ZRAW(IRAW)
   63 FORMAT('IRAW,XRAW(IRAW),YRAW(IRAW),ZRAW(IRAW) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,71)X3DEYE,Y3DEYE,Z3DEYE
   71 FORMAT('X3DEYE,Y3DEYE,Z3DEYE = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  STEP 11-                                    **
C               **  MAKE (= CONSTRUCT) A SPIKE.                 **
C               **************************************************
C
      IF(IDIR.EQ.'V')GOTO1110
      IF(IDIR.EQ.'HX')GOTO1120
      IF(IDIR.EQ.'HY')GOTO1130
      GOTO1110
C
 1110 CONTINUE
      XSPIKE(1)=XRAW(IRAW)
      YSPIKE(1)=YRAW(IRAW)
CCCCC THE FOLLOWING LINE WAS FIXED    APRIL 1992 (ALAN)
CCCCC ZSPIKE(1)=BASE2
      ZSPIKE(1)=BASEZ
      GOTO1150
C
 1120 CONTINUE
CCCCC THE FOLLOWING LINE WAS FIXED    APRIL 1992 (ALAN)
CCCCC XSPIKE(1)=BASE2
      XSPIKE(1)=BASEX
      YSPIKE(1)=YRAW(IRAW)
      ZSPIKE(1)=ZRAW(IRAW)
      GOTO1150
C
 1130 CONTINUE
      XSPIKE(1)=XRAW(IRAW)
CCCCC THE FOLLOWING LINE WAS FIXED    APRIL 1992 (ALAN)
CCCCC YSPIKE(1)=BASE2
      YSPIKE(1)=BASEY
      ZSPIKE(1)=ZRAW(IRAW)
      GOTO1150
C
 1150 CONTINUE
C
      XSPIKE(2)=XRAW(IRAW)
      YSPIKE(2)=YRAW(IRAW)
      ZSPIKE(2)=ZRAW(IRAW)
C
      NSPIKE=2
C
C               *****************
C               **  EXIT.      **
C               *****************
C
      IF(IBUGG4.NE.'ON'.AND.ISUBG4.NE.'MKSP')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF D3MKSP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGG4,ISUBG4,IERRG4
 9012 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',3A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IDIR
 9013 FORMAT('IDIR = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)BASEX,BASEY,BASEZ
 9014 FORMAT('BASEX,BASEY,BASEZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)NRAW,IRAW
 9021 FORMAT('NRAW,IRAW = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)IRAW,XRAW(IRAW),YRAW(IRAW),ZRAW(IRAW)
 9022 FORMAT('IRAW,XRAW(IRAW),YRAW(IRAW),ZRAW(IRAW) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9031)X3DEYE,Y3DEYE,Z3DEYE
 9031 FORMAT('X3DEYE,Y3DEYE,Z3DEYE = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9041)NSPIKE
 9041 FORMAT('NSPIKE = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9042I=1,NSPIKE
      WRITE(ICOUT,9043)I,XSPIKE(I),YSPIKE(I),ZSPIKE(I)
 9043 FORMAT('I,XSPIKE(I),YSPIKE(I),ZSPIKE(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
 9042 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE D3SCAL(PX,PY,NP)
C
C     PURPOSE--EXECUTE A SCALING AND TRANSLATION
C      OF 3D POINTS THAT HAVE ALREADY
C     BEEN TRANSLATED INTO 2D VALUES
C     BUT NOW NEED TO BE SCALED AND TRANSLATED
C     TO PROPER 0 TO 100 SCREEN VALUES.
C     WRITTEN BY--JAMES J. FILLIBEN
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--93/10
C     ORIGINAL VERSION--SEPTEMBER 1993.
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--SEPTEMBER 1993.
C
C-----COMMON STATEMENTS-----------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
C
      INCLUDE 'DPCO3D.INC'
      INCLUDE 'DPCOPC.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
CCCCC CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION PX(*)
      DIMENSION PY(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='D3SC'
      ISUBN2='AL  '
C
      FXMIN=FX1MIN
      FXMAX=FX1MAX
      FYMIN=FY1MIN
      FYMAX=FY1MAX
C
      FXRANG=FXMAX-FXMIN
      FYRANG=FYMAX-FYMIN
      PXRANG=PXMAX-PXMIN
      PYRANG=PYMAX-PYMIN
C
      DO1000I=1,NP
      FXRATI=(PX(I)-FXMIN)/FXRANG
      FYRATI=(PY(I)-FYMIN)/FYRANG
      PX(I)=PXMIN+FXRATI*PXRANG
      PY(I)=PYMIN+FYRATI*PYRANG
 1000 CONTINUE
C
      RETURN
      END
      SUBROUTINE D3TR32(X,Y,Z,N,XT,ZT,NT)
C
C     PURPOSE--EXECUTE A 3-D TRANSFORMATION
C              (ORTHOGRAPHIC OR PERSPECTIVE)
C              WHICH TAKES A 3-D DATA CLOUD
C              AND MAPS IN ONTO A 2-D PLANE
C              (IDENTICALLY THE ORIGINAL XZ PLANE).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, TR32ACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--88/10
C     ORIGINAL VERSION--MARCH     1979.
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--SEPTEMBER 1988.
C     UPDATE          --JUNE      1990.  COMPILE ERROR IN A WRITE STATEMENT
C
C-----COMMON STATEMENTS-----------------------------------------------
C
      INCLUDE 'DPCO3D.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION Y(*)
      DIMENSION Z(*)
      DIMENSION XT(*)
      DIMENSION ZT(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='D3TR'
      ISUBN2='32  '
C
      IERRG4='NO'
C
      EPS=0.0000001
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'TR32')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF D3TR32--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGG4,ISUBG4,IERRG4
   52 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)I3DPRO
   53 FORMAT('I3DPRO = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)X3DEYE,Y3DEYE,Z3DEYE
   54 FORMAT('X3DEYE,Y3DEYE,Z3DEYE = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)X3DMID,Y3DMID,Z3DMID
   55 FORMAT('X3DMID,Y3DMID,Z3DMID = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)D3DCXX,D3DCXY,D3DCXZ
   64 FORMAT('D3DCXX,D3DCXY,D3DCXZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,65)D3DCYX,D3DCYY,D3DCYZ
   65 FORMAT('D3DCYX,D3DCYY,D3DCYZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,66)D3DCZX,D3DCZY,D3DCZZ
   66 FORMAT('D3DCZX,D3DCZY,D3DCZZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,71)N
   71 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO72I=1,N
      WRITE(ICOUT,73)I,X(I),Y(I),Z(I)
   73 FORMAT('I,X(I),Y(I),Z(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
   72 CONTINUE
   90 CONTINUE
C
C               *********************************************************
C               **  GENERAL DISCUSSION--                               **
C               **  DETERMINE (IN ORIGINAL COORDINATE SYSTEM VALUES)   **
C               **  WHERE THE DATA POINTS FALL ON THE VISUAL PLANE.    **
C               **  FOR EACH (XD,YD,ZD) DATA POINT,                    **
C               **  DETERMINE WHERE THE VISUAL RAY FROM                **
C               **  THE DATA POINT TO OUR EYE                          **
C               **  STRIKES THE VISUAL (PERSPECTIVE) PLANE.            **
C               **  THE VISUAL PLANE IS THAT PLANE                     **
C               **  WHICH IS NORMAL TO OUR EYE                         **
C               **  AND WHICH CONTAINS THE AVERAGE POINT (XM,YM,ZM).   **
C               **  THE EQUATION OF THE VISUAL PLANE IS                **
C               **  (X3DEYE-XM)(X-XM) + (Y3DEYE-YM)(Y-YM) +
C               **                    + (Z3DEYE-YM)(Z-ZM) = 0          **
C               **  WHERE X, Y, Z ARE THE DUMMY VARIABLES              **
C               **  REPRESENTING ANY POINT (X,Y,Z) ON THAT PLANE.      **
C               **  THIS EQUATION MUST BE SOLVED FOR X, Y, AND Z.      **
C               **  THE EQUATIONS OF THE LINE FROM THE DATA POINT
C               **  (XD,YD,ZD)
C               **  TO OUR EYE (X3DEYE,Y3DEYE,Z3DEYE) ARE
C               **  (X-XD)/(X3DEYE-XD) = (Y-YD)/(Y3DEYE-YD)
C               **                     = (Z-ZD)/(Z3DEYE-ZD)
C               **  WHERE (XD,YD,ZD) REPRESENTS A DATA POINT.           **
C               **  THE VISUAL PLANE EQUATION AND THE LINE EQUATIONS    **
C               **  MUST BE COMBINED TO SOLVE FOR THE VALUES (X,Y,Z)    **
C               **  ON THE VISUAL PLANE AS OUR EYE SEES THEM.           **
C               **********************************************************
C
C               **********************************************************
C               **  THE FINAL PLOT STATEMENT WILL INVOLVE
C               **  ONLY 2 VECTORS.
C               **  AT THE MOMENT, THE POINTS (XP,YP,ZP)
C               **  ON THE VISUAL PLANE ARE DEFINED
C               **  BY 3 COORDINATE VALUES.
C               **  TO REDUCE THE 3 COORDINATE VALUES
C               **  TO 2 COORDINATE VALUES,
C               **  WE MUST ROTATE THE VISUAL PLANE
C               **  SO THAT IT IS PARALLEL TO THE ORIGINAL XZ PLANE.
C               **  TO CARRY OUT SUCH A ROTATION, WE MUST
C               **  DETERMINE THE DIRECTION NUMBERS AND DIRECTION COSINES
C               **  OF THE NEW AXES IN TERMS OF THE OLD COORDINATE SYSTEM.
C               **  THE NEW Y AXIS WILL (BY CONSTRUCTION) BE
C               **  ON THE NORMAL LINE TRAVELING FROM
C               **  THE AVERAGE POINT (XM,YM,ZM) TO OUR EYE POINT
C               **  (X3DEYE,Y3DEYE,Z3DEYE)
C               **  AND WILL THEREFORE HAVE DIRECTIONS NUMBERS
C               **  X3DEYE, Y3DEYE, Z3DEYE
C               **  THE NEW Z AXIS WILL BE PERPENDICULAR TO THE NEW Y AXIS
C               **  AND WILL RESIDE IN THE PLANE CONTAINING THE
C               **  THE FOLLOWING 3 POINTS--
C               **      1) THE AVERAGE POINT (XM,YM,ZM)
C               **      2) THE EYE POINT (X3DEYE,Y3DEYE,Z3DEYE)
C               **      3) SOME POINT (SAY (XM,YM,ZM+1)) OF THE OLD Z AXIS
C               **         DISPLACED OVER SO AS TO EMANATE FROM (XM,YM,ZM).
C               **  THE ABOVE 3 POINTS DEFINE A VERTICAL PLANE.
C               **  THE PURPOSE OF THE VERTICAL PLANE IS TO DEFINE
C               **  WHICH DIRECTION IS 'UP' IN THE FINAL PICTURE.
C               **  THE EQUATION OF THE VERTICAL PLANE IS
C               **  (A-XM)(X-XM) + (B-YM)(Y-YM) + (C-ZM)(Z-ZM) = 0 .
C               **  THIS EQUATION MUST BE SOLVED FOR A, B, AND C.
C               **  WITHOUT LOSS OF GENERALITY, A MAY BE INITIALLY SET TO 1.
C               **  THE SOLUTION TURNS OUT TO BE
C               **      A = 1
C               **      B = -X3DEYE/Y3DEYE
C               **      C = 0
C               **  NOTE, HOWEVER, THAT THESE A, B, AND C VALUES
C               **  FOR THIS VERTICAL PLANE WILL BE IDENTICAL TO THE
C               **  DIRECTION NUMBERS FOR THE NORMAL TO THIS VERTICAL PLANE
C               **  WHICH IS IDENTICALLY THE NEW X AXIS
C               **  AND SO THE ABOVE A, B, AND C VALUES DEFINE THE DIRECTION
C               **  DIRECTION NUMBERS FOR THE NEW X AXIS.
C               **  TO SOLVE FOR THE DIRECTION NUMBERS FOR THE NEW Z AXIS,
C               **  WE SEEK 3 DIRECTION NUMBERS D, E, AND F
C               **  WHICH MUST BE PERPENDICULAR TO BOTH THE
C               **  NEW Y AXIS (WITH DIRECTION NUMBERS X3DEYE, Y3DEYE,
C               **  AND Z3DEYE)
C               **  AND THE NEW X AXIS (WITH DIRECTION NUMBERS A, B, AND C ABOVE
C               **  WITHOUT LOSS OF GENERALITY, D MAY BE INITIALLY SET TO 1.
C               **  NOTE THAT WHENEVER 2 LINES ARE PERPENDICULAR,
C               **  THE INNER PRODUCT OF THE DIRECTION NUMBERS MUST = 0.
C               **  WITHOUT LOSS OF GENERALITY, D MAY BE INITIALLY SET TO 1.
C               **  INCORPORATING THE 2 INNER PRODUCT EQUATIONS,
C               **  WE MAY SOLVE FOR E AND F.
C               **  THE SOLUTIONS TURN OUT TO BE
C               **      D = 1
C               **      E = Y3DEYE/X3DEYE
C               **      F = (-X3DEYE*X3DEYE - Y3DEYE*Y3DEYE) / (X3DEYE*Z3DEYE)
C               **
C               **  IN SUMMARY, THE DIRECTION NUMBERS FOR THE 3 NEW AXES
C               **  MAY BE WRITTEN AS
C               **      NEW X AXIS:  Y3DEYE       -X3DEYE     0
C               **      NEW Y AXIS:  X3DEYE       Y3DEYE      Z3DEYE
C               **      NEW Z AXIS:  -X3DEYE*Z3DEYE   -Y3DEYE*Z3DEYE
C               **                                        X3DEYE*X3DEYE+Y3DEYE
C               **  NOTE THAT BY INSPECTION WE SEE RETROSPECTIVELY
C               **  THAT THE 3 INNER PRODUCTS ALL = 0
C               **  AND SO THE 3 DEFINED AXES ARE ALL PERPENDICULAR
C               **  (AS THEY SHOULD BE).
C               **
C               **  THE CORRESPONDING DIRECTION COSINES
C               **  ARE GOTTEN BY NORMALIZATION TO UNITY;
C               **  LET US SYMBOLICALLY REPRESENT THEM BY--
C               **      D3DCXX   D3DCXY   D3DCXZ
C               **      D3DCYX   D3DCYY   D3DCYZ
C               **      D3DCZX   D3DCZY   D3DCZZ
C               **  THE ABOVE RESULTS WERE ACTUALLY ARRIVED AT
C               **  (AND ARE VALID FOR) BY DISPLACING THE OLD ORIGIN
C               **  FROM (0,0,0) TO (XM,YM,ZM).
C               **  THIS SIMPLIFIES THE EQUATIONS CONSIDERABLY.
C               **
C               **  GIVEN THAT WE NOW HAVE THE DIRECTION COSINES
C               **  OF THE NEW AXES IN TERMS OF THE OLD COORDINATES,
C               **  WE MAKE USE OF
C               **  EISENHART (COORDINATE GEOMETRY, PAGE 160) WHICH STATES
C               **  THAT THE LINEAR TRANSFORMATION THAT IS NEEDED TO CARRY OUT
C               **  THE ROTATION FROM THE VISUAL PLANE TO THE XZ PLANE
C               **  IS GIVEN BY
C               **      XT = XM + D3DCXX(X-XM) + D3DCXY(Y-YM) + D3DCXZ(Z-ZM)
C               **      YT = YM + D3DCYX(X-XM) + D3DCYY(Y-YM) + D3DCYZ(Z-ZM)
C               **      ZT = ZM + D3DCZX(X-XM) + D3DCZY(Y-YM) + D3DCZZ(Z-ZM)
C               **
C               **  NOTE THAT BY INSPECTION OF THE ABOVE TRANSFORMATION
C               **  IT IS SEEN THAT (XM,YM,ZM) IS MAPPED INTO (XM,YM,ZM)
C               **  (AS IT SHOULD BE).
C               **  NOTE ALSO THAT THE EYE POINT AND ANY POINT ALONG THE LINE
C               **  OF SIGHT WOULD HAVE BEEN MAPPED INTO (XM,YM,ZM)
C               **  AS IT SHOULD BE.
C               **  NOTE ALSO THAT ALL POINTS ON THE VISUAL PLANE
C               **  SINCE THEY SATISFY
C               **     (X3DEYE-XM)(X-XM) + (Y3DEYE-YM)(Y-YM) + (Z3DEYE-ZM)(Z-ZM)
C               **     = 0
C               **  GETS MAPPED INTO THE CONSTANT YT VALUE OF YT = YM
C               **  AND SO THE TRANSFORMED PLOT SURFACE IS ONE WHICH
C               **  IS PARALLEL TO THE XZ PLANE BUT IS DISPLACED
C               **  YM UNITS OUT FROM THE XZ PLANE.
C               **  THIS PLOT PLANE WILL CONTAIN THE POINT (XM,YM,ZM).
C               ****************************************************************
C
C               **************************************************
C               **  STEP 11--                                   **
C               **  BRANCH TO THE APPROPRIATE                   **
C               **  TRANSFORMATION                              **
C               **************************************************
C
      ISTEPN='11'
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'TR32')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NT=N
C
      XDEL=X3DEYE-X3DMID
      IF(XDEL.EQ.0.0)XDEL=EPS
      YDEL=Y3DEYE-Y3DMID
      IF(YDEL.EQ.0.0)YDEL=EPS
      ZDEL=Z3DEYE-Z3DMID
      IF(ZDEL.EQ.0.0)ZDEL=EPS
C
      IF(I3DPRO.EQ.'ORTH')GOTO2100
      GOTO3100
C
C               **************************************************
C               **  STEP 21--                                   **
C               **  TREAT THE ORTHOGRAPHIC TRANSFORMATION CASE  **
C               **************************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'TR32')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     THE FOLLOWING IS INCORRECT (XM FOR X(I) ETC.)
CCCCC MAY 1996.  NP12 IS UNDEFINED.  USE NT.
CCCCC DO2110I=1,NP12
      DO2110I=1,NT
C
C     ***** 5 LINES OF CODE TO ADJUST FOR DIVISION BY 0 ADDED AUGUST 1983 *****
CCCCC A11=XDEL
CCCCC A12=YDEL
CCCCC A13=ZDEL
CCCCC A23=Y3DEYE-Y3DMID
CCCCC IF(A23.EQ.0.0)A21=EPS
CCCCC A23=-(X3DEYE-X3DMID)
CCCCC IF(A23.EQ.0.0)A22=EPS
CCCCC A23=0.0
CCCCC A31=0.0
CCCCC A32=Z3DEYE-Z3DMID
CCCCC IF(A32.EQ.0.0)A32=EPS
CCCCC A33=-(Y3DEYE-Y3DMID)
CCCCC IF(A33.EQ.0.0)A33=EPS
C
CCCCC R1=XDEL*X3DMID+YDEL*Y3DMID+ZDEL*Z3DMID
CCCCC R2=(Y3DEYE-Y3DMID)*X3DMID-(X3DEYE-X3DMID)*YM
CCCCC R3=(Z3DEYE-Z3DMID)*Y3DMID-(Y3DEYE-Y3DMID)*Z3DMID
C
CCCCC P12=-A23/A11
CCCCC P13=-A32/(P12*A12+A23)
C
CCCCC ZPI=(P13*(P12*R1+R2)+R3)/
CCCCC1(P13*P12*A13+A33)
CCCCC YPI=(R3-A33*ZPI)/A32
CCCCC XPI=(R2-A23*YPI)/A21
CCCCC IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'TR32')
CCCCC1WRITE(ICOUT,2111)I,XPI,YPI,ZPI
C2111 FORMAT('I,XPI,YPI,ZPI = ',I8,3E15.7)
CCCCC IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'TR32')
CCCCC1CALL DPWRST('XXX','BUG ')
C
CCCCC DELX=XPI-X3DMID
CCCCC DELY=YPI-Y3DMID
CCCCC DELZ=ZPI-Z3DMID
CCCCC XT(I)=X3DMID+D3DCXX*DELX+D3DCXY*DELY+D3DCXZ*DELZ
CCCCC YT(I)=Y3DMID+D3DCYX*DELX+D3DCYY*DELY+D3DCYZ*DELZ
CCCCC ZT(I)=X3DMID+D3DCZX*DELX+D3DCZY*DELY+D3DCZZ*DELZ
      DELX=X(I)-X3DMID
      DELY=Y(I)-Y3DMID
      DELZ=Z(I)-Z3DMID
      XT(I)=X3DMID+TERMXX*DELX+TERMXY*DELY+TERMXZ*DELZ
      ZT(I)=X3DMID+TERMZX*DELX+TERMZY*DELY+TERMZZ*DELZ
C
 2110 CONTINUE
      GOTO9000
C
C               **************************************************
C               **  STEP 31--                                   **
C               **  TREAT THE PERSPECTIVE TRANSFORMATION CASE   **
C               **************************************************
C
 3100 CONTINUE
C
      ISTEPN='31'
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'TR32')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO3110I=1,N
C
C     ***** 5 LINES OF CODE TO ADJUST FOR DIVISION BY 0 ADDED AUGUST 1983 *****
      A11=XDEL
      A12=YDEL
      A13=ZDEL
      A21=Y3DEYE-Y(I)
      IF(A21.EQ.0.0)A21=EPS
      A22=-(X3DEYE-X(I))
      IF(A22.EQ.0.0)A22=EPS
      A23=0.0
      A31=0.0
      A32=Z3DEYE-Z(I)
      IF(A32.EQ.0.0)A32=EPS
      A33=-(Y3DEYE-Y(I))
      IF(A33.EQ.0.0)A33=EPS
C
      R1=XDEL*X3DMID+YDEL*Y3DMID+ZDEL*Z3DMID
      R2=(Y3DEYE-Y(I))*X(I)-(X3DEYE-X(I))*Y(I)
      R3=(Z3DEYE-Z(I))*Y(I)-(Y3DEYE-Y(I))*Z(I)
C
      P12=-A21/A11
      P13=-A32/(P12*A12+A22)
C
      ZPI=(P13*(P12*R1+R2)+R3)/
     1(P13*P12*A13+A33)
      YPI=(R3-A33*ZPI)/A32
      XPI=(R2-A22*YPI)/A21
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'TR32')
     1WRITE(ICOUT,3111)I,XPI,YPI,ZPI
 3111 FORMAT('I,XPI,YPI,ZPI = ',I8,3E15.7)
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'TR32')
     1CALL DPWRST('XXX','BUG ')
C
      DELX=XPI-X3DMID
      DELY=YPI-Y3DMID
      DELZ=ZPI-Z3DMID
      XT(I)=X3DMID+D3DCXX*DELX+D3DCXY*DELY+D3DCXZ*DELZ
CCCCC YT(I)=Y3DMID+D3DCYX*DELX+D3DCYY*DELY+D3DCYZ*DELZ
      ZT(I)=X3DMID+D3DCZX*DELX+D3DCZY*DELY+D3DCZZ*DELZ
C
 3110 CONTINUE
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'TR32')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF D3TR32--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGG4,ISUBG4,IERRG4
 9012 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',3A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)I3DPRO
 9013 FORMAT('I3DPRO = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IBUGG4,ISUBG4,IERRG4
 9014 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',3A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)X3DEYE,Y3DEYE,Z3DEYE
 9015 FORMAT('X3DEYE,Y3DEYE,Z3DEYE = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)X3DMID,Y3DMID,Z3DMID
 9016 FORMAT('X3DMID,Y3DMID,Z3DMID = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9024)D3DCXX,D3DCXY,D3DCXZ
 9024 FORMAT('D3DCXX,D3DCXY,D3DCXZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9025)D3DCYX,D3DCYY,D3DCYZ
 9025 FORMAT('D3DCYX,D3DCYY,D3DCYZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9026)D3DCZX,D3DCZY,D3DCZZ
 9026 FORMAT('D3DCZX,D3DCZY,D3DCZZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9031)XDEL,YDEL,ZDEL
 9031 FORMAT('XDEL,YDEL,ZDEL = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9032)A11,A12,A13
 9032 FORMAT('A11,A12,A13    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9033)A21,A22,A23
 9033 FORMAT('A21,A22,A23    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9034)A31,A32,A33
 9034 FORMAT('A31,A32,A33    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9035)R1,R2,R3
 9035 FORMAT('R1,R2,R3       = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9036)P12,P13
 9036 FORMAT('P12,P13        = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9037)XPI,YPI,ZPI
 9037 FORMAT('XPI,YPI,ZPI    = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9038)DELX,DELY,DELZ
 9038 FORMAT('DELX,DELY,DELZ = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9039)XT(N),ZT(N)
 9039 FORMAT('XT(N),ZT(N)    = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9041)N,NT
 9041 FORMAT('N,NT = ',2I8)
      CALL DPWRST('XXX','BUG ')
      DO9042I=1,N
      WRITE(ICOUT,9043)I,X(I),Y(I),Z(I),XT(I),ZT(I)
 9043 FORMAT('I,X(I),Y(I),Z(I),XT(I),ZT(I) = ',I8,5E11.3)
      CALL DPWRST('XXX','BUG ')
 9042 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE D3TRXP(X,Y,N,IDIR,ABASE,
     1FXMIN,FXMAX,FXRANG,FYMIN,FYMAX,FYRANG,
     1PXMIN,PXMAX,PXRANG,PYMIN,PYMAX,PYRANG,
     1PX,PY,NP,PBASE)
C
C     PURPOSE--TRANSLATE 2-D RAW OR INTERMEDIATE DATA
C              INTO 2-D VISUAL PLANE (0 TO 100) DATA
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--88/10
C     ORIGINAL VERSION--SEPTEMBER 1988.
C
C-----COMMON STATEMENTS-----------------------------------------------
C
      INCLUDE 'DPCO3D.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IDIR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
CCCCC CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION Y(*)
      DIMENSION PX(*)
      DIMENSION PY(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='D3TR'
      ISUBN2='XP  '
C
      IERRG4='NO'
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'TRXP')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF D3TRXP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGG4,ISUBG4,IERRG4
   52 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)FXMIN,FXMAX,FXRANG
   53 FORMAT('FXMIN,FXMAX,FXRANG = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)FYMIN,FYMAX,FYRANG
   54 FORMAT('FYMIN,FYMAX,FYRANG = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)PXMIN,PXMAX,PXRANG
   55 FORMAT('PXMIN,PXMAX,PXRANG = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)PYMIN,PYMAX,PYRANG
   56 FORMAT('PYMIN,PYMAX,PYRANG = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,57)ABASE
   57 FORMAT('ABASE = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)N,IDIR
   61 FORMAT('N,IDIR = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
      DO62I=1,N
      WRITE(ICOUT,63)I,X(I),Y(I)
   63 FORMAT('I,X(I),Y(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
   62 CONTINUE
   90 CONTINUE
C
C               *****************************************************
C               **  STEP 11--                                      **
C               **  TRANSLATE THE 2-D PLANE DATA POINTS            **
C               **  INTO STANDARDIZED (0.0 TO 100.0) COORDINATES.  **
C               *****************************************************
C
      NP=N
C
      DO1110I=1,N
      FXRATI=(X(I)-FXMIN)/FXRANG
      FYRATI=(Y(I)-FYMIN)/FYRANG
      PX(I)=PXMIN+FXRATI*PXRANG
      PY(I)=PYMIN+FYRATI*PYRANG
 1110 CONTINUE
C
      IF(IDIR.EQ.'V')GOTO1120
      GOTO1129
 1120 CONTINUE
      FYRATI=(ABASE-FYMIN)/FYRANG
      PBASE=PYMIN+FYRATI*PYRANG
 1129 CONTINUE
C
      IF(IDIR.EQ.'H')GOTO1130
      GOTO1139
 1130 CONTINUE
      FXRATI=(ABASE-FXMIN)/FXRANG
      PBASE=PXMIN+FXRATI*PXRANG
 1139 CONTINUE
C
C               **************************************************
C               **  STEP 90--                                   **
C               **  EXIT.                                       **
C               **************************************************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'TRXP')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF D3TRXP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGG4,ISUBG4,IERRG4
 9012 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)FXMIN,FXMAX,FXRANG
 9013 FORMAT('FXMIN,FXMAX,FXRANG = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)FYMIN,FYMAX,FYRANG
 9014 FORMAT('FYMIN,FYMAX,FYRANG = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)PXMIN,PXMAX,PXRANG
 9015 FORMAT('PXMIN,PXMAX,PXRANG = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)PYMIN,PYMAX,PYRANG
 9016 FORMAT('PYMIN,PYMAX,PYRANG = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)ABASE
 9017 FORMAT('ABASE = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)N,NP,IDIR
 9021 FORMAT('N,NP,IDIR = ',2I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
      DO9022I=1,N
      WRITE(ICOUT,9023)I,X(I),Y(I),PX(I),PY(I)
 9023 FORMAT('I,X(I),Y(I),PX(I),PY(I) = ',I8,4E15.7)
      CALL DPWRST('XXX','BUG ')
 9022 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      FUNCTION E1 (X)
C***BEGIN PROLOGUE  E1
C***PURPOSE  Compute the exponential integral E1(X).
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C5
C***TYPE      SINGLE PRECISION (E1-S, DE1-D)
C***KEYWORDS  E1 FUNCTION, EXPONENTIAL INTEGRAL, FNLIB,
C             SPECIAL FUNCTIONS
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C E1 calculates the single precision exponential integral, E1(X), for
C positive single precision argument X and the Cauchy principal value
C for negative X.  If principal values are used everywhere, then, for
C all X,
C
C    E1(X) = -Ei(-X)
C or
C    Ei(X) = -E1(-X).
C
C
C Series for AE11       on the interval -1.00000D-01 to  0.
C                                        with weighted error   1.76E-17
C                                         log weighted error  16.75
C                               significant figures required  15.70
C                                    decimal places required  17.55
C
C
C Series for AE12       on the interval -2.50000D-01 to -1.00000D-01
C                                        with weighted error   5.83E-17
C                                         log weighted error  16.23
C                               significant figures required  15.76
C                                    decimal places required  16.93
C
C
C Series for E11        on the interval -4.00000D+00 to -1.00000D+00
C                                        with weighted error   1.08E-18
C                                         log weighted error  17.97
C                               significant figures required  19.02
C                                    decimal places required  18.61
C
C
C Series for E12        on the interval -1.00000D+00 to  1.00000D+00
C                                        with weighted error   3.15E-18
C                                         log weighted error  17.50
C                        approx significant figures required  15.8
C                                    decimal places required  18.10
C
C
C Series for AE13       on the interval  2.50000D-01 to  1.00000D+00
C                                        with weighted error   2.34E-17
C                                         log weighted error  16.63
C                               significant figures required  16.14
C                                    decimal places required  17.33
C
C
C Series for AE14       on the interval  0.          to  2.50000D-01
C                                        with weighted error   5.41E-17
C                                         log weighted error  16.27
C                               significant figures required  15.38
C                                    decimal places required  16.97
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  CSEVL, INITS, R1MACH, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   770701  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   891115  Modified prologue description.  (WRB)
C   891115  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   920618  Removed space from variable names.  (RWC, WRB)
C***END PROLOGUE  E1
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOMC.INC'
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DIMENSION AE11CS(39), AE12CS(25), E11CS(19), E12CS(16),
     1  AE13CS(25), AE14CS(26)
      LOGICAL FIRST
      SAVE AE11CS, AE12CS, E11CS, E12CS, AE13CS, AE14CS,
     1 NTAE11, NTAE12, NTE11, NTE12, NTAE13, NTAE14, XMAX, FIRST
      DATA AE11CS( 1) /    .1215032397 1606579E0 /
      DATA AE11CS( 2) /   -.0650887785 13550150E0 /
      DATA AE11CS( 3) /    .0048976513 57459670E0 /
      DATA AE11CS( 4) /   -.0006492378 43027216E0 /
      DATA AE11CS( 5) /    .0000938404 34587471E0 /
      DATA AE11CS( 6) /    .0000004202 36380882E0 /
      DATA AE11CS( 7) /   -.0000081133 74735904E0 /
      DATA AE11CS( 8) /    .0000028042 47688663E0 /
      DATA AE11CS( 9) /    .0000000564 87164441E0 /
      DATA AE11CS(10) /   -.0000003448 09174450E0 /
      DATA AE11CS(11) /    .0000000582 09273578E0 /
      DATA AE11CS(12) /    .0000000387 11426349E0 /
      DATA AE11CS(13) /   -.0000000124 53235014E0 /
      DATA AE11CS(14) /   -.0000000051 18504888E0 /
      DATA AE11CS(15) /    .0000000021 48771527E0 /
      DATA AE11CS(16) /    .0000000008 68459898E0 /
      DATA AE11CS(17) /   -.0000000003 43650105E0 /
      DATA AE11CS(18) /   -.0000000001 79796603E0 /
      DATA AE11CS(19) /    .0000000000 47442060E0 /
      DATA AE11CS(20) /    .0000000000 40423282E0 /
      DATA AE11CS(21) /   -.0000000000 03543928E0 /
      DATA AE11CS(22) /   -.0000000000 08853444E0 /
      DATA AE11CS(23) /   -.0000000000 00960151E0 /
      DATA AE11CS(24) /    .0000000000 01692921E0 /
      DATA AE11CS(25) /    .0000000000 00607990E0 /
      DATA AE11CS(26) /   -.0000000000 00224338E0 /
      DATA AE11CS(27) /   -.0000000000 00200327E0 /
      DATA AE11CS(28) /   -.0000000000 00006246E0 /
      DATA AE11CS(29) /    .0000000000 00045571E0 /
      DATA AE11CS(30) /    .0000000000 00016383E0 /
      DATA AE11CS(31) /   -.0000000000 00005561E0 /
      DATA AE11CS(32) /   -.0000000000 00006074E0 /
      DATA AE11CS(33) /   -.0000000000 00000862E0 /
      DATA AE11CS(34) /    .0000000000 00001223E0 /
      DATA AE11CS(35) /    .0000000000 00000716E0 /
      DATA AE11CS(36) /   -.0000000000 00000024E0 /
      DATA AE11CS(37) /   -.0000000000 00000201E0 /
      DATA AE11CS(38) /   -.0000000000 00000082E0 /
      DATA AE11CS(39) /    .0000000000 00000017E0 /
      DATA AE12CS( 1) /    .5824174951 3472674E0 /
      DATA AE12CS( 2) /   -.1583488509 0578275E0 /
      DATA AE12CS( 3) /   -.0067642755 90323141E0 /
      DATA AE12CS( 4) /    .0051258439 50185725E0 /
      DATA AE12CS( 5) /    .0004352324 92169391E0 /
      DATA AE12CS( 6) /   -.0001436133 66305483E0 /
      DATA AE12CS( 7) /   -.0000418013 20556301E0 /
      DATA AE12CS( 8) /   -.0000027133 95758640E0 /
      DATA AE12CS( 9) /    .0000011513 81913647E0 /
      DATA AE12CS(10) /    .0000004206 50022012E0 /
      DATA AE12CS(11) /    .0000000665 81901391E0 /
      DATA AE12CS(12) /    .0000000006 62143777E0 /
      DATA AE12CS(13) /   -.0000000028 44104870E0 /
      DATA AE12CS(14) /   -.0000000009 40724197E0 /
      DATA AE12CS(15) /   -.0000000001 77476602E0 /
      DATA AE12CS(16) /   -.0000000000 15830222E0 /
      DATA AE12CS(17) /    .0000000000 02905732E0 /
      DATA AE12CS(18) /    .0000000000 01769356E0 /
      DATA AE12CS(19) /    .0000000000 00492735E0 /
      DATA AE12CS(20) /    .0000000000 00093709E0 /
      DATA AE12CS(21) /    .0000000000 00010707E0 /
      DATA AE12CS(22) /   -.0000000000 00000537E0 /
      DATA AE12CS(23) /   -.0000000000 00000716E0 /
      DATA AE12CS(24) /   -.0000000000 00000244E0 /
      DATA AE12CS(25) /   -.0000000000 00000058E0 /
      DATA E11CS( 1) / -16.1134616555 71494026E0 /
      DATA E11CS( 2) /   7.7940727787 426802769E0 /
      DATA E11CS( 3) /  -1.9554058188 631419507E0 /
      DATA E11CS( 4) /    .3733729386 6277945612E0 /
      DATA E11CS( 5) /   -.0569250319 1092901938E0 /
      DATA E11CS( 6) /    .0072110777 6966009185E0 /
      DATA E11CS( 7) /   -.0007810490 1449841593E0 /
      DATA E11CS( 8) /    .0000738809 3356262168E0 /
      DATA E11CS( 9) /   -.0000062028 6187580820E0 /
      DATA E11CS(10) /    .0000004681 6002303176E0 /
      DATA E11CS(11) /   -.0000000320 9288853329E0 /
      DATA E11CS(12) /    .0000000020 1519974874E0 /
      DATA E11CS(13) /   -.0000000001 1673686816E0 /
      DATA E11CS(14) /    .0000000000 0627627066E0 /
      DATA E11CS(15) /   -.0000000000 0031481541E0 /
      DATA E11CS(16) /    .0000000000 0001479904E0 /
      DATA E11CS(17) /   -.0000000000 0000065457E0 /
      DATA E11CS(18) /    .0000000000 0000002733E0 /
      DATA E11CS(19) /   -.0000000000 0000000108E0 /
      DATA E12CS( 1) /  -0.0373902147 92202795E0 /
      DATA E12CS( 2) /   0.0427239860 62209577E0 /
      DATA E12CS( 3) /   -.1303182079 849700544E0 /
      DATA E12CS( 4) /    .0144191240 2469889073E0 /
      DATA E12CS( 5) /   -.0013461707 8051068022E0 /
      DATA E12CS( 6) /    .0001073102 9253063780E0 /
      DATA E12CS( 7) /   -.0000074299 9951611943E0 /
      DATA E12CS( 8) /    .0000004537 7325690753E0 /
      DATA E12CS( 9) /   -.0000000247 6417211390E0 /
      DATA E12CS(10) /    .0000000012 2076581374E0 /
      DATA E12CS(11) /   -.0000000000 5485141480E0 /
      DATA E12CS(12) /    .0000000000 0226362142E0 /
      DATA E12CS(13) /   -.0000000000 0008635897E0 /
      DATA E12CS(14) /    .0000000000 0000306291E0 /
      DATA E12CS(15) /   -.0000000000 0000010148E0 /
      DATA E12CS(16) /    .0000000000 0000000315E0 /
      DATA AE13CS( 1) /   -.6057732466 4060346E0 /
      DATA AE13CS( 2) /   -.1125352434 8366090E0 /
      DATA AE13CS( 3) /    .0134322662 47902779E0 /
      DATA AE13CS( 4) /   -.0019268451 87381145E0 /
      DATA AE13CS( 5) /    .0003091183 37720603E0 /
      DATA AE13CS( 6) /   -.0000535641 32129618E0 /
      DATA AE13CS( 7) /    .0000098278 12880247E0 /
      DATA AE13CS( 8) /   -.0000018853 68984916E0 /
      DATA AE13CS( 9) /    .0000003749 43193568E0 /
      DATA AE13CS(10) /   -.0000000768 23455870E0 /
      DATA AE13CS(11) /    .0000000161 43270567E0 /
      DATA AE13CS(12) /   -.0000000034 66802211E0 /
      DATA AE13CS(13) /    .0000000007 58754209E0 /
      DATA AE13CS(14) /   -.0000000001 68864333E0 /
      DATA AE13CS(15) /    .0000000000 38145706E0 /
      DATA AE13CS(16) /   -.0000000000 08733026E0 /
      DATA AE13CS(17) /    .0000000000 02023672E0 /
      DATA AE13CS(18) /   -.0000000000 00474132E0 /
      DATA AE13CS(19) /    .0000000000 00112211E0 /
      DATA AE13CS(20) /   -.0000000000 00026804E0 /
      DATA AE13CS(21) /    .0000000000 00006457E0 /
      DATA AE13CS(22) /   -.0000000000 00001568E0 /
      DATA AE13CS(23) /    .0000000000 00000383E0 /
      DATA AE13CS(24) /   -.0000000000 00000094E0 /
      DATA AE13CS(25) /    .0000000000 00000023E0 /
      DATA AE14CS( 1) /   -.1892918000 753017E0 /
      DATA AE14CS( 2) /   -.0864811785 5259871E0 /
      DATA AE14CS( 3) /    .0072241015 4374659E0 /
      DATA AE14CS( 4) /   -.0008097559 4575573E0 /
      DATA AE14CS( 5) /    .0001099913 4432661E0 /
      DATA AE14CS( 6) /   -.0000171733 2998937E0 /
      DATA AE14CS( 7) /    .0000029856 2751447E0 /
      DATA AE14CS( 8) /   -.0000005659 6491457E0 /
      DATA AE14CS( 9) /    .0000001152 6808397E0 /
      DATA AE14CS(10) /   -.0000000249 5030440E0 /
      DATA AE14CS(11) /    .0000000056 9232420E0 /
      DATA AE14CS(12) /   -.0000000013 5995766E0 /
      DATA AE14CS(13) /    .0000000003 3846628E0 /
      DATA AE14CS(14) /   -.0000000000 8737853E0 /
      DATA AE14CS(15) /    .0000000000 2331588E0 /
      DATA AE14CS(16) /   -.0000000000 0641148E0 /
      DATA AE14CS(17) /    .0000000000 0181224E0 /
      DATA AE14CS(18) /   -.0000000000 0052538E0 /
      DATA AE14CS(19) /    .0000000000 0015592E0 /
      DATA AE14CS(20) /   -.0000000000 0004729E0 /
      DATA AE14CS(21) /    .0000000000 0001463E0 /
      DATA AE14CS(22) /   -.0000000000 0000461E0 /
      DATA AE14CS(23) /    .0000000000 0000148E0 /
      DATA AE14CS(24) /   -.0000000000 0000048E0 /
      DATA AE14CS(25) /    .0000000000 0000016E0 /
      DATA AE14CS(26) /   -.0000000000 0000005E0 /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  E1
      IF (FIRST) THEN
         ETA = 0.1*R1MACH(3)
         NTAE11 = INITS (AE11CS, 39, ETA)
         NTAE12 = INITS (AE12CS, 25, ETA)
         NTE11 = INITS (E11CS, 19, ETA)
         NTE12 = INITS (E12CS, 16, ETA)
         NTAE13 = INITS (AE13CS, 25, ETA)
         NTAE14 = INITS (AE14CS, 26, ETA)
C
         XMAXT = -LOG (R1MACH(1))
         XMAX = XMAXT - LOG(XMAXT)
      ENDIF
      FIRST = .FALSE.
C
      IF (X.GT.(-10.)) GO TO 20
C
C E1(X) = -EI(-X) FOR X .LE. -10.
C
      E1 = EXP(-X)/X * (1.+CSEVL (20./X+1., AE11CS, NTAE11))
      RETURN
C
 20   IF (X.GT.(-4.0)) GO TO 30
C
C E1(X) = -EI(-X) FOR -10. .LT. X .LE. -4.
C
      E1 = EXP(-X)/X * (1.+CSEVL ((40./X+7.)/3., AE12CS, NTAE12))
      RETURN
C
 30   IF (X.GT.(-1.0)) GO TO 40
C
C E1(X) = -EI(-X) FOR -4. .LT. X .LE. -1.
C
      E1 = -LOG(ABS(X)) + CSEVL ((2.*X+5.)/3., E11CS, NTE11)
      RETURN
C
 40   IF (X.GT.1.) GO TO 50
      IF (X .EQ. 0.) THEN
        WRITE(ICOUT,41)
   41   FORMAT('***** ERORR FROM E1, X IS ZER0.  *******')
        CALL DPWRST('XXX','BUG ')
        E1=0.0
        RETURN
      ENDIF
C
C E1(X) = -EI(-X) FOR -1. .LT. X .LE. 1.,  X .NE. 0.
C
      E1 = (-LOG(ABS(X)) - 0.6875 + X) + CSEVL (X, E12CS, NTE12)
      RETURN
C
 50   IF (X.GT.4.) GO TO 60
C
C E1(X) = -EI(-X) FOR 1. .LT. X .LE. 4.
C
      E1 = EXP(-X)/X * (1.+CSEVL ((8./X-5.)/3., AE13CS, NTAE13))
      RETURN
C
 60   IF (X.GT.XMAX) GO TO 70
C
C E1(X) = -EI(-X) FOR 4. .LT. X .LE. XMAX
C
      E1 = EXP(-X)/X * (1. + CSEVL (8./X-1., AE14CS, NTAE14))
      RETURN
C
C E1(X) = -EI(-X) FOR X .GT. XMAX
C
 70   CONTINUE
      WRITE(ICOUT,71)
      CALL DPWRST('XXX','BUG ')
   71 FORMAT('***** WARNING FROM E1, UNDERFLOW BECAUSE THE ',
     1       'VALUE OF X IS SO LARGE.  ****')
      E1 = 0.
      RETURN
C
      END
      SUBROUTINE EA(NEWFLG,SVALUE,LIMEXP,RESULT,ABSERR,EPSTAB,IERR)
C   PART OF QAGI CODE.
C***BEGIN PROLOGUE  EA
C***DATE WRITTEN   800101  (YYMMDD)
C***REVISION DATE  871208   (YYMMDD)
C***CATEGORY NO.  E5
C***KEYWORDS  CONVERGENCE ACCELERATION,EPSILON ALGORITHM,EXTRAPOLATION
C***AUTHOR  PIESSENS, ROBERT, APPLIED MATH. AND PROGR. DIV. -
C             K. U. LEUVEN
C           DE DONCKER-KAPENGA, ELISE,WESTERN MICHIGAN UNIVERSITY
C           KAHANER, DAVID K., NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C           STARKENBURG, C. B., NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C***PURPOSE  Given a slowly convergent sequence, this routine attempts
C            to extrapolate nonlinearly to a better estimate of the
C            sequence's limiting value, thus improving the rate of
C            convergence. Routine is based on the epsilon algorithm
C            of P. Wynn. An estimate of the absolute error is also
C            given.
C     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE
C     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS
C     From the book "Numerical Methods and Software"
C          by  D. Kahaner, C. Moler, S. Nash
C               Prentice Hall 1988
C***END PROLOGUE  EA
      REAL ABSERR,DELTA1,DELTA2,DELTA3,EPRN,EPSTAB(*),
     1   ERROR,ERR1,ERR2,ERR3,E0,E1,E2,E3,RELPR,RES,RESULT,
     2   RES3LA(3),R1MACH,SS,SVALUE,TOL1,TOL2,TOL3
      INTEGER I,IB,IB2,IE,IERR,IN,K1,K2,K3,LIMEXP,N,NEWELM,NUM,NRES
      LOGICAL NEWFLG
C
      INCLUDE 'DPCOMC.INC'
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C***FIRST EXECUTABLE STATEMENT  EA
      IF(LIMEXP.LT.3) THEN
        IERR = 1
CCCCC   CALL XERROR('LIMEXP IS LESS THAN 3',21,1,1)
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,901)
  901   FORMAT('***** ERROR--NUMERICAL INTEGRATION ROUTINE EA (CALLED ',
     1         'BY QAGI ROUTINE).')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,903)
  903   FORMAT('      LIMEXP IS LESS THAN 3.')
        CALL DPWRST('XXX','BUG ')
        GO TO 110
      ENDIF
      IERR = 0
      RES3LA(1)=EPSTAB(LIMEXP+5)
      RES3LA(2)=EPSTAB(LIMEXP+6)
      RES3LA(3)=EPSTAB(LIMEXP+7)
      RESULT=SVALUE
      IF(NEWFLG) THEN
        N=1
        NRES=0
        NEWFLG=.FALSE.
        EPSTAB(N)=SVALUE
        ABSERR=ABS(RESULT)
        GO TO 100
      ELSE
        N=INT(EPSTAB(LIMEXP+3))
        NRES=INT(EPSTAB(LIMEXP+4))
        IF(N.EQ.2) THEN
          EPSTAB(N)=SVALUE
          ABSERR=.6E+01*ABS(RESULT-EPSTAB(1))
          GO TO 100
        ENDIF
      ENDIF
      EPSTAB(N)=SVALUE
      RELPR=R1MACH(4)
      EPRN=1.0E+01*RELPR
      EPSTAB(N+2)=EPSTAB(N)
      NEWELM=(N-1)/2
      NUM=N
      K1=N
      DO 40 I=1,NEWELM
        K2=K1-1
        K3=K1-2
        RES=EPSTAB(K1+2)
        E0=EPSTAB(K3)
        E1=EPSTAB(K2)
        E2=RES
        DELTA2=E2-E1
        ERR2=ABS(DELTA2)
        TOL2=MAX(ABS(E2),ABS(E1))*RELPR
        DELTA3=E1-E0
        ERR3=ABS(DELTA3)
        TOL3=MAX(ABS(E1),ABS(E0))*RELPR
        IF(ERR2.GT.TOL2.OR.ERR3.GT.TOL3) GO TO 10
C
C           IF E0, E1 AND E2 ARE EQUAL TO WITHIN MACHINE
C           ACCURACY, CONVERGENCE IS ASSUMED.
C           RESULT=E2
C           ABSERR=ABS(E1-E0)+ABS(E2-E1)
C
        RESULT=RES
        ABSERR=ERR2+ERR3
        GO TO 50
   10   IF(I.NE.1) THEN
          E3=EPSTAB(K1)
          EPSTAB(K1)=E1
          DELTA1=E1-E3
          ERR1=ABS(DELTA1)
          TOL1=MAX(ABS(E1),ABS(E3))*RELPR
C
C           IF TWO ELEMENTS ARE VERY CLOSE TO EACH OTHER, OMIT
C           A PART OF THE TABLE BY ADJUSTING THE VALUE OF N
C
          IF(ERR1.LE.TOL1.OR.ERR2.LE.TOL2.OR.ERR3.LE.TOL3) GO TO 20
          SS=0.1E+01/DELTA1+0.1E+01/DELTA2-0.1E+01/DELTA3
        ELSE
          EPSTAB(K1)=E1
          IF(ERR2.LE.TOL2.OR.ERR3.LE.TOL3) GO TO 20
          SS=0.1E+01/DELTA2-0.1E+01/DELTA3
        ENDIF
C
C           TEST TO DETECT IRREGULAR BEHAVIOUR IN THE TABLE, AND
C           EVENTUALLY OMIT A PART OF THE TABLE ADJUSTING THE VALUE
C           OF N
C
        IF(ABS(SS*E1).GT.0.1E-03) GO TO 30
   20   N=I+I-1
        IF(NRES.EQ.0) THEN
          ABSERR=ERR2+ERR3
          RESULT=RES
        ELSE IF(NRES.EQ.1) THEN
          RESULT=RES3LA(1)
        ELSE IF(NRES.EQ.2) THEN
          RESULT=RES3LA(2)
        ELSE
          RESULT=RES3LA(3)
        ENDIF
        GO TO 50
C
C           COMPUTE A NEW ELEMENT AND EVENTUALLY ADJUST
C           THE VALUE OF RESULT
C
   30   RES=E1+0.1E+01/SS
        EPSTAB(K1)=RES
        K1=K1-2
        IF(NRES.EQ.0) THEN
          ABSERR=ERR2+ABS(RES-E2)+ERR3
          RESULT=RES
          GO TO 40
        ELSE IF(NRES.EQ.1) THEN
          ERROR=.6E+01*(ABS(RES-RES3LA(1)))
        ELSE IF(NRES.EQ.2) THEN
          ERROR=.2E+01*(ABS(RES-RES3LA(2))+ABS(RES-RES3LA(1)))
        ELSE
          ERROR=ABS(RES-RES3LA(3))+ABS(RES-RES3LA(2))
     1          +ABS(RES-RES3LA(1))
        ENDIF
        IF(ERROR.GT.1.0E+01*ABSERR) GO TO 40
        ABSERR=ERROR
        RESULT=RES
   40 CONTINUE
C
C           COMPUTE ERROR ESTIMATE
C
        IF(NRES.EQ.1) THEN
          ABSERR=.6E+01*(ABS(RESULT-RES3LA(1)))
        ELSE IF(NRES.EQ.2) THEN
          ABSERR=.2E+01*ABS(RESULT-RES3LA(2))+ABS(RESULT-RES3LA(1))
        ELSE IF(NRES.GT.2) THEN
          ABSERR=ABS(RESULT-RES3LA(3))+ABS(RESULT-RES3LA(2))
     1          +ABS(RESULT-RES3LA(1))
        ENDIF
C
C           SHIFT THE TABLE
C
   50 IF(N.EQ.LIMEXP) N=2*(LIMEXP/2)-1
      IB=1
      IF((NUM/2)*2.EQ.NUM) IB=2
      IE=NEWELM+1
      DO 60 I=1,IE
        IB2=IB+2
        EPSTAB(IB)=EPSTAB(IB2)
        IB=IB2
   60 CONTINUE
      IF(NUM.EQ.N) GO TO 80
      IN=NUM-N+1
      DO 70 I=1,N
        EPSTAB(I)=EPSTAB(IN)
        IN=IN+1
   70 CONTINUE
C
C           UPDATE RES3LA
C
   80 IF(NRES.EQ.0) THEN
        RES3LA(1)=RESULT
      ELSE IF(NRES.EQ.1) THEN
        RES3LA(2)=RESULT
      ELSE IF(NRES.EQ.2) THEN
        RES3LA(3)=RESULT
      ELSE
        RES3LA(1)=RES3LA(2)
        RES3LA(2)=RES3LA(3)
        RES3LA(3)=RESULT
      ENDIF
   90 ABSERR=MAX(ABSERR,EPRN*ABS(RESULT))
      NRES=NRES+1
  100 N=N+1
*     IF(N.LE.3) ABSERR = R1MACH(2) * (0.1D-03)
      EPSTAB(LIMEXP+3)=REAL(N)
      EPSTAB(LIMEXP+4)=REAL(NRES)
      EPSTAB(LIMEXP+5)=RES3LA(1)
      EPSTAB(LIMEXP+6)=RES3LA(2)
      EPSTAB(LIMEXP+7)=RES3LA(3)
  110 RETURN
      END
      FUNCTION EI (X)
C***BEGIN PROLOGUE  EI
C***PURPOSE  Compute the exponential integral Ei(X).
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C5
C***TYPE      SINGLE PRECISION (EI-S, DEI-D)
C***KEYWORDS  EI FUNCTION, EXPONENTIAL INTEGRAL, FNLIB,
C             SPECIAL FUNCTIONS
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C EI calculates the single precision exponential integral, Ei(X), for
C positive single precision argument X and the Cauchy principal value
C for negative X.  If principal values are used everywhere, then, for
C all X,
C
C    Ei(X) = -E1(-X)
C or
C    E1(X) = -Ei(-X).
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  E1
C***REVISION HISTORY  (YYMMDD)
C   770401  DATE WRITTEN
C   891115  Modified prologue description.  (WRB)
C   891115  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  EI
C***FIRST EXECUTABLE STATEMENT  EI
      EI = -E1(-X)
C
      RETURN
      END
      SUBROUTINE EDGEF (NK,FC,GC,XX,YY,BFK,CDFX,POI,POJ,EPS3,IFLAG,L) 
C
C--- COMPUTE THE BETA C.D.F.'S BY A RECURRENCE RELATION ALONG THE EDGES
C--- I = IMIN AND J = JMIN OF A GRID.  THE CORRESPONDING COMPONENTS OF
C--- THE F" C.D.F. ARE INCLUDED IN THE SUMMATION.  TERMS WHICH MIGHT
C--- CAUSE UNDERFLOW ARE SET TO ZERO.
C
      DIMENSION BFK(*),POI(*),POJ(*)
      DOUBLE PRECISION DARG,DEUFLO,DLNGAM
      DATA DEUFLO / -30.0D0 / 
      FD = FC-1.0
      K = MAX0(L,MIN0(NK,INT((GC-1.0)*XX/YY-FD))) 
      FK = FD+REAL(K)
CCCCC CALL CDFBET (XX,FK,GC,EPS3,IFLAG,BFK(K))
      CALL BETCDF(XX,FK,GC,BFK(K))
CCCCC IF (IFLAG.NE.0) RETURN
      IF (L.EQ.1) BFK(K) = 1.0-BFK(K)
      IF (NK.EQ.1) GO TO 40
      DARG = DBLE(FK)*DLOG(DBLE(XX))+DBLE(GC)*DLOG(DBLE(YY))-
     *   DLOG(DBLE(FK))+DLNGAM(DBLE(FK+GC))-DLNGAM(DBLE(FK))-
     *   DLNGAM(DBLE(GC))
      IF (DARG.LT.DEUFLO) THEN
         DK = 0.0
      ELSE
         DK = SNGL(DEXP(DARG))*(-1.0)**L
      ENDIF
      IF (K.GE.NK) GO TO 20
      BFK(K+1) = BFK(K)-DK
      DI = DK
      KFLAG = 1
      DO 10 I = K+1, NK-1
         IF (KFLAG.EQ.1) THEN 
            DI = DI*(FD+GC+REAL(I-1))*XX/(FD+REAL(I))
            IF (DK+DI.EQ.DK) THEN
               KFLAG = 0
               DI = 0.0
            ENDIF
         ENDIF
         BFK(I+1) = BFK(I)-DI 
   10 CONTINUE
   20 DI = DK
      KFLAG = 1
      DO 30 I = K-1, L, -1
         IF (KFLAG.EQ.1) THEN 
            DI = DI*(FC+REAL(I))/((FD+GC+REAL(I))*XX)
            IF (DK+DI.EQ.DK) THEN
               KFLAG = 0
               DI = 0.0
            ENDIF
         ENDIF
         BFK(I) = BFK(I+1)+DI 
   30 CONTINUE
   40 DO 50 I = L, NK
         CDFX = CDFX+POI(I)*POJ(1)*BFK(I)
   50 CONTINUE
      RETURN
      END 
      SUBROUTINE EDGET(NK,FC,GC,XX,YY,BFK,CDFX,POI,POJ,EPS3,IFLAG,L) 
CCCCC CONVERT TO DOUBLE PRECISION.  SINGLE PRECISION GIVES INACCURATE
CCCCC RESULTS FOR 32-BIT MACHINES.
C
C--- COMPUTE THE BETA C.D.F.'S BY A RECURRENCE RELATION ALONG THE EDGES
C--- I = IMIN AND J = JMIN OF A GRID.  THE CORRESPONDING COMPONENTS OF
C--- THE T" C.D.F. ARE INCLUDED IN THE SUMMATION.  TERMS WHICH MIGHT
C--- CAUSE UNDERFLOW ARE SET TO ZERO.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DIMENSION BFK(*),POI(*),POJ(*)
CCCCC DOUBLE PRECISION DARG,DEUFLO,DLNGAM
      DATA DEUFLO / -69.0D0 / 
      FD = FC-1.0D0
      K = MAX0(L,MIN0(NK,INT((GC-1.0D0)*XX/YY-FD))) 
      FK = FD+DBLE(K)
CCCCC CALL BETCDF(SNGL(XX),SNGL(FK),SNGL(GC),ATEMP)
      BFK(K)=DBETAI(XX,FK,GC)
C
      IF (IFLAG.NE.0) RETURN
      IF (L.EQ.1) BFK(K) = 1.0D0-BFK(K)
      IF (NK.EQ.1) GO TO 40
      DARG = FK*DLOG(XX)+GC*DLOG(YY)-
     *   DLOG(FK)+DLNGAM(FK+GC)-DLNGAM(FK)-
     *   DLNGAM(GC)
      IF (DARG.LT.DEUFLO) THEN
         DK = 0.0D0
      ELSE
         DK = DEXP(DARG)*(-1.0D0)**L
      ENDIF
      IF (K.GE.NK) GO TO 20
      BFK(K+1) = BFK(K)-DK
      DI = DK
      KFLAG = 1
      DO 10 I = K+1, NK-1
         IF (KFLAG.EQ.1) THEN 
            DI = DI*(FD+GC+DBLE(I-1))*XX/(FD+DBLE(I))
            IF (DK+DI.EQ.DK) THEN
               KFLAG = 0
               DI = 0.0D0
            ENDIF
         ENDIF
         BFK(I+1) = BFK(I)-DI 
   10 CONTINUE
   20 DI = DK
      KFLAG = 1
      DO 30 I = K-1, L, -1
         IF (KFLAG.EQ.1) THEN 
            DI = DI*(FC+DBLE(I))/((FD+GC+DBLE(I))*XX)
            IF (DK+DI.EQ.DK) THEN
               KFLAG = 0
               DI = 0.0D0
            ENDIF
         ENDIF
         BFK(I) = BFK(I+1)+DI 
   30 CONTINUE
   40 DO 50 I = L, NK
         CDFX = CDFX+POI(I)*POJ(1)*BFK(I)
   50 CONTINUE
      RETURN
      END 
      SUBROUTINE EDGVER(EDGE1,EDGE2,NEDGE,Y,X,NVERT,IWRITE,
     1Y2,X2,TAG,NOUT,
     1IBUGA3,IERROR)
C
C     PURPOSE--GIVEN A LIST OF EDGES AND A SET OF ORIGINAL
C              VERTICES, GENERATE A NEW LIST OF VERTICES
C              CORRESPONDING TO THE EDGES.  NOTE THAT A
C              NUMBER OF COMBINATORIC/COMPUTATIONAL GEOMETRY
C              ALGORITHMS WORK WITH EDGES.  THIS IS A UTILITY
C              ROUTINE THAT MAKES IT EASIER TO PLOT THESE EDGES.
C     EXAMPLES--LET Y2 X2 TAG = EDGES TO VERTICES EDGE1 EDGE2 Y X
C     INPUT  ARGUMENTS--EDGE1  VECTOR IDENTIFYING FIRST VERTEX IN EDGE
C                       EDGE2  VECTOR IDENTIFYING SECOND VERTEX IN EDGE
C                       Y      Y-AXIS VECTOR
C                       X      X-AXIS VECTOR
C                       NEDGE  NUMBER OF EDGES
C                       NVERT  NUMBER OF VERTICES
C     OUTPUT ARGUMENTS--Y2     Y-AXIS VECTOR OF THE NEW VERTICES
C                       X2     X-AXIS VECTOR OF THE NEW VERTICES
C                       TAG    VECTOR IDENTIFYING PAIRS OF VERTICES
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/4
C     ORIGINAL VERSION--APRIL    2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
      DIMENSION EDGE1(*)
      DIMENSION EDGE2(*)
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION TAG(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EDGV'
      ISUBN2='ER  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF EDGVER--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,IWRITE,NEDGE,NVERT
   52   FORMAT('IBUGA3,IWRITE,NEDGE,NVERT = ',A4,2X,A4,2X,2I10)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NEDGE
          WRITE(ICOUT,56)I,EDGE1(I),EDGE2(I)
   56     FORMAT('I,EDGE1(I),EDGE2(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        DO65I=1,NVERT
          WRITE(ICOUT,66)I,Y(I),X(I)
   66     FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   65   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1: CHECK THAT VERTICES ARE IN  **
C               **          THE RANGE (1,NVERT)         **
C               ******************************************
C
      DO100I=1,NEDGE
        ITEMP1=INT(EDGE1(I)+0.01)
        IF(ITEMP1.LT.1 .OR. ITEMP1.GT.NVERT)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
  101     FORMAT('***** ERROR FROM EDGES TO VERTICES--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,103)I
  103     FORMAT('      THE FIRST VERTEX FOR EDGE ',I8,' IS LESS ',
     1           'THAN ONE')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,105)NVERT
  105     FORMAT('      OR GREATER THAN THE NUMBER OF VERTICES (',I8,
     1           ').')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
C
        ITEMP2=INT(EDGE2(I)+0.01)
        IF(ITEMP2.LT.1 .OR. ITEMP2.GT.NVERT)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,113)I
  113     FORMAT('      THE SECOND VERTEX FOR EDGE ',I8,' IS LESS THAN')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,105)NVERT
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
C
  100 CONTINUE
C
      ICNT1=0
      ICNT2=0
      DO200I=1,NEDGE
        ICNT2=ICNT2+1
        ITEMP1=INT(EDGE1(I)+0.01)
        ITEMP2=INT(EDGE2(I)+0.01)
        ICNT1=ICNT1+1
        Y2(ICNT1)=Y(ITEMP1)
        X2(ICNT1)=X(ITEMP1)
        TAG(ICNT1)=REAL(ICNT2)
        ICNT1=ICNT1+1
        Y2(ICNT1)=Y(ITEMP2)
        X2(ICNT1)=X(ITEMP2)
        TAG(ICNT1)=REAL(ICNT2)
  200 CONTINUE
C
      NOUT=ICNT1
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF EDGVER--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)NOUT
 9014   FORMAT('NOUT = ',I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NOUT
          WRITE(ICOUT,9016)I,Y2(I),X2(I),TAG(I)
 9016     FORMAT('I,Y2(I),X2(I),TAG(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE EEWCDF(X,AL,GAMMA1,SCALE1,GAMMA2,SCALE2,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE END-EFFECTS WEIBULL DISTRIBUTION.
C              THIS DISTRIBUTION IS USED IN MODELING FAILURES OF
C              CARBON FIBERS UNDER STRESS.  THE CDF IS DEFINED AS:
C
C              F(X,L,S1,G1,L2,S2,G2) =
C                 1 - EXP[-L*(X/S1)**G1 - (X/S2)**G2]
C                     X, L, S1, G1, S2, G2 > 0 
C
C             HERE, S1 AND G1 ARE THE SCALE AND SHAPE PARAMETERS
C             OF A WEIBULL DISTRIBUTION THAT MODELS "TRUE" FLAWS
C             AND S2 AND G2 ARE SCALE AND SHAPE PARAMETERS OF A
C             WEIBULL DISTRIBUTION THAT MODELS "END EFFECTS".  L
C             IS THE LENGTH OF THE FIBER (THIS SHOULD TYPICALLY BE
C             A KNOWN, FIXED VALUE).  NOTE THAT END-EFFECTS TYPICALLY
C             BECOME LESS PROMINENT AS THE FIBER LENGTH INCREASES
C             SINCE THE FIBER IS MORE LIKELY TO CONTAIN A FATAL FLAW.
C             
C     INPUT  ARGUMENTS--X      = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE NON-NEGATIVE.
C                     --AL     = FIBER LENGTH
C                     --SCALE1 = SCALE PARAMETER (FIRST PART)
C                     --GAMMA1 = SHAPE PARAMETER (FIRST PART)
C                     --SCALE2 = SCALE PARAMETER (SECOND PART)
C                     --GAMMA2 = SHAPE PARAMETER (SECOND PART)
C     OUTPUT ARGUMENTS--CDF    = THE DOUBLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE END-EFFECTS WEIBULL DISTRIBUTION
C             WITH 5 SHAPE PARAMETERS
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C                 --GAMMA1,GAMMA2,SCALE1,SCALE2,AL SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--STONER, EDIE, AND DURHAM (1994), "AN END-EFFECT MODEL
C                 FOR THE SINGLE-FILAMENT TENSILE TEST", JOURNAL OF
C                 OF MATERIALS SCIENCE, 29, PP. 6561-6574.
C               --NEWELL AND SAGENDORF (1999), "EXPERIMENTAL VERIFICATION
C                 OF THE END-EFFECT WEIBULL MODEL AS A PREDICTOR OF THE
C                 TENSILE STRENGTH OF KEVLAR-29 (POLY
C                 p-PHENYLENETEREPHTHALAMIDE) FIBRES AT DIFFERENCE GAUGE
C                 LENGTHS", HIGH PERFORMANCE POLYMERS, 11, PP. 297-305.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010.7
C     ORIGINAL VERSION--JULY      2010.
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C 
      REAL CPUMIN
      REAL CPUMAX
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      CDF=0.0D0
      IF(SCALE1.LE.0.0D0)THEN
        WRITE(ICOUT,5)
    5   FORMAT('***** ERROR--THE SCALE(1) PARAMETER FOR EEWCDF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE1
   46   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA1.LE.0.0D0)THEN
        WRITE(ICOUT,15)
   15   FORMAT('***** ERROR--THE GAMMA(1) SHAPE PARAMETER FOR EEWCDF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA1
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(SCALE2.LE.0.0D0)THEN
        WRITE(ICOUT,25)
   25   FORMAT('***** ERROR--THE SCALE(2) PARAMETER FOR EEWCDF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA2.LE.0.0D0)THEN
        WRITE(ICOUT,35)
   35   FORMAT('***** ERROR--THE GAMMA(2) SHAPE PARAMETER FOR EEWCDF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(AL.LE.0.0D0)THEN
        WRITE(ICOUT,45)
   45   FORMAT('***** ERROR--THE FIBER LENGTH PARAMETER FOR EEWCDF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)AL
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      IF(X.LE.0.0D0)THEN
        CDF=0.0D0
      ELSE
        DTERM1=-AL*(X/SCALE1)**GAMMA1
        DTERM2=(X/SCALE2)**GAMMA2
        CDF=DEXP(DTERM1 - DTERM2)
        CDF=1.0D0 - CDF
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EEWCD2(X,NX,LI,PI,NI,GAMMA1,SCALE1,GAMMA2,SCALE2,ALOC,
     1                  CDF,
     1                  ISUBRO,IBUGA2,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE END-EFFECTS WEIBULL DISTRIBUTION.
C              THIS DISTRIBUTION IS USED IN MODELING FAILURES OF
C              CARBON FIBERS UNDER STRESS.  THE CDF IS DEFINED AS:
C
C              F(X,L,S1,G1,L2,S2,G2) =
C                 1 - EXP[-L*(X/S1)**G1 - (X/S2)**G2]
C                     X, L, S1, G1, S2, G2 > 0 
C
C             HERE, S1 AND G1 ARE THE SCALE AND SHAPE PARAMETERS
C             OF A WEIBULL DISTRIBUTION THAT MODELS "TRUE" FLAWS
C             AND S2 AND G2 ARE SCALE AND SHAPE PARAMETERS OF A
C             WEIBULL DISTRIBUTION THAT MODELS "END EFFECTS".  L
C             IS THE LENGTH OF THE FIBER (THIS SHOULD TYPICALLY BE
C             A KNOWN, FIXED VALUE).  NOTE THAT END-EFFECTS TYPICALLY
C             BECOME LESS PROMINENT AS THE FIBER LENGTH INCREASES
C             SINCE THE FIBER IS MORE LIKELY TO CONTAIN A FATAL FLAW.
C
C             THE EEWCDF ROUTINE COMPUTES THIS FUNCTION FOR A SINGLE
C             VALUE OF L.  THIS ROUTINE COMPUTES THIS FUNCTION FOR
C             MULTIPLE VALUES OF L.  IT DOES THIS USING A MIXTURE
C             APPROACH.  THAT IS
C
C              F(X;L,GAMMA1,SCALE1,GAMMA2,SCALE2) = SUM[i=1 to NI]
C                  [p(i)*EEFCDF(X;L(i),GAMMA1,SCALE1,GAMMA2,SCALE2)]
C
C              WHERE NI IS THE NUMBER OF DISTINCT VALUES FOR L.
C
C              THIS ROUTINE ASSUMES THAT THE SCALE/SHAPE
C              PARAMETERS ARE FIXED (I.E., ONLY L VARIES).
C
C              CURRENTLY, WE RESTRICT L TO A MAXIMUM OF 10 DISTINCT
C              LEVELS.
C
C     INPUT  ARGUMENTS--X      = A VARIABLE CONTAINING THE VALUES AT WHICH
C                                THE CUMULATIVE DISTRIBUTION FUNCTION IS
C                                TO BE EVALUATED.
C                     --NX     = A PARAMETER THAT SPECIFIES THE NUMBER
C                                OF VALUES FOR X.
C                     --LI     = A VARIABLE CONTAINING THE GAUGE LENGTH
C                                PARAMETER L.
C                     --PI     = A VARIABLE CONTAINING THE "MIXING"
C                                PROPORTIONS FOR LI.
C                     --NI     = A PARAMETER THAT SPECIFIES THE NUMBER
C                                OF VALUES FOR LI AND PI.
C                     --GAMMA1 = SHAPE PARAMETER (FIRST PART)
C                     --SCALE1 = SCALE PARAMETER (FIRST PART)
C                     --GAMMA2 = SHAPE PARAMETER (SECOND PART)
C                     --SCALE2 = SCALE PARAMETER (SECOND PART)
C     OUTPUT ARGUMENTS--PDF    = A VARIABLE CONTAINING THE CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUES.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION FUNCTION VALUES
C             CDF FOR THE END-EFFECTS WEIBULL DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C                 --GAMMA1,GAMMA2,SCALE1,SCALE2,AL SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--EEWCDF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--STONER, EDIE, AND DURHAM (1994), "AN END-EFFECT MODEL
C                 FOR THE SINGLE-FILAMENT TENSILE TEST", JOURNAL OF
C                 OF MATERIALS SCIENCE, 29, PP. 6561-6574.
C               --NEWELL AND SAGENDORF (1999), "EXPERIMENTAL VERIFICATION
C                 OF THE END-EFFECT WEIBULL MODEL AS A PREDICTOR OF THE
C                 TENSILE STRENGTH OF KEVLAR-29 (POLY
C                 p-PHENYLENETEREPHTHALAMIDE) FIBRES AT DIFFERENCE GAUGE
C                 LENGTHS", HIGH PERFORMANCE POLYMERS, 11, PP. 297-305.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010.10
C     ORIGINAL VERSION--NOVEMBER  2010.
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION X(*)
      DOUBLE PRECISION LI(*)
      DOUBLE PRECISION PI(*)
      DOUBLE PRECISION CDF(*)
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA2
      CHARACTER*4 IERROR
C
      REAL CPUMIN
      REAL CPUMAX
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(NX.LT.1)THEN
        WRITE(ICOUT,1)
    1   FORMAT('***** ERROR IN END EFFECTS WEIBULL CDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3)
    3   FORMAT('      THE NUMBER OF REQUESTED CDF VALUES IS ',
     1         'NON-POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3)NX
    5   FORMAT('      THE NUMBER OF REQUESTED CDF VALUES  = ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(NI.LT.1)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,13)
   13   FORMAT('      THE NUMBER OF DISTINCT GAUGE LENGTH (L) VALUES ',
     1         'IS NON-POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,15)NI
   15   FORMAT('      THE NUMBER OF REQUESTED L VALUES  = ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(NI.GT.10)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,18)
   18   FORMAT('      THE NUMBER OF DISTINCT GAUGE LENGTH (L) VALUES ',
     1         'IS GREATER THAN 10.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,15)NI
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(SCALE1.LE.0.0D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,21)
   21   FORMAT('      THE SCALE(1) PARAMETER IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE1
   46   FORMAT('      THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA1.LE.0.0D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,23)
   23   FORMAT('      THE GAMMA(1) SHAPE PARAMETER IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA1
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(SCALE2.LE.0.0D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,25)
   25   FORMAT('      THE SCALE(2) PARAMETER IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA2.LE.0.0D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,27)
   27   FORMAT('      THE GAMMA(2) SHAPE PARAMETER IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      DSUM1=0.0D0
      DO60I=1,NI
        IF(LI(I).LE.0.0D0)THEN
          WRITE(ICOUT,1)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,62)I
   62     FORMAT('      FOR ROW ',I8,' THE VALUE OF THE GAUGE LENGTH ',
     1           'ARGUMENT (L) IS NON-POSITIVE.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,64)LI(I)
   64     FORMAT('      THE VALUE OF L(I)  = ',G15.7)
          CALL DPWRST('XXX','BUG ')
          GOTO9000
          IERROR='YES'
        ELSEIF(PI(I).LE.0.0D0 .OR. PI(I).GT.1.0D0)THEN
          WRITE(ICOUT,1)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,67)I
   67     FORMAT('      FOR ROW ',I8,' THE VALUE OF THE MIXING ',
     1           'ARGUMENT (P)')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,68)
   68     FORMAT('      IS OUTSIDE THE (0,1) INTERVAL).')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,69)PI(I)
   69     FORMAT('      THE VALUE OF P(I)  = ',G15.7)
          CALL DPWRST('XXX','BUG ')
          GOTO9000
          IERROR='YES'
        ENDIF
        DSUM1=DSUM1 + PI(I)
   60 CONTINUE
C
C     CHECK THAT MIXING PROPORTIONS SUM TO 1
C
      IF(ABS(DSUM1 - 1.0D0).GT.0.000001D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,63)
   63   FORMAT('      THE MIXING PROPORTIONS DO NOT SUM TO ONE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,65)REAL(DSUM1)
   65   FORMAT('      THE SUM OF THE MIXING PROPORTIONS  = ',G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C     NOW COMPUTE THE CDF BY SUMMING OVER THE L(I) CASES
C
      DO100I=1,NX
        IF(X(I).LE.ALOC)THEN
          CDF(I)=0.0D0
          GOTO100
        ENDIF
        DSUM1=0.0D0
        DO200J=1,NI
          DTERM1=X(I)-ALOC
          CALL EEWCDF(DTERM1,LI(J),GAMMA1,SCALE1,GAMMA2,SCALE2,DTERM2)
          DSUM1=DSUM1 + PI(J)*DTERM2
  200   CONTINUE
        CDF(I)=DSUM1
  100 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EEWPDF(X,AL,GAMMA1,SCALE1,GAMMA2,SCALE2,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILUITY DENSITY
C              FUNCTION VALUE FOR THE END-EFFECTS WEIBULL DISTRIBUTION.
C              THIS DISTRIBUTION IS USED IN MODELING FAILURES OF
C              CARBON FIBERS UNDER STRESS.  THE PDF IS DEFINED AS:
C
C              f(X,L,S1,G1,L2,S2,G2) =
C                 [L*G1*X**(G1-1)/S1**G1 + G2*X**(G2-1)/S2**G2]*
C                 EXP[-L*(X/S1)**G1 - (X/S2)**G2]
C                 X, L, S1, G1, S2, G2 > 0 
C
C             HERE, S1 AND G1 ARE THE SCALE AND SHAPE PARAMETERS
C             OF A WEIBULL DISTRIBUTION THAT MODELS "TRUE" FLAWS
C             AND S2 AND G2 ARE SCALE AND SHAPE PARAMETERS OF A
C             WEIBULL DISTRIBUTION THAT MODELS "END EFFECTS".  L
C             IS THE LENGTH OF THE FIBER (THIS SHOULD TYPICALLY BE
C             A KNOWN, FIXED VALUE).  NOTE THAT END-EFFECTS TYPICALLY
C             BECOME LESS PROMINENT AS THE FIBER LENGTH INCREASES
C             SINCE THE FIBER IS MORE LIKELY TO CONTAIN A FATAL FLAW.
C             
C     INPUT  ARGUMENTS--X      = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE NON-NEGATIVE.
C                     --AL     = FIBER LENGTH
C                     --SCALE1 = SCALE PARAMETER (FIRST PART)
C                     --GAMMA1 = SHAPE PARAMETER (FIRST PART)
C                     --SCALE2 = SCALE PARAMETER (SECOND PART)
C                     --GAMMA2 = SHAPE PARAMETER (SECOND PART)
C     OUTPUT ARGUMENTS--PDF    = THE DOUBLE PRECISION PROBABILITY DENSITY
C                                FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PROBABILITY DENSITY FUNCTION VALUE PDF
C             FOR THE END-EFFECTS WEIBULL DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C                 --GAMMA1,GAMMA2,SCALE1,SCALE2,AL SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--STONER, EDIE, AND DURHAM (1994), "AN END-EFFECT MODEL
C                 FOR THE SINGLE-FILAMENT TENSILE TEST", JOURNAL OF
C                 OF MATERIALS SCIENCE, 29, PP. 6561-6574.
C               --NEWELL AND SAGENDORF (1999), "EXPERIMENTAL VERIFICATION
C                 OF THE END-EFFECT WEIBULL MODEL AS A PREDICTOR OF THE
C                 TENSILE STRENGTH OF KEVLAR-29 (POLY
C                 p-PHENYLENETEREPHTHALAMIDE) FIBRES AT DIFFERENCE GAUGE
C                 LENGTHS", HIGH PERFORMANCE POLYMERS, 11, PP. 297-305.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010.7
C     ORIGINAL VERSION--JULY      2010.
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C 
      REAL CPUMIN
      REAL CPUMAX
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      PDF=0.0D0
      IF(X.LE.0.0D0)THEN
        WRITE(ICOUT,55)
   55   FORMAT('***** ERROR--THE FIRST ARGUMENT TO EEWPDF IS ',
     1         'NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(SCALE1.LE.0.0D0)THEN
        WRITE(ICOUT,5)
    5   FORMAT('***** ERROR--THE SCALE(1) PARAMETER FOR EEWPDF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE1
   46   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA1.LE.0.0D0)THEN
        WRITE(ICOUT,15)
   15   FORMAT('***** ERROR--THE GAMMA(1) SHAPE PARAMETER FOR EEWPDF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA1
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(SCALE2.LE.0.0D0)THEN
        WRITE(ICOUT,25)
   25   FORMAT('***** ERROR--THE SCALE(2) PARAMETER FOR EEWPDF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA2.LE.0.0D0)THEN
        WRITE(ICOUT,35)
   35   FORMAT('***** ERROR--THE GAMMA(2) SHAPE PARAMETER FOR EEWPDF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(AL.LE.0.0D0)THEN
        WRITE(ICOUT,45)
   45   FORMAT('***** ERROR--THE FIBER LENGTH PARAMETER FOR EEWPDF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)AL
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      DTERM1=AL*GAMMA1*(X**(GAMMA1-1.0D0))/(SCALE1**GAMMA1)
      DTERM2=GAMMA2*(X**(GAMMA2-1.0D0))/(SCALE2**GAMMA2)
      DTERM3=-AL*(X/SCALE1)**GAMMA1
      DTERM4=(X/SCALE2)**GAMMA2
      PDF=(DTERM1 + DTERM2)*DEXP(DTERM3 - DTERM4)
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EEWPD2(X,NX,LI,PI,NI,GAMMA1,SCALE1,GAMMA2,SCALE2,ALOC,
     1                  PDF,
     1                  ISUBRO,IBUGA2,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILUITY DENSITY
C              FUNCTION VALUE FOR THE END-EFFECTS WEIBULL DISTRIBUTION.
C              THIS DISTRIBUTION IS USED IN MODELING FAILURES OF
C              CARBON FIBERS UNDER STRESS.  THE PDF IS DEFINED AS:
C
C              f(X,L,S1,G1,L2,S2,G2) =
C                 [L*G1*X**(G1-1)/S1**G1 + G2*X**(G2-1)/S2**G2]*
C                 EXP[-L*(X/S1)**G1 - (X/S2)**G2]
C                 X, L, S1, G1, S2, G2 > 0 
C
C             HERE, S1 AND G1 ARE THE SCALE AND SHAPE PARAMETERS
C             OF A WEIBULL DISTRIBUTION THAT MODELS "TRUE" FLAWS
C             AND S2 AND G2 ARE SCALE AND SHAPE PARAMETERS OF A
C             WEIBULL DISTRIBUTION THAT MODELS "END EFFECTS".  L
C             IS THE LENGTH OF THE FIBER (THIS SHOULD TYPICALLY BE
C             A KNOWN, FIXED VALUE).  NOTE THAT END-EFFECTS TYPICALLY
C             BECOME LESS PROMINENT AS THE FIBER LENGTH INCREASES
C             SINCE THE FIBER IS MORE LIKELY TO CONTAIN A FATAL FLAW.
C
C             THE EEWPDF ROUTINE COMPUTES THIS FUNCTION FOR A SINGLE
C             VALUE OF L.  THIS ROUTINE COMPUTES THIS FUNCTION FOR
C             MULTIPLE VALUES OF L.  IT DOES THIS USING A MIXTURE
C             APPROACH.  THAT IS
C
C              f(X;L,GAMMA1,SCALE1,GAMMA2,SCALE2) = SUM[i=1 to NI]
C                  [p(i)*EEFPDF(X;L(i),GAMMA1,SCALE1,GAMMA2,SCALE2)]
C
C              WHERE NI IS THE NUMBER OF DISTINCT VALUES FOR L.
C
C              THIS ROUTINE ASSUMES THAT THE SCALE/SHAPE
C              PARAMETERS ARE FIXED (I.E., ONLY L VARIES).
C
C              CURRENTLY, WE RESTRICT L TO A MAXIMUM OF 10 DISTINCT
C              LEVELS.
C
C     INPUT  ARGUMENTS--X      = A VARIABLE CONTAINING THE VALUES AT WHICH
C                                THE PROBABILITY DENSITY FUNCTION IS TO
C                                BE EVALUATED.
C                     --NX     = A PARAMETER THAT SPECIFIES THE NUMBER
C                                OF VALUES FOR X.
C                     --LI     = A VARIABLE CONTAINING THE GAUGE LENGTH
C                                PARAMETER L.
C                     --PI     = A VARIABLE CONTAINING THE "MIXING"
C                                PROPORTIONS FOR LI.
C                     --NI     = A PARAMETER THAT SPECIFIES THE NUMBER
C                                OF VALUES FOR LI AND PI.
C                     --GAMMA1 = SHAPE PARAMETER (FIRST PART)
C                     --SCALE1 = SCALE PARAMETER (FIRST PART)
C                     --GAMMA2 = SHAPE PARAMETER (SECOND PART)
C                     --SCALE2 = SCALE PARAMETER (SECOND PART)
C     OUTPUT ARGUMENTS--PDF    = A VARIABLE CONTAINING THE PROBABILITY
C                                DENSITY FUNCTION VALUES.
C     OUTPUT--THE DOUBLE PRECISION PROBABILITY DENSITY FUNCTION VALUE PDF
C             FOR THE END-EFFECTS WEIBULL DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C                 --GAMMA1,GAMMA2,SCALE1,SCALE2,AL SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--EEWPDF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--STONER, EDIE, AND DURHAM (1994), "AN END-EFFECT MODEL
C                 FOR THE SINGLE-FILAMENT TENSILE TEST", JOURNAL OF
C                 OF MATERIALS SCIENCE, 29, PP. 6561-6574.
C               --NEWELL AND SAGENDORF (1999), "EXPERIMENTAL VERIFICATION
C                 OF THE END-EFFECT WEIBULL MODEL AS A PREDICTOR OF THE
C                 TENSILE STRENGTH OF KEVLAR-29 (POLY
C                 p-PHENYLENETEREPHTHALAMIDE) FIBRES AT DIFFERENCE GAUGE
C                 LENGTHS", HIGH PERFORMANCE POLYMERS, 11, PP. 297-305.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010.10
C     ORIGINAL VERSION--NOVEMBER  2010.
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION X(*)
      DOUBLE PRECISION LI(*)
      DOUBLE PRECISION PI(*)
      DOUBLE PRECISION PDF(*)
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA2
      CHARACTER*4 IERROR
C
      REAL CPUMIN
      REAL CPUMAX
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(NX.LT.1)THEN
        WRITE(ICOUT,1)
    1   FORMAT('***** ERROR IN END EFFECTS WEIBULL PDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3)
    3   FORMAT('      THE NUMBER OF REQUESTED PDF VALUES IS ',
     1         'NON-POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3)NX
    5   FORMAT('      THE NUMBER OF REQUESTED PDF VALUES  = ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(NI.LT.1)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,13)
   13   FORMAT('      THE NUMBER OF DISTINCT GAUGE LENGTH (L) VALUES ',
     1         'IS NON-POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,15)NI
   15   FORMAT('      THE NUMBER OF REQUESTED L VALUES  = ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(NI.GT.10)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,18)
   18   FORMAT('      THE NUMBER OF DISTINCT GAUGE LENGTH (L) VALUES ',
     1         'IS GREATER THAN 10.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,15)NI
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(SCALE1.LE.0.0D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,21)
   21   FORMAT('      THE SCALE(1) PARAMETER IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE1
   46   FORMAT('      THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA1.LE.0.0D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,23)
   23   FORMAT('      THE GAMMA(1) SHAPE PARAMETER IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA1
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(SCALE2.LE.0.0D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,25)
   25   FORMAT('      THE SCALE(2) PARAMETER IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA2.LE.0.0D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,27)
   27   FORMAT('      THE GAMMA(2) SHAPE PARAMETER IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      DO50I=1,NX
        IF(X(I).LE.ALOC)THEN
          WRITE(ICOUT,1)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,55)I
   55     FORMAT('      FOR ROW ',I8,' THE VALUE OF THE INPUT ',
     1           'ARGUMENT IS')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,56)
   56     FORMAT('      LESS THAN OR EQUAL TO THE VALUE OF THE ',
     1           'LOCATION PARAMETER')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,58)X(I)
   58     FORMAT('      THE VALUE OF X(I)                    = ',G15.7)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,59)ALOC
   59     FORMAT('      THE VALUE OF THE LOCATION PARAMETER  = ',G15.7)
          CALL DPWRST('XXX','BUG ')
          GOTO9000
          IERROR='YES'
        ENDIF
   50 CONTINUE
C
      DSUM1=0.0D0
      DO60I=1,NI
        IF(LI(I).LE.0.0D0)THEN
          WRITE(ICOUT,1)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,62)I
   62     FORMAT('      FOR ROW ',I8,' THE VALUE OF THE GAUGE LENGTH ',
     1           'ARGUMENT (L) IS NON-POSITIVE.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,64)LI(I)
   64     FORMAT('      THE VALUE OF L(I)  = ',G15.7)
          CALL DPWRST('XXX','BUG ')
          GOTO9000
          IERROR='YES'
        ELSEIF(PI(I).LE.0.0D0 .OR. PI(I).GT.1.0D0)THEN
          WRITE(ICOUT,1)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,67)I
   67     FORMAT('      FOR ROW ',I8,' THE VALUE OF THE MIXING ',
     1           'ARGUMENT (P)')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,68)
   68     FORMAT('      IS OUTSIDE THE (0,1) INTERVAL).')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,69)PI(I)
   69     FORMAT('      THE VALUE OF P(I)  = ',G15.7)
          CALL DPWRST('XXX','BUG ')
          GOTO9000
          IERROR='YES'
        ENDIF
        DSUM1=DSUM1 + PI(I)
   60 CONTINUE
C
C     CHECK THAT MIXING PROPORTIONS SUM TO 1
C
      IF(ABS(DSUM1 - 1.0D0).GT.0.000001D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,63)
   63   FORMAT('      THE MIXING PROPORTIONS DO NOT SUM TO ONE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,65)REAL(DSUM1)
   65   FORMAT('      THE SUM OF THE MIXING PROPORTIONS  = ',G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C     NOW COMPUTE THE PDF BY SUMMING OVER THE L(I) CASES
C
      DO100I=1,NX
        DSUM1=0.0D0
        DO200J=1,NI
          DTERM1=X(I)-ALOC
          CALL EEWPDF(DTERM1,LI(J),GAMMA1,SCALE1,GAMMA2,SCALE2,DTERM2)
          DSUM1=DSUM1 + PI(J)*DTERM2
  200   CONTINUE
        PDF(I)=DSUM1
  100 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EEWPPF(P,AL,GAMMA1,SCALE1,GAMMA2,SCALE2,PPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE END-EFFECTS WEIBULL DISTRIBUTION.
C              THIS DISTRIBUTION IS USED IN MODELING FAILURES OF
C              CARBON FIBERS UNDER STRESS.  THE CDF IS DEFINED AS:
C
C              F(X,L,S1,G1,L2,S2,G2) =
C                 1 - EXP[-L*(X/S1)**G1 - (X/S2)**G2]
C                     X, L, S1, G1, S2, G2 > 0 
C
C             HERE, S1 AND G1 ARE THE SCALE AND SHAPE PARAMETERS
C             OF A WEIBULL DISTRIBUTION THAT MODELS "TRUE" FLAWS
C             AND S2 AND G2 ARE SCALE AND SHAPE PARAMETERS OF A
C             WEIBULL DISTRIBUTION THAT MODELS "END EFFECTS".  L
C             IS THE LENGTH OF THE FIBER (THIS SHOULD TYPICALLY BE
C             A KNOWN, FIXED VALUE).  NOTE THAT END-EFFECTS TYPICALLY
C             BECOME LESS PROMINENT AS THE FIBER LENGTH INCREASES
C             SINCE THE FIBER IS MORE LIKELY TO CONTAIN A FATAL FLAW.
C
C             THE PERCENT POINT FUNCTION IS COMPUTED BY NUMERICALLY
C             INVERTING THE CDF FUNCTION.
C
C     INPUT  ARGUMENTS--P      = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE PERCENT POINT
C                                FUNCTION IS TO BE EVALUATED.
C                     --AL     = FIBER LENGTH
C                     --SCALE1 = SCALE PARAMETER (FIRST PART)
C                     --GAMMA1 = SHAPE PARAMETER (FIRST PART)
C                     --SCALE2 = SCALE PARAMETER (SECOND PART)
C                     --GAMMA2 = SHAPE PARAMETER (SECOND PART)
C     OUTPUT ARGUMENTS--CDF    = THE DOUBLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE END-EFFECTS WEIBULL DISTRIBUTION
C             WITH 5 SHAPE PARAMETERS
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C                 --GAMMA1,GAMMA2,SCALE1,SCALE2,AL SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--STONER, EDIE, AND DURHAM (1994), "AN END-EFFECT MODEL
C                 FOR THE SINGLE-FILAMENT TENSILE TEST", JOURNAL OF
C                 OF MATERIALS SCIENCE, 29, PP. 6561-6574.
C               --NEWELL AND SAGENDORF (1999), "EXPERIMENTAL VERIFICATION
C                 OF THE END-EFFECT WEIBULL MODEL AS A PREDICTOR OF THE
C                 TENSILE STRENGTH OF KEVLAR-29 (POLY
C                 p-PHENYLENETEREPHTHALAMIDE) FIBRES AT DIFFERENCE GAUGE
C                 LENGTHS", HIGH PERFORMANCE POLYMERS, 11, PP. 297-305.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010.7
C     ORIGINAL VERSION--JULY      2010.
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C 
      REAL CPUMIN
      REAL CPUMAX
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA DEPS /0.000000001/
      DATA DSIG /1.0D-9/
      DATA MAXIT /2000/
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      PPF=0.0D0
      IF(P.LT.0.0D0 .OR. P.GE.1.0D0)THEN
        WRITE(ICOUT,55)
   55   FORMAT('***** ERROR--THE FIRST ARGUMENT TO EEWPPF IS OUTSIDE ',
     1         'THE (0,1) INTERVAL')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(SCALE1.LE.0.0D0)THEN
        WRITE(ICOUT,5)
    5   FORMAT('***** ERROR--THE SCALE(1) PARAMETER FOR EEWPPF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE1
   46   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA1.LE.0.0D0)THEN
        WRITE(ICOUT,15)
   15   FORMAT('***** ERROR--THE GAMMA(1) SHAPE PARAMETER FOR EEWPPF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA1
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(SCALE2.LE.0.0D0)THEN
        WRITE(ICOUT,25)
   25   FORMAT('***** ERROR--THE SCALE(2) PARAMETER FOR EEWPPF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA2.LE.0.0D0)THEN
        WRITE(ICOUT,35)
   35   FORMAT('***** ERROR--THE GAMMA(2) SHAPE PARAMETER FOR EEWPPF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(AL.LE.0.0D0)THEN
        WRITE(ICOUT,45)
   45   FORMAT('***** ERROR--THE FIBER LENGTH PARAMETER FOR EEWPPF ',
     1         'IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)AL
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      IF(P.LE.0.0D0)THEN
        PPF=0.0D0
        GOTO9000
      ENDIF
C
C     COMPUTE PPF NUMERICALLY
C
C
C     FIND BRACKETING INTERVAL.
C
      DXL=0.0D0
      DXINC=MAX(SCALE1,SCALE2)
      IF(DXINC.LT.1.0D0)DXINC=1.0D0
      ICOUNT=0
      MAXCNT=10000
C
   91 CONTINUE
      DXR=DXL+DXINC
      IF(DXL.LE.0.0D0)DXL=0.0D0
      IF(DXR.LE.0.0D0)DXR=DXL+DXINC
      CALL EEWCDF(DXL,AL,GAMMA1,SCALE1,GAMMA2,SCALE2,CDFL)
      CALL EEWCDF(DXR,AL,GAMMA1,SCALE1,GAMMA2,SCALE2,CDFR)
      IF(CDFL.LT.P .AND. CDFR.LT.P)THEN
        DXL=DXR
      ELSEIF(CDFL.GT.P .AND. CDFR.GT.P)THEN
        DXL=DXL-DXINC
      ELSE
        GOTO99
      ENDIF
      ICOUNT=ICOUNT+1
      IF(ICOUNT.GT.MAXCNT)THEN
        WRITE(ICOUT,96)
        CALL DPWRST('XXX','BUG ')
        PPF=0.0D0
        GOTO9000
      ENDIF
   96 FORMAT('***** ERROR--EEWPPF UNABLE TO FIND BRACKETING INTERVAL')
      GOTO91
C
C  BISECTION METHOD
C
   99 CONTINUE
      IC = 0
      DFXL = -P
      DFXR = 1.0D0 - P
  105 CONTINUE
      DX = (DXL+DXR)*0.5D0
      CALL EEWCDF(DX,AL,GAMMA1,SCALE1,GAMMA2,SCALE2,DCDF)
      DP1=DCDF
      DPPF=DX
      PPF=DPPF
      DFCS = DP1 - P
      IF(DFCS*DFXL.GT.0.0D0)GOTO110
      DXR = DX
      DFXR = DFCS 
      GOTO115
  110 CONTINUE
      DXL = DX
      DFXL = DFCS
  115 CONTINUE
      DXRML = DXR - DXL
      IF(DXRML.LE.DSIG .AND. DABS(DFCS).LE.DEPS)GOTO9000
      IC = IC + 1
      IF(IC.LE.MAXIT)GOTO105
      WRITE(ICOUT,130)
      CALL DPWRST('XXX','BUG ')
  130 FORMAT('***** ERROR--EEWPPF ROUTINE DID NOT CONVERGE. ***')
      GOTO9000
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EEWPP2(P,NX,LI,PI,NI,GAMMA1,SCALE1,GAMMA2,SCALE2,ALOC,
     1                  PPF,
     1                  ISUBRO,IBUGA2,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE END EFFECTS WEIBULL
C              DISTRIBUTION.
C
C              THE EEWPPF ROUTINE COMPUTES THIS FUNCTION FOR A SINGLE
C              VALUE OF L.  THIS ROUTINE COMPUTES THIS FUNCTION FOR
C              MULTIPLE VALUES OF L.  IT DOES THIS USING A MIXTURE
C              APPROACH.  EEWPP2 COMPUTES THE PPF FUNCTION BY
C              NUMERICALLY INVERTING THE CUMULATIVE DISTRIBUTION
C              FUNCTION.
C
C              THIS ROUTINE ASSUMES THAT THE LOCATION/SCALE/SHAPE
C              PARAMETERS ARE FIXED (I.E., ONLY L VARIES).
C
C              CURRENTLY, WE RESTRICT L TO A MAXIMUM OF 10 DISTINCT
C              LEVELS.
C
C     INPUT  ARGUMENTS--P      = A VARIABLE CONTAINING THE VALUES AT WHICH
C                                THE PERCENT POINT FUNCTION IS
C                                TO BE EVALUATED.
C                     --NX     = A PARAMETER THAT SPECIFIES THE NUMBER
C                                OF VALUES FOR P.
C                     --LI     = A VARIABLE CONTAINING THE GAUGE LENGTH
C                                PARAMETER L.
C                     --PI     = A VARIABLE CONTAINING THE "MIXING"
C                                PROPORTIONS FOR LI.
C                     --NI     = A PARAMETER THAT SPECIFIES THE NUMBER
C                                OF VALUES FOR LI AND PI.
C                     --GAMMA1 = SHAPE PARAMETER (FIRST PART)
C                     --SCALE1 = SCALE PARAMETER (FIRST PART)
C                     --GAMMA2 = SHAPE PARAMETER (SECOND PART)
C                     --SCALE2 = SCALE PARAMETER (SECOND PART)
C     OUTPUT ARGUMENTS--PPF    = A VARIABLE CONTAINING THE PERCENT POINT
C                                FUNCTION VALUES.
C     OUTPUT--THE DOUBLE PRECISION PERCENT POINT FUNCTION VALUES.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     OTHER DATAPAC   SUBROUTINES NEEDED--EEWCD2.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--STONER, EDIE, AND DURHAM (1994), "AN END-EFFECT MODEL
C                 FOR THE SINGLE-FILAMENT TENSILE TEST", JOURNAL OF
C                 OF MATERIALS SCIENCE, 29, PP. 6561-6574.
C               --NEWELL AND SAGENDORF (1999), "EXPERIMENTAL VERIFICATION
C                 OF THE END-EFFECT WEIBULL MODEL AS A PREDICTOR OF THE
C                 TENSILE STRENGTH OF KEVLAR-29 (POLY
C                 p-PHENYLENETEREPHTHALAMIDE) FIBRES AT DIFFERENCE GAUGE
C                 LENGTHS", HIGH PERFORMANCE POLYMERS, 11, PP. 297-305.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010.11
C     ORIGINAL VERSION--NOVEMBER  2010.
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION P(*)
      DOUBLE PRECISION LI(*)
      DOUBLE PRECISION PI(*)
      DOUBLE PRECISION PPF(*)
C
      DOUBLE PRECISION DCDF(1)
      DOUBLE PRECISION DX(1)
C
      DOUBLE PRECISION LMIN
      DOUBLE PRECISION LMAX
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA2
      CHARACTER*4 IERROR
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      REAL CPUMIN
      REAL CPUMAX
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA DEPS /1.0D-14/
      DATA DSIG /1.0D-14/
      DATA MAXIT /1000/
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(NX.LT.1)THEN
        WRITE(ICOUT,1)
    1   FORMAT('***** ERROR IN END EFFECTS WEIBULL PPF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3)
    3   FORMAT('      THE NUMBER OF REQUESTED PPF VALUES IS ',
     1         'NON-POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3)NX
    5   FORMAT('      THE NUMBER OF REQUESTED PPF VALUES  = ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(NI.LT.1)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,13)
   13   FORMAT('      THE NUMBER OF DISTINCT GAUGE LENGTH (L) VALUES ',
     1         'IS NON-POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,15)NI
   15   FORMAT('      THE NUMBER OF REQUESTED L VALUES  = ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(NI.GT.10)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,18)
   18   FORMAT('      THE NUMBER OF DISTINCT GAUGE LENGTH (L) VALUES ',
     1         'IS GREATER THAN 10.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,15)NI
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(SCALE1.LE.0.0D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,21)
   21   FORMAT('      THE SCALE(1) PARAMETER IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE1
   46   FORMAT('      THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA1.LE.0.0D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,23)
   23   FORMAT('      THE GAMMA(1) SHAPE PARAMETER IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA1
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(SCALE2.LE.0.0D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,25)
   25   FORMAT('      THE SCALE(2) PARAMETER IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA2.LE.0.0D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,27)
   27   FORMAT('      THE GAMMA(2) SHAPE PARAMETER IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      DSUM1=0.0D0
      DO50I=1,NI
        IF(LI(I).LE.0.0D0)THEN
          WRITE(ICOUT,1)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,52)I
   52     FORMAT('      FOR ROW ',I8,' THE VALUE OF THE GAUGE LENGTH ',
     1           'ARGUMENT (L) IS NON-POSITIVE.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,54)LI(I)
   54     FORMAT('      THE VALUE OF L(I)  = ',G15.7)
          CALL DPWRST('XXX','BUG ')
          GOTO9000
          IERROR='YES'
        ELSEIF(PI(I).LE.0.0D0 .OR. PI(I).GT.1.0D0)THEN
          WRITE(ICOUT,1)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,57)I
   57     FORMAT('      FOR ROW ',I8,' THE VALUE OF THE MIXING ',
     1           'ARGUMENT (P)')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,58)
   58     FORMAT('      OUTSIDE THE (0,1) INTERVAL).')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,59)PI(I)
   59     FORMAT('      THE VALUE OF P(I)  = ',G15.7)
          CALL DPWRST('XXX','BUG ')
          GOTO9000
          IERROR='YES'
        ENDIF
        DSUM1=DSUM1 + PI(I)
   50 CONTINUE
C
C     CHECK THAT MIXING PROPORTIONS SUM TO 1
C
      IF(ABS(DSUM1 - 1.0D0).GT.0.000001D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,63)
   63   FORMAT('      THE MIXING PROPORTIONS DO NOT SUM TO ONE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,65)REAL(DSUM1)
   65   FORMAT('      THE SUM OF THE MIXING PROPORTIONS  = ',G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C     NOW COMPUTE THE PPF BY NUMERICALLY INVERTING THE CDF FUNCTION
C
      NTEMP=1
      LMIN=LI(1)
      LMAX=LI(1)
      DO90I=1,NI
        IF(LI(I).LT.LMIN)LMIN=LI(I)
        IF(LI(I).GT.LMAX)LMAX=LI(I)
   90 CONTINUE
C
      DO100I=1,NX
        DP=P(I)
C
        IF(DP.LT.0.0D0 .OR. DP.GE.1.0D0)THEN
          WRITE(ICOUT,1)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,105)I
  105     FORMAT('      FOR ROW ',I8,' THE PROBABILITY PARAMETER (P) ',
     1           'IS OUTSIDE THE (0,1) INTERVAL.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,106)DP
  106     FORMAT('      THE VALUE OF P  = ',G15.7)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ELSEIF(1.0D0 - DP.LE.0.0D0)THEN
          WRITE(ICOUT,1)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,108)I
  108     FORMAT('      FOR ROW ',I8,' THE PROBABILITY PARAMETER (P) ',
     1           'IS TOO CLOSE TO 1 TO COMPUTE.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,106)DP
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
        IF(DP.EQ.0.0D0)THEN
          PPF(I)=ALOC
          GOTO100
        ENDIF
C
C       STEP 1: FIND BRACKETING INTERVAL
C
        CALL EEWPPF(DP,LMIN,GAMMA1,SCALE1,GAMMA2,SCALE2,DTERM1)
        DTERM1=ALOC + DTERM1
        CALL EEWPPF(DP,LMAX,GAMMA1,SCALE1,GAMMA2,SCALE2,DTERM2)
        DTERM2=ALOC + DTERM2
        DXL=MIN(DTERM1,DTERM2)
        DXR=MAX(DTERM1,DTERM2)
        IF(DXL.EQ.DXR)THEN
          PPF(I)=DXL
          GOTO100
        ENDIF
        NTEMP=1
        DX(1)=DXL
        CALL EEWCD2(DX,NTEMP,LI,PI,NI,GAMMA1,SCALE1,GAMMA2,SCALE2,ALOC,
     1              DCDF,
     1              ISUBRO,IBUGA2,IERROR)
        DCDFL=DCDF(1)
        DX(1)=DXR
        CALL EEWCD2(DX,NTEMP,LI,PI,NI,GAMMA1,SCALE1,GAMMA2,SCALE2,ALOC,
     1              DCDF,
     1              ISUBRO,IBUGA2,IERROR)
        DCDFR=DCDF(1)
C
        IF(DCDFL.LT.DP .AND. DCDFR.LT.DP)THEN
          PPF(I)=CPUMIN
          GOTO100
        ELSEIF(DCDFL.GT.DP .AND. DCDFR.GT.DP)THEN
          PPF(I)=CPUMIN
          GOTO100
        ENDIF
C
C       STEP 2: BISECTION METHOD
C
  299   CONTINUE
        IC = 0
        DFXL = -DP
        DFXR = 1.0D0 - DP
  205   CONTINUE
        DX(1)=(DXL+DXR)*0.5D0
        CALL EEWCD2(DX,NTEMP,LI,PI,NI,GAMMA1,SCALE1,GAMMA2,SCALE2,ALOC,
     1              DCDF,
     1              ISUBRO,IBUGA2,IERROR)
        DP1=DCDF(1)
        DPPF=DX(1)
        DFCS = DP1 - DP
C
        IF(DFCS*DFXL.GT.0.0D0)THEN
          DXL = DX(1)
          DFXL = DFCS
        ELSE
          DXR = DX(1)
          DFXR = DFCS 
        ENDIF
C
        DXRML = DXR - DXL
        IF(DXRML.LE.DSIG .AND. DABS(DFCS).LE.DEPS)THEN
          PPF(I)=DPPF
          GOTO100
        ENDIF
C
C       STEP 3: ERROR MESSAGE FOR NO CONVERGENCE
C
        IC = IC + 1
        IF(IC.LE.MAXIT)GOTO205
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,230)I,DP
  230   FORMAT('      FOR ROW ',I8,' (P = ',G15.7,'), THERE WAS ',
     1         'NO CONVERGENCE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,233)
  233   FORMAT('      LAST VALUE OBTAINED WILL BE USED.')
        CALL DPWRST('XXX','BUG ')
        PPF(I)=DPPF
        GOTO100
C
  100 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EN(X,ULAB,XREF,UREF,N,IWRITE,ENOUT,
     1              IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE EN STATISTIC:
C
C                 EN(i) = (x(i) - XREF)/SQRT(U(lab)**2 + U(ref)**2)
C
C              WHERE
C
C                   XREF    = THE ASSIGNED VALUE (DETERMINED FROM A
C                             REFERENCE LABORATORY)
C                   U(ref)  = THE EXPANDED UNCERTAINTY FOR THE ASSIGNED
C                             VALUE
C                   U(lab)  = THE EXPANDED UNCERTAINTY FOR THE LAB
C
C              NOTE THAT SINCE THE LAB UNCERTAINTY CAN VARY DEPENDING
C              ON THE LAB, THIS IS INPUT AS A VECTOR RATHER THAN A
C              PARAMETER.  XREF AND UREF ARE INPUT AS PARAMETERS SINCE
C              THEY ARE FIXED FOR ALL LABS.  ULAB EFFECTIVELY ACTS AS
C              AS A PROXY FOR LAB-ID, SO NO NEED TO INPUT THIS AS A
C              SEPARATE VALUE.
C
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --ULAB   = THE SINGLE PRECISION VECTOR OF
C                                LAB EXPANDED UNCERTAINTIES
C                     --XREF   = THE SINGLE PRECISION VALUE CONTAINING
C                                THE ASSIGNED VALUE
C                     --UREF   = THE SINGLE PRECISION VALUE CONTAINING
C                                THE EXPANDED UNCERTAINTY FOR THE
C                                ASSIGNED VALUE
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--ENOUT  = THE SINGLE PRECISION VECTOR OF THE
C                                COMPUTED EN VALUES.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VECTOR OF THE SAMPLE EN
C             VALUES.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--SQRT.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCE--ISO 13528, FIRST EDITION, STATISTICAL METHODS FOR USE
C                IN PROFICIENCY TESTING BY INTERLABORATORY COMPARISONS,
C                2005, PP. 27-28.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2012.1
C     ORIGINAL VERSION--JANUARY   2012.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DSUM
C
      DIMENSION X(*)
      DIMENSION ULAB(*)
      DIMENSION ENOUT(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EN  '
      ISUBN2='    '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'EN  ')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF EN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,N,XREF,UREF
   52   FORMAT('IBUGA3,N = ',A4,2X,I8,2G15.7)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,X(I),ULAB(I)
   56     FORMAT('I,X(I),ULAB(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ********************
C               **  COMPUTE EN    **
C               ********************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(N.LT.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN EN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE NUMBER OF OBSERVATIONS IN THE VARIABLE FOR')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,114)
  114   FORMAT('      WHICH THE MEAN IS TO BE COMPUTED MUST BE AT ',
     1         'LEAST 1.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,117)N
  117   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,'.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(UREF.LT.0.0)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,122)
  122   FORMAT('      THE REFERENCE EXPANDED UNCERTAINTY IS NEGATIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,127)UREF
  127   FORMAT('      THE REFERENCE EXPANDED UNCERTAINTY = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               *************************
C               **  STEP 2--           **
C               **  COMPUTE THE EN     **
C               *************************
C
      DO200I=1,N
        UTEMP1=ULAB(I)
        UTEMP2=UTEMP1**2 + UREF**2
C
        IF(UTEMP1.LT.0.0 .OR. UTEMP2.LE.0.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,111)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,222)
  222     FORMAT('      EITHER THE LAB EXPANDED UNCERTAINTY IS ',
     1           'NEGATIVE OR')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,224)
  224     FORMAT('      BOTH THE LAB EXPANDED UNCERTAINTY AND THE ',
     1           'EXPANDED')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,226)
  226     FORMAT('      REFERENCE UNCERTAINTY ARE ZERO.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,127)UREF
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,227)ULAB(I)
  227     FORMAT('      THE LAB EXPANDED UNCERTAINTY = ',G15.7)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
C
        ENOUT(I)=(X(I) - XREF)/SQRT(UTEMP1**2 + UREF**2)
  200 CONTINUE
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
  800 CONTINUE
      IF(IFEEDB.EQ.'ON' .AND. IWRITE.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,811)N
  811   FORMAT('THE NUMBER OF EN VALUES GENERATED = ',I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'EN  ')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF EN--')
        CALL DPWRST('XXX','BUG ')
        DO9012I=1,N
          WRITE(ICOUT,9015)I,X(I),ULAB(I),ENOUT(I)
 9015     FORMAT('I,X(I),ULAB(I),ENOUT(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 9012   CONTINUE
      ENDIF
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION ENVJ(N,X)
      DOUBLE PRECISION X
      ENVJ=0.5D0*DLOG10(6.28D0*N)-N*DLOG10(1.36D0*X/N)
      RETURN
      END
      DOUBLE PRECISION FUNCTION EPLFUN (DB)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE ESTIMATE OF B
C              FOR THE EXPONENTIAL LAW (NUMBER OF FAILURES CASE).
C              THIS FUNCTION FINDS THE ROOT OF THE EQUATION:
C
C                 SUM[i=1 to n][X(i)] + N/Bhat -
C                 N*X(n)/(1 - EXP(-BHAT*X(n)) = 0
C
C              WITH
C
C                 N        = NUMBER OF FAILURE TIMES
C                 Bhat     = POINT ESTIMATE OF B
C                 X        = VECTOR OF FAILURE TIMES
C
C              NOTE THAT THE SUM[X(I)] AND X(N) ARE COMPUTED IN
C              DPMLEL AND PASSED VIA COMMON BLOCK.
C
C              CALLED BY DFZERO ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.
C     EXAMPLE--EXPONENTIAL LAW MAXIMUM LIKELIHOOD Y CENSOR
C     REFERENCE--TOBIAS AND TRINDADE, "APPLIED RELIABILITY", SECOND
C                EDITION, PP. 363-365.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/2
C     ORIGINAL VERSION--FEBRUARY   2007.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DB
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DTEND
      DOUBLE PRECISION DXSUM
      DOUBLE PRECISION DXN
      COMMON/EPLCOM/DXSUM,DXN,DTEND,DN
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  COMPUTE SOME SUMS
C
      EPLFUN=DXSUM + (DN/DB) - DN*DXN/(1.0D0 - DEXP(-DB*DXN))
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION EPLFU2 (DB)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE ESTIMATE OF B
C              FOR THE EXPONENTIAL LAW (TIME CENSORED CASE).
C              THIS FUNCTION FINDS THE ROOT OF THE EQUATION:
C
C                 SUM[i=1 to n][X(i)] + N/Bhat -
C                 N*T/(1 - EXP(-BHAT*T)) = 0
C
C              WITH
C
C                 N        = NUMBER OF FAILURE TIMES
C                 Bhat     = POINT ESTIMATE OF B
C                 X        = VECTOR OF FAILURE TIMES
C                 T        = CENSORING TIME
C
C              NOTE THAT THE SUM[X(I)] AND T ARE COMPUTED IN
C              DPMLEL AND PASSED VIA COMMON BLOCK.
C
C              CALLED BY DFZERO ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.
C     EXAMPLE--EXPONENTIAL LAW MAXIMUM LIKELIHOOD Y CENSOR
C     REFERENCE--TOBIAS AND TRINDADE, "APPLIED RELIABILITY", SECOND
C                EDITION, PP. 363-365.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/2
C     ORIGINAL VERSION--FEBRUARY   2007.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DB
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DTEND
      DOUBLE PRECISION DXSUM
      DOUBLE PRECISION DXN
      COMMON/EPLCOM/DXSUM,DXN,DTEND,DN
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  COMPUTE SOME SUMS
C
      EPLFU2=DXSUM + (DN/DB) - DN*DTEND/(1.0D0 - DEXP(-DB*DTEND))
C
      RETURN
      END
      SUBROUTINE EUCDIS(AMAT,AMAT2,MAXROM,MAXCOM,NR1,NC1,ICASE,IWRITE,
     1IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE
C              EUCLIDEAN DISTANCE OF A MATRIX.  THE FORMULA IS:
C                 Dij=SQRT(SUM(Xik - Xjk)**2)
C              THE SUMMATION IS K = 1 TO P (WHERE THERE ARE P
C              COLUMNS IN THE MATRIX).  FOR EXAMPLE, D23 IS
C              THE DISTANCE BETWEEN THE SECOND AND THIRD ROWS.
C     INPUT  ARGUMENTS--AMAT   = THE SINGLE PRECISION MATRIX
C                     --MAXROM = THE INTEGER ROW DIMENSION OF AMAT
C                     --MAXCOM = THE INTEGER COUMN DIMENSION OF AMAT
C                     --NR1    = THE INTEGER NUMBER OF ROWS OF AMAT
C                     --NC1    = THE INTEGER NUMBER OF COLUMNS OF AMAT
C     OUTPUT ARGUMENTS--AMAT2    = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED SAMPLE EUCLIDEAN DISTANCES.
C     OUTPUT--MATRIX OF EUCLIDEAN DISTANCES
C     NOTE--THIS ROUTINE ASSUMES THE ERROR CHECKING (FOR EQUAL
C           ROWS AND COLUMNS, MATCHING DIMENSIONS FOR X AND AMAT)
C           IS DONE BT THE CALLING SUBROUTINE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98.6
C     ORIGINAL VERSION--JUNE      1998.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASE
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DSUM
      DOUBLE PRECISION DYM1
      DOUBLE PRECISION DYM2
C
      DIMENSION AMAT(MAXROM,MAXCOM)
      DIMENSION AMAT2(MAXROM,MAXCOM)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EUCD'
      ISUBN2='IS  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF EUCDIS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3
   52 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)NR1,NC1
   53 FORMAT('NR1, NC1 = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)ICASE
   54 FORMAT('ICASE = ',A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               ********************************
C               **  COMPUTE EUCLIDEAN DISTANCE *
C               ********************************
C
      IF(ICASE.EQ.'ROW ')THEN
        DO5861I=1,NR1
          DO5863J=1,I
            IF(I.EQ.1)THEN
              AMAT2(I,I)=0.0
            ELSE
              DSUM=0.0D0
              DO5865K=1,NC1
                DYM1=AMAT(I,K)
                DYM2=AMAT(J,K)
                DSUM=DSUM+(DYM1-DYM2)**2
 5865         CONTINUE
              AMAT2(I,J)=REAL(DSQRT(DSUM))
              AMAT2(J,I)=AMAT2(I,J)
            ENDIF
 5863     CONTINUE
 5861   CONTINUE
      ELSEIF(ICASE.EQ.'COLU')THEN
        DO5961I=1,NC1
          DO5963J=1,I
            IF(I.EQ.1)THEN
              AMAT2(I,I)=0.0
            ELSE
              DSUM=0.0D0
              DO5965K=1,NR1
                DYM1=AMAT(K,I)
                DYM2=AMAT(K,J)
                DSUM=DSUM+(DYM1-DYM2)**2
 5965         CONTINUE
              AMAT2(I,J)=REAL(DSQRT(DSUM))
              AMAT2(J,I)=AMAT2(I,J)
            ENDIF
 5963     CONTINUE
 5961   CONTINUE
      ENDIF
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)
  811 FORMAT('THE EUCLIDEAN DISTANCE MATRIX HAS BEEN CALCULATED.')
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF EUCDIS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,IERROR
 9012 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE EULERB(N,EN)
C
C       ======================================
C       Purpose: Compute Euler number En
C       Input :  n --- Serial number
C       Output:  EN(n) --- En
C       ======================================
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      REAL CPUMAX, CPUMIN
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
        DIMENSION EN(0:N)
C
        HPI=2.0D0/3.141592653589793D0
        DO1I=0,N
          EN(I)=0.0D0
 1      CONTINUE
C
        EN(0)=1.0D0
        EN(2)=-1.0D0
        IF(N.LE.3)RETURN
        R1=-4.0D0*HPI**3
C
        IFLAG=0
C
        DO 20 M=4,N,2
           IF(IFLAG.EQ.1)THEN
             EN(M)=DBLE(CPUMAX)
             GOTO20
           ENDIF
           R1=-R1*(M-1)*M*HPI*HPI
           R2=1.0D0
           ISGN=1.0D0
           DO 10 K=3,1000,2
              ISGN=-ISGN
              S=(1.0D0/K)**(M+1)
              R2=R2+ISGN*S
              IF (S.LT.1.0D-15) GOTO 29
10         CONTINUE
29         CONTINUE
           EN(M)=R1*R2
           IF(EN(M).GE.DBLE(CPUMAX))THEN
             IFLAG=1
             EN(M)=DBLE(CPUMAX)
             WRITE(ICOUT,90)M
             CALL DPWRST('XXX','BUG')
90           FORMAT('***** EULER NUMBERS: OVERFLOW AT N = ',I8)
           ENDIF
20      CONTINUE
C
        RETURN
        END
      SUBROUTINE EULERP(X,N,EN)
C
C       ======================================
C       Purpose: Compute Euler polynomial of order n for X
C       Input :  n --- Order of Euler polynomial
C                x --- value at which to compute the polynomial
C       Output:  EN--- computed value
C       ======================================
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DIMENSION DTEMP(200)
      REAL CPUMIN, CPUMAX
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      SUM=0.0D0
      DO100I=0,N/2
        CALL EULERB(2*I,DTEMP)
        TERM2=DTEMP(2*I+1)
        TERM1=DBINOM(N,2*I)
        IF(X-0.5D0.EQ.0.0D0 .AND. N-2*I.EQ.0)THEN
          TERM3=1.0D0
        ELSE
          TERM3=(X-0.5D0)**(N-2*I)
        ENDIF
        SUM=SUM + TERM1*TERM2*TERM3/DBLE(2**(2*I))
  100 CONTINUE
      EN=SUM
C
      RETURN
      END
      SUBROUTINE EXCHNG (X, M, Y, N, SX, SY)
C
C        ALGORITHM AS 304.2 APPL.STATIST. (1996), VOL.45, NO.3
C
C        Exchanges the sample data.  Assumes both X and Y have been
C        previously dimensioned to at least max(M, N) elements
C
C        DATAPLOT NOTE: UTILITY ROUTINE USED BY THE FISHER TWO SAMPLE
C                       RANDOMIZATION TEST
C
      INTEGER M, N
      REAL X(*), Y(*), SX, SY
C
      INTEGER C, K
      REAL TEMP
C
      TEMP = SX
      SX = SY
      SY = TEMP
C
      C = MIN(M, N)
      DO 10 K = 1, C
         TEMP = X(K)
         X(K) = Y(K)
         Y(K) = TEMP
   10 CONTINUE
      IF (M .GT. N) THEN
         DO 20 K = C+1, M
            Y(K) = X(K)
   20    CONTINUE
         N = M
         M = C
      ELSE IF (M .LT. N) THEN
         DO 30 K = C+1, N
            X(K) = Y(K)
   30    CONTINUE
         M = N
         N = C
      END IF
C
      RETURN
      END
      SUBROUTINE EXINT (X, N, KODE, M, TOL, EN, NZ, IERR)
C***BEGIN PROLOGUE  EXINT
C***PURPOSE  Compute an M member sequence of exponential integrals
C            E(N+K,X), K=0,1,...,M-1 for N .GE. 1 and X .GE. 0.
C***LIBRARY   SLATEC
C***CATEGORY  C5
C***TYPE      SINGLE PRECISION (EXINT-S, DEXINT-D)
C***KEYWORDS  EXPONENTIAL INTEGRAL, SPECIAL FUNCTIONS
C***AUTHOR  Amos, D. E., (SNLA)
C***DESCRIPTION
C
C         EXINT computes M member sequences of exponential integrals
C         E(N+K,X), K=0,1,...,M-1 for N .GE. 1 and X .GE. 0.  The
C         exponential integral is defined by
C
C         E(N,X)=integral on (1,infinity) of EXP(-XT)/T**N
C
C         where X=0.0 and N=1 cannot occur simultaneously.  Formulas
C         and notation are found in the NBS Handbook of Mathematical
C         Functions (ref. 1).
C
C         The power series is implemented for X .LE. XCUT and the
C         confluent hypergeometric representation
C
C                     E(A,X) = EXP(-X)*(X**(A-1))*U(A,A,X)
C
C         is computed for X .GT. XCUT.  Since sequences are computed in
C         a stable fashion by recurring away from X, A is selected as
C         the integer closest to X within the constraint N .LE. A .LE.
C         N+M-1.  For the U computation, A is further modified to be the
C         nearest even integer.  Indices are carried forward or
C         backward by the two term recursion relation
C
C                     K*E(K+1,X) + X*E(K,X) = EXP(-X)
C
C         once E(A,X) is computed.  The U function is computed by means
C         of the backward recursive Miller algorithm applied to the
C         three term contiguous relation for U(A+K,A,X), K=0,1,...
C         This produces accurate ratios and determines U(A+K,A,X), and
C         hence E(A,X), to within a multiplicative constant C.
C         Another contiguous relation applied to C*U(A,A,X) and
C         C*U(A+1,A,X) gets C*U(A+1,A+1,X), a quantity proportional to
C         E(A+1,X).  The normalizing constant C is obtained from the
C         two term recursion relation above with K=A.
C
C     Description of Arguments
C
C         Input
C           X       X .GT. 0.0 for N=1 and  X .GE. 0.0 for N .GE. 2
C           N       order of the first member of the sequence, N .GE. 1
C                   (X=0.0 and N=1 is an error)
C           KODE    a selection parameter for scaled values
C                   KODE=1   returns        E(N+K,X), K=0,1,...,M-1.
C                       =2   returns EXP(X)*E(N+K,X), K=0,1,...,M-1.
C           M       number of exponential integrals in the sequence,
C                   M .GE. 1
C           TOL     relative accuracy wanted, ETOL .LE. TOL .LE. 0.1
C                   ETOL = single precision unit roundoff = R1MACH(4)
C
C         Output
C           EN      a vector of dimension at least M containing values
C                   EN(K) = E(N+K-1,X) or EXP(X)*E(N+K-1,X), K=1,M
C                   depending on KODE
C           NZ      underflow indicator
C                   NZ=0   a normal return
C                   NZ=M   X exceeds XLIM and an underflow occurs.
C                          EN(K)=0.0E0 , K=1,M returned on KODE=1
C           IERR    error flag
C                   IERR=0, normal return, computation completed
C                   IERR=1, input error,   no computation
C                   IERR=2, error,         no computation
C                           algorithm termination condition not met
C
C***REFERENCES  M. Abramowitz and I. A. Stegun, Handbook of
C                 Mathematical Functions, NBS AMS Series 55, U.S. Dept.
C                 of Commerce, 1955.
C               D. E. Amos, Computation of exponential integrals, ACM
C                 Transactions on Mathematical Software 6, (1980),
C                 pp. 365-377 and pp. 420-428.
C***ROUTINES CALLED  I1MACH, PSIXN, R1MACH
C***REVISION HISTORY  (YYMMDD)
C   800501  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890531  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900326  Removed duplicate information from DESCRIPTION section.
C           (WRB)
C   910408  Updated the REFERENCES section.  (WRB)
C   920207  Updated with code with a revision date of 880811 from
C           D. Amos.  Included correction of argument list.  (WRB)
C   920501  Reformatted the REFERENCES section.  (WRB)
C***END PROLOGUE  EXINT
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOMC.INC'
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      REAL             A,AA,AAMS,AH,AK,AT,B,BK,BT,CC,CNORM,CT,EM,EMX,EN,
     1                 ETOL,FNM,FX,PT,P1,P2,S,TOL,TX,X,XCUT,XLIM,XTOL,Y,
     2                 YT,Y1,Y2
      REAL             PSIXN
      INTEGER I,IC,ICASE,ICT,IERR,IK,IND,IX,I1M,JSET,K,KK,KN,KODE,KS,M,
     1        ML,MU,N,ND,NM,NZ
      DIMENSION EN(*), A(99), B(99), Y(2)
C***FIRST EXECUTABLE STATEMENT  EXINT
      IERR = 0
      NZ = 0
      ETOL = MAX(R1MACH(4),0.5E-18)
      IF (X.LT.0.0E0) IERR = 1
      IF (N.LT.1) IERR = 1
      IF (KODE.LT.1 .OR. KODE.GT.2) IERR = 1
      IF (M.LT.1) IERR = 1
      IF (TOL.LT.ETOL .OR. TOL.GT.0.1E0) IERR = 1
      IF (X.EQ.0.0E0 .AND. N.EQ.1) IERR = 1
      IF (IERR.NE.0) RETURN
      I1M = -I1MACH(12)
      PT = 2.3026E0*R1MACH(5)*I1M
      XLIM = PT - 6.907755E0
      BT = PT + (N+M-1)
      IF (BT.GT.1000.0E0) XLIM = PT - LOG(BT)
C
      XCUT = 2.0E0
      IF (ETOL.GT.2.0E-7) XCUT = 1.0E0
      IF (X.GT.XCUT) GO TO 100
      IF (X.EQ.0.0E0 .AND. N.GT.1) GO TO 80
C-----------------------------------------------------------------------
C     SERIES FOR E(N,X) FOR X.LE.XCUT
C-----------------------------------------------------------------------
      TX = X + 0.5E0
      IX = TX
C-----------------------------------------------------------------------
C     ICASE=1 MEANS INTEGER CLOSEST TO X IS 2 AND N=1
C     ICASE=2 MEANS INTEGER CLOSEST TO X IS 0,1, OR 2 AND N.GE.2
C-----------------------------------------------------------------------
      ICASE = 2
      IF (IX.GT.N) ICASE = 1
      NM = N - ICASE + 1
      ND = NM + 1
      IND = 3 - ICASE
      MU = M - IND
      ML = 1
      KS = ND
      FNM = NM
      S = 0.0E0
      XTOL = 3.0E0*TOL
      IF (ND.EQ.1) GO TO 10
      XTOL = 0.3333E0*TOL
      S = 1.0E0/FNM
   10 CONTINUE
      AA = 1.0E0
      AK = 1.0E0
      IC = 35
      IF (X.LT.ETOL) IC = 1
      DO 50 I=1,IC
        AA = -AA*X/AK
        IF (I.EQ.NM) GO TO 30
        S = S - AA/(AK-FNM)
        IF (ABS(AA).LE.XTOL*ABS(S)) GO TO 20
        AK = AK + 1.0E0
        GO TO 50
   20   CONTINUE
        IF (I.LT.2) GO TO 40
        IF (ND-2.GT.I .OR. I.GT.ND-1) GO TO 60
        AK = AK + 1.0E0
        GO TO 50
   30   S = S + AA*(-LOG(X)+PSIXN(ND))
        XTOL = 3.0E0*TOL
   40   AK = AK + 1.0E0
   50 CONTINUE
      IF (IC.NE.1) GO TO 340
   60 IF (ND.EQ.1) S = S + (-LOG(X)+PSIXN(1))
      IF (KODE.EQ.2) S = S*EXP(X)
      EN(1) = S
      EMX = 1.0E0
      IF (M.EQ.1) GO TO 70
      EN(IND) = S
      AA = KS
      IF (KODE.EQ.1) EMX = EXP(-X)
      GO TO (220, 240), ICASE
   70 IF (ICASE.EQ.2) RETURN
      IF (KODE.EQ.1) EMX = EXP(-X)
      EN(1) = (EMX-S)/X
      RETURN
   80 CONTINUE
      DO 90 I=1,M
        EN(I) = 1.0E0/(N+I-2)
   90 CONTINUE
      RETURN
C-----------------------------------------------------------------------
C     BACKWARD RECURSIVE MILLER ALGORITHM FOR
C              E(N,X)=EXP(-X)*(X**(N-1))*U(N,N,X)
C     WITH RECURSION AWAY FROM N=INTEGER CLOSEST TO X.
C     U(A,B,X) IS THE SECOND CONFLUENT HYPERGEOMETRIC FUNCTION
C-----------------------------------------------------------------------
  100 CONTINUE
      EMX = 1.0E0
      IF (KODE.EQ.2) GO TO 130
      IF (X.LE.XLIM) GO TO 120
      NZ = M
      DO 110 I=1,M
        EN(I) = 0.0E0
  110 CONTINUE
      RETURN
  120 EMX = EXP(-X)
  130 CONTINUE
      IX = X+0.5E0
      KN = N + M - 1
      IF (KN.LE.IX) GO TO 140
      IF (N.LT.IX .AND. IX.LT.KN) GO TO 170
      IF (N.GE.IX) GO TO 160
      GO TO 340
  140 ICASE = 1
      KS = KN
      ML = M - 1
      MU = -1
      IND = M
      IF (KN.GT.1) GO TO 180
  150 KS = 2
      ICASE = 3
      GO TO 180
  160 ICASE = 2
      IND = 1
      KS = N
      MU = M - 1
      IF (N.GT.1) GO TO 180
      IF (KN.EQ.1) GO TO 150
      IX = 2
  170 ICASE = 1
      KS = IX
      ML = IX - N
      IND = ML + 1
      MU = KN - IX
  180 CONTINUE
      IK = KS/2
      AH = IK
      JSET = 1 + KS - (IK+IK)
C-----------------------------------------------------------------------
C     START COMPUTATION FOR
C              EN(IND) = C*U( A , A ,X)    JSET=1
C              EN(IND) = C*U(A+1,A+1,X)    JSET=2
C     FOR AN EVEN INTEGER A.
C-----------------------------------------------------------------------
      IC = 0
      AA = AH + AH
      AAMS = AA - 1.0E0
      AAMS = AAMS*AAMS
      TX = X + X
      FX = TX + TX
      AK = AH
      XTOL = TOL
      IF (TOL.LE.1.0E-3) XTOL = 20.0E0*TOL
      CT = AAMS + FX*AH
      EM = (AH+1.0E0)/((X+AA)*XTOL*SQRT(CT))
      BK = AA
      CC = AH*AH
C-----------------------------------------------------------------------
C     FORWARD RECURSION FOR P(IC),P(IC+1) AND INDEX IC FOR BACKWARD
C     RECURSION
C-----------------------------------------------------------------------
      P1 = 0.0E0
      P2 = 1.0E0
  190 CONTINUE
      IF (IC.EQ.99) GO TO 340
      IC = IC + 1
      AK = AK + 1.0E0
      AT = BK/(BK+AK+CC+IC)
      BK = BK + AK + AK
      A(IC) = AT
      BT = (AK+AK+X)/(AK+1.0E0)
      B(IC) = BT
      PT = P2
      P2 = BT*P2 - AT*P1
      P1 = PT
      CT = CT + FX
      EM = EM*AT*(1.0E0-TX/CT)
      IF (EM*(AK+1.0E0).GT.P1*P1) GO TO 190
      ICT = IC
      KK = IC + 1
      BT = TX/(CT+FX)
      Y2 = (BK/(BK+CC+KK))*(P1/P2)*(1.0E0-BT+0.375E0*BT*BT)
      Y1 = 1.0E0
C-----------------------------------------------------------------------
C     BACKWARD RECURRENCE FOR
C              Y1=             C*U( A ,A,X)
C              Y2= C*(A/(1+A/2))*U(A+1,A,X)
C-----------------------------------------------------------------------
      DO 200 K=1,ICT
        KK = KK - 1
        YT = Y1
        Y1 = (B(KK)*Y1-Y2)/A(KK)
        Y2 = YT
  200 CONTINUE
C-----------------------------------------------------------------------
C     THE CONTIGUOUS RELATION
C              X*U(B,C+1,X)=(C-B)*U(B,C,X)+U(B-1,C,X)
C     WITH  B=A+1 , C=A IS USED FOR
C              Y(2) = C * U(A+1,A+1,X)
C     X IS INCORPORATED INTO THE NORMALIZING RELATION
C-----------------------------------------------------------------------
      PT = Y2/Y1
      CNORM = 1.0E0 - PT*(AH+1.0E0)/AA
      Y(1) = 1.0E0/(CNORM*AA+X)
      Y(2) = CNORM*Y(1)
      IF (ICASE.EQ.3) GO TO 210
      EN(IND) = EMX*Y(JSET)
      IF (M.EQ.1) RETURN
      AA = KS
      GO TO (220, 240), ICASE
C-----------------------------------------------------------------------
C     RECURSION SECTION  N*E(N+1,X) + X*E(N,X)=EMX
C-----------------------------------------------------------------------
  210 EN(1) = EMX*(1.0E0-Y(1))/X
      RETURN
  220 K = IND - 1
      DO 230 I=1,ML
        AA = AA - 1.0E0
        EN(K) = (EMX-AA*EN(K+1))/X
        K = K - 1
  230 CONTINUE
      IF (MU.LE.0) RETURN
      AA = KS
  240 K = IND
      DO 250 I=1,MU
        EN(K+1) = (EMX-X*EN(K))/AA
        AA = AA + 1.0E0
        K = K + 1
  250 CONTINUE
      RETURN
  340 CONTINUE
      IERR = 2
      RETURN
      END
      SUBROUTINE ERRCDF(X,ALPHA,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE ERROR (OR EXPONENTIAL POWER OR
C              GENERAL ERROR OR SUBBOTIN) DISTRIBUTION.  NOTE THAT
C              THERE ARE SEVERAL DIFFERENT PARAMETERIZATIONS OF
C              THIS DISTRIBUTION.  WE USE THE ONE FROM THE
C              TADIKAMALLA PAPER (SEE REFERENCE BELOW).  SPECIFICALLY,
C              THE PDF IS:
C              F(X,ALPHA)=EXP(-|X|**ALPHA)/[2*ALPHA(1+1/ALPHA)]
C                         -INFINITY < X < INFINITY, ALPHA >= 1
C              WITH ALPHA DENOTING THE SHAPE PARAMETER.
C              AT THE VALUE ALPHA.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE CUMULATIVE DISTRIBUTION 
C                                FUNCTION IS TO BE EVALUATED.
C                                X CAN BE ANY REAL NUMBER
C                     --ALPHA  = THE SINGLE PRECISION VALUE 
C                                OF THE TAIL LENGTH PARAMETER.
C                                ALPHA SHOULD BE >= 1..
C     OUTPUT ARGUMENTS--CDF    = THE SINGLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--ALPHA SHOULD BE >= 1.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DGAMMA, DGAMI
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--PANDU R. RADIKAMALLA, "RANDOM SAMPLING FROM THE
C                 EXPONENTIAL POWER DISTRIBUTION", JOURNAL OF THE
C                 AMERICAN STATISTICAL ASSOCIATION, SEPTEMBER, 1980,
C                 PAGES 683-686.
C               --JOHNSON, KOTZ, AND BALAKRISHNAN, "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS--VOLUME 2, SECOND EDITION",
C                 WILEY, 1994.
C               --EVANS, HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--THIRD EDITION", WILEY, 2000.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--MAY       2003.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX,DALPHA,DGAMMA,DGAMI,DCDF
      DOUBLE PRECISION DTERM1, DTERM2
      EXTERNAL DGAMI
      EXTERNAL DGAMMA
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(ALPHA.LT.1.0)THEN
        WRITE(ICOUT,15) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,16) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)ALPHA
        CALL DPWRST('XXX','BUG ')
        CDF=0.0
        GOTO9999
      ENDIF
   15 FORMAT('***** FATAL ERROR--THE SHAPE PARAMETER FOR THE ERROR')
   16 FORMAT('      CDF FUNCTION IS LESS THAN ONE.')
   46 FORMAT('      THE VALUE OF THE ARGUMENT IS ',E15.8)
C
C-----START POINT-----------------------------------------------------
C
      DX=DBLE(X)
      DALPHA=DBLE(ALPHA)
C
C  ALPHA=1 IS DOUBLE EXPONENTIAL
C  ALPHA=2 IS NORMAL
C
      IF(ALPHA.LE.1.00005)THEN
        CALL DEXCDF(X,CDF)
        GOTO9999
      ELSEIF(ALPHA.EQ.2.0)THEN
        CALL NORCDF(X,CDF)
        GOTO9999
      ENDIF
C
      IF(X.EQ.0.0)THEN
        CDF=0.5
        GOTO9999
      ELSEIF(X.GT.0.0)THEN
        DTERM1=-DX*DGAMI(1.0D0/DALPHA,DX**DALPHA)
        DTERM2=2.0D0*DALPHA*(DX**DALPHA)**(1.0D0/DALPHA)*
     1         DGAMMA(1.0D0+1.0D0/DALPHA)
        DCDF=0.5D0 - DTERM1/DTERM2
      ELSE
        DX=-DX
        DTERM1=-DX*DGAMI(1.0D0/DALPHA,DX**DALPHA)
        DTERM2=2.0D0*DALPHA*(DX**DALPHA)**(1.0D0/DALPHA)*
     1         DGAMMA(1.0D0+1.0D0/DALPHA)
        DCDF=0.5D0 + DTERM1/DTERM2
      ENDIF
C
      CDF=REAL(DCDF)
 9999 CONTINUE
      RETURN
      END 
      SUBROUTINE ERRPDF(X,ALPHA,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE ERROR (OR EXPONENTIAL POWER OR
C              GENERAL ERROR OR SUBBOTIN) DISTRIBUTION.  NOTE THAT
C              THERE ARE SEVERAL DIFFERENT PARAMETERIZATIONS OF
C              THIS DISTRIBUTION.  WE USE THE ONE FROM THE
C              TADIKAMALLA PAPER (SEE REFERENCE BELOW).  SPECIFICALLY,
C              THE PDF IS:
C              F(X,ALPHA)=EXP(-|X|**ALPHA)/[2*ALPHA(1+1/ALPHA)]
C                         -INFINITY < X < INFINITY, ALPHA >= 1
C              WITH ALPHA DENOTING THE SHAPE PARAMETER.
C              AT THE VALUE ALPHA.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE CUMULATIVE DISTRIBUTION 
C                                FUNCTION IS TO BE EVALUATED.
C                                X CAN BE ANY REAL NUMBER
C                     --ALPHA  = THE SINGLE PRECISION VALUE 
C                                OF THE TAIL LENGTH PARAMETER.
C                                ALPHA SHOULD BE >= 1..
C     OUTPUT ARGUMENTS--PDF    = THE SINGLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--ALPHA SHOULD BE >= 1.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DEXP, DLOG.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--PANDU R. RADIKAMALLA, "RANDOM SAMPLING FROM THE
C                 EXPONENTIAL POWER DISTRIBUTION", JOURNAL OF THE
C                 AMERICAN STATISTICAL ASSOCIATION, SEPTEMBER, 1980,
C                 PAGES 683-686.
C               --JOHNSON, KOTZ, AND BALAKRISHNAN, "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS--VOLUME 2, SECOND EDITION",
C                 WILEY, 1994.
C               --EVANS, HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--THIRD EDITION", WILEY, 2000.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--MAY       2003.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C

      DOUBLE PRECISION DX,DALPHA,DLNGAM,DPDF
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(ALPHA.LT.1.0)THEN
        WRITE(ICOUT,15) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,16) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)ALPHA
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9999
      ENDIF
   15 FORMAT('***** FATAL ERROR--THE SHAPE PARAMETER FOR THE ERROR')
   16 FORMAT('      PDF FUNCTION IS LESS THAN ONE.')
   46 FORMAT('      THE VALUE OF THE ARGUMENT IS ',E15.8)
C
C-----START POINT-----------------------------------------------------
C
      DX=DBLE(X)
      DALPHA=DBLE(ALPHA)
C
      IF(ALPHA.EQ.1.0)THEN
        CALL DEXPDF(X,PDF)
        GOTO9999
      ELSEIF(ALPHA.EQ.2.0)THEN
        CALL NORPDF(X,PDF)
        GOTO9999
      ENDIF
C
      DPDF=-DABS(DX)**DALPHA-DLOG(2.0D0)-DLNGAM(1.0D0+1.0D0/DALPHA)
      IF(DPDF.LT.-80.D0)THEN
        PDF=0.0
      ELSEIF(DPDF.LT.LOG(CPUMAX))THEN
        PDF=REAL(DEXP(DPDF))
      ELSE
        PDF=LOG(CPUMAX)
        WRITE(ICOUT,105) 
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
  105 FORMAT('****** WARNING--OVERFLOW IN ERRPDF ROUTINE.')
C
 9999 CONTINUE
      RETURN
      END 
      SUBROUTINE ERRPPF(P,ALPHA,PPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE ERROR (OR EXPONENTIAL POWER OR
C              GENERAL ERROR OR SUBBOTIN) DISTRIBUTION.  NOTE THAT
C              THERE ARE SEVERAL DIFFERENT PARAMETERIZATIONS OF
C              THIS DISTRIBUTION.  WE USE THE ONE FROM THE
C              TADIKAMALLA PAPER (SEE REFERENCE BELOW).  SPECIFICALLY,
C              THE PPF IS:
C              F(X,ALPHA)=EXP(-|X|**ALPHA)/[2*ALPHA(1+1/ALPHA)]
C                         -INFINITY < X < INFINITY, ALPHA >= 1
C              WITH ALPHA DENOTING THE SHAPE PARAMETER.
C              AT THE VALUE ALPHA.
C              THE PERCENT POINT FUNCTION IS COMPUTED NUMERICALLY
C              USING A BISECTION METHOD.
C     INPUT  ARGUMENTS--P      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE PERCENT POINT 
C                                FUNCTION IS TO BE EVALUATED.
C                                X CAN BE ANY REAL NUMBER
C                     --ALPHA  = THE SINGLE PRECISION VALUE 
C                                OF THE TAIL LENGTH PARAMETER.
C                                ALPHA SHOULD BE >= 1..
C     OUTPUT ARGUMENTS--PPF    = THE SINGLE PRECISION PERCENT POINT
C                                FUNCTION VALUE.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--ALPHA SHOULD BE >= 1.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DEXP, DLOG.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--PANDU R. RADIKAMALLA, "RANDOM SAMPLING FROM THE
C                 EXPONENTIAL POWER DISTRIBUTION", JOURNAL OF THE
C                 AMERICAN STATISTICAL ASSOCIATION, SEPTEMBER, 1980,
C                 PAGES 683-686.
C               --JOHNSON, KOTZ, AND BALAKRISHNAN, "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS--VOLUME 2, SECOND EDITION",
C                 WILEY, 1994.
C               --EVANS, HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--THIRD EDITION", WILEY, 2000.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--MAY       2003.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX,DALPHA,DGAMMA
      EXTERNAL DGAMMA
C
      DATA EPS /0.00001/
      DATA SIG /1.0E-6/
      DATA ZERO /0./
      DATA MAXIT /500/
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LE.0.0 .OR. P.GE.1.0)THEN
        WRITE(ICOUT,5) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,6) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ENDIF
      IF(ALPHA.LT.1.0)THEN
        WRITE(ICOUT,15) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,16) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)ALPHA
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ENDIF
    5 FORMAT('***** FATAL ERROR--THE INPUT ARGUMENT FOR THE ERROR')
    6 FORMAT('      PERCENT POINT FUNCTION IS OUTSIDE THE ALLOWABLE ',
     1       '[0,1] INTERVAL.')
   15 FORMAT('***** FATAL ERROR--THE SHAPE PARAMETER FOR THE ERROR')
   16 FORMAT('      PERCENT POINT FUNCTION IS LESS THAN ONE.')
   46 FORMAT('      THE VALUE OF THE ARGUMENT IS ',E15.8)
C
C-----START POINT-----------------------------------------------------
C
      IF(ALPHA.LE.1.00005)THEN
        CALL DEXPPF(P,PPF)
        ASGN=1.0
        GOTO9999
      ELSEIF(ALPHA.EQ.2.0)THEN
        CALL NORPPF(P,PPF)
        ASGN=1.0
        GOTO9999
      ENDIF
C
      DALPHA=DBLE(ALPHA)
C
C  P = 0.5 IS ZERO.  USE SYMMETRY TO HANDLE P < 0.5 AND P > 0.5
C  CASES WITH SAME CODE (JUST NEED TO CHANGE SIGN OF FINAL PPF
C  VALUE).
C
      IF(P.EQ.0.5)THEN
        PPF=0.0
        GOTO9999
      ENDIF
      ASGN=1.0
      IF(P.LT.0.5)THEN
        P=1.0 - P
        ASGN=-1.0
      ENDIF
C
C  FIND BRACKETING INTERVAL.  BRACKETED ABOVE BY ZERO.  STANDARD
C  DEVIATION = SQRT(GAMMA(3/ALPHA)/GAMMA(1/ALPHA)).
C
      SD=DSQRT(DGAMMA(3.0D0/DALPHA)/DGAMMA(1.0D0/DALPHA))
      XL=0.0D0
      XINC=SD
      ICOUNT=0
      MAXCNT=200
C
   91 CONTINUE
      XR=XL+XINC
      IF(XL.LE.0.0)XL=0.0
      IF(XR.LE.0.0)XR=XL+1.0
      CALL ERRCDF(XL,ALPHA,CDFL)
      CALL ERRCDF(XR,ALPHA,CDFR)
      IF(CDFL.LT.P .AND. CDFR.LT.P)THEN
        XL=XR
      ELSEIF(CDFL.GT.P .AND. CDFR.GT.P)THEN
        XL=XL-XINC
      ELSE
        GOTO99
      ENDIF
      ICOUNT=ICOUNT+1
      IF(ICOUNT.GT.MAXCNT)THEN
        WRITE(ICOUT,96)
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ENDIF
   96 FORMAT('***** FATAL ERROR--ERRPPF UNABLE TO FIND BRACKETING ',
     *       'INTERVAL. *****')
      GOTO91
C
C  BISECTION METHOD
C
   99 CONTINUE
      IC = 0
      FXL = -P
      FXR = 1.0 - P
  105 CONTINUE
      X = (XL+XR)*0.5
      CALL ERRCDF(X,ALPHA,CDF)
      P1=CDF
      PPF=X
      FCS = P1 - P
      IF(FCS*FXL.GT.ZERO)GOTO110
      XR = X
      FXR = FCS 
      GOTO115
  110 CONTINUE
      XL = X
      FXL = FCS
  115 CONTINUE
      XRML = XR - XL
      IF(XRML.LE.SIG .AND. ABS(FCS).LE.EPS)GOTO9999
      IC = IC + 1
      IF(IC.LE.MAXIT)GOTO105
      WRITE(ICOUT,130)
      CALL DPWRST('XXX','BUG ')
  130 FORMAT('***** FATAL ERROR--ERRPPF ROUTINE DID NOT CONVERGE. ***')
      GOTO9999
C
C
 9999 CONTINUE
      PPF=ASGN*PPF
      RETURN
      END 
      SUBROUTINE ERRRAN(N,ALPHA,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE ERROR DISTRIBUTION WITH SINGLE PRECISION SHAPE
C              PARAMETER = ALPHA.  THIS DISTRIBUTION IS ALSO REFERRED
C              TO AS THE SUBBOTIN, EXPONENTIAL POWER, OR GENERAL
C              ERROR DISTRIBUTION.  NOTE THAT
C              THERE ARE SEVERAL DIFFERENT PARAMETERIZATIONS OF
C              THIS DISTRIBUTION.  WE USE THE ONE FROM THE
C              TADIKAMALLA PAPER (SEE REFERENCE BELOW).  SPECIFICALLY,
C              THE PDF IS:
C              F(X,ALPHA)=EXP(-|X|**ALPHA)/[2*ALPHA(1+1/ALPHA)]
C                         -INFINITY < X < INFINITY, ALPHA >= 1
C              WITH ALPHA DENOTING THE SHAPE PARAMETER.
C              AT THE VALUE ALPHA.
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --ALPHA  = THE SINGLE PRECISION VALUE OF THE
C                                FIRST  SHAPE PARAMETER.
C                                ALPHA SHOULD BE GREATER THAN 1.0.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE ERROR DISTRIBUTION
C             WITH SHAPE PARAMETER VALUE = ALPHA
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --ALPHA SHOULD BE GREATER THAN
C                   OR EQUAL TO 1.0.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN, GAMRAN, DEXRAN,
C                                         GAMRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--PANDU R. RADIKAMALLA, "RANDOM SAMPLING FROM THE
C                 EXPONENTIAL POWER DISTRIBUTION", JOURNAL OF THE
C                 AMERICAN STATISTICAL ASSOCIATION, SEPTEMBER, 1980,
C                 PAGES 683-686.
C               --JOHNSON, KOTZ, AND BALAKRISHNAN, "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS--VOLUME 2, SECOND EDITION",
C                 WILEY, 1994.
C               --EVANS, HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--THIRD EDITION", WILEY, 2000.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLARITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--2003.5
C     ORIGINAL VERSION--MAY       2003.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION XTEMP(1)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
      IF(ALPHA.LT.1.0)THEN
        WRITE(ICOUT,16)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)ALPHA
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    5 FORMAT('***** FATAL ERROR--THE NUMBER OF REQUESTED ERROR ',
     1'RANDOM NUMBERS IS NON-POSITIVE.')
   16 FORMAT('***** FATAL ERROR--THE SHAPE PARAMETER FOR THE ',
     1'ERROR DISTRIBUTION IS LESS THAN 1.0 *****')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,' *****')
C
C     GENERATE N ERROR RANDOM NUMBERS USING THE ALGORITHM OF
C     RADIKAMALLA.  THIS IS A FORTRAN IMPLEMENTATION OF THE ROUTINE
C     "gsl_ran_exppow" IN THE GNU GSL SCIENTIFIC LIBRARY.
C
      NTEMP=1
C
C  FIRST, HANDLE SPECIAL CASES (ALPHA = 1, 2 ARE DOUBLE EXPONENTIAL
C  AND NORMAL, RESPECTIVELY).
C
      IF(ALPHA.EQ.1.0)THEN
        CALL DEXRAN(N,ISEED,X)
      ELSEIF(ALPHA.EQ.2.0)THEN
        CALL NORRAN(N,ISEED,X)
C
C  CASE WHERE 1 < ALPHA < 2.  USE DOUBLE EXPONENTIAL DISTRIBUTION
C  FOR REJECTION METHOD.
C
      ELSEIF(ALPHA.GT.1.0 .AND. ALPHA.LT.2.0)THEN
        S=1.4489
        DO390I=1,N
  300     CONTINUE
            CALL DEXRAN(NTEMP,ISEED,XTEMP)
            AX=XTEMP(1)
            CALL DEXPDF(AX,AY)
            CALL ERRPDF(AX,ALPHA,AH)
            RATIO=AH/(S*AY)
            CALL UNIRAN(NTEMP,ISEED,XTEMP)
            U=XTEMP(1)
          IF(U.GT.RATIO)GOTO300
          X(I)=AX
  390   CONTINUE
C
C  CASE WHERE ALPHA > 2.  USE GAUSSIAN FOR FOR REJECTION METHOD.
C
      ELSE
        SIGMA=1.0/1.0/SQRT(2.0)
        S=2.4091
        DO490I=1,N
  400     CONTINUE
            CALL NORRAN(NTEMP,ISEED,XTEMP)
            AX=SIGMA*XTEMP(1)
            CALL NORPDF(AX/SIGMA,AY)
            AY=AY/SIGMA
            CALL ERRPDF(AX,ALPHA,AH)
            RATIO=AH/(S*AY)
            CALL UNIRAN(NTEMP,ISEED,XTEMP)
            U=XTEMP(1)
          IF(U.GT.RATIO)GOTO400
          X(I)=AX
  490   CONTINUE
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE ERRORF(IANS1,IANS2,IANS3,IANS4,AMIN,AMAX,DEF,
     1ANS2,IERROR)
C
C     PURPOSE--ANALYZE FLOATING POINT INPUT TERMINAL RESPONSE DURING
C              EXECUTION OF DATAPLOT AND
C              DETERMINE IF VALID.
C              ALSO, MAKE CONVERSION TO FLOATING POINT.
C     INPUT  ARGUMENTS--IANS1
C                     --IANS2
C                     --IANS3
C                     --IANS4
C                     --AMIN
C                     --AMAX
C                     --DEF
C     OUTPUT ARGUMENTS--ANS2
C                     --IERROR
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--OCTOBER 18, 1976.
C     UPDATED         --OCTOBER   1976.
C     UPDATED         --JULY      1978.
C     UPDATED         --OCTOBER   1978.
C     UPDATED         --FEBRUARY  1981.
C     UPDATED         --FEBRUARY  1982.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IANS1
      CHARACTER*4 IANS2
      CHARACTER*4 IANS3
      CHARACTER*4 IANS4
      CHARACTER*4 IERROR
C
      CHARACTER*4 IBUG1
      CHARACTER*4 IBUG2
      CHARACTER*4 IA
C
C---------------------------------------------------------------------
C
      DIMENSION IA(20)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ANS2=0
      IERROR='NO'
      IBUG1='OFF'
      IBUG2='OFF'
C
C               ************************************************************
C               **  DEFINE NUMASC = NUMBER OF ASCII CHARACTERS PER WORD.  **
C               **  THIS IS 4 REGARDLESS OF THE COMPUTER MAKE AND         **
C               **  REGARDLESS OF THE WORD SIZE.                          **
C               ************************************************************
C
      NUMASC=4
      NUMAS2=2*NUMASC
      NUMAS3=3*NUMASC
C
C               *******************************
C               **  STEP 1--                 **
C               **  CHECK FOR BLANK ENTRIES  **
C               *******************************
C
      IF(IANS1.EQ.'    '.AND.IANS2.EQ.'    '.AND.IANS3.EQ.'    '.AND.
     1IANS4.EQ.'    ')GOTO105
      GOTO110
  105 CONTINUE
      ANS2=DEF
      IF(AMIN.LE.ANS2.AND.ANS2.LE.AMAX)GOTO9000
      GOTO1750
  110 CONTINUE
C
C               *******************************************************
C               **  STEP 2--                                         **
C               **  DECOMPOSE THE INPUT WORDS                        **
C               **  IANS1, IANS2, IANS3, AND IANS4                   **
C               **  INTO 16 NUMBPC-BIT CHUNKS                        **
C               **  WHERE NUMBPC = NUMBER OF BITS PER CHARACTER      **
C               **  FOR THIS COMPUTER.                               **
C               **  EACH NUMBPC-BIT CHUNK WILL (BY CONSTRUCTION)     **
C               **  BE STORED                                        **
C               **  IN A LEFT-JUSTIFIED FASHION IN IA(.)             **
C               **  WITH (BY CONSTRUCTION) BLANK-FILL TO THE RIGHT.  **
C               *******************************************************
C
      DO150I=1,16
      IA(I)='    '
  150 CONTINUE
      DO200I=1,4
      ISTAR3=NUMBPC*(I-1)
      ISTAR3=IABS(ISTAR3)
      I1=I
      I2=I1+NUMASC
      I3=I1+NUMAS2
      I4=I1+NUMAS3
      CALL DPCHEX(ISTAR3,NUMBPC,IANS1,0,NUMBPC,IA(I1))
      CALL DPCHEX(ISTAR3,NUMBPC,IANS2,0,NUMBPC,IA(I2))
      CALL DPCHEX(ISTAR3,NUMBPC,IANS3,0,NUMBPC,IA(I3))
      CALL DPCHEX(ISTAR3,NUMBPC,IANS4,0,NUMBPC,IA(I4))
  200 CONTINUE
      IF(IBUG1.EQ.'OFF')GOTO350
      DO300I=1,16
      WRITE(ICOUT,305)IA(I)
  305 FORMAT(A4)
      CALL DPWRST('XXX','BUG ')
  300 CONTINUE
  350 CONTINUE
C
C               **********************************************
C               **  STEP 3--                                **
C               **  CHECK FOR AN EXIT, END, STOP, OR TERM.  **
C               **********************************************
C
      DO500I=1,16
      IP1=I+1
      IP2=I+2
      IP3=I+3
      IF(IA(I).EQ.'E'.AND.IA(IP1).EQ.'X'.AND.IA(IP2).EQ.'I'
     1.AND.IA(IP3).EQ.'T')GOTO510
      IF(IA(I).EQ.'E'.AND.IA(IP1).EQ.'N'.AND.IA(IP2).EQ.'D')
     1GOTO510
      IF(IA(I).EQ.'S'.AND.IA(IP1).EQ.'T'.AND.IA(IP2).EQ.'O'
     1.AND.IA(IP3).EQ.'P')GOTO510
      IF(IA(I).EQ.'T'.AND.IA(IP1).EQ.'E'.AND.IA(IP2).EQ.'R'
     1.AND.IA(IP3).EQ.'M')GOTO510
  500 CONTINUE
      GOTO550
  510 WRITE(ICOUT,520)
  520 FORMAT('THIS IS AN EXIT FROM DATAPLOT ')
      CALL DPWRST('XXX','BUG ')
      STOP
  550 CONTINUE
C
C               *********************************
C               **  STEP 4--                   **
C               **  CONVERT TO FLOATING POINT  **
C               *********************************
C
C               ************************************************************
C               **  STEP 4.1--                                            **
C               **  FIRST OF ALL, LOCATE THE DECIMAL POINT (IF EXISTENT)  **
C               ************************************************************
C
      ILOC=0
      IDECPT=0
      DO1000I=1,16
      IF(IA(I).EQ.'.')ILOC=I
      IF(IA(I).EQ.'.')IDECPT=IDECPT+1
 1000 CONTINUE
      IF(IDECPT.GE.2)GOTO1530
      IF(IDECPT.EQ.1)GOTO1150
      DO1100I=1,16
      IREV=16-I+1
      IF(IA(IREV).EQ.' ')GOTO1100
      IF(IA(IREV).EQ.'0')GOTO1110
      IF(IA(IREV).EQ.'1')GOTO1110
      IF(IA(IREV).EQ.'2')GOTO1110
      IF(IA(IREV).EQ.'3')GOTO1110
      IF(IA(IREV).EQ.'4')GOTO1110
      IF(IA(IREV).EQ.'5')GOTO1110
      IF(IA(IREV).EQ.'6')GOTO1110
      IF(IA(IREV).EQ.'7')GOTO1110
      IF(IA(IREV).EQ.'8')GOTO1110
      IF(IA(IREV).EQ.'9')GOTO1110
      IF(IA(IREV).EQ.'+')GOTO1530
      IF(IA(IREV).EQ.'-')GOTO1530
 1100 CONTINUE
      GOTO1530
 1110 ILOC=IREV+1
 1150 CONTINUE
      IF(IBUG2.EQ.'ON')WRITE(ICOUT,1111)ILOC,IDECPT
 1111 FORMAT('ILOC = ',I8,'    IDECPT = ',I8)
      IF(IBUG2.EQ.'ON')CALL DPWRST('XXX','BUG ')
C
C               *******************************************************
C               **  STEP 4.2--                                       **
C               **  SECONDLY, COMPUTE THE INTEGER PART OF THE VALUE  **
C               *******************************************************
C
      SIGN=1.0
      IDIGI=0
      ISIGN=0
      SUMI=0
      ILOCM1=ILOC-1
      IF(ILOCM1.LT.1)GOTO1250
      DO1200I=1,ILOCM1
      IREV=ILOCM1-I+1
      IF(IA(IREV).EQ.' ')GOTO1200
      IF(IA(IREV).EQ.'0')GOTO1210
      IF(IA(IREV).EQ.'1')GOTO1211
      IF(IA(IREV).EQ.'2')GOTO1212
      IF(IA(IREV).EQ.'3')GOTO1213
      IF(IA(IREV).EQ.'4')GOTO1214
      IF(IA(IREV).EQ.'5')GOTO1215
      IF(IA(IREV).EQ.'6')GOTO1216
      IF(IA(IREV).EQ.'7')GOTO1217
      IF(IA(IREV).EQ.'8')GOTO1218
      IF(IA(IREV).EQ.'9')GOTO1219
      IF(IA(IREV).EQ.'+')GOTO1220
      IF(IA(IREV).EQ.'-')GOTO1221
      GOTO1530
 1210 ITERM=0
      GOTO1225
 1211 ITERM=1
      GOTO1225
 1212 ITERM=2
      GOTO1225
 1213 ITERM=3
      GOTO1225
 1214 ITERM=4
      GOTO1225
 1215 ITERM=5
      GOTO1225
 1216 ITERM=6
      GOTO1225
 1217 ITERM=7
      GOTO1225
 1218 ITERM=8
      GOTO1225
 1219 ITERM=9
      GOTO1225
 1220 ISIGN=ISIGN+1
      GOTO1200
 1221 ISIGN=ISIGN+1
      SIGN=-SIGN
      GOTO1200
 1225 IDIGI=IDIGI+1
      TERM=ITERM
      IEXP=IDIGI-1
      SUMI=SUMI+TERM*(10.0**IEXP)
 1200 CONTINUE
 1250 CONTINUE
      IF(ISIGN.GE.2)GOTO1530
      IF(IBUG2.EQ.'ON')WRITE(ICOUT,1255)IDIGI,SUMI
 1255 FORMAT('IDIGI = ',I8,'    SUMI = ',F20.10)
      IF(IBUG2.EQ.'ON')CALL DPWRST('XXX','BUG ')
C
C               ******************************************************
C               **  STEP 4.3--                                      **
C               **  THIRDLY, COMPUTE THE DECIMAL PART OF THE VALUE  **
C               ******************************************************
C
      IDIGD=0
      SUMD=0.0
      ILOCP1=ILOC+1
      IF(ILOCP1.GT.16)GOTO1350
      DO1300I=ILOCP1,16
      IF(IA(I).EQ.' ')GOTO1300
      IF(IA(I).EQ.'0')GOTO1310
      IF(IA(I).EQ.'1')GOTO1311
      IF(IA(I).EQ.'2')GOTO1312
      IF(IA(I).EQ.'3')GOTO1313
      IF(IA(I).EQ.'4')GOTO1314
      IF(IA(I).EQ.'5')GOTO1315
      IF(IA(I).EQ.'6')GOTO1316
      IF(IA(I).EQ.'7')GOTO1317
      IF(IA(I).EQ.'8')GOTO1318
      IF(IA(I).EQ.'9')GOTO1319
      GOTO1530
 1310 ITERM=0
      GOTO1325
 1311 ITERM=1
      GOTO1325
 1312 ITERM=2
      GOTO1325
 1313 ITERM=3
      GOTO1325
 1314 ITERM=4
      GOTO1325
 1315 ITERM=5
      GOTO1325
 1316 ITERM=6
      GOTO1325
 1317 ITERM=7
      GOTO1325
 1318 ITERM=8
      GOTO1325
 1319 ITERM=9
      GOTO1325
 1325 IDIGD=IDIGD+1
      TERM=ITERM
      SUMD=SUMD+TERM/(10.0**IDIGD)
 1300 CONTINUE
 1350 CONTINUE
      IF(IBUG2.EQ.'ON')WRITE(ICOUT,1355)IDIGD,SUMD
 1355 FORMAT('IDIGD = ',I8,'    SUMD = ',F20.10)
      IF(IBUG2.EQ.'ON')CALL DPWRST('XXX','BUG ')
      IDIGT=IDIGI+IDIGD
      IF(IDIGT.LE.0)GOTO1530
      ANS2=SUMI+SUMD
      IF(SIGN.LT.0.0)ANS2=-ANS2
      IF(AMIN.LE.ANS2.AND.ANS2.LE.AMAX)GOTO9000
      GOTO1750
C
 1530 CONTINUE
      WRITE(ICOUT,1531)
 1531 FORMAT('***** ERROR IN ERRORF--LAST ENTRY WAS ',
     1'INVALID ***')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1532)
 1532 FORMAT('      IT SHOULD HAVE BEEN SOME INTEGER OR ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1533)
 1533 FORMAT('      FLOATING POINT NUMBER, BUT WAS NOT.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1534)IANS1,IANS2,IANS3,IANS4
 1534 FORMAT('      THE ENTRY WAS ',4A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1535)
 1535 FORMAT('      REENTER PROPER VALUE NOW--')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 1750 CONTINUE
      WRITE(ICOUT,1531)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1752)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1753)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1754)AMIN,AMAX
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1755)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1734)IANS1,IANS2,IANS3,IANS4
 1734 FORMAT('      THE ENTRY WAS ',4A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1735)
 1735 FORMAT('      REENTER PROPER VALUE NOW--')
      CALL DPWRST('XXX','BUG ')
 1752 FORMAT('      IT SHOULD HAVE BEEN SOME INTEGER OR ')
 1753 FORMAT('      FLOATING POINT NUMBER ')
 1754 FORMAT('      BETWEEN ',E15.7,' AND ',E15.7,' (INCLUSIVE),')
 1755 FORMAT('      BUT WAS NOT.')
      IERROR='YES'
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      RETURN
      END
      subroutine ess(y,n,len,ideg,njump,userw,rw,ys,res)
c
c  This routine is part of the Bill Cleveland seasonal loess
c  program.
c
      integer n, len, ideg, njump, newnj, nleft, nright, nsh, k, i, j
      real y(n), rw(n), ys(n), res(n), delta
      logical ok, userw
      if(.not.(n .lt. 2))goto 23019
      ys(1) = y(1)
      return
23019 continue
      newnj = min0(njump, n-1)
      if(.not.(len .ge. n))goto 23021
      nleft = 1
      nright = n
      do 23023 i = 1,n,newnj 
      call est(y,n,len,ideg,float(i),ys(i),nleft,nright,res,userw,rw,ok)
      if(.not.( .not. ok))goto 23025
      ys(i) = y(i)
23025 continue
23023 continue
      goto 23022
23021 continue
      if(.not.(newnj .eq. 1))goto 23027
      nsh = (len+1)/2
      nleft = 1
      nright = len
      do 23029 i = 1,n 
      if(.not.(i .gt. nsh  .and.  nright .ne. n))goto 23031
      nleft = nleft+1
      nright = nright+1
23031 continue
      call est(y,n,len,ideg,float(i),ys(i),nleft,nright,res,userw,rw,ok)
      if(.not.( .not. ok))goto 23033
      ys(i) = y(i)
23033 continue
23029 continue
      goto 23028
23027 continue
      nsh = (len+1)/2
      do 23035 i = 1,n,newnj 
      if(.not.(i .lt. nsh))goto 23037
      nleft = 1
      nright = len
      goto 23038
23037 continue
      if(.not.(i .ge. n-nsh+1))goto 23039
      nleft = n-len+1
      nright = n
      goto 23040
23039 continue
      nleft = i-nsh+1
      nright = len+i-nsh
23040 continue
23038 continue
      call est(y,n,len,ideg,float(i),ys(i),nleft,nright,res,userw,rw,ok)
      if(.not.( .not. ok))goto 23041
      ys(i) = y(i)
23041 continue
23035 continue
23028 continue
23022 continue
      if(.not.(newnj .ne. 1))goto 23043
      do 23045 i = 1,n-newnj,newnj 
      delta = (ys(i+newnj)-ys(i))/float(newnj)
      do 23047 j = i+1,i+newnj-1
      ys(j) = ys(i)+delta*float(j-i)
23047 continue
23045 continue
      k = ((n-1)/newnj)*newnj+1
      if(.not.(k .ne. n))goto 23049
      call est(y,n,len,ideg,float(n),ys(n),nleft,nright,res,userw,rw,ok)
      if(.not.( .not. ok))goto 23051
      ys(n) = y(n)
23051 continue
      if(.not.(k .ne. n-1))goto 23053
      delta = (ys(n)-ys(k))/float(n-k)
      do 23055 j = k+1,n-1
      ys(j) = ys(k)+delta*float(j-k)
23055 continue
23053 continue
23049 continue
23043 continue
      return
      end
      subroutine est(y,n,len,ideg,xs,ys,nleft,nright,w,userw,rw,ok)
c
c  This routine is part of the Bill Cleveland seasonal loess
c  program.
c
      integer n, len, ideg, nleft, nright, j
      real y(n), w(n), rw(n), xs, ys, range, h, h1, h9, a, b, c, r
      logical userw,ok
      range = float(n)-float(1)
      h = amax1(xs-float(nleft),float(nright)-xs)
      if(.not.(len .gt. n))goto 23057
      h = h+float((len-n)/2)
23057 continue
      h9 = .999*h
      h1 = .001*h
      a = 0.0
      do 23059 j = nleft,nright 
      w(j) = 0.
      r = abs(float(j)-xs)
      if(.not.(r .le. h9))goto 23061
      if(.not.(r .le. h1))goto 23063
      w(j) = 1.
      goto 23064
23063 continue
      w(j) = (1.0-(r/h)**3)**3
23064 continue
      if(.not.(userw))goto 23065
      w(j) = rw(j)*w(j)
23065 continue
      a = a+w(j)
23061 continue
23059 continue
      if(.not.(a .le. 0.0))goto 23067
      ok = .false.
      goto 23068
23067 continue
      ok = .true.
      do 23069 j = nleft,nright
      w(j) = w(j)/a
23069 continue
      if(.not.((h .gt. 0.) .and. (ideg .gt. 0)))goto 23071
      a = 0.0
      do 23073 j = nleft,nright
      a = a+w(j)*float(j)
23073 continue
      b = xs-a
      c = 0.0
      do 23075 j = nleft,nright
      c = c+w(j)*(float(j)-a)**2
23075 continue
      if(.not.(sqrt(c) .gt. .001*range))goto 23077
      b = b/c
      do 23079 j = nleft,nright
      w(j) = w(j)*(b*(float(j)-a)+1.0)
23079 continue
23077 continue
23071 continue
      ys = 0.0
      do 23081 j = nleft,nright
      ys = ys+w(j)*y(j)
23081 continue
23068 continue
      return
      end
      SUBROUTINE EV1CDF(X,MINMAX,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE EXTREME VALUE TYPE 1
C              DISTRIBUTION.
C              THE EXTREME VALUE TYPE 1 DISTRIBUTION USED
C              HEREIN HAS MEAN = EULER'S NUMBER = 0.57721566
C              AND STANDARD DEVIATION = PI/SQRT(6) = 1.28254983.
C              THIS DISTRIBUTION IS DEFINED FOR ALL X
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              FOR THE MAXIMUM ORDER STATISTIC
C              F(X) = (EXP(-X)) * (EXP(-(EXP(-X))))
C              WHICH SIMPLIFIES TO:
C              F(X) = EXP(-X - EXP(-X))
C              FOR THE MINIMUIM ORDER STATISTIC
C              F(X) = (EXP(X)) * (EXP(-(EXP(X))))
C              WHICH SIMPLIFIES TO:
C              F(X) = EXP(X-EXP(X))
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE CUMULATIVE DISTRIBUTION 
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--CDF    = THE SINGLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE EXTREME VALUE TYPE 1
C             DISTRIBUTION WITH MEAN = EULER'S NUMBER = 0.57721566
C             AND STANDARD DEVIATION = PI/SQRT(6) = 1.28254983.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 272-295.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-921-2315
C     ORIGINAL VERSION--APRIL     1994. 
C     UPDATED         --JULY      2005. CODE IN DOUBLE PRECIONS FOR
C                                       BETTER ACCURACY
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DCDF
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS.
C     NO INPUT ARGUMENT ERRORS POSSIBLE 
C     FOR THIS DISTRIBUTION.
C
C-----START POINT-----------------------------------------------------
C
      DX=DBLE(X)
      IF(MINMAX.EQ.1)THEN
        DCDF=1.0D0-DEXP(-(DEXP(DX))) 
      ELSEIF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        DCDF=DEXP(-(DEXP(-DX))) 
      ELSE
         WRITE(ICOUT,1800)
 1800    FORMAT('*****ERROR IN EV1CDF--MINMAX NOT 1 OR 2')
         CALL DPWRST('XXX','BUG ')
      END IF
      CDF=REAL(DCDF)
C
      RETURN
      END 
      SUBROUTINE EV1CDD(X,MINMAX,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE EXTREME VALUE TYPE 1
C              DISTRIBUTION.
C              THE EXTREME VALUE TYPE 1 DISTRIBUTION USED
C              HEREIN HAS MEAN = EULER'S NUMBER = 0.57721566
C              AND STANDARD DEVIATION = PI/SQRT(6) = 1.28254983.
C              THIS DISTRIBUTION IS DEFINED FOR ALL X
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              FOR THE MAXIMUM ORDER STATISTIC
C              F(X) = (EXP(-X)) * (EXP(-(EXP(-X))))
C              WHICH SIMPLIFIES TO:
C              F(X) = EXP(-X - EXP(-X))
C              FOR THE MINIMUIM ORDER STATISTIC
C              F(X) = (EXP(X)) * (EXP(-(EXP(X))))
C              WHICH SIMPLIFIES TO:
C              F(X) = EXP(X-EXP(X))
C     NOTE  --THIS IS A DOUBLE PRECISION VERSION OF EV1CDF USED
C             IN CALCULATING HAZARD FUNCTIONS.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE CUMULATIVE DISTRIBUTION 
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--CDF    = THE SINGLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE EXTREME VALUE TYPE 1
C             DISTRIBUTION WITH MEAN = EULER'S NUMBER = 0.57721566
C             AND STANDARD DEVIATION = PI/SQRT(6) = 1.28254983.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 272-295.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-921-2315
C     ORIGINAL VERSION--APRIL     1994. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DOUBLE PRECISION X
      DOUBLE PRECISION CDF
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS.
C     NO INPUT ARGUMENT ERRORS POSSIBLE 
C     FOR THIS DISTRIBUTION.
C
C-----START POINT-----------------------------------------------------
C
      IF(MINMAX.EQ.1)THEN
        CDF=1.0D0-DEXP(-(DEXP(X))) 
      ELSEIF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        CDF=DEXP(-(DEXP(-X))) 
      ELSE
         WRITE(ICOUT,1800)
 1800    FORMAT('*****ERROR IN EV1CDF--MINMAX NOT 1 OR 2')
         CALL DPWRST('XXX','BUG ')
      END IF
C
      RETURN
      END 
      SUBROUTINE EV1CHA(X,MINMAX,HAZ)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE HAZARD
C              FUNCTION VALUE FOR THE EXTREME VALUE TYPE 1
C              DISTRIBUTION.
C              THE EXTREME VALUE TYPE 1 DISTRIBUTION USED
C              HEREIN HAS MEAN = EULER'S NUMBER = 0.57721566
C              AND STANDARD DEVIATION = PI/SQRT(6) = 1.28254983.
C              THIS DISTRIBUTION IS DEFINED FOR ALL X
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              FOR THE MAXIMUM ORDER STATISTIC
C              F(X) = (EXP(-X)) * (EXP(-(EXP(-X))))
C              WHICH SIMPLIFIES TO:
C              F(X) = EXP(-X - EXP(-X))
C              FOR THE MINIMUIM ORDER STATISTIC
C              F(X) = (EXP(X)) * (EXP(-(EXP(X))))
C              WHICH SIMPLIFIES TO:
C              F(X) = EXP(-X - EXP(-X))
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE CUMULATIVE DISTRIBUTION 
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--HAZ    = THE SINGLE PRECISION CUMULATIVE HAZARD
C                                FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE HAZARD
C             FUNCTION VALUE FOR THE EXTREME VALUE TYPE 1
C             DISTRIBUTION WITH MEAN = EULER'S NUMBER = 0.57721566
C             AND STANDARD DEVIATION = PI/SQRT(6) = 1.28254983.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 272-295.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-975-2899
C     ORIGINAL VERSION--APRIL     1998. 
C     UPDATED         --JUNE      1999. SIMPLIFY FORMULAS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
CCCCC DOUBLE PRECISION CDF
      DOUBLE PRECISION DX
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS.
C     NO INPUT ARGUMENT ERRORS POSSIBLE 
C     FOR THIS DISTRIBUTION.
C
C-----START POINT-----------------------------------------------------
C
      IF(MINMAX.EQ.1)THEN
        HAZ=EXP(X)
CCCCC   CALL EV1CDD(DBLE(X),MINMAX,CDF)
CCCCC   IF(1.0D0-CDF.LE.0.0D0)THEN
CCCCC     WRITE(ICOUT,1100)
C1100     FORMAT('*****ERROR IN EV1CHA--CDF ESSENTIALLY 1.')
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC   ELSE
CCCCC     HAZ=REAL(-DLOG(1.0D0-CDF))
CCCCC   ENDIF
      ELSEIF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        DX=DBLE(X)
        DTERM1=DEXP(-DEXP(-DX))
        DTERM2=1.0D0-DTERM1
        IF(DTERM2.GT.0.0D0)THEN
          HAZ=REAL(-DLOG(DTERM2))
        ELSE
          WRITE(ICOUT,1100)
          CALL DPWRST('XXX','BUG ')
          HAZ=0.0
        ENDIF
 1100   FORMAT('*****ERROR IN EV1CHA--UNABLE TO COMPUTE CUMULATIVE',
     1         'HAZARD FUNCTION.')
CCCCC   CALL EV1CDD(DBLE(X),MINMAX,CDF)
CCCCC   IF(1.0D0-CDF.LE.0.0D0)THEN
CCCCC     WRITE(ICOUT,1100)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC   ELSE
CCCCC     HAZ=REAL(-DLOG(1.0D0-CDF))
CCCCC   ENDIF
      ELSE
        HAZ=0.0
        WRITE(ICOUT,1800)
 1800   FORMAT('*****ERROR IN EV1CHA--MINMAX NOT 1 OR 2')
        CALL DPWRST('XXX','BUG ')
      END IF
C
      RETURN
      END 
      SUBROUTINE EV1EST(X,NOBS,ALOC,SCALE,ALOC2,SCALE2,MINMAX,IERROR)
C
C  COMPUTE MLES FOR SCALE PARAMETER (SCALE) AND LOCATION
C  PARAMETER (ALOC) BY SOLVING THE EQUATION
C     G(SCALE)=0, WHERE G IS
C  A MONOTONICALLY INCREASING FUNCTION OF SCALE.
C  THE INITIAL ESTIMATE IS THE METHOD OF MOMENTS ESTIMATOR
C  AND THE TOLERANCE IS   :   2*RI/(10**6).
C
      DIMENSION X(*)
C
      REAL GFM, GFM2
      REAL SCALEL, SCALEH, SCALEM
      REAL TOL
C
      CHARACTER*4 IBUGA3
      CHARACTER*4 IWRITE
      CHARACTER*4 IERROR
C
      IERROR='NO'
      RN=REAL(NOBS)
C
C  USE METHOD OF MOMENTS TO GET INITAL ESTIMATES OF LOCATION AND SCALE
C
      IBUGA3='OFF'
      IWRITE='OFF'
      CALL MEAN(X,NOBS,IWRITE,XMEAN,IBUGA3,IERROR)
      CALL SD(X,NOBS,IWRITE,XSD,IBUGA3,IERROR)
      SCALEM=SQRT(1.645)*XSD
      IF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        ALOCM=XMEAN-0.5772*XSD
      ELSE
        ALOCM=XMEAN+0.5772*XSD
      ENDIF
      ALOC2=ALOCM
      SCALE2=SCALEM
C
      TOL=2.0*.000001*SCALEM
      CALL EV1FUN(X,NOBS,XMEAN,ALOCM,SCALEM,GFM,MINMAX)
C
C  IF G(SCALEM) .GE. 0, DIVIDE THE INITIAL ESTIMATE BY 2 UNTIL
C  THE ROOT IS BRACKETED BY SCALEL AND SCALEH.
C
      IF(GFM.GE.0.0D0)THEN
           SCALEH=SCALEM/2.0
           CALL EV1FUN(X,NOBS,XMEAN,ALOCM,SCALEM,GFM2,MINMAX)
           DCONST=2.0
           IF(GFM2.GT.GFM)DCONST=0.5
           DO 3 J=1,200
                SCALEH=SCALEM
                SCALEM=SCALEM/DCONST
                CALL EV1FUN(X,NOBS,XMEAN,ALOCM,SCALEM,GFM,MINMAX)
                IF(GFM.LE.0.0)GO TO 4
    3      CONTINUE
           IERROR='YES'
           GOTO9999
    4      CONTINUE
           SCALEL=SCALEM
C
C  IF G(SCALEM) .LT. 0, MULTIPLY THE INITIAL ESTIMATE BY 2 UNTIL
C  THE ROOT IS BRACKETED BY SCALEL AND SCALEH.
      ELSEIF(GFM.LT.0.0)THEN
           SCALEH=SCALEM/2.0
           CALL EV1FUN(X,NOBS,XMEAN,ALOCM,SCALEM,GFM2,MINMAX)
           DCONST=2.0
           IF(GFM2.LT.GFM)DCONST=0.5
           DO 7 J=1,2000
                SCALEL=SCALEM
                SCALEM=SCALEM*DCONST
                CALL EV1FUN(X,NOBS,XMEAN,ALOCM,SCALEM,GFM,MINMAX)
                IF(GFM.GE.0.0D0)GO TO 8
    7      CONTINUE
           IERROR='YES'
           GOTO9999
    8      CONTINUE
           SCALEH=SCALEM
      ENDIF
C
C SOLVE THE EQUATION G(SCALE)=0 FOR SCALE BY BISECTING THE
C   INTERVAL (SCALEL,SCALEH) UNTIL THE TOLERANCE IS MET
      MAXIT=20000
      NIT=0
   10 CONTINUE
      SCALEM=(SCALEL+SCALEH)/2.0
      CALL EV1FUN(X,NOBS,XMEAN,ALOCM,SCALEM,GFM,MINMAX)
      IF(GFM.GE.0.0)THEN
           SCALEH=SCALEM
      ENDIF
      IF(GFM.LT.0.0)THEN
           SCALEL=SCALEM
      ENDIF
      NIT=NIT+1
C
      IF(NIT.GT.MAXIT)THEN
        IERROR='YES'
        SCALE=(SCALEL+SCALEH)/2.0
        ALOC=ALOCM
        GOTO9999
      ENDIF
C
      IF(SCALEH-SCALEL.GT.TOL)GO TO 10
C
      SCALE=(SCALEL+SCALEH)/2.0
      ALOC=ALOCM
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE EV1FUN(X,N,XMEAN,ALOC,SCALE,EV1VAL,MINMAX)
C
C   COMPUTE G FUNCTION USED IN ESTIMATING THE SHAPE AND SCALE
C   PARAMETERS FOR EV1 DISTRIBUTION.
C
      DOUBLE PRECISION DN, DSUM1, DSUM2, DTERM1, DX, DSCALE
      DIMENSION X(*)
C
C  CALCULATE SOME INTERMEDIATE VALUES
C
      IF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        DN=DBLE(N)
        DSCALE=DBLE(SCALE)
        DSUM1=0.0
        DSUM2=0.0
        DO100I=1,N
          DX=DBLE(X(I))
          DSUM1=DSUM1 + DEXP(-DX/DSCALE)
          DSUM2=DSUM2 + DX*DEXP(-DX/DSCALE)
  100   CONTINUE
C
        ALOC=-SCALE*DLOG(DSUM1/DN)
C
        DTERM1=DBLE(XMEAN) - DSUM2/DSUM1
        EV1VAL=SCALE - REAL(DTERM1)
C
      ELSE
        DN=DBLE(N)
        DSCALE=DBLE(SCALE)
        DSUM1=0.0
        DSUM2=0.0
        DO200I=1,N
          DX=DBLE(X(I))
          DSUM1=DSUM1 + DEXP(DX/DSCALE)
          DSUM2=DSUM2 + DX*DEXP(DX/DSCALE)
  200   CONTINUE
C
        ALOC=SCALE*DLOG(DSUM1/DN)
C
        DTERM1=-DBLE(XMEAN) + DSUM2/DSUM1
        EV1VAL=SCALE - REAL(DTERM1)
C
      ENDIF
      RETURN
      END
      DOUBLE PRECISION FUNCTION EV1FU2 (SHAT,X)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE MAXIMUM LIKELIHOOD
C              ESTIMATE OF THE SCALE PARAMETER FOR THE GUMBEL
C              MODEL FOR FULL SAMPLE DATA (NO CENSORING).  THIS
C              FUNCTION FINDS THE ROOT OF THE EQUATION:
C
C              FOR THE MAXIMUM CASE:
C
C                 SHAT - XBAR + SUM[i=1 to N][X(I)*EXP(-X(I)/SHAT)]/
C                        SUM[i=1 to N][EXP(-X(I)/SHAT)] = 0
C
C              FOR THE MINIMUM CASE:
C
C                 SHAT - XBAR + SUM[i=1 to N][X(I)*EXP(X(I)/SHAT)]/
C                        SUM[i=1 to N][EXP(X(I)/SHAT)] = 0
C
C              WITH
C
C                 SHAT     = CURRENT ESTIMATE OF SCALE PARAMETER
C                 XBAR     = SAMPLE MEAN
C                 N        = SAMPLE SIZE
C                 MINMAX   = SPECIFY WHETHER MAXIMUM OR MINIMUM
C                            CASE IS BEING ESTIMATED
C
C              CALLED BY DFZER2 ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.
C     EXAMPLE--GUMBEL MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 15.
C              --JOHNSON, KOTZ, AND BALAKRISNAN, "CONTINUOUS
C                UNIVARIATE DISTRIBUTIONS--VOLUME 1", SECOND EDITION,
C                WILEY, 1994, CHAPTER xx.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/12
C     ORIGINAL VERSION--DECEMBER   2004.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION SHAT
      DOUBLE PRECISION X(*)
C
      INTEGER N 
      DOUBLE PRECISION XBAR
      COMMON/EV1CO2/XBAR,MINMAX,N
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  COMPUTE SOME SUMS
C
      DSUM1=0.0D0
      DSUM2=0.0D0
C
      IF(MINMAX.EQ.2)THEN
        DO100I=1,N
          DSUM1=DSUM1 + X(I)*DEXP(-X(I)/SHAT)
          DSUM2=DSUM2 + DEXP(-X(I)/SHAT)
  100   CONTINUE
        EV1FU2=SHAT - XBAR + DSUM1/DSUM2
      ELSE
        DO200I=1,N
          DSUM1=DSUM1 + X(I)*DEXP(X(I)/SHAT)
          DSUM2=DSUM2 + DEXP(X(I)/SHAT)
  200   CONTINUE
        EV1FU2=SHAT + XBAR - DSUM1/DSUM2
      ENDIF
C
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION EV1FU3 (SHAT,X)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE LIKELIHOOD RATIO
C              BASED CONFIDECE INTERVALS FOR THE LOCATION AND SCALE
C              PARAMETERS OF A GUMBEL DISTRIBUTION.
C              THIS FUNCTION FINDS THE ROOT OF THE EQUATION:
C
C                 2*LL(MU,SIGMA) - 2*LL(M(sigma),sigma)
C                                - CHSPPF(alpha,1)
C
C              WITH
C
C                 LL(MU,SIGMA) = -N*LOG(SIGMA) - N*XBAR/SIGMA +
C                                N*MU/SIGMA -
C                                SUM[i=1 to N][EXP(-(X(I)-MU)/SIGMA)]
C
C              GIVEN CURRENT VALUE OF SIGMA (= SHAT),
C
C                 MU(SIGMA) = -SIGMA*LOG(SUM[i=1 to N][EXP(-X(I)/SIGMA)]/N]
C
C              CALLED BY DFZER2 ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.
C     EXAMPLE--GUMBEL MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 15.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/12
C     ORIGINAL VERSION--DECEMBER   2004.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION SHAT
      DOUBLE PRECISION X(*)
C
      INTEGER N 
      DOUBLE PRECISION XBAR
      COMMON/EV1CO2/XBAR,MINMAX,N
      DOUBLE PRECISION DK, DLLUS
      COMMON/EV1CO3/DK, DLLUS
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DMU
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DSUM1
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C
C  GIVEN SIGMA, COMPUTE ESTIMATE OF MU
C
      DSUM1=0.0D0
      DN=DBLE(N)
C
      IF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        DO100I=1,N
          DSUM1=DSUM1 + DEXP(-X(I)/SHAT)
  100   CONTINUE
        DMU=-SHAT*DLOG(DSUM1/DN)
      ELSE
        DO200I=1,N
          DSUM1=DSUM1 + DEXP(X(I)/SHAT)
  200   CONTINUE
        DMU=SHAT*DLOG(DSUM1/DN)
      ENDIF
C
C  COMPUTE SOME SUMS
C
      DSUM1=0.0D0
C
      IF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        DO300I=1,N
          DSUM1=DSUM1 + DEXP(-(X(I) - DMU)/SHAT)
  300   CONTINUE
        DTERM1=-DN*DLOG(SHAT) - DN*XBAR/SHAT + DN*DMU/SHAT - DSUM1
      ELSE
        DO400I=1,N
          DSUM1=DSUM1 + DEXP((X(I) + DMU)/SHAT)
  400   CONTINUE
        DTERM1=-DN*DLOG(SHAT) - DN*XBAR/SHAT + DN*DMU/SHAT - DSUM1
      ENDIF
C
      EV1FU3=2.0D0*DLLUS - 2.0D0*DTERM1 - DK
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION EV1FU4 (DMU,X)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE LIKELIHOOD RATIO
C              BASED CONFIDECE INTERVALS FOR THE LOCATION AND SCALE
C              PARAMETERS OF A GUMBEL DISTRIBUTION.
C              THIS FUNCTION FINDS THE ROOT OF THE EQUATION:
C
C                 2*LL(MU,SIGMA) - 2*LL(mu,sigma(mu))
C                                - CHSPPF(alpha,1)
C
C              WITH
C
C                 LL(MU,SIGMA) = -N*LOG(SIGMA) - N*XBAR/SIGMA +
C                                N*MU/SIGMA -
C                                SUM[i=1 to N][EXP(-(X(I)-MU)/SIGMA)]
C
C              GIVEN CURRENT VALUE OF MU (= DMU), SIGMA IS ROOT OF:
C
C                 SIGMA + MU +
C                 SUM[i=1 to n][X(I)*EXP(-(X(I)-MU)/SIGMA]/N - 
C                 MU*SUM[i=1 to n][EXP(-(X(I)-MU)/SIGMA]/N -  XBAR
C
C              CALLED BY DFZER2 ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.
C     EXAMPLE--GUMBEL MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 15.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/12
C     ORIGINAL VERSION--DECEMBER   2004.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DMU
      DOUBLE PRECISION X(*)
C
      INTEGER N 
      DOUBLE PRECISION XBAR
      COMMON/EV1CO2/XBAR,MINMAX,N
      DOUBLE PRECISION DLLUS
      DOUBLE PRECISION DK
      COMMON/EV1CO3/DK, DLLUS
      DOUBLE PRECISION SHAT
      COMMON/EV1CO4/SHAT
      DOUBLE PRECISION DMU2
      COMMON/EV1CO5/DMU2
      DOUBLE PRECISION EV1FU5
      EXTERNAL EV1FU5
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION AE
      DOUBLE PRECISION RE
      DOUBLE PRECISION XLOW
      DOUBLE PRECISION XUP
      DOUBLE PRECISION XSTRT
      DOUBLE PRECISION SHAT2
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  STEP 1: GIVEN VALUE OF LOCATION PARAMETER (MU), NEED TO COMPUTE
C          THE SCALE PARAMETER (WHICH IN TURN INVOLVES FINDING A
C          ROOT).
C
      DMU2=DMU
C
      AE=1.D-7
      RE=1.D-7
      XSTRT=SHAT
      XLOW=XSTRT/2.0D0
      XUP=XSTRT*2.0D0
      CALL DFZER3(EV1FU5,XLOW,XUP,XSTRT,RE,AE,IFLAG,X)
      SHAT2=XLOW
C
      DSUM1=0.0D0
      DN=DBLE(N)
C
C  COMPUTE SOME SUMS
C
      DSUM1=0.0D0
C
      IF(MINMAX.EQ.2 .OR. MINMAX.EQ.2)THEN
        DO300I=1,N
          DSUM1=DSUM1 + DEXP(-(X(I) - DMU)/SHAT2)
  300   CONTINUE
        DTERM1=-DN*DLOG(SHAT2) - DN*XBAR/SHAT2 + DN*DMU/SHAT2 - DSUM1
      ELSE
        DO400I=1,N
          DSUM1=DSUM1 + DEXP((X(I) + DMU)/SHAT2)
  400   CONTINUE
        DTERM1=-DN*DLOG(SHAT2) - DN*XBAR/SHAT2 + DN*DMU/SHAT2 - DSUM1
      ENDIF
C
      EV1FU4=2.0D0*DLLUS - 2.0D0*DTERM1 - DK
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION EV1FU5 (SHAT,X)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE LIKELIHOOD RATIO
C              BASED CONFIDECE INTERVALS FOR THE LOCATION AND SCALE
C              PARAMETERS OF A GUMBEL DISTRIBUTION.
C              THIS CONFIDENCE INTERVAL IS THE ROOT OF THE EQUATION
C
C                 2*LL(MU,SIGMA) - 2*LL(mu,sigma(mu))
C                                - CHSPPF(alpha,1)
C
C              WITH
C
C                 LL(MU,SIGMA) = -N*LOG(SIGMA) - N*XBAR/SIGMA +
C                                N*MU/SIGMA -
C                                SUM[i=1 to N][EXP(-(X(I)-MU)/SIGMA)]
C
C              GIVEN CURRENT VALUE OF MU (= DMU), SIGMA IS ROOT OF:
C
C                 SIGMA + MU +
C                 SUM[i=1 to n][X(I)*EXP(-(X(I)-MU)/SIGMA]/N - 
C                 MU*SUM[i=1 to n][EXP(-(X(I)-MU)/SIGMA]/N -  XBAR
C
C              EV1FU5 IS USED IN SOLVING FOR THE VALUE OF SIGMA
C              GIVEN MU.
C
C              CALLED BY DFZER3 ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.
C     EXAMPLE--GUMBEL MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 15.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/12
C     ORIGINAL VERSION--DECEMBER   2004.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION SHAT
      DOUBLE PRECISION X(*)
C
      INTEGER N 
      DOUBLE PRECISION XBAR
      COMMON/EV1CO2/XBAR,MINMAX,N
      DOUBLE PRECISION DMU
      COMMON/EV1CO5/DMU
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C
C  GIVEN MU, FIND ROOT FOR SIGMA
C
      DSUM1=0.0D0
      DSUM2=0.0D0
      DN=DBLE(N)
C
      IF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        DO100I=1,N
          DSUM1=DSUM1 + X(I)*DEXP(-(X(I)-DMU)/SHAT)
          DSUM2=DSUM2 + DEXP(-(X(I)-DMU)/SHAT)
  100   CONTINUE
        EV1FU5=SHAT + DMU + DSUM1/DN - DMU*DSUM2/DN - XBAR
      ELSE
        DO200I=1,N
          DSUM1=DSUM1 + X(I)*DEXP((X(I)+DMU)/SHAT)
          DSUM2=DSUM2 + DEXP((X(I)+DMU)/SHAT)
  200   CONTINUE
        EV1FU5=SHAT + DMU + DSUM1/DN - DMU*DSUM2/DN - XBAR
      ENDIF
C
C  COMPUTE SOME SUMS
C
C
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION EV1FU6 (DPPF,X)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE LIKELIHOOD RATIO
C              BASED CONFIDECE INTERVALS FOR THE LOCATION AND SCALE
C              PARAMETERS OF A GUMBEL DISTRIBUTION.
C              THIS FUNCTION FINDS THE ROOT OF THE EQUATION:
C
C                 2*LL(MU,SIGMA) - 2*LL(mu(Q),S1(Q)
C                                - CHSPPF(alpha,1)
C
C              WITH
C
C                 LL(MU,SIGMA) = -N*LOG(SIGMA) - N*XBAR/SIGMA +
C                                N*MU/SIGMA -
C                                SUM[i=1 to N][EXP(-(X(I)-MU)/SIGMA)]
C
C              GIVEN A VALUE OF Q, EV1FU6 IS CALLED TO DETERMINE A
C              VALUE OF SIGMA.  THEN THE FOLLOWING IS USED TO
C              FIND THE VALUE OF M.
C
C                 MU = Q + LN(LN(1/q))*SHAT
C
C              CALLED BY DFZER2 ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.
C     EXAMPLE--GUMBEL MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 15.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/12
C     ORIGINAL VERSION--DECEMBER   2004.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DPPF
      DOUBLE PRECISION X(*)
C
      DOUBLE PRECISION EV1FU7
      EXTERNAL EV1FU7
C
      INTEGER N 
      DOUBLE PRECISION XBAR
      COMMON/EV1CO2/XBAR,MINMAX,N
      DOUBLE PRECISION DLLUS
      DOUBLE PRECISION DK
      COMMON/EV1CO3/DK, DLLUS
      DOUBLE PRECISION DQ
      DOUBLE PRECISION SHATML
      COMMON/EV1CO6/DQ,SHATML
      DOUBLE PRECISION DQ2
      DOUBLE PRECISION DPPF2
      COMMON/EV1CO7/DQ2,DPPF2
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DMU
      DOUBLE PRECISION SHAT2
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION AE
      DOUBLE PRECISION RE
      DOUBLE PRECISION XLOW
      DOUBLE PRECISION XUP
      DOUBLE PRECISION XSTRT
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  STEP 1: GIVEN VALUE OF Q, NEED TO COMPUTE
C          THE SCALE PARAMETER (WHICH IN TURN INVOLVES FINDING A
C          ROOT).
C
      DQ2=DQ
      DPPF2=DPPF
C
      AE=1.D-7
      RE=1.D-7
      XSTRT=SHATML
      XLOW=XSTRT/5.0D0
      XUP=XSTRT*5.0D0
      CALL DFZER3(EV1FU7,XLOW,XUP,XSTRT,RE,AE,IFLAG,X)
      SHAT2=XLOW
C
C  STEP 2: NOW COMPUTE VALUE OF MU
C
      DMU=DPPF + DLOG(DLOG(1.0D0/DQ))*SHAT2
C
C  COMPUTE SOME SUMS
C
      DN=DBLE(N)
      DSUM1=0.0D0
C
      IF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        DO300I=1,N
          DSUM1=DSUM1 + DEXP(-(X(I) - DMU)/SHAT2)
  300   CONTINUE
        DTERM1=-DN*DLOG(SHAT2) - DN*XBAR/SHAT2 + DN*DMU/SHAT2 - DSUM1
      ELSE
        DO400I=1,N
          DSUM1=DSUM1 + DEXP((X(I) + DMU)/SHAT2)
  400   CONTINUE
        DTERM1=-DN*DLOG(SHAT2) - DN*XBAR/SHAT2 + DN*DMU/SHAT2 - DSUM1
      ENDIF
C
      EV1FU6=2.0D0*DLLUS - 2.0D0*DTERM1 - DK
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION EV1FU7 (SHAT,X)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE LIKELIHOOD RATIO
C              BASED CONFIDECE INTERVALS FOR A PERCENTILE OF THE
C              GUMBEL DISTRIBUTION.  THIS FUNCTION FINDS THE ROOT
C              OF THE EQUATION:
C
C              (N/SIGMA)*{(XBAR - Q)/SIGMA + (LOG(q)/N)*
C              SUM[i=1 to N][EXP(-(X(I)-Q)/SIGMA)*(X(I)-Q)/SIGMA)] - 1
C
C              WITH
C
C                 q       = DESIRED PERCENTILE (E.G., 0.95) (DQ IN CODE)
C                 Q       = POINT ESTIMATE OF PERCENTILE (EV1PPF(q) =
C                           DPPF IN CODE)
C
C              EV1FU7 IS USED IN SOLVING FOR THE VALUE OF SIGMA
C              GIVEN q AND Q.
C
C              CALLED BY DFZER3 ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.
C     EXAMPLE--GUMBEL MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 15.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/12
C     ORIGINAL VERSION--DECEMBER   2004.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION SHAT
      DOUBLE PRECISION X(*)
C
      INTEGER N 
      DOUBLE PRECISION XBAR
      COMMON/EV1CO2/XBAR,MINMAX,N
      DOUBLE PRECISION DQ
      DOUBLE PRECISION DPPF
      COMMON/EV1CO7/DQ,DPPF
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DTERM1
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C
C  GIVEN MU, FIND ROOT FOR SIGMA
C
      DSUM1=0.0D0
      DN=DBLE(N)
      DTERM1=(XBAR-DPPF)/SHAT
C
      IF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        DO100I=1,N
          DSUM1=DSUM1 + ((X(I)-DPPF)/SHAT)*DEXP(-(X(I)-DPPF)/SHAT)
  100   CONTINUE
      ELSE
        DO200I=1,N
          DSUM1=DSUM1 + ((X(I)-DPPF)/SHAT)*DEXP((X(I)-DPPF)/SHAT)
  200   CONTINUE
      ENDIF
C
      EV1FU7=(DN/SHAT)*(DTERM1 + (DLOG(DQ)/DN)*DSUM1 - 1.0D0)
C
      RETURN
      END
      SUBROUTINE EV1HAZ(X,MINMAX,HAZ)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE HAZARD
C              FUNCTION VALUE FOR THE EXTREME VALUE TYPE 1
C              DISTRIBUTION.
C              THE EXTREME VALUE TYPE 1 DISTRIBUTION USED
C              HEREIN HAS MEAN = EULER'S NUMBER = 0.57721566
C              AND STANDARD DEVIATION = PI/SQRT(6) = 1.28254983.
C              THIS DISTRIBUTION IS DEFINED FOR ALL X
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              FOR THE MAXIMUM ORDER STATISTIC
C              F(X) = (EXP(-X)) * (EXP(-(EXP(-X))))
C              WHICH SIMPLIFIES TO:
C              F(X) = EXP(-X - EXP(-X))
C              FOR THE MINIMUIM ORDER STATISTIC
C              F(X) = (EXP(X)) * (EXP(-(EXP(X))))
C              WHICH SIMPLIFIES TO:
C              F(X) = EXP(-X - EXP(-X))
C              THE HAZARD FUNCTION IS:
C              EXP(-X)/(EXP(EXP(-X)-1))
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE CUMULATIVE DISTRIBUTION 
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--HAZ    = THE SINGLE PRECISION HAZARD
C                                FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION HAZARD
C             FUNCTION VALUE FOR THE EXTREME VALUE TYPE 1
C             DISTRIBUTION WITH MEAN = EULER'S NUMBER = 0.57721566
C             AND STANDARD DEVIATION = PI/SQRT(6) = 1.28254983.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 272-295.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-975-2899
C     ORIGINAL VERSION--APRIL     1998. 
C     UPDATED         --JUNE      1999. USE SIMPLIFIED FORMULA FOR
C                                       MINIMUM CASE.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DOUBLE PRECISION DX
CCCCC DOUBLE PRECISION DCDF
CCCCC DOUBLE PRECISION DPDF
      DOUBLE PRECISION DHAZ
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOMC.INC'
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS.
C     NO INPUT ARGUMENT ERRORS POSSIBLE 
C     FOR THIS DISTRIBUTION.
C
C-----START POINT-----------------------------------------------------
C
      IF(MINMAX.EQ.1)THEN
        IF(X.LE.REAL(I1MACH(15)))THEN
          HAZ=0.0
        ELSEIF(X.LE.REAL(I1MACH(16)))THEN
          HAZ=EXP(X)
        ELSE
          HAZ=0.0
          WRITE(ICOUT,1700)
          CALL DPWRST('XXX','BUG ')
        ENDIF
CCCCC   DX=DBLE(X)
CCCCC   CALL EV1CDD(DX,MINMAX,DCDF)
CCCCC   DCDF=1.0D0-DCDF
CCCCC   IF(DCDF.NE.0.0D0)THEN
CCCCC     DPDF=DEXP(DX-DEXP(DX))
CCCCC     DHAZ=DPDF/DCDF
CCCCC     HAZ=REAL(DHAZ)
CCCCC   ELSE
CCCCC     WRITE(ICOUT,1600)
C1600     FORMAT('*****ERROR IN EV1HAZ--CDF ESSENTIALLY 1.')
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC   ENDIF
      ELSEIF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        DX=DBLE(-X)
CCCCC   DTERM1=DEXP(DX)-1.0D0
CCCCC   DHAZ=DEXP(DX-DTERM1)
        DTERM1=DEXP(DX)
        DTERM2=DEXP(DEXP(DX))-1.0D0
        IF(DTERM2.NE.0.0D0)THEN
          DHAZ=DTERM1/DTERM2
          HAZ=REAL(DHAZ)
        ELSE
          HAZ=0.0
          WRITE(ICOUT,1700)
 1700     FORMAT('*****ERROR IN EV1HAZ--UNABLE TO COMPUTE THE ',
     1          'HAZARD FUNCTION.')
          CALL DPWRST('XXX','BUG ')
        ENDIF
      ELSE
         HAZ=0.0
         WRITE(ICOUT,1800)
 1800    FORMAT('*****ERROR IN EV1HAZ--MINMAX NOT 1 OR 2')
         CALL DPWRST('XXX','BUG ')
      END IF
C
      RETURN
      END 
      SUBROUTINE EV1LI1(Y,N,MINMAX,
     1                  ALOC,SCALE,
     1                  ALIK,AIC,AICC,BIC,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE LIKELIHOOD FUNCTION FOR
C              THE GUMBEL (EXTREME VALUE TYPE 1) DISTRIBUTION.  THIS IS
C              FOR THE RAW DATA CASE (I.E., NO GROUPING AND NO CENSORING).
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, P. 272.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/6
C     ORIGINAL VERSION--JUNE      2010.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DS
      DOUBLE PRECISION DU
      DOUBLE PRECISION DN
      DOUBLE PRECISION DNP
      DOUBLE PRECISION DLIK
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EV1L'
      ISUBN2='I1  '
C
      IERROR='NO'
C
      ALIK=-99.0
      AIC=-99.0
      AICC=-99.0
      BIC=-99.0
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'1LI1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF EV1LI1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,ALOC,SCALE
   55   FORMAT('N,ALOC,SCALE = ',I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  COMPUTE LIKELIHOOD FUNCTION         **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'1LI1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERFLG=0
      IERROR='NO'
      IWRITE='OFF'
C
      DN=DBLE(N)
      DS=DBLE(SCALE)
      DU=DBLE(ALOC)
      DTERM1=DN*DLOG(DS)
      DSUM1=0.0D0
      DSUM2=0.0D0
      IF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        DO1000I=1,N
          DX=-(DBLE(Y(I)) - DU)/DS
          DTERM1=DEXP(DX - DEXP(DX))
          DSUM1=DSUM1 + DLOG(DTERM1/DS)
 1000   CONTINUE
      ELSE
        DO2000I=1,N
          DX=(DBLE(Y(I)) - DU)/DS
          DTERM1=DEXP(DX - DEXP(DX))
          DSUM1=DSUM1 + DLOG(DTERM1/DS)
 2000   CONTINUE
      ENDIF
      DLIK=DSUM1
C
      ALIK=REAL(DLIK)
      DNP=2.0D0
      AIC=REAL(-2.0D0*DLIK + 2.0D0*DNP)
      DTERM3=(2.0D0*DNP*(DNP+1.0D0))/(DN-DNP-1.0D0)
      AICC=REAL(-2.0D0*DLIK + 2.0D0*DNP + DTERM3)
      BIC=REAL(-2.0D0*DLIK + DNP*LOG(DN))
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'1LI1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF EV1LI1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)DSUM1,DSUM2,DTERM1,DTERM3
 9013   FORMAT('DSUM1,DSUM2,DTERM1,DTERM3 = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9014)ALIK,AIC,AICC,BIC
 9014   FORMAT('ALIK,AIC,AICC,BIC = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE EXPAND(XLAB,N1,XVAL,N2,IWRITE,Y,XLABC,TEMP1,
     1                  MAXOBV,ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--GIVEN A VECTOR OF LAB-ID'S AND A SET OF VALUES, XVAL,
C              CORRESPONDING TO UNIQUE VALUES OF THE LAB-ID'S, CREATE
C              A VECTOR OF THE SAME LENGTH AS LAB-ID WHERE THE
C              APPROPRIATE VALUE FROM XVAL IS INSERTED.
C
C              FOR EXAMPLE, SUPPOSE WE HAVE 100 LAB-ID'S WHERE THERE ARE
C              10 DISTINCT LAB-ID'S.  THEN XVAL SHOULD HAVE 10 VALUES.
C              THE FIRST VALUE IN XVAL WILL BE INSERTED INTO THE ROWS
C              WITH THE SMALLEST LAB-ID, THE SECOND VALUE IN XVAL WILL
C              BE INSERTED INTO THE ROWS WITH THE SECOND SMALLEST LAB-ID,
C              AND SO ON.
C
C     INPUT  ARGUMENTS--XLAB   = THE SINGLE PRECISION VECTOR CONTAINING
C                                THE LAB-ID'S.
C                     --XVAL   = THE SINGLE PRECISION VECTOR CONTAINING
C                                THE VALUES TO BE INSERTED INTO THE
C                                OUTPUT VECTOR.
C                     --N1     = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR XLAB.
C                     --N2     = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR XVAL.
C     OUTPUT ARGUMENTS--Y      = THE SINGLE PRECISION VECTOR INTO WHICH
C                                THE CODED VALUES WILL BE PLACED.
C     OUTPUT--THE SINGLE PRECISION VECTOR Y
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     OTHER DATAPAC   SUBROUTINES NEEDED--CODE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--NONE.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2012/1
C     ORIGINAL VERSION--JANUARY   2012.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION XLAB(*)
      DIMENSION XVAL(*)
      DIMENSION Y(*)
      DIMENSION XLABC(*)
      DIMENSION TEMP1(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EXPA'
      ISUBN2='ND  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'PAND')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF EXPAND--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N1,N2
   52   FORMAT('IBUGA3,ISUBRO,N1,N2 = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N1
          WRITE(ICOUT,56)I,XLAB(I)
   56     FORMAT('I,XLAB(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        DO65I=1,N2
          WRITE(ICOUT,66)I,XVAL(I)
   66     FORMAT('I,XVAL(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   65   CONTINUE
      ENDIF
C
      DO91I=1,N1
        XLABC(I)=0.0
   91 CONTINUE
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N1.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN EXPAND--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,113)
  113   FORMAT('      THE NUMBER OF OBSERVATIONS FOR THE LAB-IDs IS ',
     1         'LESS THAN 2.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,118)N1
  118   FORMAT('      THE NUMBER OF LAB-IDs IS ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(N2.LT.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,123)
  123   FORMAT('      THE NUMBER OF OBSERVATIONS FOR THE GROUP ',
     1         'VALUES IS LESS THAN 1.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,128)N2
  128   FORMAT('      THE NUMBER OF GROUP VALUES IS ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               **********************************************************
C               **  STEP 2--                                            **
C               **  PERFORM THE CODING--                                **
C               **  CALL CODE ROUTINE AND THEN LOOP THROUGH VALUES IN   **
C               **  THE XVAL VECTOR.                                    **
C               **  THEN APPLY THE RANKS TO ALL THE VALUES.             **
C               **********************************************************
C
      CALL CODE(XLAB,N1,IWRITE,XLABC,TEMP1,MAXOBV,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
      CALL MAXIM(XLABC,N1,IWRITE,XMAX,IBUGA3,IERROR)
      IMAX=INT(XMAX+0.1)
      IF(IMAX.GT.N2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,201)
  201   FORMAT('      THE NUMBER OF UNIQUE VALUES FOR THE LAB-IDs IS ')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,203)
  203   FORMAT('      GREATER THAN THE NUMBER OF GROUP VALUES.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,205)IMAX
  205   FORMAT('      THE NUMBER OF UNIQUE LAB-IDs IS ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,208)N2
  208   FORMAT('      THE NUMBER OF GROUP VALUES IS ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      DO310I=1,IMAX
        HOLD=XVAL(I)
        DO320J=1,N1
          IINDX=INT(XLABC(J)+0.1)
          IF(IINDX.EQ.I)Y(J)=HOLD
  320   CONTINUE
  310 CONTINUE
C
C               ******************************
C               **  STEP 3--                **
C               **  WRITE OUT A FEW LINES   **
C               **  OF SUMMARY INFORMATION  **
C               **  ABOUT THE CODING.       **
C               ******************************
C
      IF(IFEEDB.EQ.'ON' .AND. IWRITE.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,811)IMAX
  811   FORMAT('NUMBER OF DISTINCT CODE VALUES = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,812)XVAL(1)
  812   FORMAT('THE MINIMUM LAB-ID HAS CODED VALUE ',G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,813)XVAL(IMAX)
  813   FORMAT('THE MAXIMUM LAB-ID HAS CODED VALUE ',G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'PAND')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF EXPAND--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IERROR,IMAX
 9012   FORMAT('IERROR,IMAX = ',A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,N1
          WRITE(ICOUT,9016)I,XLAB(I),XLABC(I),Y(I)
 9016     FORMAT('I,XLAB(I),XLABC(I),Y(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE EXPLI1(Y,N,ICASPL,
     1                  ALOC,SCALE,
     1                  ALIK,AIC,AICC,BIC,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE LIKELIHOOD FUNCTION FOR
C              THE EXPONENTIAL DISTRIBUTION.  THIS IS FOR THE RAW DATA
C              CASE (I.E., NO GROUPING AND NO CENSORING).
C
C              NOTE THAT FOR THE 1-PARAMETER MODEL, JUST SET ALOC TO
C              ZERO BEFORE CALLING THIS ROUTINE.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, P. 187.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/6
C     ORIGINAL VERSION--JUNE      2010.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DS
      DOUBLE PRECISION DU
      DOUBLE PRECISION DN
      DOUBLE PRECISION DNP
      DOUBLE PRECISION DLIK
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM3
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EXPL'
      ISUBN2='I1  '
C
      IERROR='NO'
C
      ALIK=-99.0
      AIC=-99.0
      AICC=-99.0
      BIC=-99.0
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PLI1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF EXPLI1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,ALOC,SCALE
   55   FORMAT('N,ALOC,SCALE = ',I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  COMPUTE LIKELIHOOD FUNCTION         **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PLI1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERFLG=0
      IERROR='NO'
      IWRITE='OFF'
      IF(ICASPL.EQ.'1EXP')ALOC=0.0
C
C     THE LOG-LIKELIHOOD FUNCTION IS
C
C     SUM[i=1 to N][-(X(i)-U)/S] - N*LOG(S)
C
      DN=DBLE(N)
      DS=DBLE(SCALE)
      DU=DBLE(ALOC)
      DTERM1=DN*DLOG(DS)
      DSUM1=0.0D0
      DO1000I=1,N
        DX=DBLE(Y(I))
        DSUM1=DSUM1 - (DX-DU)/DS
 1000 CONTINUE
      DLIK=DSUM1 - DTERM1
C
      ALIK=REAL(DLIK)
      DNP=2.0D0
      IF(ICASPL.EQ.'1EXP')DNP=1.0D0
      AIC=REAL(-2.0D0*DLIK + 2.0D0*DNP)
      DTERM3=(2.0D0*DNP*(DNP+1.0D0))/(DN-DNP-1.0D0)
      AICC=REAL(-2.0D0*DLIK + 2.0D0*DNP + DTERM3)
      BIC=REAL(-2.0D0*DLIK + DNP*LOG(DN))
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PLI1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF EXPLI1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)DSUM1,DSUM2,DTERM1,DTERM3
 9013   FORMAT('DSUM1,DSUM2,DTERM1,DTERM3 = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9014)ALIK,AIC,AICC,BIC
 9014   FORMAT('ALIK,AIC,AICC,BIC = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE EXPLI2(Y,X,N,IR,ICASPL,
     1                  ALOC,SCALE,
     1                  ALIK,AIC,AICC,BIC,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE LIKELIHOOD FUNCTION FOR
C              THE CENSORED EXPONENTIAL DISTRIBUTION.  THIS IS FOR THE
C              RAW DATA CASE (I.E., NO GROUPING).
C
C              NOTE THAT FOR THE 1-PARAMETER MODEL, JUST SET ALOC TO
C              ZERO BEFORE CALLING THIS ROUTINE.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, P. 187.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/6
C     ORIGINAL VERSION--JUNE      2010.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DS
      DOUBLE PRECISION DU
      DOUBLE PRECISION DN
      DOUBLE PRECISION DR
      DOUBLE PRECISION DNP
      DOUBLE PRECISION DLIK
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM3
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EXPL'
      ISUBN2='I2  '
C
      IERROR='NO'
C
      ALIK=-99.0
      AIC=-99.0
      AICC=-99.0
      BIC=-99.0
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PLI2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF EXPLI2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,ALOC,SCALE
   55   FORMAT('N,ALOC,SCALE = ',I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),X(I)
   57     FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  COMPUTE LIKELIHOOD FUNCTION         **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PLI2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERFLG=0
      IERROR='NO'
      IWRITE='OFF'
      IF(ICASPL.EQ.'1EXP')ALOC=0.0
C
C     THE LOG-LIKELIHOOD FUNCTION IS
C
C     SUM[i=1 to N][-(X(i)-U)/S] - R*LOG(S)   X(i) > U
C
      DN=DBLE(N)
      DS=DBLE(SCALE)
      DU=DBLE(ALOC)
      DR=DBLE(IR)
      DTERM1=DN*DLOG(DR)
      DSUM1=0.0D0
      DO1000I=1,N
        IF(X(I).GT.0.5 .AND. Y(I).GT.ALOC)THEN
          DX=DBLE(Y(I))
          DSUM1=DSUM1 - (DX-DU)/DS
        ENDIF
 1000 CONTINUE
      DLIK=DSUM1 - DTERM1
C
      ALIK=REAL(DLIK)
      DNP=2.0D0
      IF(ICASPL.EQ.'1EXP')DNP=1.0D0
      AIC=REAL(-2.0D0*DLIK + 2.0D0*DNP)
      DTERM3=(2.0D0*DNP*(DNP+1.0D0))/(DN-DNP-1.0D0)
      AICC=REAL(-2.0D0*DLIK + 2.0D0*DNP + DTERM3)
      BIC=REAL(-2.0D0*DLIK + DNP*LOG(DN))
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PLI2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF EXPLI2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)DSUM1,DSUM2,DTERM1,DTERM3
 9013   FORMAT('DSUM1,DSUM2,DTERM1,DTERM3 = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9014)ALIK,AIC,AICC,BIC
 9014   FORMAT('ALIK,AIC,AICC,BIC = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE EV1ML1(Y,N,MINMAX,IGUMBC,ICASE,
     1                  DTEMP,
     1                  ALOWLO,AUPPLO,ALOWSC,AUPPSC,
     1                  ALOWL2,AUPPL2,ALOWS2,AUPPS2,
     1                  ALPHA,NUMALP,NUMOUT,
     1                  XMEAN,XSD,XMIN,XMAX,
     1                  ALOCMO,ASCAMO,ALMOSE,ASMOSE,
     1                  ALOCML,ASCAML,ASC2ML,ALMLSE,ASMLSE,COVSE,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE EXTREME VALUE TYPE 1 (GUMBEL) DISTRIBUTION FOR
C              THE RAW DATA CASE (I.E., NO CENSORING AND NO GROUPING).
C              IT WILL OPTIONALLY RETURN THE CONFIDENCE INTERVALS FOR
C              THE LOCATION AND SCALE PARAMETERS.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C              PUT THIS IN A SEPARATE ROUTINE AS IT MAY BE CALLED
C              FROM MULTIPLE PLACES (DPMGU1 WILL GENERATE THE OUTPUT
C              FOR THE EXTREME VALUE TYPE 1 MLE COMMAND).
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/10
C     ORIGINAL VERSION--OCTOBER   2009. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPMGU1)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DIMENSION ALOWLO(*)
      DIMENSION AUPPLO(*)
      DIMENSION ALOWSC(*)
      DIMENSION AUPPSC(*)
      DIMENSION ALPHA(*)
      DIMENSION ALOWL2(*)
      DIMENSION AUPPL2(*)
      DIMENSION ALOWS2(*)
      DIMENSION AUPPS2(*)
C
      CHARACTER*4 IGUMBC
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      INTEGER IFLAG
      INTEGER ICASE
C
      DIMENSION Y(*)
      DOUBLE PRECISION DTEMP(*)
C
      DOUBLE PRECISION EV1FU2
      DOUBLE PRECISION EV1FU3
      DOUBLE PRECISION EV1FU4
      EXTERNAL EV1FU2
      EXTERNAL EV1FU3
      EXTERNAL EV1FU4
C
      INTEGER IN 
      DOUBLE PRECISION XBAR
      COMMON/EV1CO2/XBAR,MINMX2,IN
      DOUBLE PRECISION DK
      DOUBLE PRECISION DLLUS
      COMMON/EV1CO3/DK, DLLUS
      DOUBLE PRECISION SHAT
      COMMON/EV1CO4/SHAT
      DOUBLE PRECISION DQ
      DOUBLE PRECISION SHATML
      COMMON/EV1CO6/DQ,SHATML
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DAE
      DOUBLE PRECISION DRE
      DOUBLE PRECISION DG
      DOUBLE PRECISION DS
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DXSTRT
      DOUBLE PRECISION DXLOW
      DOUBLE PRECISION DXUP
      DOUBLE PRECISION XLOWSV
      DOUBLE PRECISION XUPSV
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EV1M'
      ISUBN2='L1  '
C
      IWRITE='OFF'
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'1ML1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF EV1ML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,MAXNXT,MINMAX,ICASE
   52   FORMAT('IBUGA3,ISUBRO,N,MAXNXT,MINMAX,ICASE = ',2(A4,2X),4I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CARRY OUT CALCULATIONS                **
C               **  FOR EXTREME VALUE TYPE 1 MLE ESTIMATE **
C               ********************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'1ML1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='EXTREME VALUE TYPE 1'
      IFLAG=0
      CALL SUMRAW(Y,N,IDIST,IFLAG,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,
     1            ISUBRO,IBUGA3,IERROR)
C
C     MOMENT ESTIMATES ARE:
C
C        MUHAT = XBAR - 0.45006*SD
C        SHAT  = 0.77970*SD
C
C     THE ML ESTIMATE OF THE SCALE PARAMETER IS THE SOLUTION TO
C     THE FOLLOWING EQUATION:
C
C         FOR THE MAXIMUM CASE:
C
C             SHAT - XBAR + SUM[i=1 to N][X(I)*EXP(-X(I)/SHAT)]/
C                    SUM[i=1 to N][EXP(-X(I)/SHAT)] = 0
C
C         FOR THE MINIMUM CASE:
C
C             SHAT - XBAR + SUM[i=1 to N][X(I)*EXP(X(I)/SHAT)]/
C                    SUM[i=1 to N][EXP(X(I)/SHAT)] = 0
C
C         WITH
C
C             SHAT     = CURRENT ESTIMATE OF SCALE PARAMETER
C             XBAR     = SAMPLE MEAN
C             N        = SAMPLE SIZE
C             MINMAX   = SPECIFY WHETHER MAXIMUM OR MINIMUM
C                        CASE IS BEING ESTIMATED
C
C     THE ML ESTIMATE OF LOCATION FOR THE MAXIMUM CASE IS
C
C         MUHAT = -SHAT*LOG(SUM[i=1 to N][EXP(-X(I)/SHAT)]/N)
C
C     THE ML ESTIMATE OF LOCATION FOR THE MINIMUM CASE IS
C
C         MUHAT = -SHAT*LOG(SUM[i=1 to N][EXP(X(I)/SHAT)]/N)
C
      AN=REAL(N)
      DN=DBLE(N)
      IF(MINMAX.EQ.0 .OR. MINMAX.EQ.2)THEN
        ALOCMO=XMEAN - 0.45006*XSD
      ELSE
        ALOCMO=XMEAN + 0.45006*XSD
      ENDIF
      ASCAMO=0.77970*XSD
      ALMOSE=SQRT(1.16781*ASCAMO**2/AN)
      ASMOSE=1.10001*XSD**2/AN
C
      XBAR=DBLE(XMEAN)
      MINMX2=MINMAX
      IN=N
C
      DXSTRT=DBLE(ASCAMO)
      DAE=2.0*0.000001D0*DXSTRT
      DRE=DAE
      IFLAG=0
      DXLOW=DXSTRT/2.0D0
      DXUP=2.0D0*DXSTRT
      ITBRAC=0
      DO3104I=1,N
        DTEMP(I)=DBLE(Y(I))
 3104 CONTINUE
C
 3105 CONTINUE
      XLOWSV=DXLOW
      XUPSV=DXUP
      CALL DFZER2(EV1FU2,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP)
C
      IF(IFLAG.EQ.4 .AND. ITBRAC.LE.100)THEN
        DXLOW=XLOWSV/2.0D0
        DXUP=2.0D0*XUPSV
        ITBRAC=ITBRAC+1
        GOTO3105
      ENDIF
C
      IF(IFLAG.EQ.2)THEN
C
C  NOTE: SUPPRESS THIS MESSAGE FOR NOW.
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,111)
CC111   FORMAT('***** WARNING FROM GUMBEL MAXIMUM ',
CCCCC1         'LIKELIHOOD--')
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,113)
CC113   FORMAT('      ESTIMATE OF SIGMA MAY NOT BE COMPUTED TO ',
CCCCC1         'DESIRED TOLERANCE.')
CCCCC   CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,121)
  121   FORMAT('***** WARNING FROM GUMBEL MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,123)
  123   FORMAT('      ESTIMATE OF SCALE MAY BE NEAR A SINGULAR POINT.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.4)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,131)
  131   FORMAT('***** ERROR FROM GUMBEL MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,133)
  133   FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.5)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,121)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,143)
  143   FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      ASCAML=REAL(DXLOW)
      BN=(1.0 + 2.2/AN**1.13)
      ASC2ML=BN*ASCAML
C
      DSUM1=0.0D0
      IF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        DO3108I=1,N
          DX=-DBLE(Y(I))
          DSUM1=DSUM1 + DEXP(DX/DBLE(ASCAML))
 3108   CONTINUE
        DTERM1=-DBLE(ASCAML)*DLOG(DSUM1/DN)
      ELSE
        DO3109I=1,N
          DX=DBLE(Y(I))
          DSUM1=DSUM1 + DEXP(DX/DBLE(ASCAML))
 3109   CONTINUE
        DTERM1=DBLE(ASCAML)*DLOG(DSUM1/DN)
      ENDIF
      ALOCML=REAL(DTERM1)
C
      ASMLSE=0.77970*ASCAML/SQRT(AN)
      ALMLSE=1.05293*ASCAML/SQRT(AN)
      COVSE=0.50697*ASCAML/SQRT(AN)
      IF(IGUMBC.EQ.'ON')THEN
        ASMLSE=ASMLSE*BN
        COVSE=COVSE*SQRT(BN)
      ENDIF
C
      IF(ICASE.EQ.0)GOTO9000
C
      IF(IGUMBC.EQ.'ON')THEN
        SCTEMP=ASC2ML
      ELSE
        SCTEMP=ASCAML
      ENDIF
C
      DSUM1=0.0D0
      IF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        DO3110I=1,N
          DSUM1=DSUM1 + DEXP(-(Y(I) - DBLE(ALOCML))/DBLE(ASCAML))
 3110   CONTINUE
        DLLUS=-DN*DLOG(DBLE(ASCAML)) - DN*XBAR/DBLE(ASCAML) +
     1         DN*DBLE(ALOCML)/DBLE(ASCAML) - DSUM1
      ELSE
        DO3115I=1,N
          DSUM1=DSUM1 + DEXP((Y(I) + DBLE(ALOCML))/DBLE(ASCAML))
 3115   CONTINUE
        DLLUS=-DN*DLOG(DBLE(ASCAML)) - DN*XBAR/DBLE(ASCAML) +
     1         DN*DBLE(ALOCML)/DBLE(ASCAML) - DSUM1
      ENDIF
      SHAT=DBLE(SCTEMP)
C
      DAE=1.D-7
      DRE=1.D-7
      NUTEMP=1
C
      DO3120I=1,NUMALP
C
        ALP=ALPHA(I)
        P=1.0-(ALP/2.0)
        CALL NORPPF(P,APPF)
        ALOWSC(I)=SCTEMP - APPF*ASMLSE
        AUPPSC(I)=SCTEMP + APPF*ASMLSE
        ALOWLO(I)=ALOCML - APPF*ALMLSE
        AUPPLO(I)=ALOCML + APPF*ALMLSE
C
        CALL CHSPPF(1.0-ALP,NUTEMP,APPF)
        DK=DBLE(APPF)
C
        DXSTRT=DBLE(ALOWSC(I))
        DXLOW=DXSTRT/5.0D0
        DXUP=DBLE(SCTEMP)
        CALL DFZER2(EV1FU3,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP)
        ALOWS2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(AUPPSC(I))
        DXUP=DXSTRT*5.0D0
        DXLOW=DBLE(SCTEMP)
        CALL DFZER2(EV1FU3,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP)
        AUPPS2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(ALOWLO(I))
        DXLOW=DXSTRT/2.0D0
        DXUP=DBLE(ALOCML)
        CALL DFZER2(EV1FU4,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP)
        ALOWL2(I)=REAL(DXLOW)
C
        DXSTRT=DBLE(AUPPLO(I))
        DXUP=DXSTRT*2.0D0
        DXLOW=DBLE(ALOCML)
        CALL DFZER2(EV1FU4,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP)
        AUPPL2(I)=REAL(DXLOW)
C
 3120 CONTINUE
C
      NUMOUT=NUMALP
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'1ML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF EV1ML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9055)N,XMEAN,XSD,XMIN,XMAX
 9055   FORMAT('N,XMEAN,XSD,XMIN,XMAX = ',I8,4G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9056)ALOCMO,ASCAMO,ALMOSE,ASMOSE
 9056   FORMAT('ALOCMO,ASCAMO,ALMOSE,ASMOSE = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9057)ALOCML,ASCAML,ALMLSE,ASMLSE
 9057   FORMAT('ALOCML,ASCAML,ALMLSE,ASMLSE = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
        DO9060I=1,NUMALP
          WRITE(ICOUT,9065)I,ALPHA(I),ALOWLO(I),AUPPLO(I),ALOWSC(I),
     1                     AUPPSC(I)
 9065     FORMAT('I,ALPHA(I),ALOWLO(I),AUPPLO(I),ALOWSC(I),AUPPSC(I)=',
     1           I8,5G15.7)
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,9066)I,ALPHA(I),ALOWL2(I),AUPPL2(I),ALOWS2(I),
     1                     AUPPSC(I)
 9066     FORMAT('I,ALPHA(I),ALOWL2(I),AUPPL2(I),ALOWS2(I),AUPPS2(I)=',
     1           I8,5G15.7)
          CALL DPWRST('XXX','WRIT')
 9060   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE EV1PDF(X,MINMAX,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE EXTREME VALUE TYPE 1
C              DISTRIBUTION.
C              THE EXTREME VALUE TYPE 1 DISTRIBUTION USED
C              HEREIN HAS MEAN = EULER'S NUMBER = 0.57721566
C              AND STANDARD DEVIATION = PI/SQRT(6) = 1.28254983.
C              THIS DISTRIBUTION IS DEFINED FOR ALL X
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              FOR THE MAXIMUM ORDER STATISTIC
C              F(X) = (EXP(-X)) * (EXP(-(EXP(-X))))
C              WHICH SIMPLIFIES TO:
C              F(X) = EXP(-X - EXP(-X))
C              FOR THE MINIMUIM ORDER STATISTIC
C              F(X) = (EXP(X)) * (EXP(-(EXP(X))))
C              WHICH SIMPLIFIES TO:
C              F(X) = EXP(-X - EXP(-X))
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE CUMULATIVE DISTRIBUTION 
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--CDF    = THE SINGLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE CDF FOR THE EXTREME VALUE TYPE 1
C             DISTRIBUTION WITH MEAN = EULER'S NUMBER = 0.57721566
C             AND STANDARD DEVIATION = PI/SQRT(6) = 1.28254983.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 272-295.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-921-2315
C     ORIGINAL VERSION--APRIL     1994. 
C     UPDATED         --JULY      2004. CODE IN DOUBLE PRECISION FOR
C                                       BETTER ACCURACY
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DPDF
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS.
C     NO INPUT ARGUMENT ERRORS POSSIBLE 
C     FOR THIS DISTRIBUTION.
C
C-----START POINT-----------------------------------------------------
C
      DX=DBLE(X)
      IF(MINMAX.EQ.1)THEN
        DPDF=DEXP(DX-DEXP(DX)) 
      ELSEIF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        DPDF=DEXP(-DX-DEXP(-DX)) 
      ELSE
         WRITE(ICOUT,1800)
 1800    FORMAT('*****ERROR IN EV1PDF--MINMAX NOT 1 OR 2')
         CALL DPWRST('XXX','BUG ')
      END IF
      PDF=REAL(DPDF)
C
      RETURN
      END 
      SUBROUTINE EV1PPF(P,MINMAX,PPF)
CCCCC MINMAX ADDED TO ABOVE ARGUMENT LIST   MAY 1993
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE EXTREME VALUE TYPE 1
C              (= GUMBEL)
C              DISTRIBUTION.
C              THERE ARE 2 SUCH EV1 FAMILIES--
C                 ONE FOR THE MIN ORDER STAT AND
C                 ONE FOR THE MAX ORDER STAT (THE USUAL).
C              (SEE SARHAN & GREENBERG, PAGE 69)
C              THE EV1 TYPE IS SPECIFIED VIA   MINMAX
C              FOR MINMAX = 1  (FOR THE MINIMUM)
C                 THE WEIBULL DISTRIBUTION USED
C                 HEREIN IS DEFINED FOR ALL X,
C                 AND HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = ...
C              FOR MINMAX = 2 (FOR THE DEFAULT MAXIMUM),
C                 THE EV1 DISTRIBUTION USED
C                 HEREIN IS DEFINED FOR ALL X,
C                 HAS MEAN = EULER'S NUMBER = 0.57721566
C                 HAS STANDARD DEVIATION = PI/SQRT(6) = 1.28254983.
C                 AND HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = (EXP(-X)) * (EXP(-(EXP(-X))))
C              NOTE THAT THE PERCENT POINT FUNCTION OF A DISTRIBUTION
C              IS IDENTICALLY THE SAME AS THE INVERSE CUMULATIVE
C              DISTRIBUTION FUNCTION OF THE DISTRIBUTION.
C     INPUT  ARGUMENTS--P      = THE SINGLE PRECISION VALUE
C                                (BETWEEN 0.0 (EXCLUSIVELY)
C                                AND 1.0 (EXCLUSIVELY))
C                                AT WHICH THE PERCENT POINT
C                                FUNCTION IS TO BE EVALUATED.
C                     --MINMAX = THE INTEGER VALUE
C                                IDENTIFYING THE
C                                CHOSEN WEIBULL DISTRIBUTION.
C                                1 = MIN, 2 = MAX.
C     OUTPUT ARGUMENTS--PPF    = THE SINGLE PRECISION PERCENT
C                                POINT FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PERCENT POINT FUNCTION .
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--P SHOULD BE BETWEEN 0.0 (EXCLUSIVELY)
C                   AND 1.0 (EXCLUSIVELY).
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--LOG.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--SARHAN & GREENBERG,
C                 CONTRIBUTIONS TO ORDER STATISTICS,
C                 1962, WILEY, PAGE 69.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 272-295.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--NOVEMBER  1975.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MAY       1993. REWRITTEN--ADD EV1/MIN DIST.
C     UPDATED         --JANUARY   1994. ADD MINMAX ERROR MESSAGE
C     UPDATED         --JULY      2004. CODE IN DOUBLE PRECISION
C                                       FOR BETTER ACCURACY.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DP
      DOUBLE PRECISION DPPF
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LE.0.0.OR.P.GE.1.0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9000
      ENDIF
    1 FORMAT('***** ERROR--THE FIRST  INPUT ARGUMENT TO ',
     1'EV1PPF IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8)
C
CCCCC THE FOLLOWING LINE WAS REWRITTEN   MAY 1993
CCCCC PPF=(-(LOG(-LOG(P))))
C
CCCCC THE FOLLOWING SECTION WAS REWRITTEN      JANUARY 1994
      DP=DBLE(P)
      IF(MINMAX.EQ.1)THEN
         DPPF=DLOG(DLOG(1.0D0/(1.0D0-DP)))
      ELSE IF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
         DPPF=(-(DLOG(DLOG(1.0D0/DP))))
      ELSE
         WRITE(ICOUT,1800)
 1800    FORMAT('*****ERROR IN EV1PPF--MINMAX NOT 1 OR 2')
         CALL DPWRST('XXX','BUG ')
      ENDIF
      PPF=REAL(DPPF)
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EV1RAN(N,MINMAX,ISEED,X)
CCCCC MINMAX WAS ADDED TO THE ABOVE ARGUMENT LIST   MAY 1993
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE EXTREME VALUE TYPE 1 DISTRIBUTION.
C              THE PROTOTYPE EXTREME VALUE TYPE 1 DISTRIBUTION USED
C              HEREIN HAS MEAN = EULER'S NUMBER = 0.57721566
C              AND STANDARD DEVIATION = PI/SQRT(6) = 1.28254983.
C              THIS DISTRIBUTION IS DEFINED FOR ALL X
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = (EXP(-X)) * (EXP(-(EXP(-X))))
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C                     --MINMAX = THE INTEGER VALUE
C                                IDENTIFYING THE
C                                CHOSEN WEIBULL DISTRIBUTION.
C                                1 = MIN, 2 = MAX.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE EXTREME VALUE TYPE 1 DISTRIBUTION
C             WITH MEAN = EULER'S NUMBER = 0.57721566
C             AND STANDARD DEVIATION = PI/SQRT(6) = 1.28254983.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--LOG.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--SARHAN & GREENBERG,
C                 CONTRIBUTIONS TO ORDER STATISTICS,
C                 1962, WILEY, PAGE 69.
C               --TOCHER, THE ART OF SIMULATION,
C                 1963, PAGES 14-15.
C               --HAMMERSLEY AND HANDSCOMB, MONTE CARLO METHODS,
C                 1964, PAGE 36.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 272-295.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--NOVEMBER  1975.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MAY       1993. REWRITTEN--ADD EV1/MIN DIST.
C     UPDATED         --JANUARY   1994. ADD MINMAX ERROR MESSAGE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)GOTO50
      GOTO90
   50 WRITE(ICOUT, 5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,47)N
      CALL DPWRST('XXX','BUG ')
      RETURN
   90 CONTINUE
    5 FORMAT('***** FATAL ERROR--THE 1ST INPUT ARGUMENT TO THE ',
     1'EV1RAN SUBROUTINE IS NON-POSITIVE *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,' *****')
C
C     GENERATE N UNIFORM (0,1) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     GENERATE N EXTREME VALUE TYPE 1 RANDOM NUMBERS
C     USING THE PERCENT POINT FUNCTION TRANSFORMATION METHOD.
C
CCCCC THE FOLLOWING SECTION WAS REWRITTEN   MAY 1993
CCCCC DO100I=1,N
CCCCC X(I)=-LOG(LOG(1.0/X(I)))
CC100 CONTINUE
C
CCCCC THE FOLLOWING SECTION WAS REWRITTEN      JANUARY 1994
      IF(MINMAX.EQ.1)THEN
         DO100I=1,N
         X(I)=LOG(LOG(1.0/(1.0-X(I))))
  100    CONTINUE
      ELSE IF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
         DO200I=1,N
         X(I)=(-(LOG(LOG(1.0/X(I)))))
  200    CONTINUE
      ELSE
         WRITE(ICOUT,1800)
 1800    FORMAT('*****ERROR IN EV1RAN--MINMAX NOT 1 OR 2')
         CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE EV2CDF(X,GAMMA,MINMAX,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE EXTREME VALUE TYPE 2
C              DISTRIBUTION WITH SINGLE PRECISION 
C              TAIL LENGTH PARAMETER = GAMMA.
C              THE EXTREME VALUE TYPE 2 DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              FOR THE MAXIMUM ORDER STATISTIC
C              F(X) = GAMMA * (X**(-GAMMA-1)) * EXP(-(X**(-GAMMA))).
C              FOR THE MINIMUM ORDER STATISTIC
C              F(X) = GAMMA * ((-X)**(-GAMMA-1)) * EXP(-((-X)**(-GAMMA))).
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE CUMULATIVE DISTRIBUTION 
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE NON-NEGATIVE.
C                     --GAMMA  = THE SINGLE PRECISION VALUE 
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--CDF    = THE SINGLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE EXTREME VALUE TYPE 2
C             DISTRIBUTION WITH TAIL LENGTH PARAMETER VALUE = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--GAMMA SHOULD BE POSITIVE.
C                 --X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 272-295.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-921-2315
C     ORIGINAL VERSION--APRIL     1994. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 ICOUTINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,ICOUTINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(X.LT.0.0.AND.(MINMAX.EQ.2 .OR. MINMAX.EQ.0))GOTO50
      IF(X.GT.0.0.AND.MINMAX.EQ.1)GOTO60
      IF(GAMMA.LE.0.0)GOTO55
      GOTO90
   50 CONTINUE
      WRITE(ICOUT,4)
      WRITE(ICOUT,5)
      WRITE(ICOUT,46)X
      WRITE(ICOUT,47)MINMAX
      CDF=0.0
      RETURN
   55 CONTINUE
      WRITE(ICOUT,15) 
      WRITE(ICOUT,16) 
      WRITE(ICOUT,46)GAMMA
      CDF=0.0
      RETURN
   60 CONTINUE
      WRITE(ICOUT,4)
      WRITE(ICOUT,6)
      WRITE(ICOUT,46)X
      WRITE(ICOUT,47)MINMAX
      CDF=0.0
      RETURN
   90 CONTINUE
    4 FORMAT('***** NON-FATAL DIAGNOSTIC--THE FIRST  INPUT ARGUMENT ')
    5 FORMAT('      TO THE EV2CDF SUBROUTINE IS NEGATIVE *****')
    6 FORMAT('      TO THE EV2CDF SUBROUTINE IS POSITIVE *****')
   15 FORMAT('***** FATAL ERROR--THE SECOND INPUT ARGUMENT TO THE')
   16 FORMAT('      EV2CDF SUBROUTINE IS NON-POSITIVE *****')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
   47 FORMAT('***** THE VALUE OF MINMAX IS ',I5,' *****')
C
C-----START POINT-----------------------------------------------------
C
      IF(MINMAX.EQ.1)THEN
        CDF=1.0
        IF(X.GE.0.0)RETURN
        CDF=1.0-EXP(-(-X)**(-GAMMA)) 
      ELSEIF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        CDF=0.0
        IF(X.LE.0.0)RETURN
        CDF=EXP(-(X**(-GAMMA))) 
      ELSE
         WRITE(ICOUT,1800)
 1800    FORMAT('*****ERROR IN EV2CDF--MINMAX NOT 1 OR 2')
         CALL DPWRST('XXX','BUG ')
      END IF
C
      RETURN
      END 
      SUBROUTINE EV2CDD(X,GAMMA,MINMAX,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE EXTREME VALUE TYPE 2
C              DISTRIBUTION WITH SINGLE PRECISION 
C              TAIL LENGTH PARAMETER = GAMMA.
C              THE EXTREME VALUE TYPE 2 DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              FOR THE MAXIMUM ORDER STATISTIC
C              F(X) = GAMMA * (X**(-GAMMA-1)) * EXP(-(X**(-GAMMA))).
C              FOR THE MINIMUM ORDER STATISTIC
C              F(X) = GAMMA * ((-X)**(-GAMMA-1)) * EXP(-((-X)**(-GAMMA))).
C     NOTE--THIS IS A DOUBLE PRECISION VERSION OF EV2CDF USED IN
C           CALCULATING HAZARD FUNCTIONS
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE CUMULATIVE DISTRIBUTION 
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE NON-NEGATIVE.
C                     --GAMMA  = THE SINGLE PRECISION VALUE 
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--CDF    = THE SINGLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE EXTREME VALUE TYPE 2
C             DISTRIBUTION WITH TAIL LENGTH PARAMETER VALUE = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--GAMMA SHOULD BE POSITIVE.
C                 --X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 272-295.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-921-2315
C     ORIGINAL VERSION--APRIL     1994. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DOUBLE PRECISION X
      DOUBLE PRECISION GAMMA
      DOUBLE PRECISION CDF
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 ICOUTINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,ICOUTINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(X.LT.0.0D0.AND.(MINMAX.EQ.2 .OR. MINMAX.EQ.0))GOTO50
      IF(X.GT.0.0D0.AND.MINMAX.EQ.1)GOTO60
      IF(GAMMA.LE.0.0D0)GOTO55
      GOTO90
   50 CONTINUE
      WRITE(ICOUT,4)
      WRITE(ICOUT,5)
      WRITE(ICOUT,46)X
      WRITE(ICOUT,47)MINMAX
      CDF=0.0
      RETURN
   55 CONTINUE
      WRITE(ICOUT,15) 
      WRITE(ICOUT,16) 
      WRITE(ICOUT,46)GAMMA
      CDF=0.0
      RETURN
   60 CONTINUE
      WRITE(ICOUT,4)
      WRITE(ICOUT,6)
      WRITE(ICOUT,46)X
      WRITE(ICOUT,47)MINMAX
      CDF=0.0
      RETURN
   90 CONTINUE
    4 FORMAT('***** NON-FATAL DIAGNOSTIC--THE FIRST  INPUT ARGUMENT ')
    5 FORMAT('      TO THE EV2CDF SUBROUTINE IS NEGATIVE *****')
    6 FORMAT('      TO THE EV2CDF SUBROUTINE IS POSITIVE *****')
   15 FORMAT('***** FATAL ERROR--THE SECOND INPUT ARGUMENT TO THE')
   16 FORMAT('      EV2CDF SUBROUTINE IS NON-POSITIVE *****')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
   47 FORMAT('***** THE VALUE OF MINMAX IS ',I5,' *****')
C
C-----START POINT-----------------------------------------------------
C
      IF(MINMAX.EQ.1)THEN
        CDF=1.0D0
        IF(X.GE.0.0D0)RETURN
        CDF=1.0D0-DEXP(-(-X)**(-GAMMA)) 
      ELSEIF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        CDF=0.0D0
        IF(X.LE.0.0D0)RETURN
        CDF=DEXP(-(X**(-GAMMA))) 
      ELSE
         WRITE(ICOUT,1800)
 1800    FORMAT('*****ERROR IN EV2CDF--MINMAX NOT 1 OR 2')
         CALL DPWRST('XXX','BUG ')
      END IF
C
      RETURN
      END
      SUBROUTINE EV2CHA(X,GAMMA,MINMAX,HAZ)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE HAZARD
C              FUNCTION VALUE FOR THE EXTREME VALUE TYPE 2
C              DISTRIBUTION WITH SINGLE PRECISION 
C              TAIL LENGTH PARAMETER = GAMMA.
C              THE EXTREME VALUE TYPE 2 DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              FOR THE MAXIMUM ORDER STATISTIC
C              F(X) = GAMMA * (X**(-GAMMA-1)) * EXP(-(X**(-GAMMA))).
C              FOR THE MINIMUM ORDER STATISTIC
C              F(X) = GAMMA * ((-X)**(-GAMMA-1)) * EXP(-((-X)**(-GAMMA))).
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE NON-NEGATIVE.
C                     --GAMMA  = THE SINGLE PRECISION VALUE 
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--HAZ    = THE SINGLE PRECISION CUMULATIVE HAZARD
C                                FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE HAZARD
C             FUNCTION VALUE HAZ FOR THE EXTREME VALUE TYPE 2
C             DISTRIBUTION WITH TAIL LENGTH PARAMETER VALUE = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--GAMMA SHOULD BE POSITIVE.
C                 --X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 272-295.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--APRIL     1998. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DOUBLE PRECISION CDF
      DOUBLE PRECISION DHAZ
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 ICOUTINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,ICOUTINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(X.LT.0.0.AND.(MINMAX.EQ.2 .OR. MINMAX.EQ.0))GOTO50
      IF(X.GT.0.0.AND.MINMAX.EQ.1)GOTO60
      IF(GAMMA.LE.0.0)GOTO55
      GOTO90
   50 CONTINUE
      WRITE(ICOUT,4)
      WRITE(ICOUT,5)
      WRITE(ICOUT,46)X
      WRITE(ICOUT,47)MINMAX
      HAZ=0.0
      RETURN
   55 CONTINUE
      WRITE(ICOUT,15) 
      WRITE(ICOUT,16) 
      WRITE(ICOUT,46)GAMMA
      HAZ=0.0
      RETURN
   60 CONTINUE
      WRITE(ICOUT,4)
      WRITE(ICOUT,6)
      WRITE(ICOUT,47)MINMAX
      WRITE(ICOUT,46)X
      WRITE(ICOUT,47)MINMAX
      HAZ=0.0
      RETURN
   90 CONTINUE
    4 FORMAT('***** NON-FATAL DIAGNOSTIC--THE FIRST  INPUT ARGUMENT ')
    5 FORMAT('      TO THE EV2CHA SUBROUTINE IS NEGATIVE *****')
    6 FORMAT('      TO THE EV2CHA SUBROUTINE IS POSITIVE *****')
   15 FORMAT('***** FATAL ERROR--THE SECOND INPUT ARGUMENT TO THE')
   16 FORMAT('      EV2CHA SUBROUTINE IS NON-POSITIVE *****')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
   47 FORMAT('***** THE VALUE OF MINMAX IS ',I5,' *****')
C
C-----START POINT-----------------------------------------------------
C
      IF(MINMAX.EQ.1)THEN
        DGAMMA=DBLE(GAMMA)
        DX=DBLE(X)
        DHAZ=(-DX)**(-DGAMMA)
        HAZ=REAL(DHAZ)
      ELSEIF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        CALL EV2CDD(DBLE(X),DBLE(GAMMA),MINMAX,CDF)
        CDF=1.0D0-CDF
        IF(CDF.LE.0.0D0)THEN
          WRITE(ICOUT,1100)
          CALL DPWRST('XXX','BUG ')
 1100     FORMAT('*****ERROR IN EV2CHA--CDF ESSENTIALLY 1.')
        ELSE
          DHAZ=-DLOG(CDF)
          HAZ=REAL(DHAZ)
        ENDIF
      ELSE
         WRITE(ICOUT,1800)
 1800    FORMAT('*****ERROR IN EV2CHA--MINMAX NOT 1 OR 2')
         CALL DPWRST('XXX','BUG ')
      END IF
C
      RETURN
      END 
      DOUBLE PRECISION FUNCTION EV2FUN (GHAT,X)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE MAXIMUM LIKELIHOOD
C              ESTIMATE OF GAMMA FOR THE 2-PARAMETER FRECHET
C              (EXTREME VALUE TYPE 2)
C              MODEL FOR FULL SAMPLE DATA (NO CENSORING).  THIS
C              FUNCTION FINDS THE ROOT OF THE EQUATION:
C
C                 (1/GHAT) +
C                 SUM[i=1 to n][Y(I)**(-GHAT)*LN(Y(I))]/
C                 SUM[i=1 to n][[Y(I)**(-GHAT)] -
C                 (1/N)*SUM[i=1 to n][LN(Y(I))] = 0
C
C              WITH
C
C                 GHAT     = POINT ESTIMATE OF GAMMA (THIS IS THE
C                            PARAMETER WE ARE ITERATING OVER)
C
C              NOTE THAT THE THIRD TERM DOES NOT DEPEND ON GHAT,
C              SO THIS IS A CONSTANT.  FOR EFFICIENCY, SAVE THIS AS
C              A CONSTANT IN A COMMON BLOCK.
C
C              CALLED BY DFZER2 ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.
C     EXAMPLE--FRECHET MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN
C                ENGINEERING", CAMBRIDGE UNIVERSITY PRESS,
C                1999, CHAPTER 16.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2005/5
C     ORIGINAL VERSION--MAY        2005.
C     UPDATED         --JUNE       2013. CHECK FOR DIVISION BY ZERO
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION GHAT
      DOUBLE PRECISION X(*)
C
      INTEGER IN 
      DOUBLE PRECISION DEV2SM
      COMMON/EV2COM/DEV2SM,IN
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DX1
      DOUBLE PRECISION DG
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  COMPUTE SOME SUMS
C
      DSUM1=0.0D0
      DSUM2=0.0D0
      DG=GHAT
C
      DTERM1=1.0D0/DG
      DO100I=1,IN
        DX1=X(I)
        DSUM1=DSUM1 + (DX1**(-DG))*DLOG(DX1)
        DSUM2=DSUM2 + DX1**(-DG)
  100 CONTINUE
C
C     2013/06/20: IF DSUM2 IS ZERO, THEN SET DTERM2 TO A LARGE NUMBER
      IF(DSUM2.NE.0.0D0)THEN
        DTERM2=DSUM1/DSUM2
      ELSE
        DTERM2=CPUMAX/2.0D0
      ENDIF
C
      EV2FUN=DTERM1 + DTERM2 - DEV2SM
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION EV2FU2 (DA,DX)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE LIKELIHOOD RATIO
C              BASED CONFIDECE INTERVAL FOR THE 2-PARAMETER FRECHET
C              MODEL (FULL SAMPLE).  THIS FUNCTION FINDS THE ROOT
C              OF THE EQUATION:
C
C                 2*LL(ALPHA,GAMMA) - 2*LL(S(a),,a) - CHSPPF(alpha,1)
C
C              WITH
C
C                 LL(ALPHA,GAMMA) = N*LN(GAMMA) + N*GAMMA*LN(ALPHA) -
C                          (GAMMA+1)*SUM[i=1 to n][LN(X(i))] -
C                          ALPHA**GAMMA*SUM[i=1 to n][(X(i)**(-GAMA)]
C                 ALPHA    = POINT ESTIMATE OF SCALE PARAMETER
C                 GAMMA    = POINT ESTIMATE OF SHAPE PARAMETER
C                 A        = PARAMETER WE ARE FINDING ROOT FOR
C                 K        = CHSPPF(ALPHA,1) (HERE, ALPHA IS THE
C                            SIGNIFICANCE LEVEL, NOT THE SCALE PARAMETER)
C
C              NOTE THAT QUANTITIES THAT DO NOT DEPEND ON A ARE
C              COMPUTED ONCE IN DPMLFR AND PASSED VIA COMMON BLOCK.
C
C              CALLED BY DFZER2 ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.  DFZER2 IS MODIFIED VERSION OF DFZERO THAT
C              PASSES ALONG THE DATA ARRAY.
C
C     EXAMPLE--FRECHET MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 16 (SEE
C                EXAMPLE 16.4).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2005/5
C     ORIGINAL VERSION--MAY        2005.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DA
      DOUBLE PRECISION DX(*)
C
      DOUBLE PRECISION DK
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      COMMON/EV2CO2/DK,DTERM1,DTERM2,N
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DG
      DOUBLE PRECISION DSCALE
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
      DOUBLE PRECISION DTERM5
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  COMPUTE SOME SUMS
C
      DN=DBLE(N)
      DG=DA
C
      DSUM1=0.0D0
      DO100I=1,N
        DSUM1=DSUM1 + DX(I)**(-DG)
  100 CONTINUE
      DSCALE=(DSUM1/DN)**(-1.0D0/DG)
C
      DTERM3=DN*DLOG(DG) + DN*DG*DLOG(DSCALE)
      DTERM4=(DG+1.0D0)*DTERM2
      DTERM5=DSCALE**DG*DSUM1
C
      EV2FU2=DTERM1 - 2.0D0*(DTERM3 - DTERM4 - DTERM5) - DK
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION EV2FU3 (DB,DX)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE LIKELIHOOD RATIO
C              BASED CONFIDENCE INTERVAL FOR THE SCALE PARAMETER OF A
C              2-PARAMETER FRECHET MODEL (FULL SAMPLE).  THIS
C              FUNCTION FINDS THE ROOT OF THE EQUATION:
C
C                 2*LL(ALPHA,GAMMA) - 2*LL(b,I(b)) - CHSPPF(alpha,1)
C
C              WITH
C
C                 LL(ALPHA,GAMMA) = N*LN(GAMMA) + N*GAMMA*LN(ALPHA) -
C                          (GAMMA+1)*SUM[i=1 to n][LN(X(i))] -
C                          ALPHA**GAMMA*SUM[i=1 to n][(X(i)**(-GAMMA)]
C                 ALPHA    = POINT ESTIMATE OF SCALE PARAMETER
C                 GAMMA    = POINT ESTIMATE OF SHAPE PARAMETER
C                 B        = PARAMETER (SCALE) WE ARE FINDING ROOT FOR
C                 K        = CHSPPF(ALPHA,1) (HERE, ALPHA IS THE
C                            SIGNIFICANCE LEVEL, NOT THE SCALE
C                            PARAMETER)
C
C              NOTE THAT QUANTITIES THAT DO NOT DEPEND ON B ARE
C              COMPUTED ONCE IN DPMLFR AND PASSED VIA COMMON BLOCK.
C
C              GIVEN A VALUE FOR THE SCALE PARAMETER (DB), WE NEED
C              TO CALL A ROOT FINDING ROUTINE TO DETERMINE THE VALUE
C              OF THE SHAPE PARAMETER (A).
C
C              CALLED BY DFZER2 ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.  DFZER2 IS MODIFIED VERSION OF DFZERO THAT
C              PASSES ALONG THE DATA ARRAY.
C
C     EXAMPLE--FRECHET MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 16 (SEE
C                EXAMPLE 16.4).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2005/5
C     ORIGINAL VERSION--MAY        2005.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DB
      DOUBLE PRECISION DX(*)
C
      DOUBLE PRECISION DK
      DOUBLE PRECISION DTERM6
      DOUBLE PRECISION DTERM7
      DOUBLE PRECISION DGAMMA
      COMMON/EV2CO3/DK,DTERM6,DTERM7,DGAMMA,N
C
      DOUBLE PRECISION DBTEMP
      COMMON/EV2CO4/DBTEMP,N2
C
      DOUBLE PRECISION AE
      DOUBLE PRECISION RE
      DOUBLE PRECISION XLOW
      DOUBLE PRECISION XUP
      DOUBLE PRECISION XSTRT
      DOUBLE PRECISION DA
      DOUBLE PRECISION DG
      DOUBLE PRECISION DN
      DOUBLE PRECISION DSCALE
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
      DOUBLE PRECISION DTERM5
C
      DOUBLE PRECISION EV2FU4
      EXTERNAL EV2FU4
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  STEP 1: GIVEN VALUE OF SCALE PARAMETER (DB), NEED TO COMPUTE
C          THE SHAPE PARAMETER (WHICH IN TURN INVOLVES FINDING A
C          ROOT).

      N2=N
      DBTEMP=DB
      AE=1.D-7
      RE=1.D-7
      XSTRT=DGAMMA
      XLOW=XSTRT/5.0D0
      XUP=XSTRT*5.0D0
      CALL DFZER3(EV2FU4,XLOW,XUP,XSTRT,RE,AE,IFLAG,DX)
      DA=XLOW
C
C  COMPUTE SOME SUMS
C
      DN=DBLE(N)
      DG=DA
      DSCALE=DB
C
      DSUM1=0.0D0
      DO100I=1,N
        DSUM1=DSUM1 + DX(I)**(-DG)
  100 CONTINUE
C
      DTERM3=DN*DLOG(DG) + DN*DG*DLOG(DSCALE)
      DTERM4=(DG+1.0D0)*DTERM7
      DTERM5=DSCALE**DG*DSUM1
C
      EV2FU3=DTERM6 - 2.0D0*(DTERM3 - DTERM4 - DTERM5) - DK
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION EV2FU4 (DA,DX)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE LIKELIHOOD RATIO
C              BASED CONFIDENCE INTERVAL FOR THE SCALE PARAMETER OF
C              THE 2-PARAMETER FRECHET MODEL (FULL SAMPLE).
C              SPECIFICALLY, IT IS USED TO DETERMINE AN ESTIMATE
C              OF THE SHAPE PARAMETER GIVEN A VALUE OF THE SCALE
C              PARAMETER.  IT FINDS THE ROOT OF THE FOLLOWING
C              EQUATION:
C
C                 (N/A) + N*LOG(B) - SUM[LOG(X)] -
C                       SUM[(B/X)**A*LOG(B/X)]
C
C              WITH A DENOTING THE SHAPE PARAMETER, B THE SCALE
C              PARAMETER, AND THE ROOT IS WITH RESPECT TO A.
C
C              CALLED BY DFZER3 ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.  DFZER3 IS MODIFIED VERSION OF DFZERO THAT
C              PASSES ALONG THE DATA ARRAY.
C
C     EXAMPLE--FRECHET MAXIMUM LIKELIHOOD Y
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 16 (SEE
C                EXAMPLE 16.4).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2005/5
C     ORIGINAL VERSION--MAY        2005.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DA
      DOUBLE PRECISION DX(*)
C
      DOUBLE PRECISION DB
      COMMON/EV2CO4/DB,N
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DTERM1
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  COMPUTE SOME SUMS
C
      DN=DBLE(N)
      DTERM1=(DN/DA) + DN*DLOG(DB)
C
      DSUM1=0.0D0
      DSUM2=0.0D0
      DO100I=1,N
        DSUM1=DSUM1 + DLOG(DX(I))
        DSUM2=DSUM2 + ((DB/DX(I))**DA)*DLOG(DB/DX(I))
  100 CONTINUE
C
      EV2FU4=DTERM1 - DSUM1 - DSUM2
C
      RETURN
      END
      SUBROUTINE EV2HAZ(X,GAMMA,MINMAX,HAZ)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE HAZARD
C              FUNCTION VALUE FOR THE EXTREME VALUE TYPE 2
C              DISTRIBUTION WITH SINGLE PRECISION 
C              TAIL LENGTH PARAMETER = GAMMA.
C              THE EXTREME VALUE TYPE 2 DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              FOR THE MAXIMUM ORDER STATISTIC
C              F(X) = GAMMA * (X**(-GAMMA-1)) * EXP(-(X**(-GAMMA))).
C              FOR THE MINIMUM ORDER STATISTIC
C              F(X) = GAMMA * ((-X)**(-GAMMA-1)) * EXP(-((-X)**(-GAMMA))).
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE NON-NEGATIVE.
C                     --GAMMA  = THE SINGLE PRECISION VALUE 
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--HAZ    = THE SINGLE PRECISION HAZARD
C                                FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION HAZARD
C             FUNCTION VALUE HAZ FOR THE EXTREME VALUE TYPE 2
C             DISTRIBUTION WITH TAIL LENGTH PARAMETER VALUE = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--GAMMA SHOULD BE POSITIVE.
C                 --X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 272-295.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--APRIL     1998. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DOUBLE PRECISION CDF
      DOUBLE PRECISION DPDF
      DOUBLE PRECISION DX
      DOUBLE PRECISION DGAMMA
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 ICOUTINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,ICOUTINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(X.LT.0.0.AND.(MINMAX.EQ.2.OR.MINAX.EQ.0))GOTO50
      IF(X.GT.0.0.AND.MINMAX.EQ.1)GOTO60
      IF(GAMMA.LE.0.0)GOTO55
      GOTO90
   50 CONTINUE
      WRITE(ICOUT,4)
      WRITE(ICOUT,5)
      WRITE(ICOUT,46)X
      WRITE(ICOUT,47)MINMAX
      HAZ=0.0
      RETURN
   55 CONTINUE
      WRITE(ICOUT,15) 
      WRITE(ICOUT,16) 
      WRITE(ICOUT,46)GAMMA
      HAZ=0.0
      RETURN
   60 CONTINUE
      WRITE(ICOUT,4)
      WRITE(ICOUT,6)
      WRITE(ICOUT,47)MINMAX
      WRITE(ICOUT,46)X
      WRITE(ICOUT,47)MINMAX
      HAZ=0.0
      RETURN
   90 CONTINUE
    4 FORMAT('***** NON-FATAL DIAGNOSTIC--THE FIRST  INPUT ARGUMENT ')
    5 FORMAT('      TO THE EV2HAZ SUBROUTINE IS NEGATIVE *****')
    6 FORMAT('      TO THE EV2HAZ SUBROUTINE IS POSITIVE *****')
   15 FORMAT('***** FATAL ERROR--THE SECOND INPUT ARGUMENT TO THE')
   16 FORMAT('      EV2HAZ SUBROUTINE IS NON-POSITIVE *****')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
   47 FORMAT('***** THE VALUE OF MINMAX IS ',I5,' *****')
C
C-----START POINT-----------------------------------------------------
C
      DGAMMA=DBLE(GAMMA)
      DX=DBLE(X)
      IF(MINMAX.EQ.1)THEN
        DHAZ=DGAMMA*(-DX)**(-DGAMMA-1.0D0)
        HAZ=REAL(DHAZ)
      ELSEIF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        DPDF=DGAMMA*(DX**(-DGAMMA-1.0))*DEXP(-(DX**(-DGAMMA))) 
        CALL EV2CDD(DBLE(X),DBLE(GAMMA),MINMAX,CDF)
        IF(1.0D0-CDF.LE.0.0D0)THEN
          WRITE(ICOUT,1100)
          CALL DPWRST('XXX','BUG ')
 1100     FORMAT('*****ERROR IN EV2HAZ--CDF ESSENTIALLY 1, ',
     1           'HAZARD SET TO 0.')
        ELSE
          HAZ=REAL(DPDF/(1.0D0-CDF))
        ENDIF
      ELSE
         WRITE(ICOUT,1800)
 1800    FORMAT('*****ERROR IN EV2HAZ--MINMAX NOT 1 OR 2')
         CALL DPWRST('XXX','BUG ')
      END IF
C
      RETURN
      END 
      SUBROUTINE EV2ML1(Y,N,MINMAX,
     1                  TEMP1,DTEMP1,
     1                  XMEAN,XSD,XVAR,XMIN,XMAX,XLOGSD,XLOGSM,
     1                  SCALML,SCALSE,SHAPML,SHAPSE,
     1                  SHAPBC,SHABSE,COVSE,COVBSE,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE 2-PARAMETER EXTREME VALUE TYPE 2 (FRECHET)
C              DISTRIBUTION FOR THE RAW DATA CASE (I.E., NO CENSORING
C              AND NO GROUPING).  THIS ROUTINE RETURNS ONLY THE POINT
C              ESTIMATES (CONFIDENCE INTERVALS WILL BE COMPUTED IN A
C              SEPARATE ROUTINE).
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C              PUT THIS IN A SEPARATE ROUTINE AS IT MAY BE CALLED
C              FROM MULTIPLE PLACES (DPMLW1 WILL GENERATE THE OUTPUT
C              FOR THE FRECHET MLE COMMAND).
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 16.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/2
C     ORIGINAL VERSION--FEBRUARY  2010. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPMLFR)
C     UPDATED         --JUNE      2013. IMPROVED STARTING VALUES
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DIMENSION Y(*)
      DIMENSION TEMP1(*)
      DOUBLE PRECISION DTEMP1(*)
C
      CHARACTER*4 ICASE
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DAE
      DOUBLE PRECISION DRE
      DOUBLE PRECISION DG
      DOUBLE PRECISION DS
      DOUBLE PRECISION DT1
      DOUBLE PRECISION DYT
      DOUBLE PRECISION DYBAR
      DOUBLE PRECISION DXBAR
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DXSTRT
      DOUBLE PRECISION DXLOW
      DOUBLE PRECISION DXUP
      DOUBLE PRECISION XLOWSV
      DOUBLE PRECISION XUPSV
C
      DOUBLE PRECISION EV2FUN
      EXTERNAL EV2FUN
      INTEGER IN
      DOUBLE PRECISION DEV2SM
      COMMON/EV2COM/DEV2SM,IN
C
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EV2M'
      ISUBN2='L1  '
C
      IERROR='NO'
      IWRITE='OFF'
      AN=REAL(N)
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'2ML1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF EV2ML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,MINMAX
   52   FORMAT('IBUGA3,ISUBRO,MINMAX = ',2(A4,2X),I5)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'2ML1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(MINMAX.NE.1)THEN
        DO1125I=1,N
          IF(Y(I).LE.0.0)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1111)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1122)
 1122       FORMAT('      A NON-POSITIVE VALUE WAS ENCOUNTERED IN ',
     1             'THE RESPONSE VARIABLE.')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1123)I,Y(I)
 1123       FORMAT('      ROW ',I8,' HAS THE VALUE = ',E15.7)
            CALL DPWRST('XXX','WRIT')
            IERROR='YES'
            GOTO9000
          ELSE
            TEMP1(I)=LOG(Y(I))
          ENDIF
 1125   CONTINUE
      ELSE
        DO1135I=1,N
          IF(Y(I).GE.0.0)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1111)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1132)
 1132       FORMAT('      A NON-NEGATIVE VALUE WAS ENCOUNTERED IN ',
     1             'THE RESPONSE VARIABLE.')
            WRITE(ICOUT,1133)I,Y(I)
 1133       FORMAT('      ROW ',I8,' HAS THE VALUE = ',E15.7)
            CALL DPWRST('XXX','WRIT')
            IERROR='YES'
            GOTO9000
          ELSE
            TEMP1(I)=LOG(-Y(I))
          ENDIF
 1135   CONTINUE
      ENDIF
C
      HOLD=Y(1)
      DO1145I=2,N
        IF(Y(I).NE.HOLD)GOTO1149
 1145 CONTINUE
 1140 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1111)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1142)HOLD
 1142 FORMAT('      THE RESPONSE VARIABLE HAS ALL ELEMENTS = ',G15.7)
      CALL DPWRST('XXX','WRIT')
      IERROR='YES'
      GOTO9000
 1149 CONTINUE
C
C               ******************************************
C               **  STEP 2--                            **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR FRECHET MLE ESTIMATE            **
C               ******************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'2ML1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='FRECHET'
CCCCC IFLAG=2
      IFLAG=0
      CALL SUMRAW(Y,N,IDIST,IFLAG,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,
     1            ISUBRO,IBUGA3,IERROR)
      CALL SD(TEMP1,N,IWRITE,XLOGSD,IBUGA3,IERROR)
      CALL SUMDP(TEMP1,N,IWRITE,XLOGSM,IBUGA3,IERROR)
C
      SHAPML=CPUMIN
      SHAPBC=CPUMIN
      SHAPSE=CPUMIN
      SHABSE=CPUMIN
      SCALML=CPUMIN
      SCALSE=CPUMIN
      COVSE=CPUMIN
      COVBSE=CPUMIN
C
C     FOR THE SHAPE PARAMETER, SOLVE THE EQUATION:
C
C         (1/GHAT) +
C         SUM[i=1 to n][Y(I)**(-GHAT)*LN(Y(I))]/
C         SUM[i=1 to n][[Y(I)**(-GHAT)] -
C         (1/N)*SUM[i=1 to n][LN(Y(I))] = 0
C
C     THEN
C
C         SCALE = {((1/N)*SUM[i=1 to n][Y(I)**(-GHAT)])}**(-1/GHAT)
C
C     FOR STARTING VALUE, USE FACT THAT FRECHET = EXPONENTIAL OF
C     GUMBEL DISTRIBUTION.  THEN GHAT = 1/SCALE WITH SCALE DENOTING
C     THE SCALE ESTIMATE OF THE GUMBEL DISTRIBUTION.
C
C     2013/06: BASE STARTING VALUE FOR SHAPE ON "FRECHET" PLOT (SEE
C     PAGE 299 OF BURY).  THE FRECHET PLOT IS
C
C          -LN[LN[p(i)]] versus LN OF ORDERED DATA
C
C     WHERE p(i) = (i - 0.3)/(n + 0.4)
C
C     THEN
C
C           A0 = -GAMMA*LOG(SCALE)
C           A1 = GAMMA
C
C     FOR SIMPLE LINEAR REGRESSION,
C
C           A1 = SUM[X(i) - XBAR]*SUM[Y(i) - YBAR]/SUM[(X(i) - XBAR)**2]
C
C     IN ORDER TO AVOID HAVING TO PASS IN ADDITIONAL SCRATCH ARRAYS, DO
C     IN TWO PASSES.
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'2EV2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICASE='MAXIMUM'
      IF(MINMAX.EQ.1)THEN
        ICASE='MINIMUM'
        DO4103I=1,N
          Y(I)=-Y(I)
 4103   CONTINUE
      ENDIF
C
C     ESTIMATES FOR 2-PARAMETER MODEL.  USE DFZER2 TO FIND ROOT OF
C     THE EQUATION GIVEN ABOVE.
C
      DO4101I=1,N
        DTEMP1(I)=DBLE(Y(I))
 4101 CONTINUE
      KFLAG=1
      CALL DSORT(DTEMP1,DTEMP1,N,KFLAG,IERROR)
C
      DEV2SM=DBLE(XLOGSM/AN)
CCCCC DXSTRT=DBLE(SQRT(1.645)*XSD)
C
      DSUM1=0.0D0
      DSUM2=0.0D0
      DN=DBLE(N)
      DO3901I=1,N
        DYT=(DBLE(I) - 0.3D0)/(DN + 0.4D0)
        DYT=-LOG(-LOG(DYT))
        DSUM1=DSUM1 + DYT
        DSUM2=DSUM2 + DLOG(DTEMP1(I))
 3901 CONTINUE
      DYBAR=DSUM1/DN
      DXBAR=DSUM2/DN
C
      DSUM1=0.0D0
      DSUM2=0.0D0
      DO3903I=1,N
        DYT=(DBLE(I) - 0.3D0)/(DN + 0.4D0)
        DYT=-LOG(-LOG(DYT))
        DSUM1=DSUM1 + (DLOG(DTEMP1(I)) - DXBAR)*(DYT - DYBAR)
        DSUM2=DSUM2 + (DLOG(DTEMP1(I)) - DXBAR)**2
 3903 CONTINUE
      DXSTRT=DSUM1/DSUM2
C
      DAE=2.0*0.000001D0*DXSTRT
      DRE=DAE
      IN=N
      IFLAG=0
      DXLOW=DXSTRT/3.0D0
      DXUP=3.0D0*DXSTRT
      ITBRAC=0
 4105 CONTINUE
      XLOWSV=DXLOW
      XUPSV=DXUP
      CALL DFZER2(EV2FUN,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP1)
C
      IF(IFLAG.EQ.4 .AND. ITBRAC.LE.100)THEN
        DXLOW=XLOWSV/2.0D0
        DXUP=2.0D0*XUPSV
        ITBRAC=ITBRAC+1
        GOTO4105
      ENDIF
C
      IF(IFLAG.EQ.2)THEN
C
CCCCC   NOTE: SUPPRESS THIS MESSAGE FOR NOW.
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,111)
CC111   FORMAT('***** WARNING FROM FRECHET MAXIMUM ',
CCCCC1         'LIKELIHOOD--')
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,113)
CC113   FORMAT('      ESTIMATE OF SIGMA MAY NOT BE COMPUTED TO ',
CCCCC1         'DESIRED TOLERANCE.')
CCCCC   CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,121)
  121   FORMAT('***** WARNING FROM FRECHET MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,123)
  123   FORMAT('      ESTIMATE OF GAMMA MAY BE NEAR A SINGULAR POINT.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.4)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1111)
 1111   FORMAT('****** ERROR IN FRECHERT MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,133)
  133   FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.5)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,121)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,143)
  143   FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      SHAPML=REAL(DXLOW)
      DSUM=0.0D0
      DO4108I=1,N
        DSUM=DSUM + DBLE(Y(I)**(-SHAPML))
 4108 CONTINUE
      DSUM=(DSUM/DBLE(N))**(1.0D0/DBLE(-SHAPML))
      SCALML=REAL(DSUM)
      BN=1.0 + 2.2/AN**1.13
      SHAPBC=SHAPML/BN
C
C     COMPUTE STANDARD ERRORS (CAN BASE ON EITHER THE NORMAL BIASED
C     ESTIMATORS OR THE BIAS CORRECTED ESTIMATORS)
C
      SCALSE=1.05293*SCALML/(SHAPML*SQRT(AN))
      SHAPSE=0.77970*SHAPML/SQRT(AN)
      SHABSE=0.77970*SHAPML/(BN*SQRT(AN))
      COVSE=0.50697*SQRT(SCALML/AN)
      COVBSE=0.50697*SQRT(SCALML/(AN*BN))
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'2ML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF EV2ML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)N,XMEAN,XSD,XMIN,XMAX
 9013   FORMAT('N,XMEAN,XSD,XMIN,XMAX = ',I8,4G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)XLOGSD,XLOGSM
 9015   FORMAT('XLOGSD,XLOGSM = ',2G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9017)SHAPML,SCALML,SHAPSE,SCALSE
 9017   FORMAT('SHAPML,SCALML,SHAPSE,SCALSE =  ',4G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9019)SHAPBC,SHABSE,COVSE,COVBSE
 9019   FORMAT('SHAPBC,SHABSE,COVSE,COVBSE =  ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE EV2PDF(X,GAMMA,MINMAX,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE EXTREME VALUE TYPE 2
C              DISTRIBUTION WITH SINGLE PRECISION 
C              TAIL LENGTH PARAMETER = GAMMA.
C              THE EXTREME VALUE TYPE 2 DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              FOR THE MAXIMUM ORDER STATISTIC
C              F(X) = GAMMA * (X**(-GAMMA-1)) * EXP(-(X**(-GAMMA))).
C              FOR THE MINIMUM ORDER STATISTIC
C              F(X) = GAMMA * ((-X)**(-GAMMA-1)) * EXP(-((-X)**(-GAMMA))).
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE NON-NEGATIVE.
C                     --GAMMA  = THE SINGLE PRECISION VALUE 
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--PDF    = THE SINGLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE PDF FOR THE EXTREME VALUE TYPE 2
C             DISTRIBUTION WITH TAIL LENGTH PARAMETER VALUE = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--GAMMA SHOULD BE POSITIVE.
C                 --X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 272-295.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--APRIL     1994. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 ICOUTINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,ICOUTINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(X.LT.0.0.AND.(MINMAX.EQ.2 .OR. MINMAX.EQ.0))GOTO50
      IF(X.GT.0.0.AND.MINMAX.EQ.1)GOTO60
      IF(GAMMA.LE.0.0)GOTO55
      GOTO90
   50 CONTINUE
      WRITE(ICOUT,4)
      WRITE(ICOUT,5)
      WRITE(ICOUT,46)X
      WRITE(ICOUT,47)MINMAX
      PDF=0.0
      RETURN
   55 CONTINUE
      WRITE(ICOUT,15) 
      WRITE(ICOUT,16) 
      WRITE(ICOUT,46)GAMMA
      PDF=0.0
      RETURN
   60 CONTINUE
      WRITE(ICOUT,4)
      WRITE(ICOUT,6)
      WRITE(ICOUT,47)MINMAX
      WRITE(ICOUT,46)X
      WRITE(ICOUT,47)MINMAX
      PDF=0.0
      RETURN
   90 CONTINUE
    4 FORMAT('***** NON-FATAL DIAGNOSTIC--THE FIRST  INPUT ARGUMENT ')
    5 FORMAT('      TO THE EV2PDF SUBROUTINE IS NEGATIVE *****')
    6 FORMAT('      TO THE EV2PDF SUBROUTINE IS POSITIVE *****')
   15 FORMAT('***** FATAL ERROR--THE SECOND INPUT ARGUMENT TO THE')
   16 FORMAT('      EV2PDF SUBROUTINE IS NON-POSITIVE *****')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
   47 FORMAT('***** THE VALUE OF MINMAX IS ',I5,' *****')
C
C-----START POINT-----------------------------------------------------
C
      IF(MINMAX.EQ.1)THEN
        PDF=GAMMA*((-X)**(-GAMMA-1.0))*EXP(-((-X)**(-GAMMA))) 
      ELSEIF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
        PDF=GAMMA*(X**(-GAMMA-1.0))*EXP(-(X**(-GAMMA))) 
      ELSE
         WRITE(ICOUT,1800)
 1800    FORMAT('*****ERROR IN EV2PDF--MINMAX NOT 1 OR 2')
         CALL DPWRST('XXX','BUG ')
      END IF
C
      RETURN
      END 
      SUBROUTINE EV2PPF(P,GAMMA,MINMAX,PPF)
CCCCC MINMAX ADDED TO ABOVE ARGUMENT LIST   MAY 1993
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE EXTREME VALUE TYPE 2
C              (= FRECHET)
C              DISTRIBUTION WITH SINGLE PRECISION
C              TAIL LENGTH PARAMETER = GAMMA.
C              THERE ARE 2 SUCH EV2 FAMILIES--
C                 ONE FOR THE MIN ORDER STAT (THE USUAL) AND
C                 ONE FOR THE MAX ORDER STAT.
C              (SEE SARHAN & GREENBERG, PAGE 69)
C              THE EV2 TYPE IS SPECIFIED VIA   MINMAX
C              FOR MINMAX = 1  (FOR THE MINIMUM)
C                 THE EV2 DISTRIBUTION USED
C                 HEREIN IS DEFINED FOR ALL NEGATIVE X,
C                 AND HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = ...
C              FOR MINMAX = 2 (FOR THE DEFAULT MAXIMUM),
C                 THE EV2 DISTRIBUTION USED
C                 HEREIN IS DEFINED FOR ALL POSITIVE X,
C                 AND HAS THE PROBABILITY DENSITY FUNCTION
C               F(X) = GAMMA * (X**(-GAMMA-1)) * EXP(-(X**(-GAMMA))).
C              NOTE THAT THE PERCENT POINT FUNCTION OF A DISTRIBUTION
C              IS IDENTICALLY THE SAME AS THE INVERSE CUMULATIVE
C              DISTRIBUTION FUNCTION OF THE DISTRIBUTION.
C     INPUT  ARGUMENTS--P      = THE SINGLE PRECISION VALUE
C                                (BETWEEN 0.0 (EXCLUSIVELY)
C                                AND 1.0 (EXCLUSIVELY))
C                                AT WHICH THE PERCENT POINT
C                                FUNCTION IS TO BE EVALUATED.
C                     --GAMMA  = THE SINGLE PRECISION VALUE
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C                     --MINMAX = THE INTEGER VALUE
C                                IDENTIFYING THE
C                                CHOSEN WEIBULL DISTRIBUTION.
C                                1 = MIN, 2 = MAX.
C     OUTPUT ARGUMENTS--PPF    = THE SINGLE PRECISION PERCENT
C                                POINT FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PERCENT POINT FUNCTION .
C             VALUE PPF FOR THE EXTREME VALUE TYPE 2 DISTRIBUTION
C             WITH TAIL LENGTH PARAMETER VALUE = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--GAMMA SHOULD BE POSITIVE.
C                 --P SHOULD BE BETWEEN 0.0 (EXCLUSIVELY)
C                   AND 1.0 (EXCLUSIVELY).
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--LOG.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--SARHAN & GREENBERG,
C                 CONTRIBUTIONS TO ORDER STATISTICS,
C                 1962, WILEY, PAGE 69.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 272-295.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--NOVEMBER  1975.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MAY       1993. REWRITTEN--ADD EV2/MAX DIST.
C     UPDATED         --JANUARY   1994. ADD MINMAX ERROR MESSAGE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LE.0.0.OR.P.GE.1.0)GOTO50
      IF(GAMMA.LE.0.0)GOTO55
      GOTO90
   50 WRITE(ICOUT,1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)P
      CALL DPWRST('XXX','BUG ')
      PPF=0.0
      RETURN
   55 WRITE(ICOUT,15)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)GAMMA
      CALL DPWRST('XXX','BUG ')
      PPF=0.0
      RETURN
   90 CONTINUE
    1 FORMAT('***** FATAL ERROR--THE 1ST INPUT ARGUMENT TO THE ',
     1'EV2PPF SUBROUTINE IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL')
   15 FORMAT('***** FATAL ERROR--THE 2ND INPUT ARGUMENT TO THE ',
     1'EV2PPF SUBROUTINE IS NON-POSITIVE *****')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
C
CCCCC THE FOLLOWING LINE WAS REWRITTEN    MAY 1993
CCCCC PPF=(-LOG(P))**(-1.0/GAMMA)
C
CCCCC THE FOLLOWING SECTION WAS REWRITTEN      JANUARY 1994
      IF(MINMAX.EQ.1)THEN
         PPF= (-(LOG(1.0/(1.0-P)))**(-1.0/GAMMA))
      ELSE IF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
         PPF= (LOG(1.0/P))**(-1.0/GAMMA)
      ELSE
         WRITE(ICOUT,1800)
 1800    FORMAT('*****ERROR IN EV2PPF--MINMAX NOT 1 OR 2')
         CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE EV2RAN(N,GAMMA,MINMAX,ISEED,X)
CCCCC MINMAX WAS ADDED TO THE ABOVE ARGUMENT LIST   MAY 1993
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE EXTREME VALUE TYPE 2 DISTRIBUTION
C              WITH TAIL LENGTH PARAMETER VALUE = GAMMA.
C              THE PROTOTYPE EXTREME VALUE TYPE 2 DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = GAMMA * (X**(-GAMMA-1)) * EXP(-(X**(-GAMMA))).
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --GAMMA  = THE SINGLE PRECISION VALUE OF THE
C                                TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C                     --MINMAX = THE INTEGER VALUE
C                                IDENTIFYING THE
C                                CHOSEN WEIBULL DISTRIBUTION.
C                                1 = MIN, 2 = MAX.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE EXTREME VALUE TYPE 2 DISTRIBUTION
C             WITH TAIL LENGTH PARAMETER VALUE = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --GAMMA SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--LOG.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--SARHAN & GREENBERG,
C                 CONTRIBUTIONS TO ORDER STATISTICS,
C                 1962, WILEY, PAGE 69.
C               --TOCHER, THE ART OF SIMULATION,
C                 1963, PAGES 14-15.
C               --HAMMERSLEY AND HANDSCOMB, MONTE CARLO METHODS,
C                 1964, PAGE 36.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 272-295.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--NOVEMBER  1975.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MAY       1993. MINMAX
C     UPDATED         --JANUARY   1994. ADD MINMAX ERROR MESSAGE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)GOTO50
      IF(GAMMA.LE.0.0)GOTO60
      GOTO90
   50 WRITE(ICOUT, 5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,47)N
      CALL DPWRST('XXX','BUG ')
      RETURN
   60 WRITE(ICOUT,15)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)GAMMA
      CALL DPWRST('XXX','BUG ')
      RETURN
   90 CONTINUE
    5 FORMAT('***** FATAL ERROR--THE 1ST INPUT ARGUMENT TO THE ',
     1'EV2RAN SUBROUTINE IS NON-POSITIVE *****')
   15 FORMAT('***** FATAL ERROR--THE 2ND INPUT ARGUMENT TO THE ',
     1'EV2RAN SUBROUTINE IS NON-POSITIVE *****')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,' *****')
C
C     GENERATE N UNIFORM (0,1) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     GENERATE N EXTREME VALUE TYPE 2 DISTRIBUTION RANDOM NUMBERS
C     USING THE PERCENT POINT FUNCTION TRANSFORMATION METHOD.
C
CCCCC THE FOLLOWING SECTION WAS REWRITTEN    MAY 1993
CCCCC DO100I=1,N
CCCCC X(I)=(-LOG(X(I)))**(-1.0/GAMMA)
CC100 CONTINUE
C
CCCCC THE FOLLOWING SECTION WAS REWRITTEN      JANUARY 1994
      IF(MINMAX.EQ.1)THEN
         DO100I=1,N
         X(I)= (-(LOG(1.0/(1.0-X(I))))**(-1.0/GAMMA))
  100    CONTINUE
      ELSE IF(MINMAX.EQ.2 .OR. MINMAX.EQ.0)THEN
         DO200I=1,N
         X(I)= (LOG(1.0/X(I)))**(-1.0/GAMMA)
  200    CONTINUE
      ELSE
         WRITE(ICOUT,1800)
 1800    FORMAT('*****ERROR IN EV2RAN--MINMAX NOT 1 OR 2')
         CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE EVALM(IW2,IW22,W2,ITYPE,ISTART,ISTOP,IANGLU,ANS,
CCCCC FOLLOWING LINE MODIFIED  SEPTEMBER 1994.
CCCCC1SAVE1,SAVE2,SAVE3,IBUGEV,IERROR)
CCCCC FOLLOWING LINE MODIFIED  APRIL 1995
CCCCC1SAVE1,SAVE2,SAVE3,SAVE4,ILIBC1,ILIBC2,IBUGEV,IERROR)
CCCCC FOLLOWING LINE MODIFIED  MAY 1998
     1SAVE1,SAVE2,SAVE3,SAVE4,SAVE5,SAVE6,SAVE7,SAVE8,
     1ILIBC1,ILIBC2,IBUGEV,IERROR)
C
C     PURPOSE--EVALUATE A STRING OF CODE THAT CONTAINS ONLY
C     VALUES, OPERATIONS, AND LIBRARY FUNCTIONS.
C     NOTE--THE DECEMBER UPDATE AUGMENTED THE
C           USUAL MATH LIBRARY WITH
C           ARCSIN, ARCCOS, ARCTAN, OCTAL
C     NOTE--THE UPDATE WHICH ALLOWS 2 ARGUMENTS AND 3 ARGUMENTS
C           AS IN TCDF, CHSCDF, FCDF, ETC. HAS THE FOLLOWING RESTRICTIONS--
C           1) NO EXPRESSIONS FOR ARGUMENTS (MAYBE FOR FIRST)
C           2) NO NEGATIVE ARGUMENTS FOR SECOND AND THIRD ARGUMENTS
C           (FORTUNATELY THIS LAST RESTRICTION IS NO RESTRICTION
C           AT ALL FOR THE T, CHI-SQUARED, AND F DISTRIBUTIONS
C           BECAUSE THEY REQUIRE POSITIVE DEGREES OF FREEDOM ANYWAY.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--NOVEMBER 1, 1976.
C     UPDATED--DECEMBER 21, 1977.
C     UPDATED--DECEMBER 28, 1977.
C     UPDATED         --JULY      1978.
C     UPDATED         --JULY      1978.
C     UPDATED         --OCTOBER   1978.
C     UPDATED         --JANUARY   1979.
C     UPDATED         --FEBRUARY  1979.
C     UPDATED         --JUNE      1979.
C     UPDATED         --JULY      1979.
C     UPDATED         --FEBRUARY  1981.
C     UPDATED         --JUNE      1981.
C     UPDATED         --JULY      1981.
C     UPDATED         --SEPTEMBER 1981.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MARCH     1989.  SAVE3 ARGUMENT (FOR JULIA SETS)
C     UPDATED         --JUNE      1989.  UNDERFLOW SET TO 0 FOR * AND /
C     UPDATED         --MAY       1994.  SET SAVE2 AND SAVE3 TO -99.9
C                                        TO AVOID FCDF ERROR WITH
C                                        TOO FEW ARGUMENTS.
C     UPDATED         --SEPTEMBER 1994.  ADD SAVE4 ARGUMENT FOR DNFCDF
C     UPDATED         --APRIL     1995.  INITIALIZE SAVE1 ... SAVE4
C                                        (BUG IN HEAVE FUNCTION, WHERE
C                                        ARGUMENTS OPTIONAL)
C                                        ALSO, BUG IN FOLLOWING
C                                        LET A = TPDF(X,2) - TPDF(X,3)
C                                        BOTH USE 2 FOR SECOND ARG.
C     UPDATED         --SEPTEMBER 1997.  WORKAROUND FOR "**" OPERATION
C                                        (BUG IN OLD LAHEY COMPILER)
C     UPDATED         --MAY       1998.  ADD SAVE5
C     UPDATED         --NOVEMBER  1998.  FIX FOR 0**(POSITIVE NUMB)
C     UPDATED         --JUNE      2003.  ADD SAVE6, SAVE7, SAVE8
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IW2
      CHARACTER*4 IW22
      CHARACTER*4 ITYPE
      CHARACTER*4 IANGLU
      CHARACTER*4 IBUGEV
      CHARACTER*4 IERROR
C
      CHARACTER*4 IOP
C
C---------------------------------------------------------------------
C
      DIMENSION IW2(*)
      DIMENSION IW22(*)
      DIMENSION W2(*)
      DIMENSION ITYPE(*)
      DIMENSION TERM(80)
      DIMENSION IOP(80)
C
CCCCC FOLLOWING SECTION ADDED APRIL 1995.
      DIMENSION SAVE1(*)
      DIMENSION SAVE2(*)
      DIMENSION SAVE3(*)
      DIMENSION SAVE4(*)
      DIMENSION SAVE5(*)
      DIMENSION SAVE6(*)
      DIMENSION SAVE7(*)
      DIMENSION SAVE8(*)
C
CCCCC FOLLOWING LINE FOR LAHEY BUG.  SEPTEMBER 1997.
      INCLUDE 'DPCOHO.INC'
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C     DEFINE THE UPPER LIMIT OF THE NUMBER OF 'TERMS'
C     THAT THIS SUBROUTINE CAN PROCESS.
C     THIS IS USUALLY THE SAME AS THE MAX NUMBER OF CHARACTERS
C     THAT MAY BE PROCESSED BY THE COMPIM SUBROUTINE
C     IF RESTRICT THE FUNCTIONAL EXPRESSION TO 1 LINE IMAGE,
C     THEN A REASONABLE UPPER BOUND IS 80.
C     WHATEVER UPPER BOUND IS SET,
C     THE DIMENSIONS OF THE VECTORS
C     TERM(.) AND IOP(.),  USED HEREIN
C     MUST BE EQUAL OR LARGER TO THIS NUMBER.
C
      DATA MAXTER/80/
C
C-----START POINT-----------------------------------------------------
C
      ANS=0.0
      IERROR='NO'
C
      CUTOFF=0.00001
C
      AIABS2=(-999.0)
C
      ALCPUM=LOG(CPUMAX)
C
C     CHECK THAT THE INPUT PARAMETERS ISTART AND ISTOP)
C     ARE BOTH AT LEAST 1 AND BOTH AT MOST MAXTER
C     (WHERE MAXTER IS THE INTERNALLY DEFINED VARIABLE
C     WHICH CONTROLS DIMENSION SIZES AND WHICH
C     TYPICALLY HAS THE VALUE 80).
C     ALSO CHECK THAT ISTART DOES NOT EXCEED ISTOP.
C
      IF(ISTART.LT.1.OR.MAXTER.LT.ISTART)GOTO20
      IF(ISTOP.LT.1.OR.MAXTER.LT.ISTOP)GOTO20
      IF(ISTOP.LT.ISTART)GOTO20
      GOTO39
   20 CONTINUE
      WRITE(ICOUT,21)
   21 FORMAT('***** ERROR IN EVALM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,22)
   22 FORMAT('      ILLEGAL VALUES FOR THE INPUT PARAMETERS ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,23)
   23 FORMAT('      ISTART AND/OR ISTOP.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,24)
   24 FORMAT('      BOTH ISTART AND ISTOP MUST BE AT LEAST 1')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,25)
   25 FORMAT('      AND AT MOST MAXTER')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,26)
   26 FORMAT('      (WHERE MAXTER IS AN INTERNALLY-DEFINED',
     1'VARIABLE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,27)MAXTER
   27 FORMAT('      WHICH HAS THE VALUE = ',I8,'   .')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,28)
   28 FORMAT('      ALSO, ISTART MUST BE SMALLER THAN')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,29)
   29 FORMAT('      OR AT MOST EQUAL TO ISTOP')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,30)ISTART
   30 FORMAT('      ISTART = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,31)ISTOP
   31 FORMAT('      ISTOP  = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,32)MAXTER
   32 FORMAT('      MAXTER = ',I8)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
   39 CONTINUE
C
      IF(IBUGEV.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF EVALM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)ISTART,ISTOP
   52 FORMAT('ISTART,ISTOP = ',2I6)
      CALL DPWRST('XXX','BUG ')
      DO53I=ISTART,ISTOP
      WRITE(ICOUT,54)I,IW2(I),IW22(I),W2(I),ITYPE(I)
   54 FORMAT('I,IW2(I),IW22(I),W2(I),ITYPE(I) = ',I8,2X,A4,2X,A4,
     1F15.7,2X,A4)
      CALL DPWRST('XXX','BUG ')
   53 CONTINUE
      WRITE(ICOUT,56)IBUGEV
   56 FORMAT('IBUGEV = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,57)IANGLU
   57 FORMAT('IANGLU = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,58)SAVE1(1),SAVE2(1),SAVE3(1),SAVE4(1)
   58 FORMAT('I=1,SAVE1,SAVE2,SAVE3,SAVE4 = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C     BLANK-OUT THE IOP(.) VECTOR AND ZERO-OUT THE TERM(.) VECTOR.
C
      DO110I=1,MAXTER
      TERM(I)=0.0
      IOP(I)='    '
  110 CONTINUE
C
C               ***************************************************************
C               **  STEP 1--                                                 **
C               **  OPERATE ON THE VECTORS IW2(.) AND IW22(.).               **
C               **  THEY SHOULD CONTAIN NO PARENTHESES.                      **
C               **  THEY SHOULD CONTAIN ONLY--                               **
C               **       NUMBERS                                             **
C               **       X VALUES                                            **
C               **       PARAMETER VALUES                                    **
C               **       PREVIOUSLY COMPUTED VALUES                          **
C               **       OPERATIONS (5--+ - * / **)                          **
C               **       LIBRARY FUNCTIONS.                                  **
C               **  COPY THE NUMBERS, X VALUES, PARAMETER VALUES,            **
C               **  AND PREVIOUSLY COMPUTED VALUES OVER TO THE TERM VECTOR.  **
C               **  COPY THE OPERATIONS OVER TO THE OPERATIONS VECTOR.       **
C               **  ELIMINATE THE LIBRARY FUNCTIONS BY EVALUATING THEM       **
C               **  WITH THE NEXT POTENTIAL TERM AND PUTTING                 **
C               **  THE EVALUATED RESULT INTO THAT NEXT TERM.                **
C               **  OUTPUT THE VECTOR TERMS(.) AND THE VECTOR IOP(.)
C               **  WHICH CONTAIN TERMS AND OPERATIONS RESPECTIVELY.         **
C               ***************************************************************
C
      IF(ITYPE(ISTOP).EQ.'OP')GOTO120
      IF(ITYPE(ISTOP).EQ.'LF')GOTO122
      GOTO130
  120 CONTINUE
      WRITE(ICOUT,121)ITYPE(ISTOP)
  121 FORMAT('***** ERROR IN EVALM--LAST TERM ',
     1'IN AN INTERMEDIATE EXPRESSION = AN OPERATION = ',A4)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
  122 CONTINUE
      WRITE(ICOUT,123)ITYPE(ISTOP)
  123 FORMAT('***** ERROR IN EVALM--LAST TERM ',
     1'IN AN INTERMEDIATE EXPRESSION = A LIBRARY FUNCTION = ',A4)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
  130 CONTINUE
C
CCCCC APRIL 1995.  ADD FOLLOWING LINE.
CCCCC ILIBC1=ILIBC1+1
C
      NOP=0
      NTERM=0
      NUMSAV=0
      I=ISTART
C
  150 CONTINUE
      IDEL=1
      IP1=I+1
      IP2=I+2
      IP3=I+3
      IP4=I+4
      IP5=I+5
      IF(ITYPE(I).EQ.'N')GOTO200
      IF(ITYPE(I).EQ.'X')GOTO200
      IF(ITYPE(I).EQ.'PAR')GOTO200
      IF(ITYPE(I).EQ.'V')GOTO200
      IF(ITYPE(I).EQ.'OP')GOTO300
      IF(ITYPE(I).EQ.'LF'.AND.ITYPE(IP1).EQ.'V')GOTO400
      IF(ITYPE(I).EQ.'LF'.AND.ITYPE(IP1).EQ.'N')GOTO400
      IF(ITYPE(I).EQ.'LF'.AND.ITYPE(IP1).EQ.'X')GOTO400
      IF(ITYPE(I).EQ.'LF'.AND.ITYPE(IP1).EQ.'PAR')GOTO400
      IF(ITYPE(I).EQ.'COM')NUMSAV=NUMSAV+1
      IF(ITYPE(I).EQ.'COM')GOTO100
      WRITE(ICOUT,105)
  105 FORMAT('***** ERROR IN EVALM--',
     1'UNKNOWN ARGUMENT/OPERATION TYPE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,106)I,ITYPE(I)
  106 FORMAT('I,ITYPE(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
  200 CONTINUE
      IF(NUMSAV.GE.1)GOTO250
      NTERM=NTERM+1
      TERM(NTERM)=W2(I)
      IOP(NTERM)='V'
CCCCC APRIL 1995.  INITIALIZE SAVE1, ... ,SAVE4.  BUG IN HEAVE
CCCCC FUNCTION (HEAVE(X,A,B), WHERE A AND B ARE BOTH OPTIONAL).
CCCCC SAVE1(ILIBC1)=(-99.9)
CCCCC SAVE2(ILIBC1)=(-99.9)
CCCCC SAVE3(ILIBC1)=(-99.9)
CCCCC SAVE4(ILIBC1)=(-99.9)
      GOTO100
  250 CONTINUE
CCCCC THE FOLLOWING 3 LINES WERE CHANGED     MAY 1994
CCCCC FOLLOWING SECTIONS MODIFIED FOR DOUBLY NON-CENTRAL F
CCCCC WHICH HAS 5 ARGUEMNTS.                 SEPTEMBER 1994.
CCCCC IF(NUMSAV.EQ.1)SAVE1=W2(I)
CCCCC IF(NUMSAV.EQ.2)SAVE2=W2(I)
CCCCC IF(NUMSAV.EQ.3)SAVE3=W2(I)
      IF(NUMSAV.EQ.1)THEN
         SAVE1(ILIBC1)=W2(I)
CCCCC    SAVE2(ILIBC1)=(-99.9)
CCCCC    SAVE3(ILIBC1)=(-99.9)
CCCCC    SAVE4(ILIBC1)=(-99.9)
      ENDIF
      IF(NUMSAV.EQ.2)THEN
         SAVE2(ILIBC1)=W2(I)
CCCCC    SAVE3(ILIBC1)=(-99.9)
CCCCC    SAVE4(ILIBC1)=(-99.9)
      ENDIF
      IF(NUMSAV.EQ.3)THEN
         SAVE3(ILIBC1)=W2(I)
CCCCC    SAVE4(ILIBC1)=(-99.9)
      ENDIF
      IF(NUMSAV.EQ.4)THEN
         SAVE4(ILIBC1)=W2(I)
      ENDIF
      IF(NUMSAV.EQ.5)THEN
         SAVE5(ILIBC1)=W2(I)
      ENDIF
      IF(NUMSAV.EQ.6)THEN
         SAVE6(ILIBC1)=W2(I)
      ENDIF
      IF(NUMSAV.EQ.7)THEN
         SAVE7(ILIBC1)=W2(I)
      ENDIF
      IF(NUMSAV.EQ.8)THEN
         SAVE8(ILIBC1)=W2(I)
      ENDIF
      GOTO100
C
  300 CONTINUE
      IF(IW2(I).EQ.'+')GOTO310
      IF(IW2(I).EQ.'-')GOTO310
      IF(IW2(I).EQ.'*')GOTO320
      IF(IW2(I).EQ.'/')GOTO320
      IF(IW2(I).EQ.'**')GOTO320
      WRITE(ICOUT,305)
  305 FORMAT('***** ERROR IN EVALM--',
     1'NOT ONE OF THE 5 OPERATIONS:  + - * / **')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,306)I,IW2(I),IW22(I)
  306 FORMAT('I,IW2(I),IW22(I) = ',I8,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
  310 CONTINUE
      NOP=NOP+1
      IOP(NOP)=IW2(I)
      IF(NTERM.EQ.0)TERM(1)=0.0
      IF(NTERM.EQ.0)NTERM=1
      GOTO100
  320 NOP=NOP+1
      IOP(NOP)=IW2(I)
      IF(NTERM.EQ.0)WRITE(ICOUT,322)
  322 FORMAT('*, /, OR ** STARTS AN EXPRESSION')
      IF(NTERM.EQ.0)CALL DPWRST('XXX','BUG ')
      IF(NTERM.EQ.0)IERROR='YES'
      IF(NTERM.EQ.0)GOTO9000
CCCCC APRIL 1995.  ADD FOLLOWING LINE
CCCCC ILIBC2=ILIBC2+1
      GOTO100
C
  400 CONTINUE
C     PERFORM A LIBRARY FUNCTION EVALUATION.
      IF(IBUGEV.EQ.'ON')WRITE(ICOUT,331)
  331 FORMAT('IN EVALM, BEFORE ENTERING DPLIBF--')
      IF(IBUGEV.EQ.'ON')CALL DPWRST('XXX','BUG ')
      IF(IBUGEV.EQ.'ON')WRITE(ICOUT,332)IW2(I),IW22(I),W2(IP1),IBUGEV
  332 FORMAT('IW2(I),IW22(I),W2(IP1),IBUGEV = ',A4,2X,A4,2X,F10.5,
     12X,A4)
      IF(IBUGEV.EQ.'ON')CALL DPWRST('XXX','BUG ')
C
CCCCC THE SAVE3 ARGUMENT WAS ADDED MARCH 1989
CCCCC THE SAVE4 ARGUMENT WAS ADDED SEPTEMBER 1994.
CCCCC CALL DPLIBF(IW2(I),IW22(I),W2(IP1),SAVE1,SAVE2,SAVE3,I,IANGLU,
CCCCC1RESULT,IBUGEV,IERROR)
CCCCC CHANGE FOLLOWING LINE APRIL 1995
CCCCC CALL DPLIBF(IW2(I),IW22(I),W2(IP1),SAVE1,SAVE2,SAVE3,SAVE4,I,
      ILIBC2=ILIBC2+1
      IF(ILIBC2.GT.0)THEN
        ASAV1=SAVE1(ILIBC2)
        ASAV2=SAVE2(ILIBC2)
        ASAV3=SAVE3(ILIBC2)
        ASAV4=SAVE4(ILIBC2)
        ASAV5=SAVE5(ILIBC2)
        ASAV6=SAVE6(ILIBC2)
        ASAV7=SAVE7(ILIBC2)
        ASAV8=SAVE8(ILIBC2)
      ELSE
        ASAV1=0.0
        ASAV2=0.0
        ASAV3=0.0
        ASAV4=0.0
        ASAV5=0.0
        ASAV6=0.0
        ASAV7=0.0
        ASAV8=0.0
      ENDIF
      CALL DPLIBF(IW2(I),IW22(I),W2(IP1),ASAV1,ASAV2,ASAV3,ASAV4,
     1ASAV5,ASAV6,ASAV7,ASAV8,
     1I,
     1IANGLU,RESULT,IBUGEV,IERROR)
C
      IF(IBUGEV.EQ.'ON')WRITE(ICOUT,333)
  333 FORMAT('IN EVALM, AFTER RETURNING FROM DPLIBF--')
      IF(IBUGEV.EQ.'ON')CALL DPWRST('XXX','BUG ')
      IF(IBUGEV.EQ.'ON')WRITE(ICOUT,334)RESULT,IERROR
  334 FORMAT('RESULT, IERROR = ',F20.10,2X,A4)
      IF(IBUGEV.EQ.'ON')CALL DPWRST('XXX','BUG ')
      IF(IERROR.EQ.'YES')GOTO9000
      NTERM=NTERM+1
      TERM(NTERM)=RESULT
C
  490 CONTINUE
      IOP(NTERM)='V'
C
C     CHECK THAT NTERM HAS NOT EXCEEDED MAXTER (USUALLY 80)
C
      IF(NTERM.LE.MAXTER)GOTO1900
      WRITE(ICOUT,1901)
 1901 FORMAT('***** ERROR IN EVALM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1902)
 1902 FORMAT('      THE VARIABLE NTERM HAS JUST EXCEEDED')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1903)
 1903 FORMAT('      THE MAX ALLOWABLE LIMIT DEFINED ',
     1'BY THE INTERNAL VARIABLE MAXTER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1904)MAXTER
 1904 FORMAT('      THIS LIMIT IS MAXTER = ',I8)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1900 CONTINUE
C
      IDEL=2
  100 CONTINUE
      I=I+IDEL
      IF(I.LE.ISTOP)GOTO150
      IF(IBUGEV.EQ.'OFF')GOTO499
      WRITE(ICOUT,491)
  491 FORMAT('AFTER THE LIBRARY FUNCTIONS HAVE BEEN ',
     1'EVALUATED AND ELIMINATED--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,492)NTERM,NOP
  492 FORMAT('NTERM,NOP = ',2I6)
      CALL DPWRST('XXX','BUG ')
      DO493I=1,NTERM
      WRITE(ICOUT,494)I,TERM(I),IOP(I)
  494 FORMAT('I,TERM(I),IOP(I) = ',I6,E15.7,2X,A4)
      CALL DPWRST('XXX','BUG ')
  493 CONTINUE
  499 CONTINUE
C
C               *******************************************************
C               **  STEP 2--                                         **
C               **  CHECK TO SEE THAT THE NUMBER OF TERMS =          **
C               **  ONE MORE THAN THE NUMBER OF OPERATIONS.          **
C               **  ALSO CHECK TO SEE IF THE SPECIAL CASE            **
C               **  EXISTS WHERE THERE IS ONLY 1 TERM--              **
C               **  IF SO, SET ANS = TO THIS FIRST TERM AND GOTO9000.  **
C               *******************************************************
C
      NOPP1=NOP+1
      IF(NTERM.EQ.NOPP1)GOTO550
      WRITE(ICOUT,560)
  560 FORMAT('***** ERROR IN EVALM--NUMBER OF TERMS ',
     1'NOT EQUAL TO NUMBER OF OPERATIONS + 1')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,566)NTERM,NOPP1
  566 FORMAT('NTERM,NOPP1 = ',I8,2X,I8)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
  550 CONTINUE
      IF(NTERM.GE.2)GOTO990
      IF(NTERM.EQ.1)GOTO570
      WRITE(ICOUT,571)
  571 FORMAT('***** ERROR IN EVALM--',
     1'NUMBER OF TERMS = 0 AT END ',
     1'OF STEP 2 (LIBRARY FUNCTIONS ELIMINATED)')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
  570 CONTINUE
      ANS=TERM(1)
      GOTO9000
  990 CONTINUE
C
C               ****************************************************************
C               **  STEP 3--
C               **  OPERATE ON THE TERM(.) AND IOP(.) VECTORS.
C               **  AT THIS POINT WE HAVE ONLY ALTERNATING TERMS AND OPERATIONS
C               **  WHERE AN OPERATION IS ANY ONE OF THE 5--
C               **  +   -   *   /   **.
C               **  EVALUATE AND ELIMINATE ALL **.
C               **  SQUEEZE THE TERM(.) AND IOP(.) VECTORS UNTIL
C               **  UNTIL ALL ** ARE GONE.
C               ****************************************************************
C
 1000 CONTINUE
      I=1
 1100 CONTINUE
      IF(IOP(I).EQ.'**')GOTO1200
      GOTO1300
C
 1200 CONTINUE
      IP1=I+1
 1210 CONTINUE
      T1=TERM(I)
      T2=TERM(IP1)
      T3=ABS(T1)
      T4=ABS(T2)
      T34=0.0
      IF(T3.GT.0.0.AND.T4.GT.0.0)T34=T4*LOG(T3)
      IF(T34.GT.ALCPUM)GOTO1211
      IF(T1.NE.CPUMIN.AND.T1.NE.CPUMAX.AND.
     1   T2.NE.CPUMIN.AND.T2.NE.CPUMAX)GOTO1219
      IF(T1.EQ.CPUMIN.AND.T4.LE.1.0)GOTO1219
      IF(T2.EQ.CPUMIN.AND.T3.LE.1.0)GOTO1219
      IF(T1.EQ.CPUMAX.AND.T4.LE.1.0)GOTO1219
      IF(T2.EQ.CPUMAX.AND.T3.LE.1.0)GOTO1219
 1211 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1212)
 1212 FORMAT('***** ERROR IN EVALM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1213)
 1213 FORMAT('      ATTEMPT TO CARRY OUT AN OPERATION ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1214)
 1214 FORMAT('      WHICH RESULTS IN AN OUT-OF-RANGE NUMBER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1215)
 1215 FORMAT('      THE OPERATION      = **')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1216)T1
 1216 FORMAT('      THE FIRST  OPERAND = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1217)T2
 1217 FORMAT('      THE SECOND OPERAND = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1219 CONTINUE
C
 1220 CONTINUE
      IF(T1.NE.0.0)GOTO1229
CCCCC BUG FIX.  IF T2 IS POSITIVE, SET 0**T2 TO ZERO.  NOVEMBER 1998.
CCCCC IF(T2.GT.0.0)GOTO1229
      IF(T2.GT.0.0)THEN
        TERM(I)=0.0
        GOTO1239
      ENDIF
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1221)
 1221 FORMAT('***** ERROR IN EVALM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1222)
 1222 FORMAT('      ATTEMPT TO RAISE A ZERO NUMBER ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1223)
 1223 FORMAT('      TO A ZERO OR NEGATIVE POWER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1226)T2
 1226 FORMAT('      THE POWER           = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1229 CONTINUE
      IF(T1.GT.0.0)GOTO1237
C
CCCCC T6=AINT(T2)
CCCCC REM=T2-T6
CCCCC ABSREM=ABS(REM)
      ABST2=ABS(T2)
      ISIGN=(-1)
      IF(T2.GE.0.0)ISIGN=1
      IABST2=ABST2+0.5
      AIABS2=IABST2
      REM=ABST2-AIABS2
      ABSREM=ABS(REM)
      IF(ABSREM.GE.CUTOFF)GOTO1230
      IF(IBUGEV.EQ.'ON')WRITE(ICOUT,7777)T1,T2,ABST2,ISIGN,IABST2
 7777 FORMAT('T1,T2,ABST2,ISIGN,IABST2 = ',3E15.7,2I8)
      IF(IBUGEV.EQ.'ON')CALL DPWRST('XXX','BUG ')
      IF(IBUGEV.EQ.'ON')WRITE(ICOUT,7778)AIABS2,REM,ABSREM,TERM(I)
 7778 FORMAT('AIABS2,REM,ABSREM,TERM(I) = ',4E15.7)
      IF(IBUGEV.EQ.'ON')CALL DPWRST('XXX','BUG ')
      TERM(I)=TERM(I)**(ISIGN*IABST2)
      GOTO1239
C
 1230 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1231)
 1231 FORMAT('***** ERROR IN EVALM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1232)
 1232 FORMAT('      ATTEMPT TO RAISE A NEGATIVE NUMBER ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1233)
 1233 FORMAT('      TO A FRACTIONAL POWER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1235)T1
 1235 FORMAT('      THE NEGATIVE NUMBER = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1236)T2
 1236 FORMAT('      THE POWER           = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 1237 CONTINUE
      IF(IBUGEV.EQ.'ON')WRITE(ICOUT,1238)I,TERM(I),TERM(IP1),T1,T2,
     1AIABS2,REM
 1238 FORMAT('I,TERM(I),TERM(IP1),T1,T2,AIABS2,REM = ',I4,6E14.6)
      IF(IBUGEV.EQ.'ON')CALL DPWRST('XXX','BUG ')
CCCCC FOLLOWING LINE SEEMS TO SHOW A COMPILER BUG FOR THE OLDER LAHEY
CCCCC COMPILER.  WORKAROUND FOR THIS COMPILER.   SEPTEMBER 1997.
CCCCC TERM(I)=TERM(I)**TERM(IP1)
      IF(ICOMPI.NE.'LAHE')THEN
        TERM(I)=TERM(I)**TERM(IP1)
      ELSE
        ATEMP1=TERM(IP1)*LOG(TERM(I))
        TERM(I)=EXP(ATEMP1)
      ENDIF
      GOTO1239
C
 1239 CONTINUE
CCCCC CALL EVEXP(TERM(I),TERM(IP1),RESULT)
CCCCC TERM(I)=RESULT
      NOPM1=NOP-1
      IF(I.GE.NOP)GOTO1490
      DO1400J=I,NOPM1
      JP1=J+1
      JP2=J+2
      IOP(J)=IOP(JP1)
      TERM(JP1)=TERM(JP2)
 1400 CONTINUE
 1490 CONTINUE
      NOP=NOPM1
      GOTO1350
 1300 CONTINUE
      I=I+1
 1350 CONTINUE
      IF(I.LE.NOP)GOTO1100
 1500 CONTINUE
      NTERM=NOP+1
      IF(IBUGEV.EQ.'OFF')GOTO1990
      WRITE(ICOUT,1991)
 1991 FORMAT('AFTER THE ** HAVE BEEN ',
     1'EVALUATED AND ELIMINATED--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1992)NTERM,NOP
 1992 FORMAT('NTERM,NOP = ',2I6)
      CALL DPWRST('XXX','BUG ')
      DO1993I=1,NTERM
      WRITE(ICOUT,1994)I,TERM(I),IOP(I)
 1994 FORMAT('I,TERM(I),IOP(I) = ',I6,E15.7,2X,A4)
      CALL DPWRST('XXX','BUG ')
 1993 CONTINUE
 1990 CONTINUE
C
C               ****************************************************************
C               **  STEP 4--
C               **  OPERATE ON THE TERM(.) AND IOP(.) VECTORS.
C               **  AT THIS POINT WE HAVE ONLY ALTERNATING TERMS AND OPERATIONS
C               **  WHERE AN OPERATION IS ANY ONE OF THE 4--
C               **  +   -   *   /   .
C               **  EVALUATE AND ELIMINATE ALL * AND / IN SEQUENCE.
C               **  SQUEEZE THE TERM(.) AND IOP(.) VECTORS UNTIL
C               **  UNTIL ALL * AND / ARE GONE.
C               ****************************************************************
C
 2000 CONTINUE
      I=1
 2100 CONTINUE
      IF(IOP(I).EQ.'*')GOTO2210
      IF(IOP(I).EQ.'/')GOTO2220
      GOTO2300
 2210 CONTINUE
      IP1=I+1
      T1=TERM(I)
      T2=TERM(IP1)
      T3=ABS(T1)
      T4=ABS(T2)
      T34=0.0
      IF(T3.GT.0.0.AND.T4.GT.0.0)T34=LOG(T3)+LOG(T4)
      IF(T34.GT.ALCPUM)GOTO2211
CCCCC THE FOLLOWING 2 LINES WERE INSERTED JUNE 1989
      IF(T34.LT.-ALCPUM)TERM(I)=0.0
      IF(T34.LT.-ALCPUM)GOTO2250
      IF(T1.NE.CPUMIN.AND.T1.NE.CPUMAX.AND.
     1   T2.NE.CPUMIN.AND.T2.NE.CPUMAX)GOTO2219
      IF(T1.EQ.CPUMIN.AND.T4.LE.1.0)GOTO2219
      IF(T2.EQ.CPUMIN.AND.T3.LE.1.0)GOTO2219
      IF(T1.EQ.CPUMAX.AND.T4.LE.1.0)GOTO2219
      IF(T2.EQ.CPUMAX.AND.T3.LE.1.0)GOTO2219
 2211 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2212)
 2212 FORMAT('***** ERROR IN EVALM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2213)
 2213 FORMAT('      ATTEMPT TO CARRY OUT AN OPERATION ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2214)
 2214 FORMAT('      WHICH RESULTS IN AN OUT-OF-RANGE NUMBER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2215)
 2215 FORMAT('      THE OPERATION      = *')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2216)T1
 2216 FORMAT('      THE FIRST  OPERAND = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2217)T2
 2217 FORMAT('      THE SECOND OPERAND = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 2219 CONTINUE
      TERM(I)=TERM(I)*TERM(IP1)
      GOTO2250
C
 2220 CONTINUE
      IP1=I+1
      T1=TERM(I)
      T2=TERM(IP1)
      T3=ABS(T1)
      T4=ABS(T2)
      T34=0.0
      IF(T3.GT.0.0.AND.T4.GT.0.0)T34=LOG(T3)-LOG(T4)
      IF(T34.GT.ALCPUM)GOTO2221
CCCCC THE FOLLOWING 2 LINES WERE INSERTED JUNE 1989
      IF(T34.LT.-ALCPUM)TERM(I)=0.0
      IF(T34.LT.-ALCPUM)GOTO2250
      IF(T1.NE.CPUMIN.AND.T1.NE.CPUMAX.AND.
     1   T2.NE.CPUMIN.AND.T2.NE.CPUMAX)GOTO2229
      IF(T1.EQ.CPUMIN.AND.T4.GE.1.0)GOTO2229
      IF(T1.EQ.CPUMAX.AND.T4.GE.1.0)GOTO2229
 2221 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2222)
 2222 FORMAT('***** ERROR IN EVALM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2223)
 2223 FORMAT('      ATTEMPT TO CARRY OUT AN OPERATION ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2224)
 2224 FORMAT('      WHICH RESULTS IN AN OUT-OF-RANGE NUMBER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2225)
 2225 FORMAT('      THE OPERATION      = /')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2226)T1
 2226 FORMAT('      THE FIRST  OPERAND = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2227)T2
 2227 FORMAT('      THE SECOND OPERAND = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 2229 CONTINUE
      IF(T2.NE.0.0)GOTO2239
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2231)
 2231 FORMAT('***** ERROR IN EVALM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2232)
 2232 FORMAT('      ATTEMPT TO DIVIDE A NUMBER ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2233)
 2233 FORMAT('      BY ZERO.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2235)T1
 2235 FORMAT('      THE NUMERATOR   = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2236)T2
 2236 FORMAT('      THE DENOMINATOR = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 2239 CONTINUE
      TERM(I)=TERM(I)/TERM(IP1)
      GOTO2250
C
 2250 CONTINUE
      NOPM1=NOP-1
      IF(I.GE.NOP)GOTO2490
      DO2400J=I,NOPM1
      JP1=J+1
      JP2=J+2
      IOP(J)=IOP(JP1)
      TERM(JP1)=TERM(JP2)
 2400 CONTINUE
 2490 CONTINUE
      NOP=NOPM1
      GOTO2350
 2300 CONTINUE
      I=I+1
 2350 CONTINUE
      IF(I.LE.NOP)GOTO2100
 2500 CONTINUE
      NTERM=NOP+1
      IF(IBUGEV.EQ.'OFF')GOTO2990
      WRITE(ICOUT,2991)
 2991 FORMAT('AFTER THE * AND / HAVE BEEN ',
     1'EVALUATED AND ELIMINATED--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2992)NTERM,NOP
 2992 FORMAT('NTERM,NOP = ',2I6)
      CALL DPWRST('XXX','BUG ')
      DO2993I=1,NTERM
      WRITE(ICOUT,2994)I,TERM(I),IOP(I)
 2994 FORMAT('I,TERM(I),IOP(I) = ',I6,E15.7,2X,A4)
      CALL DPWRST('XXX','BUG ')
 2993 CONTINUE
 2990 CONTINUE
C
C               ****************************************************************
C               **  STEP 5--
C               **  OPERATE ON THE TERM(.) AND IOP(.) VECTORS.
C               **  AT THIS POINT WE HAVE ONLY ALTERNATING TERMS AND OPERATIONS
C               **  WHERE AN OPERATION IS ANY ONE OF THE 2--
C               **  + OR - .
C               **  EVALUATE ALL + OR - OPERATIONS IN SEQUENCE.
C               **  SQUEEZE THE TERM(.) AND IOP(.) VECTORS UNTIL
C               **  UNTIL ALL + AND - OPERATIONS ARE GONE.
C               ****************************************************************
C
 3000 CONTINUE
      IF(NOP.GE.1)GOTO3100
      ANS=TERM(1)
      GOTO9000
 3100 CONTINUE
      ANS=TERM(1)
      DO3200I=1,NOP
      IP1=I+1
      IF(IOP(I).EQ.'+')GOTO3210
      IF(IOP(I).EQ.'-')GOTO3220
      GOTO3210
 3210 CONTINUE
      T1=TERM(I)
      T2=TERM(IP1)
      IF(T1.NE.CPUMIN.AND.T1.NE.CPUMAX.AND.
     1   T2.NE.CPUMIN.AND.T2.NE.CPUMAX)GOTO3219
      IF(T1.EQ.CPUMIN.AND.T2.GE.0.0)GOTO3219
      IF(T2.EQ.CPUMIN.AND.T1.GE.0.0)GOTO3219
      IF(T1.EQ.CPUMAX.AND.T2.LE.0.0)GOTO3219
      IF(T2.EQ.CPUMAX.AND.T1.LE.0.0)GOTO3219
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3211)
 3211 FORMAT('***** ERROR IN EVALM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3212)
 3212 FORMAT('      ATTEMPT TO CARRY OUT AN OPERATION ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3213)
 3213 FORMAT('      WHICH RESULTS IN AN OUT-OF-RANGE NUMBER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3214)
 3214 FORMAT('      THE OPERATION      = +')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3215)T1
 3215 FORMAT('      THE FIRST  OPERAND = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3216)T2
 3216 FORMAT('      THE SECOND OPERAND = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 3219 CONTINUE
      ANS=ANS+TERM(IP1)
      GOTO3200
C
 3220 CONTINUE
      T1=TERM(I)
      T2=TERM(IP1)
      IF(T1.NE.CPUMIN.AND.T1.NE.CPUMAX.AND.
     1   T2.NE.CPUMIN.AND.T2.NE.CPUMAX)GOTO3229
      IF(T1.EQ.CPUMIN.AND.T2.LE.0.0)GOTO3229
      IF(T2.EQ.CPUMIN.AND.T1.LE.0.0)GOTO3229
      IF(T1.EQ.CPUMAX.AND.T2.GE.0.0)GOTO3229
      IF(T2.EQ.CPUMAX.AND.T1.GE.0.0)GOTO3229
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3221)
 3221 FORMAT('***** ERROR IN EVALM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3222)
 3222 FORMAT('      ATTEMPT TO CARRY OUT AN OPERATION ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3223)
 3223 FORMAT('      WHICH RESULTS IN AN OUT-OF-RANGE NUMBER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3224)
 3224 FORMAT('      THE OPERATION      = -')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3225)T1
 3225 FORMAT('      THE FIRST  OPERAND = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3226)T2
 3226 FORMAT('      THE SECOND OPERAND = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 3229 CONTINUE
      ANS=ANS-TERM(IP1)
      GOTO3200
 3200 CONTINUE
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGEV.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF EVALM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)ANS,IERROR
 9012 FORMAT('ANS,IERROR = ',E15.7,2X,A4)
      CALL DPWRST('XXX','BUG ')
      DO9113I=1,5
      WRITE(ICOUT,9013)I,SAVE1(I),SAVE2(I),SAVE3(I),SAVE4(I)
 9013 FORMAT('I,SAVE1,SAVE2,SAVE3,SAVE4 = ',I3,5E15.7)
      CALL DPWRST('XXX','BUG ')
 9113 CONTINUE
      WRITE(ICOUT,9014)IBUGEV
 9014 FORMAT('IBUGEV = ',A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE EWECDF(X,GAMMA,THETA,MINMAX,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE EXPONENTIATED WEIBULL
C              DISTRIBUTION WITH SINGLE PRECISION
C              TAIL LENGTH PARAMETER = GAMMA, SHAPE PARAMETER THETA.
C              THERE ARE 2 SUCH EXPONETIATED WEIBULL FAMILIES--
C                 ONE FOR THE MIN ORDER STAT (THE USUAL) AND
C                 ONE FOR THE MAX ORDER STAT.
C              (SEE SARHAN & GREENBERG, PAGE 69)
C              THE EXPONETIATED WEIBULL TYPE IS SPECIFIED VIA   MINMAX
C              FOR MINMAX = 1  (FOR THE DEFAULT MINIMUM)
C                 THE EXPONETIATED EXPONENTIATED WEIBULL DISTRIBUTION USED
C                 HEREIN IS DEFINED FOR ALL POSITIVE X,
C                 AND HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = (THETA*GAMMA)*(X**(GAMMA-1)) * EXP(-(X**GAMMA))
C                        *(1-EXP(-(X**GAMMA))**(THETA-1)
C              FOR MINMAX = 2 (FOR THE MAXIMUM),
C                 THE EXPONETIATED EXPONENTIATED WEIBULL DISTRIBUTION USED
C                 HEREIN IS DEFINED FOR ALL NEGATIVE X,
C                 AND HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = ...
C                 F(X) = GAMMA * (X**(GAMMA-1)) * EXP(-(X**GAMMA)).
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE NON-NEGATIVE.
C                     --GAMMA  = THE SHAPE PARAMETER
C                                GAMMA SHOULD BE POSITIVE.
C                     --THETA  = THE SINGLE PRECISION VALUE
C                                OF THE SECOND SHAPE PARAMETER.
C                                THETA SHOULD BE POSITIVE.
C                     --MINMAX = THE INTEGER VALUE
C                                IDENTIFYING THE
C                                CHOSEN EXPONENTIATED WEIBULL DISTRIBUTION.
C                                1 = MIN, 2 = MAX.
C     OUTPUT ARGUMENTS--CDF    = THE SINGLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE EXPONENTIATED WEIBULL DISTRIBUTION
C             WITH TAIL LENGHT PARAMETER = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C                 --GAMMA SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--SARHAN & GREENBERG,
C                 CONTRIBUTIONS TO ORDER STATISTICS,
C                 1962, WILEY, PAGE 69.
C               --MUDHOLKAR AND SRIVASTAVE, "THE EXPONENTIATED WEIBULL
C                 FAMILY: A REANALYSIS OF THE BUS-MOTOR-FAILURE DATA",
C                 TECHNOMETRICS, NOVEMBER, 1995, PP436-437.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--95/10
C     ORIGINAL VERSION--OCTOBER   1995.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION DX
      DOUBLE PRECISION DG
      DOUBLE PRECISION DT
      DOUBLE PRECISION DTERM1, DTERM2
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15)
   15   FORMAT('***** ERROR--THE SECOND ARGUMENT TO ',
     1         'EWECDF IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
   46   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        CDF=0.0
        GOTO9000
      ENDIF
      IF(THETA.LE.0.0)THEN
        WRITE(ICOUT,25)
   25   FORMAT('***** ERROR--THE THIRD ARGUMENT TO ',
     1         'EWECDF IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)THETA
        CALL DPWRST('XXX','BUG ')
        CDF=0.0
        GOTO9000
      ENDIF
C
       IF(X.LE.0.0)THEN
         CDF=0.0
       ELSE 
         DX=DBLE(X)
         DG=DBLE(GAMMA)
         DT=DBLE(THETA)
         DTERM1=DLOG(1.0D0-DEXP(-(DX**DG)))
         DTERM2=DT*DTERM1
         DCDF=DEXP(DTERM2)
         CDF=REAL(DCDF)
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EWECHA(X,GAMMA,THETA,MINMAX,HAZ)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE HAZARD
C              FUNCTION VALUE FOR THE EXPONENTIATED WEIBULL
C              DISTRIBUTION WITH SINGLE PRECISION
C              TAIL LENGTH PARAMETER = GAMMA, SHAPE PARAMETER THETA.
C              FOR MINMAX = 1  (FOR THE DEFAULT MINIMUM)
C                 THE EXPONETIATED EXPONENTIATED WEIBULL DISTRIBUTION USED
C                 HEREIN IS DEFINED FOR ALL POSITIVE X,
C                 AND HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = (THETA*GAMMA)*(X**(GAMMA-1)) * EXP(-(X**GAMMA))
C                        *(1-EXP(-(X**GAMMA))**(THETA-1)
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE HAZARD
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE NON-NEGATIVE.
C                     --GAMMA  = THE SHAPE PARAMETER
C                                GAMMA SHOULD BE POSITIVE.
C                     --THETA  = THE SINGLE PRECISION VALUE
C                                OF THE SECOND SHAPE PARAMETER.
C                                THETA SHOULD BE POSITIVE.
C                     --MINMAX = THE INTEGER VALUE
C                                IDENTIFYING THE
C                                CHOSEN EXPONENTIATED WEIBULL DISTRIBUTION.
C                                1 = MIN, 2 = MAX.
C     OUTPUT ARGUMENTS--HAZ    = THE SINGLE PRECISION CUMULATIVE HAZARD
C                                FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE HAZARD
C             FUNCTION VALUE FOR THE EXPONENTIATED WEIBULL DISTRIBUTION
C             WITH TAIL LENGTH PARAMETER GAMMA, SHAPE PARAMETER THETA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE POSITIVE
C                 --GAMMA, THETA SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--MUDHOLKAR AND SRIVASTAVE, "THE EXPONENTIATED WEIBULL
C                 FAMILY: A REANALYSIS OF THE BUS-MOTOR-FAILURE DATA",
C                 TECHNOMETRICS, NOVEMBER, 1995, PP436-437.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--98/5
C     ORIGINAL VERSION--MAY       1998.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DHAZ
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION DX
      DOUBLE PRECISION DG
      DOUBLE PRECISION DT
      DOUBLE PRECISION DTERM1, DTERM2
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15)
   15   FORMAT('***** ERROR--THE SECOND ARGUMENT TO ',
     1         'EWECHA IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
   46   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        HAZ=0.0
        GOTO9000
      ENDIF
      IF(THETA.LE.0.0)THEN
        WRITE(ICOUT,25)
   25   FORMAT('***** ERROR--THE THIRD ARGUMENT TO ',
     1         'EWECHA IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)THETA
        CALL DPWRST('XXX','BUG ')
        HAZ=0.0
        GOTO9000
      ENDIF
C
C
      IF(X.LE.0.0)THEN
        HAZ=0.0
      ELSE
C
        DX=DBLE(X)
        DT=DBLE(THETA)
        DG=DBLE(GAMMA)
        DTERM1=DLOG(1.0D0-DEXP(-(DX**DG)))
        DTERM2=DT*DTERM1
        DCDF=DEXP(DTERM2)
C
        DHAZ=-DLOG(1.0D0-DCDF)
        HAZ=SNGL(DHAZ)
C
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EWEHAZ(X,GAMMA,THETA,MINMAX,HAZ)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE HAZARD
C              FUNCTION VALUE FOR THE EXPONENTIATED WEIBULL
C              DISTRIBUTION WITH SINGLE PRECISION
C              TAIL LENGTH PARAMETER = GAMMA, SHAPE PARAMETER THETA.
C              FOR MINMAX = 1  (FOR THE DEFAULT MINIMUM)
C                 THE EXPONETIATED EXPONENTIATED WEIBULL DISTRIBUTION USED
C                 HEREIN IS DEFINED FOR ALL POSITIVE X,
C                 AND HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = (THETA*GAMMA)*(X**(GAMMA-1)) * EXP(-(X**GAMMA))
C                        *(1-EXP(-(X**GAMMA))**(THETA-1)
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE NON-NEGATIVE.
C                     --GAMMA  = THE SHAPE PARAMETER
C                                GAMMA SHOULD BE POSITIVE.
C                     --THETA  = THE SINGLE PRECISION VALUE
C                                OF THE SECOND SHAPE PARAMETER.
C                                THETA SHOULD BE POSITIVE.
C                     --MINMAX = THE INTEGER VALUE
C                                IDENTIFYING THE
C                                CHOSEN EXPONENTIATED WEIBULL DISTRIBUTION.
C                                1 = MIN, 2 = MAX.
C     OUTPUT ARGUMENTS--HAZ    = THE SINGLE PRECISION HAZARD FUNCTION
C                                VALUE.
C     OUTPUT--THE SINGLE PRECISION HAZARD
C             FUNCTION VALUE FOR THE EXPONENTIATED WEIBULL DISTRIBUTION
C             WITH TAIL LENGTH PARAMETER GAMMA, SHAPE PARAMETER THETA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE POSITIVE
C                 --GAMMA, THETA SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--MUDHOLKAR AND SRIVASTAVE, "THE EXPONENTIATED WEIBULL
C                 FAMILY: A REANALYSIS OF THE BUS-MOTOR-FAILURE DATA",
C                 TECHNOMETRICS, NOVEMBER, 1995, PP436-437.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--98/5
C     ORIGINAL VERSION--MAY       1998.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DHAZ
      DOUBLE PRECISION DX
      DOUBLE PRECISION DG
      DOUBLE PRECISION DT
      DOUBLE PRECISION DTERM1, DTERM2, DTERM3, DTERM4, DTERM5
      DOUBLE PRECISION DTERM6, DTERM7
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15)
   15   FORMAT('***** ERROR--THE SECOND ARGUMENT TO ',
     1         'EWEHAZ IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
   46   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        HAZ=0.0
        GOTO9000
      ENDIF
      IF(THETA.LE.0.0)THEN
        WRITE(ICOUT,25)
   25   FORMAT('***** ERROR--THE THIRD ARGUMENT TO ',
     1         'EWEHAZ IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)THETA
        CALL DPWRST('XXX','BUG ')
        HAZ=0.0
        GOTO9000
      ENDIF
C
      IF(X.LE.0.0)THEN
        HAZ=0.0
      ELSE
        DX=DBLE(X)
        DT=DBLE(THETA)
        DG=DBLE(GAMMA)
C
        DTERM7=DEXP(-(DX**DG))
        DTERM1=DLOG(DG) + DLOG(DT)
        DTERM2=(DT-1.0D0)*DLOG(1.0D0-DTERM7)
        DTERM3=-(DX**DG)
        DTERM4=(DG-1.0D0)*DLOG(DX)
        DTERM5=DLOG(1.0D0 - (1.0D0 - DTERM7)**DT)
        DTERM6=DTERM1+DTERM2+DTERM3+DTERM4-DTERM5
        DHAZ=DEXP(DTERM6)
        HAZ=REAL(DHAZ)
C
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EWEPDF(X,GAMMA,THETA,MINMAX,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE EXPONENTIATED WEIBULL
C              DISTRIBUTION WITH SINGLE PRECISION
C              TAIL LENGTH PARAMETER = GAMMA, SHAPE PARAMETER THETA.
C              THERE ARE 2 SUCH EXPONETIATED WEIBULL FAMILIES--
C                 ONE FOR THE MIN ORDER STAT (THE USUAL) AND
C                 ONE FOR THE MAX ORDER STAT.
C              (SEE SARHAN & GREENBERG, PAGE 69)
C              THE EXPONETIATED WEIBULL TYPE IS SPECIFIED VIA   MINMAX
C              FOR MINMAX = 1  (FOR THE DEFAULT MINIMUM)
C                 THE EXPONETIATED EXPONENTIATED WEIBULL DISTRIBUTION USED
C                 HEREIN IS DEFINED FOR ALL POSITIVE X,
C                 AND HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = (THETA*GAMMA)*(X**(GAMMA-1)) * EXP(-(X**GAMMA))
C                        *(1-EXP(-(X**GAMMA))**(THETA-1)
C              FOR MINMAX = 2 (FOR THE MAXIMUM),
C                 THE EXPONETIATED EXPONENTIATED WEIBULL DISTRIBUTION USED
C                 HEREIN IS DEFINED FOR ALL NEGATIVE X,
C                 AND HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = ...
C                 F(X) = GAMMA * (X**(GAMMA-1)) * EXP(-(X**GAMMA)).
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE NON-NEGATIVE.
C                     --GAMMA  = THE SHAPE PARAMETER
C                                GAMMA SHOULD BE POSITIVE.
C                     --THETA  = THE SINGLE PRECISION VALUE
C                                OF THE SECOND SHAPE PARAMETER.
C                                THETA SHOULD BE POSITIVE.
C                     --MINMAX = THE INTEGER VALUE
C                                IDENTIFYING THE
C                                CHOSEN EXPONENTIATED WEIBULL DISTRIBUTION.
C                                1 = MIN, 2 = MAX.
C     OUTPUT ARGUMENTS--PDF    = THE SINGLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE FOR THE EXPONENTIATED WEIBULL DISTRIBUTION
C             WITH TAIL LENGHT PARAMETER = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE POSITIVE.
C                 --GAMMA SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--SARHAN & GREENBERG,
C                 CONTRIBUTIONS TO ORDER STATISTICS,
C                 1962, WILEY, PAGE 69.
C               --MUDHOLKAR AND SRIVASTAVE, "THE EXPONENTIATED WEIBULL
C                 FAMILY: A REANALYSIS OF THE BUS-MOTOR-FAILURE DATA",
C                 TECHNOMETRICS, NOVEMBER, 1995, PP436-437.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--95/10
C     ORIGINAL VERSION--OCTOBER   1995.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DPDF
      DOUBLE PRECISION DX
      DOUBLE PRECISION DG
      DOUBLE PRECISION DT
      DOUBLE PRECISION DTERM1, DTERM2, DTERM3, DTERM4, DTERM5
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15)
   15   FORMAT('***** ERROR--THE SECOND ARGUMENT TO ',
     1         'EWEPDF IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
   46   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9000
      ENDIF
      IF(THETA.LE.0.0)THEN
        WRITE(ICOUT,25)
   25   FORMAT('***** ERROR--THE THIRD ARGUMENT TO ',
     1         'EWEPDF IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)THETA
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9000
      ENDIF
C
       IF(X.LE.0.0)THEN
         PDF=0.0
       ELSE
         DX=DBLE(X)
         IF(DX.LT.0.0000001D0)DX=0.0000001D0
         DG=DBLE(GAMMA)
         DT=DBLE(THETA)
         DTERM1=DLOG(DG) + DLOG(DT)
         DTERM2=(DT-1.0D0)*DLOG(1.0D0-DEXP(-(DX**DG)))
         DTERM3=-(DX**DG)
         DTERM4=(DG-1.0D0)*DLOG(DX)
         DTERM5=DTERM1+DTERM2+DTERM3+DTERM4
         DPDF=DEXP(DTERM5)
         PDF=REAL(DPDF)
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EWEPPF(P,GAMMA,THETA,MINMAX,PPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE EXPONETIATED WEIBULL
C              DISTRIBUTION WITH SINGLE PRECISION
C              TAIL LENGTH PARAMETER = GAMMA, SHAPE PARAMETER THETA.
C              THERE ARE 2 SUCH EXPONETIATED WEIBULL FAMILIES--
C                 ONE FOR THE MIN ORDER STAT (THE USUAL) AND
C                 ONE FOR THE MAX ORDER STAT.
C              (SEE SARHAN & GREENBERG, PAGE 69)
C              THE EXPONETIATED WEIBULL TYPE IS SPECIFIED VIA   MINMAX
C              FOR MINMAX = 1  (FOR THE DEFAULT MINIMUM)
C                 THE EXPONETIATED WEIBULL DISTRIBUTION USED
C                 HEREIN IS DEFINED FOR ALL POSITIVE X,
C                 AND HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = (THETA*GAMMA)*(X**(GAMMA-1)) * EXP(-(X**GAMMA))
C                        *(1-EXP(-(X**GAMMA))**(THETA-1)
C              FOR MINMAX = 2 (FOR THE MAXIMUM),
C                 THE EXPONETIATED WEIBULL DISTRIBUTION USED
C                 HEREIN IS DEFINED FOR ALL NEGATIVE X,
C                 AND HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = ...
C              NOTE THAT THE PERCENT POINT FUNCTION OF A DISTRIBUTION
C              IS IDENTICALLY THE SAME AS THE INVERSE CUMULATIVE
C              DISTRIBUTION FUNCTION OF THE DISTRIBUTION.
C     INPUT  ARGUMENTS--P      = THE SINGLE PRECISION VALUE
C                                (BETWEEN 0.0 (INCLUSIVELY)
C                                AND 1.0 (EXCLUSIVELY))
C                                AT WHICH THE PERCENT POINT
C                                FUNCTION IS TO BE EVALUATED.
C                     --GAMMA  = THE SINGLE PRECISION VALUE
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C                     --THETA  = THE SINGLE PRECISION VALUE
C                                OF THE SECOND SHAPE PARAMETER.
C                                THETA SHOULD BE POSITIVE.
C                     --MINMAX = THE INTEGER VALUE
C                                IDENTIFYING THE
C                                CHOSEN EXPONETIATED WEIBULL DISTRIBUTION.
C                                1 = MIN, 2 = MAX.
C     OUTPUT ARGUMENTS--PPF    = THE SINGLE PRECISION PERCENT
C                                POINT FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PERCENT POINT FUNCTION .
C             VALUE PPF FOR THE EXPONETIATED WEIBULL DISTRIBUTION
C             WITH TAIL LENGTH PARAMETER VALUE = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--GAMMA SHOULD BE POSITIVE.
C                 --P SHOULD BE BETWEEN 0.0 (INCLUSIVELY)
C                   AND 1.0 (EXCLUSIVELY).
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--LOG.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--SARHAN & GREENBERG,
C                 CONTRIBUTIONS TO ORDER STATISTICS,
C               --MUDHOLKAR AND SRIVASTAVE, "THE EXPONENTIATED WEIBULL
C                 FAMILY: A REANALYSIS OF THE BUS-MOTOR-FAILURE DATA",
C                 TECHNOMETRICS, NOVEMBER, 1995, PP436-437.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--95/10
C     ORIGINAL VERSION--OCTOBER   1995.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DP
      DOUBLE PRECISION DG
      DOUBLE PRECISION DT
      DOUBLE PRECISION DPPF
      DOUBLE PRECISION DTERM1
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LT.0.0.OR.P.GE.1.0)THEN
        WRITE(ICOUT,1)
    1   FORMAT('***** ERROR--THE FIRST ARGUMENT TO ',
     1         'EWEPPF IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9000
      ENDIF
      IF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15)
   15   FORMAT('***** ERROR--THE SECOND ARGUMENT TO ',
     1         'EWEPPF IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
   46   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9000
      ENDIF
      IF(THETA.LE.0.0)THEN
        WRITE(ICOUT,25)
   25   FORMAT('***** ERROR--THE THIRD ARGUMENT TO ',
     1         'EWEPPF IS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)THETA
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9000
      ENDIF
C
C
       IF(P.EQ.0.0)THEN
         PPF=0.0
       ELSE
         DP=DBLE(P)
         DG=DBLE(1.0/GAMMA)
         DT=DBLE(1.0/THETA)
         DTERM1=DG*DLOG(-DLOG(1.0D0-DP**DT))
         DPPF=DEXP(DTERM1)
         PPF=REAL(DPPF)
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EEWRAN(N,AL,GAMMA1,SCALE1,GAMMA2,SCALE2,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE END EFFECTS WEIBULL DISTRIBUTION.
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --AL     = THE SINGLE PRECISION VALUE OF THE
C                                FIBER LENGTH PARAMETER
C                     --GAMMA1 = THE SINGLE PRECISION VALUE OF THE
C                                SHAPE (1) PARAMETER.
C                     --SCALE1 = THE SINGLE PRECISION VALUE OF THE
C                                SCALE (1) PARAMETER.
C                     --GAMMA2 = THE SINGLE PRECISION VALUE OF THE
C                                SHAPE (2) PARAMETER.
C                     --SCALE2 = THE SINGLE PRECISION VALUE OF THE
C                                SCALE (2) PARAMETER.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE END EFFECTS WEIBULL DISTRIBUTION.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --SHAPE PARAMETERS SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010.7
C     ORIGINAL VERSION--JULY      2010.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DOUBLE PRECISION DTEMP
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT,55)
   55   FORMAT('***** ERROR--THE REQUESTED NUMBER OF END EFFECTS ',
     1         'WEIBULL RANDOM NUMBERS IS NON-POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
   47   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(SCALE1.LE.0.0D0)THEN
        WRITE(ICOUT,5)
    5   FORMAT('***** ERROR--THE SCALE1 PARAMETER FOR THE END ',
     1         'EFFECTS WEIBULL RANDOM NUMBERSIS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE1
   46   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA1.LE.0.0D0)THEN
        WRITE(ICOUT,15)
   15   FORMAT('***** ERROR--THE GAMMA1 PARAMETER FOR THE END ',
     1         'EFFECTS WEIBULL RANDOM NUMBERSIS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA1
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(SCALE2.LE.0.0D0)THEN
        WRITE(ICOUT,25)
   25   FORMAT('***** ERROR--THE SCALE2 PARAMETER FOR THE END ',
     1         'EFFECTS WEIBULL RANDOM NUMBERSIS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA2.LE.0.0D0)THEN
        WRITE(ICOUT,35)
   35   FORMAT('***** ERROR--THE GAMMA2 PARAMETER FOR THE END ',
     1         'EFFECTS WEIBULL RANDOM NUMBERSIS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(AL.LE.0.0D0)THEN
        WRITE(ICOUT,45)
   45   FORMAT('***** ERROR--THE L PARAMETER FOR THE END ',
     1         'EFFECTS WEIBULL RANDOM NUMBERSIS NON-POSITIVE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)AL
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
C     GENERATE N UNIFORM (0,1) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     GENERATE N END EFFECTS WEIBULL DISTRIBUTION RANDOM
C     NUMBERS USING THE PERCENT POINT FUNCTION TRANSFORMATION METHOD.
C
      DO100I=1,N
        CALL EEWPPF(DBLE(X(I)),DBLE(AL),DBLE(GAMMA1),DBLE(SCALE1),
     1              DBLE(GAMMA2),DBLE(SCALE2),DTEMP)
        X(I)=REAL(DTEMP)
  100 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EWERAN(N,GAMMA,THETA,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE EXPONENTIATED WEIBULL DISTRIBUTION
C              WITH SHAPE PARAMETER VALUES = GAMMA, THETA.
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --GAMMA  = THE SINGLE PRECISION VALUE OF THE
C                                FIRST SHAPE PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C                     --THETA  = THE SINGLE PRECISION VALUE OF THE
C                                SECOND SHAPE PARAMETER.
C                                THETA SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE EXPONENTIATED WEIBULL DISTRIBUTION
C             WITH SHAPE PARAMETER VALUES = GAMMA AND THETA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --GAMMA SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NON E.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--2001.9
C     ORIGINAL VERSION--SEPTEMBER 2001.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    5 FORMAT('***** FATAL ERROR--THE 1ST INPUT ARGUMENT TO THE ',
     1'EWERAN SUBROUTINE IS NON-POSITIVE *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,' *****')
C
C     GENERATE N UNIFORM (0,1) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     GENERATE N EXPONENTIATED WEIBULL DISTRIBUTION RANDOM NUMBERS
C     USING THE PERCENT POINT FUNCTION TRANSFORMATION METHOD.
C
      MINMAX=1
      DO100I=1,N
        CALL EWEPPF(X(I),GAMMA,THETA,MINMAX,XTEMP)
        X(I)=XTEMP
  100 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      DOUBLE PRECISION FUNCTION EXP3(XVALUE)
C
C   DESCRIPTION
C
C      This function calculates 
C          
C           EXP3(X) = integral 0 to X  (exp(-t*t*t)) dt
C
C      The code uses Chebyshev expansions, whose coefficients are
C      given to 20 decimal places.
C
C
C   ERROR RETURNS
C     
C      If XVALUE < 0, an error message is printed and the function 
C      returns the value 0.
C
C
C   MACHINE-DEPENDENT CONSTANTS
C
C      NTERM1 - INTEGER - The no. of terms of the array AEXP3,
C                         The recommended value is such that
C                               AEXP3(NTERM1) < EPS/100. 
C
C      NTERM2 - INTEGER - The no. of terms of the array AEXP3A.
C                         The recommended value is such that
C                               AEXP3A(NTERM2) < EPS/100.
C
C      XLOW - DOUBLE PRECISION - The value below which EXP3(X) = X to machine
C                    precision. The recommended value is
C                          cube root(4*EPSNEG)
C
C      XUPPER - DOUBLE PRECISION - The value above which EXP3(X) = 0.89297...
C                      to machine precision. The recommended value is
C                           cube root(-ln(EPSNEG))
C
C      For values of EPS and EPSNEG for various machine/compiler
C      combinations refer to the file MACHCON.TXT.
C
C      The machine-dependent constants are computed internally by
C      using the D1MACH subroutine.
C
C
C   INTRINSIC FUNCTIONS USED
C
C      EXP, LOG
C
C
C   OTHER MISCFUN SUBROUTINES USED:
C
C          CHEVAL , ERRPRN, D1MACH
C
C
C   AUTHOR
C
C      DR. ALLAN J. MACLEOD,
C      DEPARTMENT OF MATHEMATICS AND STATISTICS,
C      UNIVERSITY OF PAISLEY,
C      HIGH ST.,
C      PAISLEY
C      SCOTLAND.
C
C      (e-mail  macl_ms0@paisley.ac.uk )
C
C
C   LATEST MODIFICATION:  23 January, 1996
C
C
      INTEGER NTERM1,NTERM2
      DOUBLE PRECISION AEXP3(0:24),AEXP3A(0:24),CHEVAL,
     1      FOUR,FUNINF,HALF,ONE,ONEHUN,SIXTEN,T,THREE,
     2      TWO,X,XLOW,XUPPER,XVALUE,ZERO
CCCCC CHARACTER FNNAME*6,ERRMSG*14
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOMC.INC'
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
CCCCC DATA FNNAME/'EXP3  '/
CCCCC DATA ERRMSG/'ARGUMENT < 0.0'/
      DATA ZERO,HALF,ONE/0.0 D 0 , 0.5 D 0 , 1.0 D 0/
      DATA TWO,THREE,FOUR/2.0 D 0 , 3.0 D 0 , 4.0 D 0 /
      DATA SIXTEN,ONEHUN/16.0 D 0 , 100.0 D 0/
      DATA FUNINF/0.89297 95115 69249 21122 D 0/
      DATA AEXP3(0)/  1.26919 84142 21126 01434  D    0/
      DATA AEXP3(1)/ -0.24884 64463 84140 98226  D    0/
      DATA AEXP3(2)/  0.80526 22071 72310 4125   D   -1/
      DATA AEXP3(3)/ -0.25772 73325 19683 2934   D   -1/
      DATA AEXP3(4)/  0.75998 78873 07377 429    D   -2/
      DATA AEXP3(5)/ -0.20306 95581 94040 510    D   -2/
      DATA AEXP3(6)/  0.49083 45866 99329 17     D   -3/
      DATA AEXP3(7)/ -0.10768 22391 42020 77     D   -3/
      DATA AEXP3(8)/  0.21551 72626 42898 4      D   -4/
      DATA AEXP3(9)/ -0.39567 05137 38429        D   -5/
      DATA AEXP3(10)/ 0.66992 40933 8956         D   -6/
      DATA AEXP3(11)/-0.10513 21808 0703         D   -6/
      DATA AEXP3(12)/ 0.15362 58019 825          D   -7/
      DATA AEXP3(13)/-0.20990 96036 36           D   -8/
      DATA AEXP3(14)/ 0.26921 09538 1            D   -9/
      DATA AEXP3(15)/-0.32519 52422              D  -10/
      DATA AEXP3(16)/ 0.37114 8157               D  -11/
      DATA AEXP3(17)/-0.40136 518                D  -12/
      DATA AEXP3(18)/ 0.41233 46                 D  -13/
      DATA AEXP3(19)/-0.40337 5                  D  -14/
      DATA AEXP3(20)/ 0.37658                    D  -15/
      DATA AEXP3(21)/-0.3362                     D  -16/
      DATA AEXP3(22)/ 0.288                      D  -17/
      DATA AEXP3(23)/-0.24                       D  -18/
      DATA AEXP3(24)/ 0.2                        D  -19/
      DATA AEXP3A(0)/  1.92704 64955 06827 37293  D    0/
      DATA AEXP3A(1)/ -0.34929 35652 04813 8054   D   -1/
      DATA AEXP3A(2)/  0.14503 38371 89830 093    D   -2/
      DATA AEXP3A(3)/ -0.89253 36718 32790 3      D   -4/
      DATA AEXP3A(4)/  0.70542 39219 11838        D   -5/
      DATA AEXP3A(5)/ -0.66717 27454 7611         D   -6/
      DATA AEXP3A(6)/  0.72426 75899 824          D   -7/
      DATA AEXP3A(7)/ -0.87825 82560 56           D   -8/
      DATA AEXP3A(8)/  0.11672 23442 78           D   -8/
      DATA AEXP3A(9)/ -0.16766 31281 2            D   -9/
      DATA AEXP3A(10)/ 0.25755 01577              D  -10/
      DATA AEXP3A(11)/-0.41957 8881               D  -11/
      DATA AEXP3A(12)/ 0.72010 412                D  -12/
      DATA AEXP3A(13)/-0.12949 055                D  -12/
      DATA AEXP3A(14)/ 0.24287 03                 D  -13/
      DATA AEXP3A(15)/-0.47331 1                  D  -14/
      DATA AEXP3A(16)/ 0.95531                    D  -15/
      DATA AEXP3A(17)/-0.19914                    D  -15/
      DATA AEXP3A(18)/ 0.4277                     D  -16/
      DATA AEXP3A(19)/-0.944                      D  -17/
      DATA AEXP3A(20)/ 0.214                      D  -17/
      DATA AEXP3A(21)/-0.50                       D  -18/
      DATA AEXP3A(22)/ 0.12                       D  -18/
      DATA AEXP3A(23)/-0.3                        D  -19/
      DATA AEXP3A(24)/ 0.1                        D  -19/
C
C   Start calculation
C
      X = XVALUE
C
C   Error test
C
      IF ( X .LT. ZERO ) THEN
CCCCC    CALL ERRPRN(FNNAME,ERRMSG)
         WRITE(ICOUT,999)
         CALL DPWRST('XXX','BUG ')
         WRITE(ICOUT,101)X
         CALL DPWRST('XXX','BUG ')
         EXP3 = ZERO
         RETURN
      ENDIF
  999 FORMAT(1X)
  101 FORMAT('***** ERROR FROM EXP3--ARGUMENT MUST BE ',
     1       'NON-NEGATIVE, ARGUMENT = ',G15.7)
C
C   Compute the machine-dependent constants.
C
      T = D1MACH(3)
      XLOW = ( FOUR * T ) ** (ONE/THREE)
      XUPPER = ( -LOG ( T ) ) ** (ONE/THREE)
      T = T / ONEHUN
      IF ( X .LE. TWO ) THEN
         DO 10 NTERM1 = 24 , 0 , -1
            IF ( ABS(AEXP3(NTERM1)) .GT. T ) GOTO 19
 10      CONTINUE
 19      CONTINUE
      ELSE
         DO 40 NTERM2 = 24 , 0 , -1
            IF ( ABS(AEXP3A(NTERM2)) .GT. T ) GOTO 49
 40      CONTINUE
 49      CONTINUE
      ENDIF
C
C   Code for XVALUE < =  2
C
      IF ( X .LE. TWO ) THEN
         IF ( X .LT. XLOW ) THEN
            EXP3 = X
         ELSE
            T =  (  ( X * X * X / FOUR ) - HALF ) - HALF
            EXP3 = X * CHEVAL ( NTERM1,AEXP3,T ) 
         ENDIF
      ELSE
C
C   Code for XVALUE > 2
C
         IF ( X .GT. XUPPER ) THEN
            EXP3 = FUNINF
         ELSE
            T = ( ( SIXTEN/ ( X * X * X ) ) - HALF ) - HALF
            T = CHEVAL ( NTERM2,AEXP3A,T ) 
            T = T * EXP ( -X * X * X ) / ( THREE * X * X ) 
            EXP3 = FUNINF - T
         ENDIF
      ENDIF
      RETURN
      END            
      SUBROUTINE EXPLOS(X,N,ENGLSL,ENGUSL,COSUSL,IWRITE,XEL,
     1IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE
C              SAMPLE EXPECTED LOSS FROM THE DATA IN THE INPUT VECTOR X.
C              THIS CALCULATION ASSUMES--
C                 1) A QUADRATIC LOSS FUNCTION
C                 2) A NORMAL DISTRIBUTION
C                 3) WITH MEAN XBAR AND STANDARD DEVIATION S
C                 4) A DOLLAR COST    COSUSL   AT THE UPPER SPEC LIMIT
C                 5) THE TARGET IS MIDWAY BETWEEN ENGUSL AND ENGLSL
C              XEL = INTEGRAL K*(X-TARGET)**2 * NORMALPDF(XBAR,S)
C              WHERE K IS DERIVED FROM THE LOSS FUNCTION
C                 L(X) = K*(X-TARGET)**2
C              EVALUATED AT X = USL
C                 SOLVING     L(USL) = COSUSL
C                             K*(USL-TARGET)**2 = COSUSL
C                             K = COSUSL / (USL-TARGET)**2
C     THE FINAL FORM FOR XEL IS QUITE SIMPLE--
C        XEL = COSUSL * (KSIGMA**2 + KMU**2)
C     WHERE KSIGMA IS DEFINED VIA   SIGMA = KSIGMA * H
C     AND   KMU    IS DEFINED VIA   MU    = TARGET + KMU*H
C     YIELDING KSIGMA = SIGMA / H
C     AND      KMU    = (MU - TARGET) / H
C     IN PRACTICE, WE USE XBAR FOR MU AND S FOR SIGMA.
C     NOTE--XEL IS A MEASURE OF PROCESS COST AND IS
C           SENSITIVE TO LOSS FROM BOTH BIAS AND FROM VARIATION.
C     NOTE--XEL IS A MEASURE WHICH TAKES ON
C           THE VALUES 0 TO INFINITY.
C           A GOOD PROCESS YIELDS VALUES OF
C           EXPECTED LOSS NEAR 0.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C                     --ENGLSL = LOWER (ENGINEERING) SPEC LIMIT
C                     --ENGUSL = UPPER (ENGINEERING) SPEC LIMIT
C                     --COSUSL = COST AT UPPER SPEC LIMIT
C     OUTPUT ARGUMENTS--EXPLOS = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED SAMPLE EXPECTED LOSS
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE EXPECTED LOSS (IN XEL)
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DSQRT.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--R&M 2000 AIR FORCE MANUAL
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--89.5
C     ORIGINAL VERSION--MAY       1989.
C     UPDATED         --SEPTEMBER 1990. REVERSE INPUT ARGS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DX
      DOUBLE PRECISION DSUM
      DOUBLE PRECISION DMEAN
      DOUBLE PRECISION DVAR
      DOUBLE PRECISION DSD
C
      DOUBLE PRECISION DUSL
      DOUBLE PRECISION DLSL
C
      DOUBLE PRECISION DTARG
      DOUBLE PRECISION DH
      DOUBLE PRECISION DKMU
      DOUBLE PRECISION DKSIGM
      DOUBLE PRECISION DEL
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EXPL'
      ISUBN2='OS  '
C
      IERROR='NO'
C
      DMEAN=0.0D0
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF EXPLOS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3
   52 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)N
   53 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)ENGUSL,ENGLSL,COSUSL
   54 FORMAT('ENGUSL,ENGLSL,COSUSL = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,N
      WRITE(ICOUT,56)I,X(I)
   56 FORMAT('I,X(I) = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               ********************************************
C               **  COMPUTE PROCESS CAPABILITY INDEX EXPLOS  **
C               ********************************************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(N.GE.1)GOTO119
      IERROR='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
  111 FORMAT('***** ERROR IN EXPLOS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,112)
  112 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,113)
  113 FORMAT('      IN THE VARIABLE FOR WHICH')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,114)
  114 FORMAT('      THE EXPECTED LOSS IS TO BE COMPUTED')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,115)
  115 FORMAT('      MUST BE 1 OR LARGER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,116)
  116 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,117)N
  117 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,
     1'.')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
  119 CONTINUE
C
      IF(N.EQ.1)GOTO120
      GOTO129
  120 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,121)
CC121 FORMAT('***** NON-FATAL DIAGNOSTIC IN EXPLOS--',
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC1'THE SECOND INPUT ARGUMENT (N) HAS THE VALUE 1')
      XSD=0.0
      GOTO9000
  129 CONTINUE
C
      HOLD=X(1)
      DO135I=2,N
      IF(X(I).NE.HOLD)GOTO139
  135 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,136)HOLD
CC136 FORMAT('***** NON-FATAL DIAGNOSTIC IN EXPLOS--',
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC1'THE FIRST INPUT ARGUMENT (A VECTOR) HAS ALL ELEMENTS = ',E15.7)
      XSD=0.0
      GOTO9000
  139 CONTINUE
C
  190 CONTINUE
C
C               ***************************************
C               **  STEP 2--                         **
C               **  COMPUTE THE STANDARD DEVIATION.  **
C               ***************************************
C
      DN=N
      DSUM=0.0D0
      DO200I=1,N
      DX=X(I)
      DSUM=DSUM+DX
  200 CONTINUE
      DMEAN=DSUM/DN
C
      DSUM=0.0D0
      DO300I=1,N
      DX=X(I)
      DSUM=DSUM+(DX-DMEAN)**2
  300 CONTINUE
      DVAR=DSUM/(DN-1.0D0)
      DSD=0.0D0
      IF(DVAR.GT.0.0D0)DSD=DSQRT(DVAR)
      XSD=DSD
C
C               **************************************************
C               **  STEP 3--                                    **
C               **  COMPUTE THE EXPECTED LOSS                   **
C               **************************************************
C
      DUSL=ENGUSL
      DLSL=ENGLSL
C
      DTARG=(DUSL+DLSL)/2.0D0
      DH=(DUSL-DLSL)/2.0D0
C
      IF(DH.EQ.0.0D0)XEL=CPUMAX
      IF(DH.EQ.0.0D0)GOTO490
C
      DKSIGM=DSD/DH
      DKMU=(DMEAN-DTARG)/DH
C
      DCOSUS=COSUSL
      DEL=DCOSUS*(DKSIGM**2+DKMU**2)
      XEL=DEL
C
  490 CONTINUE
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)N,XEL
  811 FORMAT('THE EXPECTED LOSS ($) OF THE ',I8,' OBSERVATIONS = ',
     1E15.7)
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF EXPLOS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,IERROR
 9012 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)N
 9013 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)DMEAN
 9014 FORMAT('DMEAN = ',D15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)DSD
 9015 FORMAT('DSD = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)DUSL,DLSL,DTARG,DH
 9016 FORMAT('DUSL,DLSL,DTARG,DH = ',4D15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)DKMU,DKSIGM,DEL,XEL
 9017 FORMAT('DKMU,DKSIGM,DEL,XEL = ',3D15.7,E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE EXPAFR(X1,X2,SCALE,AFR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE AVERAGE FAILURE
C              RATE (AFR) FUNCTION VALUE FOR THE EXPONENTIAL DISTRIBUTION.
C              THE AFR IS DEFINED AS:
C
C              AFR(X1,X2,LOC,SCALE) = (H(X2,LOC,SCALE) - H(X1,LOC,SCALE))/(X2-X1)
C
C              WHERE
C
C              H(X,LOC,SCALE) = (X-LOC)/SCALE
C
C              SO
C
C              AFR(X1,X2) = ((X2-LOC)/SCALE) - (X1-LOC)/SCALE)/(X2-X1)
C                         = 1/SCALE
C
C              NOTE THAT THE LOCATION PARAMETER CANCELS OUT, SO
C              WE OMIT THE ARGUMENT.
C     INPUT  ARGUMENTS--X1     = THE SINGLE PRECISION VALUE AT
C                                WHICH THE AFR FUNCTION IS TO BE
C                                EVALUATED.
C     INPUT  ARGUMENTS--X2     = THE SINGLE PRECISION VALUE AT
C                                WHICH THE AFR FUNCTION IS TO BE
C                                EVALUATED.
C     OUTPUT ARGUMENTS--AFR    = THE SINGLE PRECISION AVERAGE
C                                FAILURE RATE FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION AVERAGE FAILURE RATE
C             FUNCTION VALUE PDF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X2 AND X1  SHOULD BE NON-NEGATIVE AND NOT EQUAL.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--TOBIAS AND TRINDALE, "APPLIED RELIABILITY", SECOND
C                 EDITION, CHAPMAN AND HALL/CRC, 1995.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 INFORMATION TECHNOLOGY LABORATORY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--MARCH     2005. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 ICOUTINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,ICOUTINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      X1MN=MIN(X1,X2)
      X1MX=MAX(X1,X2)
      IF(X1MN.EQ.X1MX)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)X1MN
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,48)X1MX
        CALL DPWRST('XXX','BUG ')
        AFR=0.0
        GOTO9000
      ELSEIF(X1MN.LT.0.0)THEN
        WRITE(ICOUT,4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X1MN
        CALL DPWRST('XXX','BUG ')
        AFR=0.0
        GOTO9000
      ELSEIF(SCALE.LE.0.0)THEN
        WRITE(ICOUT,6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SCALE
        CALL DPWRST('XXX','BUG ')
        AFR=0.0
        GOTO9000
      ENDIF
   90 CONTINUE
    4 FORMAT('***** ERROR--THE FIRST INPUT ARGUMENT TO EXPAFR ',
     1       'IS NEGATIVE')
    5 FORMAT('***** ERROR--THE FIRST AND SECOND INPUT ARGUMENTS ',
     1       'TO EXPAFR ARE EQUAL')
    6 FORMAT('***** ERROR--THE FOURTH INPUT ARGUMENT TO EXPAFR ',
     1       '(THE SCALE) IS NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8)
   47 FORMAT('***** THE VALUE OF THE FIRST ARGUMENT IS ',E15.8)
   48 FORMAT('***** THE VALUE OF THE SECOND ARGUMENT IS ',E15.8)
C
C-----START POINT-----------------------------------------------------
C
      AFR=1.0/SCALE
C
 9000 CONTINUE
      RETURN
      END 
      SUBROUTINE EXPCDF(X,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE EXPONENTIAL DISTRIBUTION
C              WITH MEAN = 1 AND STANDARD DEVIATION = 1.
C              THIS DISTRIBUTION IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = EXP(-X).
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--CDF    = THE SINGLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 207-232.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-921-2315
C     ORIGINAL VERSION--APRIL     1994. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(X.LT.0.0)THEN
CCCCC   WRITE(ICOUT,4)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,46)X
CCCCC   CALL DPWRST('XXX','BUG ')
        CDF=0.0
      ELSE
        CDF=1.0-EXP(-X)
      ENDIF
C
CCCC4 FORMAT('***** WARNING--THE FIRST ARGUMENT TO EXPCDF IS NEGATIVE.')
CCC46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      RETURN
      END 
      SUBROUTINE EXPCHA(X,HAZ)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE HAZARD
C              FUNCTION VALUE FOR THE EXPONENTIAL DISTRIBUTION
C              WITH MEAN = 1 AND STANDARD DEVIATION = 1.
C              THIS DISTRIBUTION IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = EXP(-X) AND
C              CUMULATIVE HAZARD FUNCTION
C              H(X)=X.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--HAZ    = THE SINGLE PRECISION
C                                CUMULATIVE HAZARD FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE HAZARD
C             FUNCTION VALUE PDF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, CHAPTER 19.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--APRIL     1998. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 ICOUTINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,ICOUTINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(X.LT.0.0)THEN
        WRITE(ICOUT,4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        HAZ=0.0
      ELSE
        HAZ=X
      ENDIF
    4 FORMAT('***** WARNING--THE FIRST ARGUMENT TO EXPHAZ IS NEGATIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      RETURN
      END 
      DOUBLE PRECISION FUNCTION EXPFUN (DA)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE LIKELIHOOD RATIO
C              BASED CONFIDECE INTERVAL FOR THE 1-SAMPLE EXPONENTIAL
C              MODEL WITH TIME CENSORING.  THIS FUNCTION FINDS THE ROOT
C              OF THE EQUATION:
C
C                 2*IR*LN(SIGMAHAT) - (2/SIGMAHAT)*2*SUM[i=1 to N][X(i)]
C                 + 2*IR*LN(A) + (2/A)*SUM[i=1 to N][X(i)] - K
C
C              WITH
C
C                 IR       = NUMBER OF FAILURE TIMES
C                 SIGMAHAT = POINT ESTIMATE OF SIGMA
C                 A        = PARAMETER OF INTEREST
C                 K        = CHSPPF(ALPHA,1)
C
C              NOTE THAT THE SUM[X(I)], K, IR ARE COMPUTED IN
C              DPMLE2 AND PASSED VIA COMMON BLOCK.
C
C              CALLED BY DFZERO ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.
C     EXAMPLE--EXPONENTIAL MAXIMUM LIKELIHOOD Y CENSOR
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 12 (SEE
C                EXAMPLE 12.3).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/10
C     ORIGINAL VERSION--OCTOBER    2004.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DA
C
      DOUBLE PRECISION DC
      DOUBLE PRECISION DK
      DOUBLE PRECISION DR
      DOUBLE PRECISION SHAT
      DOUBLE PRECISION XSUM
      COMMON/EXPCOM/DK,DR,SHAT,XSUM,DC
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  COMPUTE SOME SUMS
C
      EXPFUN=DC - 2.0D0*(-DR*DLOG(DA) - XSUM/DA) - DK
C
      RETURN
      END
      REAL FUNCTION EXPFU2 (SIGHAT,X,N)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE MAXIMUM LIKELIHOOD
C              ESTIMATE OF SIGMA FOR THE 1-PARAMETER EXPONENTIAL
C              MODEL FOR GROUPED DATA (NO CENSORING).  THIS FUNCTION
C              FINDS THE ROOT OF THE EQUATION:
C
C                 SUM[i=1 to k-1][N(i)*(X(i)-X(i-1))/
C                     (EXP(X(i)-X(I-1))/SIGMAHAT) - 1) -
C                 SUM[I=2 to k][N(i)*X(i-1)] = 0
C
C              WITH
C
C                 X(i)     = UPPER BOUNDARY OF iTH BIN
C                 N(i)     = COUNT FOR iTH INTERVAL
C                 SIGMAHAT = POINT ESTIMATE OF SIGMA (THIS IS THE
C                            PARAMETER WE ARE ITERATING OVER)
C                 K        = NUMBER OF INTERVALS
C
C              FORMULAS GO FROM 0 TO K.  FOR CONVENIENCE WITH
C              FORTRAN, WE WILL GO FROM 1 TO K+1.
C
C              CALLED BY FZEROY ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.
C     EXAMPLE--EXPONENTIAL GROUPED MAXIMUM LIKELIHOOD Y X
C     REFERENCE--JOHNSON, KOTZ, AND BALAKRISHNAN, "CONTINUOUS
C                UNIVARIATE DISTRIBUTIONS--Volume 1", SECOND EDITION,
C                WILEY, 1994, PP. 509-510.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/10
C     ORIGINAL VERSION--OCTOBER    2004.
C
C---------------------------------------------------------------------
C
      REAL SIGHAT
      REAL X(*)
      REAL N(*)
C
      INTEGER IK
      COMMON/EX2COM/IK
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DNI
      DOUBLE PRECISION DX1
      DOUBLE PRECISION DX2
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  COMPUTE SOME SUMS
C
      DSUM1=0.0D0
      DSUM2=0.0D0
C
C  COMPUTE SUM FOR FIRST TERM
C
      DO100I=2,IK
        DNI=DBLE(N(I))
        DX1=DBLE(X(I))
        DX2=DBLE(X(I-1))
        DTERM1=DNI*(DX1-DX2)/(DEXP((DX1-DX2)/DBLE(SIGHAT))-1.0D0)
        DSUM1=DSUM1 + DTERM1
  100 CONTINUE
C
C  COMPUTE SUM FOR SECOND TERM
C
      DO200I=3,IK+1
        DNI=DBLE(N(I))
        DX2=DBLE(X(I-1))
        DSUM2=DSUM2 + DNI*DX2
  200 CONTINUE
C
      EXPFU2=REAL(DSUM1-DSUM2)
C
      RETURN
      END
      SUBROUTINE EXPHAZ(X,HAZ)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE HAZARD
C              FUNCTION VALUE FOR THE EXPONENTIAL DISTRIBUTION
C              WITH MEAN = 1 AND STANDARD DEVIATION = 1.
C              THIS DISTRIBUTION IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = EXP(-X) AND
C              HAZARD FUNCTION
C              H(X)=1.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--HAZ    = THE SINGLE PRECISION
C                                HAZARD FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION HAZARD
C             FUNCTION VALUE PDF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, CHAPTER 19.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--APRIL     1998. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 ICOUTINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,ICOUTINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(X.LT.0.0)THEN
        WRITE(ICOUT,4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        HAZ=0.0
      ELSE
        HAZ=1.0
      ENDIF
    4 FORMAT('***** WARNING--THE FIRST ARGUMENT TO EXPHAZ IS NEGATIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
C
      RETURN
      END 
      DOUBLE PRECISION FUNCTION EXPM1(DX)
C***BEGIN PROLOGUE  EXPM1
C***PURPOSE  Evaluate EXP(X)- 1
C
      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
C
C-----COMMON----------------------------------------------------------
C
      REAL R1MACH
      INCLUDE 'DPCOMC.INC'
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      REAL CPUMIN
      REAL CPUMAX
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      A=ABS(DX)
      IF(A.LT.D1MACH(4))THEN
        EXPM1=DX
        GOTO9000
      ELSEIF(A.GT.0.697)THEN
        EXPM1=EXP(DX) - 1.0D0
        GOTO9000
      ENDIF
C
      IF(A.GT.1.0D-8)THEN
        Y=EXP(DX) - 1.0D0
      ELSE
        Y=((DX/2.0D0) + 1.0D0)*DX
      ENDIF
      DTERM1=DLNREL(Y)
      EXPM1=Y - (1.0D0 + Y)*(DTERM1 - DX)
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EXPML1(Y,N,ICASE,IEXPBC,
     1                  ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,
     1                  NUMALP,NUMOUT,
     1                  XMEAN,XSD,XVAR,XMIN,XMAX,
     1                  ALOCML,ALOCSE,SCALML,SCALSE,
     1                  ALOCBC,ALOBSE,SCABML,SCABSE,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE EXPONENTIAL DISTRIBUTION FOR THE RAW DATA CASE
C              (I.E., NO CENSORING AND NO GROUPING).  IT WILL ALSO
C              RETURN THE CONFIDENCE INTERVALS FOR THE LOCATION
C              AND SCALE PARAMETERS.  THIS ROUTINE WILL ESTIMATE EITHER
C              THE 2-PARAMETER CASE (I.E., BOTH LOCATION AND SCALE ARE
C              ESTIMATED) OR THE 1-PARAMETER CASE (ONLY SCALE IS
C              ESTIMATED) BASED ON VALUE OF ICASE.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C              PUT THIS IN A SEPARATE ROUTINE AS IT MAY BE CALLED
C              FROM MULTIPLE PLACES (DPMLE1 WILL GENERATE THE OUTPUT
C              FOR THE EXPONENTIAL MLE COMMAND).
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 12.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/1
C     ORIGINAL VERSION--JANUARY   2010. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPMLE1)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DIMENSION Y(*)
      DIMENSION ALOWLO(*)
      DIMENSION AUPPLO(*)
      DIMENSION ALOWSC(*)
      DIMENSION AUPPSC(*)
      DIMENSION ALPHA(*)
C
      CHARACTER*4 ICASE
      CHARACTER*4 IEXPBC
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EXPM'
      ISUBN2='L1  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PML1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF EXPML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,ICASE,IEXPBC
   52   FORMAT('IBUGA3,ISUBRO,ICASE,IEXPBC = ',3(A4,2X),A4)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR NORMAL MLE ESTIMATE             **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PML1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='EXPONENTIAL'
      IFLAG=0
      CALL SUMRAW(Y,N,IDIST,IFLAG,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,
     1            ISUBRO,IBUGA3,IERROR)
C
      ALOCML=CPUMIN
      ALOCBC=CPUMIN
      ALOCSE=CPUMIN
      ALOBSE=CPUMIN
      SCALML=CPUMIN
      SCALSE=CPUMIN
      SCABML=CPUMIN
      SCABSE=CPUMIN
      AN=REAL(N)
C
      IF(ICASE.EQ.'1')THEN
C
C       ONE-PARAMETER CASE
C
        SCALML=XMEAN
        SCALSE=SCALML/SQRT(AN)
C
        NU=2*N
        DO1110I=1,NUMALP
          ALP=ALPHA(I)
          P=1.0-(ALP/2.0)
          CALL CHSPPF(P,NU,PPF1)
          P=ALP/2.0
          CALL CHSPPF(P,NU,PPF2)
          ALOWSC(I)=2.0*AN*SCALML/PPF1
          AUPPSC(I)=2.0*AN*SCALML/PPF2
 1110   CONTINUE
C
      ELSEIF(ICASE.EQ.'2')THEN
C
C       TWO-PARAMETER CASE
C
        ALOCML=XMIN
        ALOCBC=(AN*XMIN - XMEAN)/(AN - 1.0)
        SCALML=XMEAN-XMIN
        SCALSE=SCALML/SQRT(AN - 1.0)
        SCABML=AN*(XMEAN - XMIN)/(AN - 1.0)
        SCABSE=SCABML/SQRT(AN - 1.0)
        ALOCSE=SCALML/SQRT(AN*(AN-1.0))
        ALOBSE=SCABML/SQRT(AN*(AN-1.0))
C
        IF(IEXPBC.EQ.'ON')THEN
          UTEMP=ALOCBC
          SCTEMP=SCABML
        ELSE
          UTEMP=ALOCML
          SCTEMP=SCALML
        ENDIF
C
        NU2=2*(N-1)
        DO2120I=1,NUMALP
          ALP=ALPHA(I)
          P=1.0-(ALP/2.0)
          CALL CHSPPF(P,NU2,PPF3)
          P=ALP/2.0
          CALL CHSPPF(P,NU2,PPF4)
          ALOWSC(I)=2.0*AN*SCTEMP/PPF3
          AUPPSC(I)=2.0*AN*SCTEMP/PPF4
          P=1.0-ALP
          ACONS1=(ALP/2.0)**(1.0/(1.0-AN)) - 1.0
          ACONS2=(1.0 - ALP/2.0)**(1.0/(1.0-AN)) - 1.0
          ATEMP1=XMIN - SCTEMP*ACONS1
          ATEMP2=XMIN - SCTEMP*ACONS2
          ALOWLO(I)=MIN(ATEMP1,ATEMP2)
          AUPPLO(I)=MAX(ATEMP1,ATEMP2)
 2120   CONTINUE
      ENDIF
C 
      NUMOUT=NUMALP
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF EXPML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)N,XMEAN,XSD,XMIN,XMAX
 9013   FORMAT('N,XMEAN,XSD,XMIN,XMAX = ',I8,4G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9017)ALOCML,SCALML,ALOCSE,SCALSE
 9017   FORMAT('ALOCML,SCALML,ALOCSE,SCALSE = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9019)ALOCBC,SCALBC,ALOBSE,SCABSE
 9019   FORMAT('ALOCBC,SCALBC,ALOBSE,SCABSE = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE EXPML2(Y,TAG,N,ICASPL,ICASE,TEND,TEMP1,MAXNXT,
     1                  XMEAN,XSD,XVAR,XMIN,XMAX,XSUM,
     1                  ALOCML,ALOCSE,SCALML,SCALSE,
     1                  IR,IM,AN,AR,AM,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE EXPONENTIAL DISTRIBUTION FOR THE RAW DATA CASE
C              WITH TIME CENSORING.  THIS ROUTINE GENERATES ONLY THE
C              POINT ESTIMATES FOR THE LOCATION AND SCALE PARAMETERS.
C              IT WILL ESTIMATE EITHER THE 2-PARAMETER CASE (I.E.,
C              BOTH LOCATION AND SCALE ARE ESTIMATED) OR THE 1-PARAMETER
C              CASE (ONLY SCALE IS ESTIMATED) BASED ON VALUE OF ICASE.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C              PUT THIS IN A SEPARATE ROUTINE AS IT MAY BE CALLED
C              FROM MULTIPLE PLACES (DPMLE2 WILL GENERATE THE OUTPUT
C              FOR THE EXPONENTIAL MLE COMMAND).
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 12.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/6
C     ORIGINAL VERSION--JUNE      2010. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPMLE2)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DIMENSION Y(*)
      DIMENSION TAG(*)
      DIMENSION TEMP1(*)
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICASE
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EXPM'
      ISUBN2='L2  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PML2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF EXPML2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,ICASPL,TEND
   52   FORMAT('IBUGA3,ISUBRO,ICASE,TEND = ',2(A4,2X),A4,G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),TAG(I)
   57     FORMAT('I,Y(I),TAG(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR EXPONENTIAL MLE ESTIMATE        **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PML2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='EXPONENTIAL'
      CALL CKCENS(TAG,TEMP1,N,IDIST,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IWRITE='OFF'
      IFLAG=0
      CALL SUMRAW(Y,N,IDIST,IFLAG,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL SUMDP(Y,N,IWRITE,XSUM,IBUGA3,IERROR)
C
      ALOCML=CPUMIN
      ALOCSE=CPUMIN
      SCALML=CPUMIN
      SCALSE=CPUMIN
C
      CALL SORTC(Y,TAG,N,Y,TAG)
      IR=0
      DO2120I=1,N
        IF(TAG(I).EQ.1.0)IR=IR+1
 2120 CONTINUE
      IM=N-IR
C
      DR=DBLE(IR)
C
      IF(IM.EQ.0)THEN
        ICASE='NONE'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2131)
 2131   FORMAT('***** WARNING FROM EXPONENTIAL MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2133)
 2133   FORMAT('      NO CENSORING TIMES DETECTED.  IT IS RECOMMENDED')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2135)
 2135   FORMAT('      THAT THE FULL SAMPLE SYNTAX BE USED:')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2137)
 2137   FORMAT('      EXPONENTIAL MAXIMUM LIKELIHOOD  Y')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
      ELSE
        ICASE='SING'
        AHOLD=Y(IR+1)
        DO2140I=IR+1,N
          IF(Y(I).NE.AHOLD)THEN
            ICASE='MULT'
            GOTO2149
          ENDIF
 2140   CONTINUE
 2149   CONTINUE
      ENDIF
C
C               ************************************
C               **  STEP 41--                     **
C               **  CARRY OUT CALCULATIONS        **
C               **  FOR EXPONENTIAL MLE           **
C               **  ESTIMATE (TIME CENSORED CASE) **
C               ************************************
C
 4100 CONTINUE
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
      AN=REAL(N)
      AR=REAL(IR)
      AM=REAL(IM)
C
C     ESTIMATES FOR 1-PARAMETER MODEL
C
      IF(ICASPL.EQ.'1EXP')THEN
        ALOCML=0.0
        SCALML=XSUM/AR
        SCALSE=SCALML/SQRT(AR)
      ELSE
C
C     ESTIMATES FOR 2-PARAMETER MODEL
C
C     NOTE THAT THERE IS NO SIMPLE FORMULA FOR THE STANDARD ERROR
C     OF LOCATION PARAMETER.
C
        ALOCML=XMIN
        ALOCSE=CPUMIN
        DSUM1=0.0D0
        DO4120I=1,N
          DSUM1=DSUM1 + DBLE(Y(I) - XMIN)
 4120   CONTINUE
        SCALML=REAL(DSUM1/DBLE(IR))
        SCALSE=SCALML/SQRT(AR)
      ENDIF
C
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PML2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF EXPML2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)N,XMEAN,XSD,XMIN,XMAX
 9013   FORMAT('N,XMEAN,XSD,XMIN,XMAX = ',I8,4G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9017)ALOCML,SCALML,ALOCSE,SCALSE
 9017   FORMAT('ALOCML,SCALML,ALOCSE,SCALSE = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE EXPML3(Y,TAG,XTEMP,N,ICASPL,ICASE,TEND,MAXNXT,
     1                  XMEAN,XSD,XVAR,XMIN,XMAX,XSUM,
     1                  ALOCML,ALOCSE,SCALML,SCALSE,
     1                  IR,IM,AN,AR,AM,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE EXPONENTIAL DISTRIBUTION FOR THE RAW DATA CASE
C              WITH FAILURE CENSORING.  THIS ROUTINE GENERATES ONLY THE
C              POINT ESTIMATES FOR THE LOCATION AND SCALE PARAMETERS.
C              IT WILL ESTIMATE EITHER THE 2-PARAMETER CASE (I.E.,
C              BOTH LOCATION AND SCALE ARE ESTIMATED) OR THE 1-PARAMETER
C              CASE (ONLY SCALE IS ESTIMATED) BASED ON VALUE OF ICASE.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C              PUT THIS IN A SEPARATE ROUTINE AS IT MAY BE CALLED
C              FROM MULTIPLE PLACES (DPMLE3 WILL GENERATE THE OUTPUT
C              FOR THE EXPONENTIAL MLE COMMAND).
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 12.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/6
C     ORIGINAL VERSION--JUNE      2010. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPMLE3)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DIMENSION Y(*)
      DIMENSION TAG(*)
      DIMENSION XTEMP(*)
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICASE
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EXPM'
      ISUBN2='L3  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PML3')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF EXPML3--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,ICASPL,TEND
   52   FORMAT('IBUGA3,ISUBRO,ICASE,TEND = ',2(A4,2X),A4,G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),TAG(I)
   57     FORMAT('I,Y(I),TAG(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR EXPONENTIAL MLE ESTIMATE        **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PML3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='EXPONENTIAL'
      CALL CKCENS(TAG,XTEMP,N,IDIST,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IWRITE='OFF'
      IFLAG=0
      CALL SUMRAW(Y,N,IDIST,IFLAG,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL SUMDP(Y,N,IWRITE,XSUM,IBUGA3,IERROR)
C
      ALOCML=CPUMIN
      ALOCSE=CPUMIN
      SCALML=CPUMIN
      SCALSE=CPUMIN
C
      CALL SORTC(Y,TAG,N,Y,TAG)
      IR=0
      DO2120I=1,N
        IF(TAG(I).EQ.1.0)IR=IR+1
 2120 CONTINUE
      IM=N-IR
C
      DR=DBLE(IR)
C
      IF(IM.EQ.0)THEN
        ICASE='NONE'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2131)
 2131   FORMAT('***** WARNING FROM EXPONENTIAL MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2133)
 2133   FORMAT('      NO CENSORING TIMES DETECTED.  IT IS RECOMMENDED')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2135)
 2135   FORMAT('      THAT THE FULL SAMPLE SYNTAX BE USED:')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2137)
 2137   FORMAT('      EXPONENTIAL MAXIMUM LIKELIHOOD  Y')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
      ELSE
        ICASE='SING'
        AHOLD=Y(IR+1)
        DO2140I=IR+1,N
          IF(Y(I).NE.AHOLD)THEN
            ICASE='MULT'
            GOTO2149
          ENDIF
 2140   CONTINUE
 2149   CONTINUE
      ENDIF
C
C               ************************************
C               **  STEP 41--                     **
C               **  CARRY OUT CALCULATIONS        **
C               **  FOR EXPONENTIAL MLE           **
C               **  ESTIMATE (TIME CENSORED CASE) **
C               ************************************
C
 4100 CONTINUE
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
      AN=REAL(N)
      AR=REAL(IR)
      AM=REAL(IM)
C
C     ESTIMATES FOR 1-PARAMETER MODEL
C
C     SIGMAHAT = (1/R)*SUM[i=1 to r][(1 + b(i)X(i)]
C
C     WHERE b(i) = NUMBER OF ITEMS CENSORED AT TIME i.
C
      IF(ICASPL.EQ.'1EXP')THEN
        ALOCML=0.0
        DO4103I=1,N
          IF(TAG(I).EQ.1.0)THEN
            AHOLD=Y(I)
            NCEN=0
            DO4105J=1,N
              IF(J.NE.I .AND. TAG(J).EQ.0.0 .AND. Y(J).EQ.AHOLD)THEN
                NCEN=NCEN+1
              ENDIF
 4105       CONTINUE
            XTEMP(I)=REAL(NCEN)
          ELSE
            XTEMP(I)=0.0
          ENDIF
 4103   CONTINUE
C
        DSUM1=0.0D0
        DO4107I=1,N
          IF(TAG(I).EQ.1.0)THEN
            DSUM1=DSUM1 + DBLE(1.0 + XTEMP(I))*DBLE(Y(I))
          ENDIF
 4107   CONTINUE
        SCALML=REAL(DSUM1/DR)
        SCALSE=SCALML/SQRT(AR)
C
      ELSE
C
C     ESTIMATES FOR 2-PARAMETER MODEL
C
        IF(ICASE.EQ.'SING')THEN
          DSUM1=0.0D0
          DO4145I=1,IR
            DSUM1=DSUM1 + DBLE(Y(I))
 4145     CONTINUE
          YSUMR=REAL(DSUM1)
C
          ALOCML=(1.0/(AN*(AR-1.0)))*(AN*AR*XMIN - YSUMR + AM*Y(IR))
          SCALML=(1.0/(AR-1.0))*(YSUMR - AN*Y(1) + AM*Y(IR))
          ALOCSE=(SCALML/AN)*SQRT(AR/(AR-1.0))
          SCALSE=SCALML/SQRT(AR-1.0)
        ENDIF
      ENDIF
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PML3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF EXPML3--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)N,XMEAN,XSD,XMIN,XMAX
 9013   FORMAT('N,XMEAN,XSD,XMIN,XMAX = ',I8,4G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9017)ALOCML,SCALML,ALOCSE,SCALSE
 9017   FORMAT('ALOCML,SCALML,ALOCSE,SCALSE = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE EXPML4(Y,X1,X2,N,NUMV,MAXNXT,
     1                  XTEMP,TEMP2,TEMP3,
     1                  XMEAN,XVAR,XSD,XMIN,XMAX,NTOT,
     1                  SCALML,SCALSE,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE 1-PARAMETER EXPONENTIAL DISTRIBUTION FOR THE
C              UNCENSORED CASE WITH GROUPED DATA.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.  SPECIFICALLY, THE SAMPLE SIZE AND THE
C              PRESENCE OF NON-NEGATIVE VALUES.
C
C     REFERENCE--JOHNSON, KOTZ, AND BALAKRISHNAN, "CONTINUOUS
C                UNIVARIATE DISTRIBUTIONS--Volume 1", SECOND EDITION,
C                WILEY, 1994, PP. 509-510.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/7
C     ORIGINAL VERSION--JULY      2010. EXTRACT FROM DPMLE4
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      INTEGER IFLAG
      INTEGER IFLAG1
      INTEGER IFLAG2
C
      COMMON/EX2COM/NK
      REAL     EXPFU2
      EXTERNAL EXPFU2
C
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DSIGMA
      DOUBLE PRECISION DX1
      DOUBLE PRECISION DX2
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X1(*)
      DIMENSION X2(*)
      DIMENSION XTEMP(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EXPM'
      ISUBN2='L4  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PML4')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF EXPML4--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,NUMV
   55   FORMAT('N,NUMV = ',2I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,X1(I),X2(I),Y(I)
   57     FORMAT('I,X1(I),X2(I),Y(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  COMPUTE SUMMARY STATISTICS          **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PML4')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMV2.EQ.2)THEN
        IFLAG1=1
        IFLAG2=0
        CALL SUMGRP(Y,X1,N,IDIST,IFLAG1,IFLAG2,
     1              XTEMP,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOT,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ELSEIF(NUMV2.EQ.3)THEN
        IFLAG1=1
        IFLAG2=0
        CALL SUMGR2(Y,X1,X2,N,IDIST,IFLAG1,IFLAG2,
     1              XTEMP,TEMP2,TEMP3,MAXNXT,
     1              XMEAN,XVAR,XSD,XMIN,XMAX,NTOT,
     1              ISUBRO,IBUGA3,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ELSE
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ******************************************
C               **  STEP 2--                            **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR EXPONENTIAL MLE ESTIMATE        **
C               ******************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PML4')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERFLG=0
      IERROR='NO'
      IWRITE='OFF'
C
      IF(NUMV.EQ.2)THEN
C
C       DEFINE INTERVALS
C
        DELTA=(X1(2)-X1(1))/2.0
        ICNT=1
        X2(ICNT)=0.0
        ICNT=2
        X2(ICNT)=X1(1)+DELTA
        DO2110I=2,N
          DELTA=(X1(I)-X1(I-1))/2.0
          ICNT=ICNT+1
          X2(ICNT)=X1(I)+DELTA
 2110   CONTINUE
        NK=ICNT
        ICNT=ICNT+1
        X2(ICNT)=CPUMAX
        Y(NK)=0.0
        DO2120I=1,NK
          X1(I)=X2(I)
 2120   CONTINUE
C
      ELSE
C
C       DEFINE INTERVALS
C
        ICNT=0
        DO2130I=1,N
          ICNT=ICNT+1
          X1(ICNT)=X2(ICNT)
 2130   CONTINUE
        ICNT=ICNT+1
        X1(ICNT)=CPUMAX
        X2(ICNT)=CPUMAX
        NK=ICNT
        Y(N+1)=0.0
C
      ENDIF
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLE4')THEN
        WRITE(ICOUT,2155)NUMV,NK
 2155   FORMAT('NUMV,NK = ',2I8)
        CALL DPWRST('XXX','WRIT')
        DO2157I=1,NK+1
          WRITE(ICOUT,2156)I,X1(I),Y(I)
 2156     FORMAT('I,X1(I),Y(I) =',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
 2157   CONTINUE
      ENDIF
C
C     ESTIMATES FOR 1-PARAMETER MODEL.  USE FZEROY TO FIND ROOT OF
C     EQUATION GIVEN IN EXPFU2 (COMMENTS IN THAT ROUTINE GIVE
C     ACTUAL EQUATION).  USE OVERALL MEAN AS STARTING VALUE.
C
      AE=1.E-6
      RE=1.E-6
      IFLAG=0
      XLOW=X1(1)
      XUP=X1(NK-1)
      CALL FZEROY(EXPFU2,XLOW,XUP,XMEAN,RE,AE,IFLAG,X1,Y)
      SCALML=XLOW
C
      IF(IFLAG.EQ.2)THEN
C
C  NOTE: SUPPRESS THIS MESSAGE FOR NOW.
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,111)
CC111   FORMAT('***** WARNING FROM GROUPED EXPONENTIAL MAXIMUM ',
CCCCC1         'LIKELIHOOD--')
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,113)
CC113   FORMAT('      ESTIMATE OF SIGMA MAY NOT BE COMPUTED TO ',
CCCCC1         'DESIRED TOLERANCE.')
CCCCC   CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,121)
  121   FORMAT('***** WARNING FROM GROUPED EXPONENTIAL MAXIMUM ',
     1         'LIKELIHOOD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,123)
  123   FORMAT('      ESTIMATE OF SIGMA MAY BE NEAR A SINGULAR POINT.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.4)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,131)
  131   FORMAT('***** ERROR FROM GROUPED EXPONENTIAL MAXIMUM ',
     1         'LIKELIHOOD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,133)
  133   FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.5)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,141)
  141   FORMAT('***** WARNING FROM GROUPED EXPONENTIAL MAXIMUM ',
     1         'LIKELIHOOD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,143)
  143   FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      AN=REAL(NTOT)
      DSIGMA=DBLE(SCALML)
      DSUM1=0.0D0
      DO150I=2,NK
        DX1=DBLE(X1(I))
        DX2=DBLE(X1(I-1))
        DTERM1=(DX1-DX2)**2/(DEXP(DX1/DSIGMA) - DEXP(DX2/DSIGMA))
        DSUM1=DSUM1 + DTERM1
  150 CONTINUE
      SCALSE=SQRT(AN*REAL(DSUM1))
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'PML4')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF EXPML4--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)XMEAN,XSD,XMIN,XMAX
 9012   FORMAT('XMEAN,XSD,XMIN,XMAX = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)SCALML,SCALSE
 9013   FORMAT('SCALML,SCALSE = ',2G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE EXPPDF(X,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE EXPONENTIAL DISTRIBUTION
C              WITH MEAN = 1 AND STANDARD DEVIATION = 1.
C              THIS DISTRIBUTION IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = EXP(-X).
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--PDF    = THE SINGLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE PDF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 207-232.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-921-2315
C     ORIGINAL VERSION--APRIL     1994. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 ICOUTINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,ICOUTINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(X.LT.0.0)THEN
        WRITE(ICOUT,4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
      ELSE
        PDF=EXP(-X)
      ENDIF
    4 FORMAT('***** WARNING--THE FIRST ARGUMENT TO EXPPDF IS NEGATIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      RETURN
      END 
      SUBROUTINE EXPPPF(P,PPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE EXPONENTIAL DISTRIBUTION
C              WITH MEAN = 1 AND STANDARD DEVIATION = 1.
C              THIS DISTRIBUTION IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = EXP(-X).
C              NOTE THAT THE PERCENT POINT FUNCTION OF A DISTRIBUTION
C              IS IDENTICALLY THE SAME AS THE INVERSE CUMULATIVE
C              DISTRIBUTION FUNCTION OF THE DISTRIBUTION.
C     INPUT  ARGUMENTS--P      = THE SINGLE PRECISION VALUE
C                                (BETWEEN 0.0 AND 1.0)
C                                AT WHICH THE PERCENT POINT
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--PPF    = THE SINGLE PRECISION PERCENT
C                                POINT FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PERCENT POINT
C             FUNCTION VALUE PPF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--P SHOULD BE BETWEEN 0.0 (INCLUSIVELY)
C                   AND 1.0 (EXCLUSIVELY).
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--LOG.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--FILLIBEN, SIMPLE AND ROBUST LINEAR ESTIMATION
C                 OF THE LOCATION PARAMETER OF A SYMMETRIC
C                 DISTRIBUTION (UNPUBLISHED PH.D. DISSERTATION,
C                 PRINCETON UNIVERSITY), 1969, PAGES 21-44, 229-231.
C               --FILLIBEN, 'THE PERCENT POINT FUNCTION',
C                 (UNPUBLISHED MANUSCRIPT), 1970, PAGES 28-31.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 207-232.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--JUNE      1972.
C     UPDATED         --SEPTEMBER 1975.
C     UPDATED         --NOVEMBER  1975.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LT.0.0.OR.P.GE.1.0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
      ELSE
        PPF=-LOG(1.0-P)
      ENDIF
    1 FORMAT('***** ERROR--THE FIRST ARGUMENT TO EXPPPF IS OUTSIDE ',
     1       'THE ALLOWABLE (0,1) INTERVAL.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      RETURN
      END
      SUBROUTINE EXPRAN(N,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE EXPONENTIAL DISTRIBUTION
C              WITH MEAN = 1 AND STANDARD DEVIATION = 1.
C              THIS DISTRIBUTION IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = EXP(-X).
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE EXPONENTIAL DISTRIBUTION
C             WITH MEAN = 1 AND STANDARD DEVIATION = 1.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--LOG.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--TOCHER, THE ART OF SIMULATION,
C                 1963, PAGES 14, 35-36.
C               --HAMMERSLEY AND HANDSCOMB, MONTE CARLO METHODS,
C                 1964, PAGE 36.
C               --FILLIBEN, 'THE PERCENT POINT FUNCTION',
C                 (UNPUBLISHED MANUSCRIPT), 1970, PAGES 28-31.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 207-232.
C               --HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--A HANDBOOK FOR
C                 STUDENTS AND PRACTITIONERS, 1975,
C                 PAGE 58.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--JUNE      1972.
C     UPDATED         --SEPTEMBER 1975.
C     UPDATED         --NOVEMBER  1975.
C     UPDATED         --JULY      1976.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE FIRST ARGUMENT TO THE ',
     1       'EXPRAN SUBROUTINE IS NON-POSITIVE.')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,'.')
C
C     GENERATE N UNIFORM (0,1) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     GENERATE N EXPONENTIAL RANDOM NUMBERS
C     USING THE PERCENT POINT FUNCTION TRANSFORMATION METHOD.
C
      DO100I=1,N
        X(I)=-LOG(X(I))
  100 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EXPSF(P,SF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE SPARSITY
C              FUNCTION VALUE FOR THE EXPONENTIAL DISTRIBUTION
C              WITH MEAN = 1 AND STANDARD DEVIATION = 1.
C              THIS DISTRIBUTION IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = EXP(-X).
C              NOTE THAT THE SPARSITY FUNCTION OF A DISTRIBUTION
C              IS THE DERIVATIVE OF THE PERCENT POINT FUNCTION,
C              AND ALSO IS THE RECICOUTOCAL OF THE PROBABILITY
C              DENSITY FUNCTION (BUT IN UNITS OF P RATHER THAN X).
C     INPUT  ARGUMENTS--P      = THE SINGLE PRECISION VALUE 
C                                (BETWEEN 0.0 AND 1.0)
C                                AT WHICH THE SPARSITY
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--SF     = THE SINGLE PRECISION
C                                SPARSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION SPARSITY
C             FUNCTION VALUE SF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--P SHOULD BE BETWEEN 0.0 (INCLUSIVELY)
C                   AND 1.0 (EXCLUSIVELY).
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--FILLIBEN, SIMPLE AND ROBUST LINEAR ESTIMATION
C                 OF THE LOCATION PARAMETER OF A SYMMETRIC
C                 DISTRIBUTION (UNPUBLISHED PH.D. DISSERTATION,
C                 PRINCETON UNIVERSITY), 1969, PAGES 21-44, 229-231.
C               --FILLIBEN, 'THE PERCENT POINT FUNCTION',
C                 (UNPUBLISHED MANUSCRIPT), 1970, PAGES 28-31.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 207-232.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE:  301-921-2315
C     ORIGINAL VERSION--APRIL     1994. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 ICOUTINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,ICOUTINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LT.0.0.OR.P.GE.1.0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
      ELSE
        SF=1.0/(1.0-P)
      ENDIF
    1 FORMAT('***** ERROR--THE FIRST ARGUMENT TO EXPSF IS OUTSIDE ',
     1       'THE ALLOWABLE (0,1) INTERVAL.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7,'.')
C
      RETURN
      END 
      SUBROUTINE EXPSMO(X,TEMP,ALPHA,AMSE,NX,IWRITE,Y,IBUGA3,IERROR)
C
C     PURPOSE--COMPUTE EXPONETIAL SMOOTH OF AN ARRAY
C              THE ALPHA PARANETER IDENTIFIES THE SMOOTHING PARAMETER
C     NOTE--IT IS PERMISSIBLE TO HAVE THE OUTPUT VECTOR Y(.)
C           BEING IDENTICAL TO THE INPUT VECTOR X(.).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/5
C     ORIGINAL VERSION--MAY       1998.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
      DOUBLE PRECISION DSUM
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION Y(*)
      DIMENSION TEMP(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EXPS'
      ISUBN2='MO  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF EXPSMO--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3
   52 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)NX,ALPHA
   53 FORMAT('NX,ALPHA = ',I8,1X,F10.5)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,NX
      WRITE(ICOUT,56)I,X(I)
   56 FORMAT('I,X(I) = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               **************************************
C               **  COMPUTE EXPONENTIAL SMOOTH      **
C               **************************************
C
      IF(ALPHA.LE.0.0 .OR. ALPHA.GE.1.0)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,101)
  101   FORMAT('***** ERROR FROM EXPSMO.  SMOOTHING PARAMETER MUST')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,103)
  103   FORMAT('      BE > 0 AND < 1.  THE ENTERED VALUE WAS ',E15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      DSUM=0.0D0
      TEMP(1)=X(1)
      DO200I=2,NX
        ATEMP=X(I)-TEMP(I-1)
        TEMP(I)=ALPHA*ATEMP + TEMP(I-1)
        DSUM=DSUM + DBLE(ATEMP)**2
  200 CONTINUE
      AMSE=REAL(DSUM)/REAL(NX-1)
C
      DO300I=1,NX
        Y(I)=TEMP(I)
  300 CONTINUE
C
      NY=NX
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF EXPSMO--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,IERROR
 9012 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)NX,NY
 9013 FORMAT('NX,NY = ',2I8)
      CALL DPWRST('XXX','BUG ')
      DO9015I=1,NX
      WRITE(ICOUT,9016)I,X(I),Y(I)
 9016 FORMAT('I,X(I),Y(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE EXPSM2(X,TEMP,ALPHA,AMSE,NX,IWRITE,Y,IBUGA3,IERROR)
C
C     PURPOSE--COMPUTE EXPONETIAL SMOOTH OF AN ARRAY
C              THE ALPHA PARANETER IDENTIFIES THE SMOOTHING PARAMETER
C              NOTE: USE THIS VERSION IF ALPHA NOT SPECIFIED.
C                    USE AN ITERATIVE SEARCH TO FIND THE OPTIMAL
C                    VALUE FOR ALPHA.
C     NOTE--IT IS PERMISSIBLE TO HAVE THE OUTPUT VECTOR Y(.)
C           BEING IDENTICAL TO THE INPUT VECTOR X(.).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--99/2
C     ORIGINAL VERSION--FEBRUARY  1999.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION Y(*)
      DIMENSION TEMP(*)
C
      REAL AMSEV(20)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EXPS'
      ISUBN2='MO  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF EXPSM2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3
   52 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)NX,ALPHA
   53 FORMAT('NX,ALPHA = ',I8,1X,F10.5)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,NX
      WRITE(ICOUT,56)I,X(I)
   56 FORMAT('I,X(I) = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               **************************************
C               **  COMPUTE EXPONENTIAL SMOOTH      **
C               **************************************
C
CCCCC FIND BEST ALPHA TO FIRST DECIMAL PLACE.
C
      AMNVAL=CPUMAX
      DO100I=1,9
        ALPHA=REAL(I)/10.
        CALL EXPSMO(X,TEMP,ALPHA,AMSE,NX,IWRITE,Y,IBUGA3,IERROR)
        AMSEV(I)=AMSE
        IF(AMSEV(I).LT.AMNVAL)THEN
          AX=ALPHA
          AMNVAL=AMSEV(I)
        ENDIF
  100 CONTINUE
      ALPHA=AX
C
CCCCC FIND BEST ALPHA TO FIRST DECIMAL PLACE.
C
      AMNVAL=CPUMAX
      D=0.09
      DINC=0.01
      ASTRT=ALPHA-D
      DO200I=1,19
        ALPHA=ASTRT+REAL(I-1)*DINC
        CALL EXPSMO(X,TEMP,ALPHA,AMSE,NX,IWRITE,Y,IBUGA3,IERROR)
        AMSEV(I)=AMSE
        IF(AMSEV(I).LT.AMNVAL)THEN
          AX=ALPHA
          AMNVAL=AMSEV(I)
        ENDIF
  200 CONTINUE 
      ALPHA=AX
C
CCCCC FIND BEST ALPHA TO THIRD DECIMAL PLACE.
C
      AMNVAL=CPUMAX
      D=0.009
      DINC=0.001
      ASTRT=ALPHA-D
      DO300I=1,19
        ALPHA=ASTRT+REAL(I-1)*DINC
        CALL EXPSMO(X,TEMP,ALPHA,AMSE,NX,IWRITE,Y,IBUGA3,IERROR)
        AMSEV(I)=AMSE
        IF(AMSEV(I).LT.AMNVAL)THEN
          AX=ALPHA
          AMNVAL=AMSEV(I)
        ENDIF
  300 CONTINUE 
      ALPHA=AX
C
      IF(IWRITE.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,510)ALPHA
  510   FORMAT('FOR EXPONENTIAL SMOOTHING, OPTIMAL VALUE OF ALPHA',
     1         '(TO 3 DECIMAL PLACES) = ',F6.3)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF EXPSM2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,IERROR
 9012 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)NX
 9013 FORMAT('NX = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9015I=1,NX
      WRITE(ICOUT,9016)I,X(I),Y(I)
 9016 FORMAT('I,X(I),Y(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE EXTBOU(ICASPL,IBOUND)
C
C     PURPOSE--CERTAIN OF THE PROBABILITY ROUTINES USE LOWER AND
C              UPPER LIMIT PARAMETERS RATHER THAN LOCATION AND
C              SCALE PARAMETERS.  SET THE VALUE OF IBOUND TO 0
C              IF LOCATION AND SCALE PARAMETERS WILL BE USED AND
C              TO 1 IF LOWER AND UPPER LIMIT PARAMETERS WILL BE USED.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORAOTRY
C                 NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/9
C     ORIGINAL VERSION--SEPTEMBER 2009.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
C
C---------------------------------------------------------------------
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      IBOUND=0
      IF(ICASPL.EQ.'UNIF')IBOUND=1
      IF(ICASPL.EQ.'BETA')IBOUND=1
      IF(ICASPL.EQ.'NCBE')IBOUND=1
      IF(ICASPL.EQ.'TRIA')IBOUND=1
      IF(ICASPL.EQ.'POWF')IBOUND=1
      IF(ICASPL.EQ.'RPOW')IBOUND=1
      IF(ICASPL.EQ.'JOSB')IBOUND=1
      IF(ICASPL.EQ.'TSPO')IBOUND=1
      IF(ICASPL.EQ.'GTOL')IBOUND=1
      IF(ICASPL.EQ.'RGTL')IBOUND=1
      IF(ICASPL.EQ.'SLOP')IBOUND=1
      IF(ICASPL.EQ.'OGIV')IBOUND=1
      IF(ICASPL.EQ.'TSSL')IBOUND=1
      IF(ICASPL.EQ.'TSOG')IBOUND=1
      IF(ICASPL.EQ.'KUMA')IBOUND=1
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EXTDIG(IINPUT,IDIGIT,NDIGIT,IBUGA3,IERROR)
C
C     PURPOSE--EXTRACT THE DIGITS FROM AN INTEGER.
C              PROCEED LEFT TO RIGHT.
C     INPUT  ARGUMENTS--  IINPUT = AN INTEGER
C     OUTPUT ARGUMENTS--  IDIGIT   = VECTOR OF DIGITS
C                         NDIGIT   = NUMBER OF ELEMENTS IN IDIGIT
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--89.1
C     ORIGINAL VERSION--JANUARY   1989.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      DIMENSION IDIGIT(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
      NDIGIT=0
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF EXTDIG--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IINPUT
   52 FORMAT('IINPUT = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IBUGA3
   53 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  STEP 11--                                   **
C               **  CHECK THE INPUT NUMBER FOR ERRORS           **
C               **************************************************
C
      IF(IINPUT.GE.0)GOTO1190
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1111)
 1111 FORMAT('***** ERROR IN EXTDIG--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1112)
 1112 FORMAT('      THE INPUT NUMBER WAS NEGATIVE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1113)IINPUT
 1113 FORMAT('      THE INPUT NUMBER = ',I8)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1190 CONTINUE
C
C               **************************************************
C               **  STEP 12--                                   **
C               **  DETERMINE THE NUMBER OF DIGITS              **
C               **  IN THE NUMBER                               **
C               **************************************************
C
      MAXDIG=9
      IREM=IINPUT
      DO1200I=1,MAXDIG
      IREV=MAXDIG-I+1
      IPOWER=INT(10.0**IREV + 0.01)
      IRATIO=IREM/IPOWER
      IF(IRATIO.EQ.0)GOTO1200
      GOTO1290
 1200 CONTINUE
      IREV=0
 1290 CONTINUE
      NDIGIT=IREV+1
C
C               **************************************************
C               **  STEP 13--                                   **
C               **  EXTRACT THE INDIVIDUAL DIGITS               **
C               **************************************************
C
      IREM=IINPUT
      J=0
      DO1300I=1,NDIGIT
      J=J+1
      IREV=NDIGIT-I+1
      IPOWER=INT(10**(IREV-1) + 0.01)
      IDIGIT(I)=IREM/IPOWER
      IREM=IREM-IDIGIT(I)*IPOWER
 1300 CONTINUE
C
C               *******************
C               **   STEP 90--   **
C               **   EXIT        **
C               *******************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF EXTDIG--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IINPUT
 9012 FORMAT('IINPUT = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IBUGA3,IERROR
 9013 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)NDIGIT
 9021 FORMAT('NDIGIT = ',I8)
      CALL DPWRST('XXX','BUG ')
      IF(NDIGIT.LE.0)GOTO9024
      DO9022I=1,NDIGIT
      WRITE(ICOUT,9023)I,IDIGIT(I)
 9023 FORMAT('I,IDIGIT(I) = ',2I8)
      CALL DPWRST('XXX','BUG ')
 9022 CONTINUE
 9024 CONTINUE
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE EXTDIS(ICOM,ICOM2,IHARG,IHARG2,NUMARG,JMIN,JMAX,
     1                  IDISCS,IDISNM,IDISPR,IFOUND,ILOCV,
     1                  ISUBRO,IBUGG3,IERROR)
C
C     PURPOSE--EXTRACT THE NAME OF ONE OF 150+ DISTRIBUTIONS.  THIS
C              IS A COMMON ROUTINE CALLED BY:
C                1) DPPP    = <DIST> PROBABILITY PLOT
C                2) DP1KST  = <DIST> KOLMOGOROV SMIRNOV GOODNESS OF FIT
C                3) DPCHSQ  = <DIST> CHI-SQUARE SMIRNOV GOODNESS OF FIT
C                4) DPPPCC  = <DIST> PPCC PLOT
C
C              NOTE THAT NOT ALL COMMANDS MAY SUPPORT ALL DISTRIBUTIONS.
C
C              THE FOLLOWING DISTRIBUTIONS ARE SUPPORTED:
C
C              1 ) UNIFORM
C              2 ) NORMAL
C              3 ) LOGISTIC
C              4 ) DOUBLE EXPONENTIAL
C              5 ) CAUCHY
C              6 ) TUKEY LAMBDA
C              7 ) LOGNORMAL
C              8 ) HALFNORMAL
C              9 ) T
C              10) CHI-SQUARED
C              11) F
C              12) EXPONENTIAL
C              13) GAMMA
C              14) BETA
C              15) WEIBULL---MIN & MAX
C              16) EXTREME VALUE TYPE 1 (GUMBEL)--MIN & MAX
C              17) EXTREME VALUE TYPE 2 (FRECHET)--MIN & MAX
C              18) PARETO
C              19) BINOMIAL
C              20) GEOMETRIC
C              21) POISSON
C              22) NEGATIVE BINOMIAL
C              23) SEMI-CIRCULAR
C              24) TRIANGULAR
C              25) INVERSE GAUUSIAN
C              26) WALD
C              27) RECIPROCAL INVERSE GAUUSIAN
C              28) FAILURE TIME
C              29) GENERALIZED PARETO
C              30) DISCRETE UNIFORM
C              31) NON-CENTRAL T
C              32) NON-CENTRAL F
C              33) NON-CENTRAL CHI-SQUARE
C              34) NON-CENTRAL BETA
C              35) DOUBLY NON-CENTRAL T
C              36) DOUBLY NON-CENTRAL F
C              36) HYPER-GEOMETRIC
C              37) VON-MISES
C              38) POWER NORMAL
C              39) POWER LOGNORMAL
C              40) COSINE
C              41) ALPHA
C              42) POWER FUNCTION
C              43) CHI
C              44) LOGARITMIC SERIES
C              45) LOG LOGISTIC
C              46) GENERALIZED GAMMA
C              47) WARING
C              48) ANGLIT
C              49) ARCSIN
C              50) FOLDED NORMAL
C              51) TRUNCATED NORMAL
C              52) LOG GAMMA
C              53) HYPERBOLIC SECANT
C              54) GOMPERTZ
C              55) PARETO SECOND KIND
C              56) DOUBLE WEIBULL
C              57) WRAPPED-UP CAUCHY
C              58) EXPONENTIAL WEIBULL
C              59) TRUNCATED EXPONENTIAL
C              60) GENERALIZED LOGISTIC
C              61) EXPONENTIAL POWER
C              62) DOUBLE GAMMA
C              63) MIELKE'S BETA-KAPPA
C              64) FOLDED CAUCHY
C              65) BETA BINOMIAL
C              66) BETA PASCAL
C              67) GENERALIZED EXPONENTIAL
C              68) RECIPROCAL PROB
C              69) NORMAL MIXTURE
C              70) INVERTED GAMMA
C              71) GENERALIZED TUKEY LAMBDA
C              72) JOHNSON SB
C              73) JOHNSON SU
C              74) INVERTED WEIBULL
C              75) LOG DOUBLE EXPONENTIAL
C              76) GEOMETRIC EXTREME EXPONENTIAL
C              77) TWO-SIDED POWER
C              78) BIWEIBULL
C              79) G-AND-H
C              80) LANDAU
C              81) ERROR
C              82) TRAPEZOID
C              83) GENERALIZED TRAPEZOID
C              84) FOLDED T
C              85) SLASH
C              86) SKEWED NORMAL
C              87) SKEWED T
C              88) INVERTED BETA
C              89) GOMPERTZ-MAKEHAM
C              90) LOG-SKEW-NORMAL
C              91) LOG-SKEW-T
C              92) GENERALIZED HALF-LOGISTIC
C              93) POLYA
C              94) HERMITE
C              95) YULE
C              96) SKEW DOUBLE EXPONENTIAL
C              97) ASYMMETRIC DOUBLE EXPONENTIAL
C              98) MAXWELL
C              99) RAYLEIGH
C             100) GENERALIZED ASYMMETRIC DOUBLE EXPONENTIAL
C             101) GENERALIZED INVERSE GAUSSIAN
C             102) MCLEISH
C             103) BESSEL I FUNCTION
C             104) BESSEL K FUNCTION
C             105) GENERALIZED MCLEISH
C             106) HYPERBOLIC
C             107) GENERALIZED LOGISTIC TYPE 5
C             108) GENERALIZED LOGISTIC TYPE 2
C             109) WAKEB
C             110) BETA NORMAL
C             111) GENERALIZED LOGISTIC TYPE 3
C             114) GENERALIZED LOGISTIC TYPE 4
C             115) ASYMMETRIC LOG DOUBLE EXPONENTIAL
C             116) BETA GEOMETRIC
C             117) ZETA
C             118) ZIPF
C             118) BOREL-TANNER
C             119) BETA NEGATIVE BINOMIAL
C             120) LAGRANGE POISON
C             121) LEADS IN COIN TOSSING (DISCRETE ARCSINE)
C             122) MATCHING
C             123) LOST GAMES
C             124) LOG BETA
C             125) POLYA AEPPLI
C             126) CLASSICAL OCCUPANCY (NOT ACTIVE)
C             127) GENERALIZED LOGARITHMIC SERIES
C             128) GENERALIZED NEGATIVE BINOMIAL
C             129) GEETA
C             130) QUASI BINOMIAL TYPE I
C             131) CONSUL (GENERALIZED GEOMETRIC)
C             132) LAGRANGE KATZ (NOT ACTIVE)
C             133) KATZ
C             134) DISCRETE WEIBULL
C             135) GENERALIZED LOST GAMES
C             136) TRUNCATED GENERALIZED NEGATIVE BINOMIAL
C             137) TOPP AND LEONE
C             138) GENERALIZED TOPP AND LEONE
C             139) REFLECTED GENERALIZED TOPP AND LEONE
C             140) SLOPE
C             141) TWO-SIDED SLOPE
C             142) OGIVE
C             143) TWO-SIDED OGIVE
C             144) UNEVEN TWO-SIDED POWER
C             145) DOUBLY UNIFORM PARETO
C             146) BURR TYPE 1 (= UNIFORM)
C             147) BURR TYPE 2
C             148) BURR TYPE 3
C             149) BURR TYPE 4
C             150) BURR TYPE 5
C             151) BURR TYPE 6
C             152) BURR TYPE 7
C             153) BURR TYPE 8
C             154) BURR TYPE 9
C             155) BURR TYPE 10
C             156) BURR TYPE 11
C             157) BURR TYPE 12
C             158) KUMARASWAMY
C             159) REFLECTED POWER
C             160) MUTH
C             161) LOGISTIC-EXPONENTIAL
C             162) TRUNCATED PARETO
C             163) BRITTLE FRACTURE
C             164) 3-PARAMETER LOGISTIC-EXPONENTIAL
C             165) KAPPA
C             166) PEARSON TYPE 3
C             167) POWER LAW
C             168) END EFFECTS WEIBULL
C             169) BRITTLE FIBER WEIBULL
C             170) ARCTANGENT
C             171) SINE
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/8
C     ORIGINAL VERSION--AUGUST    2009.
C     UPDATED         --JUNE      2010. DISTINGUISH 2-PARAMETER AND
C                                       3-PARAMETER CASES FOR:
C                                       WEIBULL, LOGNORMAL, GAMMA,
C                                       INVERSE GAUSSIAN, INVERTED WEIBULL
C     UPDATED         --JULY      2010. DISTINGUISH 2-PARAMETER AND 1-PARAMETER
C                                       FOR EXPONENTIAL, RAYLEIGH, MAXWELL
C     UPDATED         --JULY      2010. END EFFECTS WEIBULL
C     UPDATED         --AUGUST    2010. BRITTLE FIBER WEIBULL
C     UPDATED         --JANUARY   2011. ARCTANGENT
C     UPDATED         --MARCH     2013. SINE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICOM
      CHARACTER*4 ICOM2
      CHARACTER*4 IHARG(*)
      CHARACTER*4 IHARG2(*)
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGG3
      CHARACTER*4 IERROR
C
      CHARACTER*4  IDISCS
      CHARACTER*60 IDISNM
      CHARACTER*4  IFOUND
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      CHARACTER*30 IDIST
C
      PARAMETER (MAXDIS=300)
      PARAMETER (MAXSCL=4)
      CHARACTER*4 INAME(MAXDIS,MAXSCL)
      CHARACTER*4 INCASE(MAXDIS)
      CHARACTER*4 INTEMP(MAXDIS)
      CHARACTER*60 INLONG(MAXDIS)
      INTEGER INSHAP(MAXDIS)
C
C-----COMMON----------------------------------------------------------
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C     CREATE TABLE OF STATISTIC NAMES.
C
C       1) INCASE      = 4-CHARACTER CODE FOR DISTRIBUTION
C       2) INAME       = MATCHING ENTRIES FOR DISTRIBUTION.
C       3) INSHAP      = NUMBER OF SHAPE PARAMETERS
C       4) INLONG      = DESCRIPTIVE NAME FOR STATISTIC.
C                
C     UNIFORM
      DATA INCASE(1)/'UNIF'/
      DATA (INAME(1,J),J=1,4)/'UNIF','    ','    ','    '/
      DATA INSHAP(1)/0/
      DATA INLONG(1)/'UNIFORM'/
      DATA INCASE(2)/'UNIF'/
      DATA (INAME(2,J),J=1,4)/'RECT','    ','    ','    '/
      DATA INSHAP(2)/0/
      DATA INLONG(2)/'UNIFORM'/
C     NORMAL MIXTURE
      DATA INCASE(3)/'NORX'/
      DATA (INAME(3,J),J=1,4)/'NORM','MIXT','    ','    '/
      DATA INSHAP(3)/5/
      DATA INLONG(3)/'NORMAL MIXTURE'/
      DATA INCASE(4)/'NORX'/
      DATA (INAME(4,J),J=1,4)/'GAUS','MIXT','    ','    '/
      DATA INSHAP(4)/5/
      DATA INLONG(4)/'NORMAL MIXTURE'/
C     NORMAL
      DATA INCASE(5)/'NORM'/
      DATA (INAME(5,J),J=1,4)/'NORM','    ','    ','    '/
      DATA INSHAP(5)/0/
      DATA INLONG(5)/'NORMAL'/
      DATA INCASE(6)/'NORM'/
      DATA (INAME(6,J),J=1,4)/'GAUS','    ','    ','    '/
      DATA INSHAP(6)/0/
      DATA INLONG(6)/'NORMAL'/
C     LOGISTIC EXPONENTIAL
      DATA INCASE(7)/'LEXP'/
      DATA (INAME(7,J),J=1,4)/'LOGI','EXPO','    ','    '/
      DATA INSHAP(7)/1/
      DATA INLONG(7)/'LOGISTIC EXPONENTIAL'/
C     DOUBLE EXPONENTIAL
      DATA INCASE(8)/'DEXP'/
      DATA (INAME(8,J),J=1,4)/'DOUB','EXPO','    ','    '/
      DATA INSHAP(8)/0/
      DATA INLONG(8)/'DOUBLE EXPONENTIAL'/
      DATA INCASE(9)/'DEXP'/
      DATA (INAME(9,J),J=1,4)/'LAPL','    ','    ','    '/
      DATA INSHAP(9)/0/
      DATA INLONG(9)/'DOUBLE EXPONENTIAL'/
C     CAUCHY
      DATA INCASE(10)/'CAUC'/
      DATA (INAME(10,J),J=1,4)/'CAUC','    ','    ','    '/
      DATA INSHAP(10)/0/
      DATA INLONG(10)/'CAUCHY'/
C     TUKEY-LAMBDA
      DATA INCASE(11)/'TULA'/
      DATA (INAME(11,J),J=1,4)/'TUKE','LAMB','    ','    '/
      DATA INSHAP(11)/1/
      DATA INLONG(11)/'TUKEY-LAMBDA'/
      DATA INCASE(12)/'TULA'/
      DATA (INAME(12,J),J=1,4)/'TUKE','    ','    ','    '/
      DATA INSHAP(12)/1/
      DATA INLONG(12)/'TUKEY-LAMBDA'/
      DATA INCASE(13)/'TULA'/
      DATA (INAME(13,J),J=1,4)/'LAMB','    ','    ','    '/
      DATA INSHAP(13)/1/
      DATA INLONG(13)/'TUKEY-LAMBDA'/
C     LOGNORMAL
      DATA INCASE(14)/'LOGN'/
      DATA (INAME(14,J),J=1,4)/'LOG ','NORM','    ','    '/
      DATA INSHAP(14)/1/
      DATA INLONG(14)/'LOG-NORMAL'/
      DATA INCASE(15)/'LOGN'/
      DATA (INAME(15,J),J=1,4)/'LOGN','    ','    ','    '/
      DATA INSHAP(15)/1/
      DATA INLONG(15)/'LOG-NORMAL'/
C     HALF-NORMAL
      DATA INCASE(16)/'HNOR'/
      DATA (INAME(16,J),J=1,4)/'HALF','NORM','    ','    '/
      DATA INSHAP(16)/0/
      DATA INLONG(16)/'HALF-NORMAL'/
C
      DATA INCASE(17)/'HALO'/
      DATA (INAME(17,J),J=1,4)/'HALF','LOGI','    ','    '/
      DATA INSHAP(17)/0/
      DATA INLONG(17)/'HALF-LOGISITC'/
C     T
      DATA INCASE(18)/'TPP'/
      DATA (INAME(18,J),J=1,4)/'T   ','    ','    ','    '/
      DATA INSHAP(18)/1/
      DATA INLONG(18)/'T'/
      DATA INCASE(19)/'TPP'/
      DATA (INAME(19,J),J=1,4)/'STUD','T   ','    ','    '/
      DATA INSHAP(19)/1/
      DATA INLONG(19)/'T'/
C     CHI-SQUARE
      DATA INCASE(20)/'CHIS'/
      DATA (INAME(20,J),J=1,4)/'CHIS','    ','    ','    '/
      DATA INSHAP(20)/1/
      DATA INLONG(20)/'CHI-SQUARE'/
      DATA INCASE(21)/'CHIS'/
      DATA (INAME(21,J),J=1,4)/'CHI ','SQUA','    ','    '/
      DATA INSHAP(21)/1/
      DATA INLONG(21)/'CHI-SQUARE'/
C     F
      DATA INCASE(22)/'FPP'/
      DATA (INAME(22,J),J=1,4)/'F   ','    ','    ','    '/
      DATA INSHAP(22)/1/
      DATA INLONG(22)/'F'/
      DATA INCASE(23)/'FPP'/
      DATA (INAME(23,J),J=1,4)/'SNED','F   ','    ','    '/
      DATA INSHAP(24)/1/
      DATA INLONG(24)/'F'/
C     EXPONENTIAL POWER
      DATA INCASE(24)/'PEXP'/
      DATA (INAME(24,J),J=1,4)/'EXPO','POWE','    ','    '/
      DATA INSHAP(24)/1/
      DATA INLONG(24)/'POWER EXPONENTIAL'/
C     NEGATIVE EXPONENTIAL (= EXPONENTIAL)
      DATA INCASE(25)/'EXPO'/
      DATA (INAME(25,J),J=1,4)/'NEGA','EXPO','    ','    '/
      DATA INSHAP(25)/0/
      DATA INLONG(25)/'EXPONENTIAL'/
C     GAMMA
      DATA INCASE(26)/'GAMM'/
      DATA (INAME(26,J),J=1,4)/'GAMM','    ','    ','    '/
      DATA INSHAP(26)/1/
      DATA INLONG(26)/'GAMMA'/
C
      DATA INCASE(27)/'BNOR'/
      DATA (INAME(27,J),J=1,4)/'BETA','NORM','    ','    '/
      DATA INSHAP(27)/4/
      DATA INLONG(27)/'BETA NORMAL'/
C     WEIBULL
      DATA INCASE(28)/'WEIB'/
      DATA (INAME(28,J),J=1,4)/'WEIB','    ','    ','    '/
      DATA INSHAP(28)/1/
      DATA INLONG(28)/'WEIBULL'/
C     EXTREME VALUE TYPE I (GUMBEL)
      DATA INCASE(29)/'EV1'/
      DATA (INAME(29,J),J=1,4)/'EXTR','VALU','TYPE','1   '/
      DATA INSHAP(29)/0/
      DATA INLONG(29)/'GUMBEL'/
      DATA INCASE(30)/'EV1'/
      DATA (INAME(30,J),J=1,4)/'EXTR','VALU','TYPE','I   '/
      DATA INSHAP(30)/0/
      DATA INLONG(30)/'GUMBEL'/
      DATA INCASE(31)/'EV1'/
      DATA (INAME(31,J),J=1,4)/'EV1 ','    ','    ','    '/
      DATA INSHAP(31)/0/
      DATA INLONG(31)/'GUMBEL'/
      DATA INCASE(32)/'EV1'/
      DATA (INAME(32,J),J=1,4)/'EVI ','    ','    ','    '/
      DATA INSHAP(32)/0/
      DATA INLONG(32)/'GUMBEL'/
      DATA INCASE(33)/'EV1'/
      DATA (INAME(33,J),J=1,4)/'GUMB','    ','    ','    '/
      DATA INSHAP(33)/0/
      DATA INLONG(33)/'GUMBEL'/
C     EXTREME VALUE TYPE II (FRECHET)
      DATA INCASE(34)/'EV2'/
      DATA (INAME(34,J),J=1,4)/'EXTR','VALU','TYPE','2   '/
      DATA INSHAP(34)/1/
      DATA INLONG(34)/'FRECHET'/
      DATA INCASE(35)/'EV2'/
      DATA (INAME(35,J),J=1,4)/'EXTR','VALU','TYPE','II  '/
      DATA INSHAP(35)/1/
      DATA INLONG(35)/'FRECHET'/
      DATA INCASE(36)/'EV2'/
      DATA (INAME(36,J),J=1,4)/'EVII','    ','    ','    '/
      DATA INSHAP(36)/1/
      DATA INLONG(36)/'FRECHET'/
      DATA INCASE(37)/'EV2'/
      DATA (INAME(37,J),J=1,4)/'EV2 ','    ','    ','    '/
      DATA INSHAP(37)/1/
      DATA INLONG(37)/'FRECHET'/
      DATA INCASE(38)/'EV2'/
      DATA (INAME(38,J),J=1,4)/'FREC','    ','    ','    '/
      DATA INSHAP(38)/1/
      DATA INLONG(38)/'FRECHET'/
C     PARETO
      DATA INCASE(39)/'PARE'/
      DATA (INAME(39,J),J=1,4)/'PARE','    ','    ','    '/
      DATA INSHAP(39)/1/
      DATA INLONG(39)/'PARETO'/
C     BINOMIAL
      DATA INCASE(40)/'BINO'/
      DATA (INAME(40,J),J=1,4)/'BINO','    ','    ','    '/
      DATA INSHAP(40)/2/
      DATA INLONG(40)/'BINOMIAL'/
C     GEOMETRIC EXTREME EXPONENTIAL
      DATA INCASE(41)/'GEEX'/
      DATA (INAME(41,J),J=1,4)/'GEOM','EXTR','EXPO','    '/
      DATA INSHAP(41)/1/
      DATA INLONG(41)/'GEOMETRIC EXTREME EXPONENTIAL'/
C
      DATA INCASE(42)/'POIS'/
      DATA (INAME(42,J),J=1,4)/'POIS','    ','    ','    '/
      DATA INSHAP(42)/1/
      DATA INLONG(42)/'POISSON'/
C     NEGATIVE BINOMIAL
      DATA INCASE(43)/'NEBI'/
      DATA (INAME(43,J),J=1,4)/'NEGA','BINO','    ','    '/
      DATA INSHAP(43)/2/
      DATA INLONG(43)/'NEGATIVE BINOMIAL'/
C     SEMI-CIRCULAR
      DATA INCASE(44)/'SEMC'/
      DATA (INAME(44,J),J=1,4)/'SEMI','CIRC','    ','    '/
      DATA INSHAP(44)/1/
      DATA INLONG(44)/'SEMI-CIRCULAR'/
      DATA INCASE(45)/'SEMC'/
      DATA (INAME(45,J),J=1,4)/'SEMI','    ','    ','    '/
      DATA INSHAP(45)/1/
      DATA INLONG(45)/'SEMI-CIRCULAR'/
C     TRIANGULAR
      DATA INCASE(46)/'TRIA'/
      DATA (INAME(46,J),J=1,4)/'TRIA','    ','    ','    '/
      DATA INSHAP(46)/1/
      DATA INLONG(46)/'TRIANGULAR'/
C     IVERSE GAUSSIAN
      DATA INCASE(47)/'INGA'/
      DATA (INAME(47,J),J=1,4)/'INVE','GAUS','    ','    '/
      DATA INSHAP(47)/2/
      DATA INLONG(47)/'INVERSE GAUSSIAN'/
      DATA INCASE(48)/'INGA'/
      DATA (INAME(48,J),J=1,4)/'IG  ','    ','    ','    '/
      DATA INSHAP(48)/2/
      DATA INLONG(48)/'INVERSE GAUSSIAN'/
C     WALD
      DATA INCASE(49)/'WALD'/
      DATA (INAME(49,J),J=1,4)/'WALD','    ','    ','    '/
      DATA INSHAP(49)/1/
      DATA INLONG(49)/'WALD'/
C     RECIPROCAL INVERSE GAUSSIAN
      DATA INCASE(50)/'RIGA'/
      DATA (INAME(50,J),J=1,4)/'RIG ','    ','    ','    '/
      DATA INSHAP(50)/2/
      DATA INLONG(50)/'RECIPROCAL INVERSE GAUSSIAN'/
      DATA INCASE(51)/'RIGA'/
      DATA (INAME(51,J),J=1,4)/'TWEE','    ','    ','    '/
      DATA INSHAP(51)/2/
      DATA INLONG(51)/'RECIPROCAL INVERSE GAUSSIAN'/
      DATA INCASE(52)/'RIGA'/
      DATA (INAME(52,J),J=1,4)/'RECI','INVE','GAUS','    '/
      DATA INSHAP(52)/2/
      DATA INLONG(52)/'RECIPROCAL INVERSE GAUSSIAN'/
C     FATIGUE LIFE
      DATA INCASE(53)/'FATL'/
      DATA (INAME(53,J),J=1,4)/'FATI','LIFE','    ','    '/
      DATA INSHAP(53)/1/
      DATA INLONG(53)/'FATIGUE LIFE'/
      DATA INCASE(54)/'FATL'/
      DATA (INAME(54,J),J=1,4)/'FL  ','    ','    ','    '/
      DATA INSHAP(54)/1/
      DATA INLONG(54)/'FATIGUE LIFE'/
      DATA INCASE(55)/'FATL'/
      DATA (INAME(55,J),J=1,4)/'BIRN','SAUN','    ','    '/
      DATA INSHAP(55)/1/
      DATA INLONG(55)/'FATIGUE LIFE'/
      DATA INCASE(56)/'FATL'/
      DATA (INAME(56,J),J=1,4)/'SAUN','BIRN','    ','    '/
      DATA INSHAP(56)/1/
      DATA INLONG(56)/'FATIGUE LIFE'/
C     GENERALIZED PARETO
      DATA INCASE(57)/'GPAR'/
      DATA (INAME(57,J),J=1,4)/'GENE','PARE','    ','    '/
      DATA INSHAP(57)/1/
      DATA INLONG(57)/'GENERALIZED PARETO'/
      DATA INCASE(58)/'GPAR'/
      DATA (INAME(58,J),J=1,4)/'GEP ','    ','    ','    '/
      DATA INSHAP(58)/1/
      DATA INLONG(58)/'GENERALIZED PARETO'/
      DATA INCASE(59)/'GPAR'/
      DATA (INAME(59,J),J=1,4)/'GP  ','    ','    ','    '/
      DATA INSHAP(59)/1/
      DATA INLONG(59)/'GENERALIZED PARETO'/
C     DISCRETE UNIFORM
      DATA INCASE(60)/'DUNI'/
      DATA (INAME(60,J),J=1,4)/'DISC','UNIF','    ','    '/
      DATA INSHAP(60)/1/
      DATA INLONG(60)/'DISCRETE UNIFORM'/
C     NON-CENTRAL T
      DATA INCASE(61)/'NCT'/
      DATA (INAME(61,J),J=1,4)/'NONC','T   ','    ','    '/
      DATA INSHAP(61)/2/
      DATA INLONG(61)/'NON-CENTRAL T'/
      DATA INCASE(62)/'NCT'/
      DATA (INAME(62,J),J=1,4)/'NON-','T   ','    ','    '/
      DATA INSHAP(62)/2/
      DATA INLONG(62)/'NON-CENTRAL T'/
      DATA INCASE(63)/'NCT'/
      DATA (INAME(63,J),J=1,4)/'NON ','CENT','T   ','    '/
      DATA INSHAP(63)/2/
      DATA INLONG(63)/'NON-CENTRAL T'/
C     NON-CENTRAL F
      DATA INCASE(64)/'NCF'/
      DATA (INAME(64,J),J=1,4)/'NONC','F   ','    ','    '/
      DATA INSHAP(64)/3/
      DATA INLONG(64)/'NON-CENTRAL F'/
      DATA INCASE(65)/'NCF'/
      DATA (INAME(65,J),J=1,4)/'NON-','F   ','    ','    '/
      DATA INSHAP(65)/3/
      DATA INLONG(65)/'NON-CENTRAL F'/
      DATA INCASE(66)/'NCF'/
      DATA (INAME(66,J),J=1,4)/'NON ','CENT','F   ','    '/
      DATA INSHAP(66)/3/
      DATA INLONG(66)/'NON-CENTRAL F'/
C
      DATA INCASE(67)/'NCBE'/
      DATA (INAME(67,J),J=1,4)/'NONC','BETA','    ','    '/
      DATA INSHAP(67)/3/
      DATA INLONG(67)/'NON-CENTRAL BETA'/
      DATA INCASE(68)/'NCBE'/
      DATA (INAME(68,J),J=1,4)/'NON-','BETA','    ','    '/
      DATA INSHAP(68)/3/
      DATA INLONG(68)/'NON-CENTRAL BETA'/
      DATA INCASE(69)/'NCBE'/
      DATA (INAME(69,J),J=1,4)/'NON ','CENT','BETA','    '/
      DATA INSHAP(69)/3/
      DATA INLONG(69)/'NON-CENTRAL BETA'/
C     NON-CENTRAL CHI-SQUARE
      DATA INCASE(70)/'NCCS'/
      DATA (INAME(70,J),J=1,4)/'NON ','CENT','CHIS','    '/
      DATA INSHAP(70)/2/
      DATA INLONG(70)/'NON-CENTRAL CHI-SQUARE'/
      DATA INCASE(71)/'NCCS'/
      DATA (INAME(71,J),J=1,4)/'NON ','CENT','CHI ','SQUA'/
      DATA INSHAP(71)/2/
      DATA INLONG(71)/'NON-CENTRAL CHI-SQUARE'/
      DATA INCASE(72)/'NCCS'/
      DATA (INAME(72,J),J=1,4)/'NONC','CHI ','SQUA','    '/
      DATA INSHAP(72)/2/
      DATA INLONG(72)/'NON-CENTRAL CHI-SQUARE'/
      DATA INCASE(73)/'NCCS'/
      DATA (INAME(73,J),J=1,4)/'NON-','CHI ','SQUA','    '/
      DATA INSHAP(73)/2/
      DATA INLONG(73)/'NON-CENTRAL CHI-SQUARE'/
      DATA INCASE(74)/'NCCS'/
      DATA (INAME(74,J),J=1,4)/'NONC','CHI-','    ','    '/
      DATA INSHAP(74)/2/
      DATA INLONG(74)/'NON-CENTRAL CHI-SQUARE'/
      DATA INCASE(75)/'NCCS'/
      DATA (INAME(75,J),J=1,4)/'NON-','CHI-','    ','    '/
      DATA INSHAP(75)/2/
      DATA INLONG(75)/'NON-CENTRAL CHI-SQUARE'/
      DATA INCASE(76)/'NCCS'/
      DATA (INAME(76,J),J=1,4)/'NONC','CHIS','    ','    '/
      DATA INSHAP(76)/2/
      DATA INLONG(76)/'NON-CENTRAL CHI-SQUARE'/
      DATA INCASE(77)/'NCCS'/
      DATA (INAME(77,J),J=1,4)/'NON-','CHIS','CHIS','    '/
      DATA INSHAP(77)/2/
      DATA INLONG(77)/'NON-CENTRAL CHI-SQUARE'/
C     DOUBLY NON-CENTRAL F
      DATA INCASE(78)/'DNCF'/
      DATA (INAME(78,J),J=1,4)/'DOUB','NONC','F   ','    '/
      DATA INSHAP(78)/4/
      DATA INLONG(78)/'DOUBLY NON-CENTRAL F'/
      DATA INCASE(79)/'DNCF'/
      DATA (INAME(79,J),J=1,4)/'DOUB','NON-','F   ','    '/
      DATA INSHAP(79)/4/
      DATA INLONG(79)/'DOUBLY NON-CENTRAL F'/
C     DOUBLY NON-CENTRAL T
      DATA INCASE(80)/'DNCT'/
      DATA (INAME(80,J),J=1,4)/'DOUB','NONC','T   ','    '/
      DATA INSHAP(80)/3/
      DATA INLONG(80)/'DOUBLY NON-CENTRAL T'/
      DATA INCASE(81)/'DNCT'/
      DATA (INAME(81,J),J=1,4)/'DOUB','NON ','CENT','T   '/
      DATA INSHAP(81)/3/
      DATA INLONG(81)/'DOUBLY NON-CENTRAL T'/
C     HYPERBOLIC SECANT
      DATA INCASE(82)/'HSEC'/
      DATA (INAME(82,J),J=1,4)/'HYPE','SECA','    ','    '/
      DATA INSHAP(82)/0/
      DATA INLONG(82)/'HYPERBOLIC SECANT'/
C     HYPERGEOMETRIC
      DATA INCASE(83)/'HYPG'/
      DATA (INAME(83,J),J=1,4)/'HYPE','GEO ','    ','    '/
      DATA INSHAP(83)/3/
      DATA INLONG(83)/'HYPERGEOMETRIC'/
C     VON MISES
      DATA INCASE(84)/'VONM'/
      DATA (INAME(84,J),J=1,4)/'VON ','MISE','    ','    '/
      DATA INSHAP(84)/1/
      DATA INLONG(84)/'VON MISES'/
      DATA INCASE(85)/'VONM'/
      DATA (INAME(85,J),J=1,4)/'VONM','    ','    ','    '/
      DATA INSHAP(85)/1/
      DATA INLONG(85)/'VON MISES'/
      DATA INCASE(86)/'VONM'/
      DATA (INAME(86,J),J=1,4)/'VON-','    ','    ','    '/
      DATA INSHAP(86)/1/
      DATA INLONG(86)/'VON MISES'/
C     POWER NORMAL
      DATA INCASE(87)/'POWN'/
      DATA (INAME(87,J),J=1,4)/'POWE','NORM','    ','    '/
      DATA INSHAP(87)/1/
      DATA INLONG(87)/'POWER NORMAL'/
C     POWER LOGNORMAL
      DATA INCASE(88)/'PLGN'/
      DATA (INAME(88,J),J=1,4)/'POWE','LOGN','    ','    '/
      DATA INSHAP(88)/2/
      DATA INLONG(88)/'POWER LOGNORMAL'/
      DATA INCASE(89)/'PLGN'/
      DATA (INAME(89,J),J=1,4)/'POWE','LGNO','    ','    '/
      DATA INSHAP(89)/2/
      DATA INLONG(89)/'POWER LOGNORMAL'/
      DATA INCASE(90)/'PLGN'/
      DATA (INAME(90,J),J=1,4)/'POWE','LOG-','    ','    '/
      DATA INSHAP(90)/2/
      DATA INLONG(90)/'POWER LOGNORMAL'/
C     COSINE
      DATA INCASE(91)/'COSI'/
      DATA (INAME(91,J),J=1,4)/'COSI','    ','    ','    '/
      DATA INSHAP(91)/0/
      DATA INLONG(91)/'COSINE'/
C     ALPHA
      DATA INCASE(92)/'ALPH'/
      DATA (INAME(92,J),J=1,4)/'ALPH','    ','    ','    '/
      DATA INSHAP(92)/1/
      DATA INLONG(92)/'ALPHA'/
C     POWER EXPONENTIAL
      DATA INCASE(93)/'PEXP'/
      DATA (INAME(93,J),J=1,4)/'POWE','EXPO','    ','    '/
      DATA INSHAP(93)/1/
      DATA INLONG(93)/'POWER EXPONENTIAL'/
C     POWER
      DATA INCASE(94)/'POWF'/
      DATA (INAME(94,J),J=1,4)/'POWE','FUNC','    ','    '/
      DATA INSHAP(94)/1/
      DATA INLONG(94)/'POWER FUNCTION'/
C     CHI
      DATA INCASE(95)/'CHI '/
      DATA (INAME(95,J),J=1,4)/'CHI ','    ','    ','    '/
      DATA INSHAP(95)/1/
      DATA INLONG(95)/'CHI'/
C     LOGARITHMIC SERIES
      DATA INCASE(96)/'LOGS'/
      DATA (INAME(96,J),J=1,4)/'LOGA','SERI','    ','    '/
      DATA INSHAP(96)/1/
      DATA INLONG(96)/'LOGARITHMIC SERIES'/
C     LOG LOGISTIC
      DATA INCASE(97)/'LOGL'/
      DATA (INAME(97,J),J=1,4)/'LOG ','LOGI','    ','    '/
      DATA INSHAP(97)/1/
      DATA INLONG(97)/'LOG-LOGISTIC'/
      DATA INCASE(98)/'LOGL'/
      DATA (INAME(98,J),J=1,4)/'LOG-','LOGI','    ','    '/
      DATA INSHAP(98)/1/
      DATA INLONG(98)/'LOG-LOGISTIC'/
      DATA INCASE(99)/'LOGL'/
      DATA (INAME(99,J),J=1,4)/'LOGL','    ','    ','    '/
      DATA INSHAP(99)/1/
      DATA INLONG(99)/'LOG-LOGISTIC'/
C     GENERALIZED GAMMA
      DATA INCASE(100)/'GGAM'/
      DATA (INAME(100,J),J=1,4)/'GENE','GAMM','    ','    '/
      DATA INSHAP(100)/2/
      DATA INLONG(100)/'GENERALIZED GAMMA'/
C     INVERTED GAMMA
      DATA INCASE(101)/'IGAM'/
      DATA (INAME(101,J),J=1,4)/'INVE','GAMM','    ','    '/
      DATA INSHAP(101)/1/
      DATA INLONG(101)/'INVERSE GAMMA'/
C     WARING
      DATA INCASE(102)/'WARI'/
      DATA (INAME(102,J),J=1,4)/'WARI','    ','    ','    '/
      DATA INSHAP(102)/2/
      DATA INLONG(102)/'WARING'/
C     YULE
      DATA INCASE(103)/'YULE'/
      DATA (INAME(103,J),J=1,4)/'YULE','    ','    ','    '/
      DATA INSHAP(103)/1/
      DATA INLONG(103)/'YULE'/
C     ANGLIT
      DATA INCASE(104)/'ANGL'/
      DATA (INAME(104,J),J=1,4)/'ANGL','    ','    ','    '/
      DATA INSHAP(104)/0/
      DATA INLONG(104)/'ANGLIT'/
C     ARCSINE
      DATA INCASE(105)/'ARSI'/
      DATA (INAME(105,J),J=1,4)/'ARCS','    ','    ','    '/
      DATA INSHAP(105)/0/
      DATA INLONG(105)/'ARCSINE'/
C     FOLDED NORMAL
      DATA INCASE(106)/'FNOR'/
      DATA (INAME(106,J),J=1,4)/'FOLD','NORM','    ','    '/
      DATA INSHAP(106)/2/
      DATA INLONG(106)/'FOLDED NORMAL'/
C     TRUNCATED NORMAL
      DATA INCASE(107)/'TNOR'/
      DATA (INAME(107,J),J=1,4)/'TRUN','NORM','    ','    '/
      DATA INSHAP(107)/4/
      DATA INLONG(107)/'TRUNCATED NORMAL'/
C     LOG GAMMA
      DATA INCASE(108)/'LGAM'/
      DATA (INAME(108,J),J=1,4)/'LOG ','GAMM','    ','    '/
      DATA INSHAP(108)/1/
      DATA INLONG(108)/'LOG-GAMMA'/
C     HYPERGEOMETRIC
      DATA INCASE(109)/'HYPG'/
      DATA (INAME(109,J),J=1,4)/'HYPE','    ','    ','    '/
      DATA INSHAP(109)/3/
      DATA INLONG(109)/'HYPERGEOMETRIC'/
C     GOMPERTZ MAKEHAM
      DATA INCASE(110)/'GOMM'/
      DATA (INAME(110,J),J=1,4)/'GOMP','MAKE','    ','    '/
      DATA INSHAP(110)/2/
      DATA INLONG(110)/'GOMPERTZ MAKEHAM'/
C     HALF CAUCHY
      DATA INCASE(111)/'HCAU'/
      DATA (INAME(111,J),J=1,4)/'HALF','CAUC','    ','    '/
      DATA INSHAP(111)/0/
      DATA INLONG(111)/'HALF-CAUCHY'/
C     GENERALIZED EXTREME VALUE
      DATA INCASE(112)/'GEV'/
      DATA (INAME(112,J),J=1,4)/'GENE','EXTR','VALU','    '/
      DATA INSHAP(112)/1/
      DATA INLONG(112)/'GENERALIZED EXTREME VALUE'/
      DATA INCASE(113)/'GEV'/
      DATA (INAME(113,J),J=1,4)/'GEV ','    ','    ','    '/
      DATA INSHAP(113)/1/
      DATA INLONG(113)/'GENERALIZED EXTREME VALUE'/
C     HALF-NORMAL
      DATA INCASE(114)/'HLOG'/
      DATA (INAME(114,J),J=1,4)/'HALF','LOGI','    ','    '/
      DATA INSHAP(114)/0/
      DATA INLONG(114)/'HALF-LOGISTIC'/
C
      DATA INCASE(115)/'PAR2'/
      DATA (INAME(115,J),J=1,4)/'PARE','SECO','KIND','    '/
      DATA INSHAP(115)/1/
      DATA INLONG(115)/'PARETO SECOND KIND'/
      DATA INCASE(116)/'PAR2'/
      DATA (INAME(116,J),J=1,4)/'PARE','TYPE','2   ','    '/
      DATA INSHAP(116)/1/
      DATA INLONG(116)/'PARETO SECOND KIND'/
      DATA INCASE(117)/'PAR2'/
      DATA (INAME(117,J),J=1,4)/'PARE','TYPE','II  ','    '/
      DATA INSHAP(117)/1/
      DATA INLONG(117)/'PARETO SECOND KIND'/
C     DOUBLE WEIBULL
      DATA INCASE(118)/'DWEI'/
      DATA (INAME(118,J),J=1,4)/'DOUB','WEIB','    ','    '/
      DATA INSHAP(118)/1/
      DATA INLONG(118)/'DOUBLE WEIBULL'/
C     EXPONENTIATED WEIBULL
      DATA INCASE(119)/'EWEI'/
      DATA (INAME(119,J),J=1,4)/'EXPO','WEIB','    ','    '/
      DATA INSHAP(119)/2/
      DATA INLONG(119)/'EXPONENTIATED WEIBULL'/
C     TRUNCATED EXPONENTIAL
      DATA INCASE(120)/'TEXP'/
      DATA (INAME(120,J),J=1,4)/'TRUN','EXPO','    ','    '/
      DATA INSHAP(120)/3/
      DATA INLONG(120)/'TRUNCATED EXPONENTIAL'/
C     WRAPPED CAUCHY
      DATA INCASE(121)/'WCAU'/
      DATA (INAME(121,J),J=1,4)/'WRAP','CAUC','    ','    '/
      DATA INSHAP(121)/1/
      DATA INLONG(121)/'WRAPPED CAUCHY'/
C     WAKEBY
      DATA INCASE(122)/'WAKE'/
      DATA (INAME(122,J),J=1,4)/'WAKE','    ','    ','    '/
      DATA INSHAP(122)/3/
      DATA INLONG(122)/'WAKEBY'/
C     EXPONENTIAL
      DATA INCASE(123)/'EXPO'/
      DATA (INAME(123,J),J=1,4)/'EXPO','    ','    ','    '/
      DATA INSHAP(123)/0/
      DATA INLONG(123)/'EXPONENTIAL'/
C     DOUBLE GAMMA
      DATA INCASE(124)/'DGAM'/
      DATA (INAME(124,J),J=1,4)/'DOUB','GAMM','    ','    '/
      DATA INSHAP(124)/1/
      DATA INLONG(124)/'DOUBLE GAMMA'/
C     MIELKE BETA KAPPA
      DATA INCASE(125)/'MBKA'/
      DATA (INAME(125,J),J=1,4)/'BETA','KAPP','    ','    '/
      DATA INSHAP(125)/2/
      DATA INLONG(125)/'MIELKE BETA KAPPA'/
      DATA INCASE(126)/'MBKA'/
      DATA (INAME(126,J),J=1,4)/'MIEL','BETA','KAPP','    '/
      DATA INSHAP(126)/2/
      DATA INLONG(126)/'MIELKE BETA KAPPA'/
C     FOLDED CAUCHY
      DATA INCASE(127)/'FCAU'/
      DATA (INAME(127,J),J=1,4)/'FOLD','CAUC','    ','    '/
      DATA INSHAP(127)/2/
      DATA INLONG(127)/'FOLDED CAUCHY'/
C     BETA BINOMIAL
      DATA INCASE(128)/'BBIN'/
      DATA (INAME(128,J),J=1,4)/'BETA','BINO','    ','    '/
      DATA INSHAP(128)/3/
      DATA INLONG(128)/'BETA BINOMIAL'/
C     BRADFORD
      DATA INCASE(129)/'BRAD'/
      DATA (INAME(129,J),J=1,4)/'BRAD','    ','    ','    '/
      DATA INSHAP(129)/1/
      DATA INLONG(129)/'BRADFORD'/
C     GENERALIZED EXPONENTIAL
      DATA INCASE(130)/'GEXP'/
      DATA (INAME(130,J),J=1,4)/'GENE','EXPO','    ','    '/
      DATA INSHAP(130)/3/
      DATA INLONG(130)/'GENERALIZED EXPONENTIAL'/
C     RECIPROCAL
      DATA INCASE(131)/'RECI'/
      DATA (INAME(131,J),J=1,4)/'RECI','    ','    ','    '/
      DATA INSHAP(131)/1/
      DATA INLONG(131)/'RECIPROCAL'/
C     INVERTED WEIBULL
      DATA INCASE(132)/'IWEI'/
      DATA (INAME(132,J),J=1,4)/'INVE','WEIB','    ','    '/
      DATA INSHAP(132)/1/
      DATA INLONG(132)/'INVERTED WEIBULL'/
C     LOG DOUBLE EXPONENTIAL
      DATA INCASE(133)/'LDEX'/
      DATA (INAME(133,J),J=1,4)/'LOG ','DOUB','EXPO','    '/
      DATA INSHAP(133)/1/
      DATA INLONG(133)/'LOG DOUBLE EXPONENTIAL'/
C     GENERALIZED TUKEY-LAMBDA
      DATA INCASE(134)/'GTLA'/
      DATA (INAME(134,J),J=1,4)/'GENE','TUKE','LAMB','    '/
      DATA INSHAP(134)/2/
      DATA INLONG(134)/'GENERALZIED TUKEY LAMBDA'/
C     JOHNSON SB
      DATA INCASE(135)/'JOSB'/
      DATA (INAME(135,J),J=1,4)/'JOHN','SB  ','    ','    '/
      DATA INSHAP(135)/2/
      DATA INLONG(135)/'JOHNSON SB'/
C     JOHNSON SU
      DATA INCASE(136)/'JOSU'/
      DATA (INAME(136,J),J=1,4)/'JOHN','SU  ','    ','    '/
      DATA INSHAP(136)/2/
      DATA INLONG(136)/'JOHNSON SU'/
C     GEOMETRIC
      DATA INCASE(137)/'GEOM'/
      DATA (INAME(137,J),J=1,4)/'GEOM','    ','    ','    '/
      DATA INSHAP(137)/1/
      DATA INLONG(137)/'GEOMETRIC'/
C     TWO-SIDED POWER
      DATA INCASE(138)/'TSPO'/
      DATA (INAME(138,J),J=1,4)/'TWO ','SIDE','POWE','    '/
      DATA INSHAP(138)/2/
      DATA INLONG(138)/'TWO-SIDED POWER'/
C     BI-WEIBULL
      DATA INCASE(139)/'BWEI'/
      DATA (INAME(139,J),J=1,4)/'BI  ','WEIB','    ','    '/
      DATA INSHAP(139)/5/
      DATA INLONG(139)/'BIWEIBULL'/
      DATA INCASE(140)/'BWEI'/
      DATA (INAME(140,J),J=1,4)/'BIWE','    ','    ','    '/
      DATA INSHAP(140)/5/
      DATA INLONG(140)/'BIWEIBULL'/
C     LANDAU
      DATA INCASE(141)/'LAND'/
      DATA (INAME(141,J),J=1,4)/'LAND','    ','    ','    '/
      DATA INSHAP(141)/0/
      DATA INLONG(141)/'LANDAU'/
C     ERROR (SUBOTTIN)
      DATA INCASE(142)/'ERRO'/
      DATA (INAME(142,J),J=1,4)/'ERRO','    ','    ','    '/
      DATA INSHAP(142)/1/
      DATA INLONG(142)/'ERROR'/
      DATA INCASE(143)/'ERRO'/
      DATA (INAME(143,J),J=1,4)/'SUBB','    ','    ','    '/
      DATA INSHAP(143)/1/
      DATA INLONG(143)/'ERROR'/
C     POWER LAW
      DATA INCASE(144)/'POWL'/
      DATA (INAME(144,J),J=1,4)/'POWE','LAW ','    ','    '/
      DATA INSHAP(144)/2/
      DATA INLONG(144)/'POWER LAW'/
C     TRAPEZOID
      DATA INCASE(145)/'TRAP'/
      DATA (INAME(145,J),J=1,4)/'TRAP','    ','    ','    '/
      DATA INSHAP(145)/4/
      DATA INLONG(145)/'TRAPEZOID'/
C     GENERALIZED TRAPEZOID
      DATA INCASE(146)/'GTRA'/
      DATA (INAME(146,J),J=1,4)/'GENE','TRAP','    ','    '/
      DATA INSHAP(146)/7/
      DATA INLONG(146)/'GENERALIZED TRAPEZOID'/
C     FOLDED T
      DATA INCASE(147)/'FT'/
      DATA (INAME(147,J),J=1,4)/'FOLD','T   ','    ','    '/
      DATA INSHAP(147)/3/
      DATA INLONG(147)/'FOLDED T'/
C     SKEW NORMAL
      DATA INCASE(148)/'SNOR'/
      DATA (INAME(148,J),J=1,4)/'SKEW','NORM','    ','    '/
      DATA INSHAP(148)/1/
      DATA INLONG(148)/'SKEWED NORMAL'/
C     SKEW T
      DATA INCASE(149)/'TSKE'/
      DATA (INAME(149,J),J=1,4)/'SKEW','T   ','    ','    '/
      DATA INSHAP(149)/2/
      DATA INLONG(149)/'SKEWED T'/
C     SLASH
      DATA INCASE(150)/'SLAS'/
      DATA (INAME(150,J),J=1,4)/'SLAS','    ','    ','    '/
      DATA INSHAP(150)/0/
      DATA INLONG(150)/'SLASH'/
C     INVERTED BETA
      DATA INCASE(151)/'IBET'/
      DATA (INAME(151,J),J=1,4)/'INVE','BETA','    ','    '/
      DATA INSHAP(151)/2/
      DATA INLONG(151)/'INVERTED BETA'/
C     GOMPERTZ
      DATA INCASE(152)/'GOMP'/
      DATA (INAME(152,J),J=1,4)/'GOMP','    ','    ','    '/
      DATA INSHAP(152)/2/
      DATA INLONG(152)/'GOMPERTZ'/
C     GENERALIZED INVERSE GAUSSIAN
      DATA INCASE(153)/'GIGA'/
      DATA (INAME(153,J),J=1,4)/'GENE','INVE','GAUS','    '/
      DATA INSHAP(153)/2/
      DATA INLONG(153)/'GENERALIZED INVERSE GAUSSIAN'/
C     GENERALIZED F
      DATA INCASE(154)/'GFPP'/
      DATA (INAME(154,J),J=1,4)/'GENE','F   ','    ','    '/
      DATA INSHAP(154)/3/
      DATA INLONG(154)/'GENERALIZED F'/
C     G AND H
      DATA INCASE(155)/'GHPP'/
      DATA (INAME(155,J),J=1,4)/'G-H ','    ','    ','    '/
      DATA INSHAP(155)/2/
      DATA INLONG(155)/'G AND H'/
      DATA INCASE(156)/'GHPP'/
      DATA (INAME(156,J),J=1,4)/'GH  ','    ','    ','    '/
      DATA INSHAP(156)/2/
      DATA INLONG(156)/'G AND H'/
      DATA INCASE(157)/'GHPP'/
      DATA (INAME(157,J),J=1,4)/'G   ','H   ','    ','    '/
      DATA INSHAP(157)/2/
      DATA INLONG(157)/'G AND H'/
      DATA INCASE(158)/'GHPP'/
      DATA (INAME(158,J),J=1,4)/'G   ','AND ','H   ','    '/
      DATA INSHAP(158)/2/
      DATA INLONG(158)/'G AND H'/
C     LOG SKEWED NORMAL
      DATA INCASE(159)/'LSNO'/
      DATA (INAME(159,J),J=1,4)/'LOG ','SKEW','NORM','    '/
      DATA INSHAP(159)/2/
      DATA INLONG(159)/'LOG SKEWED NORMAL'/
C     LOG SKEWED T
      DATA INCASE(160)/'LSKT'/
      DATA (INAME(160,J),J=1,4)/'LOG ','SKEW','T   ','    '/
      DATA INSHAP(160)/3/
      DATA INLONG(160)/'LOG SKEWED T'/
C     GENERALIZED HALF-LOGISTIC
      DATA INCASE(161)/'GHLO'/
      DATA (INAME(161,J),J=1,4)/'GENE','HALF','LOGI','    '/
      DATA INSHAP(161)/1/
      DATA INLONG(161)/'GENERALIZED HALF-LOGISITC'/
C     ARCSINE
      DATA INCASE(162)/'ARSI'/
      DATA (INAME(162,J),J=1,4)/'ARCS','    ','    ','    '/
      DATA INSHAP(162)/0/
      DATA INLONG(162)/'ARCSINE'/
C     POLY AEPPLI
      DATA INCASE(163)/'AEPP'/
      DATA (INAME(163,J),J=1,4)/'POLY','AEPP','    ','    '/
      DATA INSHAP(163)/2/
      DATA INLONG(163)/'POLYA AEPPLI'/
C     HERMITE
      DATA INCASE(164)/'HERM'/
      DATA (INAME(164,J),J=1,4)/'HERM','    ','    ','    '/
      DATA INSHAP(164)/2/
      DATA INLONG(164)/'HERMITE'/
C     SKEW DOUBLE EXPONENTIAL
      DATA INCASE(165)/'SDEX'/
      DATA (INAME(165,J),J=1,4)/'SKEW','DOUB','EXPO','    '/
      DATA INSHAP(165)/1/
      DATA INLONG(165)/'SKEW DOUBLE EXPONENTIAL'/
      DATA INCASE(166)/'SDEX'/
      DATA (INAME(166,J),J=1,4)/'SKEW','LAPL','    ','    '/
      DATA INSHAP(166)/1/
      DATA INLONG(166)/'SKEW DOUBLE EXPONENTIAL'/
C     ASYMMETRIC DOUBLE EXPONENTIAL
      DATA INCASE(167)/'ADEX'/
      DATA (INAME(167,J),J=1,4)/'ASYM','DOUB','EXPO','    '/
      DATA INSHAP(167)/1/
      DATA INLONG(167)/'ASYMMETRIC DOUBLE EXPONENTIAL'/
      DATA INCASE(168)/'ADEX'/
      DATA (INAME(168,J),J=1,4)/'ASYM','LAPL','    ','    '/
      DATA INSHAP(168)/1/
      DATA INLONG(168)/'ASYMMETRIC DOUBLE EXPONENTIAL'/
C     MAXWELL
      DATA INCASE(169)/'MAXW'/
      DATA (INAME(169,J),J=1,4)/'MAXW','    ','    ','    '/
      DATA INSHAP(169)/0/
      DATA INLONG(169)/'MAXWELL'/
C     RAYLEIGH
      DATA INCASE(170)/'RAYL'/
      DATA (INAME(170,J),J=1,4)/'RAYL','    ','    ','    '/
      DATA INSHAP(170)/0/
      DATA INLONG(170)/'RAYLEIGH'/
C     GENERALIZED ASYMETRIC DOUBLE EXPONENTIAL
      DATA INCASE(171)/'GALP'/
      DATA (INAME(171,J),J=1,4)/'GENE','ASYM','DOUB','EXPO'/
      DATA INSHAP(171)/2/
      DATA INLONG(171)/'GENERALIZED ASYMMETRIC LAPLACE'/
      DATA INCASE(172)/'GALP'/
      DATA (INAME(172,J),J=1,4)/'GENE','ASYM','LAPL','    '/
      DATA INSHAP(172)/2/
      DATA INLONG(172)/'GENERALIZED ASYMMETRIC LAPLACE'/
C     MCLEISH
      DATA (INAME(173,J),J=1,4)/'MCLE','    ','    ','    '/
      DATA INCASE(173)/'MCLE'/
      DATA INSHAP(173)/1/
      DATA INLONG(173)/'MCLEISH'/
C     BESSEL I FUNCTION
      DATA (INAME(174,J),J=1,4)/'BESS','I   ','FUNC','    '/
      DATA INCASE(174)/'BEIP'/
      DATA INSHAP(174)/3/
      DATA INLONG(174)/'BESSEL I FUNCTION'/
      DATA (INAME(175,J),J=1,4)/'BESS','I   ','    ','    '/
      DATA INCASE(175)/'BEIP'/
      DATA INSHAP(175)/3/
      DATA INLONG(175)/'BESSEL I FUNCTION'/
C     BESSEL K FUNCTION
      DATA (INAME(176,J),J=1,4)/'BESS','K   ','FUNC','    '/
      DATA INCASE(176)/'BEKP'/
      DATA INSHAP(176)/3/
      DATA INLONG(176)/'BESSEL K FUNCTION'/
      DATA (INAME(177,J),J=1,4)/'BESS','K   ','    ','    '/
      DATA INCASE(177)/'BEKP'/
      DATA INSHAP(177)/3/
      DATA INLONG(177)/'BESSEL K FUNCTION'/
C     GENERALIZED MCLEISH
      DATA (INAME(178,J),J=1,4)/'GENE','MCLE','    ','    '/
      DATA INCASE(178)/'GMCL'/
      DATA INSHAP(178)/2/
      DATA INLONG(178)/'GENERALIZED MCLEISH'/
C     LOG DOUBLE EXPONENTIAL (LOG LAPLACE)
      DATA INCASE(179)/'LLAP'/
      DATA (INAME(179,J),J=1,4)/'LOG ','LAPL','    ','    '/
      DATA INSHAP(179)/1/
      DATA INLONG(179)/'LOG LAPLACE'/
C     GENERALIZED LOGISTIC TYPE 5
      DATA INCASE(180)/'G5LO'/
      DATA (INAME(180,J),J=1,4)/'GENE','LOGI','TYPE','5   '/
      DATA INSHAP(180)/1/
      DATA INLONG(180)/'GENERALIZED LOGISTIC TYPE 5'/
      DATA INCASE(181)/'G5LO'/
      DATA (INAME(181,J),J=1,4)/'GENE','LOGI','TYPE','V   '/
      DATA INSHAP(181)/1/
      DATA INLONG(181)/'GENERALIZED LOGISTIC TYPE 5'/
      DATA INCASE(182)/'G5LO'/
      DATA (INAME(182,J),J=1,4)/'GENE','LOGI','HOSK','    '/
      DATA INSHAP(182)/1/
      DATA INLONG(182)/'GENERALIZED LOGISTIC TYPE 5'/
      DATA INCASE(183)/'G5LO'/
      DATA (INAME(183,J),J=1,4)/'HOSK','GENE','LOGI','    '/
      DATA INSHAP(183)/1/
      DATA INLONG(183)/'GENERALIZED LOGISTIC TYPE 5'/
      DATA INCASE(184)/'G5LO'/
      DATA (INAME(184,J),J=1,4)/'TYPE','5   ','GENE','LOGI'/
      DATA INSHAP(184)/1/
      DATA INLONG(184)/'GENERALIZED LOGISTIC TYPE 5'/
      DATA INCASE(185)/'G5LO'/
      DATA (INAME(185,J),J=1,4)/'TYPE','V   ','GENE','LOGI'/
      DATA INSHAP(185)/1/
      DATA INLONG(185)/'GENERALIZED LOGISTIC TYPE 5'/
C     GENERALIZED LOGISTIC TYPE 2
      DATA INCASE(186)/'G2LO'/
      DATA (INAME(186,J),J=1,4)/'GENE','LOGI','TYPE','2   '/
      DATA INSHAP(186)/1/
      DATA INLONG(186)/'GENERALIZED LOGISTIC TYPE 2'/
      DATA INCASE(187)/'G2LO'/
      DATA (INAME(187,J),J=1,4)/'GENE','LOGI','TYPE','II  '/
      DATA INSHAP(187)/1/
      DATA INLONG(187)/'GENERALIZED LOGISTIC TYPE 2'/
      DATA INCASE(188)/'G2LO'/
      DATA (INAME(188,J),J=1,4)/'TYPE','2   ','GENE','LOGI'/
      DATA INSHAP(188)/1/
      DATA INLONG(188)/'GENERALIZED LOGISTIC TYPE 2'/
      DATA INCASE(189)/'G2LO'/
      DATA (INAME(189,J),J=1,4)/'TYPE','II  ','GENE','LOGI'/
      DATA INSHAP(189)/1/
      DATA INLONG(189)/'GENERALIZED LOGISTIC TYPE 2'/
C     GENERALIZED LOGISTIC TYPE 3
      DATA INCASE(190)/'G3LO'/
      DATA (INAME(190,J),J=1,4)/'GENE','LOGI','TYPE','3   '/
      DATA INSHAP(190)/1/
      DATA INLONG(190)/'GENERALIZED LOGISTIC TYPE 3'/
      DATA INCASE(191)/'G3LO'/
      DATA (INAME(191,J),J=1,4)/'GENE','LOGI','TYPE','III '/
      DATA INSHAP(191)/1/
      DATA INLONG(191)/'GENERALIZED LOGISTIC TYPE 3'/
      DATA INCASE(192)/'G3LO'/
      DATA (INAME(192,J),J=1,4)/'TYPE','3   ','GENE','LOGI'/
      DATA INSHAP(192)/1/
      DATA INLONG(192)/'GENERALIZED LOGISTIC TYPE 3'/
      DATA INCASE(193)/'G3LO'/
      DATA (INAME(193,J),J=1,4)/'TYPE','III ','GENE','LOGI'/
      DATA INSHAP(193)/1/
      DATA INLONG(193)/'GENERALIZED LOGISTIC TYPE 3'/
C     GENERALIZED LOGISTIC TYPE 4
      DATA INCASE(194)/'G4LO'/
      DATA (INAME(194,J),J=1,4)/'GENE','LOGI','TYPE','4   '/
      DATA INSHAP(194)/2/
      DATA INLONG(194)/'GENERALIZED LOGISTIC TYPE 3'/
      DATA INCASE(195)/'G4LO'/
      DATA (INAME(195,J),J=1,4)/'GENE','LOGI','TYPE','IV  '/
      DATA INSHAP(195)/2/
      DATA INLONG(195)/'GENERALIZED LOGISTIC TYPE 4'/
      DATA INCASE(196)/'G4LO'/
      DATA (INAME(196,J),J=1,4)/'TYPE','4   ','GENE','LOGI'/
      DATA INSHAP(196)/2/
      DATA INLONG(196)/'GENERALIZED LOGISTIC TYPE 4'/
      DATA INCASE(197)/'G4LO'/
      DATA (INAME(197,J),J=1,4)/'TYPE','IV  ','GENE','LOGI'/
      DATA INSHAP(197)/2/
      DATA INLONG(197)/'GENERALIZED LOGISTIC TYPE 4'/
C     GENERALIZED LOGISTIC
      DATA INCASE(198)/'GLOG'/
      DATA (INAME(198,J),J=1,4)/'GENE','LOGI','    ','    '/
      DATA INSHAP(198)/1/
      DATA INLONG(198)/'GENERALIZED LOGISTIC'/
C     GENERALIZED TUKEY LAMBDA
      DATA INCASE(199)/'GTLA'/
      DATA (INAME(199,J),J=1,4)/'GENE','LAMB','    ','    '/
      DATA INSHAP(199)/2/
      DATA INLONG(199)/'GENERALIZED TUKEY-LAMBDA'/
C     BETA GEOMETRIC
      DATA INCASE(200)/'BGEO'/
      DATA (INAME(200,J),J=1,4)/'BETA','GEOM','    ','    '/
      DATA INSHAP(200)/2/
      DATA INLONG(200)/'BETA GEOMETRIC'/
C     LOG LAPLACE (DOUBLE EXPONENTIAL)
      DATA INCASE(201)/'LLAP'/
      DATA (INAME(201,J),J=1,4)/'LOG ','DOUB','EXPO','    '/
      DATA INSHAP(201)/1/
      DATA INLONG(201)/'LOG LAPLACE'/
C     ASYMETRIC LOG DOUBLE EXPONENTIAL (LAPLACE)
      DATA INCASE(202)/'ALDE'/
      DATA (INAME(202,J),J=1,4)/'ASYM','LOG ','DOUB','EXPO'/
      DATA INSHAP(202)/2/
      DATA INLONG(202)/'ASYMMETRIC LOG DOUBLE EXPONENTIAL'/
      DATA INCASE(203)/'ALDE'/
      DATA (INAME(203,J),J=1,4)/'ASYM','LOG ','LAPL','    '/
      DATA INSHAP(203)/2/
      DATA INLONG(203)/'ASYMMETRIC LOG DOUBLE EXPONENTIAL'/
C     ZETA
      DATA INCASE(204)/'ZETA'/
      DATA (INAME(204,J),J=1,4)/'ZETA','    ','    ','    '/
      DATA INSHAP(204)/1/
      DATA INLONG(204)/'ZETA'/
C     ZIPF
      DATA INCASE(205)/'ZIPF'/
      DATA (INAME(205,J),J=1,4)/'ZIPF','    ','    ','    '/
      DATA INSHAP(205)/2/
      DATA INLONG(205)/'ZIPF'/
C     BETA NEGATIVE BINOMIAL
      DATA INCASE(206)/'BNBI'/
      DATA (INAME(206,J),J=1,4)/'BETA','NEGA','BINO','    '/
      DATA INSHAP(206)/3/
      DATA INLONG(206)/'BETA NEGATIVE BINOMIAL'/
C     GENERALIZED WARING
      DATA INCASE(207)/'GWAR'/
      DATA (INAME(207,J),J=1,4)/'GENE','WARI','    ','    '/
      DATA INSHAP(207)/3/
      DATA INLONG(207)/'GENERALIZED WARING'/
C     BOREL TANNER
      DATA INCASE(208)/'BTAN'/
      DATA (INAME(208,J),J=1,4)/'BORE','TANN','    ','    '/
      DATA INSHAP(208)/2/
      DATA INLONG(208)/'BOREL TANNER'/
C     LOG BETA
      DATA INCASE(209)/'LBET'/
      DATA (INAME(209,J),J=1,4)/'LOG ','BETA','    ','    '/
      DATA INSHAP(209)/4/
      DATA INLONG(209)/'LOG BETA'/
C     BETA
      DATA INCASE(210)/'BETA'/
      DATA (INAME(210,J),J=1,4)/'BETA','    ','    ','    '/
      DATA INSHAP(210)/4/
      DATA INLONG(210)/'BETA'/
C     LAGRANGE POISSON
      DATA INCASE(211)/'LPOI'/
      DATA (INAME(211,J),J=1,4)/'LAGR','POIS','    ','    '/
      DATA INSHAP(211)/2/
      DATA INLONG(211)/'LAGRANGE POISSON'/
C     CONSUL GENERALIZED POISSON
      DATA INCASE(212)/'GPOI'/
      DATA (INAME(212,J),J=1,4)/'CONS','GENE','POIS','    '/
      DATA INSHAP(212)/2/
      DATA INLONG(212)/'CONSUL GENERALIZED POISSON'/
C     LEADS IN COIN TOSSING
      DATA INCASE(213)/'LICT'/
      DATA (INAME(213,J),J=1,4)/'LEAD','IN  ','COIN','TOSS'/
      DATA INSHAP(213)/1/
      DATA INLONG(213)/'LEADS IN COIN TOSSING'/
      DATA INCASE(214)/'LICT'/
      DATA (INAME(214,J),J=1,4)/'DISC','ARCS','    ','    '/
      DATA INSHAP(214)/1/
      DATA INLONG(214)/'DISCRETE ARCSINE'/
C     MATCHING
      DATA INCASE(215)/'MATC'/
      DATA (INAME(215,J),J=1,4)/'MATC','    ','    ','    '/
      DATA INSHAP(215)/1/
      DATA INLONG(215)/'MATCHING'/
C     CLASSICAL OCCUPANCY
      DATA INCASE(216)/'OCCU'/
      DATA (INAME(216,J),J=1,4)/'CLAS','OCCU','    ','    '/
      DATA INSHAP(216)/2/
      DATA INLONG(216)/'CLASSICAL OCCUPANCY'/
C     POLYA
      DATA INCASE(217)/'POLY'/
      DATA (INAME(217,J),J=1,4)/'POLY','    ','    ','    '/
      DATA INSHAP(217)/4/
      DATA INLONG(217)/'POLYA'/
C     LOST GAMES
      DATA INCASE(218)/'LOST'/
      DATA (INAME(218,J),J=1,4)/'LOST','GAME','    ','    '/
      DATA INSHAP(218)/2/
      DATA INLONG(218)/'LOST GAMES'/
C     GENERALIZED LOGARITHMIC SERIES
      DATA INCASE(219)/'GLOS'/
      DATA (INAME(219,J),J=1,4)/'GENE','LOGA','SERI','    '/
      DATA INSHAP(219)/2/
      DATA INLONG(219)/'GENERALIZED LOGARITHMIC SERIES'/
C     GENERALIZED NEGATIVE BINOMIAL
      DATA INCASE(220)/'GNBI'/
      DATA (INAME(220,J),J=1,4)/'GENE','NEGA','BINO','    '/
      DATA INSHAP(220)/2/
      DATA INLONG(220)/'GENERALZIED NEGATIVE BINOMIAL'/
C     GEETA
      DATA INCASE(221)/'GEET'/
      DATA (INAME(221,J),J=1,4)/'GEET','    ','    ','    '/
      DATA INSHAP(221)/2/
      DATA INLONG(221)/'GEETA'/
C     QUASI BINOMIAL TYPE I
      DATA INCASE(222)/'QBIN'/
      DATA (INAME(222,J),J=1,4)/'QUAS','BINO','TYPE','I   '/
      DATA INSHAP(222)/3/
      DATA INLONG(222)/'QUASI-BINOMIAL TYPE 1'/
      DATA INCASE(223)/'QBIN'/
      DATA (INAME(223,J),J=1,4)/'QUAS','BINO','TYPE','1   '/
      DATA INSHAP(223)/3/
      DATA INLONG(223)/'QUASI-BINOMIAL TYPE 1'/
      DATA INCASE(224)/'QBIN'/
      DATA (INAME(224,J),J=1,4)/'QUAS','BINO','I   ','    '/
      DATA INSHAP(224)/3/
      DATA INLONG(224)/'QUASI-BINOMIAL TYPE 1'/
      DATA INCASE(225)/'QBIN'/
      DATA (INAME(225,J),J=1,4)/'QUAS','BINO','1   ','    '/
      DATA INSHAP(225)/3/
      DATA INLONG(225)/'QUASI-BINOMIAL TYPE 1'/
C     CONSUL
      DATA INCASE(226)/'CONS'/
      DATA (INAME(226,J),J=1,4)/'CONS','    ','    ','    '/
      DATA INSHAP(226)/2/
      DATA INLONG(226)/'CONSUL'/
C     LAGRANZE KATZ
      DATA INCASE(227)/'LKAT'/
      DATA (INAME(227,J),J=1,4)/'LAGR','KATZ','    ','    '/
      DATA INSHAP(227)/3/
      DATA INLONG(227)/'LAGRANGE KATZ'/
C     KATZ
      DATA INCASE(228)/'KATZ'/
      DATA (INAME(228,J),J=1,4)/'KATZ','    ','    ','    '/
      DATA INSHAP(228)/2/
      DATA INLONG(228)/'KATZ'/
C     DISCRETE WEIBULL
      DATA INCASE(229)/'DISW'/
      DATA (INAME(229,J),J=1,4)/'DISC','WEIB','    ','    '/
      DATA INSHAP(229)/2/
      DATA INLONG(229)/'DISCRETE WEIBULL'/
C     GENERALIZED LOST GAMES
      DATA INCASE(230)/'GLGP'/
      DATA (INAME(230,J),J=1,4)/'GENE','LOST','GAME','    '/
      DATA INSHAP(230)/3/
      DATA INLONG(230)/'GENERALIZED LOST GAMES'/
C     TRUNCATED GENERALIZED NEGATIVE BINOMIAL
      DATA INCASE(231)/'TGNB'/
      DATA (INAME(231,J),J=1,4)/'TRUN','GENE','NEGA','BINO'/
      DATA INSHAP(231)/4/
      DATA INLONG(231)/'TRUNCATED GENERALIZED NEGATIVE BINOMIAL'/
C     TOPP AND LEONE
      DATA INCASE(232)/'TOPL'/
      DATA (INAME(232,J),J=1,4)/'TOPP','LEON','    ','    '/
      DATA INSHAP(232)/1/
      DATA INLONG(232)/'TOPP AND LEONE'/
      DATA INCASE(233)/'TOPL'/
      DATA (INAME(233,J),J=1,4)/'TOPP','AND ','LEON','    '/
      DATA INSHAP(233)/1/
      DATA INLONG(233)/'TOPP AND LEONE'/
C     GENERALIZED TOPP AND LEONE
      DATA INCASE(234)/'GTOL'/
      DATA (INAME(234,J),J=1,4)/'GENE','TOPP','AND ','LEON'/
      DATA INSHAP(234)/2/
      DATA INLONG(234)/'GENERALIZED TOPP AND LEONE'/
      DATA INCASE(235)/'GTOL'/
      DATA (INAME(235,J),J=1,4)/'GENE','TOPP','LEON','    '/
      DATA INSHAP(235)/2/
      DATA INLONG(235)/'GENERALIZED TOPP AND LEONE'/
C     REFLECTED GENERALIZED TOPP AND LEONE
      DATA INCASE(236)/'RGTL'/
      DATA (INAME(236,J),J=1,4)/'REFL','GENE','TOPP','LEON'/
      DATA INSHAP(236)/2/
      DATA INLONG(236)/'REFLECTED GENERALIZED TOPP AND LEONE'/
C     SLOPE
      DATA INCASE(237)/'SLOP'/
      DATA (INAME(237,J),J=1,4)/'SLOP','    ','    ','    '/
      DATA INSHAP(237)/1/
      DATA INLONG(237)/'SLOPE'/
C     TWO-SIDED SLOPE
      DATA INCASE(238)/'TSSL'/
      DATA (INAME(238,J),J=1,4)/'TWO ','SIDE','SLOP','    '/
      DATA INSHAP(238)/2/
      DATA INLONG(238)/'TWO-SIDED SLOPE'/
C     OGIVE
      DATA INCASE(239)/'OGIV'/
      DATA (INAME(239,J),J=1,4)/'OGIV','    ','    ','    '/
      DATA INSHAP(239)/1/
      DATA INLONG(239)/'OGIVE'/
C     TWO-SIDED OGIVE
      DATA INCASE(240)/'TSOG'/
      DATA (INAME(240,J),J=1,4)/'TWO ','SIDE','OGIV','    '/
      DATA INSHAP(240)/2/
      DATA INLONG(240)/'TWO-SIDED OGIVE'/
C     BURR TYPE 1
      DATA INCASE(241)/'UNIF'/
      DATA (INAME(241,J),J=1,4)/'BURR','TYPE','1   ','    '/
      DATA INSHAP(241)/0/
      DATA INLONG(241)/'BURR TYPE 1'/
      DATA INCASE(242)/'UNIF'/
      DATA (INAME(242,J),J=1,4)/'BURR','TYPE','I   ','    '/
      DATA INSHAP(242)/0/
      DATA INLONG(242)/'BURR TYPE 1'/
C     BURR TYPE 2
      DATA INCASE(243)/'BUR2'/
      DATA (INAME(243,J),J=1,4)/'BURR','TYPE','2   ','    '/
      DATA INSHAP(243)/1/
      DATA INLONG(243)/'BURR TYPE 2'/
      DATA INCASE(244)/'BUR2'/
      DATA (INAME(244,J),J=1,4)/'BURR','TYPE','II  ','    '/
      DATA INSHAP(244)/1/
      DATA INLONG(244)/'BURR TYPE 2'/
C     BURR TYPE 3
      DATA INCASE(245)/'BUR3'/
      DATA (INAME(245,J),J=1,4)/'BURR','TYPE','3   ','    '/
      DATA INSHAP(245)/2/
      DATA INLONG(245)/'BURR TYPE 3'/
      DATA INCASE(246)/'BUR3'/
      DATA (INAME(246,J),J=1,4)/'BURR','TYPE','3   ','    '/
      DATA INSHAP(246)/2/
      DATA INLONG(246)/'BURR TYPE 3'/
C     BURR TYPE 4
      DATA INCASE(247)/'BUR4'/
      DATA (INAME(247,J),J=1,4)/'BURR','TYPE','4   ','    '/
      DATA INSHAP(247)/2/
      DATA INLONG(247)/'BURR TYPE 4'/
      DATA INCASE(248)/'BUR4'/
      DATA (INAME(248,J),J=1,4)/'BURR','TYPE','IV  ','    '/
      DATA INSHAP(248)/2/
      DATA INLONG(248)/'BURR TYPE 4'/
C     BURR TYPE 5
      DATA INCASE(249)/'BUR5'/
      DATA (INAME(249,J),J=1,4)/'BURR','TYPE','5   ','    '/
      DATA INSHAP(249)/2/
      DATA INLONG(249)/'BURR TYPE 5'/
      DATA INCASE(250)/'BUR5'/
      DATA (INAME(250,J),J=1,4)/'BURR','TYPE','V   ','    '/
      DATA INSHAP(250)/2/
      DATA INLONG(250)/'BURR TYPE 5'/
C     BURR TYPE 6
      DATA INCASE(251)/'BUR6'/
      DATA (INAME(251,J),J=1,4)/'BURR','TYPE','6   ','    '/
      DATA INSHAP(251)/2/
      DATA INLONG(251)/'BURR TYPE 6'/
      DATA INCASE(252)/'BUR6'/
      DATA (INAME(252,J),J=1,4)/'BURR','TYPE','VI  ','    '/
      DATA INSHAP(252)/2/
      DATA INLONG(252)/'BURR TYPE 6'/
C     BURR TYPE 7
      DATA INCASE(253)/'BUR7'/
      DATA (INAME(253,J),J=1,4)/'BURR','TYPE','7   ','    '/
      DATA INSHAP(253)/1/
      DATA INLONG(253)/'BURR TYPE 7'/
      DATA INCASE(254)/'BUR7'/
      DATA (INAME(254,J),J=1,4)/'BURR','TYPE','VII ','    '/
      DATA INSHAP(254)/1/
      DATA INLONG(254)/'BURR TYPE 7'/
C     BURR TYPE 8
      DATA INCASE(255)/'BUR8'/
      DATA (INAME(255,J),J=1,4)/'BURR','TYPE','8   ','    '/
      DATA INSHAP(255)/1/
      DATA INLONG(255)/'BURR TYPE 8'/
      DATA INCASE(256)/'BUR8'/
      DATA (INAME(256,J),J=1,4)/'BURR','TYPE','VIII','    '/
      DATA INSHAP(256)/1/
      DATA INLONG(256)/'BURR TYPE 8'/
C     BURR TYPE 9
      DATA INCASE(257)/'BUR9'/
      DATA (INAME(257,J),J=1,4)/'BURR','TYPE','9   ','    '/
      DATA INSHAP(257)/2/
      DATA INLONG(257)/'BURR TYPE 9'/
      DATA INCASE(258)/'BUR9'/
      DATA (INAME(258,J),J=1,4)/'BURR','TYPE','IX  ','    '/
      DATA INSHAP(258)/2/
      DATA INLONG(258)/'BURR TYPE 9'/
C     BURR TYPE 10
      DATA INCASE(259)/'BU10'/
      DATA (INAME(259,J),J=1,4)/'BURR','TYPE','10  ','    '/
      DATA INSHAP(259)/1/
      DATA INLONG(259)/'BURR TYPE 10'/
      DATA INCASE(260)/'BU10'/
      DATA (INAME(260,J),J=1,4)/'BURR','TYPE','X   ','    '/
      DATA INSHAP(260)/1/
      DATA INLONG(260)/'BURR TYPE 10'/
C     BURR TYPE 11
      DATA INCASE(261)/'BU11'/
      DATA (INAME(261,J),J=1,4)/'BURR','TYPE','11  ','    '/
      DATA INSHAP(261)/1/
      DATA INLONG(261)/'BURR TYPE 11'/
      DATA INCASE(262)/'BU11'/
      DATA (INAME(262,J),J=1,4)/'BURR','TYPE','XI  ','    '/
      DATA INSHAP(262)/1/
      DATA INLONG(262)/'BURR TYPE 11'/
C     BURR TYPE 12
      DATA INCASE(263)/'BU12'/
      DATA (INAME(263,J),J=1,4)/'BURR','TYPE','12  ','    '/
      DATA INSHAP(263)/2/
      DATA INLONG(263)/'BURR TYPE 12'/
      DATA INCASE(264)/'BU12'/
      DATA (INAME(264,J),J=1,4)/'BURR','TYPE','XII ','    '/
      DATA INSHAP(264)/2/
      DATA INLONG(264)/'BURR TYPE 12'/
C     UNEVEN TWO-SIDED POWER
      DATA INCASE(265)/'UTSP'/
      DATA (INAME(265,J),J=1,4)/'UNEV','TWO ','SIDE','POWE'/
      DATA INSHAP(265)/6/
      DATA INLONG(265)/'UNEVEN TWO-SIDED POWER'/
C     DOUBLY PARETO UNIFORM
      DATA INCASE(266)/'DPUN'/
      DATA (INAME(266,J),J=1,4)/'DOUB','PARE','UNIF','    '/
      DATA INSHAP(266)/2/
      DATA INLONG(266)/'DOUBLY PARETO UNIFORM'/
C     KUMAR
      DATA INCASE(267)/'KUMA'/
      DATA (INAME(267,J),J=1,4)/'KUMA','    ','    ','    '/
      DATA INSHAP(267)/2/
      DATA INLONG(267)/'KUMARASWAMY'/
C     REFLECTED POWER
      DATA INCASE(268)/'RPOW'/
      DATA (INAME(268,J),J=1,4)/'REFL','POWE','    ','    '/
      DATA INSHAP(268)/1/
      DATA INLONG(268)/'REFLECTED POWER'/
C     MUTH
      DATA INCASE(269)/'MUTH'/
      DATA (INAME(269,J),J=1,4)/'MUTH','    ','    ','    '/
      DATA INSHAP(269)/1/
      DATA INLONG(269)/'MUTH'/
C     LOGISTIC
      DATA INCASE(270)/'LOGI'/
      DATA (INAME(270,J),J=1,4)/'LOGI','    ','    ','    '/
      DATA INSHAP(270)/0/
      DATA INLONG(270)/'LOGISTIC'/
C     TRUNCATED PARETO
      DATA INCASE(271)/'TPAR'/
      DATA (INAME(271,J),J=1,4)/'TRUN','PARE','    ','    '/
      DATA INSHAP(271)/3/
      DATA INLONG(271)/'TRUNCATED PARETO'/
C     BRITTLE FRACTURE
      DATA INCASE(272)/'BFRA'/
      DATA (INAME(272,J),J=1,4)/'BRIT','FRAC','    ','    '/
      DATA INSHAP(272)/3/
      DATA INLONG(272)/'BRITTLE FRACTURE'/
C     3-PARAMETER LOGISTIC EXPONENTIAL
      DATA INCASE(273)/'L3EX'/
      DATA (INAME(273,J),J=1,4)/'3   ','PARA','LOGI','EXPO'/
      DATA INSHAP(273)/3/
      DATA INLONG(273)/'3-PARAMETER LOGISTIC EXPONENTIAL'/
C     KAPPA
      DATA INCASE(274)/'KAPP'/
      DATA (INAME(274,J),J=1,4)/'KAPP','    ','    ','    '/
      DATA INSHAP(274)/2/
      DATA INLONG(274)/'KAPPA'/
C     PEARSON TYPE 3
      DATA INCASE(275)/'PEA3'/
      DATA (INAME(275,J),J=1,4)/'PEAR','TYPE','III ','    '/
      DATA INSHAP(275)/1/
      DATA INLONG(275)/'PEARSON TYPE 3'/
      DATA INCASE(276)/'PEA3'/
      DATA (INAME(276,J),J=1,4)/'PEAR','TYPE','3   ','    '/
      DATA INSHAP(276)/1/
      DATA INLONG(276)/'PEARSON TYPE 3'/
C     DOUBLY NONCENTRAL BETA
      DATA INCASE(277)/'DNCB'/
      DATA (INAME(277,J),J=1,4)/'DOUB','NONC','BETA','    '/
      DATA INSHAP(277)/4/
      DATA INLONG(277)/'DOUBLY NON-CENTRAL BETA'/
C     POWER
      DATA INCASE(278)/'POWF'/
      DATA (INAME(278,J),J=1,4)/'POWE','    ','    ','    '/
      DATA INSHAP(278)/1/
      DATA INLONG(278)/'POWER'/
C     3-PARAMETER WEIBULL
      DATA INCASE(279)/'3WEI'/
      DATA (INAME(279,J),J=1,4)/'3   ','PARA','WEIB','    '/
      DATA INSHAP(279)/1/
      DATA INLONG(279)/'3-PARAMETER WEIBULL'/
C     3-PARAMETER INVERTED WEIBULL
      DATA INCASE(280)/'3IWE'/
      DATA (INAME(280,J),J=1,4)/'3   ','PARA','INVE','WEIB'/
      DATA INSHAP(280)/1/
      DATA INLONG(280)/'3-PARAMETER INVERTED WEIBULL'/
C     3-PARAMETER GAMMA
      DATA INCASE(281)/'3GAM'/
      DATA (INAME(281,J),J=1,4)/'3   ','PARA','GAMM','    '/
      DATA INSHAP(281)/1/
      DATA INLONG(281)/'3-PARAMETER GAMMA'/
C     3-PARAMETER INVERSE GAUSSIAN
      DATA INCASE(282)/'3IGA'/
      DATA (INAME(282,J),J=1,4)/'3   ','PARA','INVE','GAUS'/
      DATA INSHAP(282)/1/
      DATA INLONG(282)/'3-PARAMETER INVERSE GAUSSIAN'/
C     3-PARAMETER LOGNORMAL
      DATA INCASE(283)/'3LOG'/
      DATA (INAME(283,J),J=1,4)/'3   ','PARA','LOGN','    '/
      DATA INSHAP(283)/1/
      DATA INLONG(283)/'3-PARAMETER LOGNORMAL'/
C     1-PARAMETER EXPONENTIAL
      DATA INCASE(284)/'1EXP'/
      DATA (INAME(284,J),J=1,4)/'1   ','PARA','EXPO','    '/
      DATA INSHAP(284)/0/
      DATA INLONG(284)/'1-PARAMETER EXPONENTIAL'/
C     1-PARAMETER EXPONENTIAL
      DATA INCASE(285)/'1EXP'/
      DATA (INAME(285,J),J=1,4)/'ONE ','PARA','EXPO','    '/
      DATA INSHAP(285)/0/
      DATA INLONG(285)/'1-PARAMETER EXPONENTIAL'/
C     2-PARAMETER EXPONENTIAL
      DATA INCASE(286)/'EXPO'/
      DATA (INAME(286,J),J=1,4)/'2   ','PARA','EXPO','    '/
      DATA INSHAP(286)/0/
      DATA INLONG(286)/'EXPONENTIAL'/
C     2-PARAMETER EXPONENTIAL
      DATA INCASE(287)/'EXPO'/
      DATA (INAME(287,J),J=1,4)/'TWO ','PARA','EXPO','    '/
      DATA INSHAP(287)/0/
      DATA INLONG(287)/'EXPONENTIAL'/
C     1-PARAMETER RAYLEIGH
      DATA INCASE(288)/'1RAY'/
      DATA (INAME(288,J),J=1,4)/'1   ','PARA','RAYL','    '/
      DATA INSHAP(288)/0/
      DATA INLONG(288)/'1-PARAMETER RAYLEIGH'/
C     1-PARAMETER RAYLEIGH
      DATA INCASE(289)/'1RAY'/
      DATA (INAME(289,J),J=1,4)/'ONE ','PARA','RAYL','    '/
      DATA INSHAP(289)/0/
      DATA INLONG(289)/'1-PARAMETER RAYLEIGH'/
C     2-PARAMETER RAYLEIGH
      DATA INCASE(290)/'RAYL'/
      DATA (INAME(290,J),J=1,4)/'2   ','PARA','RAYL','    '/
      DATA INSHAP(290)/0/
      DATA INLONG(290)/'RAYLEIGH'/
C     2-PARAMETER RAYLEIGH
      DATA INCASE(291)/'RAYL'/
      DATA (INAME(291,J),J=1,4)/'TWO ','PARA','RAYL','    '/
      DATA INSHAP(291)/0/
      DATA INLONG(291)/'RAYLEIGH'/
C     1-PARAMETER MAXWELL
      DATA INCASE(292)/'1MAX'/
      DATA (INAME(292,J),J=1,4)/'1   ','PARA','MAXW','    '/
      DATA INSHAP(292)/0/
      DATA INLONG(292)/'1-PARAMETER MAXWELL'/
C     1-PARAMETER MAXWELL
      DATA INCASE(293)/'1MAX'/
      DATA (INAME(293,J),J=1,4)/'ONE ','PARA','MAXW','    '/
      DATA INSHAP(293)/0/
      DATA INLONG(293)/'1-PARAMETER MAXWELL'/
C     2-PARAMETER MAXWELL
      DATA INCASE(294)/'MAXW'/
      DATA (INAME(294,J),J=1,4)/'2   ','PARA','MAXW','    '/
      DATA INSHAP(294)/0/
      DATA INLONG(294)/'MAXWELL'/
C     2-PARAMETER MAXWELL
      DATA INCASE(295)/'MAXW'/
      DATA (INAME(295,J),J=1,4)/'TWO ','PARA','MAXW','    '/
      DATA INSHAP(295)/0/
      DATA INLONG(295)/'MAXWELL'/
C     HALF WILL BE INTERPRETED AS HALF-NORMAL (TO SUPPORT
C     HALFNORMAL PROB PLOT Y SYNTAX)
      DATA INCASE(296)/'HNOR'/
      DATA (INAME(296,J),J=1,4)/'HALF','    ','    ','    '/
      DATA INSHAP(296)/0/
      DATA INLONG(296)/'HALF-NORMAL'/
C     END EFFECTS WEIBULL
      DATA INCASE(297)/'EEWE'/
      DATA (INAME(297,J),J=1,4)/'END ','EFFE','WEIB','    '/
      DATA INSHAP(297)/5/
      DATA INLONG(297)/'END-EFFECTS WEIBULL'/
C     BRITTLE FIBER WEIBULL
      DATA INCASE(298)/'BFWE'/
      DATA (INAME(298,J),J=1,4)/'BRIT','FIBE','WEIB','    '/
      DATA INSHAP(298)/1/
      DATA INLONG(298)/'BRITTLE FIBER WEIBULL'/
C     ARCTANGENT
      DATA INCASE(299)/'ARCT'/
      DATA (INAME(299,J),J=1,4)/'ARCT','    ','    ','    '/
      DATA INSHAP(299)/2/
      DATA INLONG(299)/'ARCTANGENT'/
C     SINE
      DATA INCASE(300)/'SINE'/
      DATA (INAME(300,J),J=1,4)/'SINE','    ','    ','    '/
      DATA INSHAP(300)/0/
      DATA INLONG(300)/'SINE'/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EXTD'
      ISUBN2='IS  '
C
      IWRITE='OFF'
      IFOUND='NO'
C
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'TDIS')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF EXTDIS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGG3,ISUBRO,NUMARG,JMIN,JMAX
   52   FORMAT('IBUGG3,ISUBRO,NUMARG,JMIN,JMAX = ',A4,2X,A4,3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)ICOM,ICOM2
   53   FORMAT('ICOM,ICOM2 = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        IF(NUMARG.GE.1)THEN
          DO60I=1,NUMARG
            WRITE(ICOUT,61)I,IHARG(I),IHARG2(I)
   61       FORMAT('I,IHARG(I),IHARG2(I) = ',I8,2X,A4,2X,A4)
            CALL DPWRST('XXX','BUG ')
   60     CONTINUE
        ENDIF
        WRITE(ICOUT,63)MAXDIS
   63   FORMAT('MAXDIS = ',I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C     STEP 1: INITIALIZE THE MATCHING VARIABLE
C
      DO1010I=1,MAXDIS
        INTEMP(I)='    '
 1010 CONTINUE
      IF(JMIN.EQ.0)THEN
        INTEMP(1)=ICOM
        ICNT=1
        IF(JMIN.LT.JMAX)THEN
          DO1020I=JMIN+1,JMAX
            ICNT=ICNT+1
            INTEMP(ICNT)=IHARG(I)
 1020     CONTINUE
        ENDIF
        IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'TDIS')THEN
           WRITE(ICOUT,999)
           CALL DPWRST('XXX','BUG ')
           WRITE(ICOUT,1021)ICNT
 1021      FORMAT('JMIN = 0 CASE, ICNT = ',I8)
           CALL DPWRST('XXX','BUG ')
           DO1022II=1,ICNT
             WRITE(ICOUT,1023)II,INTEMP(II)
 1023        FORMAT('II,INTEMP(II) = ',I8,A4)
             CALL DPWRST('XXX','BUG ')
 1022      CONTINUE
        ENDIF
      ELSE
        INTEMP(1)=IHARG(JMIN)
        ICNT=1
        IF(JMAX.GT.JMIN)THEN
          DO1030I=JMIN+1,JMAX
            ICNT=ICNT+1
            INTEMP(ICNT)=IHARG(I)
 1030     CONTINUE
        ENDIF
        IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'TDIS')THEN
           WRITE(ICOUT,999)
           CALL DPWRST('XXX','BUG ')
           WRITE(ICOUT,1031)ICNT
 1031      FORMAT('JMIN > 0 CASE, ICNT = ',I8)
           CALL DPWRST('XXX','BUG ')
           DO1032II=1,ICNT
             WRITE(ICOUT,1033)II,INTEMP(II)
 1033        FORMAT('II,INTEMP(II) = ',I8,A4)
             CALL DPWRST('XXX','BUG ')
 1032      CONTINUE
        ENDIF
      ENDIF
C
C     STEP 2: NOW CHECK IF MATCHING VARIABLE MATCHES AN ENTRY
C             IN THE TABLE.  NOTE THAT WE NEED TO CHECK FOR
C             NAME CONFLICTS IN FIRST 4 CHARACTERS OF FIRST
C             ARGUMENT.
C
      DO2000I=1,MAXDIS
        IROW=I
        IF(INAME(I,1).NE.INTEMP(1))GOTO2000
C
        IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'TDIS')THEN
           WRITE(ICOUT,999)
           CALL DPWRST('XXX','BUG ')
           WRITE(ICOUT,2001)I,INAME(I,1),INTEMP(1)
 2001      FORMAT('I,INAME(I,1),INTEMP(1) = ',I8,2X,A4,2X,A4)
           CALL DPWRST('XXX','BUG ')
        ENDIF
C
C       NOW CHECK IF REMAINING ARGUMENTS MATCH
C
        ITEMP=1
        DO2022J=2,MAXSCL
          IF(INAME(IROW,J).NE.'    ')GOTO2022
            ITEMP=J-1
            GOTO2024
 2022   CONTINUE
        ITEMP=MAXSCL
 2024   CONTINUE
C
        IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'TDIS')THEN
           WRITE(ICOUT,2027)IROW,ITEMP
 2027      FORMAT('IROW,ITEMP = ',2I8)
           CALL DPWRST('XXX','BUG ')
        ENDIF
C
        IF(ITEMP.GT.1)THEN
          DO2028J=2,ITEMP
            IF(INAME(IROW,J).NE.INTEMP(J))GOTO2000
 2028     CONTINUE
        ENDIF
C
        IFOUND='YES'
        IF(ITEMP.EQ.1)THEN
          ILOCV=JMIN+1
        ELSE
          ILOCV=JMIN+(ITEMP-2)+1
        ENDIF
        IDISCS=INCASE(IROW)
        IDISPR=INSHAP(IROW)
        IDISNM=INLONG(IROW)
        GOTO2099
C
 2000 CONTINUE
 2099 CONTINUE
C
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'TDIS')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF EXTDIS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGG3,ISUBRO,IFOUND
 9012   FORMAT('IBUGG3,ISUBRO,IFOUND = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        IF(IFOUND.EQ.'YES')THEN
          WRITE(ICOUT,9013)IDISCS,IDISPR,ILOCV
 9013     FORMAT('IDISCS,IDISPR,ILOCV = ',A4,2X,I5,2X,2I8)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,9014)IDISNM
 9014     FORMAT('IDISNM = ',A60)
          CALL DPWRST('XXX','BUG ')
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE EXTDST(ICASPL,IDISFL,ILOWLM,
     1                  SHAPE1,SHAPE2,SHAPE3,SHAPE4,
     1                  SHAPE5,SHAPE6,SHAPE7,
     1                  IADEDF,IGEPDF,IMAKDF,IBEIDF,
     1                  ILGADF,ISKNDF,IGLDDF,IBGEDF,
     1                  IGETDF,ICONDF,IGOMDF,IKATDF,
     1                  IGIGDF,IGEODF)
C
C     PURPOSE--SET VALUE OF IDISFL TO "CONT" OR "DISC" DEPENDING
C              ON WHETHER WE HAVE A CONTINOUS OR A DISCRETE
C              DISTRIBUTION.  ALSO RETURN THE VALUE OF THE LOWER LIMIT
C              (TYPICALLY EITHER 0 OR 1) IN ILOWLM.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORAOTRY
C                 NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/1
C     ORIGINAL VERSION--JANUARY   2010.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IDISFL
      CHARACTER*4 IADEDF
      CHARACTER*4 IGEPDF
      CHARACTER*4 IMAKDF
      CHARACTER*4 IBEIDF
      CHARACTER*4 ILGADF
      CHARACTER*4 ISKNDF
      CHARACTER*4 IGLDDF
      CHARACTER*4 IBGEDF
      CHARACTER*4 IGETDF
      CHARACTER*4 ICONDF
      CHARACTER*4 IGOMDF
      CHARACTER*4 IKATDF
      CHARACTER*4 IGIGDF
      CHARACTER*4 IGEODF
C
C---------------------------------------------------------------------
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      IDISFL='CONT'
      ILOWLM=0
C
      IF(ICASPL.EQ.'BINO')IDISFL='DISC'
      IF(ICASPL.EQ.'GEOM')IDISFL='DISC'
      IF(ICASPL.EQ.'POIS')IDISFL='DISC'
      IF(ICASPL.EQ.'NEBI')IDISFL='DISC'
      IF(ICASPL.EQ.'BBIN')IDISFL='DISC'
      IF(ICASPL.EQ.'BNBI')IDISFL='DISC'
      IF(ICASPL.EQ.'DUNI')IDISFL='DISC'
      IF(ICASPL.EQ.'HYPG')IDISFL='DISC'
      IF(ICASPL.EQ.'POLY')IDISFL='DISC'
      IF(ICASPL.EQ.'HERM')IDISFL='DISC'
      IF(ICASPL.EQ.'YULE')IDISFL='DISC'
      IF(ICASPL.EQ.'BGEO')THEN
        IDISFL='DISC'
        ILOWLM=1
        IF(IBGEDF.EQ.'SHIF')ILOWLM=0
      ENDIF
      IF(ICASPL.EQ.'ZETA')THEN
        IDISFL='DISC'
        ILOWLM=1
        CALL ZETA2(DBLE(SHAPE1),DZETA)
        DZETA=DZETA+1.0D0
      ENDIF
      IF(ICASPL.EQ.'ZIPF')THEN
        IDISFL='DISC'
        ILOWLM=1
        IMAX=INT(AMAX+0.00001)
        IF(INT(SHAPE2+0.1).LT.IMAX)SHAPE2=REAL(IMAX)
        CALL HNM(INT(SHAPE2+0.1),DBLE(SHAPE1),DZETA)
      ENDIF
      IF(ICASPL.EQ.'BTAN')THEN
        IDISFL='DISC'
        ILOWLM=INT(SHAPE2+0.1)
      ENDIF
      IF(ICASPL.EQ.'LPOI')IDISFL='DISC'
      IF(ICASPL.EQ.'OCCU')IDISFL='DISC'
      IF(ICASPL.EQ.'LICT')IDISFL='DISC'
      IF(ICASPL.EQ.'MATC')IDISFL='DISC'
      IF(ICASPL.EQ.'AEPP')IDISFL='DISC'
      IF(ICASPL.EQ.'LOST')THEN
        IDISFL='DISC'
        ILOWLM=INT(SHAPE2+0.1)
      ENDIF
      IF(ICASPL.EQ.'GLOS')THEN
        IDISFL='DISC'
        ILOWLM=INT(SHAPE3+0.1)
      ENDIF
      IF(ICASPL.EQ.'GNBI')IDISFL='DISC'
      IF(ICASPL.EQ.'GEET')THEN
        IDISFL='DISC'
        ILOWLM=1
      ENDIF
      IF(ICASPL.EQ.'QBIN')IDISFL='DISC'
      IF(ICASPL.EQ.'CONS')THEN
        IDISFL='DISC'
        ILOWLM=1
      ENDIF
      IF(ICASPL.EQ.'LKAT')IDISFL='DISC'
      IF(ICASPL.EQ.'KATZ')IDISFL='DISC'
      IF(ICASPL.EQ.'DISW')IDISFL='DISC'
      IF(ICASPL.EQ.'GLGP')IDISFL='DISC'
      IF(ICASPL.EQ.'TGNB')IDISFL='DISC'
      IF(ICASPL.EQ.'WARI')IDISFL='DISC'
      IF(ICASPL.EQ.'GWAR')IDISFL='DISC'
      IF(ICASPL.EQ.'LOGS')THEN
        IDISFL='DISC'
        ILOWLM=1
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EXTIND(X,N,IWRITE,PSTAMV,XIND,ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE INDEX WHERE THE
C              SAMPLE EXTREME OF THE DATA IN THE INPUT VECTOR X
C              OCCURS.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--XIND   = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED INDEX OF THE SAMPLE EXTREME.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE INDEX OF THE EXTREME.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009.2
C     ORIGINAL VERSION--FEBRUARY  2009.
C     UPDATED  VERSION--APRIL     2010. SKIP "MISSING VALUES"
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EXTI'
      ISUBN2='ND  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'TIND')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF EXTIND--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)N
   53   FORMAT('N = ',I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,X(I)
   56     FORMAT('I,X(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ***********************
C               **  COMPUTE EXTREME  **
C               ***********************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(N.LT.1)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN INDEX EXTREME--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS FOR THE ',
     1         'RESPONSE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,113)
  113   FORMAT('      VARIABLE MUST BE 1 OR LARGER.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,116)
  116   FORMAT('      SUCH WAS NOT THE CASE HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,117)N
  117   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,
     1         '.')
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      IF(N.EQ.1)THEN
        XIND=1.0
        GOTO800
      ENDIF
C
C               *****************************************
C               **  STEP 2--                           **
C               **  COMPUTE THE INDEX OF THE EXTREME.  **
C               *****************************************
C
      XEXT=CPUMIN
      XIND=1.0
      DO200I=1,N
        XTEMP=ABS(X(I))
        IF(XEXT.EQ.CPUMIN)THEN
          IF(XTEMP.EQ.PSTAMV)GOTO200
          XEXT=XTEMP
          XIND=REAL(I)
        ELSE
          IF(XTEMP.NE.PSTAMV .AND. XTEMP.GT.XEXT)THEN
            XEXT=XTEMP
            XIND=REAL(I)
          ENDIF
        ENDIF
  200 CONTINUE
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
  800 CONTINUE
      IF(IFEEDB.EQ.'ON' .AND. IWRITE.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,811)N,XIND
  811   FORMAT('THE INDEX FOR THE EXTREME VALUE OF THE ',I8,
     1         ' OBSERVATIONS = ',F12.0)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'TIND')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF EXTIND--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR
 9012   FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)N
 9013   FORMAT('N = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)XEXT,XEXT2,XIND
 9015   FORMAT('XEXT,XEXT2,XIND = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE EXTPA1(ICASPL,IDIST,A,B,
     1                  SHAPE1,SHAPE2,SHAPE3,SHAPE4,
     1                  SHAPE5,SHAPE6,SHAPE7,
     1                  IADEDF,IGEPDF,IMAKDF,IBEIDF,
     1                  ILGADF,ISKNDF,IGLDDF,IBGEDF,
     1                  IGETDF,ICONDF,IGOMDF,IKATDF,
     1                  IGIGDF,IGEODF,
     1                  IBFWLI,IEEWLI,
     1                  ISUBRO,IBUGG2,IERROR)
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORAOTRY
C                 NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/8
C     ORIGINAL VERSION--AUGUST    2009.
C     UPDATED         --JULY      2010. END EFFECTS WEIBULL
C     UPDATED         --AUGUST    2010. BRITTLE FIBER WEIBULL
C     UPDATED         --OCTOBER   2010. IBFWLI, IEEWLI
C     UPDATED         --JANUARY   2011. ARCTANGENT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*30 IDIST
C
      CHARACTER*4 IADEDF
      CHARACTER*4 IGEPDF
      CHARACTER*4 IMAKDF
      CHARACTER*4 IBEIDF
      CHARACTER*4 ILGADF
      CHARACTER*4 ISKNDF
      CHARACTER*4 IGLDDF
      CHARACTER*4 IBGEDF
      CHARACTER*4 IGETDF
      CHARACTER*4 ICONDF
      CHARACTER*4 IGOMDF
      CHARACTER*4 IKATDF
      CHARACTER*4 IGIGDF
      CHARACTER*4 IGEODF
      CHARACTER*4 IBFWLI
      CHARACTER*4 IEEWLI
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IBUGG2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 IH21
      CHARACTER*4 IH22
      CHARACTER*4 IH31
      CHARACTER*4 IH32
      CHARACTER*4 IH41
      CHARACTER*4 IH42
      CHARACTER*4 IH51
      CHARACTER*4 IH52
      CHARACTER*4 LOWLTY
      CHARACTER*4 UPPLTY
      CHARACTER*4 LOWLT2
      CHARACTER*4 UPPLT2
      CHARACTER*4 LOWLT3
      CHARACTER*4 UPPLT3
      CHARACTER*4 LOWLT4
      CHARACTER*4 UPPLT4
      CHARACTER*4 LOWLT5
      CHARACTER*4 UPPLT5
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 ICASEQ
C
      INCLUDE 'DPCOMC.INC'
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
C
C---------------------------------------------------------------------
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C               ***********************************************
C               **  STEP 1--                                 **
C               **  FOR THOSE DISTRIBUTIONS REQUIRING THEM,  **
C               **  DETERMINE IF THE ANALYST                 **
C               **  HAS SPECIFIED PARAMETER VALUES           **
C               ***********************************************
C
      SHAPE1=CPUMIN
      SHAPE2=CPUMIN
      SHAPE3=CPUMIN
      SHAPE4=CPUMIN
      SHAPE5=CPUMIN
      SHAPE6=CPUMIN
      SHAPE7=CPUMIN
C
      ISUBN1='EXTP'
      ISUBN2='A1  '
      ISTEPN='1'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'TPA1')THEN
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,55)IDIST
   55   FORMAT('AT BEGINNING OF EXTPA1: IDIST = ',A30)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(ICASPL.EQ.'TULA' .OR. ICASPL.EQ.'SNOR')THEN
        IH='LAMB'
        IH2='DA  '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'POIS')THEN
        IH='LAMB'
        IH2='DA  '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'TPP')THEN
        IH='NU  '
        IH2='    '
        ALOWLM=1.0
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(
     1       ICASPL.EQ.'CHIS' .OR. ICASPL.EQ.'CHI' .OR.
     1       ICASPL.EQ.'FT  '
     1      )THEN
        IH='NU  '
        IH2='    '
        ILOWLM=1
        IUPPLM=I1MACH(9)
        LOWLTY='>=  '
        UPPLTY='<=  '
        GOTO5100
      ELSEIF(ICASPL.EQ.'FPP')THEN
        IH='NU1 '
        IH2='    '
        IDIST='F     '
        ILOWLM=1
        IUPPLM=I1MACH(9)
        LOWLTY='>=  '
        UPPLTY='<=  '
        IH21='NU2 '
        IH22='    '
        ILOWL2=1
        IUPPL2=I1MACH(9)
        LOWLT2='>=  '
        UPPLT2='<=  '
        GOTO5200
      ELSEIF(
     1   ICASPL.EQ.'GAMM' .OR. ICASPL.EQ.'WEIB' .OR.
     1   ICASPL.EQ.'EV2 ' .OR. ICASPL.EQ.'WALD' .OR.
     1   ICASPL.EQ.'FATL' .OR. ICASPL.EQ.'DWEI' .OR.
     1   ICASPL.EQ.'DGAM' .OR. ICASPL.EQ.'IGAM' .OR.
     1   ICASPL.EQ.'IWEI' .OR. ICASPL.EQ.'GEEX' .OR.
     1   ICASPL.EQ.'LGAM' .OR.
     1   ICASPL.EQ.'3GAM' .OR. ICASPL.EQ.'3WEI' .OR.
     1   ICASPL.EQ.'3IGA' .OR. ICASPL.EQ.'3LGN' .OR.
     1   ICASPL.EQ.'3IWE'
     1  )THEN
        IH='GAMM'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'PARE' .OR. ICASPL.EQ.'PAR2')THEN
        IH='GAMM'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='A   '
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'BFWE')THEN
        IH='GAMM'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IF(IBFWLI.EQ.'VARI')THEN
          GOTO4100
        ELSE
          IH21='L   '
          IH22='    '
          ALOWL2=0.
          AUPPL2=CPUMAX
          LOWLT2='>   '
          UPPLT2='<=  '
          GOTO4200
         ENDIF
      ELSEIF(
     1   ICASPL.EQ.'PEA3' .OR. ICASPL.EQ.'GPAR' .OR.
     1   ICASPL.EQ.'GEV'
     1  )THEN
        IH='GAMM'
        IH2='A   '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(
     1   ICASPL.EQ.'BETA' .OR. ICASPL.EQ.'HERM' .OR.
     1   ICASPL.EQ.'BGEO' .OR. ICASPL.EQ.'IBET' .OR.
     1   ICASPL.EQ.'BNOR' .OR. ICASPL.EQ.'POWL'
     1  )THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='BETA'
        IH22='    '
        ALOWL2=0.0
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'TPAR')THEN
        IH='GAMM'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='A   '
        IH22='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLT2='>=  '
        UPPLT2='<=  '
        IH31='NU  '
        IH32='    '
        ALOWL3=0.0
        AUPPL3=CPUMAX
        LOWLT3='>   '
        UPPLT3='<=  '
        GOTO4300
      ELSEIF(ICASPL.EQ.'BFRA')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='BETA'
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>=  '
        UPPLT2='<=  '
        IH31='R   '
        IH32='    '
        ALOWL3=0.
        AUPPL3=CPUMAX
        LOWLT3='>   '
        UPPLT3='<=  '
        GOTO4300
      ELSEIF(ICASPL.EQ.'BINO')THEN
        IH='P   '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=1.0
        LOWLTY='>=  '
        UPPLTY='<=  '
        IH21='N   '
        IH22='    '
        ILOWL2=1
        IUPPL2=I1MACH(9)
        LOWLT2='>=  '
        UPPLT2='<=  '
        GOTO4900
      ELSEIF(ICASPL.EQ.'GEOM')THEN
        IH='P   '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=1.0
        LOWLTY='>   '
        UPPLTY='<   '
        GOTO4100
      ELSEIF(ICASPL.EQ.'NEBI')THEN
        IH='P   '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=1.0
        LOWLTY='>   '
        UPPLTY='<   '
        IH21='K   '
        IH22='    '
        ALOWL2=0.0
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'INGA' .OR. ICASPL.EQ.'RIGA')THEN
        IH='GAMM'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='MU  '
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'TRIA')THEN
C
C       NOTE: FOR TRIANGULAR DISTRIBUTION, THE SHAPE PARAMETER
C             IS BOUNDED BY THE MIN AND MAX OF THE DATA.
C
C             THERE ARE TWO WAYS TO DEAL WITH THIS:
C
C             1) ALLOW THE USER TO SPECIFY LOWER AND UPPER LIMITS
C                (AND SET C BASED ON THESE).
C
C                THE ADVANTAGE OF THIS APPROACH IS THAT C IS
C                GIVEN IN UNITS OF THE DATA.  THE DISADVANTAGE
C                IS THAT WE LOSE THE INVARIANCE OF LOCATION/SCALE
C                OF THE PPCC PLOT. 
C
C             2) USE DEFAULT OF A = -1, B = 1 AND THEN RESTRICT
C                VALUE OF C TO (0,1) INTERVAL.  THE ADVANTAGE
C                OF THIS APPROACH IS THAT WE MAINTAIN THE
C                INVARIANCE OF LOCATION/SCALE (I.E., INDEPENDENT
C                ESTIMATES OF A AND B).  THE DISADVANTAGE IS THAT
C                THE OPTIMAL ESTIMATE OF C HAS TO BE SCALED IF THE
C                DATA IS OUTSIDE THE (0,1) INTERVAL.
C
C                USER CAN SPECIFY LOWER/UPPER LIMITS BY ENTERING
C                LET A = <LOWLIM>  AND  LET B = <UPPLIM>.  THESE
C                PARAMETERS WILL BE CHECKED BEFORE THIS ROUTINE
C                IS CALLED.
C
        IH='C   '
        IH2='    '
        ALOWLM=A
        AUPPLM=B
        LOWLTY='>=  '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'DUNI' .OR. ICASPL.EQ.'LICT')THEN
        IH='N   '
        IH2='    '
        ILOWLM=1
        IUPPLM=I1MACH(9)
        LOWLTY='>=  '
        UPPLTY='<=  '
        GOTO5100
      ELSEIF(ICASPL.EQ.'MATC')THEN
        IH='K   '
        IH2='    '
        ILOWLM=0
        IUPPLM=I1MACH(9)
        LOWLTY='>=  '
        UPPLTY='<=  '
        GOTO5100
      ELSEIF(ICASPL.EQ.'OCCU')THEN
        IH='B   '
        IH2='    '
        ILOWLM=1
        IUPPLM=I1MACH(9)
        LOWLTY='>=  '
        UPPLTY='<=  '
        IH21='C   '
        IH22='    '
        ILOWL2=1
        IUPPL2=I1MACH(9)
        LOWLT2='>=  '
        UPPLT2='<=  '
        GOTO5200
      ELSEIF(ICASPL.EQ.'NCBE')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='BETA'
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        IH31='LAMB'
        IH32='DA  '
        ALOWL3=0.
        AUPPL3=CPUMAX
        LOWLT3='>=  '
        UPPLT3='<=  '
        GOTO4300
      ELSEIF(ICASPL.EQ.'DNCB')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='BETA'
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        IH31='LAMB'
        IH32='DA1 '
        ALOWL3=0.
        AUPPL3=CPUMAX
        LOWLT3='>=  '
        UPPLT3='<=  '
        IH41='LAMB'
        IH42='DA2 '
        ALOWL4=0.
        AUPPL4=CPUMAX
        LOWLT4='>=  '
        UPPLT4='<=  '
        GOTO4400
      ELSEIF(ICASPL.EQ.'NCCS' .OR. ICASPL.EQ.'NCT')THEN
        IH='NU  '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='LAMB'
        IH22='DA  '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>=  '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'NCF')THEN
        IH='NU1 '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='NU2 '
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        IH31='LAMB'
        IH32='DA  '
        ALOWL3=0.
        AUPPL3=CPUMAX
        LOWLT3='>=  '
        UPPLT3='<=  '
        GOTO4300
      ELSEIF(ICASPL.EQ.'DNCF')THEN
        IH='NU1 '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='NU2 '
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        IH31='LAMB'
        IH32='DA1 '
        ALOWL3=0.
        AUPPL3=CPUMAX
        LOWLT3='>=  '
        UPPLT3='<=  '
        IH41='LAMB'
        IH42='DA2 '
        ALOWL4=0.
        AUPPL4=CPUMAX
        LOWLT4='>=  '
        UPPLT4='<=  '
        GOTO4400
      ELSEIF(ICASPL.EQ.'DNCT')THEN
        IH='NU  '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='LAMB'
        IH22='DA1 '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>=  '
        UPPLT2='<=  '
        IH31='LAMB'
        IH32='DA2 '
        ALOWL3=0.
        AUPPL3=CPUMAX
        LOWLT3='>=  '
        UPPLT3='<=  '
        GOTO4300
      ELSEIF(ICASPL.EQ.'HYPB')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='XI  '
        IH22='A   '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'HYPG')THEN
        IH='M   '
        IH2='    '
        ILOWLM=1
        IUPPLM=I1MACH(9)
        LOWLTY='>=  '
        UPPLTY='<=  '
        CALL PARCHI(IH,IH2,IDIST,ISHAPE,ILOWLM,IUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        SHAPE3=REAL(ISHAPE)
        IH='N   '
        IH2='    '
        ILOWLM=1
        IUPPLM=INT(SHAPE3)+0.1
        LOWLTY='>=  '
        UPPLTY='<=  '
        CALL PARCHI(IH,IH2,IDIST,ISHAPE,ILOWLM,IUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        SHAPE2=REAL(ISHAPE)
        IH='K   '
        IH2='    '
        ILOWLM=1
        IUPPLM=INT(SHAPE3)+0.1
        LOWLTY='>=  '
        UPPLTY='<=  '
        CALL PARCHI(IH,IH2,IDIST,ISHAPE,ILOWLM,IUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        SHAPE1=REAL(ISHAPE)
      ELSEIF(ICASPL.EQ.'VONM')THEN
        IH='B   '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'POWN')THEN
        IH='P   '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'PLGN')THEN
        IH='P   '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='SD  '
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(
     1       ICASPL.EQ.'ALPH' .OR. ICASPL.EQ.'LDEX' .OR.
     1       ICASPL.EQ.'GLOG' .OR. ICASPL.EQ.'G2LO' .OR.
     1       ICASPL.EQ.'G3LO'
     1      )THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(
     1       ICASPL.EQ.'TOPL' .OR. ICASPL.EQ.'BRAD'.OR.
     1       ICASPL.EQ.'LEXP' .OR. ICASPL.EQ.'PEXP'
     1      )THEN
        IH='BETA'
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'GTOL' .OR. ICASPL.EQ.'RGTL')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=2.0
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='BETA'
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'KUMA')THEN
        IH='BETA'
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='ALPH'
        IH22='A   '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'LOGN')THEN
        IH='SIGM'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'POWF' .OR. ICASPL.EQ.'RPOW')THEN
        IH='C   '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'LOGS')THEN
        IH='THET'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=1.0
        LOWLTY='>   '
        UPPLTY='<   '
        GOTO4100
      ELSEIF(ICASPL.EQ.'GLOS')THEN
        IH='THET'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=1.0
        LOWLTY='>   '
        UPPLTY='<   '
        IH21='BETA'
        IH22='    '
        ALOWL2=1.0
        AUPPL2=1.0/THETA
        LOWLT2='>   '
        UPPLT2='<   '
        GOTO4200
      ELSEIF(ICASPL.EQ.'GNBI')THEN
        IH='THET'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=1.0
        LOWLTY='>   '
        UPPLTY='<   '
        CALL PARCHR(IH,IH2,IDIST,SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='BETA'
        IH2='    '
        ALOWLM=1.0
        AUPPLM=1.0/THETA
        LOWLTY='>   '
        UPPLTY='<   '
        CALL PARCHR(IH,IH2,IDIST,SHAPE2,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')THEN
          IF(SHAPE2.NE.0.0)THEN
            GOTO9000
          ELSE
            IERROR='NO'
          ENDIF
        ENDIF
        IH='M   '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<   '
        CALL PARCHR(IH,IH2,IDIST,SHAPE3,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
      ELSEIF(ICASPL.EQ.'TGNB')THEN
        IH='THET'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=1.0
        LOWLTY='>   '
        UPPLTY='<   '
        CALL PARCHR(IH,IH2,IDIST,SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='BETA'
        IH2='    '
        ALOWLM=1.0
        AUPPLM=1.0/THETA
        LOWLTY='>   '
        UPPLTY='<   '
        CALL PARCHR(IH,IH2,IDIST,SHAPE2,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')THEN
          IF(SHAPE2.NE.0.0)THEN
            GOTO9000
          ELSE
            IERROR='NO'
          ENDIF
        ENDIF
        IH='M   '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<   '
        CALL PARCHR(IH,IH2,IDIST,SHAPE3,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='N   '
        IH2='    '
        ILOWLM=1
        IUPPLM=I1MACH(9)
        LOWLTY='>=  '
        UPPLTY='<=  '
        CALL PARCHI(IH,IH2,IDIST,ISHAPE,ILOWLM,IUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        SHAPE4=REAL(ISHAPE)
      ELSEIF(ICASPL.EQ.'LKAT')THEN
        IH='A   '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<   '
        IH21='BETA'
        IH22='    '
        ALOWL2=CPUMIN
        AUPPL2=1.0
        LOWLT2='>   '
        UPPLT2='<   '
        IH31='B   '
        IH32='    '
        ALOWL3=0.0
        AUPPL3=CPUMAX
        LOWLT3='>   '
        UPPLT3='<   '
        GOTO4300
      ELSEIF(ICASPL.EQ.'KATZ')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<   '
        IH21='BETA'
        IH22='    '
        ALOWL2=CPUMIN
        AUPPL2=1.0
        LOWLT2='>   '
        UPPLT2='<   '
        GOTO4200
      ELSEIF(ICASPL.EQ.'QBIN')THEN
        IH='P   '
        IH2='    '
        ALOWLM=0.
        AUPPLM=1.0
        LOWLTY='>=  '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='M   '
        IH2='    '
        ILOWLM=0
        IUPPLM=I1MACH(9)
        LOWLTY='>=  '
        UPPLTY='<=  '
        CALL PARCHI(IH,IH2,IDIST,ISHAPE,ILOWLM,IUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        SHAPE3=REAL(ISHAPE)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='PHI '
        IH2='    '
        ALOWLM=-SHAPE1/SHAPE3
        AUPPLM=(1.0-SHAPE1)/SHAPE3
        LOWLTY='>   '
        UPPLTY='<   '
        CALL PARCHR(IH,IH2,IDIST,SHAPE2,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
      ELSEIF(ICASPL.EQ.'GEET')THEN
        IF(IGETDF.EQ.'THET')THEN
          IH='THET'
          IH2='A   '
          ALOWLM=0.
          AUPPLM=1.0
          LOWLTY='>   '
          UPPLTY='<   '
          CALL PARCHR(IH,IH2,IDIST,SHAPE1,ALOWLM,AUPPLM,
     1              LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
          IH='BETA'
          IH2='    '
          ALOWLM=1.0
          AUPPLM=1.0/SHAPE1
          LOWLTY='>   '
          UPPLTY='<   '
          CALL PARCHR(IH,IH2,IDIST,SHAPE2,ALOWLM,AUPPLM,
     1                LOWLTY,UPPLTY,
     1                ISUBN1,ISUBN2,IERROR)
          IF(IERROR.EQ.'YES')THEN
            IF(SHAPE2.NE.0.0)THEN
              GOTO9000
            ELSE
              IERROR='NO'
            ENDIF
          ENDIF
        ELSE
          IH='MU  '
          IH2='    '
          ALOWLM=1.0
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<   '
          IH21='BETA'
          IH22='    '
          ALOWL2=1.0
          AUPPL2=CPUMAX
          LOWLT2='>   '
          UPPLT2='<   '
          GOTO4200
        ENDIF
      ELSEIF(ICASPL.EQ.'CONS')THEN
        IF(ICONDF.EQ.'THET')THEN
          IH='THET'
          IH2='A   '
          ALOWLM=0.
          AUPPLM=1.0
          LOWLTY='>   '
          UPPLTY='<   '
          IH21='M   '
          IH22='    '
          ALOWL2=1.0
          AUPPL2=CPUMAX
          LOWLT2='>=  '
          UPPLT2='<=  '
          GOTO4200
        ELSE
          IH='MU  '
          IH2='    '
          ALOWLM=1.0
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<   '
          IH21='M   '
          IH22='    '
          ALOWL2=1.0
          AUPPL2=CPUMAX
          LOWLT2='>=  '
          UPPLT2='<   '
          GOTO4200
        ENDIF
      ELSEIF(ICASPL.EQ.'AEPP')THEN
        IH='THET'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<   '
        IH21='P   '
        IH22='    '
        ALOWL2=0.
        AUPPL2=1.0
        LOWLT2='>   '
        UPPLT2='<   '
        GOTO4200
      ELSEIF(ICASPL.EQ.'LOST')THEN
        IH='P   '
        IH2='    '
        ALOWLM=0.5
        AUPPLM=1.0
        LOWLTY='>   '
        UPPLTY='<   '
        IH21='R   '
        IH22='    '
        ILOWL2=0
        IUPPL2=I1MACH(9)
        LOWLT2='>=  '
        UPPLT2='<=  '
        GOTO4900
      ELSEIF(ICASPL.EQ.'GLGP')THEN
        IH='P   '
        IH2='    '
        ALOWLM=0.5
        AUPPLM=1.0
        LOWLTY='>   '
        UPPLTY='<   '
        CALL PARCHR(IH,IH2,IDIST,SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='A   '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<   '
        CALL PARCHR(IH,IH2,IDIST,SHAPE3,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='J   '
        IH2='    '
        ILOWLM=0
        IUPPLM=I1MACH(9)
        LOWLTY='>=  '
        UPPLTY='<=  '
        CALL PARCHI(IH,IH2,IDIST,ISHAPE,ILOWLM,IUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        SHAPE2=REAL(ISHAPE)
      ELSEIF(ICASPL.EQ.'DISW')THEN
        IH='Q   '
        IH2='    '
        ALOWLM=0.
        AUPPLM=1.0
        LOWLTY='>   '
        UPPLTY='<   '
        IH21='BETA'
        IH22='    '
        ALOWL2=0.0
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<   '
        GOTO4200
      ELSEIF(ICASPL.EQ.'LOGL')THEN
        IH='DELT'
        IH2='A   '
        IDIST='LOG-LOGISTIC'
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'GGAM')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='C   '
        IH22='    '
        ALOWL2=CPUMIN
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'YULE')THEN
        IH='P   '
        IH2='    '
        ALOWLM=0.1
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<   '
        GOTO4100
      ELSEIF(ICASPL.EQ.'WARI')THEN
        IH='C   '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='A   '
        IH22='    '
        ALOWL2=0.0
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'FNOR')THEN
        IH='MU  '
        IH2='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='SD  '
        IH22='    '
        ALOWL2=0.0
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'TNOR')THEN
        IH='MU  '
        IH2='    '
        ALOWLM=A
        AUPPLM=B
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='SD  '
        IH22='    '
        ALOWL2=0.0
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'GOMP')THEN
        IF(IGOMDF.EQ.'JOHN' .OR. IGOMDF.EQ.'DEFA')THEN
          IH='C   '
          IH2='    '
          ALOWLM=1.
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<=  '
          IH21='B   '
          IH22='    '
          ALOWL2=0.
          AUPPL2=CPUMAX
          LOWLT2='>   '
          UPPLT2='<=  '
          GOTO4200
        ELSE
          IH='ALPH'
          IH2='A   '
          ALOWLM=0.
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<=  '
          IH21='K   '
          IH22='    '
          ALOWL2=0.
          AUPPL2=CPUMAX
          LOWLT2='>   '
          UPPLT2='<=  '
          GOTO4200
        ENDIF
      ELSEIF(ICASPL.EQ.'GHLO')THEN
        IH='GAMM'
        IH2='A   '
        ALOWLM=0.0
        AUPPLM=5.0
        LOWLTY='>=  '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'WCAU')THEN
        IH='P   '
        IH2='    '
        ALOWLM=0.
        AUPPLM=1.
        LOWLTY='>=  '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'ARCT')THEN
        IH='PHI '
        IH2='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<   '
        IH21='ALPH'
        IH22='A   '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'EWEI')THEN
        IH='GAMM'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='THET'
        IH22='A   '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'TEXP')THEN
        IH='X0  '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='M   '
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>=   '
        UPPLT2='<=  '
        IH31='SD  '
        IH32='    '
        ALOWL3=0.
        AUPPL3=CPUMAX
        LOWLT3='>    '
        UPPLT3='<=  '
        GOTO4300
      ELSEIF(ICASPL.EQ.'G5LO')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'G4LO')THEN
        IH='P   '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='Q   '
        IH22='    '
        ALOWL2=0.0
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'WAKE')THEN
C
        IH='GAMM'
        IH2='A   '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IH='BETA'
        IH2='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE2,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IH='DELT'
        IH2='A   '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE3,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='ALPH'
        IH2='A   '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE4,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='CHI '
        IH2='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE5,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
      ELSEIF(ICASPL.EQ.'MBKA')THEN
        IH='THET'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='K   '
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'KAPP')THEN
        IH='K   '
        IH2='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='H   '
        IH22='    '
        ALOWL2=CPUMIN
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'FCAU')THEN
        IH='LOC '
        IH2='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='SCAL'
        IH22='E   '
        ALOWL2=0.0
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'BBIN' .OR. ICASPL.EQ.'POLY')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='BETA'
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE2,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='N   '
        IH2='    '
        ILOWLM=0
        IUPPLM=I1MACH(9)
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHI(IH,IH2,IDIST,ISHAPE,ILOWLM,IUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        SHAPE3=REAL(ISHAPE)
      ELSEIF(ICASPL.EQ.'BNBI' .OR. ICASPL.EQ.'GWAR')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='BETA'
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        IH31='K   '
        IH32='    '
        ALOWL3=0.
        AUPPL3=CPUMAX
        LOWLT3='>   '
        UPPLT3='<=  '
        GOTO4300
      ELSEIF(ICASPL.EQ.'ZETA')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=1.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'ZIPF')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=1.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='N   '
        IH22='    '
        ILOWL2=1
        IUPPL2=I1MACH(9)
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4900
      ELSEIF(ICASPL.EQ.'MUTH')THEN
        IH='BETA'
        IH2='    '
        ALOWLM=0.
        AUPPLM=1.0
        LOWLTY='>=  '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'L3EX')THEN
        IH='BETA'
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='ALPH'
        IH22='A   '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        IH31='THET'
        IH32='A   '
        ALOWL3=0.
        AUPPL3=CPUMAX
        LOWLT3='>=  '
        UPPLT3='<=  '
        GOTO4300
      ELSEIF(ICASPL.EQ.'GEXP')THEN
        IH='LAMB'
        IH2='DA1 '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='LAMB'
        IH22='DA12'
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        IH31='S   '
        IH32='    '
        ALOWL3=0.
        AUPPL3=CPUMAX
        LOWLT3='>   '
        UPPLT3='<=  '
        GOTO4300
      ELSEIF(ICASPL.EQ.'RECI')THEN
        IH='B   '
        IH2='    '
        ALOWLM=1.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'NORX')THEN
        IH='U1  '
        IH2='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='SD1 '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE2,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='U2  '
        IH2='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE3,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='SD2 '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE4,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='P   '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=1.0
        LOWLTY='>   '
        UPPLTY='<   '
        CALL PARCHR(IH,IH2,IDIST,SHAPE5,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ELSEIF(ICASPL.EQ.'ALDE')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<   '
        IH21='BETA'
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<   '
        GOTO4200
      ELSEIF(ICASPL.EQ.'JOSU' .OR. ICASPL.EQ.'JOSB')THEN
        IH='ALPH'
        IH2='A1  '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        IH21='ALPH'
        IH22='A2  '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'GTLA')THEN
        IH='LAMB'
        IH2='DA3 '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        IH21='LAMB'
        IH22='DA4 '
        ALOWL2=CPUMIN
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'ERRO')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=1.0
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'TSPO')THEN
        IH='THET'
        IH2='A   '
        ALOWLM=A
        AUPPLM=B
        LOWLTY='>=  '
        UPPLTY='<=  '
        IH21='N   '
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'BWEI')THEN
        IH='SCAL'
        IH2='E1  '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='SCAL'
        IH2='E2  '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE2,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='GAMM'
        IH2='A1  '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE3,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='GAMM'
        IH2='A2  '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE4,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='LOC2'
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE5,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ELSEIF(ICASPL.EQ.'TRAP')THEN
        IH='A   '
        IH2='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        IH21='B   '
        IH22='    '
        ALOWL2=CPUMIN
        AUPPL2=CPUMAX
        LOWLT2='>=  '
        UPPLT2='<=  '
        IH31='C   '
        IH32='    '
        ALOWL3=CPUMIN
        AUPPL3=CPUMAX
        LOWLT3='>=  '
        UPPLT3='<=  '
        IH41='D   '
        IH42='    '
        ALOWL4=CPUMIN
        AUPPL4=CPUMAX
        LOWLT4='>=  '
        UPPLT4='<=  '
        GOTO4400
      ELSEIF(ICASPL.EQ.'GTRA')THEN
        IH='A   '
        IH2='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='B   '
        IH2='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE2,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='C   '
        IH2='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE3,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='D   '
        IH2='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE4,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE5,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='NU1 '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE6,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        IH='NU3 '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,SHAPE7,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IF(SHAPE1.GE.SHAPE2 .OR. SHAPE2.GE.SHAPE3 .OR.
     1     SHAPE3.GE.SHAPE4)THEN
          WRITE(ICOUT,7322)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,7323)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,7324)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,7326)SHAPE1,SHAPE2,SHAPE3,SHAPE4
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
 7322   FORMAT(
     1'***** ERROR--FOR THE GENERALZIED TRAPEZOID DISTRIBUTION,')
 7323   FORMAT(
     1'      THE FOUR SHAPE PARAMETERS (A, B, C, D) MUST SATISFY')
 7324   FORMAT(
     1'         A < B < C < D')
 7326   FORMAT(
     1'      A, B, C, D = ',4G15.7)
C
      ELSEIF(ICASPL.EQ.'TSKE')THEN
        IH='NU  '
        IH2='    '
        ALOWLM=1.0
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        IH21='LAMB'
        IH22='DA  '
        ALOWL2=CPUMIN
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<   '
        GOTO4200
      ELSEIF(ICASPL.EQ.'GOMM')THEN
        IF(IMAKDF.EQ.'DLMF')THEN
          IH='XI  '
          IH2='    '
          ALOWLM=0.0
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<=  '
          IH21='LAMB'
          IH22='DA  '
          ALOWL2=0.0
          AUPPL2=CPUMAX
          LOWLT2='>=  '
          UPPLT2='<=  '
          IH31='THET'
          IH32='A   '
          ALOWL3=0.0
          AUPPL3=CPUMAX
          LOWLT3='>=  '
          UPPLT3='<=  '
          GOTO4300
        ELSEIF(IMAKDF.EQ.'MEEK')THEN
          IH='GAMM'
          IH2='A   '
          ALOWLM=0.0
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<=  '
          IH21='LAMB'
          IH22='DA  '
          ALOWL2=0.0
          AUPPL2=CPUMAX
          LOWLT2='>=  '
          UPPLT2='<=  '
          IH31='K   '
          IH32='    '
          ALOWL3=0.0
          AUPPL3=CPUMAX
          LOWLT3='>   '
          UPPLT3='<=  '
          GOTO4300
        ELSE
          IH='ETA '
          IH2='    '
          ALOWLM=CPUMIN
          AUPPLM=CPUMAX
          LOWLTY='>=  '
          UPPLTY='<=  '
          IH21='ZETA'
          IH22='    '
          ALOWL2=0.0
          AUPPL2=CPUMAX
          LOWLT2='>=  '
          UPPLT2='<=  '
          GOTO4200
        ENDIF
      ELSEIF(ICASPL.EQ.'GIGA')THEN
        IH='LAMB'
        IH2='DA  '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        IF(IGIGDF.EQ.'3PAR')THEN
          IH21='CHI '
          IH22='    '
          ALOWL2=0.0
          AUPPL2=CPUMAX
          LOWLT2='>   '
          IF(ALAMBA.GT.0.0)LOWLTY='>=  '
          UPPLTY='<=  '
          CALL PARCHR(IH,IH2,IDIST,CHI,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
          IH31='PSI '
          IH32='    '
          ALOWL3=0.0
          AUPPL3=CPUMAX
          LOWLT3='>   '
          IF(ALAMBA.LT.0.0)LOWLT3='>=  '
          UPPLT3='<=  '
          CALL PARCHR(IH,IH2,IDIST,PSI,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
          IF(CHI.EQ.0.0 .AND. PSI.EQ.0.0)THEN
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1301)
 1301     FORMAT('***** ERROR-FOR THE GENERALIZED INVERSE GAUSSIAN ',
     1           'PROBABILITY PLOT')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1303)
 1303     FORMAT('      THE CHI AND PSI SHAPE PARAMETERS CANNOT BOTH ',
     1           'BE ZERO.')
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
        ELSE
          IH='OMEG'
          IH2='A   '
          ALOWLM=0.0
          AUPPLM=CPUMAX
          LOWLTY='>=  '
          UPPLTY='<=  '
          GOTO4200
        ENDIF
      ELSEIF(ICASPL.EQ.'GHPP')THEN
        IH='G   '
        IH2='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=   '
        UPPLTY='<=  '
        IH21='H   '
        IH22='    '
        ALOWL2=0.0
        AUPPL2=CPUMAX
        LOWLT2='>=   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'LSNO')THEN
        IH='LAMB'
        IH2='DA  '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=   '
        UPPLTY='<=  '
        IH21='SD  '
        IH22='    '
        ALOWL2=0.0
        AUPPL2=CPUMAX
        LOWLT2='>    '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'LSKT')THEN
        IH='NU  '
        IH2='    '
        ALOWLM=1.0
        AUPPLM=CPUMAX
        LOWLTY='>=   '
        UPPLTY='<=  '
        IH21='LAMB'
        IH22='DA  '
        ALOWL2=CPUMIN
        AUPPL2=CPUMAX
        LOWLT2='>=   '
        UPPLT2='<=  '
        IH31='SD  '
        IH32='    '
        ALOWL3=0.0
        AUPPL3=CPUMAX
        LOWLT3='>    '
        UPPLT3='<=  '
        GOTO4300
      ELSEIF(ICASPL.EQ.'SDEX')THEN
        IH='LAMB'
        IH2='DA  '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<   '
        GOTO4100
      ELSEIF(ICASPL.EQ.'ADEX')THEN
        IF(IADEDF.EQ.'K')THEN
          IH='K   '
          IH2='    '
          ALOWLM=0.0
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<   '
          GOTO4100
        ELSE
          IH='MU  '
          IH2='    '
          ALOWLM=0.0
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<   '
          GOTO4100
        ENDIF
      ELSEIF(ICASPL.EQ.'GALP')THEN
        IF(IADEDF.EQ.'K')THEN
          IH='K   '
          IH2='    '
          ALOWLM=0.0
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<   '
          IH21='TAU '
          IH22='    '
          ALOWL2=0.0
          AUPPL2=CPUMAX
          LOWLT2='>   '
          UPPLT2='<   '
          GOTO4200
        ELSE
          IH='MU  '
          IH2='    '
          ALOWLM=0.0
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<   '
          IH21='TAU '
          IH22='    '
          ALOWL2=0.0
          AUPPL2=CPUMAX
          LOWLT2='>   '
          UPPLT2='<   '
          GOTO4200
        ENDIF
      ELSEIF(ICASPL.EQ.'MCLE')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'GMCL')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='A   '
        IH22='    '
        ALOWL2=-1.0
        AUPPL2=1.0
        LOWLT2='>   '
        UPPLT2='<   '
        GOTO4200
      ELSEIF(ICASPL.EQ.'BEIP' .OR. IDIST.EQ.'BEKP')THEN
        IF(IBEIDF.EQ.'1')THEN
          IH='SIGM'
          IH2='A1SQ'
          ALOWLM=0.0
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<=  '
          IH21='SIGM'
          IH22='A2SQ'
          ALOWL2=0.0
          AUPPL2=CPUMAX
          LOWLT2='>   '
          UPPLT2='<=  '
          IH31='NU  '
          IH32='    '
          ALOWL3=0.0
          AUPPL3=CPUMAX
          LOWLT3='>   '
          UPPLT3='<=  '
          GOTO4300
        ELSE
          IH='B   '
          IH2='    '
          ALOWLM=0.0
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<=  '
          IH21='C   '
          IH22='    '
          ALOWL2=1.0
          AUPPL2=CPUMAX
          LOWLT2='>   '
          UPPLT2='<=  '
          IH31='M   '
          IH32='    '
          ALOWL3=0.5
          AUPPL3=CPUMAX
          LOWLT3='>   '
          UPPLT3='<=  '
          GOTO4300
        ENDIF
      ELSEIF(ICASPL.EQ.'BTAN')THEN
        IH='LAMB'
        IH2='DA  '
        ALOWLM=0.0
        AUPPLM=1.0
        LOWLTY='>   '
        UPPLTY='<   '
        IH21='K   '
        IH22='    '
        ILOWL2=1
        IUPPL2=I1MACH(9)
        LOWLT2='>=  '
        UPPLT2='<=  '
        GOTO4900
      ELSEIF(ICASPL.EQ.'LPOI')THEN
        IH='LAMB'
        IH2='DA  '
        ALOWLM=0.0
        AUPPLM=1.0
        LOWLTY='>   '
        UPPLTY='<   '
        IH21='THET'
        IH22='A   '
        ALOWL2=0.0
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'LBET')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='BETA'
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        IH31='C   '
        IH32='    '
        ALOWL3=0.
        AUPPL3=CPUMAX
        LOWLT3='>   '
        UPPLT3='<=  '
        IH41='D   '
        IH42='    '
        ALOWL4=0.
        AUPPL4=CPUMAX
        LOWLT4='>   '
        UPPLT4='<=  '
        GOTO4400
      ELSEIF(ICASPL.EQ.'SLOP')THEN
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.
        AUPPLM=2.0
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'OGIV')THEN
        IH='N   '
        IH2='    '
        ALOWLM=0.5
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<   '
        GOTO4100
      ELSEIF(ICASPL.EQ.'TSSL')THEN
        IH='THET'
        IH2='A   '
        ALOWLM=A
        AUPPLM=B
        LOWLTY='>=  '
        UPPLTY='<=  '
        IH21='ALPH'
        IH22='A   '
        ALOWL2=0.
        AUPPL2=2.0
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'TSOG')THEN
        IH='THET'
        IH2='A   '
        ALOWLM=A
        AUPPLM=B
        LOWLTY='>=  '
        UPPLTY='<=  '
        IH21='N   '
        IH22='    '
        ALOWL2=0.5
        AUPPL2=CPUMAX
        LOWLT2='>=  '
        UPPLT2='<   '
        GOTO4200
      ELSEIF(ICASPL.EQ.'BUR2' .OR. ICASPL.EQ.'BUR7' .OR.
     1       ICASPL.EQ.'BUR8' .OR. ICASPL.EQ.'BU10' .OR.
     1       ICASPL.EQ.'BU11' .OR. ICASPL.EQ.'SEMC')THEN
        IH='R   '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        GOTO4100
      ELSEIF(ICASPL.EQ.'BUR3' .OR. ICASPL.EQ.'BUR5' .OR.
     1       ICASPL.EQ.'BUR6')THEN
        IH='R   '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='K   '
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'BUR4')THEN
        IH='R   '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='C   '
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'BUR9')THEN
        IH='K   '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='R   '
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'BU12')THEN
        IH='C   '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='K   '
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'DPUN')THEN
        IH='M   '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='N   '
        IH22='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        IH31='ALPH'
        IH32='A   '
        ALOWL3=0.
        AUPPL3=CPUMAX
        LOWLT3='>   '
        UPPLT3='<=  '
        IH41='BETA'
        IH42='    '
        ALOWL4=0.
        AUPPL4=CPUMAX
        LOWLT4='>   '
        UPPLT4='<=  '
        GOTO4400
      ELSEIF(ICASPL.EQ.'NCCS' .OR. ICASPL.EQ.'NCT')THEN
        IH='NU  '
        IH2='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='LAMB'
        IH22='DA  '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>=  '
        UPPLT2='<=  '
        GOTO4200
      ELSEIF(ICASPL.EQ.'EEWE')THEN
        IH='GAMM'
        IH2='A1  '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IH21='SCAL'
        IH22='E1  '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        IH31='GAMM'
        IH32='A2  '
        ALOWL3=0.
        AUPPL3=CPUMAX
        LOWLT3='>   '
        UPPLT3='<=  '
        IH41='SCAL'
        IH42='E2  '
        ALOWL4=0.
        AUPPL4=CPUMAX
        LOWLT4='>   '
        UPPLT4='<=  '
        IF(IEEWLI.EQ.'VARI')THEN
          GOTO4400
        ELSE
          IH51='L   '
          IH52='    '
          ALOWL5=0.
          AUPPL5=CPUMAX
          LOWLT5='>   '
          UPPLT5='<=  '
          GOTO4500
        ENDIF
      ELSEIF(ICASPL.EQ.'UTSP')THEN
        IDIST='UNEVEN TWO-SIDED POWER'
        IH='A   '
        IH2='    '
        IHWUSE='P'
        MESSAG='YES'
        CALL CHECKN(IH,IH2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        A=VALUE(ILOCP)
C
        IH='B   '
        IH2='    '
        IHWUSE='P'
        MESSAG='YES'
        CALL CHECKN(IH,IH2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        B=VALUE(ILOCP)
C
        IH='D   '
        IH2='    '
        IHWUSE='P'
        MESSAG='YES'
        CALL CHECKN(IH,IH2,IHWUSE,
     1  IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1  ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        DZ=VALUE(ILOCP)
C
        IH='ALPH'
        IH2='A   '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,ALPHA,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IH='NU1 '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,ANU1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IH='NU3 '
        IH2='    '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        CALL PARCHR(IH,IH2,IDIST,ANU3,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
        IF(A.GE.B .OR. B.GE.DZ)THEN
          WRITE(ICOUT,7332)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,7333)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,7334)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,7336)A,B,DZ
          CALL DPWRST('XXX','BUG ')
          GOTO9000
        ENDIF
 7332   FORMAT(
     1'***** ERROR--FOR THE UNEVEN TWO-SIDED POWER DISTRIBUTION,')
 7333   FORMAT(
     1'      THE THREE SHAPE PARAMETERS (A, B, D) MUST SATISFY')
 7334   FORMAT(
     1'         A < B < D')
 7336   FORMAT(
     1'      A, B, D = ',3G15.7)
C
      ENDIF
C
      GOTO9000
C
C     THE ONE AND TWO SHAPE PARAMETER CASES ARE THE MOST
C     COMMON.  HANDLE THOSE HERE.
C
C     ONE SHAPE PARAMETER CASE
C
 4100 CONTINUE
      CALL PARCHR(IH,IH2,IDIST,
     1            SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1            ISUBN1,ISUBN2,IERROR)
      IF(ICASPL.EQ.'LOGN' .AND. IERROR.EQ.'YES')THEN
        SHAPE1=1.0
      ELSEIF(ICASPL.EQ.'SEMC' .AND. IERROR.EQ.'YES')THEN
        SHAPE2=1.0
      ENDIF
      GOTO9000
C
C     TWO SHAPE PARAMETER CASE
C
 4200 CONTINUE
      CALL PARCHR(IH,IH2,IDIST,
     1            SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1            ISUBN1,ISUBN2,IERROR)
      IF(ICASPL.EQ.'CONS' .AND. ICONDF.EQ.'THET')AUPPL2=1.0/SHAPE1
      IF(ICASPL.EQ.'FNOR' .AND. IERROR.EQ.'YES')THEN
        SHAPE1=0.0
      ELSEIF(ICASPL.EQ.'TNOR' .AND. IERROR.EQ.'YES')THEN
        SHAPE1=0.0
      ELSEIF(ICASPL.EQ.'FCAU' .AND. IERROR.EQ.'YES')THEN
        SHAPE1=0.0
      ENDIF
      CALL PARCHR(IH21,IH22,IDIST,
     1            SHAPE2,ALOWL2,AUPPL2,LOWLT2,UPPLT2,
     1            ISUBN1,ISUBN2,IERROR)
      IF(ICASPL.EQ.'INGA' .AND. IERROR.EQ.'YES')THEN
        SHAPE2=1.0
      ELSEIF(ICASPL.EQ.'PLGN' .AND. IERROR.EQ.'YES')THEN
        SHAPE2=1.0
      ELSEIF(ICASPL.EQ.'PARE' .AND. IERROR.EQ.'YES')THEN
        SHAPE2=1.0
      ELSEIF(ICASPL.EQ.'PAR2' .AND. IERROR.EQ.'YES')THEN
        SHAPE2=1.0
      ELSEIF(ICASPL.EQ.'FNOR' .AND. IERROR.EQ.'YES')THEN
        SHAPE2=1.0
      ELSEIF(ICASPL.EQ.'TNOR' .AND. IERROR.EQ.'YES')THEN
        SHAPE2=1.0
      ELSEIF(ICASPL.EQ.'FCAU' .AND. IERROR.EQ.'YES')THEN
        SHAPE2=1.0
      ELSEIF(ICASPL.EQ.'GGAM' .AND. SHAPE2.EQ.0.0)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4221)
 4221   FORMAT('***** ERROR IN EXTPA1--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4222)
 4222   FORMAT('      THE SPECIFIED SHAPE PARAMETER C FOR THE ',
     1         'GENERALIZED GAMMA')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4223)
 4223   FORMAT('      DISTRIBUTION CANNOT BE EQUAL TO 0;')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4225)
 4225   FORMAT('      SUCH WAS NOT THE CASE HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4226)C
 4226   FORMAT('      THE SPECIFIED VALUE OF C = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(ICASPL.EQ.'WARI')THEN
        IF(SHAPE1.LE.SHAPE2)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4231)
 4231     FORMAT('***** ERROR IN WARING DISTRIBUTION--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4232)
 4232     FORMAT('      THE VALUE FOR THE SHAPE PARAMETER C IS ',
     1           'LESS THAN OR EQUAL TO')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4233)
 4233     FORMAT('      THE VALUE FOR THE SHAPE PARAMETER A.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4235)SHAPE1
 4235     FORMAT('      THE SPECIFIED VALUE OF C = ',G15.7)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4236)SHAPE2
 4236     FORMAT('      THE SPECIFIED VALUE OF A = ',G15.7)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ENDIF
      GOTO9000
C
C     THREE SHAPE PARAMETER CASE
C
 4300 CONTINUE
      CALL PARCHR(IH,IH2,IDIST,
     1            SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1            ISUBN1,ISUBN2,IERROR)
      CALL PARCHR(IH21,IH22,IDIST,
     1            SHAPE2,ALOWL2,AUPPL2,LOWLT2,UPPLT2,
     1            ISUBN1,ISUBN2,IERROR)
      IF(ICASPL.EQ.'TPAR' .AND. IERROR.EQ.'YES')THEN
        SHAPE2=1.0
      ELSEIF(ICASPL.EQ.'TEXP' .AND. IERROR.EQ.'YES')THEN
        SHAPE2=0.0
      ENDIF
      IF(ICASPL.EQ.'TPAR')ALOWL3=SHAPE2
      IF(ICASPL.EQ.'LKAT')ALOWL3=-SHAPE2
      CALL PARCHR(IH31,IH32,IDIST,
     1            SHAPE3,ALOWL3,AUPPL3,LOWLT3,UPPLT3,
     1            ISUBN1,ISUBN2,IERROR)
      IF(ICASPL.EQ.'TEXP' .AND. IERROR.EQ.'YES')THEN
        SHAPE3=1.0
      ENDIF
      GOTO9000
C
C     FOUR SHAPE PARAMETER CASE
C
 4400 CONTINUE
      CALL PARCHR(IH,IH2,IDIST,
     1            SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1            ISUBN1,ISUBN2,IERROR)
      CALL PARCHR(IH21,IH22,IDIST,
     1            SHAPE2,ALOWL2,AUPPL2,LOWLT2,UPPLT2,
     1            ISUBN1,ISUBN2,IERROR)
      CALL PARCHR(IH31,IH32,IDIST,
     1            SHAPE3,ALOWL3,AUPPL3,LOWLT3,UPPLT3,
     1            ISUBN1,ISUBN2,IERROR)
      CALL PARCHR(IH41,IH42,IDIST,
     1            SHAPE4,ALOWL4,AUPPL4,LOWLT4,UPPLT4,
     1            ISUBN1,ISUBN2,IERROR)
C
      IF(ICASPL.EQ.'TRAP')THEN
        IF(SHAPE1.GE.SHAPE2 .OR. SHAPE2.GE.SHAPE3 .OR.
     1     SHAPE3.GE.SHAPE4)THEN
          WRITE(ICOUT,4412)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4413)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4414)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,4416)SHAPE1,SHAPE2,SHAPE3,SHAPE4
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
 4412   FORMAT(
     1'***** ERROR--FOR THE TRAPEZOID DISTRIBUTION, THE FOUR')
 4413   FORMAT(
     1'      SHAPE PARAMETERS (A, B, C, D) MUST SATISFY')
 4414   FORMAT(
     1'         A < B < C < D')
 4416   FORMAT(
     1'      A, B, C, D = ',4G15.7)
      ENDIF
C
      GOTO9000
C
C     FIVE SHAPE PARAMETER CASE
C
 4500 CONTINUE
      CALL PARCHR(IH,IH2,IDIST,
     1            SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1            ISUBN1,ISUBN2,IERROR)
      CALL PARCHR(IH21,IH22,IDIST,
     1            SHAPE2,ALOWL2,AUPPL2,LOWLT2,UPPLT2,
     1            ISUBN1,ISUBN2,IERROR)
      CALL PARCHR(IH31,IH32,IDIST,
     1            SHAPE3,ALOWL3,AUPPL3,LOWLT3,UPPLT3,
     1            ISUBN1,ISUBN2,IERROR)
      CALL PARCHR(IH41,IH42,IDIST,
     1            SHAPE4,ALOWL4,AUPPL4,LOWLT4,UPPLT4,
     1            ISUBN1,ISUBN2,IERROR)
      CALL PARCHR(IH51,IH52,IDIST,
     1            SHAPE5,ALOWL5,AUPPL5,LOWLT5,UPPLT5,
     1            ISUBN1,ISUBN2,IERROR)
C
      GOTO9000
C
 4900 CONTINUE
      CALL PARCHR(IH,IH2,IDIST,
     1            SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1            ISUBN1,ISUBN2,IERROR)
      CALL PARCHI(IH21,IH22,IDIST,ISHAPE,ILOWL2,IUPPL2,LOWLT2,UPPLT2,
     1            ISUBN1,ISUBN2,IERROR)
      SHAPE2=REAL(ISHAPE)
      GOTO9000
C
 5100 CONTINUE
      CALL PARCHI(IH,IH2,IDIST,ISHAPE,ILOWLM,IUPPLM,LOWLTY,UPPLTY,
     1            ISUBN1,ISUBN2,IERROR)
      SHAPE1=REAL(ISHAPE)
      GOTO9000
C
 5200 CONTINUE
      CALL PARCHI(IH,IH2,IDIST,ISHAPE,ILOWLM,IUPPLM,LOWLTY,UPPLTY,
     1            ISUBN1,ISUBN2,IERROR)
      SHAPE1=REAL(ISHAPE)
      CALL PARCHI(IH21,IH22,IDIST,ISHAPE,ILOWL2,IUPPL2,LOWLT2,UPPLT2,
     1            ISUBN1,ISUBN2,IERROR)
      SHAPE2=REAL(ISHAPE)
      GOTO9000
C
 6999 CONTINUE
      CALL PARCHR(IH,IH2,IDIST,
     1            SHAPE1,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1            ISUBN1,ISUBN2,IERROR)
      GOTO9000
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE EXTPA2(ICASPL,IDIST,A,B,
     1                  SHAP11,SHAP12,SHAP21,SHAP22,
     1                  SHAPE1,SHAPE2,SHAPE3,SHAPE4,SHAPE5,
     1                  IADEDF,IGEPDF,IMAKDF,IBEIDF,
     1                  ILGADF,ISKNDF,IGLDDF,IBGEDF,
     1                  IGETDF,ICONDF,IGOMDF,IKATDF,
     1                  IGIGDF,IGEODF,
     1                  ISUBRO,IBUGG2,IERROR)
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORAOTRY
C                 NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/10
C     ORIGINAL VERSION--OCTOBER   2009.
C     UPDATED         --AUGUST    2010. BRITTLE FIBER WEIBULL
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*30 IDIST
C
      CHARACTER*4 IADEDF
      CHARACTER*4 IGEPDF
      CHARACTER*4 IMAKDF
      CHARACTER*4 IBEIDF
      CHARACTER*4 ILGADF
      CHARACTER*4 ISKNDF
      CHARACTER*4 IGLDDF
      CHARACTER*4 IBGEDF
      CHARACTER*4 IGETDF
      CHARACTER*4 ICONDF
      CHARACTER*4 IGOMDF
      CHARACTER*4 IKATDF
      CHARACTER*4 IGIGDF
      CHARACTER*4 IGEODF
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IBUGG2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 IHP11
      CHARACTER*4 IHP12
      CHARACTER*4 IHP21
      CHARACTER*4 IHP22
      CHARACTER*4 IHP31
      CHARACTER*4 IHP32
      CHARACTER*4 IHP41
      CHARACTER*4 IHP42
      CHARACTER*4 LOWLTY
      CHARACTER*4 UPPLTY
      CHARACTER*4 LOWLT2
      CHARACTER*4 UPPLT2
      CHARACTER*4 LOWLT3
      CHARACTER*4 UPPLT3
      CHARACTER*4 LOWLT4
      CHARACTER*4 UPPLT4
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 ICASEQ
C
      INCLUDE 'DPCOMC.INC'
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
C
C---------------------------------------------------------------------
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C               ***********************************************
C               **  STEP 1--                                 **
C               **  FOR THOSE DISTRIBUTIONS REQUIRING THEM,  **
C               **  DETERMINE IF THE ANALYST                 **
C               **  HAS SPECIFIED PARAMETER VALUES           **
C               ***********************************************
C
      ISUBN1='EXTP'
      ISUBN2='A2  '
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'TPA2')THEN
        ISTEPN='1'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,55)IDIST
   55   FORMAT('AT BEGINNING OF EXTPA2: IDIST = ',A30)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER GAMMA
C
      IF(ICASPL.EQ.'WEIB' .OR. ICASPL.EQ.'IWEI' .OR.
     1   ICASPL.EQ.'3WEI' .OR. ICASPL.EQ.'3IWE' .OR.
     1   ICASPL.EQ.'GAMM' .OR. ICASPL.EQ.'IGAM' .OR.
     1   ICASPL.EQ.'3GAM' .OR. ICASPL.EQ.'3IGA' .OR.
     1   ICASPL.EQ.'LGAM' .OR. ICASPL.EQ.'GPAR' .OR.
     1   ICASPL.EQ.'GEEX' .OR. ICASPL.EQ.'FATL' .OR.
     1   ICASPL.EQ.'WALD' .OR. ICASPL.EQ.'EV2 ' .OR.
     1   ICASPL.EQ.'DWEI' .OR. ICASPL.EQ.'GEV ' .OR.
     1   ICASPL.EQ.'GHLO' .OR. ICASPL.EQ.'DGAM' .OR.
     1   ICASPL.EQ.'PEA3' .OR. ICASPL.EQ.'BFWE' .OR.
     1   ICASPL.EQ.'PARE' .OR. ICASPL.EQ.'PAR2'
     1 )THEN
C
        IHP11='GAMM'
        IHP12='A1  '
        IHP21='GAMM'
        IHP22='A2  '
        LOWLTY='>   '
        UPPLTY='<=  '
        ALOWLM=0.
        AUPPLM=CPUMAX
        ADEF1=1.0
        ADEF2=50.0
C
        IF(ICASPL.EQ.'WEIB')THEN
          IDIST='WEIBULL'
        ELSEIF(ICASPL.EQ.'3WEI')THEN
          IDIST='3-PARAMETER WEIBULL'
        ELSEIF(ICASPL.EQ.'GAMM')THEN
          IDIST='GAMMA'
          ADEF1=0.5
          ADEF2=25.0
        ELSEIF(ICASPL.EQ.'3GAM')THEN
          IDIST='3-PARAMETER GAMMA'
          ADEF1=0.5
          ADEF2=25.0
        ELSEIF(ICASPL.EQ.'IGAM')THEN
          IDIST='INVERTED GAMMA'
          ADEF1=0.5
          ADEF2=25.0
        ELSEIF(ICASPL.EQ.'3IGA')THEN
          IDIST='3-PARAMETER INVERTED GAMMA'
          ADEF1=0.5
          ADEF2=25.0
        ELSEIF(ICASPL.EQ.'LGAM')THEN
          IDIST='LOG GAMMA'
          ADEF1=0.5
          ADEF2=25.0
        ELSEIF(ICASPL.EQ.'IWEI')THEN
          IDIST='INVERTED WEIBULL'
          ADEF1=0.5
          ADEF2=10.0
        ELSEIF(ICASPL.EQ.'3IWE')THEN
          IDIST='3-PARAMETER INVERTED WEIBULL'
          ADEF1=0.5
          ADEF2=10.0
        ELSEIF(ICASPL.EQ.'GPAR')THEN
          IDIST='GENERALIZED PARETO'
          ALOWLM=CPUMIN
          ADEF1=-3.0
          ADEF2=3.0
        ELSEIF(ICASPL.EQ.'GEEX')THEN
          IDIST='GEOMETRIC EXTREME EXPONENTIAL'
          ADEF1=0.1
          ADEF2=10.0
        ELSEIF(ICASPL.EQ.'FATL')THEN
          IDIST='FATIGUE LIFE'
        ELSEIF(ICASPL.EQ.'WALD')THEN
          IDIST='WALD'
          ADEF1=0.5
          ADEF2=25.0
        ELSEIF(ICASPL.EQ.'EV2 ')THEN
          IDIST='FRECHET'
          ADEF1=-25.0
          ADEF2=25.0
        ELSEIF(ICASPL.EQ.'PARE' .OR. ICASPL.EQ.'PAR2')THEN
          ADEF1=0.2
          ADEF2=5.0
          IDIST='PARETO'
          IF(ICASPL.EQ.'PAR2')IDIST='PARETO SECOND KIND'
C
C         FOR PARETO, SET VALUE FOR A
C
          IHP31='A   '
          IHP32='    '
          ALOWLM=0.0
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<=  '
          ADEF3=1.0
          CALL PARCH2(IHP31,IHP32,IDIST,SHAPE2,ADEF3,ALOWLM,AUPPLM,
     1              LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
          IF(SHAPE2.LE.0.0)SHAPE2=1.0
C
        ELSEIF(ICASPL.EQ.'BFWE')THEN
          IDIST='BRITTLE FIBER WEIBULL'
C
C         FOR BRITTLE FIBER WEIBULL, SET VALUE FOR L
C
          IHP31='L   '
          IHP32='    '
          ALOWLM=0.0
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<=  '
          ADEF3=1.0
          CALL PARCH2(IHP31,IHP32,IDIST,SHAPE2,ADEF3,ALOWLM,AUPPLM,
     1              LOWLTY,UPPLTY,
     1              ISUBN1,ISUBN2,IERROR)
          IF(SHAPE2.LE.0.0)SHAPE2=ADEF3
        ELSEIF(ICASPL.EQ.'DWEI')THEN
          IDIST='DOUBLE WEIBULL'
          ADEF1=0.5
          ADEF2=10.0
        ELSEIF(ICASPL.EQ.'DGAM')THEN
          IDIST='DOUBLE GAMMA'
          ADEF1=0.5
          ADEF2=10.0
        ELSEIF(ICASPL.EQ.'GEV ')THEN
          IDIST='GENERALIZED EXTREME VALUE'
          ALOWLM=CPUMIN
          ADEF1=-5.0
          ADEF2=5.0
        ELSEIF(ICASPL.EQ.'GHLO')THEN
          IDIST='GENERALIZED HALF LOGISTIC'
          AUPPLM=5.0
          ADEF1=0.1
          ADEF2=2.5
        ELSEIF(ICASPL.EQ.'PEA3')THEN
          IDIST='PEARSON TYPE 3'
          ALOWLM=CPUMIN
          AUPPLM=CPUMAX
          ADEF1=-10.0
          ADEF2=10.0
        ENDIF
        GOTO4100
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER SIGMA
C
      ELSEIF(ICASPL.EQ.'LOGN')THEN
        IDIST='LOGNORMAL'
        IHP11='SIGM'
        IHP12='A1  '
        IHP21='SIGM'
        IHP22='A2  '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        ADEF1=0.5
        ADEF2=25.0
        GOTO4100
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER LAMBDA
C
      ELSEIF(ICASPL.EQ.'TULA' .OR. ICASPL.EQ.'SDEX' .OR.
     1       ICASPL.EQ.'SNOR' .OR. ICASPL.EQ.'POIS' .OR.
     1       ICASPL.EQ.'BTAN')THEN
C
        IHP11='LAMB'
        IHP12='DA1 '
        IHP21='LAMB'
        IHP22='DA2 '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        IF(ICASPL.EQ.'TULA')THEN
          IDIST='TUKEY-LAMBDA'
          ADEF1=-2.0
          ADEF2=2.0
        ELSEIF(ICASPL.EQ.'SDEX')THEN
          IDIST='SKEW DOUBLE EXPONENTIAL'
          ADEF1=0.0
          ADEF2=10.0
        ELSEIF(ICASPL.EQ.'SNOR')THEN
          IDIST='SKEW NORMAL'
          ADEF1=-5.0
          ADEF2=5.0
        ELSEIF(ICASPL.EQ.'POIS')THEN
          IDIST='POISSON'
          ADEF1=1.0
          ADEF2=50.0
        ELSEIF(ICASPL.EQ.'BTAN')THEN
          IDIST='BOREL-TANNER'
          IHP21='K   '
          IHP22='    '
          ILOWL2=1
          IUPPL2=I1MACH(9)
          LOWLT2='>=  '
          UPPLT2='<=  '
          CALL PARCHI(IHP21,IHP22,IDIST,K,ILOWL2,IUPPL2,
     1                LOWLT2,UPPLT2,
     1                ISUBN1,ISUBN2,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
          SHAPE2=REAL(K)
          ALOWLM=0.0
          AUPPLM=1.0
          LOWLTY='>   '
          UPPLTY='<   '
          ADEF1=0.2
          ADEF2=0.95
        ENDIF
        GOTO4100
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER NU
C
      ELSEIF(ICASPL.EQ.'TPP' .OR. ICASPL.EQ.'CHIS' .OR.
     1       ICASPL.EQ.'CHI ' .OR. ICASPL.EQ.'FT  ')THEN
C
        IHP11='NU1 '
        IHP12='    '
        IHP21='NU2 '
        IHP22='    '
        ALOWLM=1.
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        ADEF1=1.0
        ADEF2=50.0
        IF(ICASPL.EQ.'TPP')IDIST='T'
        IF(ICASPL.EQ.'CHIS')IDIST='CHI-SQUARE'
        IF(ICASPL.EQ.'CHI ')IDIST='CHI'
        IF(ICASPL.EQ.'FT  ')IDIST='FOLDED T'
        GOTO4100
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER BETA
C
      ELSEIF(ICASPL.EQ.'BRAD' .OR. ICASPL.EQ.'TOPL' .OR.
     1       ICASPL.EQ.'PEXP' .OR. ICASPL.EQ.'MUTH' .OR.
     1       ICASPL.EQ.'LEXP')THEN
        IHP11='BETA'
        IHP12='1   '
        IHP21='BETA'
        IHP22='2   '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        ADEF1=0.1
        ADEF2=10.0
        IF(ICASPL.EQ.'BRAD')THEN
          IDIST='BRADFORD'
          ADEF1=0.5
          ADEF2=25.0
        ELSEIF(ICASPL.EQ.'TOPL')THEN
          IDIST='TOPP AND LEONE'
        ELSEIF(ICASPL.EQ.'PEXP')THEN
          IDIST='EXPONENTIAL POWER'
          ADEF1=0.5
          ADEF2=10.0
        ELSEIF(ICASPL.EQ.'MUTH')THEN
          IDIST='MUTH'
          ADEF1=0.0
          ADEF2=1.0
          AUPPLM=1.0
          LOWLTY='>=  '
        ELSEIF(ICASPL.EQ.'LEXP')THEN
          IDIST='LOGISTIC-EXPONENTIAL'
        ENDIF
        GOTO4100
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER B
C
      ELSEIF(ICASPL.EQ.'RECI' .OR. ICASPL.EQ.'VONM')THEN
        IHP11='B1  '
        IHP12='    '
        IHP21='B2  '
        IHP22='    '
        ALOWLM=1.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        ADEF1=1.5
        ADEF2=20.0
        IF(ICASPL.EQ.'RECI')THEN
          IDIST='RECIPROCAL'
        ELSEIF(ICASPL.EQ.'VONM')THEN
          IDIST='VON MISES'
          ALOWLM=0.0
          LOWLTY='>=  '
          ADEF1=0.5
          ADEF2=25.0
        ENDIF
        GOTO4100
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER ALPHA
C
      ELSEIF(ICASPL.EQ.'ERRO' .OR. ICASPL.EQ.'LLAP' .OR.
     1       ICASPL.EQ.'GLOG' .OR. ICASPL.EQ.'G2LO' .OR.
     1       ICASPL.EQ.'G3LO' .OR. ICASPL.EQ.'G5LO' .OR.
     1       ICASPL.EQ.'SLOP' .OR. ICASPL.EQ.'ALPH' .OR.
     1       ICASPL.EQ.'MCLE' .OR. ICASPL.EQ.'LDEX' .OR.
     1       ICASPL.EQ.'ZETA' .OR. ICASPL.EQ.'ZIPF')THEN
        IHP11='ALPH'
        IHP12='A1  '
        IHP21='ALPH'
        IHP22='A2  '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        ADEF1=0.1
        ADEF2=10.0
        IF(ICASPL.EQ.'ERRO')THEN
          IDIST='ERROR'
          ALOWLM=1.
          ADEF1=1.1
          ADEF2=5.0
        ELSEIF(ICASPL.EQ.'LLAP' .OR. ICASPL.EQ.'LDEX')THEN
          IDIST='LOG LAPLACE'
          ADEF1=0.5
          ADEF2=10.0
        ELSEIF(ICASPL.EQ.'GLOG')THEN
          IDIST='GENERALIZED LOGISTIC'
          ALOWLM=0.1
          ADEF1=0.2
          ADEF2=5.0
        ELSEIF(ICASPL.EQ.'G2LO')THEN
          IDIST='GENERALIZED LOGISTIC TYPE 2'
        ELSEIF(ICASPL.EQ.'G3LO')THEN
          IDIST='GENERALIZED LOGISTIC TYPE 3'
        ELSEIF(ICASPL.EQ.'G5LO')THEN
          IDIST='GENERALIZED LOGISTIC TYPE 5'
          ALOWLM=CPUMIN
          ADEF1=-2.0
          ADEF2=2.0
        ELSEIF(ICASPL.EQ.'SLOP')THEN
          IDIST='SLOPE'
          LOWLTY='>=  '
          AUPPLM=2.0
          ADEF1=0.1
          ADEF2=1.99
        ELSEIF(ICASPL.EQ.'ALPH')THEN
          IDIST='ALPHA'
          ADEF1=0.5
          ADEF2=10.0
        ELSEIF(ICASPL.EQ.'MCLE')THEN
          IDIST='MCLEISH'
          ADEF1=1.0
          ADEF2=15.5
        ELSEIF(ICASPL.EQ.'ZETA')THEN
          IDIST='ZETA'
          ALOWLM=1.0
          AUPPLM=CPUMAX
          ADEF1=1.5
          ADEF2=5.0
        ELSEIF(ICASPL.EQ.'ZIPF')THEN
          IDIST='ZIPF'
          IHP21='N   '
          IHP22='    '
          ILOWL2=1
          IUPPL2=I1MACH(9)
          LOWLT2='>=  '
          UPPLT2='<=  '
          CALL PARCHI(IHP21,IHP22,IDIST,NU,ILOWL2,IUPPL2,LOWLT2,UPPLT2,
     1                ISUBN1,ISUBN2,IERROR)
          SHAPE2=REAL(NU)
          IF(IERROR.EQ.'YES')GOTO9000
        ENDIF
        GOTO4100
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER C
C
      ELSEIF(ICASPL.EQ.'TRIA' .OR. ICASPL.EQ.'POWF'.OR.
     1       ICASPL.EQ.'RFPP')THEN
        IHP11='C1  '
        IHP12='    '
        IHP21='C2  '
        IHP22='    '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        ADEF1=0.5
        ADEF2=25.0
        IF(ICASPL.EQ.'TRIA')THEN
          IDIST='TRIANGULAR'
          ALOWLM=CPUMIN
          AUPPLM=CPUMAX
          LOWLTY='>=  '
          UPPLTY='<=  '
          ADEF1=A
          ADEF2=B
        ELSEIF(ICASPL.EQ.'POWF')THEN
          IDIST='POWER'
        ELSEIF(ICASPL.EQ.'RPOW')THEN
          IDIST='REFLECTED POWER'
        ENDIF
        GOTO4100
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER P
C
      ELSEIF(ICASPL.EQ.'POWN' .OR. ICASPL.EQ.'WCAU' .OR.
     1       ICASPL.EQ.'GEOM' .OR. ICASPL.EQ.'BINO' .OR.
     1       ICASPL.EQ.'YULE' .OR. ICASPL.EQ.'LOST')THEN
        IHP11='P1  '
        IHP12='    '
        IHP21='P2  '
        IHP22='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        IF(ICASPL.EQ.'POWN')THEN
          IDIST='POWER NORMAL'
          ADEF1=1.0
          ADEF2=50.0
        ELSEIF(ICASPL.EQ.'WCAU')THEN
          IDIST='WRAPPED CAUCHY'
          AUPPLM=1.0
          ADEF1=0.0
          ADEF2=0.99
          LOWLTY='>=  '
          UPPLTY='<   '
        ELSEIF(ICASPL.EQ.'GEOM')THEN
          IDIST='GEOMETRIC'
          ALOWLM=0.0
          AUPPLM=1.0
          LOWLTY='>   '
          UPPLTY='<   '
          ADEF1=0.01
          ADEF2=0.99
        ELSEIF(ICASPL.EQ.'YULE')THEN
          IDIST='YULE'
          ALOWLM=0.3
          AUPPLM=CPUMAX
          LOWLTY='>   '
          UPPLTY='<   '
          ADEF1=0.5
          ADEF2=5.0
        ELSEIF(ICASPL.EQ.'BINO')THEN
          IDIST='BINOMIAL'
          ALOWLM=0.0
          AUPPLM=1.0
          LOWLTY='>   '
          UPPLTY='<   '
          ADEF1=0.01
          ADEF2=0.99
          IHP21='N   '
          IHP22='    '
          ILOWLM=1
          IUPPLM=I1MACH(9)
          LOWLT2='>=  '
          UPPLT2='<=  '
          CALL PARCHI(IHP21,IHP22,IDIST,NBINOM,ILOWLM,IUPPLM,
     1                LOWLT2,UPPLT2,
     1                ISUBN1,ISUBN2,IERROR)
          SHAPE2=REAL(NBINOM)
          IF(IERROR.EQ.'YES')GOTO9000
        ELSEIF(ICASPL.EQ.'LOST')THEN
          IDIST='LOST GAMES'
          ALOWLM=0.5
          AUPPLM=1.0
          LOWLTY='>   '
          UPPLTY='<   '
          ADEF1=0.51
          ADEF2=0.95
          IHP21='R   '
          IHP22='    '
          ILOWLM=1
          IUPPLM=I1MACH(9)
          LOWLT2='>=  '
          UPPLT2='<=  '
          CALL PARCHI(IHP21,IHP22,IDIST,IR,ILOWLM,IUPPLM,
     1                LOWLT2,UPPLT2,
     1                ISUBN1,ISUBN2,IERROR)
          SHAPE2=REAL(IR)
          IF(IERROR.EQ.'YES')GOTO9000
        ENDIF
        GOTO4100
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER DELTA
C
      ELSEIF(ICASPL.EQ.'LOGL')THEN
        IDIST='LOG-LOGISTIC'
        IHP11='DELT'
        IHP12='A1  '
        IHP21='DELT'
        IHP22='A2  '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        ADEF1=0.2
        ADEF2=25.0
        GOTO4100
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER K
C
      ELSEIF(ICASPL.EQ.'ADEX' .AND. IADEDF.EQ.'K')THEN
        IDIST='ASYMMETRIC LAPLACE'
        IHP11='K1  '
        IHP12='    '
        IHP21='K2  '
        IHP22='    '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<   '
        ADEF1=0.2
        ADEF2=10.0
        GOTO4100
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER MU
C
      ELSEIF(ICASPL.EQ.'ADEX' .AND. IADEDF.EQ.'MU')THEN
        IHP11='MU1 '
        IHP12='    '
        IHP21='MU2 '
        IHP22='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<   '
        ADEF1=-5.0
        ADEF2=5.0
        GOTO4100
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER N
C
      ELSEIF(ICASPL.EQ.'OGIV')THEN
        IDIST='OGIVE'
        IHP11='N1  '
        IHP12='    '
        IHP21='N2  '
        IHP22='    '
        ALOWLM=0.5
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        ADEF1=0.51
        ADEF2=10.0
        GOTO4100
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER R
C
      ELSEIF(ICASPL.EQ.'BUR2' .OR. ICASPL.EQ.'BUR7' .OR.
     1       ICASPL.EQ.'BUR8' .OR. ICASPL.EQ.'BU10' .OR.
     1       ICASPL.EQ.'BU11')THEN
        IHP11='R1  '
        IHP12='    '
        IHP21='R2  '
        IHP22='    '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        ADEF1=0.5
        ADEF2=10.0
        IDIST='BURR TYPE 2'
        IF(ICASPL.EQ.'BUR7')IDIST='BURR TYPE 7'
        IF(ICASPL.EQ.'BUR8')IDIST='BURR TYPE 8'
        IF(ICASPL.EQ.'BU10')IDIST='BURR TYPE 10'
        IF(ICASPL.EQ.'BU11')IDIST='BURR TYPE 11'
        GOTO4100
C
C     DISTRIBUTIONS WITH SINGLE SHAPE PARAMETER THETA
C
      ELSEIF(ICASPL.EQ.'LOGS')THEN
        IHP11='THET'
        IHP12='A1  '
        IHP21='THET'
        IHP22='A2  '
        ALOWLM=0.
        AUPPLM=1.0
        LOWLTY='>   '
        UPPLTY='<   '
        ADEF1=0.05
        ADEF2=0.95
        IDIST='LOGARITHMIC SERIES'
        GOTO4100
C
C     DISTRIBUTIONS WITH TWO SHAPE PARAMETERS G AND H
C
      ELSEIF(ICASPL.EQ.'GHPP')THEN
        IHP11='G1  '
        IHP12='    '
        IHP21='G2  '
        IHP22='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=   '
        UPPLTY='<=  '
        ADEF1=-1.0
        ADEF2=1.0
        IHP31='H1  '
        IHP32='    '
        IHP41='H2  '
        IHP42='    '
        ALOWL2=0.0
        AUPPL2=CPUMAX
        LOWLT2='>=   '
        UPPLT2='<=  '
        ADEF3=0.0
        ADEF4=1.0
        IDIST='G-H'
        GOTO4200
C
C     DISTRIBUTIONS WITH TWO SHAPE PARAMETERS LAMBDA3 AND LAMBDA4
C
      ELSEIF(ICASPL.EQ.'GTLA')THEN
        IHP11='LAMB'
        IHP12='DA31'
        IHP21='LAMB'
        IHP22='DA32'
        IHP31='LAMB'
        IHP32='DA41'
        IHP41='LAMB'
        IHP42='DA42'
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=   '
        UPPLTY='<=  '
        ADEF1=-5.0
        ADEF2=5.0
        ALOWL2=CPUMIN
        AUPPL2=CPUMAX
        LOWLT2='>=   '
        UPPLT2='<=  '
        ADEF3=-5.0
        ADEF4=5.0
        IDIST='GENERALIZED TUKEY-LAMBDA'
        GOTO4200
C
C     DISTRIBUTIONS WITH TWO SHAPE PARAMETERS NU1 AND NU2
C
      ELSEIF(ICASPL.EQ.'FPP')THEN
        IHP11='NU11'
        IHP12='    '
        IHP21='NU12'
        IHP22='    '
        IHP31='NU21'
        IHP32='    '
        IHP41='NU22'
        IHP42='    '
        ALOWLM=1.0
        AUPPLM=REAL(I1MACH(9))
        LOWLTY='>=  '
        UPPLTY='<=  '
        ADEF1=1.0
        ADEF2=25.0
        ALOWL2=1.0
        AUPPL2=REAL(I1MACH(9))
        LOWLT2='>=  '
        UPPLT2='<=  '
        ADEF3=1.0
        ADEF4=25.0
        IDIST='F '
        GOTO4200
C
C     DISTRIBUTIONS WITH TWO SHAPE PARAMETERS GAMMA AND MU
C
      ELSEIF(ICASPL.EQ.'INGA' .OR. ICASPL.EQ.'RIGA')THEN
        IHP11='GAMM'
        IHP12='A1  '
        IHP21='GAMM'
        IHP22='A2  '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        ADEF1=0.5
        ADEF2=25.0
        IHP31='MU1 '
        IHP32='    '
        IHP41='MU2 '
        IHP42='    '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        ADEF3=0.5
        ADEF4=25.0
        IDIST='INVERSE GAUSSIAN'
        IF(ICASPL.EQ.'RIGA')IDIST='RECIPROCAL INVERSE GAUSSIAN'
        GOTO4200
C
C     DISTRIBUTIONS WITH TWO SHAPE PARAMETERS GAMMA AND THETA
C
      ELSEIF(ICASPL.EQ.'EWEI')THEN
        IHP11='GAMM'
        IHP12='A1  '
        IHP21='GAMM'
        IHP22='A2  '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        ADEF1=0.5
        ADEF2=5.0
        IHP31='THET'
        IHP32='A1  '
        IHP41='THET'
        IHP42='A2  '
        ALOWL2=0.
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        ADEF3=0.5
        ADEF4=5.0
        IDIST='EXPONENTIATED WEIBULL'
        GOTO4200
C
C     DISTRIBUTIONS WITH TWO SHAPE PARAMETERS ALPHA AND BETA
C
      ELSEIF(ICASPL.EQ.'BETA' .OR. ICASPL.EQ.'IBET' .OR.
     1       ICASPL.EQ.'BNOR' .OR. ICASPL.EQ.'KUMA' .OR.
     1       ICASPL.EQ.'KATZ' .OR.
     1       ICASPL.EQ.'RGTL' .OR. ICASPL.EQ.'GTOL' .OR.
     1       ICASPL.EQ.'BBIN' .OR. ICASPL.EQ.'BGEO')THEN
C
        IHP11='ALPH'
        IHP12='A1  '
        IHP21='ALPH'
        IHP22='A2  '
        ALOWLM=0.0
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        ADEF1=0.5
        ADEF2=5.0
        IHP31='BETA'
        IHP32='1   '
        IHP41='BETA'
        IHP42='2   '
        ALOWL2=0.0
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        ADEF3=0.5
        ADEF4=5.0
        IDIST='BETA'
        IF(ICASPL.EQ.'IBET')IDIST='INVERTED BETA'
        IF(ICASPL.EQ.'BNOR')IDIST='BETA NORMAL'
        IF(ICASPL.EQ.'KUMA')IDIST='KUMARASWAMY'
        IF(ICASPL.EQ.'RGTL')THEN
          IDIST='REFLECTED GENERALIZED TOPP LEONE'
          ALOWLM=0.0
          AUPPLM=2.0
          ADEF1=0.1
          ADEF2=2.0
          ADEF3=0.5
          ADEF4=10.0
        ELSEIF(ICASPL.EQ.'GTOL')THEN
          IDIST='GENERALIZED TOPP LEONE'
          ALOWLM=0.0
          AUPPLM=2.0
          ADEF1=0.1
          ADEF2=2.0
          ADEF3=0.5
          ADEF4=10.0
        ELSEIF(ICASPL.EQ.'KATZ')THEN
          IDIST='KATZ'
          ADEF1=0.1
          ADEF2=10.0
          ALOWL2=CPUMIN
          AUPPL2=1.0
          LOWLT2='>   '
          UPPLT2='<   '
          ADEF3=-3.0
          ADEF4=0.95
        ELSEIF(ICASPL.EQ.'BBIN')THEN
          IDIST='BETA-BINOMIAL'
          IHP31='N   '
          IHP32='    '
          ILOWLM=1
          IUPPLM=I1MACH(9)
          LOWLTY='>=  '
          UPPLTY='<=  '
          CALL PARCHI(IHP31,IHP32,IDIST,NU,ILOWLM,IUPPLM,LOWLTY,UPPLTY,
     1                ISUBN1,ISUBN2,IERROR)
          SHAPE3=REAL(NU)
          IF(IERROR.EQ.'YES')GOTO9000
C
        ELSEIF(ICASPL.EQ.'BGEOM')THEN
          IDIST='BETA-GEOMETRIC'
        ENDIF
        GOTO4200
C
C     DISTRIBUTIONS WITH TWO SHAPE PARAMETERS ALPHA AND C
C
      ELSEIF(ICASPL.EQ.'GGAM')THEN
        IHP11='ALPH'
        IHP12='A1  '
        IHP21='ALPH'
        IHP22='A2  '
        ALOWLM=0.
        AUPPLM=CPUMAX
        LOWLTY='>   '
        UPPLTY='<=  '
        ADEF1=0.5
        ADEF2=5.0
        IHP31='C1  '
        IHP32='    '
        IHP41='C2  '
        IHP42='    '
        ALOWL2=CPUMIN
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        ADEF3=0.1
        ADEF4=3.0
        IDIST='GENERALIZED GAMMA'
        GOTO4200
C
C     DISTRIBUTIONS WITH TWO SHAPE PARAMETERS MU AND SD
C
      ELSEIF(ICASPL.EQ.'FNOR' .OR. ICASPL.EQ.'FCAU' .OR.
     1       ICASPL.EQ.'TNOR')THEN
        IHP11='MU1 '
        IHP12='    '
        IHP21='MU2 '
        IHP22='    '
        ALOWLM=CPUMIN
        AUPPLM=CPUMAX
        LOWLTY='>=  '
        UPPLTY='<=  '
        ADEF1=-25.0
        ADEF2=25.0
        IHP31='SD1 '
        IHP32='    '
        IHP41='SD2 '
        IHP42='    '
        ALOWL2=0.0
        AUPPL2=CPUMAX
        LOWLT2='>   '
        UPPLT2='<=  '
        ADEF3=0.5
        ADEF4=25.0
        IDIST='FOLDED NORMAL'
        IF(ICASPL.EQ.'FCAU')IDIST='FOLDED CAUCHY'
        IF(ICASPL.EQ.'TNOR')IDIST='TRUNCATED NORMAL'
        GOTO4200
C
C     DISTRIBUTIONS WITH TWO SHAPE PARAMETERS THETA AND N
C
      ELSEIF(ICASPL.EQ.'TSPO' .OR. ICASPL.EQ.'TSOG')THEN
        IHP11='TH