# Sponsoring tiers

We offer a range of sponsoring tiers tailored to the diverse needs of our
community. Whether you're an individual user, or rooted in academia, or work in
an organization using our software commercially, there's a sponsoring tier
that suits your needs.

## Choosing a tier

Choosing the right sponsoring tier depends on your needs and how you intend to
use Material for MkDocs Insiders. Our tiers are categorized into [non-commercial]
and [commercial] use:

  - __Non-commercial tiers__: Intended for individuals, Open Source projects,
    and academic use
  - __Commercial tiers__: Designed for organizations and enterprises of any size

Each [monthly sponsoring tier] offers a range of benefits tailored to your needs.
Benefits include access to our private Material for MkDocs Insiders repository,
priority handling of bug reports, and more, which vary by the number of
projects[^1] that you intend to build with it and collaborators required.
Remember, you can always [upgrade or downgrade] your
sponsorship level at any time.

  [^1]:
    A project is defined as a folder with a `mkdocs.yml` configuration file
    that is built with Material for MkDocs Insiders. This is the only limitation
    to follow – the number of documentation pages or the size of your project
    is up to you.

  [monthly sponsoring tier]: #monthly-sponsoring
  [non-commercial]: #non-commercial-use
  [commercial]: #commercial-use
  [upgrade or downgrade]: #switching-tiers

## Monthly sponsoring

Monthly sponsoring tiers provide you with access to our private Material for
MkDocs Insiders repository. Your financial contribution supports the ongoing
development of both the Insiders and the community edition.

### Non-commercial use

Non-commercial use essentially means "personal use". This includes individuals
using the Insiders edition for personal or purely non-commercial Open Source
projects. We offer two different tiers for non-commercial use.

---

#### The Individual

You love Material for MkDocs and use it for your Open Source project or personal
blog. You read about all the awesome features in Insiders, which are first
exclusively released to sponsors, and don't want to miss out.

__Rewards:__

  - :material-door-open: Access to Insiders
  - :material-charity: Non-commercial use for __1-2 projects__

[&nbsp; Sponsor with __$15 a month__ <span class="mdx-sponsorship-count" data-mdx-component="sponsorship-count"></span>][15 a month]{ .md-button .md-button--primary .mdx-sponsorship-button }

  [15 a month]: https://github.com/sponsors/squidfunk/sponsorships?tier_id=210638

---

#### The Dedicated Individual

You use Material for MkDocs for several of your Open Source projects or personal
sites, and just love that you can build beautiful documentation without having
to worry about the constantly breaking JavaScript ecosystem – this is now
[@squidfunk's] job.

  [@squidfunk's]: https://github.com/squidfunk

__Rewards:__

  - :material-door-open: Access to Insiders
  - :material-charity: Non-commercial use for __3+ projects__

[&nbsp; Sponsor with __$35 a month__ <span class="mdx-sponsorship-count" data-mdx-component="sponsorship-count"></span>][35 a month]{ .md-button .md-button--primary .mdx-sponsorship-button }

  [35 a month]: https://github.com/sponsors/squidfunk/sponsorships?tier_id=210641

---

### Commercial use

Commercial use refers to any use of our software for a business or for-profit
purpose. This includes any use by a corporation or other organization, whether
or not they generate revenue directly from the software. We offer different
pricing tiers for commercial use, each tailored to the needs of different
businesses. It's important to note that internal use of the software within your
organization is also considered commercial use, as with all commercial software.

---

#### The Organization :star:

Your organization uses Material for MkDocs for its documentation or internal
knowledge base and wants to make sure that it is well-maintained and safe to use
for the years to come. You agree that $125 a month (less than 1 hour of a
skilled developer) is a clever investment into a solution, solving tons of
problems you don't want to fight yourself.

__Rewards:__

  - :material-door-open: Access to Insiders
  - :material-currency-usd: Commercial use for __1-9 projects__
  - :material-run-fast: Your bug reports are __prioritized__
  - :material-star: Backlink + placement of __small logo__

[&nbsp; Sponsor with __$125 a month__ <span class="mdx-sponsorship-count" data-mdx-component="sponsorship-count"></span>][125 a month]{ .md-button .md-button--primary .mdx-sponsorship-button }

  [125 a month]: https://github.com/sponsors/squidfunk/sponsorships?tier_id=210643

---

#### The Global Organization :star::star:

Your organization runs many internal and public-facing sites that are built with
Material for MkDocs, helping you to share and manage knowledge efficiently.
You've evaluated several commercial alternatives which will cost you 3-4x more,
some of which with a smaller feature set. You agree that $250 a month (less than
2 hours of a skilled developer) is a very good deal for the value you're getting
out of it.

__Rewards:__

  - :material-door-open: Access to Insiders
  - :material-currency-usd: Commercial use for __10-49 projects__
  - :material-run-fast: Your bug reports are __prioritized__
  - :material-star: Backlink + placement of __logo__

[&nbsp; Sponsor with __$250 a month__ <span class="mdx-sponsorship-count" data-mdx-component="sponsorship-count"></span>][250 a month]{ .md-button .md-button--primary .mdx-sponsorship-button }

  [250 a month]: https://github.com/sponsors/squidfunk/sponsorships?tier_id=181282

---

#### The Holistic Organization :star::star::star:

Your organization's day-to-day operations critically depend on Material for
MkDocs, and you need to make sure that bugs are fixed quickly to keep your
customers happy. You see your work as part of a larger ecosystem, realizing that
giving back is essential to keeping everything you fight for alive.

__Rewards:__

  - :material-door-open: Access to Insiders
  - :material-currency-usd: Commercial use for __50+ projects__
  - :material-run-fast: Your bug reports are __prioritized__
  - :material-star: Backlink + placement of __large logo__
  - :material-face-agent: Private __email support__

[&nbsp; Sponsor with __$1,000 a month__ <span class="mdx-sponsorship-count" data-mdx-component="sponsorship-count"></span>][1000 a month]{ .md-button .md-button--primary .mdx-sponsorship-button }

  [1000 a month]: https://github.com/sponsors/squidfunk/sponsorships?tier_id=334388

---

## One-time sponsoring

For those who wish to contribute one-time without an ongoing subscription and
without receiving access to the exclusive Insiders features, we offer the
following one-time sponsoring tiers.

---

### Just a Tip! :money_with_wings:

You asked a question or needed some help on a problem, and we've helped you
quickly. You want no perks, just good karma and a warm feeling of giving
something back.

[&nbsp; Sponsor __$20 one-time__ <span class="mdx-sponsorship-count" data-mdx-component="sponsorship-count"></span>][20 one-time]{ .md-button .md-button--primary .mdx-sponsorship-button }

  [20 one-time]: https://github.com/sponsors/squidfunk/sponsorships?tier_id=222886

---

### The Mentoring

A 1-hour video call with [@squidfunk], the creator and core maintainer of the
project. He is happy to share his experiences with you and help you with
anything related to his work.

__Popular topics are:__

  - How to tailor Material for MkDocs to your needs
  - How to start earning a living in Open Source
  - How to make your Open Source project sustainable

  [@squidfunk]: https://github.com/squidfunk

[&nbsp; Sponsor __$350 one-time__ <span class="mdx-sponsorship-count" data-mdx-component="sponsorship-count"></span>][350 one-time]{ .md-button .md-button--primary .mdx-sponsorship-button }

  [350 one-time]: https://github.com/sponsors/squidfunk/sponsorships?tier_id=210891

---

## Custom amount

You're invited to contribute custom sponsorship amounts via GitHub Sponsors,
enabling you to support Material for MkDocs according to your preferences.
Please be aware that individuals need to pledge a minimum of $15 a month to
access Insiders, whereas organizations are encouraged to sponsor $125 a month or
more, based on their requirements.

Contributions exceeding these thresholds are highly appreciated. Please note
that one-time donations, regardless of their size, won't be granted access to
Insiders due to technical constraints.

## Switching tiers

You can easily switch between different sponsorship tiers — [upgrade] or
[downgrade] — at any time. Simply visit the @squidfunk's
[GitHub Sponsors profile] and adjust your sponsorship tier selection. Once
you've made the change, you'll immediately sponsor at the new tier.

If you exceed the number of projects within your current sponsorship limit, we
kindly request that you upgrade your sponsorship to a higher tier to retain
access to Material for MkDocs Insiders. The change takes effect immediately,
and the amount is prorated based on your [billing cycle].

  [upgrade]: https://docs.github.com/en/billing/managing-billing-for-github-sponsors/upgrading-a-sponsorship
  [downgrade]: https://docs.github.com/en/billing/managing-billing-for-github-sponsors/downgrading-a-sponsorship
  [billing cycle]: https://docs.github.com/en/github/setting-up-and-managing-billing-and-payments-on-github/changing-the-duration-of-your-billing-cycle
  [GitHub Sponsors profile]: https://github.com/sponsors/squidfunk
