# -*- coding: utf-8 -*-
from setuptools import setup

setup(
    name='hatchling',
    version='%%PORTVERSION%%',
    description='Modern, extensible Python build backend',
    long_description='# Hatchling\n\n-----\n\nThis is the extensible, standards compliant build backend used by [Hatch](https://github.com/ofek/hatch).\n',
    author_email='Ofek Lev <oss@ofek.dev>',
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.10',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: Implementation :: CPython',
        'Programming Language :: Python :: Implementation :: PyPy',
        'Topic :: Software Development :: Build Tools',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ],
    install_requires=[
        'editables>=0.3; python_version > "3"',
        'importlib-metadata; python_version < "3.8"',
        'packaging>=21.3; python_version > "3"',
        'packaging~=20.9; python_version < "3"',
        'pathspec>=0.9',
        'pluggy>=1.0.0; python_version > "3"',
        'pluggy~=0.13; python_version < "3"',
        'tomli>=1.2.2; python_version > "3" and python_version < "3.11"',
        'toml~=0.10.2; python_version < "3"',
    ],
    entry_points={
        'console_scripts': [
            'hatchling = hatchling.cli:hatchling',
        ],
    },
    packages=[
        'hatchling',
        'hatchling.bridge',
        'hatchling.builders',
        'hatchling.builders.hooks',
        'hatchling.builders.hooks.plugin',
        'hatchling.builders.plugin',
        'hatchling.cli',
        'hatchling.cli.build',
        'hatchling.cli.dep',
        'hatchling.cli.metadata',
        'hatchling.cli.version',
        'hatchling.dep',
        'hatchling.licenses',
        'hatchling.metadata',
        'hatchling.metadata.plugin',
        'hatchling.plugin',
        'hatchling.utils',
        'hatchling.version',
        'hatchling.version.scheme',
        'hatchling.version.scheme.plugin',
        'hatchling.version.source',
        'hatchling.version.source.plugin',
    ],
    package_dir={
        '': 'src',
    },
)
