#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "interface.h"

#include "treedata.h"

int mark_nodes_on_way_down(n)
treenode n;
{
	list t;

	if(ndta(n)->selected)
		ndta(n)->td->tmp=2;
	else if(treeleaf(n))
		ndta(n)->td->tmp=0;
	else
	{
		ndta(n)->td->tmp=0;
		tforsubtree(n, t)
			if(mark_nodes_on_way_down(subtree(t)))
				ndta(n)->td->tmp++;
	}
	return(ndta(n)->td->tmp);
}

treenode find_subtree_over_one(n)
treenode n;
{
	list t;
	treenode c;

	if(ndta(n)->td->tmp>1)
		/* this is it */
		c=n;
	else if(ndta(n)->td->tmp==1)
	{
		/* find the one below this one */
		tforsubtree(n, t)
			if((c=find_subtree_over_one(subtree(t)))!=NULL)
				break;
	}
	else
		/* barking up the wrong tree  :)  */
		c=NULL;
	return(c);
}

treenode common_ancestor_of_selected_nodes(t)
tree t;
{
	treenode n;

	mark_nodes_on_way_down(treeroot(t));
	n=find_subtree_over_one(treeroot(t));
	return(n);
}

int select_common_ancestor(t)
tree t;
{
	treenode n;

	n=common_ancestor_of_selected_nodes(t);
	if(n==NULL)
		return(0);
	add_to_selection(n, SubtreeSel, 1, 0.0);
	return(1);
}

int mark_connecting_nodes_and_branches(n)
treenode n;
{
	list t;
	treebranch b;
	int keepforbelow;

	keepforbelow=0;
	startlist(n->branches);
	while((b=listnext(n->branches))!=NULL)
	{
		if(b->up==n)
		{
			if(mark_connecting_nodes_and_branches(b->down))
			{
				keepforbelow=1;
				bdta(b)->selected=1;
				bdta(b)->percentage=.5;
			}
		}
	}
	if(keepforbelow)
		ndta(n)->selected=1;
	return(ndta(n)->selected);
}

int connect_selections(t)
tree t;
{
	treenode n;

	canvas_add_tree(t);
	n=common_ancestor_of_selected_nodes(t);
	mark_connecting_nodes_and_branches(n);
	set_selection_type();
	return(1);
}

int mark_nodes_to_keep(n)
treenode n;
{
	list t;
	int keepforbelow;

	keepforbelow=0;
	tforsubtree(n, t)
		if(mark_nodes_to_keep(subtree(t)))
			keepforbelow=1;
	if(keepforbelow)
		ndta(n)->selected=1;
	return(ndta(n)->selected);
}

remove_nodes_not_to_be_kept(n)
treenode n;
{
	list t;
	treenode child;

	firstsubtree(n, &t);
	while(t!=NULL)
	{
		child=subtree(t);
		nextsubtree(n, &t);
		if(!ndta(child)->selected)
		{
			/* remove subtree */
			removesubtree(n, child);
			freesubtree(child);
		}
		else
			remove_nodes_not_to_be_kept(child);
	}
}

remove_all_but_selected_nodes(t)
tree t;
{
	mark_nodes_to_keep(treeroot(t));
	remove_nodes_not_to_be_kept(treeroot(t));
}

int prune_to_representatives(t)
tree t;
{
	treenode n;

	canvas_add_tree(t);
	/*remove_selections_on_tree(t);*/
	remove_all_but_selected_nodes(t);
	invalidate_spacing(t, Flower);
	invalidate_spacing(t, Boxed);
	invalidate_refit(t, Flower);
	invalidate_refit(t, Boxed);
	add_to_selection(treeroot(t), SubtreeSel, 1, 0.0);
	modify();
}

int change_outgroup_at_selection()
{
    static treenode n, newroot, pn, top;
	static tree t;
	static treebranch b;
	static double p;
	static int result;
	static double tx, ty;


	result=get_one_selection(BranchPointSel, &b, &p);
	switch(result)
	{
		case -1:
			tterr("Must select a Branch Point to Change Outgroup to",
				BeepMessage);
			result=0;
			break;
		case 0:
			tterr("Must select a Branch Point to Change Outgroup to",
				BeepMessage);
			result=0;
			break;
		case 1:
			n=b->down;
			pn=b->up;
			t=tree_get_tree(b);

			/* the path from b to top will be affected by change_outgroup */
			if(treechildren(treeroot(t))==2)
			{
				static treenode last;

				top=b->up;
				last=b->down;
				while(top!=treeroot(t))
				{
					last=top;
					top=parent(top);
				}
				top=last;
			}
			else
				top=treeroot(t);
			/* will use the original x,y to reposition the flower tree */
			tx=ndta(treeroot(t))->flower->x;
			ty=ndta(treeroot(t))->flower->y;
			/* change outgroup */
			newroot=(treenode)change_outgroup(n, p);
			if(newroot==NULL)
				result=0;
			else
			{
				static treenode i, j;
				static double px, py, dx, dy, nx, ny;
				static list l;

				/* adjust angles for flower */
				for(i=top;i!=newroot;i=j)
				{
					j=parent(i);
					if(j==newroot)
					{
						/* make this node point in opposite direction
							from other child of root */
						/* find node on other side of root */
						tforsubtree(j, l)
							if(subtree(l)!=i)
								break;
						ndta(i)->flower->a=ndta(subtree(l))->flower->a+M_PI;
					}
					else
						/* flip direction of node */
						ndta(i)->flower->a=ndta(j)->flower->a+M_PI;
					norm_angle(ndta(i)->flower->a);
				}
				/* find position of new root */
				px=ndta(pn)->flower->x;
				py=ndta(pn)->flower->y;
				dx=ndta(n)->flower->x-ndta(pn)->flower->x;
				dy=ndta(n)->flower->y-ndta(pn)->flower->y;
				nx=px+p*dx;
				ny=py+p*dy;
				ndta(newroot)->flower->x=nx;
				ndta(newroot)->flower->y=ny;
				/* find distance from old root */
				dx=(nx-tx)*tdta(t)->flower->tscalex;
				dy=(ny-ty)*tdta(t)->flower->tscaley;
				ndta(newroot)->flower->a=0.0;
				choose_positions(newroot);
				/* move flower back to original position */
				tdta(t)->flower->tx+=dx;
				tdta(t)->flower->ty+=dy;
				canvas_add_tree(t);
				invalidate_format(t, Boxed);
				invalidate_format(t, Flower);
				invalidate_spacing(t, Boxed);
				invalidate_spacing(t, Flower);
				invalidate_refit(t, Boxed);
				invalidate_refit(t, Flower);
				remove_selections_on_tree(t);
				result=1;
			}
			break;
		case 2:
			tterr("Must select one Branch Point to Change Outgroup to",
				BeepMessage);
			result=0;
			break;
		default:
			result=0;
			break;
	}
	modify();
	return(result);
}

int merge_mergeable_node(n, ty)
treenode n;
tree_type ty;
{
	static treenode newnode;
	static nodetypedata nd;
	static treetypedata btd, ftd;
	static double bx, by, fx, fy, dx, dy;

	if(n==treeroot(tree_get_tree(n)))
	{
		nd=tndta(n, Boxed);
		bx=nd->x;
		by=nd->y;
		nd=tndta(n, Flower);
		fx=nd->x;
		fy=nd->y;
		btd=ttdta(tree_get_tree(n), Boxed);
		ftd=ttdta(tree_get_tree(n), Flower);
	}
	else
		btd=NULL;

	if((newnode=(treenode)merge_branch(n))!=NULL)
	{
		canvas_add_tree(tree_get_tree(n));

		if(btd!=NULL)
		{
			nd=tndta(newnode, Boxed);
			dx=nd->x-bx;
			dy=nd->y-by;
			/*btd->tx+=dx;*/
			/*btd->ty+=dy;*/
			nd=tndta(newnode, Flower);
			dx=nd->x-fx;
			dy=nd->y-fy;
			/*ftd->tx+=dx;*/
			/*ftd->ty+=dy;*/
		}

		invalidate_format(tree_get_tree(n), Flower);
		invalidate_format(tree_get_tree(n), Boxed);


		invalidate_spacing(tree_get_tree(n), Flower);
		invalidate_spacing(tree_get_tree(n), Boxed);
		invalidate_refit(tree_get_tree(n), Flower);
		invalidate_refit(tree_get_tree(n), Boxed);

		canvas_add_tree(tree_get_tree(n));

		add_to_selection(NULL, NoSel, 0, 0.0);
		modify();
		return(1);
	}
	else
		return(0);
}
