#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* infonode.c:
 *
 * manages the window for modifying node attributes.  You can change the node
 * font (font name, style, and size), and color
 */

#include "interface.h"

#include "treedata.h"

static tframe info;
static tpanel p;
static tpchoice nm, sm, zm;
static tpmsg msg;
static tpmsg spacer;
static tpbutton colorb;
static tcolorchooser c;
static tpmsg fontmsg, stylemsg, sizemsg;

int node_info_pick_font(m, mi, e)
	/* callback for menus that change the font.  Just calls the SetNodeFont
	 * command (see command.c) on every node currently selected */
tpmenu m;
tpitem mi;
tevent e;
{
	tfont tmp;

	seteventloc(e);
	tfont_grey_menus(nm, sm, zm);
	tmp=(tfont)tfont_get_selected_font(globals->c, nm, sm, zm);
	do_command(EveryNode, NULL, tmp, 0.0, 0.0,
		0, 0, 0, 0, SetNodeFont);
	return(1);
}

node_choose_color(red, green, blue)
	/* callback for changing the node color.  Just calls SetNodeColor on
	 * every selected node */
unsigned short red, green, blue;
{
	tcolor n;

	n=tcolor_new(globals->c, NULL, red, green, blue);
	do_command(EveryNode, NULL, n, 0.0, 0.0,
		0, 0, 0, 0, SetNodeColor);
	tcolor_hide_chooser(c);
}

int node_show_color_chooser(b, e)
tpbutton b;
tevent e;
{
	seteventloc(e);
	tcolor_move_chooser(c, globals->ewin, globals->ex, globals->ey);
	tcolor_show_chooser(c);
}

int node_hide_color_chooser()
{
	if(globals->depth>1)
		tcolor_hide_chooser(c);
}

int create_node_info_frame(parent, args)
tframe parent;
targs args;
{
    info=tframe_new(parent, 580,100,50,50,0,1,0,
		"Treetool:Node Settings", args);
    if(info==NULL)
	return(0);
    p=tframe_dialog_panel(info);
    if(p==NULL)
	return(0);

	colorb=tpbutton_new(p, 10, 10, 0, 0, NULL, NULL, "Change Color...");
	if(globals->depth>1)
		c=(tcolorchooser)tcolor_new_chooser(parent, args, node_choose_color,
			"Choose a Node Color");
	else
		tpbutton_disable(colorb);
	tpbutton_set_event_procedure(colorb, node_show_color_chooser);
	spacer=(tpmsg)tpmsg_new(p, 10, 10, 0, 0, NULL, colorb, "  ");
    msg=(tpmsg)tpmsg_new(p, 10, 10, 0, 0, NULL, spacer,
		"Node Label:                                    ");
    nm=tfont_make_name_choicemenu(p,
		70,0,0,0,NULL,msg,globals->name,node_info_pick_font);
    sm=tfont_make_style_choicemenu(p,
		70,0,0,0,NULL,nm,globals->style,node_info_pick_font);
    zm=tfont_make_size_choicemenu(p,
		70,0,0,0,NULL,sm,globals->size,node_info_pick_font);
	fontmsg=tpmsg_new(p, 30, 0, 0, 0, NULL, msg, "Font:");
	stylemsg=tpmsg_new(p, 30, 0, 0, 0, NULL, nm, "Style:");
	sizemsg=tpmsg_new(p, 30, 0, 0, 0, NULL, sm, "Size:");
    /* make color picker */
    tpanel_fit(p);
    tframe_fit(info);
    tframe_hide(info);
    return(1);
}

int update_node_info_frame(n)
	/* changes the font menus and color chooser to reflect the attributes
	 * of the specified node */
treenode n;
{
    tfont_set_selection(ndta(n)->td->font,nm,sm,zm);
	if(globals->depth>1)
		tcolor_change_chooser_color(c, ndta(n)->td->c);
}

int show_node_info_frame()
{
	moveframetoloc(info);
    tframe_show(info);
}

int hide_node_info_frame()
{
    tframe_hide(info);
	if(globals->depth>1)
		tcolor_hide_chooser(c);
}

node_busy()
{
	if(info!=NULL)
		tframe_set_busy(info);
}

node_notbusy()
{
	if(info!=NULL)
		tframe_set_notbusy(info);
}

grey_node_info(numtrees, clip, multi, subtrees, nodes, branches)
	/* greys the font menus and color chooser, depending on if any nodes
	 * are selected or not.  If there are no nodes selected, the buttons
	 * are greyed since they don't apply */
int numtrees, clip, multi, subtrees, nodes, branches;
{
	if(nodes || subtrees)
	{
		if(globals->depth>1)
			tpbutton_enable(colorb);
		tpchoice_enable(nm);
		tpchoice_enable(sm);
		tpchoice_enable(zm);
	}
	else
	{
		if(globals->depth>1)
			tpbutton_disable(colorb);
		tpchoice_disable(nm);
		tpchoice_disable(sm);
		tpchoice_disable(zm);
	}
}
