package test.contrib;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceEbonyTheme;

public class TableSelectionFlicker {

	JFrame frame;
	private JTable table;
	private DefaultTableModel model;

	public TableSelectionFlicker() {
		frame = new JFrame();
		frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		frame.setLayout(new GridBagLayout());
		table = new JTable();
		model = new DefaultTableModel();
		model.addColumn("Column 1");
		model.addColumn("Column 2");
		model.addColumn("Column 3");
		for (int i = 0; i < 20; i++) {
			model
					.addRow(new String[] { "col1 " + i, "col2 " + i,
							"col3 " + i });
		}
		table.setModel(model);
		table.getSelectionModel().addSelectionInterval(10, 10);

		JScrollPane sp = new JScrollPane();
		sp.setViewportView(table);
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.fill = GridBagConstraints.BOTH;
		gridBagConstraints.weightx = 1.0;
		gridBagConstraints.weighty = 1.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
		frame.getContentPane().add(sp, gridBagConstraints);

		JButton bt = new JButton("Change Table");
		bt.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				changeTable();
			}
		});

		gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.anchor = GridBagConstraints.EAST;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
		frame.getContentPane().add(bt, gridBagConstraints);
		frame.pack();
	}

	private void changeTable() {
		new Thread(new Runnable() {
			public void run() {
				for (int i = 0; i < model.getRowCount(); i++) {
					model.setValueAt(
							Thread.currentThread().getName() + " " + i, i, 1);
					try {
						Thread.sleep(200);
					} catch (InterruptedException e) {
					}
				}
			}
		}).start();
	}

	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {

			public void run() {
				try {

					UIManager
							.setLookAndFeel("org.jvnet.substance.skin.SubstanceRavenGraphiteGlassLookAndFeel");
					SubstanceLookAndFeel
							.setCurrentTheme(new SubstanceEbonyTheme());
					TableSelectionFlicker sb = new TableSelectionFlicker();
					sb.frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}
}