package test;

import java.awt.Dimension;
import java.awt.FlowLayout;

import javax.swing.*;
import javax.swing.border.EmptyBorder;

import org.jvnet.substance.SubstanceLookAndFeel;

public class ToggleNoMinSize extends JFrame {
	public ToggleNoMinSize() {
		super("Toggle min size");
		this.setLayout(new FlowLayout());
		this.setSize(new Dimension(400, 200));
		this.setLocationRelativeTo(null);

		JToggleButton jtb1 = new JToggleButton("t1");
		jtb1.putClientProperty(
				SubstanceLookAndFeel.BUTTON_NO_MIN_SIZE_PROPERTY, Boolean.TRUE);
		this.add(jtb1);
		JToggleButton jtb2 = new JToggleButton("t2");
		jtb2.setBorder(new EmptyBorder(0, 0, 0, 0));
		this.add(jtb2);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new ToggleNoMinSize().setVisible(true);
			}
		});
	}

}
