/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package test;

import java.awt.*;
import java.util.Map;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.ThemeInfo;

/**
 * Image creator demo.
 * 
 * @author Kirill Grouchnikov
 */
public class SchemeCreatorDemo {

	public static final int COLOR_CELL = 30;

	public static final int NAME_CELL = 120;

	private static final class SchemeCreatorFrame extends JFrame {
		/**
		 * Simple constructor. Creates all the icons.
		 */
		public SchemeCreatorFrame() {
			// int width = COLOR_CELL * 6 + NAME_CELL;
			// int height = COLOR_CELL * ColorSchemeEnum.values().length;
			// Dimension dim = new Dimension(width, height);
			// this.setPreferredSize(dim);
			// this.setSize(dim);

			this.setLayout(new BorderLayout());
			this.add(new SchemeCreatorPanel(), BorderLayout.CENTER);

			// this.setResizable(false);
		}
	}

	/**
	 * Demo frame.
	 * 
	 * @author Kirill Grouchnikov
	 */
	private static final class SchemeCreatorPanel extends JPanel {
		/**
		 * Simple constructor. Creates all the icons.
		 */
		public SchemeCreatorPanel() {
			int width = 2 * (COLOR_CELL * 6 + NAME_CELL);
			int height = 1 + (COLOR_CELL * SubstanceLookAndFeel.getAllThemes()
					.size()) / 2;
			Dimension dim = new Dimension(width, height);
			this.setPreferredSize(dim);
			this.setMinimumSize(dim);
			this.setSize(dim);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see java.awt.Component#paint(java.awt.Graphics)
		 */
		public final void paint(Graphics g) {
			try {
				int width = this.getWidth();
				int height = this.getHeight();
				g.setColor(Color.white);
				g.fillRect(0, 0, width, height);
				int count = 0;
				for (Map.Entry<String, ThemeInfo> schemeEntry : SubstanceLookAndFeel
						.getAllThemes().entrySet()) {
					String name = schemeEntry.getKey();
					SubstanceTheme theme = (SubstanceTheme) Class.forName(
							schemeEntry.getValue().getClassName())
							.newInstance();
					ColorScheme scheme = theme.getColorScheme();

					g.setColor(Color.BLACK);
					g.setFont(new Font("Arial", Font.BOLD, 14));

					int deltaX = (count % 2 == 0) ? 0 : getWidth() / 2;

					g
							.drawString(name, deltaX + 5, (1 + (count / 2))
									* COLOR_CELL
									- (COLOR_CELL - g.getFontMetrics()
											.getHeight()) / 2);

					int x = NAME_CELL + deltaX;
					int y = (count / 2) * COLOR_CELL;

					g.setColor(scheme.getUltraLightColor());
					g.fillRect(x, y, COLOR_CELL, COLOR_CELL);
					x += COLOR_CELL;

					g.setColor(scheme.getExtraLightColor());
					g.fillRect(x, y, COLOR_CELL, COLOR_CELL);
					x += COLOR_CELL;

					g.setColor(scheme.getLightColor());
					g.fillRect(x, y, COLOR_CELL, COLOR_CELL);
					x += COLOR_CELL;

					g.setColor(scheme.getMidColor());
					g.fillRect(x, y, COLOR_CELL, COLOR_CELL);
					x += COLOR_CELL;

					g.setColor(scheme.getDarkColor());
					g.fillRect(x, y, COLOR_CELL, COLOR_CELL);
					x += COLOR_CELL;

					g.setColor(scheme.getUltraDarkColor());
					g.fillRect(x, y, COLOR_CELL, COLOR_CELL);

					count++;
				}
				g.setColor(new Color(128, 128, 128));
				g.drawLine(0, 0, width - 1, 0);
				g.drawLine(0, height - 1, width - 1, height - 1);
				g.drawLine(0, 0, 0, height - 1);
				g.drawLine(width - 1, 0, width - 1, height - 1);

				for (count = 0; count < SubstanceLookAndFeel.getAllThemes()
						.size(); count++) {
					int yPos = COLOR_CELL * count;
					g.drawLine(0, yPos, width - 1, yPos);
				}

				for (count = 0; count < 6; count++) {
					int xPos = NAME_CELL + count * COLOR_CELL;
					g.drawLine(xPos, 0, xPos, height - 1);
				}
				for (count = 0; count < 6; count++) {
					int xPos = NAME_CELL + count * COLOR_CELL;
					g.drawLine(width / 2 + xPos, 0, width / 2 + xPos,
							height - 1);
				}
			} catch (Exception exc) {
				exc.printStackTrace();
			}
		}
	}

	/**
	 * Main function for running <code>this</code> demo.
	 * 
	 * @param args
	 */
	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		SchemeCreatorFrame icf = new SchemeCreatorFrame();
		icf.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		icf.pack();
		icf.setVisible(true);
	}
}
