/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.theme;

import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.utils.AbstractTraitInfo;

/**
 * Information on a single theme. This class is part of officially supported
 * API.
 * 
 * @author Kirill Grouchnikov
 */
public class ThemeInfo extends AbstractTraitInfo {
	/**
	 * The kind of <code>this</code> theme.
	 */
	private SubstanceTheme.ThemeKind themeKind;

	/**
	 * Simple constructor.
	 * 
	 * @param themeDisplayName
	 *            Display name of <code>this</code> theme.
	 * @param themeClassName
	 *            Class name of <code>this</code> theme.
	 * @param themeKind
	 *            Kind of <code>this</code> theme.
	 */
	public ThemeInfo(String themeDisplayName, String themeClassName,
			ThemeKind themeKind) {
		super(themeDisplayName, themeClassName);
		this.themeKind = themeKind;
	}

	/**
	 * Returns the class name of <code>this</code> theme.
	 * 
	 * @return The class name of <code>this</code> theme.
	 * @deprecated Use {@link #getClassName()}.
	 */
	public String getThemeClassName() {
		return this.getClassName();
	}

	/**
	 * Returns the display name of <code>this</code> theme.
	 * 
	 * @return The display name of <code>this</code> theme.
	 * @deprecated Use {@link #getDisplayName()}.
	 */
	public String getThemeDisplayName() {
		return this.getDisplayName();
	}

	/**
	 * Returns the kind of <code>this</code> theme.
	 * 
	 * @return The kind of <code>this</code> theme.
	 */
	public SubstanceTheme.ThemeKind getThemeKind() {
		return this.themeKind;
	}
}
