// File:	StepToGeom_MakeConic2d.cxx
// Created:	Fri Aug 26 11:38:37 1994
// Author:	Frederic MAUPAS
//		<fma@minox>
//:p0 abv 19.02.99: management of 'done' flag improved

#include <StepToGeom_MakeConic2d.ixx>
#include <StdFail_NotDone.hxx>
#include <StepToGeom_MakeConic2d.hxx>
#include <StepGeom_Conic.hxx>
#include <StepGeom_Circle.hxx>
#include <StepGeom_Ellipse.hxx>
#include <StepGeom_Hyperbola.hxx>
#include <StepGeom_Parabola.hxx>
#include <StepToGeom_MakeCircle2d.hxx>
#include <StepToGeom_MakeEllipse2d.hxx>
#include <StepToGeom_MakeHyperbola2d.hxx>
#include <StepToGeom_MakeParabola2d.hxx>

//=============================================================================
// Creation d' une Conic de Geom2d a partir d' une Conic de Step
//=============================================================================

StepToGeom_MakeConic2d::StepToGeom_MakeConic2d ( const Handle(StepGeom_Conic)& C)
{
  done = Standard_False;
  if (C->IsKind(STANDARD_TYPE(StepGeom_Circle))) {
    Handle(StepGeom_Circle) Cir = Handle(StepGeom_Circle)::DownCast(C);
    StepToGeom_MakeCircle2d MkCircle2d(Cir);
    if ( MkCircle2d.IsDone() ) theConic = MkCircle2d.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_Ellipse))) {
    Handle(StepGeom_Ellipse) Ell = Handle(StepGeom_Ellipse)::DownCast(C);
    StepToGeom_MakeEllipse2d MkEllipse2d(Ell);
    if ( MkEllipse2d.IsDone() ) theConic = MkEllipse2d.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_Hyperbola))) {
    Handle(StepGeom_Hyperbola) Hyp = Handle(StepGeom_Hyperbola)::DownCast(C);
    StepToGeom_MakeHyperbola2d MkHyperbola2d(Hyp);
    if ( MkHyperbola2d.IsDone() ) theConic = MkHyperbola2d.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_Parabola))) {
    Handle(StepGeom_Parabola) Par = Handle(StepGeom_Parabola)::DownCast(C);
    StepToGeom_MakeParabola2d MkParabola2d(Par);
    if ( MkParabola2d.IsDone() ) theConic = MkParabola2d.Value();
  }
  // Attention : Other conic shall be implemented !
  done = ! theConic.IsNull();
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom2d_Conic) &
      StepToGeom_MakeConic2d::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theConic;
}
