/* MDESAB.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"

/* Subroutine */ int mmdesab_(ndimen, ncourb, ncoefs, hdecal, tasemh, dimvec, 
	vecsol, tabcbr, iercod)
integer *ndimen, *ncourb, *ncoefs, *hdecal, *tasemh, *dimvec;
doublereal *vecsol, *tabcbr;
integer *iercod;
{
    /* System generated locals */
    integer tasemh_dim1, tasemh_offset, tabcbr_dim1, tabcbr_dim2, 
	    tabcbr_offset, i__1, i__2, i__3;

    /* Local variables */
    static logical ldbg;
    static integer iaux, d__, e, i__, ig;
    extern integer mnfndeb_();
    extern /* Subroutine */ int maermsg_(), mgenmsg_(), mgsomsg_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*       DESASSEMBLAGE DES COURBE */

/*     MOTS CLES : */
/*     ----------- */
/*      RESERVE, LISSAGE, DESASSAMBLAGE, COURBE */

/*     ARGUMENTS D'ENTREE : */
/*     -------------------- */
/*       NDIMEN: DIMENSION DE L'ESPACE */
/*       NCOURB: NOMBRE DE COURBES */
/*       NCOEFS: Ordre de la super courbe */
/*       HDECAL: DECALAGE PERMETTANT DE CALCULER LES INDICES */
/*               DE STOCKAGE POUR LES AUTRES COMPOSANTS (Y,Z) */
/*       TASEMH: TABLE D'ASSENMBLAGE DE LA MATRICE HESSIENNE */
/*       DIMVEC: DIMENSION DU VECTEUR VECSOL */
/*       VECSOL: VECTEUR SOLUTION AVANT DESASSEMBLAGE */


/*     ARGUMENTS DE SORTIE : */
/*     --------------------- */
/*       NCFTAB : Le nombre de coefficients de chaque courbe */
/*       TABCBR : TABLE DES COEFFICIENTS DE LA COURBE PLOLYNOMIALE */
/*               PAR MORCEAUX */
/*       IERCOD : CODE D'ERREUR */
/*     COMMONS UTILISES : */
/*     ------------------ */


/*     REFERENCES APPELEES : */
/*     --------------------- */


/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */


/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*      4-10-1995: PMN/KHN; ECRITURE VERSION ORIGINALE. */
/* > */
/* ***********************************************************************
 */
/*                            DECLARATIONS */
/* ***********************************************************************
 */



/* ***********************************************************************
 */
/*                      INITIALISATIONS */
/* ***********************************************************************
 */

    /* Parameter adjustments */
    tabcbr_dim1 = *ndimen;
    tabcbr_dim2 = *ncoefs;
    tabcbr_offset = tabcbr_dim1 * (tabcbr_dim2 + 1) + 1;
    tabcbr -= tabcbr_offset;
    tasemh_dim1 = *ncourb;
    tasemh_offset = tasemh_dim1 + 1;
    tasemh -= tasemh_offset;
    --vecsol;

    /* Function Body */
    ldbg = mnfndeb_() >= 2;
    if (ldbg) {
	mgenmsg_("MMDESAB", 7L);
    }
    *iercod = 0;

/* ***********************************************************************
 */
/*                     TRAITEMENT */
/* ***********************************************************************
 */

/*    Desamblage */


    i__1 = *ndimen;
    for (d__ = 1; d__ <= i__1; ++d__) {
	iaux = *hdecal * (d__ - 1);
	i__2 = *ncourb;
	for (e = 1; e <= i__2; ++e) {
	    i__3 = *ncoefs;
	    for (i__ = 1; i__ <= i__3; ++i__) {
		ig = tasemh[e + i__ * tasemh_dim1] + iaux;
		tabcbr[d__ + (i__ + e * tabcbr_dim2) * tabcbr_dim1] = vecsol[
			ig];
	    }
	}
    }

    goto L9999;

/* ***********************************************************************
 */
/*                   TRAITEMENT DES ERREURS */
/* ***********************************************************************
 */


/* ***********************************************************************
 */
/*                   RETOUR PROGRAMME APPELANT */
/* ***********************************************************************
 */

L9999:


    maermsg_("MMDESAB", iercod, 7L);
    if (ldbg) {
	mgsomsg_("MMDESAB", 7L);
    }
 return 0 ;
} /* mmdesab_ */

