// Macros to access Default Trace  for Interface
// These are abbreviated definitions to call class methods
// See also class Interface_TraceFile for complete definition

// IDT_Level allows to access Default Trace Level and IDT_SetLevel to change it
// IDT_Out   can be used exactly as an OStream&, like cout : IDT_Out<<...
// IDT_OutRef(sout)  declares a variable OStream&, as the Default Trace Output
//           sout can then be used like cout : sout<<...
// IDT_NewFile(name) [New File] and IDT_SetFile(name) [Append to File else New]
//           declare <name> as beeing the output file for Default Trace
// IDT_NewFile and IDT_SetFile return a Boolean, True if success, False else
// IDT_SetStandard() declares the Standard Output (cout) as beeing Trace output

#include <Interface_TraceFile.hxx>

#define IDT_Level           Interface_TraceFile::DefLevel()
#define IDT_SetLevel(level) Interface_TraceFile::SetDefLevel(level)
#define IDT_Out             Interface_TraceFile::Def()
#define IDT_OutRef(sout)    Standard_OStream& sout = Interface_TraceFile::Def()
#define IDT_NewFile(name)   Interface_TraceFile::SetDef(name,Standard_True)
#define IDT_SetFile(name)   Interface_TraceFile::SetDef(name,Standard_False)
#define IDT_SetStandard     Interface_TraceFile::SetDefStandard
