/* MA2CFV.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"

/* Subroutine */ int mma2cfv_(ndvjac, mindgu, maxdgu, nbpntv, gssvtb, chpair, 
	chimpr, patjac)
integer *ndvjac, *mindgu, *maxdgu, *nbpntv;
doublereal *gssvtb, *chpair, *chimpr, *patjac;
{
    /* System generated locals */
    integer chpair_dim1, chpair_offset, chimpr_dim1, chimpr_offset, 
	    patjac_offset, i__1, i__2;

    /* Local variables */
    static logical ldbg;
    static integer nptv2, ii, jj;
    extern integer mnfndeb_();
    extern /* Subroutine */ int mgenmsg_();
    static doublereal bid1;
    extern /* Subroutine */ int mgsomsg_();






/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*     Calcul des coefficients de l' approximation polynomiale de F(u,v) 
*/
/*     de degre NDVJAC en V et de degre en U variant de MINDGU a MAXDGU. 
*/

/*     MOTS CLES : */
/*     ----------- */
/*     FONCTION,APPROXIMATION,COEFFICIENT,POLYNOME */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*   NDVJAC: Degre du polynome d' approximation en V. */
/*           La representation dans la base orthogonale part du degre */
/*           0. La base polynomiale est la base de Jacobi d' ordre -1 */
/*           (Legendre), 0, 1 ou 2 */
/*   MINDGU: Degre minimum en U des coeff. a calculer. */
/*   MAXDGU: Degre maximum en U des coeff. a calculer. */
/*   NBPNTV: Degre du polynome de Legendre sur les racines duquel */
/*           sont calcules les coefficients d' integration suivant V */
/*           par la methode de Gauss. On doit avoir NBPNTV = 30, 40, */
/*           50 ou 61 et NDVJAC < NBPNTV. */
/*   GSSVTB: Table des coefficients d' integration par la methode de */
/*           Gauss suivant V pour NDVJAC fixe: j varie de 0 a NBPNTV/2. */
/*   CHPAIR: Tableau de termes lies aux degres MINDGU a MAXDGU en U pour 
*/
/*           calculer les coeff. de l'approximation de degre PAIR NDVJAC 
*/
/*           en V. */
/*   CHIMPR: Tableau de termes lies aux degres MINDGU a MAXDGU en U pour 
*/
/*           calculer les coeff. de l'approximation de degre IMPAIR */
/*           NDVJAC en V. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*   PATJAC: Table des coefficients en U du polynome d' approximation */
/*           P(u,v) de degre MINDGU a MAXDGU en U et NDVJAC en V. */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     11-06-1991 : RBD ; Creation. */
/* > */
/* ********************************************************************** 
*/
/*   Le nom de la routine */


/* --------------------------- Initialisations -------------------------- 
*/

    /* Parameter adjustments */
    patjac_offset = *mindgu;
    patjac -= patjac_offset;
    chimpr_dim1 = *nbpntv / 2;
    chimpr_offset = chimpr_dim1 * *mindgu + 1;
    chimpr -= chimpr_offset;
    chpair_dim1 = *nbpntv / 2 + 1;
    chpair_offset = chpair_dim1 * *mindgu;
    chpair -= chpair_offset;

    /* Function Body */
    ldbg = mnfndeb_() >= 3;
    if (ldbg) {
	mgenmsg_("MMA2CFV", 7L);
    }
    nptv2 = *nbpntv / 2;

/* --------- Calcul des coefficients pour un degre NDVJAC pair ---------- 
*/

    if (*ndvjac % 2 == 0) {
	i__1 = *maxdgu;
	for (ii = *mindgu; ii <= i__1; ++ii) {
	    bid1 = 0.;
	    i__2 = nptv2;
	    for (jj = 1; jj <= i__2; ++jj) {
		bid1 += chpair[jj + ii * chpair_dim1] * gssvtb[jj];
/* L200: */
	    }
	    patjac[ii] = bid1;
/* L100: */
	}

/* -------- Calcul des coefficients pour un degre NDVJAC impair -----
---- */

    } else {
	i__1 = *maxdgu;
	for (ii = *mindgu; ii <= i__1; ++ii) {
	    bid1 = 0.;
	    i__2 = nptv2;
	    for (jj = 1; jj <= i__2; ++jj) {
		bid1 += chimpr[jj + ii * chimpr_dim1] * gssvtb[jj];
/* L250: */
	    }
	    patjac[ii] = bid1;
/* L150: */
	}
    }

/* ------- Ajout des termes lies a la racine supplementaire (0.D0) ------ 
*/
/* ----------- du polynome de Legendre de degre impair NBPNTV ----------- 
*/

    if (*nbpntv % 2 != 0 && *ndvjac % 2 == 0) {
	bid1 = gssvtb[0];
	i__1 = *maxdgu;
	for (ii = *mindgu; ii <= i__1; ++ii) {
	    patjac[ii] += bid1 * chpair[ii * chpair_dim1];
/* L300: */
	}
    }

/* ------------------------------ The end ------------------------------- 
*/

    if (ldbg) {
	mgsomsg_("MMA2CFV", 7L);
    }
    return 0;
} /* mma2cfv_ */

