// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Sweep_NumShapeIterator_HeaderFile
#define _Sweep_NumShapeIterator_HeaderFile

#ifndef _Sweep_NumShape_HeaderFile
#include <Sweep_NumShape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
class Standard_NoMoreObject;
class Standard_NoSuchObject;
class Sweep_NumShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class provides iteration services required by <br>
//!          the   Swept Primitives  for   a Directing NumShape <br>
//!          Line. <br>
//! <br>
class Sweep_NumShapeIterator  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Sweep_NumShapeIterator();

//! Resest the NumShapeIterator on sub-shapes of <aShape>. <br>
Standard_EXPORT   void Init(const Sweep_NumShape& aShape) ;
//! Returns True if there is a current sub-shape. <br>
//! <br>
  Standard_Boolean More() const;

//! Moves to the next sub-shape. <br>
Standard_EXPORT   void Next() ;
//! Returns the current sub-shape. <br>
 const Sweep_NumShape& Value() const;
//! Returns the orientation of the current sub-shape. <br>
  TopAbs_Orientation Orientation() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Sweep_NumShape myNumShape;
Sweep_NumShape myCurrentNumShape;
Standard_Integer myCurrentRange;
Standard_Boolean myMore;
TopAbs_Orientation myCurrentOrientation;


};


#include <Sweep_NumShapeIterator.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
