// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MeshVS_MeshPrsBuilder_HeaderFile
#define _MeshVS_MeshPrsBuilder_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_MeshVS_MeshPrsBuilder_HeaderFile
#include <Handle_MeshVS_MeshPrsBuilder.hxx>
#endif

#ifndef _MeshVS_PrsBuilder_HeaderFile
#include <MeshVS_PrsBuilder.hxx>
#endif
#ifndef _Handle_MeshVS_Mesh_HeaderFile
#include <Handle_MeshVS_Mesh.hxx>
#endif
#ifndef _MeshVS_DisplayModeFlags_HeaderFile
#include <MeshVS_DisplayModeFlags.hxx>
#endif
#ifndef _Handle_MeshVS_DataSource_HeaderFile
#include <Handle_MeshVS_DataSource.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MeshVS_BuilderPriority_HeaderFile
#include <MeshVS_BuilderPriority.hxx>
#endif
#ifndef _Handle_Prs3d_Presentation_HeaderFile
#include <Handle_Prs3d_Presentation.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Graphic3d_ArrayOfPolylines_HeaderFile
#include <Handle_Graphic3d_ArrayOfPolylines.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Graphic3d_ArrayOfPolygons_HeaderFile
#include <Handle_Graphic3d_ArrayOfPolygons.hxx>
#endif
#ifndef _Handle_MeshVS_HArray1OfSequenceOfInteger_HeaderFile
#include <Handle_MeshVS_HArray1OfSequenceOfInteger.hxx>
#endif
#ifndef _Handle_Graphic3d_ArrayOfPrimitives_HeaderFile
#include <Handle_Graphic3d_ArrayOfPrimitives.hxx>
#endif
#ifndef _Handle_Graphic3d_AspectFillArea3d_HeaderFile
#include <Handle_Graphic3d_AspectFillArea3d.hxx>
#endif
#ifndef _Handle_Graphic3d_AspectLine3d_HeaderFile
#include <Handle_Graphic3d_AspectLine3d.hxx>
#endif
class MeshVS_Mesh;
class MeshVS_DataSource;
class Prs3d_Presentation;
class MeshVS_Array1OfIntegerBoolean;
class TColStd_Array1OfReal;
class Graphic3d_ArrayOfPolylines;
class Graphic3d_ArrayOfPolygons;
class MeshVS_HArray1OfSequenceOfInteger;
class Graphic3d_ArrayOfPrimitives;
class Graphic3d_AspectFillArea3d;
class Graphic3d_AspectLine3d;


//! This class provides methods to compute base mesh presentation <br>
class MeshVS_MeshPrsBuilder : public MeshVS_PrsBuilder {

public:
 // Methods PUBLIC
 // 

//! Creates builder with certain display mode flags, data source, ID and priority <br>
Standard_EXPORT MeshVS_MeshPrsBuilder(const Handle(MeshVS_Mesh)& Parent,const MeshVS_DisplayModeFlags& Flags = MeshVS_DMF_OCCMask,const Handle(MeshVS_DataSource)& DS = 0,const Standard_Integer Id = -1,const MeshVS_BuilderPriority& Priority = MeshVS_BP_Mesh);

//! Builds base mesh presentation by calling the methods below <br>
Standard_EXPORT virtual  void Build(const Handle(Prs3d_Presentation)& Prs,MeshVS_Array1OfIntegerBoolean& IDs,const Standard_Boolean IsElement,const Standard_Integer DisplayMode) const;

//! Builds nodes presentation <br>
Standard_EXPORT virtual  void BuildNodes(const Handle(Prs3d_Presentation)& Prs,MeshVS_Array1OfIntegerBoolean& IDs,const Standard_Integer DisplayMode) const;

//! Builds elements presentation <br>
Standard_EXPORT virtual  void BuildElements(const Handle(Prs3d_Presentation)& Prs,MeshVS_Array1OfIntegerBoolean& IDs,const Standard_Integer DisplayMode) const;

//! Builds presentation of hilighted entity <br>
Standard_EXPORT virtual  void BuildHilightPrs(const Handle(Prs3d_Presentation)& Prs,MeshVS_Array1OfIntegerBoolean& IDs,const Standard_Boolean IsElement) const;

//! Add to array polygons or polylines representing volume <br>
Standard_EXPORT static  void AddVolumePrs(const Handle(MeshVS_HArray1OfSequenceOfInteger)& Topo,const TColStd_Array1OfReal& Nodes,const Standard_Integer NbNodes,const Handle(Graphic3d_ArrayOfPrimitives)& Array,const Standard_Boolean IsReflected,const Standard_Boolean IsShrinked,const Standard_Boolean IsSelect,const Standard_Real ShrinkCoef) ;

//! Calculate how many polygons or polylines are necessary to draw passed topology <br>
Standard_EXPORT static  void HowManyPrimitives(const Handle(MeshVS_HArray1OfSequenceOfInteger)& Topo,const Standard_Boolean AsPolygons,const Standard_Boolean IsSelect,const Standard_Integer NbNodes,Standard_Integer& Vertices,Standard_Integer& Bounds) ;
//Standard_EXPORT ~MeshVS_MeshPrsBuilder();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Default calculation of center of face or link. This method if useful for shrink mode presentation <br>
//! theCoords is array of nodes co-ordinates in the strict order X1, Y1, Z1, X2... <br>
//! NbNodes is number of nodes an element consist of <br>
//! xG, yG, zG are co-ordinates of center whose will be returned <br>
Standard_EXPORT static  void CalculateCenter(const TColStd_Array1OfReal& theCoords,const Standard_Integer NbNodes,Standard_Real& xG,Standard_Real& yG,Standard_Real& zG) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Add to array of polylines some lines representing link <br>
Standard_EXPORT   void AddLinkPrs(const TColStd_Array1OfReal& theCoords,const Handle(Graphic3d_ArrayOfPolylines)& theLines,const Standard_Boolean IsShrinked,const Standard_Real ShrinkCoef) const;

//! Add to array of polylines some lines representing face's wire <br>
Standard_EXPORT   void AddFaceWirePrs(const TColStd_Array1OfReal& theCoords,const Standard_Integer NbNodes,const Handle(Graphic3d_ArrayOfPolylines)& theLines,const Standard_Boolean IsShrinked,const Standard_Real ShrinkCoef) const;

//! Add to array of polygons a polygon representing face <br>
Standard_EXPORT   void AddFaceSolidPrs(const Standard_Integer ID,const TColStd_Array1OfReal& theCoords,const Standard_Integer NbNodes,const Standard_Integer MaxNodes,const Handle(Graphic3d_ArrayOfPolygons)& thePolygons,const Standard_Boolean IsReflected,const Standard_Boolean IsShrinked,const Standard_Real ShrinkCoef,const Standard_Boolean IsMeshSmoothShading) const;

//! Draw array of polygons and polylines in the certain order according to transparency <br>
Standard_EXPORT   void DrawArrays(const Handle(Prs3d_Presentation)& Prs,const Handle(Graphic3d_ArrayOfPolygons)& thePolygons,const Handle(Graphic3d_ArrayOfPolylines)& theLines,const Handle(Graphic3d_ArrayOfPolylines)& theLinkLines,const Handle(Graphic3d_ArrayOfPolygons)& theVolumesInShad,const Standard_Boolean IsPolygonsEdgesOff,const Standard_Boolean IsSelected,const Handle(Graphic3d_AspectFillArea3d)& theFillAsp,const Handle(Graphic3d_AspectLine3d)& theLineAsp) const;


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
