// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GccEnt_HeaderFile
#define _GccEnt_HeaderFile

class GccEnt_QualifiedLin;
class gp_Lin2d;
class GccEnt_QualifiedCirc;
class gp_Circ2d;
class GccEnt_QualifiedLin;
class GccEnt_QualifiedCirc;
class GccEnt_QualifiedCurv;
class GccEnt_Array1OfPosition;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This package provides an implementation of the qualified <br>
//!          entities useful to create 2d entities with geometric <br>
//!          constraints. The qualifier explains which subfamily of <br>
//!          solutions we want to obtain. It uses the following law: the <br>
//!          matter/the interior side is at the left of the line, if we go <br>
//!          from the beginning to the end. <br>
//!          The qualifiers are: <br>
//!            Enclosing   : the solution(s) must enclose the argument. <br>
//!            Enclosed    : the solution(s) must be enclosed in the <br>
//!                          argument. <br>
//!            Outside     : both the solution(s) and the argument must be <br>
//!                          outside to each other. <br>
//!            Unqualified : the position is undefined, so give all the <br>
//!                          solutions. <br>
//!          The use of a qualifier is always required if such <br>
//!          subfamilies exist. For example, it is not used for a point. <br>
//! Note:    the interior of a curve is defined as the left-hand <br>
//!          side of the curve in relation to its orientation. <br>
class GccEnt  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs a qualified line, <br>
//! so that the relative position to the circle or line of the <br>
//! solution computed by a construction algorithm using the <br>
//! qualified circle or line is not qualified, i.e. all solutions apply. <br>
Standard_EXPORT static  GccEnt_QualifiedLin Unqualified(const gp_Lin2d& Obj) ;

//! Constructs a qualified circle <br>
//! so that the relative position to the circle or line of the <br>
//! solution computed by a construction algorithm using the <br>
//! qualified circle or line is not qualified, i.e. all solutions apply. <br>
Standard_EXPORT static  GccEnt_QualifiedCirc Unqualified(const gp_Circ2d& Obj) ;


//! Constructs such a qualified circle that the solution <br>
//! computed by a construction algorithm using the qualified <br>
//! circle encloses the circle. <br>
Standard_EXPORT static  GccEnt_QualifiedCirc Enclosing(const gp_Circ2d& Obj) ;

//! Constructs a qualified line, <br>
//! so that the solution computed by a construction <br>
//! algorithm using the qualified circle or line is enclosed by <br>
//! the circle or line. <br>
Standard_EXPORT static  GccEnt_QualifiedLin Enclosed(const gp_Lin2d& Obj) ;

//! Constructs a qualified circle <br>
//! so that the solution computed by a construction <br>
//! algorithm using the qualified circle or line is enclosed by <br>
//! the circle or line. <br>
Standard_EXPORT static  GccEnt_QualifiedCirc Enclosed(const gp_Circ2d& Obj) ;

//! Constructs a qualified line, <br>
//! so that the solution computed by a construction <br>
//! algorithm using the qualified circle or line and the circle <br>
//! or line are external to one another. <br>
Standard_EXPORT static  GccEnt_QualifiedLin Outside(const gp_Lin2d& Obj) ;

//! Constructs a qualified circle <br>
//! so that the solution computed by a construction <br>
//! algorithm using the qualified circle or line and the circle <br>
//! or line are external to one another. <br>
Standard_EXPORT static  GccEnt_QualifiedCirc Outside(const gp_Circ2d& Obj) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class GccEnt_QualifiedLin;
friend class GccEnt_QualifiedCirc;
friend class GccEnt_QualifiedCurv;
friend class GccEnt_Array1OfPosition;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
