// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Extrema_ExtElC2d_HeaderFile
#define _Extrema_ExtElC2d_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Extrema_POnCurv2d_HeaderFile
#include <Extrema_POnCurv2d.hxx>
#endif
class StdFail_InfiniteSolutions;
class StdFail_NotDone;
class Standard_OutOfRange;
class gp_Lin2d;
class gp_Circ2d;
class gp_Elips2d;
class gp_Hypr2d;
class gp_Parab2d;
class Extrema_POnCurv2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! It calculates all the distance between two elementary <br>
//!          curves. <br>
//!          These distances can be maximum or minimum. <br>
class Extrema_ExtElC2d  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Extrema_ExtElC2d();

//! Calculates the distance between two lines. <br>
//!          AngTol is used to test if the lines are parallel: <br>
//!          Angle(C1,C2) < AngTol. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Lin2d& C1,const gp_Lin2d& C2,const Standard_Real AngTol);

//! Calculates the distance between a line and a <br>
//!          circle. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Lin2d& C1,const gp_Circ2d& C2,const Standard_Real Tol);

//! Calculates the distance between a line and an <br>
//!          elipse. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Lin2d& C1,const gp_Elips2d& C2);

//! Calculates the distance between a line and a <br>
//!          hyperbola. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Lin2d& C1,const gp_Hypr2d& C2);

//! Calculates the distance between a line and a <br>
//!          parabola. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Lin2d& C1,const gp_Parab2d& C2);

//! Calculates the distance between two circles. <br>
//!          The circles can be parallel or identical. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Circ2d& C1,const gp_Circ2d& C2);

//! Calculates the distance between a circle and an <br>
//!          elipse. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Circ2d& C1,const gp_Elips2d& C2);

//! Calculates the distance between a circle and a <br>
//!          hyperbola. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Circ2d& C1,const gp_Hypr2d& C2);

//! Calculates the distance between a circle and a <br>
//!          parabola. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Circ2d& C1,const gp_Parab2d& C2);

//! Calculates the distance between two elipses. <br>
//!          The elipses can be parallel or identical. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Elips2d& C1,const gp_Elips2d& C2);

//! Calculates the distance between an elipse and a <br>
//!          hyperbola. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Elips2d& C1,const gp_Hypr2d& C2);

//! Calculates the distance between an elipse and a <br>
//!          parabola. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Elips2d& C1,const gp_Parab2d& C2);

//! Calculates the distance between two hyperbolas. <br>
//!          The hyperbolas can be parallel or identical. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Hypr2d& C1,const gp_Hypr2d& C2);

//! Calculates the distance between a hyperbola and a <br>
//!          parabola. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Hypr2d& C1,const gp_Parab2d& C2);

//! Calculates the distance between two parabolas <br>
//!          The parabolas can be parallel or identical. <br>
Standard_EXPORT Extrema_ExtElC2d(const gp_Parab2d& C1,const gp_Parab2d& C2);

//! Returns True if the distances are found. <br>
Standard_EXPORT   Standard_Boolean IsDone() const;

//! Returns True if the two curves are parallel. <br>
Standard_EXPORT   Standard_Boolean IsParallel() const;

//! Returns the number of extremum distances. <br>
Standard_EXPORT   Standard_Integer NbExt() const;

//! Returns the value of the Nth extremum distance. <br>
Standard_EXPORT   Standard_Real Value(const Standard_Integer N = 1) const;

//! Returns the points of the Nth extremum distance. <br>
//!          P1 is on the first curve, P2 on the second one. <br>
Standard_EXPORT   void Points(const Standard_Integer N,Extrema_POnCurv2d& P1,Extrema_POnCurv2d& P2) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myDone;
Standard_Boolean myIsPar;
Standard_Integer myNbExt;
Standard_Real myValue[4];
Extrema_POnCurv2d myPoint[4][2];


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
