// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepPrimAPI_MakeSphere_HeaderFile
#define _BRepPrimAPI_MakeSphere_HeaderFile

#ifndef _BRepPrim_Sphere_HeaderFile
#include <BRepPrim_Sphere.hxx>
#endif
#ifndef _BRepPrimAPI_MakeOneAxis_HeaderFile
#include <BRepPrimAPI_MakeOneAxis.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
class Standard_DomainError;
class gp_Pnt;
class gp_Ax2;
class BRepPrim_Sphere;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions to build spheres or portions of spheres. <br>
//! A MakeSphere object provides a framework for: <br>
//! -   defining the construction of a sphere, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the result. <br>
class BRepPrimAPI_MakeSphere  : public BRepPrimAPI_MakeOneAxis {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Make a sphere of radius R. <br>
Standard_EXPORT BRepPrimAPI_MakeSphere(const Standard_Real R);

//! Make a sphere of radius R. <br>
Standard_EXPORT BRepPrimAPI_MakeSphere(const Standard_Real R,const Standard_Real angle);

//! Make a sphere of radius R. <br>
Standard_EXPORT BRepPrimAPI_MakeSphere(const Standard_Real R,const Standard_Real angle1,const Standard_Real angle2);

//! Make a sphere of radius R. <br>
Standard_EXPORT BRepPrimAPI_MakeSphere(const Standard_Real R,const Standard_Real angle1,const Standard_Real angle2,const Standard_Real angle3);

//! Make a sphere of radius R. <br>
Standard_EXPORT BRepPrimAPI_MakeSphere(const gp_Pnt& Center,const Standard_Real R);

//! Make a sphere of radius R. <br>
Standard_EXPORT BRepPrimAPI_MakeSphere(const gp_Pnt& Center,const Standard_Real R,const Standard_Real angle);

//! Make a sphere of radius R. <br>
Standard_EXPORT BRepPrimAPI_MakeSphere(const gp_Pnt& Center,const Standard_Real R,const Standard_Real angle1,const Standard_Real angle2);

//! Make a sphere of radius R. <br>
Standard_EXPORT BRepPrimAPI_MakeSphere(const gp_Pnt& Center,const Standard_Real R,const Standard_Real angle1,const Standard_Real angle2,const Standard_Real angle3);

//! Make a sphere of radius R. <br>
Standard_EXPORT BRepPrimAPI_MakeSphere(const gp_Ax2& Axis,const Standard_Real R);

//! Make a sphere of radius R. <br>
Standard_EXPORT BRepPrimAPI_MakeSphere(const gp_Ax2& Axis,const Standard_Real R,const Standard_Real angle);

//! Make a sphere of radius R. <br>
Standard_EXPORT BRepPrimAPI_MakeSphere(const gp_Ax2& Axis,const Standard_Real R,const Standard_Real angle1,const Standard_Real angle2);

//! Make a sphere of radius R. <br>//! For all algorithms The resulting shape is composed of <br>
//! -   a lateral spherical face, <br>
//! -   two planar faces parallel to the plane z = 0 if the <br>
//!   sphere is truncated in the v parametric direction, or <br>
//!   only one planar face if angle1 is equal to -p/2 or if <br>
//!     angle2 is equal to p/2 (these faces are circles in <br>
//!   case of a complete truncated sphere), <br>
//! -   and in case of a portion of sphere, two planar faces <br>
//!   to shut the shape.(in the planes u = 0 and u = angle). <br>
Standard_EXPORT BRepPrimAPI_MakeSphere(const gp_Ax2& Axis,const Standard_Real R,const Standard_Real angle1,const Standard_Real angle2,const Standard_Real angle3);

//! Returns the algorithm. <br>
Standard_EXPORT   Standard_Address OneAxis() ;

//! Returns the algorithm. <br>
//! <br>
Standard_EXPORT   BRepPrim_Sphere& Sphere() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRepPrim_Sphere mySphere;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
