// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepFeat_MakeRevol_HeaderFile
#define _BRepFeat_MakeRevol_HeaderFile

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeListOfShape_HeaderFile
#include <TopTools_DataMapOfShapeListOfShape.hxx>
#endif
#ifndef _gp_Ax1_HeaderFile
#include <gp_Ax1.hxx>
#endif
#ifndef _TColGeom_SequenceOfCurve_HeaderFile
#include <TColGeom_SequenceOfCurve.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _BRepFeat_StatusError_HeaderFile
#include <BRepFeat_StatusError.hxx>
#endif
#ifndef _BRepFeat_Form_HeaderFile
#include <BRepFeat_Form.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Geom_Curve;
class Standard_ConstructionError;
class TopoDS_Shape;
class TopoDS_Face;
class gp_Ax1;
class TopoDS_Edge;
class TColGeom_SequenceOfCurve;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions to build revolved shells from basis shapes. <br>
class BRepFeat_MakeRevol  : public BRepFeat_Form {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! initializes the revolved shell class. <br>
BRepFeat_MakeRevol();
//! a face Pbase is selected in the <br>
//!   shape Sbase to serve as the basis for the <br>
//!   revolved shell. The revolution will be defined <br>
//!   by the axis Axis and Fuse offers a choice between: <br>
//!   -   removing matter with a Boolean cut using the setting 0 <br>
//!   -   adding matter with Boolean fusion using the setting 1. <br>
//!     The sketch face Skface serves to determine <br>
//! the type of operation. If it is inside the basis <br>
//! shape, a local operation such as glueing can be performed. <br>
BRepFeat_MakeRevol(const TopoDS_Shape& Sbase,const TopoDS_Shape& Pbase,const TopoDS_Face& Skface,const gp_Ax1& Axis,const Standard_Integer Fuse,const Standard_Boolean Modify);


Standard_EXPORT   void Init(const TopoDS_Shape& Sbase,const TopoDS_Shape& Pbase,const TopoDS_Face& Skface,const gp_Ax1& Axis,const Standard_Integer Fuse,const Standard_Boolean Modify) ;

//! Indicates that the edge <E> will slide on the face <br>
//! <OnFace>. Raises ConstructionError if the  face does not belong to the <br>
//! basis shape, or the edge to the prismed shape. <br>
Standard_EXPORT   void Add(const TopoDS_Edge& E,const TopoDS_Face& OnFace) ;


Standard_EXPORT   void Perform(const Standard_Real Angle) ;


Standard_EXPORT   void Perform(const TopoDS_Shape& Until) ;

//! Reconstructs the feature topologically. <br>
Standard_EXPORT   void Perform(const TopoDS_Shape& From,const TopoDS_Shape& Until) ;

//! Builds an infinite shell. The infinite descendants <br>
//! will not be kept in the result. <br>
Standard_EXPORT   void PerformThruAll() ;

//! Assigns both a limiting shape, Until from <br>
//! TopoDS_Shape, and an angle, Angle at <br>
//! which to stop generation of the revolved shell feature. <br>
Standard_EXPORT   void PerformUntilAngle(const TopoDS_Shape& Until,const Standard_Real Angle) ;


Standard_EXPORT   void Curves(TColGeom_SequenceOfCurve& S) ;


Standard_EXPORT   Handle_Geom_Curve BarycCurve() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Shape myPbase;
TopTools_DataMapOfShapeListOfShape mySlface;
gp_Ax1 myAxis;
TColGeom_SequenceOfCurve myCurves;
Handle_Geom_Curve myBCurve;
BRepFeat_StatusError myStatusError;


};


#include <BRepFeat_MakeRevol.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
