#line 1 "cfunc.mod"
#include "cm.h"
#line 1 "cfunc.mod"
/* $Id: cfunc.mod,v 1.4 2005/08/23 08:21:02 pnenzi Exp $ */


#define TS 0
#define VS 1


void ucm_real_to_v (Mif_Private_t *private)
{

    double *t, *v;
    double *in;

    /*double out;*/


    in = private->conn[0]->port[0]->input.pvalue;

    if(private->circuit.init) {
        t = (void *) cm_event_alloc(TS, 2 * sizeof(double));
        v = (void *) cm_event_alloc(VS, 2 * sizeof(double));
        t = (void *) cm_event_get_ptr(TS, 0);
        v = (void *) cm_event_get_ptr(VS, 0);
        t[0] = -2.0;
        t[1] = -1.0;
        v[0] = *in;
        v[1] = *in;
    }
    else {
        t = (void *) cm_event_get_ptr(TS, 0);
        v = (void *) cm_event_get_ptr(VS, 0);
    }

    switch(private->circuit.call_type) {

    case ANALOG:
        if(private->circuit.time == 0.0) {
            private->conn[1]->port[0]->output.rvalue = *in;
            v[0] = *in;
            v[1] = *in;
        }
        else {
            if(private->circuit.time <= t[0])
                private->conn[1]->port[0]->output.rvalue = v[0];
            else if(private->circuit.time >= t[1])
                private->conn[1]->port[0]->output.rvalue = v[1];
            else {
                private->conn[1]->port[0]->output.rvalue = v[0] + (v[1] - v[0]) *
                                (private->circuit.time - t[0]) / (t[1] - t[0]);
            }
        }
        break;

    case EVENT:
        if(private->circuit.time == 0.0)
            return;
        if(private->circuit.time >= t[1]) {
            v[0] = v[1];
            v[1] = *in;
            t[0] = private->circuit.time;
            t[1] = private->circuit.time + private->param[1]->element[0].rvalue;
        }
        else {
            v[0] = v[0] + (v[1] - v[0]) *
                                (private->circuit.time - t[0]) / (t[1] - t[0]);
            v[1] = *in;
            t[0] = private->circuit.time;
            t[1] = private->circuit.time + private->param[1]->element[0].rvalue;
        }
        break;

    }
}




