#!/bin/bash

function failure {
	echo $1
	rm -f marscore.o 
	exit 3
}

#declare -a dp_dsp_isr_sym
dp_dsp_isr_sym=(`nm -S ltmdmobj.o | grep dp_dsp_isr`)

#echo ${dp_dsp_isr_sym[0]} ${dp_dsp_isr_sym[1]}

dp_dsp_isr_start=$(( 0x${dp_dsp_isr_sym[0]} ))
dp_dsp_isr_stop=$(( 0x${dp_dsp_isr_sym[0]} + 0x${dp_dsp_isr_sym[1]} ))

#echo $dp_dsp_isr_start $dp_dsp_isr_stop

set -o pipefail
relentries=(`
	objdump --start-address=$dp_dsp_isr_start \
		--stop-address=$dp_dsp_isr_stop \
		--reloc \
		ltmdmobj.o \
	|
	awk 'BEGIN { 
		syms[0] = "dp_int_regread"; 
		syms[1] = "dp_int_regwrite"; 
		syms[2] = "Write_mdm_word"; 
		count = 0 
		}
		{ 
			if ($3 == syms[count]) { 
				print $1; count++; 
				if (count == 3) exit; 
			} 
		}'
	`) \
	|| failure "search symbols failure"


# entries pattern
# (dp_int_regread dp_int_regwrite Write_mdm_word) = $relocation_entries
#

./elf386tweakrelocs $1 \
	0x${relentries[0]}=mars_read_reg_subst \
	0x${relentries[1]}=mars_stub \
	0x${relentries[2]}=mars_stub || failure "tweakrelocs failure"
	

