# $Id: Navigation.pm,v 1.10 2011-06-17 15:14:34 sb23 Exp $

package EnsEMBL::Web::Document::Element::Navigation;

# Generates the left sided navigation menu, used in dynamic pages

use strict;

use HTML::Entities qw(encode_entities);

use base qw(EnsEMBL::Web::Document::Element);

sub new {
  return shift->SUPER::new({
    %{$_[0]},
    tree    => undef,
    active  => undef,
    caption => 'Local context',
    counts  => {}
  });
}

sub tree {
  my $self = shift;
  $self->{'tree'} = shift if @_;
  return $self->{'tree'};
}

sub active {
  my $self = shift;
  $self->{'active'} = shift if @_;
  return $self->{'active'};
}

sub caption {
  my $self = shift;
  $self->{'caption'} = shift if @_;
  return $self->{'caption'};
}

sub counts {
  my $self = shift;
  $self->{'counts'} = shift if @_;
  return $self->{'counts'} || {};
}

sub configuration {
  my $self = shift;
  $self->{'configuration'} = shift if @_;
  return $self->{'configuration'};
}

sub availability {
  my $self = shift;
  $self->{'availability'} = shift if @_;
  $self->{'availability'} ||= {};
  return $self->{'availability'};
}

sub get_json {
  my $self = shift;
  return { nav => $self->content };
}

sub init {
  my $self          = shift;
  my $controller    = shift;    
  my $object        = $controller->object;
  my $hub           = $controller->hub;
  my $configuration = $controller->configuration;
  my $action        = $configuration->get_valid_action($hub->action, $hub->function);
 
  $self->tree($configuration->{'_data'}{'tree'});
  $self->active($action);
  $self->caption(ref $object ? $object->short_caption : $configuration->short_caption);
  $self->counts($object->counts) if ref $object;
  $self->availability(ref $object ? $object->availability : {});     
  
  $self->{'hub'} = $hub;
}

sub content {
  my $self = shift;
  my $tree = $self->tree;
  
  return unless $tree;
  
  my $active = $self->active;
  my @nodes  = grep { $_->can('data') && !$_->data->{'no_menu_entry'} && $_->data->{'caption'} } @{$tree->child_nodes};
  my $menu;
  
  if ($tree->get_node($active) || $nodes[0]) {
    my $hub        = $self->{'hub'};
    my $img_url    = $hub->species_defs->img_url;
    my $counts     = $self->counts;
    my $all_params = !!$hub->object_types->{$hub->type};
    
    $self->build_menu($_, $hub, $img_url, $counts, $all_params, $active, $nodes[-1]) for @nodes;
    
    $menu .= $_->render for @nodes;
  }
  
  return sprintf('
    %s
    <div class="header">%s</div>
    <ul class="local_context">%s</ul>',
    $self->configuration ? '' : '<input type="hidden" class="panel_type" value="LocalContext" />',
    encode_entities($self->strip_HTML($self->caption)),
    $menu
  );
}

sub build_menu {
  my ($self, $node, $hub, $img_url, $counts, $all_params, $active, $last_child) = @_;
  
  my $data = $node->data;
  
  return if $data->{'no_menu_entry'} || !$data->{'caption'};
  
  my @children     = grep { $_->can('data') && !$_->data->{'no_menu_entry'} && $_->data->{'caption'} } @{$node->child_nodes};
  my $caption      = $data->{'caption'};
  my $title        = $data->{'full_caption'} || $caption;
  my $count        = $data->{'count'};
  my $availability = $data->{'availability'};
  my @append       = ([ 'img', scalar @children ? { src => "${img_url}open.gif", class => 'toggle' } : { src => "${img_url}leaf.gif" }]);
  
  if ($availability && $self->is_available($availability)) {
    # $node->data->{'code'} contains action and function where required, so setting function to undef is fine.
    # If function is NOT set to undef and you are on a page with a function, the generated url could be wrong
    # e.g. on Location/Compara_Alignments/Image the url for Alignments (Text) will also be Location/Compara_Alignments/Image, rather than Location/Compara_Alignments
    my $url   = $data->{'url'} || $hub->url({ action => $data->{'code'}, function => undef }, undef, $all_params);
    my $class = $data->{'class'};
    my $rel   = $data->{'external'} ? 'external' : $data->{'rel'};
    
    for ($title, $caption) {
      s/\[\[counts::(\w+)\]\]/$counts->{$1}||0/eg;
      $_ = encode_entities($_);
    }
    
    push @append, [ 'a',    { class => $class,  inner_HTML => $caption, href => $url, title => $title, rel => $rel }];
    push @append, [ 'span', { class => 'count', inner_HTML => $count }] if $count;
  } else {
    $caption =~ s/\(\[\[counts::(\w+)\]\]\)//eg;
    push @append, [ 'span', { class => 'disabled', title => $data->{'disabled'}, inner_HTML => $caption }];
  }
  
  if (scalar @children) {
    my $ul = $node->dom->create_element('ul');
    
    foreach (@children) {
      $self->build_menu($_, $hub, $img_url, $counts, $all_params, $active, $children[-1]);
      $ul->append_child($_);
    }
    
    push @append, $ul;
  }
  
  $node->node_name = 'li';
  $node->set_attributes({ id => $data->{'id'}, class => ($node->id eq $active ? 'active' : '') . ($node eq $last_child ? ' last' : '') });
  $node->append_children(@append);
}

1;
