/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.ClustalwThread;
import jalview.CommandThread;
import jalview.ConsThread;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;

public class ProgressPanel
extends Panel
implements Runnable {
    Thread ct = null;
    Object parent;
    long tstart;
    long tend;
    GridBagLayout gb;
    GridBagConstraints gbc;
    Button cancel;
    Label status;
    Label time;

    public ProgressPanel(Object object, Thread thread) {
        this.ct = thread;
        this.parent = object;
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.setLayout(this.gb);
        this.status = new Label("Status: Process stopped", 0);
        this.time = new Label("Time elapsed = ", 0);
        this.cancel = new Button("Cancel");
        this.gbc.insets = new Insets(10, 10, 0, 0);
        this.gbc.fill = 13;
        this.add(this.status, this.gb, this.gbc, 0, 0, 1, 1);
        this.add(this.time, this.gb, this.gbc, 0, 1, 1, 1);
        this.gbc.fill = 0;
        this.add(this.cancel, this.gb, this.gbc, 0, 2, 1, 1);
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 200);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void run() {
        this.tstart = System.currentTimeMillis();
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            if (this.ct != null && this.ct.isAlive()) {
                bl2 = true;
                this.tend = System.currentTimeMillis();
                this.status.setText("Process running");
                this.time.setText("Time elapsed = " + (this.tend - this.tstart) / 1000L + " seconds");
            } else if (bl2) {
                bl = true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Interrupted Exception : " + interruptedException);
            }
        }
        this.tend = System.currentTimeMillis();
        this.status.setText("Process finished");
        if (bl && this.ct instanceof ClustalwThread) {
            this.viewOutput();
        }
        this.time.setText("Total time taken = " + (this.tend - this.tstart) / 1000L + " seconds");
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.cancel && event.id == 1001) {
            if (this.ct != null && this.ct.isAlive()) {
                if (this.ct instanceof CommandThread) {
                    CommandThread commandThread = (CommandThread)this.ct;
                    System.out.println("Destroying process");
                    commandThread.p.destroy();
                }
                this.ct.stop();
                this.ct = null;
                this.status.setText("Status: Process stopped");
            } else {
                this.status.setText("No process running");
            }
        }
        return super.handleEvent(event);
    }

    public void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    public void viewOutput() {
        if (this.ct instanceof ClustalwThread) {
            Object object;
            AlignFrame alignFrame = new AlignFrame(this.parent, ((ClustalwThread)this.ct).outFile, "File", "CLUSTAL");
            if (this.parent instanceof AlignFrame) {
                object = (AlignFrame)this.parent;
                Font font = ((AlignFrame)object).getAlignFont();
                alignFrame.setAlignFont(font.getName(), font.getStyle(), font.getSize());
            }
            alignFrame.resize(700, 500);
            alignFrame.show();
            object = new ConsThread(alignFrame);
            ((Thread)object).start();
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Testy");
        ClustalwThread clustalwThread = new ClustalwThread("pog.msf", "pog.aln");
        ProgressPanel progressPanel = new ProgressPanel(frame, clustalwThread);
        Thread thread = new Thread(progressPanel);
        thread.start();
        frame.add(progressPanel);
        frame.resize(350, 150);
        frame.show();
        clustalwThread.start();
    }
}

