/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.AlignmentPanel;
import jalview.FileParse;
import jalview.Format;
import jalview.PostalColourScheme;
import jalview.Sequence;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class PostalFile
extends FileParse {
    Vector scores = new Vector();
    Vector seqs = new Vector();

    public PostalFile(String string) {
        this.readLines(string);
        System.out.println(this.noLines);
        System.out.println(this.lineArray.size());
        this.parse();
    }

    public PostalFile(String string, String string2) throws IOException {
        super(string, string2);
        System.out.print("Reading file....");
        this.readLines();
        System.out.println("done");
        System.out.println("Parsing file....");
        this.parse();
    }

    public void parse() {
        int n = 0;
        n = 0;
        while (n < this.noLines) {
            String string = this.lineArray.elementAt(n).toString();
            if (string.indexOf(" ") != 0) {
                Object object;
                String string2;
                StringTokenizer stringTokenizer = new StringTokenizer(string.toString(), " ");
                if (string.indexOf("#") == 0) {
                    string2 = "";
                    if (stringTokenizer.countTokens() == 3) {
                        string2 = stringTokenizer.nextToken();
                        string2 = stringTokenizer.nextToken();
                        if (string2.indexOf("_acc") >= 0) {
                            string2 = string2.substring(0, string2.indexOf("_acc"));
                        }
                        if (!string2.equals("Consensus")) {
                            String string3 = stringTokenizer.nextToken();
                            char[] cArray = string3.toCharArray();
                            object = new Vector();
                            int n2 = 0;
                            while (n2 < cArray.length) {
                                if (cArray[n2] == '.') {
                                    ((Vector)object).addElement(new Double(10.0));
                                } else {
                                    ((Vector)object).addElement(new Double(Character.getNumericValue(cArray[n2])));
                                }
                                ++n2;
                            }
                            this.scores.addElement(object);
                        }
                    }
                } else if (string.indexOf(" ") != 0) {
                    string2 = stringTokenizer.nextToken();
                    int n3 = -1;
                    int n4 = -1;
                    if (string2.indexOf("/") > 0 && ((StringTokenizer)(object = new StringTokenizer(string2, "/"))).countTokens() == 2) {
                        string2 = ((StringTokenizer)object).nextToken();
                        string = ((StringTokenizer)object).nextToken();
                        if (((StringTokenizer)(object = new StringTokenizer(string, "-"))).countTokens() == 2) {
                            n3 = Integer.valueOf(((StringTokenizer)object).nextToken());
                            n4 = Integer.valueOf(((StringTokenizer)object).nextToken());
                        } else {
                            n3 = -1;
                            n4 = -1;
                        }
                    }
                    object = stringTokenizer.nextToken();
                    if (n3 != -1 && n4 != -1) {
                        Sequence sequence = new Sequence(string2, (String)object, n3, n4);
                        this.seqs.addElement(sequence);
                    } else {
                        Sequence sequence = new Sequence(string2, (String)object, 1, ((String)object).length());
                        this.seqs.addElement(sequence);
                    }
                }
            }
            ++n;
        }
        this.addScores();
    }

    public static String print(Sequence[] sequenceArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < sequenceArray.length && sequenceArray[n3] != null) {
            String string = sequenceArray[n3].getName() + "/" + sequenceArray[n3].start + "-" + sequenceArray[n3].end;
            if (sequenceArray[n3].getSequence().length() > n) {
                n = sequenceArray[n3].getSequence().length();
            }
            if (string.length() > n2) {
                n2 = string.length();
            }
            ++n3;
        }
        if ((n2 += 5) < 15) {
            n2 = 15;
        }
        int n4 = 0;
        while (n4 < sequenceArray.length && sequenceArray[n4] != null) {
            stringBuffer.append(new Format("%-" + n2 + "s").form(sequenceArray[n4].getName() + "/" + sequenceArray[n4].start + "-" + sequenceArray[n4].end) + " ");
            stringBuffer.append(sequenceArray[n4].getSequence() + "\n");
            stringBuffer.append(new Format("%-" + n2 + "s").form("#=GC " + sequenceArray[n4].getName() + "_acc") + " ");
            int n5 = 0;
            while (n5 < sequenceArray[n4].score[0].size()) {
                if (((Double)sequenceArray[n4].score[0].elementAt(n5)).intValue() == 10) {
                    stringBuffer.append(".");
                } else {
                    int n6 = ((Double)sequenceArray[n4].score[0].elementAt(n5)).intValue();
                    stringBuffer.append(n6);
                }
                ++n5;
            }
            stringBuffer.append("\n");
            ++n4;
        }
        return stringBuffer.toString();
    }

    public void addScores() {
        System.out.println("Adding scores");
        int n = 0;
        while (n < this.seqs.size()) {
            Sequence sequence = (Sequence)this.seqs.elementAt(n);
            if (n < this.scores.size() && sequence != null && this.scores.elementAt(n) != null) {
                System.out.println("Adding scores for " + sequence.name + " " + ((Vector)this.scores.elementAt(n)).size());
                sequence.score[0] = (Vector)this.scores.elementAt(n);
            }
            ++n;
        }
    }

    public static void setColours(AlignmentPanel alignmentPanel) {
        PostalColourScheme postalColourScheme = new PostalColourScheme();
        alignmentPanel.setSequenceColor(postalColourScheme);
    }

    public static void main(String[] stringArray) {
        AlignFrame alignFrame = new AlignFrame(null, stringArray[0], "File", "POSTAL");
        alignFrame.resize(700, 500);
        alignFrame.show();
        try {
            PostalFile postalFile = new PostalFile(stringArray[0], "File");
            PostalFile.setColours(alignFrame.ap);
            alignFrame.updateFont();
            alignFrame.updateFont();
        }
        catch (IOException iOException) {}
    }
}

