/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.DrawableSequence;
import jalview.PCA;
import jalview.PCAFrame;
import jalview.PCAPanel;
import jalview.ProgressBar;
import java.awt.BorderLayout;

public class PCAThread
extends Thread {
    DrawableSequence[] s;
    Object parent;
    PCA pca;
    PCAPanel p;
    boolean calculated = false;
    ProgressBar pb;

    public PCAThread(Object object, DrawableSequence[] drawableSequenceArray) {
        this.s = drawableSequenceArray;
        this.parent = object;
    }

    public void run() {
        if (this.parent instanceof AlignFrame && this.pb != null) {
            ((AlignFrame)this.parent).labelPanel.add(this.pb);
            this.pb.validate();
        }
        this.pca = new PCA(this.s, this.pb);
        this.pca.run();
        this.calculated = true;
        if (this.parent instanceof AlignFrame) {
            ((AlignFrame)this.parent).status.setText("Finished PCA calculation");
            ((AlignFrame)this.parent).status.validate();
        }
        int n = 0;
        while (n < this.s.length && this.s[n] != null) {
            ++n;
        }
        double[][] dArray = new double[n][n];
        int n2 = 0;
        while (n2 < n) {
            if (this.pca.eigenvector.d[n2] > 1.0E-4) {
                dArray[n2] = this.pca.component(n2);
            }
            ++n2;
        }
        PCAFrame pCAFrame = new PCAFrame("PCA results", this.parent);
        pCAFrame.setLayout(new BorderLayout());
        this.p = new PCAPanel(this.parent, this.pca, this.s);
        pCAFrame.add("Center", this.p);
        pCAFrame.resize(400, 400);
        pCAFrame.show();
    }
}

